/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.GameImpl;
import com.ea.game.IInputListener;
import com.ea.game.IStringConstants;
import com.ea.game.Map;
import com.ea.game.SpriteConstants;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class Menu
implements Constants,
IStringConstants,
IInputListener,
SpriteConstants,
Constants.MenuConstants {
    public int menuIndex;
    public int menuState;
    public SDKString titleStr = null;
    public SDKString textStr = null;
    public int textDisplay = -1;
    public boolean transitionAnimation;
    public boolean transitionOpen;
    public int transitionState;
    public int transitionPos;
    public boolean transitionFinished;
    public byte[] menuIndexPositions;
    public byte[] stack;
    public int stackPos;
    public int startListPos = 0;
    public int selectedObjective = 0;
    public int numShownObjectives = 0;
    public int numVisibleObjectives = 0;
    public int numShownAchievements = 0;
    public int numVisibleAchievements = 0;
    public int confirmationYesState = -1;
    public int confirmationNoState = -1;
    public int levelToStart = 0;
    public int menuSelectionOffsetIndex = 0;
    public int mainMenuSpaceBetweenItems = 0;
    public static int[] MAIN_MENU_ITEMS;
    public static int[] PAUSE_MENU_ITEMS;
    public static int[] OPTIONS_MENU_ITEMS;
    public static boolean isContinueEnabled;
    public static boolean skipMoreGames;
    public static int numMainMenuItems;
    public static int soundStartTimer;

    public boolean diplayTextState(int n, int n2) {
        SDKString sDKString = this.titleStr = n != -1 ? SDKUtils.getString(n, this.titleStr) : null;
        if (n2 != -1) {
            GameImpl.string = SDKUtils.getString(n2, GameImpl.string);
            if (n2 == 204) {
                String string = SDKMIDlet.getAppProp("MIDlet-Version");
                this.textStr = GameImpl.string.replaceFirst(string);
            } else {
                this.textStr = SDKUtils.getString(n2, this.textStr);
            }
            SDKUtils.setFont(GameImpl.fonts[0]);
            GameImpl.wrapOffsets = SDKUtils.wrapString(this.textStr, GameImpl.wrapOffsets, 290, (short)124);
        } else {
            this.textStr = null;
        }
        return this.goToState(7);
    }

    public boolean goToState(int n) {
        if (++this.stackPos > 7) {
            this.stackPos = 7;
            return false;
        }
        this.menuIndexPositions[this.menuState] = (byte)this.menuIndex;
        this.stack[this.stackPos] = (byte)this.menuState;
        this.setMenuStateWithAnimation(n);
        this.startListPos = 0;
        return true;
    }

    public void goToConfirmNewLevelState(int n, int n2) {
        this.textDisplay = n;
        if (n2 == 4 || n2 == 6 || n2 == 8) {
            --n2;
        }
        this.levelToStart = n2;
        GameImpl.setState(8);
    }

    public boolean goBackState() {
        if (this.stackPos < 0) {
            this.stackPos = 0;
            this.menuIndexPositions[this.menuState] = 0;
            this.setMenuStateWithAnimation(1);
            return false;
        }
        this.menuIndexPositions[this.menuState] = (byte)this.menuIndex;
        this.setMenuStateWithAnimation(this.stack[this.stackPos]);
        --this.stackPos;
        return true;
    }

    public Menu(int n) {
        this.menuState = n;
        this.stack = new byte[8];
        this.stackPos = 0;
        this.menuIndexPositions = new byte[9];
        this.transitionAnimation = false;
        this.transitionOpen = false;
        this.transitionPos = 0;
        this.transitionFinished = false;
    }

    public void startNewLevel(int n) {
        for (int i = 0; i < GameImpl.achievementCount; ++i) {
            GameImpl.continueAchievementCompleted[i] = false;
        }
        GameImpl.hideTarget = false;
        GameImpl.deleteLevelSave();
        GameImpl.raceTime = -1;
        GameImpl.saveDataPart = null;
        this.stackPos = 0;
        GameImpl.continueNextLevel = GameImpl.currentLevel = n;
        GameImpl.storeCompletedAchievements();
        GameImpl.changeGameMode((byte)GameImpl.levels[GameImpl.currentLevel][3], false, false);
        SDKCanvas.disableInput(1);
    }

    public void clickMainMenu() {
        switch (MAIN_MENU_ITEMS[this.menuIndex]) {
            case 5: {
                if (!isContinueEnabled) {
                    for (int i = 0; i < GameImpl.achievementCount; ++i) {
                        GameImpl.continueAchievementCompleted[i] = false;
                    }
                    GameImpl.saveAchievements();
                    this.startNewLevel(0);
                    break;
                }
                this.goToConfirmNewLevelState(137, 0);
                break;
            }
            case 11: {
                this.stackPos = 0;
                if (GameImpl.continueNextLevel != -1) {
                    this.startNewLevel(GameImpl.continueNextLevel);
                } else {
                    GameImpl.changeGameMode((byte)GameImpl.levels[GameImpl.currentLevel][3], false, false);
                }
                SDKCanvas.disableInput(1);
                break;
            }
            case 119: {
                this.goToState(6);
                break;
            }
            case 13: {
                this.goToState(3);
                break;
            }
            case 17: {
                this.goToState(4);
                break;
            }
            case 46: {
                this.goToState(5);
                break;
            }
            case 6: {
                GameImpl.setState(3);
                break;
            }
            case 203: {
                this.diplayTextState(203, 205);
                break;
            }
            case 202: {
                this.diplayTextState(202, 204);
            }
        }
    }

    public void mainMenuMove(boolean bl, int n) {
        if (bl) {
            this.menuSelectionOffsetIndex += this.mainMenuSpaceBetweenItems;
            do {
                if (--this.menuIndex >= 0) continue;
                this.menuIndex = n - 1;
                this.menuSelectionOffsetIndex = 0;
            } while (!isContinueEnabled && MAIN_MENU_ITEMS[this.menuIndex] == 11 || skipMoreGames && MAIN_MENU_ITEMS[this.menuIndex] == 6);
        } else {
            this.menuSelectionOffsetIndex -= this.mainMenuSpaceBetweenItems;
            do {
                if (++this.menuIndex <= n - 1) continue;
                this.menuIndex = 0;
                this.menuSelectionOffsetIndex = 0;
            } while (!isContinueEnabled && MAIN_MENU_ITEMS[this.menuIndex] == 11 || skipMoreGames && MAIN_MENU_ITEMS[this.menuIndex] == 6);
        }
    }

    public void goToConfirmationState(int n, int n2, int n3) {
        this.confirmationYesState = n;
        this.confirmationNoState = n2;
        this.textDisplay = n3;
        this.goToState(8);
    }

    public void clickPauseMenu() {
        switch (PAUSE_MENU_ITEMS[this.menuIndex]) {
            case 11: {
                SDKCanvas.disableInput(1);
                byte by = GameImpl.savedPlayState;
                GameImpl.setState(1);
                GameImpl.fadeInToPlayState(by);
                break;
            }
            case 316: {
                this.goToConfirmNewLevelState(315, GameImpl.currentLevel);
                break;
            }
            case 13: {
                this.goToState(3);
                break;
            }
            case 17: {
                this.goToState(4);
                break;
            }
            case 46: {
                this.goToState(5);
                break;
            }
            case 203: {
                this.diplayTextState(203, 205);
                break;
            }
            case 4: {
                this.goToConfirmationState(1, -1, 313);
            }
        }
    }

    private void clickOptionsMenu() {
        switch (OPTIONS_MENU_ITEMS[this.menuIndex]) {
            case 15: {
                GameImpl.soundManager.setSoundEnabled(!GameImpl.soundManager.isSoundEnabled());
                if (!GameImpl.soundManager.isSoundEnabled()) break;
                GameImpl.playSound(7);
                soundStartTimer = 20;
                break;
            }
            case 70: {
                GameImpl.displayHints = !GameImpl.displayHints;
                break;
            }
            case 1: {
                this.goToState(0);
            }
        }
    }

    public void appKeyPressed(int n, long l) {
        if (!this.transitionAnimation) {
            block0 : switch (this.menuState) {
                case 1: {
                    if (n == 32 || n == 4096 || n == 16) {
                        this.clickMainMenu();
                        break;
                    }
                    if (n == 64 || n == 524288) {
                        GameImpl.setState(7);
                        break;
                    }
                    if (n == 1 || n == 512) {
                        this.mainMenuMove(true, MAIN_MENU_ITEMS.length);
                        break;
                    }
                    if (n != 2 && n != 32768) break;
                    this.mainMenuMove(false, MAIN_MENU_ITEMS.length);
                    break;
                }
                case 0: {
                    if (n == 32 || n == 4096 || n == 16) {
                        SDKUtils.setCurrentLanguage(this.menuIndex);
                        this.goBackState();
                        break;
                    }
                    if (n == 64 || n == 524288) {
                        this.goBackState();
                        break;
                    }
                    if (n == 1 || n == 512) {
                        if (--this.menuIndex >= 0) break;
                        this.menuIndex = GameImpl.numLangsLoaded - 1;
                        break;
                    }
                    if (n != 2 && n != 32768) break;
                    this.menuIndex = (this.menuIndex + 1) % GameImpl.numLangsLoaded;
                    break;
                }
                case 2: {
                    if (n == 32 || n == 4096 || n == 16) {
                        this.clickPauseMenu();
                        break;
                    }
                    if (n == 64 || n == 524288) {
                        SDKCanvas.disableInput(1);
                        byte by = GameImpl.savedPlayState;
                        GameImpl.setState(1);
                        GameImpl.fadeInToPlayState(by);
                        break;
                    }
                    if (n == 1 || n == 512) {
                        if (--this.menuIndex >= 0) break;
                        this.menuIndex = PAUSE_MENU_ITEMS.length - 1;
                        break;
                    }
                    if (n != 2 && n != 32768) break;
                    this.menuIndex = (this.menuIndex + 1) % PAUSE_MENU_ITEMS.length;
                    break;
                }
                case 3: {
                    if (n == 32 || n == 4096 || n == 16) {
                        this.clickOptionsMenu();
                        break;
                    }
                    if (n == 64 || n == 524288) {
                        this.goBackState();
                        break;
                    }
                    if (n == 1 || n == 512) {
                        if (--this.menuIndex >= 0) break;
                        this.menuIndex = OPTIONS_MENU_ITEMS.length - 1;
                        break;
                    }
                    if (n != 2 && n != 32768) break;
                    this.menuIndex = (this.menuIndex + 1) % OPTIONS_MENU_ITEMS.length;
                    break;
                }
                case 4: {
                    if (n == 32 || n == 4096 || n == 16) {
                        GameImpl.currentObjective = this.selectedObjective;
                        break;
                    }
                    if (n == 64 || n == 524288) {
                        if (this.goBackState()) break;
                        GameImpl.setState(1);
                        break;
                    }
                    if (n == 1 || n == 512) {
                        if (this.menuIndex > 0) {
                            --this.menuIndex;
                        }
                        if (this.menuIndex >= this.startListPos) break;
                        --this.startListPos;
                        break;
                    }
                    if (n != 2 && n != 32768) break;
                    if (this.menuIndex < this.numShownObjectives - 1) {
                        ++this.menuIndex;
                    }
                    if (this.menuIndex <= this.startListPos + this.numVisibleObjectives) break;
                    ++this.startListPos;
                    break;
                }
                case 5: {
                    if (n == 32 || n == 4096 || n == 16) break;
                    if (n == 64 || n == 524288) {
                        if (this.goBackState()) break;
                        GameImpl.setState(1);
                        break;
                    }
                    if (n == 1 || n == 512) {
                        while (this.startListPos > 0) {
                            --this.startListPos;
                            if (!Menu.isAchievementVisible(this.startListPos)) continue;
                            break block0;
                        }
                    } else {
                        if (n != 2 && n != 32768) break;
                        while (this.startListPos < this.numShownAchievements - this.numVisibleAchievements) {
                            ++this.startListPos;
                            if (!Menu.isAchievementVisible(this.startListPos + this.numVisibleAchievements)) continue;
                            break block0;
                        }
                    }
                    break;
                }
                case 6: {
                    if (n == 32 || n == 4096 || n == 16) {
                        if (!isContinueEnabled) {
                            for (int i = 0; i < GameImpl.achievementCount; ++i) {
                                GameImpl.continueAchievementCompleted[i] = false;
                            }
                            GameImpl.saveAchievements();
                            this.startNewLevel(this.menuIndex);
                            break;
                        }
                        this.goToConfirmNewLevelState(314, this.menuIndex);
                        break;
                    }
                    if (n == 64 || n == 524288) {
                        this.goBackState();
                        break;
                    }
                    if (n == 1 || n == 512) {
                        do {
                            if (--this.menuIndex >= 0) continue;
                            this.menuIndex = GameImpl.currentMaxUnlockedLevel;
                        } while (GameImpl.levels[this.menuIndex][7] == 0);
                        break;
                    }
                    if (n != 2 && n != 32768) break;
                    do {
                        this.menuIndex = (this.menuIndex + 1) % (GameImpl.currentMaxUnlockedLevel + 1);
                    } while (GameImpl.levels[this.menuIndex][7] == 0);
                    break;
                }
                case 7: {
                    if (n == 32 || n == 4096 || n == 16) break;
                    if (n == 64 || n == 524288) {
                        this.goBackState();
                        break;
                    }
                    if (n == 1 || n == 512 || n == 4 || n == 2048) {
                        if (this.menuIndex <= 0) break;
                        --this.menuIndex;
                        break;
                    }
                    if (n != 2 && n != 32768 && n != 8 && n != 8192 || GameImpl.wrapOffsets[0] <= (this.menuIndex + 1) * 9) break;
                    ++this.menuIndex;
                    break;
                }
                case 8: {
                    if (n == 32 || n == 4096 || n == 16) {
                        if (this.confirmationYesState != -1) {
                            this.goToState(this.confirmationYesState);
                            break;
                        }
                        this.goBackState();
                        break;
                    }
                    if (n != 64 && n != 524288) break;
                    if (this.confirmationNoState != -1) {
                        this.goToState(this.confirmationNoState);
                        break;
                    }
                    this.goBackState();
                }
            }
        }
    }

    public void appKeyReleased(int n, long l) {
    }

    public void updateTransitionAnimation() {
        if (this.transitionOpen) {
            this.transitionPos = (this.transitionPos * 1 + 67) / 2;
            if (67 - this.transitionPos < 4) {
                this.transitionPos = 67;
                this.transitionFinished = true;
                this.transitionAnimation = false;
            }
        } else {
            this.transitionPos = (this.transitionPos * 1 + 0) / 2;
            if (this.transitionPos < 4) {
                this.transitionPos = 0;
                this.transitionFinished = true;
                this.transitionOpen = true;
            }
        }
    }

    public void update() {
        if (soundStartTimer > 0 && --soundStartTimer == 0 && GameImpl.soundManager.isSoundEnabled()) {
            GameImpl.soundManager.stopSounds();
            GameImpl.playSoundRepeated(6);
            soundStartTimer = -1;
        }
        if (this.transitionAnimation) {
            this.updateTransitionAnimation();
            if (this.transitionFinished && this.transitionPos == 0) {
                this.setMenuState(this.transitionState);
            }
        }
        switch (this.menuState) {
            case 1: {
                if (this.menuSelectionOffsetIndex > 0) {
                    if ((this.menuSelectionOffsetIndex -= 7) >= 0) break;
                    this.menuSelectionOffsetIndex = 0;
                    break;
                }
                if (this.menuSelectionOffsetIndex >= 0 || (this.menuSelectionOffsetIndex += 7) <= 0) break;
                this.menuSelectionOffsetIndex = 0;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                this.numShownObjectives = 0;
                for (int i = 0; i < GameImpl.numObjectives; ++i) {
                    if (GameImpl.objectives[i].state == 0) continue;
                    ++this.numShownObjectives;
                }
                this.numVisibleObjectives = this.numShownObjectives;
                break;
            }
            case 5: {
                this.numVisibleAchievements = this.numShownAchievements;
                break;
            }
        }
    }

    public void paint(SDKGraphics sDKGraphics) {
        XSprite.setTempDrawScaled(false);
        switch (this.menuState) {
            case 1: {
                this.drawMainMenu(sDKGraphics);
                break;
            }
            case 0: {
                this.drawLSM(sDKGraphics);
                break;
            }
            case 2: {
                this.drawPauseMenu(sDKGraphics);
                break;
            }
            case 3: {
                this.drawOptionsMenu(sDKGraphics);
                break;
            }
            case 6: {
                this.drawChooseLevelMenu(sDKGraphics);
                break;
            }
            case 4: {
                this.drawObjectivesMenu(sDKGraphics);
                break;
            }
            case 5: {
                this.drawAchievementsMenu(sDKGraphics);
                break;
            }
            case 7: {
                this.drawTextDisplayMenu(sDKGraphics);
                break;
            }
            case 8: {
                GameImpl.drawConfirmation(sDKGraphics, this.textDisplay);
                break;
            }
        }
        if (this.transitionAnimation) {
            this.drawTransitionAnimation(sDKGraphics);
        }
        XSprite.restoreDrawScaled();
    }

    public void drawTransitionAnimation(SDKGraphics sDKGraphics) {
        GameImpl.FillRect(sDKGraphics, 0, 0, 0, 320, 120 - this.transitionPos);
        GameImpl.FillRect(sDKGraphics, 0, 0, 120 + this.transitionPos, 320, 120 - this.transitionPos);
        GameImpl.sprites[10].DrawFrame(2, 160, 120 - this.transitionPos, 0);
        GameImpl.sprites[10].DrawFrame(2, 160, 120 + this.transitionPos, 0);
    }

    public void setMenuState(int n) {
        if (this.menuState == 0) {
            GameImpl.saveSettings();
        }
        this.menuState = n;
        int n2 = this.menuIndex = n == 7 ? 0 : this.menuIndexPositions[this.menuState];
        if (this.menuState == 1) {
            GameImpl.machineGunPlaying = false;
            boolean bl = isContinueEnabled = !SDKUtils.isRecordEmpty(1) || GameImpl.continueNextLevel != -1;
            if (GameImpl.bCleanMemory) {
                Map._imgBB = null;
                Map._gBB = null;
                System.gc();
                GameImpl.cleanSprites();
            }
            skipMoreGames = !GameImpl.mgInstance.isAvailable();
            numMainMenuItems = MAIN_MENU_ITEMS.length;
            if (skipMoreGames) {
                --numMainMenuItems;
            }
            GameImpl.loadSplashSprite();
            SDKUtils.setFont(GameImpl.fonts[3]);
            this.mainMenuSpaceBetweenItems = SDKUtils.getLineSize() + -4;
        }
        if (this.menuState == 5) {
            this.numShownAchievements = 0;
            for (int i = 0; i < GameImpl.achievementCount; ++i) {
                if (!Menu.isAchievementVisible(i) || i == 21 || i == 23) continue;
                ++this.numShownAchievements;
            }
        }
    }

    public void setMenuStateWithAnimation(int n) {
        if (n != this.menuState) {
            this.transitionAnimation = true;
            this.transitionOpen = false;
            this.transitionState = n;
            this.transitionFinished = false;
            this.transitionPos = 67;
        }
    }

    public void openMenuWithAnimation() {
        this.transitionAnimation = true;
        this.transitionOpen = true;
        this.transitionPos = 0;
        this.transitionFinished = false;
    }

    public void drawMenuBackground(SDKGraphics sDKGraphics, int n, int n2) {
        if (GameImpl.sprites[13] != null) {
            GameImpl.sprites[13].DrawFrame(n, 0, 0, 0);
        }
    }

    public void drawMenuSoftkeys(boolean bl, boolean bl2) {
        if (bl) {
            if (SDKCanvas.isKeyPressed(32)) {
                GameImpl.sprites[7].DrawFrame(38, 18, 228, 0);
            } else {
                GameImpl.sprites[7].DrawFrame(37, 18, 228, 0);
            }
        }
        if (bl2) {
            if (SDKCanvas.isKeyPressed(64)) {
                GameImpl.sprites[7].DrawFrame(40, 301, 228, 0);
            } else {
                GameImpl.sprites[7].DrawFrame(39, 301, 228, 0);
            }
        }
    }

    private void drawPauseMenu(SDKGraphics sDKGraphics) {
        int n = 67;
        SDKUtils.setFont(GameImpl.fonts[0]);
        GameImpl.string = SDKUtils.getString(7, GameImpl.string);
        SDKUtils.drawString(GameImpl.string, 160, 41, 17);
        SDKUtils.setFont(GameImpl.fonts[0]);
        int n2 = SDKUtils.getLineSize() + 5;
        for (int i = 0; i < PAUSE_MENU_ITEMS.length; ++i) {
            if (i == this.menuIndex) {
                SDKUtils.setFont(GameImpl.fonts[1]);
            } else {
                SDKUtils.setFont(GameImpl.fonts[0]);
            }
            GameImpl.string = SDKUtils.getString(PAUSE_MENU_ITEMS[i], GameImpl.string);
            SDKUtils.drawString(GameImpl.string, 90, n, 20);
            if (i == this.menuIndex) {
                GameImpl.sprites[10].DrawFrame(19, 90, n, 0);
            }
            n += n2;
        }
        this.drawMenuSoftkeys(true, true);
    }

    private void drawMainMenu(SDKGraphics sDKGraphics) {
        int n;
        if (GameImpl.sprites[13] != null) {
            GameImpl.sprites[13].DrawFrame(2, 0, 0, 0);
            GameImpl.sprites[13].DrawFrame(1, 0, 0, 0);
        }
        SDKUtils.setFont(GameImpl.fonts[3]);
        this.mainMenuSpaceBetweenItems = SDKUtils.getLineSize() + -4;
        int n2 = this.menuIndex;
        for (n = 0; n < this.menuIndex; ++n) {
            if ((isContinueEnabled || MAIN_MENU_ITEMS[n] != 11) && (!skipMoreGames || MAIN_MENU_ITEMS[n] != 6)) continue;
            --n2;
        }
        n = 53;
        int n3 = n + n2 * this.mainMenuSpaceBetweenItems + this.menuSelectionOffsetIndex + 13;
        int n4 = 0;
        for (int i = 0; i < MAIN_MENU_ITEMS.length; ++i) {
            if (!isContinueEnabled && MAIN_MENU_ITEMS[i] == 11 || skipMoreGames && MAIN_MENU_ITEMS[i] == 6) continue;
            if (i == this.menuIndex) {
                SDKUtils.setFont(GameImpl.fonts[2]);
                GameImpl.sprites[10].DrawFrame(31, 292, n + 12, 0);
            } else {
                SDKUtils.setFont(GameImpl.fonts[3]);
            }
            GameImpl.string = SDKUtils.getString(MAIN_MENU_ITEMS[i], GameImpl.string);
            n4 = Math.abs(n + 13 - n3);
            SDKUtils.drawString(GameImpl.string, 288, n, 9);
            if (MAIN_MENU_ITEMS[i] == 6) {
                int n5 = 288;
                sDKGraphics.setColor(6903635);
                sDKGraphics.drawLine(n5 - SDKUtils.getStringSize(GameImpl.string), n + SDKUtils.getLineSize(), n5, n + SDKUtils.getLineSize());
                sDKGraphics.drawLine(n5 - SDKUtils.getStringSize(GameImpl.string), n + SDKUtils.getLineSize() + 1, n5, n + SDKUtils.getLineSize() + 1);
            }
            n += this.mainMenuSpaceBetweenItems;
        }
        if (!this.transitionAnimation) {
            this.drawMenuSoftkeys(true, true);
        }
    }

    private void drawOptionsMenu(SDKGraphics sDKGraphics) {
        this.drawMenuBackground(sDKGraphics, 0, 45);
        SDKUtils.setFont(GameImpl.fonts[0]);
        GameImpl.string = SDKUtils.getString(13, GameImpl.string);
        SDKUtils.drawString(GameImpl.string, 160, 71, 17);
        SDKUtils.setFont(GameImpl.fonts[0]);
        int n = SDKUtils.getLineSize() + 5;
        int n2 = 100;
        for (int i = 0; i < OPTIONS_MENU_ITEMS.length; ++i) {
            if (i == this.menuIndex) {
                SDKUtils.setFont(GameImpl.fonts[1]);
            } else {
                SDKUtils.setFont(GameImpl.fonts[0]);
            }
            GameImpl.string = OPTIONS_MENU_ITEMS[i] == 1 ? SDKUtils.getHeaderString(SDKUtils.getCurrentLanguage(), OPTIONS_MENU_ITEMS[i], GameImpl.string) : SDKUtils.getString(OPTIONS_MENU_ITEMS[i], GameImpl.string);
            SDKUtils.drawString(GameImpl.string, 90, n2, 20);
            switch (OPTIONS_MENU_ITEMS[i]) {
                case 15: {
                    GameImpl.string = GameImpl.soundManager.isSoundEnabled() ? SDKUtils.getString(67, GameImpl.string) : SDKUtils.getString(68, GameImpl.string);
                    SDKUtils.drawString(GameImpl.string, 200, n2, 20);
                    break;
                }
                case 70: {
                    GameImpl.string = GameImpl.displayHints ? SDKUtils.getString(67, GameImpl.string) : SDKUtils.getString(68, GameImpl.string);
                    SDKUtils.drawString(GameImpl.string, 200, n2, 20);
                    break;
                }
                case 1: {
                    GameImpl.string = SDKUtils.getHeaderString(SDKUtils.getCurrentLanguage(), 0, GameImpl.string);
                    SDKUtils.drawString(GameImpl.string, 200, n2, 20);
                }
            }
            if (i == this.menuIndex) {
                GameImpl.sprites[10].DrawFrame(19, 90, n2, 0);
            }
            n2 += n;
        }
        if (!this.transitionAnimation) {
            this.drawMenuSoftkeys(true, true);
        }
    }

    private void drawChooseLevelMenu(SDKGraphics sDKGraphics) {
        this.drawMenuBackground(sDKGraphics, 0, 25);
        SDKUtils.setFont(GameImpl.fonts[0]);
        GameImpl.string = SDKUtils.getString(119, GameImpl.string);
        SDKUtils.drawString(GameImpl.string, 160, 65, 17);
        GameImpl.sprites[10].DrawFrame(32, 160, 86, 0);
        int n = 0;
        int n2 = GameImpl.levels.length;
        int n3 = 0;
        if (this.menuIndex > 5) {
            n3 = 6;
        }
        while (n3 < GameImpl.levels.length) {
            if (GameImpl.levels[n3][7] != 0) {
                if (n3 == this.menuIndex) {
                    GameImpl.FillRect(sDKGraphics, 0xEEEEEE, 0, 98 + n * 25 + 3, 320, 19);
                }
                GameImpl.sprites[10].DrawFrame(n3 > GameImpl.currentMaxUnlockedLevel ? 43 : 42, 0, 98 + n * 25, 0);
                if (n3 == this.menuIndex) {
                    SDKUtils.setFont(GameImpl.fonts[1]);
                } else {
                    SDKUtils.setFont(GameImpl.fonts[0]);
                }
                GameImpl.string = SDKUtils.getString(GameImpl.levels[n3][4], GameImpl.string);
                SDKUtils.drawString(GameImpl.string, 60, 98 + n * 25, 20);
                if (++n > 3) break;
            }
            ++n3;
        }
        GameImpl.sprites[10].DrawFrame(33, 160, 208, 0);
        if (!this.transitionAnimation) {
            this.drawMenuSoftkeys(true, true);
        }
    }

    public void drawObjectivesStartingFrom(SDKGraphics sDKGraphics, int n, boolean bl) {
        int n2 = 0;
        boolean bl2 = true;
        SDKUtils.setFont(GameImpl.fonts[0]);
        if (GameImpl.numObjectives > 0) {
            if (this.startListPos > 0) {
                GameImpl.sprites[10].DrawFrame(15, 305, 187, 0);
            }
            for (int i = 0; i < GameImpl.numObjectives; ++i) {
                if (GameImpl.objectives[i].state == 0) continue;
                if (bl2) {
                    if (n2 >= this.startListPos) {
                        if (GameImpl.objectives[i].state == 2) {
                            SDKUtils.setFont(GameImpl.fonts[0]);
                        } else {
                            SDKUtils.setFont(GameImpl.fonts[1]);
                        }
                        GameImpl.string = SDKUtils.getString(GameImpl.objectives[i].textActivate, GameImpl.string);
                        GameImpl.wrapOffsets = SDKUtils.wrapString(GameImpl.string, GameImpl.wrapOffsets, 260, (short)124);
                        if (n + SDKUtils.getLineSize() * GameImpl.wrapOffsets[0] > 180) {
                            bl2 = false;
                            this.numVisibleObjectives = n2 - this.startListPos;
                        }
                        if (n2 == this.menuIndex && bl) {
                            this.selectedObjective = i;
                            GameImpl.FillRect(sDKGraphics, 0x555555, 0, n, 320, SDKUtils.getLineSize() * GameImpl.wrapOffsets[0]);
                        }
                        SDKUtils.drawWrappedString(GameImpl.string, GameImpl.wrapOffsets, 1, GameImpl.wrapOffsets[0], 60, n, 20);
                        if (GameImpl.objectives[i].state == 2) {
                            GameImpl.sprites[10].DrawFrame(3, 30, n + (SDKUtils.getLineSize() * GameImpl.wrapOffsets[0] + 3 >> 1), 0);
                        } else {
                            GameImpl.sprites[10].DrawFrame(4, 30, n + (SDKUtils.getLineSize() * GameImpl.wrapOffsets[0] + 3 >> 1), 0);
                        }
                        if (GameImpl.currentObjective == i && bl) {
                            GameImpl.sprites[7].DrawFrame(44, 6, n + (SDKUtils.getLineSize() * GameImpl.wrapOffsets[0] + 3 >> 1) - 1, 0);
                        }
                        n += SDKUtils.getLineSize() * GameImpl.wrapOffsets[0] + 3;
                    }
                } else {
                    if (this.numVisibleObjectives >= this.numShownObjectives) break;
                    GameImpl.sprites[10].DrawFrame(17, 305, 195, 0);
                    break;
                }
                ++n2;
            }
        }
    }

    private void drawObjectivesMenu(SDKGraphics sDKGraphics) {
        this.drawMenuBackground(sDKGraphics, 0, 45);
        SDKUtils.setFont(GameImpl.fonts[0]);
        GameImpl.string = SDKUtils.getString(17, GameImpl.string);
        SDKUtils.drawString(GameImpl.string, 160, 36, 17);
        this.drawObjectivesStartingFrom(sDKGraphics, 60, true);
        if (!this.transitionAnimation) {
            if (this.numShownObjectives > 1) {
                this.drawMenuSoftkeys(true, true);
            } else {
                this.drawMenuSoftkeys(false, true);
            }
        }
    }

    public static boolean isAchievementVisible(int n) {
        return n < 18 || Utils.isFlagSet(GameImpl.levels[n - 18][6], 8);
    }

    private void drawAchievementsMenu(SDKGraphics sDKGraphics) {
        int n = 79;
        int n2 = 0;
        boolean bl = true;
        this.drawMenuBackground(sDKGraphics, 0, 45);
        SDKUtils.setFont(GameImpl.fonts[0]);
        GameImpl.string = SDKUtils.getString(46, GameImpl.string);
        SDKUtils.drawString(GameImpl.string, 160, 61, 17);
        if (this.startListPos > 0) {
            GameImpl.sprites[10].DrawFrame(32, 160, n, 0);
        }
        n += 15;
        int n3 = SDKUtils.getLeadingSpacing();
        SDKUtils.setLeadingSpacing(-4);
        for (int i = 0; i < GameImpl.achievementCount; ++i) {
            if (bl) {
                if (n2 >= this.startListPos) {
                    GameImpl.string = SDKUtils.getString(GameImpl.achievementName[i], GameImpl.string);
                    GameImpl.stringBuffer.setLength(0);
                    GameImpl.stringBuffer.append(GameImpl.string);
                    if (i >= 18) {
                        if (!Menu.isAchievementVisible(i) || i == 21 || i == 23) continue;
                        GameImpl.stringBuffer.append("\"");
                        GameImpl.string = SDKUtils.getString(GameImpl.levels[i - 18][4], GameImpl.string);
                        GameImpl.stringBuffer.append(GameImpl.string);
                        GameImpl.stringBuffer.append("\"");
                    }
                    GameImpl.wrapOffsets = SDKUtils.wrapString(GameImpl.stringBuffer, GameImpl.wrapOffsets, 280, (short)124);
                    int n4 = 43;
                    if (GameImpl.achievementCompleted[i]) {
                        n4 = 42;
                    }
                    GameImpl.sprites[10].DrawFrame(n4, -2, n, 0);
                    if (n + 24 > 170) {
                        bl = false;
                    }
                    SDKUtils.drawWrappedString(GameImpl.stringBuffer, GameImpl.wrapOffsets, 1, GameImpl.wrapOffsets[0], 38, n + 12 - 2, 6);
                    n += 24;
                }
            } else {
                if (!Menu.isAchievementVisible(i)) continue;
                GameImpl.sprites[10].DrawFrame(33, 160, n + 16, 0);
                break;
            }
            ++n2;
        }
        this.numVisibleAchievements = n2 - this.startListPos;
        SDKUtils.setLeadingSpacing(n3);
        if (!this.transitionAnimation) {
            this.drawMenuSoftkeys(false, true);
        }
    }

    private void drawTextDisplayMenu(SDKGraphics sDKGraphics) {
        int n;
        this.drawMenuBackground(sDKGraphics, 0, 45);
        if (this.titleStr != null) {
            SDKUtils.setFont(GameImpl.fonts[0]);
            SDKUtils.drawString(this.titleStr, 160, 61, 17);
        }
        if (this.textStr != null) {
            n = 0;
            n = GameImpl.wrapOffsets[0] - this.menuIndex * 9 > 9 ? 9 : GameImpl.wrapOffsets[0] - this.menuIndex * 9;
            SDKUtils.drawWrappedString(this.textStr, GameImpl.wrapOffsets, this.menuIndex * 9 + 1, n, 15, 80, 20);
        }
        if (!this.transitionAnimation) {
            n = GameImpl.wrapOffsets[0] % 9 > 0 ? GameImpl.wrapOffsets[0] / 9 + 1 : GameImpl.wrapOffsets[0] / 9;
            GameImpl.stringBuffer.setLength(0);
            GameImpl.stringBuffer.append(this.menuIndex + 1).append(" / ");
            GameImpl.stringBuffer.append(n);
            SDKUtils.drawString(GameImpl.stringBuffer, 160, 239, 33);
            if (this.menuIndex > 0) {
                GameImpl.sprites[7].DrawFrame(43, 130, 231, 0);
            }
            if (this.menuIndex < GameImpl.wrapOffsets[0] / 9) {
                GameImpl.sprites[7].DrawFrame(44, 190, 231, 0);
            }
            this.drawMenuSoftkeys(false, true);
        }
    }

    private void drawLSM(SDKGraphics sDKGraphics) {
        this.drawMenuBackground(sDKGraphics, 0, 45);
        SDKUtils.setFont(GameImpl.fonts[0]);
        GameImpl.string = SDKUtils.getHeaderString(SDKUtils.getCurrentLanguage(), 1, GameImpl.string);
        SDKUtils.drawString(GameImpl.string, 160, 61, 17);
        int n = SDKUtils.getLineSize();
        int n2 = 120 - (n * GameImpl.numLangsLoaded >> 1);
        for (int i = 0; i < GameImpl.numLangsLoaded; ++i) {
            SDKUtils.getHeaderString(i, 0, GameImpl.string);
            if (i == this.menuIndex) {
                SDKUtils.setFont(GameImpl.fonts[1]);
                SDKUtils.drawString(GameImpl.string, 160, n2, 17);
                SDKUtils.setFont(GameImpl.fonts[0]);
            } else {
                SDKUtils.drawString(GameImpl.string, 160, n2, 1);
            }
            n2 += n;
        }
        this.drawMenuSoftkeys(true, true);
    }

    static {
        isContinueEnabled = false;
        skipMoreGames = false;
        numMainMenuItems = 0;
        soundStartTimer = -1;
    }
}

