/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.GameImpl;
import com.ea.game.PathFinder;
import com.ea.game.Region;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;

public class Map
implements Constants {
    public static int _nrTiles;
    public static short[] _tilePalette;
    public static byte[] _map;
    public static int tileWidth;
    public static int tileHeight;
    public static int _map_tw;
    public static int _map_th;
    public static int _map_size;
    public static int _map_w;
    public static int _map_h;
    public static int _coll_map_w;
    public static int _coll_map_h;
    public static byte[] _coll_map;
    public static int _coll_map_tw;
    public static int _coll_map_th;
    public static int _coll_map_size;
    public static int collision_tile_w;
    public static int collision_tile_h;
    static boolean useLights;
    static boolean fillTile;
    static boolean useSmallCDB;
    public static int _currentTileSet;
    public static SDKImage _imgBB;
    public static SDKGraphics _gBB;
    public static boolean _bResetCDB;
    public static int cdb_tw;
    public static int cdb_th;
    public static int cdb_w;
    public static int cdb_h;
    public static int _CDB_view_tx;
    public static int _CDB_view_ty;
    public static int _CDB_orig_tx;
    public static int _CDB_orig_ty;
    public static int _CDB_xo;
    public static int _CDB_yo;
    public static int _CDB_oldX;
    public static int _CDB_oldY;
    public static int _CDB_x;
    public static int _CDB_y;
    public static int _CDB_w;
    public static int _CDB_h;
    public static int _CDB_nrRegions;
    public static Region[] _CDB_regions;
    public static int _CDB_separator;
    static long time;

    static void Init() {
        tileWidth = 32;
        tileHeight = 32;
        collision_tile_w = 8;
        collision_tile_h = 8;
        switch (GameImpl.gameMode) {
            case 2: {
                tileWidth >>= 1;
                tileHeight >>= 1;
                collision_tile_w >>= 1;
                collision_tile_h >>= 1;
            }
        }
        cdb_tw = (320 + tileWidth - 1) / tileWidth + 1;
        cdb_th = (240 + tileHeight - 1) / tileHeight + 1;
        cdb_w = cdb_tw * tileWidth;
        cdb_h = cdb_th * tileHeight;
    }

    static void InitBackBuffer() {
        if (_imgBB != null) {
            // empty if block
        }
        _imgBB = SDKUtils.createImage(cdb_w, cdb_h);
        _CDB_w = 320;
        _CDB_h = 240;
        _gBB = _imgBB.getGraphics();
    }

    static void LoadTileMap(int n) {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            _currentTileSet = GameImpl.tileSets[sDKInputStream.read()];
            _nrTiles = sDKInputStream.read() & 0xFF;
            _tilePalette = new short[_nrTiles];
            for (int i = 0; i < _nrTiles; ++i) {
                Map._tilePalette[i] = sDKInputStream.readShort();
            }
            _map_tw = sDKInputStream.read() & 0xFF;
            _map_th = sDKInputStream.read() & 0xFF;
            _map_size = _map_tw * _map_th;
            _map_w = _map_tw * tileWidth;
            _map_h = _map_th * tileHeight;
            _map = Utils.ReadByteArray(sDKInputStream, _map_size << 1, null, 0);
            sDKInputStream.close();
            SDKInputStream.purgeCache();
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadTileMap:", exception);
        }
    }

    static void CDB_Update() {
        int n;
        int n2;
        int n3;
        if (useSmallCDB) {
            Map._CDB_update(Camera.posX, Camera.posY);
            for (int i = 0; i < _CDB_nrRegions; ++i) {
                Region region = _CDB_regions[i];
                Map.CDB_InvalidateArea(region.xo, region.yo, region.w, region.h, region.x, region.y, false);
            }
            return;
        }
        if (!_bResetCDB) {
            n3 = Camera.posX - _CDB_view_tx * tileWidth;
            if (n3 < 0) {
                n2 = (tileWidth - 1 - n3) / tileWidth;
                if (n2 >= cdb_tw) {
                    _bResetCDB = true;
                } else {
                    _CDB_view_tx -= n2;
                    if ((_CDB_orig_tx -= n2) < 0) {
                        n = n2 + _CDB_orig_tx;
                        if (n != 0) {
                            Map.CDB_InvalidateTilesV(0, n, _CDB_view_tx - _CDB_orig_tx);
                        }
                        Map.CDB_InvalidateTilesV(_CDB_orig_tx += cdb_tw, n2 - n, _CDB_view_tx);
                    } else {
                        Map.CDB_InvalidateTilesV(_CDB_orig_tx, n2, _CDB_view_tx);
                    }
                }
            } else if (n3 > cdb_w - 320) {
                n2 = (n3 - (cdb_w - 320) + (tileWidth - 1)) / tileWidth;
                if (n2 >= cdb_tw) {
                    _bResetCDB = true;
                } else {
                    n = _CDB_orig_tx + n2 - cdb_tw;
                    if (n >= 0) {
                        Map.CDB_InvalidateTilesV(_CDB_orig_tx, cdb_tw - _CDB_orig_tx, _CDB_view_tx + cdb_tw);
                        if (n != 0) {
                            Map.CDB_InvalidateTilesV(0, n, _CDB_view_tx + cdb_tw + cdb_tw - _CDB_orig_tx);
                        }
                        _CDB_orig_tx = n;
                    } else {
                        Map.CDB_InvalidateTilesV(_CDB_orig_tx, n2, _CDB_view_tx + cdb_tw);
                        _CDB_orig_tx += n2;
                    }
                    _CDB_view_tx += n2;
                }
            }
        }
        if (!_bResetCDB) {
            n3 = Camera.posY - _CDB_view_ty * tileHeight;
            if (n3 < 0) {
                n2 = (tileHeight - 1 - n3) / tileHeight;
                if (n2 >= cdb_th) {
                    _bResetCDB = true;
                } else {
                    _CDB_view_ty -= n2;
                    if ((_CDB_orig_ty -= n2) < 0) {
                        n = n2 + _CDB_orig_ty;
                        if (n != 0) {
                            Map.CDB_InvalidateTilesH(0, n, _CDB_view_ty - _CDB_orig_ty);
                        }
                        Map.CDB_InvalidateTilesH(_CDB_orig_ty += cdb_th, n2 - n, _CDB_view_ty);
                    } else {
                        Map.CDB_InvalidateTilesH(_CDB_orig_ty, n2, _CDB_view_ty);
                    }
                }
            } else if (n3 > cdb_h - 240) {
                n2 = (n3 - (cdb_h - 240) + (tileHeight - 1)) / tileHeight;
                if (n2 >= cdb_th) {
                    _bResetCDB = true;
                } else {
                    n = _CDB_orig_ty + n2 - cdb_th;
                    if (n >= 0) {
                        Map.CDB_InvalidateTilesH(_CDB_orig_ty, cdb_th - _CDB_orig_ty, _CDB_view_ty + cdb_th);
                        if (n != 0) {
                            Map.CDB_InvalidateTilesH(0, n, _CDB_view_ty + cdb_th + cdb_th - _CDB_orig_ty);
                        }
                        _CDB_orig_ty = n;
                    } else {
                        Map.CDB_InvalidateTilesH(_CDB_orig_ty, n2, _CDB_view_ty + cdb_th);
                        _CDB_orig_ty += n2;
                    }
                    _CDB_view_ty += n2;
                }
            }
        }
        if (_bResetCDB) {
            _bResetCDB = false;
            _CDB_view_tx = Camera.posX / tileWidth;
            if (_CDB_view_tx > _map_tw - cdb_tw) {
                _CDB_view_tx = _map_tw - cdb_tw;
            }
            if ((_CDB_view_ty = Camera.posY / tileHeight) > _map_th - cdb_th) {
                _CDB_view_ty = _map_th - cdb_th;
            }
            _CDB_orig_tx = 0;
            _CDB_orig_ty = 0;
            Map.CDB_InvalidateTiles(0, 0, cdb_tw, cdb_th, _CDB_view_tx, _CDB_view_ty);
        }
    }

    static void CDB_Invalidate(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n / tileWidth;
        int n12 = n2 / tileHeight;
        int n13 = (n + n3 - 1) / tileWidth + 1;
        int n14 = (n2 + n4 - 1) / tileHeight + 1;
        if (n11 < _CDB_view_tx) {
            n11 = _CDB_view_tx;
        }
        if (n13 > _CDB_view_tx + cdb_tw) {
            n13 = _CDB_view_tx + cdb_tw;
        }
        if (n13 - n11 <= 0) {
            return;
        }
        if (n12 < _CDB_view_ty) {
            n12 = _CDB_view_ty;
        }
        if (n14 > _CDB_view_ty + cdb_th) {
            n14 = _CDB_view_ty + cdb_th;
        }
        if (n14 - n12 <= 0) {
            return;
        }
        int n15 = n11 + _CDB_orig_tx - _CDB_view_tx;
        int n16 = n15 - cdb_tw;
        if (n16 < 0) {
            n16 = 0;
        }
        if ((n10 = cdb_tw - n15) > (n9 = n13 - n11)) {
            n10 = n9;
        }
        if ((n8 = n9 - n10) > n9) {
            n8 = n9;
        }
        n13 = n11 + n9 - n8;
        int n17 = n12 + _CDB_orig_ty - _CDB_view_ty;
        int n18 = n17 - cdb_th;
        if (n18 < 0) {
            n18 = 0;
        }
        if ((n7 = cdb_th - n17) > (n6 = n14 - n12)) {
            n7 = n6;
        }
        if ((n5 = n6 - n7) > n6) {
            n5 = n6;
        }
        n14 = n12 + n6 - n5;
        if (n10 > 0) {
            if (n7 > 0) {
                Map.CDB_InvalidateTiles(n15, n17, n10, n7, n11, n12);
            }
            if (n5 > 0) {
                Map.CDB_InvalidateTiles(n15, n18, n10, n5, n11, n14);
            }
        }
        if (n8 > 0) {
            if (n7 > 0) {
                Map.CDB_InvalidateTiles(n16, n17, n8, n7, n13, n12);
            }
            if (n5 > 0) {
                Map.CDB_InvalidateTiles(n16, n18, n8, n5, n13, n14);
            }
        }
    }

    private static void CDB_InvalidateTilesV(int n, int n2, int n3) {
        if (_CDB_orig_ty > 0) {
            Map.CDB_InvalidateTiles(n, 0, n2, _CDB_orig_ty, n3, _CDB_view_ty + cdb_th - _CDB_orig_ty);
            Map.CDB_InvalidateTiles(n, _CDB_orig_ty, n2, cdb_th - _CDB_orig_ty, n3, _CDB_view_ty);
        } else {
            Map.CDB_InvalidateTiles(n, 0, n2, cdb_th, n3, _CDB_view_ty);
        }
    }

    private static void CDB_InvalidateTilesH(int n, int n2, int n3) {
        if (_CDB_orig_tx > 0) {
            Map.CDB_InvalidateTiles(0, n, _CDB_orig_tx, n2, _CDB_view_tx + cdb_tw - _CDB_orig_tx, n3);
            Map.CDB_InvalidateTiles(_CDB_orig_tx, n, cdb_tw - _CDB_orig_tx, n2, _CDB_view_tx, n3);
        } else {
            Map.CDB_InvalidateTiles(0, n, cdb_tw, n2, _CDB_view_tx, n3);
        }
    }

    private static void CDB_InvalidateTiles(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n * tileWidth;
        int n8 = n2 * tileHeight;
        int n9 = n3 * tileWidth;
        int n10 = n4 * tileHeight;
        int n11 = n5 * tileWidth;
        int n12 = n6 * tileHeight;
        _gBB.setClip(n7, n8, n9, n10);
        XSprite.SetGraphics(_gBB);
        int n13 = n7 + n9;
        int n14 = n8 + n10;
        int n15 = n5 + n6 * _map_tw;
        int n16 = n8;
        while (n16 < n14) {
            int n17 = n15;
            int n18 = n7;
            while (n18 < n13) {
                Map.CDB_DrawTile(n17, n18, n16);
                n18 += tileWidth;
                ++n17;
            }
            n16 += tileHeight;
            n15 += _map_tw;
        }
        Map.CDB_DrawBackgroundEntities(n7, n8, n9, n10, n11, n12);
    }

    private static void CDB_InvalidateArea(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        int n8 = n3;
        int n9 = n4;
        if (n8 * n9 > 12288) {
            if (n3 > n4) {
                Map.CDB_InvalidateArea(n, n2, n3 >> 1, n4, n5, n6, bl);
                Map.CDB_InvalidateArea(n + (n3 >> 1), n2, n3 - (n3 >> 1), n4, n5 + (n3 >> 1), n6, bl);
            } else {
                Map.CDB_InvalidateArea(n, n2, n3, n4 >> 1, n5, n6, bl);
                Map.CDB_InvalidateArea(n, n2 + (n4 >> 1), n3, n4 - (n4 >> 1), n5, n6 + (n4 >> 1), bl);
            }
            return;
        }
        int n10 = n;
        int n11 = n2;
        _gBB.setClip(n, n2, n3, n4);
        XSprite.SetGraphics(_gBB);
        int n12 = n5 / tileWidth;
        int n13 = n6 / tileHeight;
        int n14 = n12 + n13 * _map_tw;
        int n15 = n12 * tileWidth - n5 + n10;
        int n16 = n7 = n13 * tileHeight - n6 + n11;
        while (n16 < n9 + n11) {
            int n17 = n14;
            int n18 = n15;
            while (n18 < n8 + n10) {
                Map.CDB_DrawTile(n17, n18, n16);
                n18 += tileWidth;
                ++n17;
            }
            n16 += tileHeight;
            n14 += _map_tw;
        }
        Map.CDB_DrawBackgroundEntities(n10, n11, n8, n9, n5, n6);
        XSprite._op = 0;
    }

    private static void CDB_DrawBackgroundEntities(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Camera.posX;
        int n8 = Camera.posY;
        Camera.posX = n5 - n;
        Camera.posY = n6 - n2;
        GameImpl.setDecoratorsClip(n5, n6, n3, n4);
        GameImpl.drawCDBEntities();
        Camera.posX = n7;
        Camera.posY = n8;
    }

    static void CDB_Draw(SDKGraphics sDKGraphics) {
        if (useSmallCDB) {
            Map._CDB_blitToScreen(sDKGraphics);
            return;
        }
        int n = Camera.posX - (_CDB_view_tx - _CDB_orig_tx) * tileWidth;
        int n2 = Camera.posY - (_CDB_view_ty - _CDB_orig_ty) * tileHeight;
        int n3 = cdb_w - n;
        if (n3 < 0) {
            int n4 = 0 + cdb_w - n;
            int n5 = cdb_h - n2;
            if (n5 < 0) {
                int n6 = 0 + cdb_h - n2;
                sDKGraphics.setClip(0, 0, 320, 240);
                sDKGraphics.drawImage(_imgBB, n4, n6, 0);
            } else if (n5 > 240) {
                int n7 = 0 - n2;
                sDKGraphics.setClip(0, 0, 320, 240);
                sDKGraphics.drawImage(_imgBB, n4, n7, 0);
            } else {
                int n8 = 240 - n5;
                int n9 = 0 - n2;
                int n10 = 0 + cdb_h - n2;
                sDKGraphics.setClip(0, 0, 320, n5);
                sDKGraphics.drawImage(_imgBB, n4, n9, 0);
                sDKGraphics.setClip(0, n10, 320, n8);
                sDKGraphics.drawImage(_imgBB, n4, n10, 0);
            }
        } else if (n3 > 320) {
            int n11 = 0 - n;
            int n12 = cdb_h - n2;
            if (n12 < 0) {
                int n13 = 0 + cdb_h - n2;
                sDKGraphics.setClip(0, 0, 320, 240);
                sDKGraphics.drawImage(_imgBB, n11, n13, 0);
            } else if (n12 > 240) {
                int n14 = 0 - n2;
                sDKGraphics.setClip(0, 0, 320, 240);
                sDKGraphics.drawImage(_imgBB, n11, n14, 0);
            } else {
                int n15 = 240 - n12;
                int n16 = 0 - n2;
                int n17 = 0 + cdb_h - n2;
                sDKGraphics.setClip(0, 0, 320, n12);
                sDKGraphics.drawImage(_imgBB, n11, n16, 0);
                sDKGraphics.setClip(0, n17, 320, n15);
                sDKGraphics.drawImage(_imgBB, n11, n17, 0);
            }
        } else {
            int n18 = 320 - n3;
            int n19 = 0 - n;
            int n20 = 0 + cdb_w - n;
            int n21 = cdb_h - n2;
            if (n21 < 0) {
                int n22 = 0 + cdb_h - n2;
                sDKGraphics.setClip(0, 0, n3, 240);
                sDKGraphics.drawImage(_imgBB, n19, n22, 0);
                sDKGraphics.setClip(n20, 0, n18, 240);
                sDKGraphics.drawImage(_imgBB, n20, n22, 0);
            } else if (n21 > 240) {
                int n23 = 0 - n2;
                sDKGraphics.setClip(0, 0, n3, 240);
                sDKGraphics.drawImage(_imgBB, n19, n23, 0);
                sDKGraphics.setClip(n20, 0, n18, 240);
                sDKGraphics.drawImage(_imgBB, n20, n23, 0);
            } else {
                int n24 = 240 - n21;
                int n25 = 0 - n2;
                int n26 = 0 + cdb_h - n2;
                sDKGraphics.setClip(0, 0, n3, n21);
                sDKGraphics.drawImage(_imgBB, n19, n25, 0);
                sDKGraphics.setClip(0, n26, n3, n24);
                sDKGraphics.drawImage(_imgBB, n19, n26, 0);
                sDKGraphics.setClip(n20, 0, n18, n21);
                sDKGraphics.drawImage(_imgBB, n20, n25, 0);
                sDKGraphics.setClip(n20, n26, n18, n24);
                sDKGraphics.drawImage(_imgBB, n20, n26, 0);
            }
        }
        sDKGraphics.setClip(0, 0, 320, 240);
    }

    private static void CDB_DrawTile(int n, int n2, int n3) {
        if (fillTile) {
            _gBB.setColor(0);
            _gBB.fillRect(n2, n3, tileWidth, tileHeight);
        }
        if ((n <<= 1) < 0 || n >= _map.length) {
            return;
        }
        int n4 = _map[n] & 0xFF;
        if (n4 != 255 && (n4 = _tilePalette[n4]) >= 0) {
            int n5 = _map[n + 1] & 0xFF;
            int n6 = n2;
            int n7 = n3;
            if ((n5 & 4) != 0) {
                if ((n5 & 1) != 0) {
                    n7 += tileHeight;
                }
                if ((n5 & 2) == 0) {
                    n6 += tileWidth;
                }
            } else {
                if ((n5 & 1) != 0) {
                    n6 += tileWidth;
                }
                if ((n5 & 2) != 0) {
                    n7 += tileHeight;
                }
            }
            GameImpl.sprites[_currentTileSet].DrawFrame(n4, n6, n7, n5);
        }
    }

    public static void _CDB_init(int n, int n2) {
        _CDB_separator = -1;
        _CDB_x = n;
        _CDB_y = n2;
        _CDB_xo = 0;
        _CDB_yo = 0;
        _CDB_oldX = n;
        _CDB_oldY = n2;
        _CDB_nrRegions = 0;
        Map._CDB_addRegion(n, n2, _CDB_xo, _CDB_yo, _CDB_w, _CDB_h);
    }

    public static void _CDB_moveX(int n) {
        int n2 = _CDB_xo;
        if ((_CDB_xo += n) >= _CDB_w) {
            Map._CDB_findXRegion(_CDB_x + _CDB_w, n2, _CDB_w - n2);
            Map._CDB_findXRegion(_CDB_x + _CDB_w + (_CDB_w - n2), 0, _CDB_xo -= _CDB_w);
            return;
        }
        if (_CDB_xo < 0) {
            Map._CDB_findXRegion(_CDB_x + n, _CDB_xo += _CDB_w, _CDB_w - _CDB_xo);
            Map._CDB_findXRegion(_CDB_x + n + _CDB_w - _CDB_xo, 0, n2);
            return;
        }
        if (n > 0) {
            Map._CDB_findXRegion(_CDB_x + _CDB_w, n2, n);
        } else {
            Map._CDB_findXRegion(_CDB_x + n, n2 + n, -n);
        }
    }

    public static void _CDB_findXRegion(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        Map._CDB_addRegion(n, _CDB_y, n2, _CDB_yo, n3, _CDB_h - _CDB_yo);
        if (_CDB_yo != 0) {
            Map._CDB_addRegion(n, _CDB_y + (_CDB_h - _CDB_yo), n2, 0, n3, _CDB_yo);
        }
    }

    public static void _CDB_moveY(int n) {
        int n2 = _CDB_yo;
        if ((_CDB_yo += n) >= _CDB_h) {
            Map._CDB_findYRegion(_CDB_y + _CDB_h, n2, _CDB_h - n2);
            Map._CDB_findYRegion(_CDB_y + _CDB_h + (_CDB_h - n2), 0, _CDB_yo -= _CDB_h);
            return;
        }
        if (_CDB_yo < 0) {
            Map._CDB_findYRegion(_CDB_y + n, _CDB_yo += _CDB_h, _CDB_h - _CDB_yo);
            Map._CDB_findYRegion(_CDB_y + n + _CDB_h - _CDB_yo, 0, n2);
            return;
        }
        if (n > 0) {
            Map._CDB_findYRegion(_CDB_y + _CDB_h, n2, n);
        } else {
            Map._CDB_findYRegion(_CDB_y + n, n2 + n, -n);
        }
    }

    public static void _CDB_findYRegion(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        Map._CDB_addRegion(_CDB_x, n, _CDB_xo, n2, _CDB_w - _CDB_xo, n3);
        if (_CDB_xo != 0) {
            Map._CDB_addRegion(_CDB_x + (_CDB_w - _CDB_xo), n, 0, n2, _CDB_xo, n3);
        }
    }

    public static void _CDB_addRegion(int n, int n2, int n3, int n4, int n5, int n6) {
        Region region = new Region();
        region.x = (short)n;
        region.y = (short)n2;
        region.xo = (short)n3;
        region.yo = (short)n4;
        region.w = (short)n5;
        region.h = (short)n6;
        Map._CDB_regions[Map._CDB_nrRegions++] = region;
    }

    public static void _CDB_update(int n, int n2) {
        int n3;
        _CDB_separator = 0;
        if (_bResetCDB) {
            Map._CDB_init(n, n2);
            _bResetCDB = false;
            return;
        }
        Map.clearRegions();
        _CDB_nrRegions = 0;
        int n4 = n - _CDB_oldX;
        if (n4 <= -_CDB_w || n4 >= _CDB_w) {
            Map._CDB_init(n, n2);
            return;
        }
        if (n4 != 0) {
            Map._CDB_moveX(n4);
        }
        _CDB_x = n;
        _CDB_oldX = n;
        if (_CDB_separator != -1) {
            _CDB_separator = _CDB_nrRegions;
        }
        if ((n3 = n2 - _CDB_oldY) <= -_CDB_h || n3 >= _CDB_h) {
            Map._CDB_init(n, n2);
            return;
        }
        if (n3 != 0) {
            Map._CDB_moveY(n3);
        }
        _CDB_y = n2;
        _CDB_oldY = n2;
    }

    public static void _CDB_blitToScreen(SDKGraphics sDKGraphics) {
        if (_CDB_w - _CDB_xo != 0) {
            if (_CDB_h - _CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, _CDB_xo, _CDB_yo, _CDB_w - _CDB_xo, _CDB_h - _CDB_yo, 0, 0, 0, 20);
            }
            if (_CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, _CDB_xo, 0, _CDB_w - _CDB_xo, _CDB_yo, 0, 0, _CDB_h - _CDB_yo + 0, 20);
            }
        }
        if (_CDB_xo != 0) {
            if (_CDB_h - _CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, 0, _CDB_yo, _CDB_xo, _CDB_h - _CDB_yo, 0, _CDB_w - _CDB_xo + 0, 0, 20);
            }
            if (_CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, 0, 0, _CDB_xo, _CDB_yo, 0, _CDB_w - _CDB_xo + 0, _CDB_h - _CDB_yo + 0, 20);
            }
        }
    }

    static void LoadCollisionMap(int n) {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            sDKInputStream.readShort();
            sDKInputStream.readShort();
            _coll_map_tw = sDKInputStream.readShort();
            _coll_map_th = sDKInputStream.readShort();
            _coll_map_size = _coll_map_tw * _coll_map_th;
            _coll_map = new byte[_coll_map_size << 2 >> 3];
            int n2 = 0;
            for (int i = 0; i < _coll_map_th; ++i) {
                boolean bl = true;
                for (int j = 0; j < _coll_map_tw; ++j) {
                    if (bl) {
                        n2 = sDKInputStream.read();
                    }
                    bl = !bl;
                    int n3 = n2 & 0xF;
                    int n4 = i * _coll_map_tw + j << 2;
                    int n5 = n4 >> 3;
                    int n6 = n4 & 7;
                    int n7 = n5;
                    _coll_map[n7] = (byte)(_coll_map[n7] + (byte)(n3 << n6));
                    n2 >>= 4;
                }
            }
            sDKInputStream.close();
            _coll_map_w = _coll_map_tw * collision_tile_w;
            _coll_map_h = _coll_map_th * collision_tile_h;
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadCollisionMap:", exception);
        }
    }

    static int getCollisionAt(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= _coll_map_w || n2 >= _coll_map_h) {
            return 2;
        }
        return Map.getCollision(n2 / collision_tile_w * _coll_map_tw + n / collision_tile_h);
    }

    static int getCollision(int n) {
        int n2 = n << 2 >> 3;
        int n3 = n << 2 & 7;
        return _coll_map[n2] >> n3 & 0xF;
    }

    static void setCollision(int n, int n2) {
        int n3 = n << 2 >> 3;
        int n4 = n << 2 & 7;
        int n5 = n3;
        _coll_map[n5] = (byte)(_coll_map[n5] & ~(15 << n4));
        int n6 = n3;
        _coll_map[n6] = (byte)(_coll_map[n6] | (n2 & 0xF) << n4);
    }

    static void setCollisionAt(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= _coll_map_w || n2 >= _coll_map_h) {
            return;
        }
        Map.setCollision(n2 / collision_tile_w * _coll_map_tw + n / collision_tile_h, n3);
    }

    static void DrawCollisions(SDKGraphics sDKGraphics) {
        int n;
        for (n = 0; n < _coll_map_th; ++n) {
            for (int i = 0; i < _coll_map_tw; ++i) {
                int n2 = Map.getCollisionAt(i * collision_tile_h, n * collision_tile_w);
                switch (n2) {
                    case 0: {
                        sDKGraphics.setColor(65280);
                        break;
                    }
                    case 1: {
                        sDKGraphics.setColor(0xFF0000);
                        break;
                    }
                    case 2: {
                        sDKGraphics.setColor(0xFFFF00);
                        break;
                    }
                    case 3: {
                        sDKGraphics.setColor(255);
                    }
                }
                if (n2 == 15) continue;
                sDKGraphics.drawRect(i * collision_tile_h - Camera.posX, n * collision_tile_w - Camera.posY, collision_tile_h, collision_tile_w);
            }
        }
        sDKGraphics.setColor(255);
        for (n = 0; n < PathFinder.pathSize; ++n) {
            sDKGraphics.drawRect(PathFinder.resultPathX[n] * collision_tile_w - Camera.posX, PathFinder.resultPathY[n] * collision_tile_h - Camera.posY, collision_tile_w, collision_tile_h);
        }
    }

    public static void clearRegions() {
        if (_CDB_regions != null) {
            for (int i = 0; i < _CDB_regions.length; ++i) {
                if (_CDB_regions[i] == null) continue;
                Map._CDB_regions[i] = null;
            }
        }
    }

    static {
        useLights = false;
        fillTile = false;
        useSmallCDB = false;
        _currentTileSet = -1;
        _CDB_regions = new Region[24];
    }
}

