/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.AlliedCharacter;
import com.ea.game.AnimatedEntity;
import com.ea.game.Animator;
import com.ea.game.BinarySerializer;
import com.ea.game.Camera;
import com.ea.game.Character;
import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.Enemy;
import com.ea.game.Entity;
import com.ea.game.IStringConstants;
import com.ea.game.Machinegun;
import com.ea.game.Map;
import com.ea.game.Menu;
import com.ea.game.Objective;
import com.ea.game.PathFinder;
import com.ea.game.SpriteConstants;
import com.ea.game.Target;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.ResourceLoader;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKMoreGames;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import com.ea.vm.XSVMUInvokeInterface;
import com.ea.vm.XScriptVirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class GameImpl
implements SDKGame,
ResourceLoader,
Constants,
IStringConstants,
XSVMUInvokeInterface,
SpriteConstants,
Constants.GameStates {
    public static byte playState;
    public static byte savedPlayState;
    public static byte gameMode;
    public static Character player;
    public static Enemy[] enemies;
    public static byte[] areaEnemies;
    public static int areaEnemiesFrames;
    public static int areaCamX;
    public static int areaCamY;
    public static AlliedCharacter[] allies;
    public static Entity[] entities;
    public static Entity[] triggers;
    public static Machinegun[] machineguns;
    public static AnimatedEntity[] barracks;
    public static AnimatedEntity[] hidingPlaces;
    public static AnimatedEntity[] explodables;
    public static Entity[] enemyClasses;
    public static Entity[] weaponClasses;
    public static Entity[] crateClasses;
    public static Vector tempEntities;
    public static int numEnemies;
    public static int numAreaEnemies;
    public static int numEntities;
    public static int numAllies;
    public static int numTriggers;
    public static int numBarracks;
    public static int numHidingPlaces;
    public static int numExplodables;
    public static int numMachineguns;
    public static int numWeponClasses;
    public static int numCrateClasses;
    public static int cameraLastPOrientation;
    public static int cameraLastPState;
    public static int cameraFrameCounter;
    static int numStaticDecorators;
    static int[] destructibleDecorators;
    static short[] staticDecoratorEosOrder;
    static int numNodes;
    static short[] kdIndices;
    static int[] kdChildren;
    static int[] staticDecoratorPos;
    static int[] staticDecoratorData;
    static Animator[] decoratorsAnim;
    static int[] decoratorsAnimID;
    static short[] staticDecoratorIds;
    static int[] fixedWeights;
    static int[] fixedIdx;
    static int fixedCount;
    static int dynamicCount;
    static int[] dynamicWeights;
    static int[] dynamicIdx;
    static int[] rectScreen;
    static int[] rectClip;
    static int[] rectTemp;
    static boolean findBackgroundDecorators;
    public static boolean runEnemyAI;
    public static boolean raceLevel;
    public static int raceStartMessage;
    public static int raceTime;
    public static long raceLastUpdateTime;
    public static boolean scopeDraw;
    public static int sniperMsgLenght;
    public static int sniperMsgPos;
    public static int sniperMsgInc;
    public static int sniperMsgLenght2;
    public static int sniperMsgPos2;
    public static int sniperMsgInc2;
    public static AlliedCharacter protectedAllied;
    public static Enemy enemySniperTarget;
    public static int[] sniperMessages;
    public static final int[] sniperReboundPositions;
    public static int sniperReboundCounter;
    public static int sniperBulletTimeCounter;
    public static boolean sniperScopeOn;
    public static int sniperScopeOutCounter;
    public static boolean sniperGoingOut;
    public static final int[][] sniperScopeOutPositions;
    public static int sniperCoolDownTimer;
    public static int sniperScopeSpeed;
    public static int currentMaxUnlockedLevel;
    public static int currentLanguage;
    public static int state;
    public static int levelType;
    public static boolean showUI;
    public static int transitionToState;
    public static boolean isTransitionToGameState;
    static final int[] tileSets;
    public static SDKMoreGames mgInstance;
    public static SDKSoundManager soundManager;
    public static XScriptVirtualMachine vm;
    public static Object[] fonts;
    public static SDKString string;
    public static SDKString stringBuffer;
    public static short[] wrapOffsets;
    public static Entity cameraTarget;
    public static int numLangsLoaded;
    public static int spriteToLoad;
    public static int[][][] scriptsList;
    public static int[][] levels;
    public static int currentLevel;
    public static long frames;
    public static int loadingAnimState;
    public static long loadingAnimTime;
    public static boolean pGodMode;
    public static boolean godMode;
    public static boolean postponeEndLevel;
    public static boolean postponeChangeLevelMode;
    public static boolean forceCinematicBars;
    public static int continueNextLevel;
    public static int standbyTimer;
    public static int postponedTransition;
    public static int cinematicBarHeight;
    public static int saveTimer;
    public static short[] hudModel;
    public static boolean hudChangeToNextWeapon;
    public static long hudChangeToNextWeaponStartFrame;
    public static Animator hudAnimator;
    public static Animator writingAnimator;
    public static SDKString[] bombingHudFakeCodes;
    public static Menu menu;
    public static int loadingPercent;
    public static int loadingAnimOffset;
    public static int loadState;
    public static int loadLevelState;
    public static int briefingPage;
    public static boolean skipBriefing;
    public static int currentDialogTextID;
    public static int currentDialogTitleID;
    public static short dialogHeight;
    public static short dialogWidth;
    public static short dialogTitleWidth;
    public static short dialogTitleHeight;
    public static short dialogOffsetY;
    public static short dialogPositionX;
    public static short dialogTitlePositionY;
    public static short dialogTitlePositionX;
    public static byte dialogMode;
    public static short dialogImagePosX;
    public static short dialogImagePosY;
    public static boolean msgSkip;
    public static short tutorialBoxX;
    public static short tutorialBoxY;
    public static short tutorialText;
    public static byte tutorialPhase;
    public static int previousCameraPosX;
    public static int previousCameraPosY;
    public static short objTitle;
    public static short objText;
    public static short objTimer;
    public static boolean displayHints;
    static XSprite[] sprites;
    static int[][] sprInfo;
    static int[][] sprLevelInfo;
    static int[] deltaSpritePalettes;
    public static boolean hideTarget;
    public static int[] bombingPath;
    public static int[] bombingTargets;
    public static int targetX;
    public static int targetY;
    public static int[] bombingTargetsAnims;
    public static byte[] bombingTargetsFlags;
    public static int bombingPathIdx;
    public static int bombingSkipScript;
    public static int numBombs;
    public static int[] firedBombs;
    public static int numFiredBombs;
    public static int numTargetsDestroyed;
    public static int bombingRunBombArea;
    public static int bombingRunBombDamage;
    public static long splashDisplayTime;
    private static SDKImage splashEA;
    public static boolean fadingFinished;
    public static boolean faded;
    public static Objective[] objectives;
    public static int numObjectives;
    public static int currentObjective;
    public static int objectiveOrientation;
    public static boolean objectiveShowMsg;
    public static int currentConsecutiveHeadshots;
    public static int currentConsecutiveStealthKills;
    public static int currentGrenadeKillCount;
    public static int currentBombKillCount;
    public static int sniperKillCount;
    public static int pistolKillCount;
    public static int machinegunKillCount;
    public static boolean shouldCheckAchievements;
    public static boolean[] achievementCompleted;
    public static boolean[] beforeLevelAchievementCompleted;
    public static boolean[] continueAchievementCompleted;
    public static int[] achievementName;
    public static int lastCompletedAchievementIDX;
    public static long achievementDisplayTime;
    public static int achievementCount;
    public static int endLevelAchievementsPage;
    public static int endLevelAchievementsCounter;
    public static byte[] saveData;
    public static byte[] saveDataPart;
    public static int saveCursor;
    public static int saveCursor2;
    public static int saveCountPosition;
    public static int saveCount;
    public static int numDestroyedCollisions;
    public static int numLoadedEnemies;
    public static short[] destroyedCollisionsPosX;
    public static short[] destroyedCollisionsPosY;
    public static int playAreaLeftLimit;
    public static int playAreaRightLimit;
    public static int playAreaTopLimit;
    public static int playAreaBottomLimit;
    public static final int[][] MAP_KP_ORIENTATION;
    public static final int[] X_ORIENTATION_FACTOR;
    public static final int[] Y_ORIENTATION_FACTOR;
    public static final int[][] CAMERA_OFFSET;
    public static int[] GRENADE_FRAME_ORIENTATION_MAPPING;
    public static int[] BULLET_DUST_ANIM;
    public static int[] WEAPON_TYPE_HUD_MAPPING;
    public static int[] X_ORIENTATION_DX_FACTOR;
    public static int[] Y_ORIENTATION_DY_FACTOR;
    public static SDKImage[] imgs_font_mg;
    private static SDKImage[] imgs_font_cool;
    private static long lastHealthLootTime;
    private static long lastAmmoLootTime;
    public static int cutSceneScript;
    public static int skipSceneScript;
    public static SDKImage dImg;
    public static boolean bCleanMemory;
    static int currentSpriteToLoad;
    public static final int[] SHOTGUN_LEFT_LINE_OFFSET_X;
    public static final int[] SHOTGUN_RIGHT_LINE_OFFSET_X;
    public static final int[] SHOTGUN_LEFT_LINE_OFFSET_Y;
    public static final int[] SHOTGUN_RIGHT_LINE_OFFSET_Y;
    public static boolean bSetStateMenu;
    private static final int[] dialogPercentages;
    private static int dialogFrame;
    static boolean[] soundsLoaded;
    public static boolean machineGunPlaying;

    public GameImpl(SDKCanvas sDKCanvas) {
    }

    public void init() {
        Object object;
        int n;
        targetX = 40960;
        targetY = 30720;
        objTimer = (short)-1;
        fonts = new Object[4];
        for (n = 0; n < 4; ++n) {
            GameImpl.fonts[n] = null;
        }
        mgInstance = new SDKMoreGames(320, 240);
        soundManager = SDKSoundManager.getManager();
        soundManager.setLoader(this);
        soundManager.setPlaybackType(1);
        menu = new Menu(1);
        sprites = new XSprite[20];
        hudAnimator = new Animator();
        n = 0;
        byte[] byArray = new byte[1024];
        try {
            object = this.getClass().getResourceAsStream("/hdr1");
            ((InputStream)object).read(byArray);
            ((InputStream)object).close();
            object = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        numLangsLoaded = SDKUtils.loadTextHeader(byArray);
        SDKUtils.loadStringsChunk(1);
        object = SDKInputStream.loadResourceAsByteArray(280);
        n += ((Object)object).length;
        int[] nArray = new int[]{-1, 282};
        imgs_font_mg = SDKInputStream.loadImageObjectWithPalette(281, nArray);
        GameImpl.fonts[0] = SDKUtils.loadFont(imgs_font_mg[0], (byte[])object);
        GameImpl.fonts[1] = SDKUtils.loadFont(imgs_font_mg[1], (byte[])object);
        SDKInputStream.purgeCache();
        Menu.isContinueEnabled = !SDKUtils.isRecordEmpty(1) || continueNextLevel != -1;
        saveDataPart = null;
        if (SDKUtils.isRecordEmpty(0)) {
            int n2 = SDKUtils.chooseLanguage(-1);
            if (n2 < 0) {
                GameImpl.setState(9);
            } else {
                SDKUtils.setCurrentLanguage(n2);
                GameImpl.setState(5);
            }
        } else {
            GameImpl.loadSettings();
            if (currentLanguage < 0) {
                GameImpl.setState(9);
            } else {
                SDKUtils.setCurrentLanguage(currentLanguage);
                GameImpl.setState(5);
            }
        }
        SDKUtils.setFont(fonts[0]);
        savedPlayState = 0;
        forceCinematicBars = false;
        dImg = SDKUtils.createImage(320, 240);
    }

    public static void initData() {
    }

    public static void cleanStructures() {
    }

    public static void cleanDecorators() {
        kdIndices = null;
        kdChildren = null;
    }

    public static void cleanMemory() {
        int n;
        if (player != null) {
            player = null;
        }
        if (enemies != null) {
            for (n = 0; n < 89; ++n) {
                if (enemies[n] == null) continue;
                GameImpl.enemies[n] = null;
            }
            enemies = null;
        }
        if (enemyClasses != null) {
            for (n = 0; n < 14; ++n) {
                if (enemyClasses[n] == null) continue;
                GameImpl.enemyClasses[n] = null;
            }
            enemyClasses = null;
        }
        if (weaponClasses != null) {
            for (n = 0; n < 5; ++n) {
                if (weaponClasses[n] == null) continue;
                GameImpl.weaponClasses[n] = null;
            }
            weaponClasses = null;
        }
        if (crateClasses != null) {
            for (n = 0; n < 5; ++n) {
                if (crateClasses[n] == null) continue;
                GameImpl.crateClasses[n] = null;
            }
            crateClasses = null;
        }
        if (triggers != null) {
            for (n = 0; n < 24; ++n) {
                if (triggers[n] == null) continue;
                GameImpl.triggers[n] = null;
            }
            triggers = null;
        }
        if (barracks != null) {
            for (n = 0; n < 5; ++n) {
                if (barracks[n] == null) continue;
                GameImpl.barracks[n] = null;
            }
            barracks = null;
        }
        if (machineguns != null) {
            for (n = 0; n < 16; ++n) {
                if (machineguns[n] == null) continue;
                GameImpl.machineguns[n] = null;
            }
            machineguns = null;
        }
        if (entities != null) {
            for (n = 0; n < 16; ++n) {
                if (entities[n] == null) continue;
                GameImpl.entities[n] = null;
            }
            entities = null;
        }
        if (tempEntities != null) {
            n = -1;
            while (++n < tempEntities.size()) {
                tempEntities.removeElementAt(n);
            }
            tempEntities = null;
        }
        if (allies != null) {
            for (n = 0; n < 23; ++n) {
                if (allies[n] == null) continue;
                GameImpl.allies[n] = null;
            }
            allies = null;
        }
        if (hidingPlaces != null) {
            for (n = 0; n < 8; ++n) {
                if (hidingPlaces[n] == null) continue;
                GameImpl.hidingPlaces[n] = null;
            }
            hidingPlaces = null;
        }
        if (explodables != null) {
            for (n = 0; n < 8; ++n) {
                if (explodables[n] == null) continue;
                GameImpl.explodables[n] = null;
            }
            explodables = null;
        }
        if (areaEnemies != null) {
            areaEnemies = null;
        }
        if (objectives != null) {
            for (n = 0; n < 8; ++n) {
                if (objectives[n] == null) continue;
                GameImpl.objectives[n] = null;
            }
            objectives = null;
        }
        Map.clearRegions();
        Map._CDB_regions = null;
        Map._tilePalette = null;
        Map._map = null;
        Map._coll_map = null;
        Map._imgBB = null;
        Map._CDB_regions = null;
        Map._gBB = null;
        System.gc();
    }

    private void doGameLoading() {
        try {
            switch (loadLevelState) {
                case 0: {
                    int n;
                    GameImpl.sprites[13] = null;
                    GameImpl.fonts[3] = null;
                    GameImpl.fonts[2] = null;
                    this.unloadSounds();
                    System.gc();
                    GameImpl.tickLoading(50000);
                    vm.unloadEverything();
                    vm.deleteAllInstances();
                    GameImpl.clean();
                    for (n = 0; n < scriptsList[0].length; ++n) {
                        vm.loadScript(scriptsList[0][n][0]);
                    }
                    n = currentLevel + 1;
                    if (scriptsList[n] != null) {
                        for (int i = 0; i < scriptsList[n].length; ++i) {
                            vm.loadScript(scriptsList[n][i][0]);
                        }
                    }
                    SDKInputStream.purgeCache();
                    GameImpl.tickLoading(150000);
                    break;
                }
                case 1: {
                    int n;
                    staticDecoratorData = new int[1153];
                    for (n = 0; n < staticDecoratorData.length; ++n) {
                        GameImpl.staticDecoratorData[n] = 0;
                    }
                    staticDecoratorPos = new int[1153];
                    for (n = 0; n < staticDecoratorData.length; ++n) {
                        GameImpl.staticDecoratorPos[n] = 0;
                    }
                    for (n = 0; n < decoratorsAnim.length; ++n) {
                        GameImpl.decoratorsAnim[n] = null;
                    }
                    GameImpl.cleanMemory();
                    numStaticDecorators = 0;
                    enemies = new Enemy[89];
                    areaEnemies = new byte[25];
                    numEnemies = 0;
                    numDestroyedCollisions = 0;
                    enemyClasses = new Entity[14];
                    weaponClasses = new Entity[5];
                    crateClasses = new Entity[5];
                    numWeponClasses = 0;
                    numCrateClasses = 0;
                    triggers = new Entity[24];
                    numTriggers = 0;
                    barracks = new AnimatedEntity[5];
                    numBarracks = 0;
                    hidingPlaces = new AnimatedEntity[8];
                    for (n = 0; n < 8; ++n) {
                        GameImpl.hidingPlaces[n] = null;
                    }
                    numHidingPlaces = 0;
                    explodables = new AnimatedEntity[8];
                    for (n = 0; n < 8; ++n) {
                        GameImpl.explodables[n] = null;
                    }
                    numExplodables = 0;
                    machineguns = new Machinegun[16];
                    numMachineguns = 0;
                    entities = new Entity[16];
                    allies = new AlliedCharacter[23];
                    numAllies = 0;
                    numEntities = 0;
                    objectives = new Objective[8];
                    numObjectives = 0;
                    currentObjective = -1;
                    forceCinematicBars = false;
                    tempEntities = new Vector();
                    GameImpl.initData();
                    GameImpl.tickLoading(50000);
                    break;
                }
                case 2: {
                    GameImpl.cleanSprites();
                    GameImpl.tickLoading(50000);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    int n = sprLevelInfo[gameMode].length / 5;
                    int n2 = currentSpriteToLoad;
                    while (n2 < sprLevelInfo[gameMode].length) {
                        if (n >= 0) {
                            ++currentSpriteToLoad;
                            GameImpl.loadSprite(sprLevelInfo[gameMode][n2]);
                            GameImpl.tickLoading(50000);
                            SDKInputStream.purgeCache();
                            --n;
                        }
                        ++n2;
                    }
                    break;
                }
                case 8: {
                    Map.Init();
                    GameImpl.loadEntities(239);
                    SDKInputStream.purgeCache();
                    GameImpl.tickLoading(50000);
                    GameImpl.loadEntities(levels[currentLevel][2]);
                    SDKInputStream.purgeCache();
                    GameImpl.tickLoading(50000);
                    Map.LoadCollisionMap(levels[currentLevel][0]);
                    SDKInputStream.purgeCache();
                    GameImpl.tickLoading(50000);
                    Map.LoadTileMap(levels[currentLevel][1]);
                    SDKInputStream.purgeCache();
                    GameImpl.tickLoading(50000);
                    for (int i = 0; i < numEnemies; ++i) {
                        enemies[i].setCoverState(GameImpl.canCover(GameImpl.enemies[i].posX >> 8, GameImpl.enemies[i].posY >> 8, GameImpl.enemies[i].orientation, GameImpl.enemies[i].isCovered));
                    }
                    System.out.println("currentLevel : " + currentLevel);
                    System.out.println("numStaticDecorators : " + numStaticDecorators);
                    System.out.println("numEnemies : " + numEnemies);
                    System.out.println("numBarracks : " + numBarracks);
                    System.out.println("numMachineguns : " + numMachineguns);
                    System.out.println("numHidingPlaces : " + numHidingPlaces);
                    System.out.println("numTriggers : " + numTriggers);
                    System.out.println("numEntities : " + numEntities);
                    System.out.println("numObjectives : " + numObjectives);
                    System.out.println("numAllies : " + numAllies);
                    System.out.println("numCrateClasses : " + numCrateClasses);
                    System.out.println("levelType : " + levelType);
                    if (levelType == 1) {
                        Map.fillTile = true;
                        sprites[6].SetCurrentPalette(1);
                        sprites[1].SetCurrentPalette(1);
                        sprites[16].SetCurrentPalette(0);
                        break;
                    }
                    if (levelType == 2) {
                        sprites[6].SetCurrentPalette(2);
                        sprites[1].SetCurrentPalette(2);
                        sprites[16].SetCurrentPalette(1);
                        break;
                    }
                    sprites[6].SetCurrentPalette(0);
                    sprites[1].SetCurrentPalette(0);
                    sprites[16].SetCurrentPalette(0);
                    break;
                }
                case 9: {
                    PathFinder.Init(Map._coll_map_tw, Map._coll_map_th, Map._coll_map);
                    Map.InitBackBuffer();
                    break;
                }
                case 10: {
                    numLoadedEnemies = numEnemies;
                    GameImpl.loadLevel();
                    if (gameMode == 2) {
                        playAreaBottomLimit = -1;
                        playAreaLeftLimit = -1;
                        playAreaRightLimit = -1;
                        playAreaTopLimit = -1;
                    }
                    GameImpl.loadSounds();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ++loadLevelState;
        System.gc();
    }

    public static void initGame() {
        int n;
        showUI = true;
        cameraTarget = null;
        shouldCheckAchievements = false;
        lastCompletedAchievementIDX = -1;
        achievementDisplayTime = -1L;
        lastAmmoLootTime = 0L;
        godMode = false;
        saveTimer = 0;
        for (n = 0; n < numEnemies; ++n) {
            enemies[n].init();
        }
        writingAnimator = new Animator();
        GameImpl.writingAnimator._sprite = 15;
        writingAnimator.SetCrtAnim(3);
        switch (gameMode) {
            case 2: {
                for (n = 0; n < sniperMessages.length; ++n) {
                    GameImpl.sniperMessages[n] = -1;
                }
                GameImpl.scaleWorldPositions();
                GameImpl.initbombingHudFakeCodes();
                Camera.setCenter(bombingPath[0], bombingPath[1]);
                break;
            }
            case 3: {
                for (n = 0; n < sniperMessages.length; ++n) {
                    GameImpl.sniperMessages[n] = -1;
                }
                sniperScopeOn = false;
                sniperGoingOut = false;
                sniperScopeOutCounter = -1;
                enemySniperTarget = null;
                if (Utils.isFlagSet(levels[currentLevel][6], 4)) {
                    protectedAllied = null;
                    for (n = 0; n < numAllies; ++n) {
                        allies[n].init();
                    }
                    Camera.setCenter(56960, 380032);
                } else {
                    protectedAllied = allies[0];
                    protectedAllied.init();
                    Camera.setCenter(GameImpl.protectedAllied.posX, GameImpl.protectedAllied.posY);
                }
                sniperBulletTimeCounter = 0;
                sniperReboundCounter = sniperReboundPositions.length;
                break;
            }
            default: {
                player.init();
                for (n = 0; n < numAllies; ++n) {
                    allies[n].init();
                }
                Camera.setCenter(GameImpl.player.posX, GameImpl.player.posY);
            }
        }
        frames = 0L;
        hudChangeToNextWeapon = false;
        numFiredBombs = 0;
        numTargetsDestroyed = 0;
        objectiveOrientation = 16;
        GameImpl.initKDTree();
        GameImpl.setState(1);
        switch (gameMode) {
            case 2: 
            case 3: {
                XSprite.setTempDrawScaled(true);
                break;
            }
            case 1: {
                XSprite.setTempDrawScaled(false);
            }
        }
        Map._bResetCDB = true;
        Map.CDB_Update();
        XSprite.restoreDrawScaled();
        GameImpl.constructVisibleEnemies();
        bombingSkipScript = -1;
        cutSceneScript = -1;
        skipSceneScript = -1;
        SDKCanvas.disableInput(0);
        GameImpl.fadeInToPlayState(0);
        if (currentLevel == 2 && gameMode == 1) {
            GameImpl.fadeInToPlayState(1);
        } else {
            GameImpl.fadeInToPlayState(0);
        }
    }

    public void loadData() {
        SDKInputStream sDKInputStream;
        switch (loadState) {
            case 1: {
                Object[] objectArray;
                GameImpl.tickLoading(50000);
                byte[] byArray = new byte[1024];
                try {
                    objectArray = this.getClass().getResourceAsStream("/moregames");
                    objectArray.read(byArray);
                    objectArray.close();
                    objectArray = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                mgInstance.setProductData(byArray);
                objectArray = new Object[5];
                objectArray[0] = fonts[0];
                objectArray[2] = fonts[1];
                objectArray[3] = fonts[0];
                objectArray[4] = fonts[1];
                objectArray[1] = fonts[0];
                mgInstance.setFonts(objectArray);
                Debug.setFont(fonts[0]);
                imgs_font_mg = null;
                ++loadState;
                GameImpl.tickLoading(50000);
                break;
            }
            case 2: {
                GameImpl.loadSounds();
                ++loadState;
                GameImpl.tickLoading(5000);
                break;
            }
            case 3: {
                try {
                    sDKInputStream = new SDKInputStream(12);
                    Menu.MAIN_MENU_ITEMS = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Menu.PAUSE_MENU_ITEMS = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Menu.OPTIONS_MENU_ITEMS = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    sDKInputStream.close();
                    SDKInputStream.purgeCache();
                    GameImpl.tickLoading(50000);
                    sDKInputStream = new SDKInputStream(13);
                    Character.F_DAMAGE_SOURCE = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.F_SHOTGUN_DAMAGE_AREA = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_JUMP_OVER_COVER = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_PUT_WEAPON_DOWN = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_BROWSING = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_BASE_STAND = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_BASE_RUN = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_BASE_AIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_BASE_COVER_AIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_BASE_COVER_STAND = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_BASE_COVER_RUN = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_IDLE = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_RUN = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_MACHINEGUN_SHOOT = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_DELTA_ANIM_DIE_RIFLE_BURST = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_DELTA_ANIM_DIE_RIFLE = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_DELTA_ANIM_DIE_EXPLOSION = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_RELOAD = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_COVER_RELOAD = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_AIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_COVER_AIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_SHOOT = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_COVER_SHOOT = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    GameImpl.tickLoading(50000);
                    Character.A_TURRET_SHOTGUN_AIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_SHOTGUN_COVER_AIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_SHOTGUN_SHOOT = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_SHOTGUN_COVER_SHOOT = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_SHOTGUN_RELOAD = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_SHOTGUN_COVER_RELOAD = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_GUN_AIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_GUN_COVER_AIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_GUN_SHOOT = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_GUN_COVER_SHOOT = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_GUN_RELOAD = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_GUN_COVER_RELOAD = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_GRENADE_AIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_GRENADE_COVER_AIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_GRENADE_SHOOT = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_TURRET_GRENADE_COVER_SHOOT = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_STEALTH_KILL = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_STEALTH_COMBO_KILL = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.A_SLIDE_IN_COVER = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Character.F_SELECTION_PLAYER = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Enemy.A_ENEMY_DIE_RIFLE_BURST = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Enemy.A_ENEMY_RIFLE_BURST = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Enemy.A_ENEMY_ALERT = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Enemy.A_ENEMY_NOTICE = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    sDKInputStream.close();
                    SDKInputStream.purgeCache();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ++loadState;
                GameImpl.tickLoading(5000);
                break;
            }
            case 4: {
                try {
                    sDKInputStream = new SDKInputStream(14);
                    destructibleDecorators = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    scriptsList = BinarySerializer.BS_ReadIntArray(sDKInputStream, (int[][][])null);
                    levels = BinarySerializer.BS_ReadIntArray(sDKInputStream, (int[][])null);
                    GRENADE_FRAME_ORIENTATION_MAPPING = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    BULLET_DUST_ANIM = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Machinegun.X_GUNNER_MACHINEGUN_OFFSET = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Machinegun.Y_GUNNER_MACHINEGUN_OFFSET = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    WEAPON_TYPE_HUD_MAPPING = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    X_ORIENTATION_DX_FACTOR = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    Y_ORIENTATION_DY_FACTOR = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                    sDKInputStream.close();
                    SDKInputStream.purgeCache();
                    GameImpl.tickLoading(50000);
                    achievementCount = 18 + levels.length;
                    achievementCompleted = new boolean[achievementCount];
                    beforeLevelAchievementCompleted = new boolean[achievementCount];
                    continueAchievementCompleted = new boolean[achievementCount];
                    achievementName = new int[achievementCount];
                    GameImpl.achievementName[0] = 27;
                    GameImpl.achievementName[1] = 28;
                    GameImpl.achievementName[2] = 29;
                    GameImpl.achievementName[3] = 30;
                    GameImpl.achievementName[4] = 31;
                    GameImpl.achievementName[5] = 32;
                    GameImpl.achievementName[6] = 33;
                    GameImpl.achievementName[7] = 34;
                    GameImpl.achievementName[8] = 35;
                    GameImpl.achievementName[9] = 36;
                    GameImpl.achievementName[10] = 43;
                    GameImpl.achievementName[11] = 44;
                    GameImpl.achievementName[12] = 45;
                    GameImpl.achievementName[13] = 38;
                    GameImpl.achievementName[14] = 39;
                    GameImpl.achievementName[15] = 41;
                    GameImpl.achievementName[16] = 42;
                    GameImpl.achievementName[17] = 290;
                    for (int i = 18; i < achievementCount; ++i) {
                        GameImpl.achievementName[i] = 217;
                    }
                    GameImpl.loadAchievements();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++loadState;
                GameImpl.tickLoading(50000);
                break;
            }
            case 5: {
                vm = new XScriptVirtualMachine();
                vm.registerUserFunctions(this);
                System.gc();
                GameImpl.tickLoading(50000);
                ++loadState;
                break;
            }
            case 6: {
                switch (spriteToLoad) {
                    case -1: {
                        try {
                            sDKInputStream = new SDKInputStream(15);
                            sprInfo = BinarySerializer.BS_ReadIntArray(sDKInputStream, (int[][])null);
                            deltaSpritePalettes = BinarySerializer.BS_ReadIntArray(sDKInputStream, sDKInputStream.readShort(), null, 0);
                            sprLevelInfo = BinarySerializer.BS_ReadIntArray(sDKInputStream, (int[][])null);
                            sDKInputStream.close();
                            SDKInputStream.purgeCache();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        GameImpl.tickLoading(50000);
                        break;
                    }
                    default: {
                        try {
                            GameImpl.loadSprite(sprLevelInfo[0][spriteToLoad]);
                            SDKInputStream.purgeCache();
                            GameImpl.tickLoading(100000);
                            break;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                if (++spriteToLoad < sprLevelInfo[0].length) break;
                ++loadState;
                break;
            }
            default: {
                ++loadState;
            }
        }
        if (loadState >= 7) {
            loadingPercent = 100;
            sDKInputStream = null;
            SDKInputStream.purgeCache();
        }
    }

    public static void tickLoading(int n) {
        if ((loadingPercent += n * 100 / 1000000) > 100) {
            loadingPercent = 100;
        }
    }

    private static void loadEntities(int n) {
        int n2 = 0;
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            block22: while (sDKInputStream.available() != 0) {
                int n3 = sDKInputStream.read() & 0xFF;
                if (n2++ % 400 == 0) {
                    GameImpl.tickLoading(50000);
                }
                switch (n3) {
                    case 1: 
                    case 8: {
                        GameImpl.staticDecoratorIds[GameImpl.numStaticDecorators] = sDKInputStream.readShort();
                        GameImpl.staticDecoratorPos[GameImpl.numStaticDecorators] = sDKInputStream.readShort();
                        int n4 = numStaticDecorators;
                        staticDecoratorPos[n4] = staticDecoratorPos[n4] | sDKInputStream.readShort() << 16;
                        GameImpl.staticDecoratorData[GameImpl.numStaticDecorators] = 0;
                        int n5 = numStaticDecorators;
                        staticDecoratorData[n5] = staticDecoratorData[n5] | sDKInputStream.read() << 0;
                        int n6 = numStaticDecorators;
                        staticDecoratorData[n6] = staticDecoratorData[n6] | sDKInputStream.read() << 8;
                        if (n3 == 8) {
                            int n7 = numStaticDecorators;
                            staticDecoratorData[n7] = staticDecoratorData[n7] | 0x800000;
                            int n8 = numStaticDecorators;
                            staticDecoratorData[n8] = staticDecoratorData[n8] | 0x1000000;
                        } else {
                            int n9 = numStaticDecorators;
                            staticDecoratorData[n9] = staticDecoratorData[n9] | sDKInputStream.read() << 16;
                            int n10 = numStaticDecorators;
                            staticDecoratorData[n10] = staticDecoratorData[n10] | sDKInputStream.read() << 24;
                        }
                        ++numStaticDecorators;
                        break;
                    }
                    case 2: {
                        player = new Character();
                        GameImpl.player.target = new Target(player);
                        player.load(sDKInputStream);
                        break;
                    }
                    case 16: {
                        GameImpl.allies[GameImpl.numAllies] = new AlliedCharacter();
                        GameImpl.allies[GameImpl.numAllies].target = new Target(allies[numAllies]);
                        allies[numAllies++].load(sDKInputStream);
                        break;
                    }
                    case 3: {
                        Entity entity = new Entity(3);
                        entity.load(sDKInputStream);
                        GameImpl.addEnemyClass(entity);
                        break;
                    }
                    case 4: {
                        Enemy enemy = new Enemy();
                        enemy.load(sDKInputStream);
                        GameImpl.addEnemy(enemy);
                        break;
                    }
                    case 5: {
                        int n11 = sDKInputStream.read() & 0xFF;
                        if (player != null) {
                            GameImpl.player.posX = sDKInputStream.readShort() << 8;
                            GameImpl.player.posY = sDKInputStream.readShort() << 8;
                            Camera.setCenter(GameImpl.player.posX, GameImpl.player.posY);
                        } else {
                            Camera.setCenter(sDKInputStream.readShort() << 8, sDKInputStream.readShort() << 8);
                        }
                        levelType = sDKInputStream.read();
                        bombingRunBombArea = sDKInputStream.readShort();
                        bombingRunBombDamage = sDKInputStream.readShort();
                        numBombs = sDKInputStream.read();
                        firedBombs = new int[3 * numBombs];
                        n11 = (byte)sDKInputStream.read();
                        if (player != null) {
                            GameImpl.player.orientation = n11;
                        }
                        raceTime = -1;
                        raceLevel = sDKInputStream.read() == 1;
                        raceStartMessage = sDKInputStream.readShort();
                        break;
                    }
                    case 6: {
                        Entity entity = new Entity(6);
                        entity.load(sDKInputStream);
                        GameImpl.triggers[GameImpl.numTriggers++] = entity;
                        break;
                    }
                    case 24: {
                        Entity entity = new Entity(24);
                        entity.load(sDKInputStream);
                        GameImpl.triggers[GameImpl.numTriggers++] = entity;
                        break;
                    }
                    case 9: {
                        Entity entity = new Entity(9);
                        entity.load(sDKInputStream);
                        GameImpl.addWeaponClas(entity);
                        break;
                    }
                    case 10: {
                        Entity entity = new Entity(10);
                        entity.load(sDKInputStream);
                        GameImpl.addCrateClass(entity);
                        break;
                    }
                    case 11: 
                    case 15: {
                        AnimatedEntity animatedEntity = new AnimatedEntity(n3);
                        animatedEntity.load(sDKInputStream);
                        GameImpl.AddEntity(animatedEntity);
                        break;
                    }
                    case 13: {
                        AnimatedEntity animatedEntity = new AnimatedEntity(13);
                        animatedEntity.load(sDKInputStream);
                        GameImpl.addBarrack(animatedEntity);
                        break;
                    }
                    case 14: {
                        Machinegun machinegun = new Machinegun(14);
                        machinegun.load(sDKInputStream);
                        GameImpl.addMachinegun(machinegun);
                        break;
                    }
                    case 18: {
                        Objective objective = new Objective();
                        objective.load(sDKInputStream);
                        GameImpl.addObjective(objective);
                        break;
                    }
                    case 20: {
                        int n12 = sDKInputStream.read() & 0xFF;
                        bombingPath = new int[n12 << 2];
                        for (int i = 0; i < bombingPath.length >> 2; ++i) {
                            GameImpl.bombingPath[i << 2] = sDKInputStream.readShort() << 8 >> 1;
                            GameImpl.bombingPath[(i << 2) + 1] = sDKInputStream.readShort() << 8 >> 1;
                            GameImpl.bombingPath[(i << 2) + 2] = sDKInputStream.readShort();
                            GameImpl.bombingPath[(i << 2) + 3] = sDKInputStream.readShort();
                            if (i != 0) continue;
                            vm.spawnInstanceByID(bombingPath[3], -1);
                        }
                        bombingPathIdx = 1;
                        break;
                    }
                    case 22: {
                        int n12 = sDKInputStream.read() & 0xFF;
                        if (n12 <= 0) break;
                        bombingTargets = new int[n12 << 1];
                        bombingTargetsAnims = new int[n12 << 1];
                        bombingTargetsFlags = new byte[n12];
                        for (int i = 0; i < bombingTargets.length >> 1; ++i) {
                            GameImpl.bombingTargets[2 * i] = sDKInputStream.readShort() >> 1;
                            GameImpl.bombingTargets[2 * i + 1] = sDKInputStream.readShort() >> 1;
                            GameImpl.bombingTargetsAnims[2 * i] = Utils.random(320) << 8;
                            GameImpl.bombingTargetsAnims[2 * i + 1] = 61440;
                        }
                        continue block22;
                    }
                    case 26: {
                        AnimatedEntity animatedEntity = new AnimatedEntity(n3);
                        animatedEntity.load(sDKInputStream);
                        GameImpl.addHidingPlace(animatedEntity);
                        break;
                    }
                    case 27: {
                        AnimatedEntity animatedEntity = new AnimatedEntity(n3);
                        animatedEntity.load(sDKInputStream);
                        GameImpl.addExplodable(animatedEntity);
                    }
                }
            }
            sDKInputStream.close();
            sDKInputStream = null;
            SDKInputStream.purgeCache();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadSpriteGraphics(XSprite xSprite, int n, int n2) throws IOException {
        int[] nArray = xSprite._index == 0 ? deltaSpritePalettes : (xSprite._index == 1 ? (gameMode == 3 ? new int[]{-1} : new int[]{-1, 22, 23}) : (xSprite._index == 6 ? (gameMode == 3 ? new int[]{-1} : new int[]{-1, 35, 36}) : (xSprite._index == 16 ? (gameMode == 3 ? new int[]{-1} : new int[]{-1, 26}) : (n2 == 0 ? new int[]{-1} : new int[]{-1, n2}))));
        xSprite._images = SDKInputStream.loadImageObjectWithPalette(n, nArray);
    }

    public byte[] loadResource(int n) {
        return SDKInputStream.loadResourceAsByteArray(n);
    }

    public static void loadSpriteData(int n) throws IOException {
        try {
            XSprite xSprite = sprites[n];
            SDKInputStream sDKInputStream = new SDKInputStream(sprInfo[n][0]);
            xSprite.LoadData(sDKInputStream);
            sDKInputStream.close();
            sDKInputStream = null;
            GameImpl.loadSpriteGraphics(xSprite, sprInfo[n][1], sprInfo[n][2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static XSprite loadSprite(int n) throws IOException {
        GameImpl.sprites[n] = new XSprite(n);
        GameImpl.sprites[n].grayPercent = sprInfo[n][3];
        GameImpl.loadSpriteData(n);
        if (gameMode == 2) {
            if (n == 5) {
                sprites[n].scaleImages(true, true);
            } else {
                sprites[n].scaleImages(false, true);
            }
        } else if (gameMode == 3 && n != 11) {
            sprites[n].scaleSniperImages(false, false);
        }
        if (currentLevel == 11) {
            if (n == 6 || n == 1) {
                GameImpl.sprites[n]._images[0] = null;
                GameImpl.sprites[n]._images[2] = null;
            }
            if (n == 16) {
                GameImpl.sprites[n]._images[1] = null;
            }
        } else if (currentLevel == 7 || currentLevel == 8) {
            if (n == 6 || n == 1) {
                GameImpl.sprites[n]._images[0] = null;
                GameImpl.sprites[n]._images[1] = null;
            }
            if (n == 16) {
                GameImpl.sprites[n]._images[0] = null;
            }
        } else {
            if ((n == 6 || n == 1) && gameMode != 3 && gameMode != 2) {
                GameImpl.sprites[n]._images[1] = null;
                GameImpl.sprites[n]._images[2] = null;
            }
            if (n == 16 && gameMode != 3 && gameMode != 2) {
                GameImpl.sprites[n]._images[1] = null;
            }
        }
        GameImpl.sprites[n].gameMode = gameMode;
        return sprites[n];
    }

    public static void addObjective(Objective objective) {
        GameImpl.objectives[GameImpl.numObjectives++] = objective;
    }

    public static void addEnemy(Enemy enemy) {
        GameImpl.enemies[GameImpl.numEnemies++] = enemy;
    }

    private static void addEnemyClass(Entity entity) {
        GameImpl.enemyClasses[entity.id] = entity;
    }

    private static void addWeaponClas(Entity entity) {
        GameImpl.weaponClasses[GameImpl.numWeponClasses++] = entity;
    }

    private static void addCrateClass(Entity entity) {
        GameImpl.crateClasses[GameImpl.numCrateClasses++] = entity;
    }

    public static void AddEntity(Entity entity) {
        GameImpl.entities[GameImpl.numEntities++] = entity;
    }

    public static void addBarrack(AnimatedEntity animatedEntity) {
        GameImpl.barracks[GameImpl.numBarracks++] = animatedEntity;
    }

    public static void addMachinegun(Machinegun machinegun) {
        GameImpl.machineguns[GameImpl.numMachineguns++] = machinegun;
    }

    public static void addHidingPlace(AnimatedEntity animatedEntity) {
        GameImpl.hidingPlaces[GameImpl.numHidingPlaces++] = animatedEntity;
    }

    public static void addExplodable(AnimatedEntity animatedEntity) {
        GameImpl.explodables[GameImpl.numExplodables++] = animatedEntity;
    }

    public void drawSniper(SDKGraphics sDKGraphics) {
        boolean bl;
        boolean bl2 = bl = !sniperScopeOn && (sniperGoingOut && sniperScopeOutCounter < sniperScopeOutPositions.length || !sniperGoingOut && sniperScopeOutCounter >= 0);
        if (sniperScopeOn && !bl) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            scopeDraw = true;
            XSprite.setTempDrawScaled(false);
            sDKGraphics.setClip(0, 0, 320, 240);
            sprites[11].DrawFrame(0, 160, 120, 0);
            XSprite.restoreDrawScaled();
            if (enemySniperTarget != null) {
                n6 = GameImpl.enemySniperTarget.posX - Camera.getCenterX();
                n5 = GameImpl.enemySniperTarget.posY - Camera.getCenterY();
                if (n6 > 70000) {
                    n6 = 70000;
                }
                if (n6 < -70000) {
                    n6 = -70000;
                }
                if (n5 > 70000) {
                    n5 = 70000;
                }
                if (n5 < -70000) {
                    n5 = -70000;
                }
                if ((n4 = Utils.Distance(n6, n5)) > 8320) {
                    XSprite.setTempDrawScaled(true);
                    sprites[11].RectFrame(0, 0, 0, 0);
                    XSprite.restoreDrawScaled();
                    n3 = (XSprite._rect[2] - XSprite._rect[0]) / 4 + 20 << 8;
                    n2 = Camera.getCenterX() + n6 * n3 / n4 >> 8;
                    n = Camera.getCenterY() + n5 * n3 / n4 >> 8;
                    sDKGraphics.setColor(0xFF0000);
                    sDKGraphics.fillArc(n2 - Camera.posX - 4, n - Camera.posY - 4, 8, 8, 0, 360);
                }
            }
            if (protectedAllied != null) {
                n6 = GameImpl.protectedAllied.posX - Camera.getCenterX();
                n5 = GameImpl.protectedAllied.posY - Camera.getCenterY();
                if (n6 > 70000) {
                    n6 = 70000;
                }
                if (n6 < -70000) {
                    n6 = -70000;
                }
                if (n5 > 70000) {
                    n5 = 70000;
                }
                if (n5 < -70000) {
                    n5 = -70000;
                }
                if ((n4 = Utils.Distance(n6, n5)) > 8320) {
                    XSprite.setTempDrawScaled(true);
                    sprites[11].RectFrame(0, 0, 0, 0);
                    XSprite.restoreDrawScaled();
                    n3 = (XSprite._rect[2] - XSprite._rect[0]) / 4 + 20 << 8;
                    n2 = Camera.getCenterX() + n6 * n3 / n4 >> 8;
                    n = Camera.getCenterY() + n5 * n3 / n4 >> 8;
                    sDKGraphics.setColor(65280);
                    sDKGraphics.fillArc(n2 - Camera.posX - 4, n - Camera.posY - 4, 8, 8, 0, 360);
                }
            }
            if (sniperCoolDownTimer > 0) {
                n6 = sniperCoolDownTimer * 100 / 25;
                n5 = 50 * n6 / 100;
                sDKGraphics.setColor(65280);
                sDKGraphics.drawLine(160, 200, 160, 200 - n5);
            }
            XSprite.restoreDrawScaled();
        } else if (bl) {
            XSprite.setTempDrawScaled(false);
            sprites[11].DrawFrame(0, sniperScopeOutPositions[sniperScopeOutCounter][0], sniperScopeOutPositions[sniperScopeOutCounter][1], 0);
            XSprite.restoreDrawScaled();
        }
    }

    public void drawSniperHud(SDKGraphics sDKGraphics) {
        if (!showUI) {
            return;
        }
        XSprite.setTempDrawScaled(false);
        if (raceLevel && raceTime >= 0) {
            Object object = SDKUtils.getFont();
            SDKUtils.setFont(fonts[0]);
            GameImpl.convertTimeIntoString(raceTime, stringBuffer);
            SDKUtils.drawString(stringBuffer, 160, 0, 1);
            SDKUtils.setFont(object);
        }
        if (!Utils.isFlagSet(levels[currentLevel][6], 4)) {
            sprites[10].RectFrame(30, 0, 0, 0);
            sprites[10].DrawFrame(30, 320 - XSprite._rect[2], -XSprite._rect[1], 0);
            int n = XSprite._rect[2] - XSprite._rect[0];
            int n2 = XSprite._rect[3] - XSprite._rect[1];
            int n3 = n * GameImpl.protectedAllied.life / GameImpl.protectedAllied.maxLife;
            if (GameImpl.protectedAllied.state != 6) {
                sDKGraphics.setColor(0x11EE11);
                sDKGraphics.fillRect(320 - n, n2, n3, 10);
            }
        }
        sprites[10].RectFrame(29, 0, 0, 0);
        sprites[10].DrawFrame(29, 0 - XSprite._rect[0], 162, 0);
        GameImpl.drawSniperMessages(sDKGraphics);
        XSprite.restoreDrawScaled();
    }

    public static void drawSniperMessages(SDKGraphics sDKGraphics) {
        SDKUtils.setFont(fonts[0]);
        int n = 2 * SDKUtils.getLineSize() + 6;
        int n2 = 222 - n;
        if (gameMode == 3) {
            int n3;
            sDKGraphics.setColor(0);
            GameImpl.fakeFillRect(sDKGraphics, 0, n2, 320, n);
            string = SDKUtils.getString(182, string);
            SDKUtils.drawString(string, 0, n2 + 2, 36);
            if (sniperMessages[sniperMessages.length - 1] != -1) {
                n3 = SDKUtils.getStringSize(string = SDKUtils.getString(sniperMessages[sniperMessages.length - 1], string));
                sniperMsgLenght = n3 - 325;
                if (sniperMsgLenght > 0) {
                    SDKUtils.drawString(string, 160 + sniperMsgPos, n2, 1);
                    if (sniperMsgPos < -sniperMsgLenght) {
                        sniperMsgInc = 1;
                    }
                    if (sniperMsgPos > sniperMsgLenght) {
                        sniperMsgInc = -1;
                    }
                    sniperMsgPos += sniperMsgInc;
                    n2 += SDKUtils.getLineSize();
                } else {
                    SDKUtils.drawString(string, 160, n2, 1);
                    n2 += SDKUtils.getLineSize();
                }
            }
            for (n3 = sniperMessages.length - 2; n3 >= 0; --n3) {
                if (sniperMessages[n3] == -1) continue;
                int n4 = SDKUtils.getStringSize(string = SDKUtils.getString(sniperMessages[n3], string));
                sniperMsgLenght2 = n4 - 320;
                if (sniperMsgLenght2 > 0) {
                    SDKUtils.drawString(string, 160 + sniperMsgPos2, n2, 1);
                    if (sniperMsgPos2 < -sniperMsgLenght2) {
                        sniperMsgInc2 = 1;
                    }
                    if (sniperMsgPos2 > sniperMsgLenght2) {
                        sniperMsgInc2 = -1;
                    }
                    sniperMsgPos2 += sniperMsgInc2;
                    n2 += SDKUtils.getLineSize();
                    continue;
                }
                SDKUtils.drawString(string, 160, n2, 1);
                n2 += SDKUtils.getLineSize();
            }
        } else if (sniperMessages[sniperMessages.length - 1] != -1) {
            string = SDKUtils.getString(sniperMessages[sniperMessages.length - 1], string);
            wrapOffsets = SDKUtils.wrapString(string, wrapOffsets, 320, (short)124);
            n2 = 222 - wrapOffsets[0] * SDKUtils.getLineSize();
            sDKGraphics.setColor(0);
            GameImpl.fakeFillRect(sDKGraphics, 0, n2, 320, wrapOffsets[0] * SDKUtils.getLineSize());
            SDKUtils.drawWrappedString(string, wrapOffsets, 1, wrapOffsets[0], 160, n2, 17);
        }
    }

    public void addSniperMessage(int n) {
        int n2;
        if (n == -1) {
            for (n2 = 0; n2 < sniperMessages.length; ++n2) {
                GameImpl.sniperMessages[n2] = -1;
            }
        }
        for (n2 = 0; n2 < sniperMessages.length - 1; ++n2) {
            GameImpl.sniperMessages[n2] = sniperMessages[n2 + 1];
        }
        GameImpl.sniperMessages[GameImpl.sniperMessages.length - 1] = n;
        sniperMsgPos = 0;
        sniperMsgInc = -1;
        sniperMsgPos2 = 0;
        sniperMsgInc2 = -1;
    }

    private void updateSniper() {
        int n;
        int n2;
        if (gameMode != 3) {
            return;
        }
        boolean bl = false;
        int n3 = sniperScopeSpeed = ++sniperScopeSpeed > 10 ? 10 : sniperScopeSpeed;
        if (!sniperScopeOn) {
            if (sniperGoingOut) {
                if (sniperScopeOutCounter < sniperScopeOutPositions.length) {
                    ++sniperScopeOutCounter;
                    bl = true;
                }
            } else if (sniperScopeOutCounter >= 0) {
                if (--sniperScopeOutCounter < 0) {
                    sniperScopeOn = true;
                } else {
                    bl = true;
                }
            }
        }
        if (bl) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        if (sniperReboundCounter >= sniperReboundPositions.length) {
            if (SDKCanvas.isKeyPressed(2052) || SDKCanvas.isKeyPressed(8200)) {
                int n6 = n4 = SDKCanvas.isKeyPressed(2052) ? -sniperScopeSpeed : sniperScopeSpeed;
            }
            if (SDKCanvas.isKeyPressed(513) || SDKCanvas.isKeyPressed(32770)) {
                int n7 = n5 = SDKCanvas.isKeyPressed(513) ? -sniperScopeSpeed : sniperScopeSpeed;
            }
            if (!(SDKCanvas.isKeyPressed(513) || SDKCanvas.isKeyPressed(32770) || SDKCanvas.isKeyPressed(2052) || SDKCanvas.isKeyPressed(8200))) {
                sniperScopeSpeed = 0;
            }
            if (n4 != 0 || n5 != 0) {
                Camera.setCenter(Camera.getCenterX() + (n4 << 8), Camera.getCenterY() + (n5 << 8));
            } else if (SDKCanvas.isKeyPressed(128) && !Utils.isFlagSet(levels[currentLevel][6], 4)) {
                Camera.moveCenterTo(GameImpl.protectedAllied.posX, GameImpl.protectedAllied.posY);
            }
            if (SDKCanvas.isNewKeyPressed(65536)) {
                sniperGoingOut = sniperScopeOn;
                int n8 = sniperScopeOutCounter = sniperGoingOut ? 0 : sniperScopeOutPositions.length - 1;
                if (sniperScopeOn) {
                    sniperScopeOn = false;
                }
            }
        } else {
            Camera.setCenter(Camera.getCenterX(), Camera.getCenterY() + sniperReboundPositions[sniperReboundCounter]);
            ++sniperReboundCounter;
        }
        Camera.update();
        if (--sniperCoolDownTimer <= 0 && SDKCanvas.isNewKeyPressed(4112) && sniperScopeOn) {
            Entity entity;
            sniperCoolDownTimer = 25;
            GameImpl.playSoundSniper(11);
            sniperReboundCounter = 0;
            n2 = 160 + Camera.posX;
            int n9 = 120 + Camera.posY;
            if (Map.getCollisionAt(n2, n9) == 15) {
                GameImpl.spawnTempAnimation(n2 << 8, n9 << 8, 8, 0);
            }
            for (n = 0; n < numAreaEnemies; ++n) {
                entity = enemies[areaEnemies[n]];
                if (entity.state == 1 || entity.state == 17 || !((Enemy)entity).isOnScreen()) continue;
                int n10 = entity.posX >> 8;
                int n11 = entity.posY >> 8;
                int[] nArray = sprites[5].RectFrame(14, n10, n11, 0);
                int n12 = (nArray[3] - nArray[1] - 9) / 3;
                int n13 = nArray[2] - nArray[0] - 12 >> 1;
                int n14 = nArray[0] + 6 + (n13 >> 1);
                int n15 = nArray[1] + 3 + (((Enemy)entity).isCovered ? n12 + 3 : 0);
                if (entity.state == 10) {
                    n15 = nArray[1] + 10;
                }
                int n16 = nArray[0] + 6;
                int n17 = nArray[1] + 3 + n12 + (((Enemy)entity).isCovered ? n12 + 3 : 0);
                if (entity.state == 10) {
                    n17 = nArray[1] + 10 + n12;
                }
                if (Utils.collPointBox(n2, n9, n14, n15, n13, n12)) {
                    ++sniperKillCount;
                    shouldCheckAchievements = true;
                    this.addSniperMessage(97);
                    ((Enemy)entity).takeDamage(100, n2 << 8, n9 + (((Enemy)entity).isCovered ? 35 : 50) << 8);
                    break;
                }
                if (!Utils.collPointBox(n2, n9, n16, n17, n13 << 1, ((Enemy)entity).isCovered ? n12 : n12 << 1)) continue;
                ((Enemy)entity).takeDamage(100, n2 << 8, n9 + (((Enemy)entity).isCovered ? 35 : 50) << 8);
                break;
            }
            GameImpl.scareEnemiesAround(n2, n9, 100);
            for (n = 0; n < numEntities; ++n) {
                int[] nArray;
                entity = entities[n];
                if (entity.type != 15 || entity.sData[1] == 1 || !Utils.collPointBox(n2, n9, (nArray = sprites[2].RectFrame(entity.sData[0], ((AnimatedEntity)entity).posX >> 8, ((AnimatedEntity)entity).posY >> 8, 0))[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1])) continue;
                entity.sData[1] = 1;
                GameImpl.spawnBlastAnimation(((AnimatedEntity)entity).posX, ((AnimatedEntity)entity).posY, 9, Utils.random(1), 53, 100, (byte)0);
                break;
            }
        }
        n2 = 0xFFFFFF;
        Enemy enemy = null;
        for (n = 0; n < numEnemies; ++n) {
            int n18;
            if (GameImpl.enemies[n].state == 1 || GameImpl.enemies[n].state == 17 || (GameImpl.enemies[n].flags & 4) == 0 || (n18 = Utils.Distance(GameImpl.enemies[n].posX - GameImpl.protectedAllied.posX >> 8, GameImpl.enemies[n].posY - GameImpl.protectedAllied.posY >> 8)) >= 200 || GameImpl.enemies[n].getEnemyClass().sData[3] < n18 || n18 >= n2) continue;
            n2 = n18;
            enemy = enemies[n];
        }
        if (enemy == null && !Utils.isFlagSet(levels[currentLevel][6], 4)) {
            n2 = 0xFFFFFF;
            for (n = 0; n < numEnemies; ++n) {
                int n19;
                if (GameImpl.enemies[n].state == 1 || GameImpl.enemies[n].state == 17 || (n19 = Utils.Distance(GameImpl.enemies[n].posX - GameImpl.protectedAllied.posX >> 8, GameImpl.enemies[n].posY - GameImpl.protectedAllied.posY >> 8)) >= 200 || n19 >= n2) continue;
                n2 = n19;
                enemy = enemies[n];
            }
        }
        if (n2 < 240) {
            int n20 = n = (enemy.flags & 4) != 0 ? 1 : 0;
            if (enemySniperTarget != enemy && n != 0) {
                int n21 = -1;
                n4 = enemy.posX - Camera.getCenterX();
                n5 = enemy.posY - Camera.getCenterY();
                n21 = Math.abs(n4) > Math.abs(n5) ? (n4 > 0 ? 179 : 181) : (n5 > 0 ? 180 : 178);
                this.addSniperMessage(n21);
            }
            enemySniperTarget = enemy;
        } else {
            enemySniperTarget = null;
        }
        for (n = 0; n < numMachineguns; ++n) {
            machineguns[n].update();
        }
    }

    public static void scareEnemiesAround(int n, int n2, int n3) {
        for (int i = 0; i < numEnemies; ++i) {
            if (GameImpl.enemies[i].state == 1 || !enemies[i].isOnScreen() || Utils.Distance(GameImpl.enemies[i].posX - (n << 8), GameImpl.enemies[i].posY - (n2 << 8)) >= n3 << 8) continue;
            enemies[i].runFrom(n, n2);
        }
    }

    public static void postponeObjectiveMessage(int n, int n2) {
        objText = (short)n2;
        objTitle = (short)n;
        objTimer = (short)30;
    }

    public static void objectiveSetState(int n, int n2) {
        for (int i = 0; i < numObjectives; ++i) {
            if (GameImpl.objectives[i].id != n) continue;
            if (GameImpl.objectives[i].state == 1 && n2 == 1) {
                GameImpl.setCurrentObjective(i);
                break;
            }
            objectives[i].setState(n2);
            break;
        }
    }

    public static void setCurrentObjective(int n) {
        currentObjective = n;
    }

    public static void setCurrentObjectiveById(int n) {
        for (int i = 0; i < numObjectives; ++i) {
            if (GameImpl.objectives[i].id != n) continue;
            currentObjective = i;
            break;
        }
    }

    public static boolean isBombingObjectiveCompleted() {
        return bombingTargetsFlags.length - numTargetsDestroyed <= 0;
    }

    public static int getObjectiveOfType(int n) {
        for (int i = 0; i < numObjectives; ++i) {
            if (GameImpl.objectives[i].type != n) continue;
            return i;
        }
        return -1;
    }

    public static void updateObjectives(int n) {
        block8: for (int i = 0; i < numObjectives; ++i) {
            if (GameImpl.objectives[i].state != 1 || GameImpl.objectives[i].type != n) continue;
            switch (n) {
                case 1: {
                    int n2;
                    int n3;
                    for (n3 = 0; n3 < numEnemies; ++n3) {
                        for (n2 = 0; n2 < GameImpl.objectives[i].numberIds; ++n2) {
                            if (GameImpl.objectives[i].ids[n2] != GameImpl.enemies[n3].id || GameImpl.enemies[n3].state == 1) continue;
                            return;
                        }
                    }
                    objectives[i].setState(2);
                    continue block8;
                }
                case 2: {
                    int n2;
                    int n3;
                    for (n3 = 0; n3 < numAllies; ++n3) {
                        for (n2 = 0; n2 < GameImpl.objectives[i].numberIds; ++n2) {
                            if (GameImpl.objectives[i].ids[n2] != GameImpl.allies[n3].id || GameImpl.allies[n3].state == 6) continue;
                            return;
                        }
                        objectives[i].setState(3);
                    }
                    continue block8;
                }
                case 3: {
                    int n2;
                    int n3;
                    for (n3 = 0; n3 < numExplodables; ++n3) {
                        for (n2 = 0; n2 < GameImpl.objectives[i].numberIds; ++n2) {
                            if (GameImpl.objectives[i].ids[n2] != GameImpl.explodables[n3].id || GameImpl.explodables[n3].state == 2) continue;
                            return;
                        }
                    }
                    objectives[i].setState(2);
                    continue block8;
                }
                case 4: {
                    int n3;
                    for (n3 = 0; n3 < GameImpl.objectives[i].numberIds; ++n3) {
                        if (GameImpl.objectives[GameImpl.objectives[i].ids[n3]].state == 2) continue;
                        return;
                    }
                    objectives[i].setState(2);
                    continue block8;
                }
                case 5: {
                    continue block8;
                }
                case 6: {
                    if (GameImpl.player.life == GameImpl.player.maxLife) continue block8;
                    objectives[i].setState(3);
                }
            }
        }
    }

    public void updateAchievements() {
        if (shouldCheckAchievements) {
            if (currentConsecutiveHeadshots >= 1 && !achievementCompleted[0]) {
                GameImpl.achievementCompleted[0] = true;
                GameImpl.continueAchievementCompleted[0] = true;
                lastCompletedAchievementIDX = 0;
                GameImpl.saveAchievements();
                return;
            }
            if (currentConsecutiveHeadshots >= 3 && !achievementCompleted[1]) {
                GameImpl.achievementCompleted[1] = true;
                GameImpl.continueAchievementCompleted[1] = true;
                lastCompletedAchievementIDX = 1;
                GameImpl.saveAchievements();
                return;
            }
            if (currentConsecutiveHeadshots >= 5 && !achievementCompleted[2]) {
                GameImpl.achievementCompleted[2] = true;
                GameImpl.continueAchievementCompleted[2] = true;
                lastCompletedAchievementIDX = 2;
                GameImpl.saveAchievements();
                return;
            }
            if (currentConsecutiveHeadshots >= 10 && !achievementCompleted[3]) {
                GameImpl.achievementCompleted[3] = true;
                GameImpl.continueAchievementCompleted[3] = true;
                lastCompletedAchievementIDX = 3;
                GameImpl.saveAchievements();
                return;
            }
            if (currentConsecutiveStealthKills >= 1 && !achievementCompleted[4]) {
                GameImpl.achievementCompleted[4] = true;
                GameImpl.continueAchievementCompleted[4] = true;
                lastCompletedAchievementIDX = 4;
                GameImpl.saveAchievements();
                return;
            }
            if (currentConsecutiveStealthKills >= 3 && !achievementCompleted[5]) {
                GameImpl.achievementCompleted[5] = true;
                GameImpl.continueAchievementCompleted[5] = true;
                lastCompletedAchievementIDX = 5;
                GameImpl.saveAchievements();
                return;
            }
            if (currentConsecutiveStealthKills >= 5 && !achievementCompleted[6]) {
                GameImpl.achievementCompleted[6] = true;
                GameImpl.continueAchievementCompleted[6] = true;
                lastCompletedAchievementIDX = 6;
                GameImpl.saveAchievements();
                return;
            }
            if (currentConsecutiveStealthKills >= 10 && !achievementCompleted[7]) {
                GameImpl.achievementCompleted[7] = true;
                GameImpl.continueAchievementCompleted[7] = true;
                lastCompletedAchievementIDX = 7;
                GameImpl.saveAchievements();
                return;
            }
            if (currentGrenadeKillCount >= 3 && !achievementCompleted[9]) {
                GameImpl.achievementCompleted[9] = true;
                GameImpl.achievementCompleted[8] = true;
                GameImpl.continueAchievementCompleted[9] = true;
                GameImpl.continueAchievementCompleted[8] = true;
                lastCompletedAchievementIDX = 9;
                GameImpl.saveAchievements();
                return;
            }
            if (currentGrenadeKillCount >= 2 && !achievementCompleted[8]) {
                GameImpl.achievementCompleted[8] = true;
                GameImpl.continueAchievementCompleted[8] = true;
                lastCompletedAchievementIDX = 8;
                GameImpl.saveAchievements();
                return;
            }
            if (currentBombKillCount >= 3 && !achievementCompleted[14]) {
                GameImpl.achievementCompleted[14] = true;
                GameImpl.continueAchievementCompleted[14] = true;
                lastCompletedAchievementIDX = 14;
                GameImpl.saveAchievements();
                return;
            }
            if (sniperKillCount >= 10 && !achievementCompleted[12]) {
                GameImpl.achievementCompleted[12] = true;
                GameImpl.achievementCompleted[11] = true;
                GameImpl.achievementCompleted[10] = true;
                GameImpl.continueAchievementCompleted[12] = true;
                GameImpl.continueAchievementCompleted[11] = true;
                GameImpl.continueAchievementCompleted[10] = true;
                lastCompletedAchievementIDX = 12;
                GameImpl.saveAchievements();
                return;
            }
            if (sniperKillCount >= 5 && !achievementCompleted[11]) {
                GameImpl.achievementCompleted[11] = true;
                GameImpl.achievementCompleted[10] = true;
                GameImpl.continueAchievementCompleted[11] = true;
                GameImpl.continueAchievementCompleted[10] = true;
                lastCompletedAchievementIDX = 11;
                GameImpl.saveAchievements();
                return;
            }
            if (sniperKillCount >= 3 && !achievementCompleted[10]) {
                GameImpl.achievementCompleted[10] = true;
                GameImpl.continueAchievementCompleted[10] = true;
                lastCompletedAchievementIDX = 10;
                GameImpl.saveAchievements();
                return;
            }
            if (pistolKillCount >= 15 && !achievementCompleted[13]) {
                GameImpl.achievementCompleted[13] = true;
                GameImpl.continueAchievementCompleted[13] = true;
                lastCompletedAchievementIDX = 13;
                GameImpl.saveAchievements();
                return;
            }
            if (machinegunKillCount >= 3 && !achievementCompleted[15]) {
                GameImpl.achievementCompleted[15] = true;
                GameImpl.continueAchievementCompleted[15] = true;
                lastCompletedAchievementIDX = 15;
                GameImpl.saveAchievements();
                return;
            }
            if (machinegunKillCount >= 5 && !achievementCompleted[16]) {
                GameImpl.achievementCompleted[15] = true;
                GameImpl.achievementCompleted[16] = true;
                GameImpl.continueAchievementCompleted[15] = true;
                GameImpl.continueAchievementCompleted[16] = true;
                lastCompletedAchievementIDX = 16;
                GameImpl.saveAchievements();
                return;
            }
            if (Utils.isFlagSet(levels[currentLevel][6], 8) && !achievementCompleted[18 + currentLevel]) {
                boolean bl = false;
                boolean bl2 = true;
                for (int i = 0; i < numEntities; ++i) {
                    if (GameImpl.entities[i].type == 11) {
                        if (GameImpl.entities[i].state != 3) {
                            bl = true;
                        } else {
                            bl2 = true;
                        }
                    }
                    if (bl && bl2) break;
                }
                if (!bl && bl2) {
                    GameImpl.achievementCompleted[18 + GameImpl.currentLevel] = true;
                    GameImpl.continueAchievementCompleted[18 + GameImpl.currentLevel] = true;
                    if (currentLevel != 3) {
                        lastCompletedAchievementIDX = 18 + currentLevel;
                    }
                    GameImpl.saveAchievements();
                    return;
                }
            }
        }
        shouldCheckAchievements = false;
    }

    public static void saveStartCounting() {
        saveCount = 0;
        saveCountPosition = saveCursor;
        saveCursor += 2;
    }

    public static void saveEndCounting() {
        int n = saveCursor;
        saveCursor = saveCountPosition;
        GameImpl.savePutShort(saveCount);
        saveCursor = n;
    }

    public static void savePutBoolean(boolean bl) {
        GameImpl.saveData[GameImpl.saveCursor++] = (byte)(bl ? 1 : 0);
    }

    public static void savePutByte(int n) {
        GameImpl.saveData[GameImpl.saveCursor++] = (byte)(n & 0xFF);
    }

    public static void savePartPutByte(int n) {
        GameImpl.saveDataPart[GameImpl.saveCursor2] = (byte)(n & 0xFF);
    }

    public static void savePutShort(int n) {
        GameImpl.saveData[GameImpl.saveCursor++] = (byte)(n >> 8 & 0xFF);
        GameImpl.saveData[GameImpl.saveCursor++] = (byte)(n & 0xFF);
    }

    public static void savePartPutShort(int n) {
        GameImpl.saveDataPart[GameImpl.saveCursor2] = (byte)(n >> 8 & 0xFF);
        GameImpl.saveDataPart[GameImpl.saveCursor2 + 1] = (byte)(n & 0xFF);
    }

    public static void savePutInt(int n) {
        GameImpl.saveData[GameImpl.saveCursor++] = (byte)(n >> 24 & 0xFF);
        GameImpl.saveData[GameImpl.saveCursor++] = (byte)(n >> 16 & 0xFF);
        GameImpl.saveData[GameImpl.saveCursor++] = (byte)(n >> 8 & 0xFF);
        GameImpl.saveData[GameImpl.saveCursor++] = (byte)(n & 0xFF);
    }

    public static boolean saveGetBoolean() {
        return saveData[saveCursor++] == 1;
    }

    public static int saveGetByte() {
        return saveData[saveCursor++] & 0xFF;
    }

    public static int savePartGetByte() {
        return saveDataPart[saveCursor2] & 0xFF;
    }

    public static int savePartGetShort() {
        int n = (saveDataPart[saveCursor2] & 0xFF) << 8 | saveDataPart[saveCursor2 + 1] & 0xFF;
        return n;
    }

    public static int saveGetShort() {
        int n = (saveData[saveCursor] & 0xFF) << 8 | saveData[saveCursor + 1] & 0xFF;
        saveCursor += 2;
        return n;
    }

    public static int saveGetInt() {
        int n = (saveData[saveCursor] & 0xFF) << 24 | (saveData[saveCursor + 1] & 0xFF) << 16 | (saveData[saveCursor + 2] & 0xFF) << 8 | saveData[saveCursor + 3] & 0xFF;
        saveCursor += 4;
        return n;
    }

    public static void deleteLevelSave() {
        SDKUtils.removeRecord(1);
    }

    public static void saveLevel() {
        int n;
        continueNextLevel = -1;
        saveTimer = 40;
        saveCursor = 0;
        GameImpl.saveStartCounting();
        for (n = 0; n < numLoadedEnemies; ++n) {
            if (GameImpl.enemies[n].state != 1) continue;
            GameImpl.savePutShort(n);
            ++saveCount;
        }
        GameImpl.saveEndCounting();
        GameImpl.saveStartCounting();
        for (n = 0; n < numLoadedEnemies; ++n) {
            if (GameImpl.enemies[n].state != 17) continue;
            GameImpl.savePutShort(n);
            ++saveCount;
        }
        GameImpl.saveEndCounting();
        GameImpl.saveStartCounting();
        for (n = 0; n < numStaticDecorators; ++n) {
            int n2 = staticDecoratorData[n] >> 16 & 0xFF;
            if ((n2 & 0x70) == 0) continue;
            GameImpl.savePutShort(staticDecoratorEosOrder[n]);
            ++saveCount;
        }
        GameImpl.saveEndCounting();
        GameImpl.saveStartCounting();
        for (n = 0; n < tempEntities.size(); ++n) {
            Entity entity = (Entity)tempEntities.elementAt(n);
            if (entity.type != 25) continue;
            GameImpl.savePutShort(((AnimatedEntity)entity).posX >> 8);
            GameImpl.savePutShort(((AnimatedEntity)entity).posY >> 8);
            GameImpl.savePutByte(entity.state);
            ++saveCount;
        }
        GameImpl.saveEndCounting();
        GameImpl.saveStartCounting();
        for (n = 0; n < numDestroyedCollisions; ++n) {
            GameImpl.savePutShort(destroyedCollisionsPosX[n]);
            GameImpl.savePutShort(destroyedCollisionsPosY[n]);
            ++saveCount;
        }
        GameImpl.saveEndCounting();
        GameImpl.saveStartCounting();
        for (n = 0; n < numTriggers; ++n) {
            if (GameImpl.triggers[n].state != 1) continue;
            GameImpl.savePutShort(n);
            ++saveCount;
        }
        GameImpl.saveEndCounting();
        GameImpl.saveStartCounting();
        for (n = 0; n < numEntities; ++n) {
            if (GameImpl.entities[n].type == 11) {
                GameImpl.savePutShort(GameImpl.entities[n].state);
                ++saveCount;
                continue;
            }
            if (GameImpl.entities[n].type != 15) continue;
            GameImpl.savePutShort(GameImpl.entities[n].sData[1]);
            ++saveCount;
        }
        GameImpl.saveEndCounting();
        saveDataPart = null;
        saveCursor2 = 0;
        if (currentLevel == 7 || currentLevel == 3 || currentLevel == 5) {
            saveDataPart = new byte[1024];
        }
        GameImpl.savePutShort(GameImpl.player.posX >> 8);
        GameImpl.savePutShort(GameImpl.player.posY >> 8);
        GameImpl.savePutByte(GameImpl.player.orientation);
        if (saveDataPart != null) {
            saveCursor2 = 0;
            GameImpl.savePartPutByte(GameImpl.player.life);
            ++saveCursor2;
            GameImpl.savePartPutByte(GameImpl.player.currentWeapon);
            ++saveCursor2;
            GameImpl.savePartPutByte(GameImpl.player.numWeapons);
            ++saveCursor2;
        }
        GameImpl.savePutByte(GameImpl.player.life);
        GameImpl.savePutByte(GameImpl.player.currentWeapon);
        GameImpl.savePutByte(GameImpl.player.numWeapons);
        for (n = 0; n < GameImpl.player.numWeapons; ++n) {
            GameImpl.savePutByte(GameImpl.player.weaponClass[n].bData[0]);
            GameImpl.savePutShort(GameImpl.player.weaponAmmunition[n]);
            GameImpl.savePutShort(GameImpl.player.weaponMagazine[n]);
            if (saveDataPart == null) continue;
            GameImpl.savePartPutByte(GameImpl.player.weaponClass[n].bData[0]);
            ++saveCursor2;
            GameImpl.savePartPutShort(GameImpl.player.weaponAmmunition[n]);
            saveCursor2 += 2;
            GameImpl.savePartPutShort(GameImpl.player.weaponMagazine[n]);
            saveCursor2 += 2;
        }
        for (n = 0; n < numAllies; ++n) {
            AlliedCharacter alliedCharacter = allies[n];
            if (gameMode == 1 || gameMode == 3) {
                GameImpl.savePutShort(alliedCharacter.posX >> 8);
                GameImpl.savePutShort(alliedCharacter.posY >> 8);
            } else {
                GameImpl.savePutShort(alliedCharacter.posX >> 7);
                GameImpl.savePutShort(alliedCharacter.posY >> 7);
            }
            GameImpl.savePutByte(alliedCharacter.currentWaypoint);
            GameImpl.savePutByte(alliedCharacter.flags);
            GameImpl.savePutByte(alliedCharacter.state);
            GameImpl.savePutByte(alliedCharacter.orientation);
        }
        GameImpl.savePutInt(currentObjective);
        for (n = 0; n < numObjectives; ++n) {
            GameImpl.savePutByte(GameImpl.objectives[n].state);
            GameImpl.savePutShort(GameImpl.objectives[n].posX >> 8);
            GameImpl.savePutShort(GameImpl.objectives[n].posY >> 8);
        }
        for (n = 0; n < GameImpl.vm.gVars.length; ++n) {
            GameImpl.savePutInt(GameImpl.vm.gVars[n]);
        }
        for (n = 0; n < numExplodables; ++n) {
            GameImpl.savePutByte(GameImpl.explodables[n].state);
            GameImpl.savePutByte(GameImpl.explodables[n].bData[2]);
        }
        GameImpl.savePutShort(Camera.posX);
        GameImpl.savePutShort(Camera.posY);
        GameImpl.savePutInt(raceTime);
        GameImpl.savePutInt(playAreaTopLimit);
        GameImpl.savePutInt(playAreaBottomLimit);
        GameImpl.savePutInt(playAreaLeftLimit);
        GameImpl.savePutInt(playAreaRightLimit);
        SDKUtils.saveRecord(1, saveData);
        GameImpl.saveSettings();
    }

    public static void loadLevel() {
        if (saveDataPart != null) {
            saveCursor2 = 0;
            GameImpl.player.life = GameImpl.savePartGetByte();
            ++saveCursor2;
            GameImpl.player.currentWeapon = GameImpl.savePartGetByte();
            ++saveCursor2;
            GameImpl.player.numWeapons = GameImpl.savePartGetByte();
            ++saveCursor2;
            for (int i = 0; i < GameImpl.player.numWeapons; ++i) {
                GameImpl.player.weaponClass[i] = GameImpl.getWeaponClassByType(GameImpl.savePartGetByte());
                ++saveCursor2;
                GameImpl.player.weaponAmmunition[i] = (short)GameImpl.savePartGetShort();
                saveCursor2 += 2;
                GameImpl.player.weaponMagazine[i] = (byte)GameImpl.savePartGetShort();
                saveCursor2 += 2;
            }
            player.setWeapon(GameImpl.player.currentWeapon);
        }
        if (SDKUtils.isRecordEmpty(1)) {
            playAreaBottomLimit = -1;
            playAreaTopLimit = -1;
            playAreaLeftLimit = -1;
            playAreaRightLimit = -1;
            return;
        }
        byte[] byArray = SDKUtils.loadRecord(1);
        if (byArray != null) {
            int n;
            int n2;
            System.arraycopy(byArray, 0, saveData, 0, byArray.length);
            saveCursor = 0;
            int n3 = GameImpl.saveGetShort();
            for (n2 = 0; n2 < n3; ++n2) {
                n = GameImpl.saveGetShort();
                GameImpl.enemies[n].state = 1;
                GameImpl.enemies[n].substate = 2;
            }
            n3 = GameImpl.saveGetShort();
            for (n2 = 0; n2 < n3; ++n2) {
                n = GameImpl.saveGetShort();
                enemies[n].setState(17);
            }
            n3 = GameImpl.saveGetShort();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                n = GameImpl.saveGetShort();
                int n5 = staticDecoratorData[n] >> 0 & 0xFF;
                if (GameImpl.getDestructibleArrayIndex(n5, n4 = staticDecoratorData[n] >> 8 & 0xFF) != -1) {
                    int n6 = n;
                    staticDecoratorData[n6] = staticDecoratorData[n6] | 0x400000;
                    continue;
                }
                int n7 = n;
                staticDecoratorData[n7] = staticDecoratorData[n7] | 0x100000;
            }
            n3 = GameImpl.saveGetShort();
            for (n2 = 0; n2 < n3; ++n2) {
                AnimatedEntity animatedEntity = new AnimatedEntity(25);
                animatedEntity.posX = GameImpl.saveGetShort() << 8;
                animatedEntity.posY = GameImpl.saveGetShort() << 8;
                animatedEntity.state = GameImpl.saveGetByte();
                tempEntities.addElement(animatedEntity);
            }
            n3 = GameImpl.saveGetShort();
            for (n2 = 0; n2 < n3; ++n2) {
                GameImpl.destroyCollisionAndSavePos(GameImpl.saveGetShort(), GameImpl.saveGetShort());
            }
            n3 = GameImpl.saveGetShort();
            for (n2 = 0; n2 < n3; ++n2) {
                int n8 = GameImpl.saveGetShort();
                GameImpl.triggers[n8].state = 1;
            }
            n3 = GameImpl.saveGetShort();
            if (n3 > 0) {
                n2 = 0;
                for (int i = 0; i < entities.length; ++i) {
                    if (GameImpl.entities[i].type == 11) {
                        ((AnimatedEntity)entities[i]).setState(GameImpl.saveGetShort());
                        if (++n2 != n3) continue;
                        break;
                    }
                    if (GameImpl.entities[i].type != 15) continue;
                    GameImpl.entities[i].sData[1] = (short)GameImpl.saveGetShort();
                    if (++n2 == n3) break;
                }
            }
            GameImpl.player.posX = GameImpl.saveGetShort() << 8;
            GameImpl.player.posY = GameImpl.saveGetShort() << 8;
            GameImpl.player.orientation = GameImpl.saveGetByte();
            GameImpl.player.life = GameImpl.saveGetByte();
            GameImpl.player.currentWeapon = GameImpl.saveGetByte();
            GameImpl.player.numWeapons = GameImpl.saveGetByte();
            for (n2 = 0; n2 < GameImpl.player.numWeapons; ++n2) {
                GameImpl.player.weaponClass[n2] = GameImpl.getWeaponClassByType(GameImpl.saveGetByte());
                GameImpl.player.weaponAmmunition[n2] = (short)GameImpl.saveGetShort();
                GameImpl.player.weaponMagazine[n2] = (byte)GameImpl.saveGetShort();
            }
            player.setWeapon(GameImpl.player.currentWeapon);
            for (n2 = 0; n2 < numAllies; ++n2) {
                GameImpl.allies[n2].posX = GameImpl.saveGetShort() << 8;
                GameImpl.allies[n2].posY = GameImpl.saveGetShort() << 8;
                GameImpl.allies[n2].currentWaypoint = GameImpl.saveGetByte();
                GameImpl.allies[n2].flags = (byte)GameImpl.saveGetByte();
                int n9 = GameImpl.saveGetByte();
                if (n9 == 5) {
                    allies[n2].gotoXY(GameImpl.allies[n2].waypoints[2 * GameImpl.allies[n2].currentWaypoint], GameImpl.allies[n2].waypoints[2 * GameImpl.allies[n2].currentWaypoint + 1]);
                } else {
                    GameImpl.allies[n2].state = n9 == 11 ? 11 : (n9 == 13 ? 13 : (n9 != 6 ? 0 : 6));
                }
                GameImpl.allies[n2].orientation = GameImpl.saveGetByte();
            }
            currentObjective = GameImpl.saveGetInt();
            for (n2 = 0; n2 < numObjectives; ++n2) {
                GameImpl.objectives[n2].state = GameImpl.saveGetByte();
                GameImpl.objectives[n2].posX = GameImpl.saveGetShort() << 8;
                GameImpl.objectives[n2].posY = GameImpl.saveGetShort() << 8;
            }
            for (n2 = 0; n2 < GameImpl.vm.gVars.length; ++n2) {
                GameImpl.vm.gVars[n2] = GameImpl.saveGetInt();
            }
            for (n2 = 0; n2 < numExplodables; ++n2) {
                GameImpl.explodables[n2].state = GameImpl.saveGetByte();
                if (GameImpl.explodables[n2].state == 2) {
                    GameImpl.explodables[n2].animator._crt_aframe = GameImpl.explodables[n2].bData[0];
                }
                GameImpl.explodables[n2].bData[2] = (byte)GameImpl.saveGetByte();
                if (GameImpl.explodables[n2].state != 1) continue;
                GameImpl.explodables[n2].iData[0] = (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL);
            }
            Camera.posX = GameImpl.saveGetShort();
            Camera.posY = GameImpl.saveGetShort();
            raceTime = GameImpl.saveGetInt();
            playAreaTopLimit = GameImpl.saveGetInt();
            playAreaBottomLimit = GameImpl.saveGetInt();
            playAreaLeftLimit = GameImpl.saveGetInt();
            playAreaRightLimit = GameImpl.saveGetInt();
        } else {
            playAreaBottomLimit = -1;
            playAreaTopLimit = -1;
            playAreaLeftLimit = -1;
            playAreaRightLimit = -1;
        }
    }

    public static void saveSettings() {
        saveCursor = 0;
        GameImpl.savePutByte(currentLevel);
        GameImpl.savePutByte(currentMaxUnlockedLevel);
        GameImpl.savePutBoolean(displayHints);
        GameImpl.savePutInt(continueNextLevel);
        if (state != 9) {
            GameImpl.savePutInt(SDKUtils.getCurrentLanguage());
        } else {
            GameImpl.savePutInt(-1);
        }
        SDKUtils.saveRecord(0, saveData);
    }

    public static void loadSettings() {
        if (SDKUtils.isRecordEmpty(0)) {
            return;
        }
        byte[] byArray = SDKUtils.loadRecord(0);
        if (byArray != null) {
            System.arraycopy(byArray, 0, saveData, 0, byArray.length);
            saveCursor = 0;
            currentLevel = GameImpl.saveGetByte();
            currentMaxUnlockedLevel = GameImpl.saveGetByte();
            displayHints = GameImpl.saveGetBoolean();
            continueNextLevel = GameImpl.saveGetInt();
            currentLanguage = GameImpl.saveGetInt();
        }
    }

    public static void saveAchievements() {
        int n;
        saveCursor = 0;
        for (n = 0; n < achievementCount; ++n) {
            GameImpl.savePutBoolean(achievementCompleted[n]);
        }
        for (n = 0; n < achievementCount; ++n) {
            GameImpl.savePutBoolean(continueAchievementCompleted[n]);
        }
        GameImpl.savePutInt(sniperKillCount);
        GameImpl.savePutInt(machinegunKillCount);
        SDKUtils.saveRecord(2, saveData);
    }

    public static void loadAchievements() {
        int n;
        if (SDKUtils.isRecordEmpty(2)) {
            return;
        }
        byte[] byArray = SDKUtils.loadRecord(2);
        System.arraycopy(byArray, 0, saveData, 0, byArray.length);
        saveCursor = 0;
        for (n = 0; n < achievementCount; ++n) {
            GameImpl.achievementCompleted[n] = GameImpl.saveGetBoolean();
        }
        for (n = 0; n < achievementCount; ++n) {
            GameImpl.continueAchievementCompleted[n] = GameImpl.saveGetBoolean();
        }
        sniperKillCount = GameImpl.saveGetInt();
        machinegunKillCount = GameImpl.saveGetInt();
    }

    public static void constructVisibleEnemies() {
        areaEnemiesFrames = 0;
        int n = 320;
        int n2 = 240;
        if (gameMode == 2) {
            n <<= 1;
            n2 <<= 1;
        }
        int n3 = Camera.posX - (n >> 1);
        int n4 = Camera.posY - (n2 >> 1);
        int n5 = Camera.posX + n + (n >> 1);
        int n6 = Camera.posY + n2 + (n2 >> 1);
        areaCamX = Camera.posX;
        areaCamY = Camera.posY;
        numAreaEnemies = 0;
        for (int i = 0; i < numEnemies; ++i) {
            Enemy enemy = enemies[i];
            if (enemy.posX >> 8 <= n3 || enemy.posX >> 8 >= n5 || enemy.posY >> 8 <= n4 || enemy.posY >> 8 >= n6 || enemy.state == 1) continue;
            if (numAreaEnemies >= 25) break;
            GameImpl.areaEnemies[GameImpl.numAreaEnemies++] = (byte)i;
        }
    }

    private void updateRaceLevelTimer() {
        long l;
        if (raceLevel && raceTime > 0 && (l = System.currentTimeMillis()) - raceLastUpdateTime >= 1000L) {
            --raceTime;
            raceLastUpdateTime = l;
        }
    }

    private void updateGame() {
        if (saveTimer > 0) {
            --saveTimer;
        }
        ++frames;
        if (++areaEnemiesFrames >= 30) {
            GameImpl.constructVisibleEnemies();
        }
        switch (playState) {
            case 0: {
                shouldCheckAchievements = false;
                currentBombKillCount = 0;
                currentGrenadeKillCount = 0;
                if (sniperBulletTimeCounter > 0) {
                    --sniperBulletTimeCounter;
                    if ((frames & 1L) != 0L) {
                        this.updateSniper();
                        Map.CDB_Update();
                        return;
                    }
                }
                vm.cycle();
                if (state != 1) {
                    return;
                }
                this.updateEntities();
                this.updateBombingRun();
                if (gameMode == 1 || gameMode == 3) {
                    this.updateAllies();
                }
                if (objTimer > 0) {
                    objTimer = (short)(objTimer - 1);
                } else if (objTimer == 0) {
                    objTimer = (short)-1;
                    GameImpl.showMessage(objTitle, objText, 8);
                }
                this.updateSniper();
                Map.CDB_Update();
                this.updateRaceLevelTimer();
                this.updateAchievements();
                break;
            }
            case 1: {
                vm.cycle();
                if (cutSceneScript != -1 && skipSceneScript != -1 && SDKCanvas.isNewKeyPressed(32)) {
                    vm.stopInstancesByID(cutSceneScript);
                    vm.spawnInstanceByID(skipSceneScript, -1);
                    return;
                }
                this.updateEntities();
                this.updateAllies();
                Map.CDB_Update();
                this.updateRaceLevelTimer();
                break;
            }
            case 2: {
                if (!SDKCanvas.isNewKeyPressed(32)) break;
                GameImpl.setState(2);
                menu.setMenuState(1);
                break;
            }
            case 10: {
                hudAnimator.UpdateCrtAnim();
                if (SDKCanvas.isNewKeyPressed(32)) {
                    continueNextLevel = currentLevel + 1;
                    GameImpl.setPlayState(9);
                    break;
                }
                if (!SDKCanvas.isNewKeyPressed(64)) break;
                continueNextLevel = currentLevel + 1;
                currentMaxUnlockedLevel = Math.max(currentLevel + 1, currentMaxUnlockedLevel);
                GameImpl.setState(2);
                menu.setMenuState(1);
                break;
            }
            case 12: {
                Menu.isContinueEnabled = false;
                continueNextLevel = -1;
                GameImpl.setState(2);
                menu.setMenuState(1);
                break;
            }
            case 9: {
                if (SDKCanvas.isNewKeyPressed(513)) {
                    if (GameImpl.menu.menuIndex <= 0) break;
                    GameImpl.menu.menuIndex -= 2;
                    --GameImpl.menu.startListPos;
                    break;
                }
                if (!SDKCanvas.isNewKeyPressed(32770) || GameImpl.menu.menuIndex >= GameImpl.menu.numShownObjectives - 1) break;
                GameImpl.menu.menuIndex += 2;
                ++GameImpl.menu.startListPos;
                break;
            }
            case 4: {
                this.updateCamera();
                Map.CDB_Update();
                writingAnimator.UpdateCrtAnim();
                if (dialogMode == 7) {
                    hudAnimator.UpdateCrtAnim();
                    if (!SDKCanvas.isNewKeyPressed(4144)) break;
                    GameImpl.setPlayState(0);
                    break;
                }
                if (Camera.state == 0) {
                    if (tutorialPhase == 0) {
                        hudAnimator.UpdateCrtAnim();
                    } else {
                        GameImpl.setPlayState(0);
                    }
                }
                if (!SDKCanvas.isNewKeyPressed(4144)) break;
                Camera.moveCenterToWithSpeed(previousCameraPosX, previousCameraPosY, 4);
                tutorialPhase = 1;
                break;
            }
            case 3: {
                if (hudAnimator != null && dialogMode != 9 && dialogMode != 10) {
                    hudAnimator.UpdateCrtAnim();
                }
                if (dialogMode == 8 && hudAnimator.IsCrtAnimEnded()) {
                    writingAnimator.UpdateCrtAnim();
                }
                if (SDKCanvas.isNewKeyPressed(4112)) {
                    if (postponeEndLevel) {
                        postponeEndLevel = false;
                        GameImpl.setPlayState(9);
                    } else if (postponeChangeLevelMode) {
                        postponeChangeLevelMode = false;
                        GameImpl.fadeOutToPlayState(postponedTransition);
                    } else {
                        GameImpl.setPlayState(0);
                    }
                }
                if (!SDKCanvas.isNewKeyPressed(32)) break;
                msgSkip = true;
                if (postponeEndLevel) {
                    postponeEndLevel = false;
                    GameImpl.setPlayState(9);
                    break;
                }
                if (postponeChangeLevelMode) {
                    postponeChangeLevelMode = false;
                    GameImpl.fadeOutToPlayState(postponedTransition);
                    break;
                }
                GameImpl.setPlayState(0);
                break;
            }
            case 6: 
            case 7: {
                if (!fadingFinished) {
                    menu.updateTransitionAnimation();
                    if (!GameImpl.menu.transitionFinished) break;
                    fadingFinished = true;
                    if (playState == 7) {
                        faded = true;
                    }
                    if (isTransitionToGameState) {
                        bCleanMemory = true;
                        isTransitionToGameState = false;
                        GameImpl.setState(transitionToState);
                        break;
                    }
                    if (playState == transitionToState || transitionToState == -1) break;
                    if (transitionToState == -4) {
                        GameImpl.changeGameMode((byte)1, true, true);
                        break;
                    }
                    if (transitionToState == -2) {
                        GameImpl.changeGameMode((byte)2, false, true);
                        break;
                    }
                    if (transitionToState == -3) {
                        GameImpl.changeGameMode((byte)3, true, true);
                        break;
                    }
                    switch (gameMode) {
                        case 2: 
                        case 3: {
                            XSprite.setDrawScaled(true);
                            break;
                        }
                        case 1: {
                            XSprite.setDrawScaled(false);
                        }
                    }
                    GameImpl.setPlayState(transitionToState);
                    break;
                }
                vm.cycle();
            }
        }
    }

    private void updateBombingRun() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (gameMode != 2) {
            return;
        }
        if (SDKCanvas.isKeyPressed(32770)) {
            targetY += 2000;
        }
        if (SDKCanvas.isKeyPressed(513)) {
            targetY -= 2000;
        }
        if (SDKCanvas.isKeyPressed(8200)) {
            targetX += 2000;
        }
        if (SDKCanvas.isKeyPressed(2052)) {
            targetX -= 2000;
        }
        if (targetX >> 8 < 0) {
            targetX = 0;
        }
        if (targetY >> 8 < 0) {
            targetY = 0;
        }
        if (targetX >> 8 > 320) {
            targetX = 81920;
        }
        if (targetY >> 8 > 240) {
            targetY = 61440;
        }
        for (n7 = 0; n7 <= numFiredBombs; ++n7) {
            if (3 * n7 + 2 >= firedBombs.length) continue;
            int n8 = 3 * n7 + 2;
            firedBombs[n8] = firedBombs[n8] - 1;
            if (firedBombs[n8] == 0) {
                GameImpl.spawnBlastAnimation(firedBombs[3 * n7], firedBombs[3 * n7 + 1], 9, 1, bombingRunBombArea, bombingRunBombDamage, (byte)3);
                GameImpl.scareEnemiesAround(firedBombs[3 * n7] >> 8, firedBombs[3 * n7 + 1] >> 8, 100);
            }
            if (firedBombs[3 * n7 + 2] >= 0) continue;
            GameImpl.firedBombs[3 * n7 + 2] = -1;
        }
        if (SDKCanvas.isNewKeyPressed(4112) && numFiredBombs < numBombs - 1) {
            GameImpl.firedBombs[3 * ++GameImpl.numFiredBombs] = Camera.fracPosX + targetX;
            GameImpl.firedBombs[3 * GameImpl.numFiredBombs + 1] = Camera.fracPosY + targetY;
            GameImpl.firedBombs[3 * GameImpl.numFiredBombs + 2] = 8;
            if (bombingTargetsAnims != null) {
                for (n7 = 0; n7 < bombingTargetsAnims.length >> 1; ++n7) {
                    if (bombingTargetsFlags[n7] == 3 || bombingTargetsFlags[n7] == 4 || (n6 = Utils.Distance((targetX >> 8) - (bombingTargets[2 * n7] - Camera.posX), (targetY >> 8) - (bombingTargets[2 * n7 + 1] - Camera.posY))) > 20) continue;
                    GameImpl.bombingTargetsFlags[n7] = 3;
                    ++numTargetsDestroyed;
                    GameImpl.updateObjectives(5);
                }
            }
        }
        if (bombingPathIdx < bombingPath.length >> 2) {
            n7 = -(bombingPath[bombingPathIdx - 1 << 2] - bombingPath[4 * bombingPathIdx]);
            n6 = -(bombingPath[(bombingPathIdx - 1 << 2) + 1] - bombingPath[4 * bombingPathIdx + 1]);
            n5 = Utils.Distance((bombingPath[4 * (bombingPathIdx - 1)] >> 8) - (bombingPath[4 * bombingPathIdx] >> 8), (bombingPath[4 * (bombingPathIdx - 1) + 1] >> 8) - (bombingPath[4 * bombingPathIdx + 1] >> 8));
            n4 = bombingPath[4 * (bombingPathIdx - 1) + 2];
            n3 = n4 * n7 / n5;
            n2 = n4 * n6 / n5;
            n = Camera.fracPosX + n3 + 40960;
            int n9 = Camera.fracPosY + n2 + 30720;
            Camera.setCenter(n, n9);
            Camera.update();
            n5 = Utils.Distance(bombingPath[4 * bombingPathIdx] - n >> 8, bombingPath[4 * bombingPathIdx + 1] - n9 >> 8);
            if (n5 <= n4 << 4) {
                int n10;
                if (bombingPath[(bombingPathIdx << 2) + 3] != -1) {
                    vm.spawnInstanceByID(bombingPath[(bombingPathIdx << 2) + 3], -1);
                }
                if (++bombingPathIdx >= bombingPath.length / 4 && (n10 = GameImpl.getObjectiveOfType(5)) != -1) {
                    if (GameImpl.isBombingObjectiveCompleted()) {
                        objectives[n10].setState(2);
                    } else {
                        objectives[n10].setState(3);
                    }
                }
            }
        }
        if (bombingTargetsFlags != null) {
            for (n7 = 0; n7 < bombingTargetsFlags.length; ++n7) {
                if (bombingTargetsFlags[n7] == 0) {
                    if (bombingTargets[2 * n7] - Camera.posX <= 0 || bombingTargets[2 * n7] - Camera.posX >= 320 || bombingTargets[2 * n7 + 1] - Camera.posY <= 0 || bombingTargets[2 * n7 + 1] - Camera.posY >= 240) continue;
                    GameImpl.bombingTargetsFlags[n7] = 1;
                    GameImpl.bombingTargetsAnims[2 * n7] = Utils.random(320) << 8;
                    GameImpl.bombingTargetsAnims[2 * n7 + 1] = 61440;
                    continue;
                }
                if (bombingTargetsFlags[n7] != 1) continue;
                n6 = -(bombingTargetsAnims[2 * n7] >> 8) + (bombingTargets[2 * n7] - Camera.posX);
                n5 = -(bombingTargetsAnims[2 * n7 + 1] >> 8) + (bombingTargets[2 * n7 + 1] - Camera.posY);
                n4 = Utils.Distance(n6, n5);
                n3 = n4 / 2;
                if (n3 < 5) {
                    n3 = 5;
                }
                n2 = n3 * n6 / n4;
                n = n3 * n5 / n4;
                int n11 = 2 * n7;
                bombingTargetsAnims[n11] = bombingTargetsAnims[n11] + (n2 << 8);
                int n12 = 2 * n7 + 1;
                bombingTargetsAnims[n12] = bombingTargetsAnims[n12] + (n << 8);
                if (Utils.Distance((bombingTargetsAnims[2 * n7] >> 8) - (bombingTargets[2 * n7] - Camera.posX), (bombingTargetsAnims[2 * n7 + 1] >> 8) - (bombingTargets[2 * n7 + 1] - Camera.posY)) >= 5) continue;
                GameImpl.bombingTargetsFlags[n7] = 2;
                int n13 = 2 * n7;
                bombingTargetsAnims[n13] = bombingTargetsAnims[n13] + (bombingTargets[2 * n7] - Camera.posX);
                int n14 = 2 * n7 + 1;
                bombingTargetsAnims[n14] = bombingTargetsAnims[n14] + (bombingTargets[2 * n7 + 1] - Camera.posY);
            }
        }
    }

    private void updateAllies() {
        for (int i = 0; i < numAllies; ++i) {
            allies[i].update();
        }
    }

    public void updateEntities() {
        int n;
        for (n = 0; n < numEnemies; ++n) {
            enemies[n].update();
        }
        for (n = 0; n < numBarracks; ++n) {
            barracks[n].update();
        }
        if (gameMode == 1) {
            for (n = 0; n < numMachineguns; ++n) {
                machineguns[n].update();
            }
            for (n = 0; n < numTriggers; ++n) {
                triggers[n].update();
            }
        }
        for (n = 0; n < numExplodables; ++n) {
            explodables[n].update();
        }
        for (n = 0; n < numEntities; ++n) {
            entities[n].update();
        }
        n = -1;
        while (++n < tempEntities.size()) {
            Entity entity = (Entity)tempEntities.elementAt(n);
            if (!entity.finished) continue;
            tempEntities.removeElement(entity);
        }
        int n2 = tempEntities.size();
        for (int i = 0; i < n2; ++i) {
            Entity entity = (Entity)tempEntities.elementAt(i);
            entity.update();
            if (i >= tempEntities.size() || tempEntities.elementAt(i) == entity) continue;
            --i;
            --n2;
        }
        if (gameMode == 1) {
            player.update();
            this.updateHudModel();
        }
        this.updateCamera();
    }

    public void changeToNextWeapon() {
        if (Utils.isFlagSet(levels[currentLevel][6], 2)) {
            return;
        }
        int n = 0;
        do {
            player.setNextWeapon();
        } while (GameImpl.player.weaponAmmunition[GameImpl.player.currentWeapon] <= 0 && ++n <= GameImpl.player.numWeapons);
    }

    public static void setPlayState(int n) {
        soundManager.stopSounds();
        if (machineGunPlaying) {
            GameImpl.playSoundRepeated(8);
        }
        switch (playState) {
            case 1: {
                godMode = pGodMode;
                break;
            }
            case 3: {
                break;
            }
        }
        switch (n) {
            case 4: {
                tutorialPhase = 0;
                GameImpl.reworkDialogLayout();
                break;
            }
            case 3: {
                msgSkip = false;
                GameImpl.reworkDialogLayout();
                break;
            }
            case 7: {
                GameImpl.menu.transitionAnimation = true;
                GameImpl.menu.transitionOpen = false;
                GameImpl.menu.transitionState = state;
                GameImpl.menu.transitionFinished = false;
                GameImpl.menu.transitionPos = 67;
                fadingFinished = false;
                break;
            }
            case 6: {
                GameImpl.menu.transitionAnimation = true;
                GameImpl.menu.transitionOpen = true;
                GameImpl.menu.transitionState = state;
                GameImpl.menu.transitionFinished = false;
                GameImpl.menu.transitionPos = 0;
                fadingFinished = false;
                break;
            }
            case 8: {
                faded = false;
                GameImpl.setState(2);
                menu.setMenuState(2);
                GameImpl.menu.menuIndex = 0;
                break;
            }
            case 9: {
                int n2;
                GameImpl.menu.startListPos = 0;
                GameImpl.menu.menuIndex = 0;
                endLevelAchievementsCounter = 0;
                GameImpl.menu.numShownObjectives = 0;
                for (n2 = 0; n2 < numObjectives; ++n2) {
                    if (GameImpl.objectives[n2].state == 0) continue;
                    ++GameImpl.menu.numShownObjectives;
                }
                GameImpl.menu.numVisibleObjectives = GameImpl.menu.numShownObjectives;
                for (n2 = 0; n2 < achievementCount; ++n2) {
                    if (!continueAchievementCompleted[n2] && (beforeLevelAchievementCompleted[n2] || !achievementCompleted[n2])) continue;
                    ++endLevelAchievementsCounter;
                }
                break;
            }
            case 11: 
            case 12: {
                bCleanMemory = true;
                break;
            }
            case 10: {
                if (objTimer != -1) {
                    objTimer = 0;
                    postponeEndLevel = true;
                    return;
                }
                if (n == 3) {
                    postponeEndLevel = true;
                    return;
                }
                bCleanMemory = true;
                break;
            }
            case 1: {
                pGodMode = godMode;
                godMode = true;
                if (forceCinematicBars || playState == 3) break;
                cinematicBarHeight = 0;
                break;
            }
            case 0: {
                if (gameMode == 1) {
                    showUI = true;
                }
                if (sprites[13] == null && fonts[3] == null) break;
                GameImpl.sprites[13] = null;
                GameImpl.fonts[3] = null;
                GameImpl.fonts[2] = null;
                System.gc();
            }
        }
        playState = (byte)n;
        SDKCanvas.disableInput(0);
    }

    public static void storeCompletedAchievements() {
        for (int i = 0; i < achievementCount; ++i) {
            GameImpl.beforeLevelAchievementCompleted[i] = achievementCompleted[i];
        }
    }

    public static void incrementLevel() {
        if (currentLevel >= levels.length - 1) {
            GameImpl.setState(2);
            return;
        }
        if (++currentLevel != 8 && currentLevel != 4 && currentLevel != 6) {
            saveDataPart = null;
        }
        GameImpl.deleteLevelSave();
        if (currentLevel != 8 && currentLevel != 4 && currentLevel != 6) {
            for (int i = 0; i < achievementCount; ++i) {
                GameImpl.continueAchievementCompleted[i] = false;
            }
            GameImpl.saveAchievements();
        }
        currentMaxUnlockedLevel = Math.max(currentLevel, currentMaxUnlockedLevel);
        GameImpl.saveSettings();
        GameImpl.menu.stackPos = 0;
        GameImpl.storeCompletedAchievements();
        GameImpl.changeGameMode((byte)levels[currentLevel][3], false, false);
        SDKCanvas.disableInput(1);
    }

    public static void fadeInToPlayState(int n) {
        transitionToState = n;
        faded = false;
        fadingFinished = false;
        GameImpl.setPlayState(6);
    }

    public static void fadeOutToPlayState(int n) {
        transitionToState = n;
        faded = false;
        fadingFinished = false;
        GameImpl.setPlayState(7);
    }

    public static void fadeOutToGameState(int n) {
        transitionToState = n;
        faded = false;
        fadingFinished = false;
        isTransitionToGameState = true;
        GameImpl.setPlayState(7);
    }

    public static void cameraManualControl(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 8;
        for (n5 = 0; n5 < MAP_KP_ORIENTATION.length; ++n5) {
            if (!SDKCanvas.isKeyPressed(MAP_KP_ORIENTATION[n5][0]) || n6 != MAP_KP_ORIENTATION[n5][1]) continue;
            n6 = MAP_KP_ORIENTATION[n5][2];
        }
        if (n6 != 8) {
            n5 = Camera.posX + 160 + (X_ORIENTATION_FACTOR[n6] * 20 >> 8);
            int n7 = Camera.posY + 120 + (Y_ORIENTATION_FACTOR[n6] * 20 >> 8);
            if (n - n5 > n3 || n - n5 < -n3) {
                n5 = Camera.posX + 160;
            }
            if (n2 - n7 > n4 || n2 - n7 < -n4) {
                n7 = Camera.posY + 120;
            }
            Camera.moveCenterTo(n5 << 8, n7 << 8);
        }
    }

    public void updateCamera() {
        if (gameMode != 1) {
            return;
        }
        if (playState == 0) {
            if (GameImpl.player.target == null) {
                Camera.update();
                return;
            }
            if (GameImpl.player.state == 8) {
                Camera.moveCenterTo(GameImpl.player.posX + GameImpl.player.machinegun.targetPosX >> 1, GameImpl.player.posY + GameImpl.player.machinegun.targetPosY >> 1);
            } else if (GameImpl.player.state == 13) {
                GameImpl.cameraManualControl(GameImpl.player.posX >> 8, GameImpl.player.posY >> 8, 160, 120);
            } else if (GameImpl.player.target.mode != 1) {
                if (GameImpl.player.target.isLocked() || GameImpl.player.target.state == 1) {
                    Enemy enemy = GameImpl.player.target.enemyTarget;
                    int n = enemy.posX - GameImpl.player.posX;
                    int n2 = enemy.posY - GameImpl.player.posY;
                    Camera.moveCenterTo(GameImpl.player.posX + (n >> 1), GameImpl.player.posY + (n2 >> 1));
                } else if (cameraLastPOrientation != GameImpl.player.orientation) {
                    cameraLastPOrientation = GameImpl.player.orientation;
                    cameraFrameCounter = 0;
                } else {
                    int n = GameImpl.player.posX + CAMERA_OFFSET[GameImpl.player.orientation][0];
                    int n3 = Camera.fracPosX + 40960;
                    int n4 = GameImpl.player.posY + CAMERA_OFFSET[GameImpl.player.orientation][1];
                    int n5 = Camera.fracPosY + 30720;
                    int n6 = Utils.Distance(n - n3 >> 8, n4 - n5 >> 8);
                    if (n6 == 0) {
                        n6 = 1;
                    }
                    if (cameraFrameCounter == 0 && cameraLastPState == 1 && GameImpl.player.state == 1) {
                        cameraFrameCounter = GameImpl.player.speed * 6;
                    }
                    int n7 = cameraFrameCounter * (n - n3) / n6;
                    int n8 = cameraFrameCounter * (n4 - n5) / n6;
                    if (cameraFrameCounter < n6) {
                        Camera.moveCenterTo(n3 + n7, n5 + n8);
                    } else {
                        Camera.moveCenterTo(n, n4);
                    }
                    ++cameraFrameCounter;
                }
                cameraLastPState = GameImpl.player.state;
            } else {
                Camera.moveCenterTo(GameImpl.player.target.posX, GameImpl.player.target.posY);
            }
        } else if (playState == 1 && cameraTarget != null) {
            int n;
            int n9 = Enemy.isEnemy(cameraTarget) ? ((Enemy)GameImpl.cameraTarget).posX : (n = AlliedCharacter.isCharacter(cameraTarget) ? ((AlliedCharacter)GameImpl.cameraTarget).posX : ((Character)GameImpl.cameraTarget).posX);
            int n10 = Enemy.isEnemy(cameraTarget) ? ((Enemy)GameImpl.cameraTarget).posY : (AlliedCharacter.isCharacter(cameraTarget) ? ((AlliedCharacter)GameImpl.cameraTarget).posY : ((Character)GameImpl.cameraTarget).posY);
            Camera.moveCenterTo(n, n10);
        }
        Camera.update();
    }

    public static void spawnBlastAnimation(int n, int n2, int n3, int n4, int n5, int n6, byte by) {
        int n7;
        Entity entity;
        int n8;
        int n9;
        GameImpl.spawnTempAnimation(n, n2, n3, n4);
        if (gameMode == 1 && Utils.Distance(GameImpl.player.posX - n, GameImpl.player.posY - n2) >> 8 < n5) {
            player.getBlasted(n6 >> (GameImpl.player.isCovered ? 2 : 1));
        }
        if (gameMode == 1 || gameMode == 3) {
            for (n9 = 0; n9 < numAllies; ++n9) {
                if (Utils.Distance(GameImpl.allies[n9].posX - n, GameImpl.allies[n9].posY - n2) >> 8 >= n5) continue;
                allies[n9].getBlasted(n6 >> 1);
            }
        }
        n9 = 0;
        for (n8 = 0; n8 < numEnemies; ++n8) {
            entity = enemies[n8];
            if (entity.state == 1 || entity.state == 17 || (n7 = Utils.Distance(entity.posX - n, entity.posY - n2)) >> 8 >= n5) continue;
            if (n3 == 9) {
                Character.bigExpl = true;
            }
            ((Enemy)entity).takeDamage(n6, n, n2);
            if (((Enemy)entity).life > 0) continue;
            ++n9;
        }
        if (by == 1) {
            currentGrenadeKillCount += n9;
            shouldCheckAchievements = n9 > 1;
        } else if (by == 3) {
            currentBombKillCount += n9;
            boolean bl = shouldCheckAchievements = n9 > 1;
        }
        if (gameMode == 1) {
            for (n8 = 0; n8 < numEntities; ++n8) {
                entity = entities[n8];
                if (entity.type != 15 || entity.sData[1] == 1 || (n7 = Utils.Distance(((AnimatedEntity)entity).posX - n, ((AnimatedEntity)entity).posY - n2)) >> 8 >= n5) continue;
                entity.sData[1] = 1;
                GameImpl.spawnBlastAnimation(((AnimatedEntity)entity).posX, ((AnimatedEntity)entity).posY, 9, Utils.random(1), 106, n6, (byte)0);
            }
        }
        if (n4 == 1) {
            int n10;
            int[] nArray = new int[90];
            int n11 = 0;
            for (n10 = 0; n10 < 2; ++n10) {
                GameImpl.setDecoratorsClip((n >> 8) - (n5 << 1), (n2 >> 8) - (n5 << 1), n5 << 2, n5 << 2);
                GameImpl.clipDecorators(n10 == 0);
                for (int i = 0; i < fixedCount; ++i) {
                    int[] nArray2;
                    n8 = fixedIdx[i];
                    int n12 = staticDecoratorData[n8] >> 0 & 0xFF;
                    n7 = staticDecoratorData[n8] >> 8 & 0xFF;
                    int n13 = staticDecoratorData[n8] >> 16 & 0xFF;
                    int n14 = staticDecoratorPos[n8] & 0xFFFF;
                    int n15 = staticDecoratorPos[n8] >> 16 & 0xFFFF;
                    if (Map.getCollisionAt(n14, n15) == 3) {
                        int[] nArray3 = sprites[n12].RectFrame(n7, n14, n15, n13);
                        if (!Utils.collBoxCircle(nArray3[0], nArray3[1], nArray3[2] - nArray3[0], nArray3[3] - nArray3[1], n >> 8, n2 >> 8, n5)) continue;
                        GameImpl.setFlagStaticDecorator(n8, 16);
                        nArray[2 * n11] = n14;
                        nArray[2 * n11 + 1] = n15;
                        ++n11;
                        Map._bResetCDB = true;
                        continue;
                    }
                    int n16 = GameImpl.getDestructibleArrayIndex(n12, n7);
                    if ((n13 & 0x20) != 0 || n16 == -1 || !Utils.collBoxCircle((nArray2 = sprites[n12].RectFrame(n7, n14, n15, n13))[0], nArray2[1], nArray2[2] - nArray2[0], nArray2[3] - nArray2[1], n >> 8, n2 >> 8, n5)) continue;
                    if (destructibleDecorators[4 * n16 + 3] == 1) {
                        GameImpl.setFlagStaticDecorator(n8, 32);
                        Entity entity2 = new Entity(105);
                        entity2.sData[0] = (short)n14;
                        entity2.sData[1] = (short)n15;
                        entity2.sData[2] = (short)n3;
                        entity2.sData[3] = (short)n4;
                        entity2.sData[5] = (short)n5;
                        entity2.sData[4] = (short)n6;
                        entity2.sData[6] = (short)n8;
                        entity2.sData[7] = (short)n7;
                        tempEntities.addElement(entity2);
                    } else {
                        GameImpl.setFlagStaticDecorator(n8, 64);
                        Map._bResetCDB = true;
                    }
                    if (n7 != 0 || n12 != 14) continue;
                    int n17 = n5 >> 1;
                    if (n17 <= 0) {
                        n17 = 1;
                    }
                    byte[] byArray = new byte[]{2, (byte)(-n17), (byte)(-n17), (byte)(n17 << 1), (byte)(n17 << 1)};
                    for (int j = 0; j < numTriggers; ++j) {
                        if (GameImpl.triggers[j].type != 24 || !Utils.isColliding(GameImpl.triggers[j].sData[0], GameImpl.triggers[j].sData[1], GameImpl.triggers[j].bData, n >> 8, n2 >> 8, byArray)) continue;
                        GameImpl.triggers[j].state = 2;
                    }
                }
            }
            for (n10 = 0; n10 < n11; ++n10) {
                if (Map.getCollisionAt(nArray[2 * n10], nArray[2 * n10 + 1]) != 3) continue;
                GameImpl.destroyCollisionAndSavePos(nArray[2 * n10], nArray[2 * n10 + 1]);
            }
            nArray = null;
        }
    }

    public static void spawnLoot(int n, int n2) {
        int n3;
        if (gameMode != 1) {
            return;
        }
        if (Utils.Distance(GameImpl.player.posX - n, GameImpl.player.posY - n2) > 153600) {
            return;
        }
        int n4 = Utils.random(100);
        int n5 = -1;
        long l = SDKCanvas.getInstance().getAppTime();
        if (GameImpl.player.life <= 50 && n4 >= 50 && l - lastHealthLootTime > 24000L) {
            n5 = 6;
            lastHealthLootTime = l;
        } else if (GameImpl.player.life <= 20 && n4 >= 10 && l - lastHealthLootTime > 24000L) {
            n5 = 6;
            lastHealthLootTime = l;
        } else if (!Utils.isFlagSet(levels[currentLevel][6], 2)) {
            for (n3 = 0; n3 < GameImpl.player.numWeapons; ++n3) {
                if (GameImpl.player.weaponAmmunition[n3] != 0 && (GameImpl.player.weaponAmmunition[n3] > GameImpl.player.weaponClass[n3].bData[4] >> 1 || n4 < 50) || GameImpl.player.weaponClass[n3].bData[0] == 1 || l - lastAmmoLootTime <= 24000L) continue;
                switch (GameImpl.player.weaponClass[n3].bData[0]) {
                    case 0: {
                        n5 = 0;
                        lastAmmoLootTime = l;
                    }
                }
                break;
            }
        }
        if (n5 == -1) {
            return;
        }
        n3 = GameImpl.findColision(n >> 8, n2 >> 8, 50, 15);
        AnimatedEntity animatedEntity = new AnimatedEntity(25);
        animatedEntity.posX = Map.collision_tile_h * (n3 & 0xFF) << 8;
        animatedEntity.posY = Map.collision_tile_w * (n3 >> 16) << 8;
        animatedEntity.state = n5;
        tempEntities.addElement(animatedEntity);
    }

    public static void spawnTempAnimationWithRandomFrame(int n, int n2, int n3, int n4) {
        AnimatedEntity animatedEntity = GameImpl.spawnTempAnimation(n, n2, n3, n4);
        animatedEntity.animator._crt_aframe = Utils.random(sprites[n3].GetAnimLength(n4) >> 1);
    }

    public static AnimatedEntity spawnTempAnimation(int n, int n2, int n3, int n4) {
        AnimatedEntity animatedEntity = new AnimatedEntity(104);
        animatedEntity.posX = n;
        animatedEntity.posY = n2;
        animatedEntity.animator._sprite = n3;
        animatedEntity.animator._flags |= 0x800;
        animatedEntity.animator.SetCrtAnim(n4);
        tempEntities.addElement(animatedEntity);
        return animatedEntity;
    }

    public static void activateAssist(int n, int n2, int n3, int n4, int n5) {
    }

    public static void activateBarracks(int n, int n2, int n3) {
        for (int i = 0; i < numBarracks; ++i) {
            int n4;
            int n5;
            if (GameImpl.barracks[i].state != 0 || Utils.Distance(n - (n5 = GameImpl.barracks[i].posX >> 8), n2 - (n4 = GameImpl.barracks[i].posY >> 8)) >= n3) continue;
            boolean bl = true;
            block1: for (int j = 0; j < 2; ++j) {
                GameImpl.clipDecorators(j == 0);
                if (!bl) break;
                for (int k = 0; k < fixedCount; ++k) {
                    int n6 = fixedIdx[k];
                    int n7 = staticDecoratorData[n6] >> 0 & 0xFF;
                    int n8 = staticDecoratorData[n6] >> 8 & 0xFF;
                    int n9 = staticDecoratorData[n6] >> 16 & 0xFF;
                    int n10 = staticDecoratorPos[n6] & 0xFFFF;
                    int n11 = staticDecoratorPos[n6] >> 16 & 0xFFFF;
                    int[] nArray = sprites[n7].RectFrame(n8, n10, n11, n9);
                    if ((n9 & 0x40) == 0 || n5 < nArray[0] || n5 > nArray[2] || n4 < nArray[1] || n4 > nArray[3]) continue;
                    bl = false;
                    continue block1;
                }
            }
            if (!bl) continue;
            barracks[i].activateBarrack(n, n2);
        }
        GameImpl.activateAssist(n, n2, GameImpl.player.posX >> 8, GameImpl.player.posY >> 8, n3);
    }

    public static AnimatedEntity createGrenade(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        AnimatedEntity animatedEntity = new AnimatedEntity(103);
        animatedEntity.animator.SetCrtFrame(GRENADE_FRAME_ORIENTATION_MAPPING[n6]);
        animatedEntity.bData[0] = 3;
        animatedEntity.bData[1] = 0;
        animatedEntity.bData[3] = 1;
        animatedEntity.iData[0] = n;
        animatedEntity.iData[1] = n2;
        animatedEntity.iData[4] = animatedEntity.iData[7] = n5;
        animatedEntity.iData[2] = n3 - n;
        animatedEntity.iData[3] = n4 - (n2 - n5);
        int n8 = Utils.Distance(animatedEntity.iData[2], animatedEntity.iData[3]);
        animatedEntity.bData[2] = (byte)(n8 / (n7 == 1 ? 1500 : 3000));
        if (animatedEntity.bData[2] == 0) {
            animatedEntity.bData[2] = 1;
        }
        animatedEntity.iData[8] = (n7 == 1 ? 240 : 300) * 3000 >> 8;
        animatedEntity.iData[5] = animatedEntity.iData[8];
        animatedEntity.iData[6] = (animatedEntity.iData[5] << 1) / animatedEntity.bData[2];
        animatedEntity.bData[4] = (byte)n7;
        tempEntities.addElement(animatedEntity);
        return animatedEntity;
    }

    public static Entity getWeaponClassByType(int n) {
        for (int i = 0; i < numWeponClasses; ++i) {
            if (GameImpl.weaponClasses[i].bData[0] != n) continue;
            return weaponClasses[i];
        }
        return null;
    }

    public void drawEndLevelHeader(SDKGraphics sDKGraphics) {
        SDKUtils.setFont(fonts[1]);
        string = SDKUtils.getString(216, string);
        wrapOffsets = SDKUtils.wrapString(string, wrapOffsets, 320, (short)124);
        SDKUtils.drawWrappedString(string, wrapOffsets, 1, wrapOffsets[0], 160, 41, 17);
    }

    public void drawEndLevelAchievements(SDKGraphics sDKGraphics, int n) {
        int n2 = -(endLevelAchievementsPage * 3);
        SDKUtils.setFont(fonts[0]);
        for (int i = 0; i < achievementCount; ++i) {
            if (!continueAchievementCompleted[i] && (beforeLevelAchievementCompleted[i] || !achievementCompleted[i])) continue;
            if (++n2 > 3) {
                return;
            }
            if (n2 <= 0) continue;
            string = SDKUtils.getString(achievementName[i], string);
            stringBuffer.setLength(0);
            stringBuffer.append(string);
            if (i >= 18) {
                if (!Utils.isFlagSet(levels[i - 18][6], 8) || i == 21 || i == 23) {
                    --n2;
                    continue;
                }
                if (i == 22 && !achievementCompleted[21] || i == 24 && !achievementCompleted[23]) continue;
                stringBuffer.append("\"");
                string = SDKUtils.getString(levels[i - 18][4], string);
                stringBuffer.append(string);
                stringBuffer.append("\"");
            }
            sprites[10].DrawFrame(5, 118, n, 0);
            wrapOffsets = SDKUtils.wrapString(stringBuffer, wrapOffsets, 280, (short)124);
            SDKUtils.drawWrappedString(stringBuffer, wrapOffsets, 1, wrapOffsets[0], 38, n + 21 - 4, 6);
            n += 43;
        }
    }

    public void drawGame(SDKGraphics sDKGraphics) {
        block34: {
            block36: {
                block35: {
                    if (playState == 9) {
                        XSprite.setTempDrawScaled(false);
                        this.drawEndLevelHeader(sDKGraphics);
                        menu.drawObjectivesStartingFrom(sDKGraphics, 83, false);
                        this.drawSoftkeys(sDKGraphics);
                        XSprite.restoreDrawScaled();
                        return;
                    }
                    if (playState == 11) {
                        XSprite.setTempDrawScaled(false);
                        this.drawEndLevelHeader(sDKGraphics);
                        this.drawEndLevelAchievements(sDKGraphics, 83);
                        this.drawSoftkeys(sDKGraphics);
                        XSprite.restoreDrawScaled();
                        return;
                    }
                    sDKGraphics.setClip(0, 0, 320, 240);
                    Map.CDB_Draw(sDKGraphics);
                    XSprite.SetGraphics(sDKGraphics);
                    SDKUtils.setFont(fonts[0]);
                    switch (gameMode) {
                        case 3: {
                            XSprite.setDrawScaled(true);
                            GameImpl.drawEntities(sDKGraphics);
                            if (scopeDraw) break;
                            XSprite.setTempDrawScaled(false);
                            GameImpl.drawCinematicBars(sDKGraphics);
                            this.drawSoftkeys(sDKGraphics);
                            this.drawSniper(sDKGraphics);
                            this.drawSniperHud(sDKGraphics);
                            XSprite.restoreDrawScaled();
                            break;
                        }
                        case 2: {
                            XSprite.setDrawScaled(true);
                            GameImpl.drawEntities(sDKGraphics);
                            if (playState == 12) {
                                GameImpl.fakeFillRect(sDKGraphics, 0, 0, 320, 240);
                                return;
                            }
                            if (!Utils.isFlagSet(levels[currentLevel][6], 16)) {
                                GameImpl.drawBombingHud(sDKGraphics);
                            }
                            GameImpl.drawCinematicBars(sDKGraphics);
                            this.drawSoftkeys(sDKGraphics);
                            this.drawBombingTarget(sDKGraphics);
                            break;
                        }
                        default: {
                            if (player.getWeponType() == 2 && GameImpl.player.state != 8 && !GameImpl.player.canStealthKill && !GameImpl.player.canComboStealthKill) {
                                GameImpl.drawShotgunArea(sDKGraphics);
                            }
                            for (int i = 0; i < numAreaEnemies; ++i) {
                                enemies[areaEnemies[i]].drawTargetGrenade(sDKGraphics);
                            }
                            GameImpl.drawFireRange(sDKGraphics);
                            if (GameImpl.player.target != null) {
                                if (GameImpl.player.target.mode == 1) {
                                    GameImpl.player.target.draw(sDKGraphics);
                                    GameImpl.drawEntities(sDKGraphics);
                                } else {
                                    GameImpl.drawEntities(sDKGraphics);
                                    GameImpl.player.target.draw(sDKGraphics);
                                }
                            }
                            if ((playState == 0 || playState == 4 && dialogMode == 7 || playState == 1) && playState != 1) {
                                this.drawHud(sDKGraphics);
                            }
                            GameImpl.drawCinematicBars(sDKGraphics);
                            if ((playState == 0 || playState == 4 && dialogMode == 7 || playState == 1) && raceLevel && raceTime >= 0) {
                                Object object = SDKUtils.getFont();
                                SDKUtils.setFont(fonts[0]);
                                GameImpl.convertTimeIntoString(raceTime, stringBuffer);
                                SDKUtils.drawString(stringBuffer, 160, 0, 1);
                                SDKUtils.setFont(object);
                            }
                            this.drawSoftkeys(sDKGraphics);
                        }
                    }
                    if (playState == 2) {
                        GameImpl.fakeFillRect(sDKGraphics, 0, 0, 320, 240);
                        string = SDKUtils.getString(8, string);
                        SDKUtils.setFont(fonts[1]);
                        SDKUtils.drawString(string, 160, 120, 3);
                        this.drawSoftkeys(sDKGraphics);
                        return;
                    }
                    if (playState == 10) {
                        GameImpl.fakeFillRect(sDKGraphics, 0, 0, 320, 240);
                        string = SDKUtils.getString(216, string);
                        SDKUtils.setFont(fonts[1]);
                        XSprite.setTempDrawScaled(false);
                        sDKGraphics.setColor(0);
                        GameImpl.fakeFillRect(sDKGraphics, 0, 117, 320, 40);
                        sprites[10].DrawFrame(0, 20, 146, 0);
                        XSprite.restoreDrawScaled();
                        this.drawSoftkeys(sDKGraphics);
                        SDKUtils.drawString(string, 160, 120, 3);
                        return;
                    }
                    if (playState == 3 && (gameMode != 3 || scopeDraw || !sniperScopeOn)) {
                        this.drawDialog(sDKGraphics);
                    }
                    if (playState != 4 || gameMode == 3 && !scopeDraw && sniperScopeOn || Camera.state != 0) break block34;
                    XSprite.setTempDrawScaled(false);
                    if (!hudAnimator.IsCrtAnimEnded()) break block35;
                    short s = hudModel[5];
                    hudModel[5] = (short)(s + 1);
                    if (s % 14 >= 7) break block36;
                }
                if (dialogMode == 7) {
                    hudAnimator.DrawCrtAnimOnScreenCoordinates(sDKGraphics, tutorialBoxX, tutorialBoxY);
                } else {
                    hudAnimator.DrawCrtAnim(sDKGraphics, tutorialBoxX, tutorialBoxY);
                }
            }
            XSprite.restoreDrawScaled();
            if (hudAnimator.IsCrtAnimEnded()) {
                this.drawDialog(sDKGraphics);
            }
        }
        if (lastCompletedAchievementIDX != -1) {
            if (currentLevel == 6 && lastCompletedAchievementIDX >= 18) {
                lastCompletedAchievementIDX = -1;
                return;
            }
            if (achievementDisplayTime == -1L) {
                achievementDisplayTime = SDKCanvas.getInstance().getAppTime();
            }
            if (SDKCanvas.getInstance().getAppTime() < achievementDisplayTime + 6000L) {
                sDKGraphics.setColor(0);
                GameImpl.fakeFillRect(sDKGraphics, 0, 20, 320, 57);
                XSprite.setTempDrawScaled(false);
                sprites[10].DrawFrame(0, 20, 49, 0);
                XSprite.restoreDrawScaled();
                string = SDKUtils.getString(achievementName[lastCompletedAchievementIDX], string);
                stringBuffer.setLength(0);
                stringBuffer.append(string);
                if (lastCompletedAchievementIDX >= 18) {
                    stringBuffer.append("\"");
                    string = SDKUtils.getString(levels[currentLevel][4], string);
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                }
                SDKUtils.setFont(fonts[0]);
                wrapOffsets = SDKUtils.wrapString(stringBuffer, wrapOffsets, 280, (short)124);
                SDKUtils.drawWrappedString(stringBuffer, wrapOffsets, 1, wrapOffsets[0], 178, 55, 3);
                string = SDKUtils.getString(47, string);
                SDKUtils.setFont(fonts[0]);
                SDKUtils.drawString(string, 160, 20, 17);
            } else {
                lastCompletedAchievementIDX = -1;
                achievementDisplayTime = -1L;
            }
        }
        if (saveTimer / 5 % 3 > 0) {
            XSprite.setTempDrawScaled(false);
            sprites[7].DrawFrame(45, 16, 9, 0);
            XSprite.restoreDrawScaled();
        }
        if (saveTimer > 0) {
            SDKUtils.setFont(fonts[0]);
            string = SDKUtils.getString(319, string);
            SDKUtils.drawString(string, 31, 6, 6);
        }
        XSprite.setTempDrawScaled(false);
        if (playState == 6 || playState == 7) {
            menu.drawTransitionAnimation(sDKGraphics);
        }
        if (faded) {
            this.clearScreen(sDKGraphics, 0);
        }
        XSprite.restoreDrawScaled();
    }

    public static void drawShotgunArea(SDKGraphics sDKGraphics) {
        if (playState == 0) {
            int n = (GameImpl.player.posX >> 8) - Camera.posX;
            int n2 = (GameImpl.player.posY >> 8) - Camera.posY;
            sprites[10].DrawFrame(Character.F_SHOTGUN_DAMAGE_AREA[GameImpl.player.orientation], n, n2, 0);
            sDKGraphics.setColor(0x990000);
            sDKGraphics.drawLine(n + SHOTGUN_LEFT_LINE_OFFSET_X[GameImpl.player.orientation], n2 + SHOTGUN_LEFT_LINE_OFFSET_Y[GameImpl.player.orientation], n, n2);
            sDKGraphics.drawLine(n + SHOTGUN_RIGHT_LINE_OFFSET_X[GameImpl.player.orientation], n2 + SHOTGUN_RIGHT_LINE_OFFSET_Y[GameImpl.player.orientation], n, n2);
        }
    }

    public static void drawCinematicBars(SDKGraphics sDKGraphics) {
        if (playState == 1 || forceCinematicBars) {
            if (cinematicBarHeight < 13) {
                cinematicBarHeight += 3;
            }
            GameImpl.fakeFillRect(sDKGraphics, 0, 0, 320, cinematicBarHeight);
            GameImpl.fakeFillRect(sDKGraphics, 0, 240 - cinematicBarHeight, 320, cinematicBarHeight);
        }
    }

    public static void drawCDBEntities() {
        GameImpl.clipDecorators(true);
        Utils.QuickSort(fixedWeights, fixedIdx, 0, fixedCount - 1);
        for (int i = 0; i < fixedCount; ++i) {
            GameImpl.drawStaticDecorator(fixedIdx[i]);
        }
    }

    public static void drawEntities(SDKGraphics sDKGraphics) {
        XSprite.SetGraphics(sDKGraphics);
        GameImpl.setDecoratorsClip(Camera.posX, Camera.posY, 320, 240);
        GameImpl.clipDecorators(false);
        Utils.QuickSort(fixedWeights, fixedIdx, 0, fixedCount - 1);
        GameImpl.clipDynamicEntities();
        Utils.QuickSort(dynamicWeights, dynamicIdx, 0, dynamicCount - 1);
        int n = 0;
        int n2 = 0;
        while (n < fixedCount && n2 < dynamicCount) {
            if (fixedWeights[n] < dynamicWeights[n2]) {
                GameImpl.drawStaticDecorator(fixedIdx[n++]);
                continue;
            }
            GameImpl.drawDynamicEntity(n2++, sDKGraphics);
        }
        while (n < fixedCount) {
            GameImpl.drawStaticDecorator(fixedIdx[n++]);
        }
        while (n2 < dynamicCount) {
            GameImpl.drawDynamicEntity(n2++, sDKGraphics);
        }
    }

    public static void drawDynamicEntity(int n, SDKGraphics sDKGraphics) {
        int n2 = dynamicIdx[n] & 0xFFFF;
        int n3 = dynamicIdx[n] >> 16 & 0xFFFF;
        switch (n2) {
            case 1: {
                player.draw(sDKGraphics);
                break;
            }
            case 2: {
                enemies[n3].draw(sDKGraphics);
                break;
            }
            case 4: {
                entities[n3].draw(sDKGraphics);
                break;
            }
            case 8: {
                ((Entity)tempEntities.elementAt(n3)).draw(sDKGraphics);
                break;
            }
            case 16: {
                allies[n3].draw(sDKGraphics);
                break;
            }
            case 32: {
                machineguns[n3].draw(sDKGraphics);
                break;
            }
            case 64: {
                hidingPlaces[n3].draw(sDKGraphics);
                break;
            }
            case 128: {
                explodables[n3].draw(sDKGraphics);
            }
        }
    }

    public static void drawStaticDecorator(int n) {
        int n2 = staticDecoratorPos[n] & 0xFFFF;
        int n3 = staticDecoratorPos[n] >> 16 & 0xFFFF;
        if (GameImpl.isDecoratorAnimated(n)) {
            int n4 = staticDecoratorData[n] >> 16 & 0xFF;
            if ((n4 & 0x10) == 0) {
                for (int i = 0; i < 12; ++i) {
                    if (decoratorsAnimID[i] != n) continue;
                    decoratorsAnim[i].DrawCrtAnim(XSprite._g, n2, n3);
                    decoratorsAnim[i].UpdateCrtAnim();
                    break;
                }
            }
        } else {
            int n5 = staticDecoratorData[n] >> 0 & 0xFF;
            int n6 = staticDecoratorData[n] >> 8 & 0xFF;
            int n7 = staticDecoratorData[n] >> 16 & 0xFF;
            if ((n7 & 0x40) != 0) {
                int n8 = GameImpl.getDestructibleArrayIndex(n5, n6);
                if (n8 != -1) {
                    int n9 = n2 - Camera.posX;
                    int n10 = n3 - Camera.posY;
                    sprites[n5].DrawFrame(destructibleDecorators[4 * n8 + 2], n9, n10, n7);
                }
            } else if ((n7 & 0x10) == 0) {
                int n11 = n2 - Camera.posX;
                int n12 = n3 - Camera.posY;
                sprites[n5].DrawFrame(n6, n11, n12, n7);
            }
        }
    }

    public static void drawFireRange(SDKGraphics sDKGraphics) {
        if (currentLevel != 7 && currentLevel != 8) {
            return;
        }
        for (int i = 0; i < 12; ++i) {
            if (decoratorsAnim[i] == null) continue;
            int n = staticDecoratorPos[decoratorsAnimID[i]] & 0xFFFF;
            int n2 = staticDecoratorPos[decoratorsAnimID[i]] >> 16 & 0xFFFF;
            int[] nArray = new int[]{0xAACC22, 9808935, 8358957, 6908723, 5458489};
            for (int j = 0; j < 5; ++j) {
                sDKGraphics.setColor(nArray[j]);
                sDKGraphics.drawArc(n - Camera.posX - 80 + j * 1, n2 - Camera.posY - 40 - 5 + j * 1, 160 - j * 2 * 1, 80 - j * 2, 0, 360);
            }
        }
    }

    private void drawBombingTarget(SDKGraphics sDKGraphics) {
        if (hideTarget) {
            return;
        }
        XSprite.setTempDrawScaled(false);
        sprites[5].DrawFrame(24, targetX >> 8, targetY >> 8, 0);
        if (!Utils.isFlagSet(levels[currentLevel][6], 16) && bombingTargetsFlags != null && bombingTargetsAnims != null) {
            for (int i = 0; i < bombingTargetsAnims.length >> 1; ++i) {
                if (bombingTargetsFlags[i] == 1) {
                    sprites[5].DrawFrame(0, bombingTargetsAnims[2 * i] >> 8, bombingTargetsAnims[2 * i + 1] >> 8, 0);
                    continue;
                }
                if (bombingTargetsFlags[i] == 2) {
                    int n = Utils.Distance((targetX >> 8) - (bombingTargets[2 * i] - Camera.posX), (targetY >> 8) - (bombingTargets[2 * i + 1] - Camera.posY));
                    if (n > 20) {
                        sprites[5].DrawFrame(21, bombingTargets[2 * i] - Camera.posX, bombingTargets[2 * i + 1] - Camera.posY, 0);
                        continue;
                    }
                    sprites[5].DrawFrame(22, bombingTargets[2 * i] - Camera.posX, bombingTargets[2 * i + 1] - Camera.posY, 0);
                    continue;
                }
                if (bombingTargetsFlags[i] != 3) continue;
                sprites[5].DrawFrame(1, bombingTargets[2 * i] - Camera.posX, bombingTargets[2 * i + 1] - Camera.posY, 0);
            }
        }
        XSprite.restoreDrawScaled();
    }

    private void clearScreen(SDKGraphics sDKGraphics, int n) {
        sDKGraphics.setClip(0, 0, 320, 240);
        sDKGraphics.setColor(n);
        sDKGraphics.fillRect(0, 0, 320, 240);
    }

    public static void convertTimeIntoString(int n, SDKString sDKString) {
        sDKString.setLength(0);
        int n2 = n / 60;
        int n3 = n % 60;
        if (n2 < 10) {
            sDKString.append("0");
        }
        sDKString.append(n2);
        sDKString.append(":");
        if (n3 < 10) {
            sDKString.append("0");
        }
        sDKString.append(n3);
    }

    public static boolean destroyCollisionAndSavePos(int n, int n2) {
        GameImpl.destroyedCollisionsPosX[GameImpl.numDestroyedCollisions] = (short)n;
        GameImpl.destroyedCollisionsPosY[GameImpl.numDestroyedCollisions] = (short)n2;
        ++numDestroyedCollisions;
        return GameImpl.destroyCollision(n, n2);
    }

    public static boolean destroyCollision(int n, int n2) {
        boolean bl = false;
        if (Map.getCollisionAt(n, n2) == 3) {
            Map.setCollisionAt(n, n2, 15);
            GameImpl.destroyCollision(n - Map.collision_tile_w, n2);
            GameImpl.destroyCollision(n + Map.collision_tile_w, n2);
            GameImpl.destroyCollision(n, n2 - Map.collision_tile_h);
            GameImpl.destroyCollision(n, n2 + Map.collision_tile_h);
            bl = true;
        }
        return bl;
    }

    public static boolean isCollisionPassable(int n, int n2) {
        return Map.getCollisionAt(n, n2) == 15;
    }

    public static boolean isCollisionCover(int n, int n2) {
        return Map.getCollisionAt(n, n2) == 1;
    }

    public static int getFirstCollision(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n;
        int n8 = n2;
        int n9 = n3 - n;
        int n10 = n4 - n2;
        int n11 = n9 > 0 ? 1 : (n6 = n9 < 0 ? -1 : 0);
        int n12 = n10 > 0 ? 1 : (n10 < 0 ? -1 : 0);
        int n13 = n8 * Map._coll_map_tw + n7;
        int n14 = n12 * Map._coll_map_tw;
        n9 = n9 < 0 ? -n9 : n9;
        int n15 = n10 = n10 < 0 ? -n10 : n10;
        if (n9 > n10) {
            int n16 = n10 - n9;
            while (true) {
                if (Map.getCollision(n13) == n5) {
                    return n8 << 16 | n7;
                }
                if (n7 == n3) {
                    return -1;
                }
                if (n16 >= 0) {
                    n16 -= n9;
                    n8 += n12;
                    n13 += n14;
                }
                n7 += n6;
                n16 += n10;
                n13 += n6;
            }
        }
        int n17 = n9 - n10;
        while (Map.getCollision(n13) != n5) {
            if (n8 == n4) {
                return -1;
            }
            if (n17 >= 0) {
                n17 -= n10;
                n7 += n6;
                n13 += n6;
            }
            n8 += n12;
            n17 += n9;
            n13 += n14;
        }
        return n8 << 16 | n7;
    }

    public static int getCoverPosition(int n, int n2, int n3, int n4) {
        int n5 = 3 * n + n3 >> 10;
        int n6 = 3 * n2 + n4 >> 10;
        int n7 = GameImpl.findColision(n5, n6, 24, 1);
        if (n7 == -1) {
            return -1;
        }
        return GameImpl.findCoverLimit((n3 >> 8) / Map.collision_tile_h, (n4 >> 8) / Map.collision_tile_w, n7 & 0xFF, n7 >> 16);
    }

    public static int findColision(int n, int n2, int n3, int n4) {
        int n5 = (n2 /= Map.collision_tile_w) * Map._coll_map_tw + (n /= Map.collision_tile_h);
        int n6 = -1;
        for (int i = 1; i < n3; ++i) {
            for (int j = 1; j < i; ++j) {
                n5 = (n2 + n6 * j) * Map._coll_map_tw + n;
                if (n5 < Map._coll_map_size && Map.getCollision(n5) == n4) {
                    return n | n2 + n6 * j << 16;
                }
                n5 = (n2 + n6 * (i - 1)) * Map._coll_map_tw + (n + n6 * j);
                if (n5 >= Map._coll_map_size || Map.getCollision(n5) != n4) continue;
                return n2 + n6 * (i - 1) << 16 | n + n6 * j;
            }
            n += n6 * (i - 1);
            n2 += n6 * (i - 1);
            n6 = -n6;
        }
        return -1;
    }

    private static int findCoverLimit(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3 > n ? 1 : (n5 = n3 < n ? -1 : 0);
        int n7 = n4 > n2 ? 1 : (n4 < n2 ? -1 : 0);
        for (int i = 1; i < 10; ++i) {
            int n8 = (n4 + n7 * i) * Map._coll_map_tw + (n3 + n5 * i);
            if (Map.getCollision(n8) != 15) continue;
            return n4 + n7 * i << 16 | n3 + n5 * i;
        }
        return -1;
    }

    public static boolean isSomethingInBetween(int n, int n2, int n3, int n4, int n5) {
        int n6 = GameImpl.getFirstCollision(n /= Map.collision_tile_h, n2 /= Map.collision_tile_w, n3 /= Map.collision_tile_h, n4 /= Map.collision_tile_w, n5);
        return n6 != -1;
    }

    public static boolean isInSight(int n, int n2, int n3, int n4, int n5) {
        return Y_ORIENTATION_FACTOR[n3] * (n5 - n2) >= -(X_ORIENTATION_FACTOR[n3] << 1) * (n4 - n);
    }

    public static boolean isVisible(int n, int n2, int n3, int n4) {
        int n5 = GameImpl.getFirstCollision(n /= Map.collision_tile_h, n2 /= Map.collision_tile_w, n3 /= Map.collision_tile_h, n4 /= Map.collision_tile_w, 0);
        return n5 == -1;
    }

    public static boolean collideBullet(int n, int n2, int n3, int n4) {
        int n5 = GameImpl.getFirstCollision(n /= Map.collision_tile_h, n2 /= Map.collision_tile_w, n3 /= Map.collision_tile_h, n4 /= Map.collision_tile_w, 0);
        return n5 != -1;
    }

    public static boolean collideBulletWithCover(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = GameImpl.getFirstCollision(n /= Map.collision_tile_h, n2 /= Map.collision_tile_w, n3 /= Map.collision_tile_h, n4 /= Map.collision_tile_w, 1);
        if (n5 == -1) {
            return false;
        }
        int n6 = n5 & 0xFFFF;
        int n7 = n5 >> 16 & 0xFFFF;
        if (Math.abs(n7 - n2) > 2 && Math.abs(n6 - n) > 2) {
            return false;
        }
        if (GameImpl.isCoverLine(n6, n2, n6, n7)) {
            if (bl) {
                GameImpl.spawnTempAnimation(n6 * Map.collision_tile_h << 8, (n7 - 2) * Map.collision_tile_w << 8, 8, BULLET_DUST_ANIM[GameImpl.getBulletOrientation(n3, n4, n, n2)]);
            }
            return true;
        }
        if (GameImpl.isCoverLine(n, n7, n6, n7)) {
            if (bl) {
                GameImpl.spawnTempAnimation(n6 * Map.collision_tile_h << 8, (n7 - 2) * Map.collision_tile_w << 8, 8, BULLET_DUST_ANIM[GameImpl.getBulletOrientation(n3, n4, n, n2)]);
            }
            return true;
        }
        return false;
    }

    public static boolean isCoverLine(int n, int n2, int n3, int n4) {
        int n5;
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        n5 = n2 * Map._coll_map_tw + n;
        if (n == n3) {
            int n6 = n2;
            while (n6 <= n4) {
                if (Map.getCollision(n5) != 1) {
                    return false;
                }
                ++n6;
                n5 += Map._coll_map_tw;
            }
        } else {
            int n7 = n;
            while (n7 <= n3) {
                if (Map.getCollision(n5) != 1) {
                    return false;
                }
                ++n7;
                ++n5;
            }
        }
        return true;
    }

    public static int getBulletOrientation(int n, int n2, int n3, int n4) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        return GameImpl.getOrientation(n5, n6);
    }

    public static boolean canCover(int n, int n2, int n3, boolean bl) {
        if (!bl) {
            int n4 = n / Map.collision_tile_h;
            int n5 = n2 / Map.collision_tile_w;
            int n6 = n5 * Map._coll_map_tw + n4;
            int n7 = X_ORIENTATION_DX_FACTOR[n3] + Y_ORIENTATION_DY_FACTOR[n3] * Map._coll_map_tw;
            for (int i = 0; i < 2; ++i) {
                if ((n6 += n7) <= 0 || n6 >= Map._coll_map_size || Map.getCollision(n6) != 1) continue;
                return true;
            }
            return false;
        }
        int n8 = n / Map.collision_tile_h - 2;
        int n9 = n2 / Map.collision_tile_w - 2;
        int n10 = n9 * Map._coll_map_tw + n8;
        int n11 = 4;
        int n12 = 0;
        while (n12 <= n11) {
            for (int i = 0; i <= n11; ++i) {
                if (n10 + i <= 0 || n10 + i >= Map._coll_map_size || Map.getCollision(n10 + i) != 1) continue;
                return true;
            }
            ++n12;
            n10 += Map._coll_map_tw;
        }
        return false;
    }

    public static int getCollisionPosition(int n, int n2, int n3, int n4, int n5) {
        return GameImpl.getFirstCollision(n /= Map.collision_tile_h, n2 /= Map.collision_tile_w, n3 /= Map.collision_tile_h, n4 /= Map.collision_tile_w, n5);
    }

    static int getOrientation(int n, int n2) {
        int n3 = Utils.Distance(n, n2);
        if (n3 > 0) {
            int n4 = (-n2 << 8) / n3;
            if (n4 < 97 && n4 > -97 && n > 0) {
                return 2;
            }
            if (n4 < 97 && n4 > -97 && n < 0) {
                return 6;
            }
            if (n4 <= -237) {
                return 4;
            }
            if (n4 >= 237) {
                return 0;
            }
            if (n4 >= 97 && n4 < 237 && n > 0) {
                return 1;
            }
            if (n4 >= 97 && n4 < 237 && n < 0) {
                return 7;
            }
            if (n4 <= -97 && n4 > -237 && n > 0) {
                return 3;
            }
            if (n4 <= -97 && n4 > -237 && n < 0) {
                return 5;
            }
        }
        return 0;
    }

    static int getExtendedOrientation(int n, int n2) {
        int n3 = Utils.Distance(n, n2);
        if (n3 > 0) {
            int n4 = (-n2 << 8) / n3;
            if (n4 > -49 && n4 < 49 && n > 0) {
                return 4;
            }
            if (n4 > -49 && n4 < 49 && n < 0) {
                return 12;
            }
            if (n4 <= -250) {
                return 8;
            }
            if (n4 >= 250) {
                return 0;
            }
            if (n4 >= 49 && n4 < 140 && n > 0) {
                return 3;
            }
            if (n4 >= 140 && n4 < 212 && n > 0) {
                return 2;
            }
            if (n4 >= 212 && n4 < 250 && n > 0) {
                return 1;
            }
            if (n4 >= 49 && n4 < 140 && n < 0) {
                return 13;
            }
            if (n4 >= 140 && n4 < 212 && n < 0) {
                return 14;
            }
            if (n4 >= 212 && n4 < 250 && n < 0) {
                return 15;
            }
            if (n4 <= -49 && n4 > -140 && n > 0) {
                return 5;
            }
            if (n4 <= -140 && n4 > -212 && n > 0) {
                return 6;
            }
            if (n4 <= -212 && n4 > -250 && n > 0) {
                return 7;
            }
            if (n4 <= -49 && n4 > -140 && n < 0) {
                return 11;
            }
            if (n4 <= -140 && n4 > -212 && n < 0) {
                return 10;
            }
            if (n4 <= -212 && n4 > -250 && n < 0) {
                return 9;
            }
        }
        return 0;
    }

    static void FillRect(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5) {
        sDKGraphics.setColor(n);
        sDKGraphics.fillRect(n2, n3, n4, n5);
    }

    public static void fakeFillRect(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4) {
        sDKGraphics.setClip(n, n2, n3, n4);
        sDKGraphics.setColor(0);
        for (int i = n - n4; i < n3; i += 2) {
            sDKGraphics.drawLine(i, n2, n3, n2 + n3 - i);
        }
        sDKGraphics.setClip(0, 0, 320, 240);
    }

    static void initKDTree() {
        int n;
        kdIndices = new short[numStaticDecorators * 2 + 1];
        kdChildren = new int[numStaticDecorators * 2 + 1];
        staticDecoratorEosOrder = new short[numStaticDecorators];
        for (n = 0; n < numStaticDecorators; ++n) {
            GameImpl.staticDecoratorEosOrder[n] = (short)n;
        }
        Utils.setRandomSeed(System.currentTimeMillis());
        numNodes = 0;
        GameImpl.buildKDTree(0, numStaticDecorators - 1, 0);
        n = 0;
        for (int i = 0; i < numStaticDecorators; ++i) {
            if (!GameImpl.isDecoratorAnimated(i)) continue;
            Animator animator = new Animator();
            animator._sprite = staticDecoratorData[i] >> 0 & 0xFF;
            animator.SetCrtAnim(staticDecoratorData[i] >> 8 & 0xFF);
            GameImpl.decoratorsAnimID[n] = i;
            GameImpl.decoratorsAnim[n] = animator;
            ++n;
        }
    }

    static int buildKDTree(int n, int n2, int n3) {
        int n4 = numNodes++;
        if (n2 <= n) {
            GameImpl.kdIndices[n4] = (short)((n << 1) + n3);
            GameImpl.kdChildren[n4] = 0;
        } else {
            int n5 = GameImpl.findMedian(n, n2, n3 << 4, n + (n2 - n) / 2);
            int n6 = staticDecoratorPos[n5] >> (n3 << 4) & 0xFFFF;
            GameImpl.kdChildren[n4] = GameImpl.buildKDTree(n, n5, ~n3 & 1) + (GameImpl.buildKDTree(n5 + 1, n2, ~n3 & 1) << 16);
            GameImpl.kdIndices[n4] = (short)((n6 << 1) + n3);
        }
        return n4;
    }

    static int findMedian(int n, int n2, int n3, int n4) {
        int n5 = Utils.random(n, n2);
        GameImpl.switchStaticDecorators(n2, n5);
        int n6 = staticDecoratorPos[n2] >> n3 & 0xFFFF;
        int n7 = n;
        for (int i = n; i < n2; ++i) {
            if ((staticDecoratorPos[i] >> n3 & 0xFFFF) > n6) continue;
            GameImpl.switchStaticDecorators(n7, i);
            ++n7;
        }
        GameImpl.switchStaticDecorators(n7, n2);
        if (n4 == n7) {
            return n7;
        }
        if (n4 < n7) {
            return GameImpl.findMedian(n, n7 - 1, n3, n4);
        }
        return GameImpl.findMedian(n7 + 1, n2, n3, n4);
    }

    static void switchStaticDecorators(int n, int n2) {
        int n3 = staticDecoratorPos[n];
        GameImpl.staticDecoratorPos[n] = staticDecoratorPos[n2];
        GameImpl.staticDecoratorPos[n2] = n3;
        n3 = staticDecoratorData[n];
        GameImpl.staticDecoratorData[n] = staticDecoratorData[n2];
        GameImpl.staticDecoratorData[n2] = n3;
        n3 = staticDecoratorEosOrder[n];
        GameImpl.staticDecoratorEosOrder[n] = staticDecoratorEosOrder[n2];
        GameImpl.staticDecoratorEosOrder[n2] = (short)n3;
        n3 = staticDecoratorIds[n];
        GameImpl.staticDecoratorIds[n] = staticDecoratorIds[n2];
        GameImpl.staticDecoratorIds[n2] = (short)n3;
    }

    static void clipDynamicEntities() {
        int n;
        int n2;
        Entity entity;
        int n3;
        Utils.CreateRect(rectScreen, Camera.posX, Camera.posY, 320, 240);
        Utils.RectExpand(rectClip, rectScreen, 20);
        dynamicCount = 0;
        if (gameMode == 1) {
            if (Utils.PointInRect(rectClip, GameImpl.player.posX >> 8, GameImpl.player.posY >> 8)) {
                GameImpl.addDynamicEntity(1, GameImpl.calcWeight(1, 0, GameImpl.player.posY >> 8));
            }
            for (n3 = 0; n3 < numHidingPlaces; ++n3) {
                entity = hidingPlaces[n3];
                n2 = entity.posX >> 8;
                n = entity.posY >> 8;
                if (!Utils.PointInRect(rectClip, n2, n)) continue;
                GameImpl.addDynamicEntity(0x40 | n3 << 16, GameImpl.calcWeight(0, 0, n));
            }
        }
        if (gameMode == 1 || gameMode == 3) {
            for (n3 = 0; n3 < numAllies; ++n3) {
                entity = allies[n3];
                if (!Utils.PointInRect(rectClip, entity.posX >> 8, entity.posY >> 8)) continue;
                GameImpl.addDynamicEntity(0x10 | n3 << 16, GameImpl.calcWeight(1, 0, entity.posY >> 8));
            }
        }
        for (n3 = 0; n3 < numExplodables; ++n3) {
            entity = explodables[n3];
            n2 = entity.posX >> 8;
            n = entity.posY >> 8;
            sprites[((AnimatedEntity)entity).animator._sprite].RectFrame(((AnimatedEntity)entity).animator._crt_aframe, n2, n, 0);
            if (!Utils.RectIntersect(rectClip, XSprite._rect)) continue;
            GameImpl.addDynamicEntity(0x80 | n3 << 16, GameImpl.calcWeight(1, 0, n));
        }
        for (n3 = 0; n3 < numAreaEnemies; ++n3) {
            entity = enemies[areaEnemies[n3]];
            n2 = entity.posX >> 8;
            n = entity.posY >> 8;
            if (!Utils.PointInRect(rectClip, n2, n)) continue;
            GameImpl.addDynamicEntity(2 | areaEnemies[n3] << 16, GameImpl.calcWeight(1, 0, n));
        }
        for (n3 = 0; n3 < numMachineguns; ++n3) {
            entity = machineguns[n3];
            n2 = entity.posX >> 8;
            n = entity.posY >> 8;
            if (!Utils.PointInRect(rectClip, n2, n)) continue;
            GameImpl.addDynamicEntity(0x20 | n3 << 16, GameImpl.calcWeight(2, 0, n));
        }
        for (n3 = 0; n3 < tempEntities.size(); ++n3) {
            entity = (Entity)tempEntities.elementAt(n3);
            if (entity.type != 103 && entity.type != 104 && entity.type != 25 || !Utils.PointInRect(rectClip, n2 = ((AnimatedEntity)entity).posX >> 8, n = ((AnimatedEntity)entity).posY >> 8)) continue;
            GameImpl.addDynamicEntity(8 | n3 << 16, GameImpl.calcWeight(entity.type == 25 ? 1 : 2, 0, n));
        }
        for (n3 = 0; n3 < numEntities; ++n3) {
            entity = entities[n3];
            if (!AnimatedEntity.isAnimatedEntity(entity) || !Utils.PointInRect(rectClip, n2 = ((AnimatedEntity)entity).posX >> 8, n = ((AnimatedEntity)entity).posY >> 8)) continue;
            GameImpl.addDynamicEntity(4 | n3 << 16, GameImpl.calcWeight(1, 0, n));
        }
    }

    static int calcWeight(int n, int n2, int n3) {
        if (n == 0) {
            return n2;
        }
        return n << 16 | n3 & 0xFFFF;
    }

    static void addDynamicEntity(int n, int n2) {
        if (dynamicCount >= 50) {
            return;
        }
        GameImpl.dynamicIdx[GameImpl.dynamicCount] = n;
        GameImpl.dynamicWeights[GameImpl.dynamicCount] = n2;
        ++dynamicCount;
    }

    static void setDecoratorsClip(int n, int n2, int n3, int n4) {
        Utils.CreateRect(rectScreen, n, n2, n3, n4);
        Utils.RectExpand(rectClip, rectScreen, 100);
    }

    static void clipDecorators(boolean bl) {
        fixedCount = 0;
        findBackgroundDecorators = bl;
        GameImpl.findClippedDecorators(0, 0, 0, 0xFFFFFFF, 0xFFFFFFF);
    }

    static void findClippedDecorators(int n, int n2, int n3, int n4, int n5) {
        if (kdChildren[n] == 0) {
            if (GameImpl.isDecoratorInRect(kdIndices[n] >> 1, rectClip)) {
                GameImpl.selectDecorator(kdIndices[n] >> 1);
            }
        } else {
            int n6 = kdChildren[n] & 0xFFFF;
            int n7 = kdChildren[n] >> 16 & 0xFFFF;
            Utils.RectAssign(rectTemp, n2, n3, n4, n5);
            if (GameImpl.computeChildRegion(n, true, rectTemp)) {
                if (Utils.IsRectInRect(Utils.rect, rectClip)) {
                    GameImpl.selectTree(n6);
                } else if (Utils.RectIntersect(Utils.rect, rectClip)) {
                    GameImpl.findClippedDecorators(n6, Utils.rect[0], Utils.rect[1], Utils.rect[2], Utils.rect[3]);
                }
            }
            Utils.RectAssign(rectTemp, n2, n3, n4, n5);
            if (GameImpl.computeChildRegion(n, false, rectTemp)) {
                if (Utils.IsRectInRect(Utils.rect, rectClip)) {
                    GameImpl.selectTree(n7);
                } else if (Utils.RectIntersect(Utils.rect, rectClip)) {
                    GameImpl.findClippedDecorators(n7, Utils.rect[0], Utils.rect[1], Utils.rect[2], Utils.rect[3]);
                }
            }
        }
    }

    static boolean computeChildRegion(int n, boolean bl, int[] nArray) {
        int n2 = kdIndices[n] & 1;
        int n3 = kdIndices[n] >> 1;
        if (n2 == 0) {
            if (n3 >= nArray[0] && n3 <= nArray[2]) {
                Utils.RectAssign(Utils.rect, bl ? nArray[0] : n3, nArray[1], bl ? n3 : nArray[2], nArray[3]);
                return true;
            }
            return false;
        }
        if (n3 >= nArray[1] && n3 <= nArray[3]) {
            Utils.RectAssign(Utils.rect, nArray[0], bl ? nArray[1] : n3, nArray[2], bl ? n3 : nArray[3]);
            return true;
        }
        return false;
    }

    static boolean isDecoratorHidden(int n) {
        int n2 = staticDecoratorData[n] >> 16 & 0xFF;
        return (n2 & 8) != 0;
    }

    static boolean isDecoratorAnimated(int n) {
        int n2 = staticDecoratorData[n] >> 16 & 0xFF;
        return (n2 & 0x80) != 0;
    }

    static void showHiddenDecorators() {
        for (int i = 0; i < numStaticDecorators; ++i) {
            if (!GameImpl.isDecoratorHidden(i)) continue;
            int n = i;
            staticDecoratorData[n] = staticDecoratorData[n] & 0xFFF7FFFF;
        }
    }

    static boolean isDecoratorInRect(int n, int[] nArray) {
        int n2;
        int n3 = staticDecoratorData[n] >> 0 & 0xFF;
        int n4 = staticDecoratorPos[n] & 0xFFFF;
        int n5 = staticDecoratorPos[n] >> 16 & 0xFFFF;
        int n6 = staticDecoratorData[n] >> 8 & 0xFF;
        if (GameImpl.isDecoratorAnimated(n)) {
            for (n2 = 0; n2 < 12; ++n2) {
                if (decoratorsAnimID[n2] != n) continue;
                n6 = decoratorsAnim[n2].GetCrtAFrameIdx();
                break;
            }
        }
        n2 = staticDecoratorData[n] >> 16 & 0xFF;
        sprites[n3].RectFrame(n6, n4, n5, n2);
        return Utils.RectIntersect(nArray, XSprite._rect);
    }

    static void selectTree(int n) {
        if (kdChildren[n] == 0) {
            GameImpl.selectDecorator(kdIndices[n] >> 1);
        } else {
            GameImpl.selectTree(kdChildren[n] & 0xFFFF);
            GameImpl.selectTree(kdChildren[n] >> 16 & 0xFFFF);
        }
    }

    static void selectDecorator(int n) {
        if (fixedCount >= 100) {
            return;
        }
        if (GameImpl.isDecoratorInRect(n, rectScreen)) {
            if (GameImpl.isDecoratorHidden(n)) {
                return;
            }
            int n2 = staticDecoratorData[n] >> 24 & 0xFF;
            if (findBackgroundDecorators && n2 != 0) {
                return;
            }
            if (!findBackgroundDecorators && n2 == 0) {
                return;
            }
            int n3 = staticDecoratorPos[n] >> 16 & 0xFFFF;
            GameImpl.fixedIdx[GameImpl.fixedCount] = n;
            GameImpl.fixedWeights[GameImpl.fixedCount] = GameImpl.calcWeight(n2, staticDecoratorEosOrder[n], n3);
            ++fixedCount;
        }
    }

    public static void setFlagStaticDecorator(int n, int n2) {
        int n3 = n;
        staticDecoratorData[n3] = staticDecoratorData[n3] | (staticDecoratorData[n] >> 16 & 0xFF | n2) << 16;
    }

    public static int getDestructibleArrayIndex(int n, int n2) {
        for (int i = 0; i < destructibleDecorators.length >> 2; ++i) {
            if (n != destructibleDecorators[4 * i] || n2 != destructibleDecorators[4 * i + 1]) continue;
            return i;
        }
        return -1;
    }

    public void update(long l) {
        Debug.startTimer(0);
        try {
            switch (state) {
                case 9: {
                    if (SDKCanvas.isNewKeyPressed(513)) {
                        if (--currentLanguage < 0) {
                            currentLanguage = numLangsLoaded - 1;
                        }
                    } else if (SDKCanvas.isNewKeyPressed(32770)) {
                        currentLanguage = (currentLanguage + 1) % numLangsLoaded;
                    }
                    if (!SDKCanvas.isKeyPressed(32)) break;
                    SDKUtils.setCurrentLanguage(currentLanguage);
                    GameImpl.setState(5);
                    break;
                }
                case 5: {
                    if (SDKCanvas.isKeyPressed(524352)) {
                        soundManager.setSoundEnabled(false);
                        GameImpl.setState(6);
                        splashDisplayTime = l;
                    }
                    if (!SDKCanvas.isKeyPressed(32)) break;
                    soundManager.setSoundEnabled(true);
                    GameImpl.setState(6);
                    splashDisplayTime = l;
                    break;
                }
                case 7: {
                    if (SDKCanvas.isKeyPressed(524352)) {
                        GameImpl.setState(2);
                    }
                    if (!SDKCanvas.isKeyPressed(32)) break;
                    SDKMIDlet.exit();
                    break;
                }
                case 8: {
                    if (SDKCanvas.isKeyPressed(524352)) {
                        GameImpl.setState(2);
                    }
                    if (!SDKCanvas.isKeyPressed(32)) break;
                    machineGunPlaying = false;
                    for (int i = 0; i < achievementCount; ++i) {
                        GameImpl.continueAchievementCompleted[i] = false;
                    }
                    GameImpl.saveAchievements();
                    menu.startNewLevel(GameImpl.menu.levelToStart);
                    break;
                }
                case 6: {
                    if (l - splashDisplayTime > 2500L) {
                        GameImpl.setState(0);
                    }
                    Thread.sleep(10L);
                    break;
                }
                case 0: {
                    if (loadState >= 7) {
                        GameImpl.setState(2);
                        menu.setMenuState(1);
                        break;
                    }
                    this.loadData();
                    break;
                }
                case 1: {
                    this.updateGame();
                    break;
                }
                case 2: {
                    menu.update();
                    break;
                }
                case 3: {
                    if (mgInstance.isActive()) {
                        mgInstance.update();
                    } else {
                        GameImpl.setState(2);
                    }
                    if (Menu.soundStartTimer <= 0 || --Menu.soundStartTimer != 0 || !soundManager.isSoundEnabled()) break;
                    soundManager.stopSounds();
                    GameImpl.playSoundRepeated(6);
                    Menu.soundStartTimer = -1;
                    break;
                }
                case 4: {
                    if (loadLevelState < 11) {
                        this.doGameLoading();
                        break;
                    }
                    if (!skipBriefing) break;
                    Camera.state = 0;
                    GameImpl.initGame();
                }
            }
            Debug.stopTimer(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void changeGameMode(byte by, boolean bl, boolean bl2) {
        if (bl) {
            GameImpl.saveLevel();
        }
        Map.fillTile = false;
        Map.useSmallCDB = false;
        Map.useLights = false;
        gameMode = by;
        switch (gameMode) {
            case 2: {
                Map.useLights = false;
                XSprite.setDrawScaled(true);
                break;
            }
            case 3: {
                Map.useLights = false;
                XSprite.setDrawScaled(true);
                break;
            }
            default: {
                XSprite.setDrawScaled(false);
            }
        }
        skipBriefing = bl2;
        GameImpl.setState(4);
    }

    public static void scaleWorldPositions() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < numEnemies; ++n3) {
            GameImpl.enemies[n3].posX >>= 1;
            GameImpl.enemies[n3].posY >>= 1;
            if (GameImpl.enemies[n3].waypoints != null) {
                n2 = GameImpl.enemies[n3].waypoints.length;
                for (n = 0; n < n2 >> 1; ++n) {
                    int n4 = n << 1;
                    GameImpl.enemies[n3].waypoints[n4] = GameImpl.enemies[n3].waypoints[n4] >> 1;
                    int n5 = (n << 1) + 1;
                    GameImpl.enemies[n3].waypoints[n5] = GameImpl.enemies[n3].waypoints[n5] >> 1;
                }
            }
            if (GameImpl.enemies[n3].state != 7) continue;
            GameImpl.enemies[n3].pathLength = 0;
        }
        for (n3 = 0; n3 < enemyClasses.length; ++n3) {
            if (enemyClasses[n3] == null) continue;
            GameImpl.enemyClasses[n3].bData[9] = (byte)(GameImpl.enemyClasses[n3].bData[9] >> 1);
        }
        for (n3 = 0; n3 < numAllies; ++n3) {
            GameImpl.allies[n3].posX >>= 1;
            GameImpl.allies[n3].posY >>= 1;
            GameImpl.allies[n3].speed >>= 1;
            if (GameImpl.allies[n3].waypoints == null) continue;
            n2 = GameImpl.allies[n3].waypoints.length;
            for (n = 0; n < n2 >> 1; ++n) {
                int n6 = n << 1;
                GameImpl.allies[n3].waypoints[n6] = GameImpl.allies[n3].waypoints[n6] >> 1;
                int n7 = (n << 1) + 1;
                GameImpl.allies[n3].waypoints[n7] = GameImpl.allies[n3].waypoints[n7] >> 1;
            }
        }
        for (n3 = 0; n3 < numStaticDecorators; ++n3) {
            GameImpl.staticDecoratorPos[n3] = staticDecoratorPos[n3] >> 17 << 16 | (staticDecoratorPos[n3] & 0xFFFF) >> 1;
        }
        for (n3 = 0; n3 < numEntities; ++n3) {
            if (!AnimatedEntity.isAnimatedEntity(entities[n3])) continue;
            ((AnimatedEntity)GameImpl.entities[n3]).posX >>= 1;
            ((AnimatedEntity)GameImpl.entities[n3]).posY >>= 1;
        }
        for (n3 = 0; n3 < numMachineguns; ++n3) {
            GameImpl.machineguns[n3].posX >>= 1;
            GameImpl.machineguns[n3].posY >>= 1;
        }
        for (n3 = 0; n3 < numBarracks; ++n3) {
            GameImpl.barracks[n3].posX >>= 1;
            GameImpl.barracks[n3].posY >>= 1;
        }
    }

    public static void doDialogLayout(int n, int n2) {
        dialogFrame = 0;
        dialogWidth = n == 10 || n == 9 ? (short)300 : (short)235;
        dialogHeight = (short)8;
        dialogMode = (byte)n;
        SDKUtils.setFont(fonts[0]);
        if (currentDialogTitleID != -1) {
            dialogHeight = (short)(dialogHeight + 4);
            dialogHeight = (short)(dialogHeight + SDKUtils.getLineSize());
        }
        if (currentDialogTextID != -1) {
            string = SDKUtils.getString(currentDialogTextID, string);
            wrapOffsets = SDKUtils.wrapString(string, wrapOffsets, dialogWidth - 10, (short)124);
            dialogHeight = (short)(dialogHeight + wrapOffsets[0] * SDKUtils.getLineSize());
        }
    }

    public static void reworkDialogLayout() {
        dialogHeight = (short)8;
        SDKUtils.setFont(fonts[0]);
        if (currentDialogTitleID != -1) {
            dialogHeight = (short)(dialogHeight + 4);
            dialogHeight = (short)(dialogHeight + SDKUtils.getLineSize());
        }
        if (currentDialogTextID != -1) {
            string = SDKUtils.getString(currentDialogTextID, string);
            wrapOffsets = SDKUtils.wrapString(string, wrapOffsets, dialogWidth - 10, (short)124);
            dialogHeight = (short)(dialogHeight + wrapOffsets[0] * SDKUtils.getLineSize());
        }
    }

    public static void loadSplashSprite() {
        if (sprites[13] == null) {
            try {
                Object object;
                Object object2;
                if (sprites[13] == null) {
                    object2 = new SDKInputStream(1);
                    object = new XSprite(13);
                    ((XSprite)object).LoadData((SDKInputStream)object2);
                    ((SDKInputStream)object2).close();
                    object2 = null;
                    GameImpl.loadSpriteGraphics((XSprite)object, 2, 0);
                    GameImpl.sprites[13] = object;
                    object = null;
                    SDKInputStream.purgeCache();
                }
                if (fonts[2] == null || fonts[3] == null) {
                    object2 = SDKInputStream.loadResourceAsByteArray(3);
                    object = new int[]{-1, 5};
                    imgs_font_cool = SDKInputStream.loadImageObjectWithPalette(4, (int[])object);
                    GameImpl.fonts[2] = SDKUtils.loadFont(imgs_font_cool[0], (byte[])object2);
                    GameImpl.fonts[3] = SDKUtils.loadFont(imgs_font_cool[1], (byte[])object2);
                    imgs_font_cool = null;
                    SDKInputStream.purgeCache();
                }
                SDKInputStream.purgeCache();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void setState(int n) {
        if (state == n) {
            return;
        }
        SDKCanvas.disableInput(0);
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (soundManager != null) {
            soundManager.stopSounds();
        }
        XSprite.saved = false;
        switch (state) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                briefingPage = 0;
                break;
            }
            case 0: {
                loadingPercent = 0;
                loadingAnimOffset = 0;
                loadState = 0;
                splashEA = null;
                SDKInputStream.purgeCache();
            }
        }
        switch (n) {
            case 6: {
                splashEA = SDKInputStream.loadImageObject(0);
                break;
            }
            case 0: {
                GameImpl.loadSplashSprite();
                loadState = 0;
                spriteToLoad = -1;
                loadingAnimState = 0;
                break;
            }
            case 1: {
                GameImpl.sprites[13] = null;
                GameImpl.fonts[3] = null;
                GameImpl.fonts[2] = null;
                System.gc();
                playState = savedPlayState;
                break;
            }
            case 2: {
                menu.openMenuWithAnimation();
                bSetStateMenu = true;
                break;
            }
            case 3: {
                SDKUtils.loadStringsChunk(2);
                mgInstance.reset("mnu");
                Menu.soundStartTimer = 20;
                break;
            }
            case 4: {
                loadingAnimState = 0;
                loadLevelState = 0;
                currentSpriteToLoad = 0;
            }
        }
        state = n;
    }

    /*
     * Unable to fully structure code
     */
    public void callFunction(int var1_1, XScriptVirtualMachine var2_2) {
        block0 : switch (var1_1) {
            case 0: {
                var3_3 = Utils.Distance(var2_2.getParam16() - var2_2.getParam16(), var2_2.getParam16() - var2_2.getParam16());
                var2_2.putParam(var3_3);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 1: {
                var2_2.getParam16();
                var2_2.getParam16();
                var2_2.putParam(0);
                var2_2.putParam(GameImpl.player.posX >> 8);
                var2_2.putParam(GameImpl.player.posY >> 8);
                break;
            }
            case 68: {
                var2_2.getParam16();
                var2_2.getParam16();
                var2_2.putParam(0);
                var2_2.putParam(320);
                var2_2.putParam(240);
                break;
            }
            case 2: {
                var2_2.getParam16();
                var2_2.getParam16();
                var4_5 = var2_2.getParam16();
                var7_56 = -1;
                var8_62 = -1;
                if (var4_5 >= 0 && var4_5 < GameImpl.numEnemies && GameImpl.enemies[var4_5].state != 1) {
                    var7_56 = GameImpl.enemies[var4_5].posX >> 8;
                    var8_62 = GameImpl.enemies[var4_5].posY >> 8;
                }
                var2_2.putParam(0);
                var2_2.putParam(var7_56);
                var2_2.putParam(var8_62);
                var2_2.putParam(0);
                break;
            }
            case 3: {
                var4_6 = var2_2.getParam16();
                GameImpl.enemies[var4_6].setState(2);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 6: {
                var4_7 = var2_2.getParam16();
                var5_68 = var2_2.getParam16();
                GameImpl.enemies[var5_68].setCoverState(var4_7 == 1);
                for (var12_91 = 0; var12_91 < 3; ++var12_91) {
                    var2_2.putParam(0);
                }
                break;
            }
            case 7: {
                var4_8 = var2_2.getParam16();
                var2_2.putParam(Utils.random(var4_8));
                var2_2.putParam(0);
                break;
            }
            case 8: {
                var4_9 = var2_2.getParam16();
                var5_69 = var2_2.getParam();
                for (var12_92 = 0; var12_92 < GameImpl.numAllies; ++var12_92) {
                    if (Utils.Distance(GameImpl.player.posX - GameImpl.allies[var12_92].posX, GameImpl.player.posY - GameImpl.allies[var12_92].posY) >> 8 >= var4_9) continue;
                    GameImpl.signalAlly(GameImpl.allies[var12_92], (byte)(var5_69 & 255));
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 9: {
                var4_10 = var2_2.getParam16();
                for (var12_93 = 0; var12_93 < GameImpl.numEntities; ++var12_93) {
                    var13_95 = (AnimatedEntity)GameImpl.entities[var12_93];
                    if (GameImpl.entities[var12_93].type != 15 || GameImpl.entities[var12_93].id != var4_10 || GameImpl.entities[var12_93].sData[1] == 1) continue;
                    GameImpl.spawnBlastAnimation(var13_95.posX, var13_95.posY, 9, Utils.random(1), 106, 100, (byte)0);
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 10: {
                var4_11 = var2_2.getParam16();
                var5_70 = var2_2.getParam16();
                var6_97 = var2_2.getParam();
                if (!GameImpl.msgSkip) {
                    GameImpl.showMessage(var4_11, var5_70, var6_97);
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 11: {
                GameImpl.objectiveShowMsg = true;
                var4_12 = var2_2.getParam16();
                GameImpl.objectiveSetState(var4_12, 1);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 70: {
                GameImpl.objectiveShowMsg = false;
                var4_13 = var2_2.getParam16();
                GameImpl.objectiveSetState(var4_13, 1);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 12: {
                var4_14 = var2_2.getParam16();
                GameImpl.objectiveSetState(var4_14, 2);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 13: {
                var4_15 = var2_2.getParam();
                var5_71 = var2_2.getParam();
                GameImpl.signalTeam((byte)(var4_15 & 255), (byte)(var5_71 & 255));
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 14: {
                var4_16 = var2_2.getParam16();
                var7_57 = var2_2.getParam16();
                var8_63 = var2_2.getParam16();
                this.alertEnemy(var4_16, var7_57, var8_63);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 15: {
                var4_17 = var2_2.getParam16();
                var7_58 = var2_2.getParam16();
                var8_64 = var2_2.getParam16();
                this.tutorialMessage(var4_17, var7_58, var8_64, 6, 0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 31: {
                var4_18 = var2_2.getParam16();
                var7_59 = var2_2.getParam16();
                var8_65 = var2_2.getParam16();
                var5_72 = var2_2.getParam();
                if (GameImpl.displayHints) {
                    this.tutorialMessage(var4_18, var7_59, var8_65, 7, var5_72);
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 16: {
                var4_19 = var2_2.getParam16();
                if (var4_19 == 1) {
                    GameImpl.changeGameMode((byte)1, true, true);
                } else if (var4_19 == 2) {
                    GameImpl.changeGameMode((byte)2, false, true);
                } else {
                    GameImpl.changeGameMode((byte)3, true, true);
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 17: {
                var4_20 = var2_2.getParam16();
                var5_73 = var2_2.getParam16();
                GameImpl.player.setState(0);
                GameImpl.player.posX = var4_20 << 8;
                GameImpl.player.posY = var5_73 << 8;
                GameImpl.player.update();
                if (GameImpl.gameMode == 1 || GameImpl.gameMode == 3) {
                    Camera.setCenter(GameImpl.player.posX, GameImpl.player.posY);
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 18: {
                var4_21 = var2_2.getParam();
                var5_74 = var2_2.getParam16();
                if (var4_21 > 2) {
                    GameImpl.cameraTarget = null;
                    var2_2.putParam(0);
                    var2_2.putParam(0);
                    var2_2.putParam(0);
                    break;
                }
                if (var4_21 == 2) {
                    GameImpl.cameraTarget = GameImpl.player;
                    var2_2.putParam(0);
                    var2_2.putParam(0);
                    var2_2.putParam(0);
                    break;
                }
                var12_94 = var4_21 == 0 ? GameImpl.numEnemies : GameImpl.numAllies;
                var13_96 = var4_21 == 0 ? (Entity[])GameImpl.enemies : (Entity[])GameImpl.allies;
                for (var14_104 = 0; var14_104 < var12_94; ++var14_104) {
                    if (var13_96[var14_104].id != var5_74) continue;
                    GameImpl.cameraTarget = var13_96[var14_104];
                    var2_2.putParam(0);
                    var2_2.putParam(0);
                    var2_2.putParam(0);
                    break block0;
                }
                break;
            }
            case 19: {
                var4_22 = var2_2.getParam16();
                var5_75 = var2_2.getParam();
                this.setEnemyFlag(var4_22, (byte)var5_75);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 52: {
                var4_23 = var2_2.getParam16();
                var5_76 = var2_2.getParam();
                this.unsetEnemyFlag(var4_23, (byte)var5_76);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 20: {
                var4_24 = var2_2.getParam16();
                var5_77 = var2_2.getParam16();
                GameImpl.player.gotoXY(var4_24, var5_77);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 21: {
                var4_25 = var2_2.getParam16();
                var5_78 = var2_2.getParam16();
                if (GameImpl.gameMode == 2) {
                    var4_25 >>= 1;
                    var5_78 >>= 1;
                }
                var6_98 = var2_2.getParam16();
                var3_4 = var2_2.getParam16();
                GameImpl.spawnBlastAnimation(var4_25 << 8, var5_78 << 8, 9, 1, var6_98, var3_4, (byte)0);
                for (var14_105 = 0; var14_105 < 5; ++var14_105) {
                    var2_2.putParam(0);
                }
                break;
            }
            case 22: {
                var2_2.getParam16();
                var2_2.getParam16();
                var2_2.putParam(0);
                var2_2.putParam(Camera.posX + 160);
                var2_2.putParam(Camera.posY + 120);
                break;
            }
            case 23: {
                var4_26 = var2_2.getParam16();
                var5_79 = var2_2.getParam16();
                GameImpl.cameraTarget = null;
                if (GameImpl.gameMode == 2) {
                    var4_26 >>= 1;
                    var5_79 >>= 1;
                }
                Camera.setCenter(var4_26 << 8, var5_79 << 8);
                this.updateCamera();
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 24: {
                var4_27 = var2_2.getParam16();
                GameImpl.setPlayState(var4_27);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 25: {
                var2_2.putParam(GameImpl.playState);
                break;
            }
            case 27: {
                var4_28 = var2_2.getParam16();
                var5_80 = var2_2.getParam16();
                for (var14_106 = 0; var14_106 < GameImpl.numEnemies; ++var14_106) {
                    if (GameImpl.enemies[var14_106].id != var4_28) continue;
                    GameImpl.enemies[var14_106].setState(var5_80);
                    break;
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 26: {
                var4_29 = var2_2.getParam16();
                var14_107 = false;
                for (var15_108 = 0; var15_108 < GameImpl.numEnemies; ++var15_108) {
                    if (GameImpl.enemies[var15_108].id != var4_29) continue;
                    var2_2.putParam(GameImpl.enemies[var15_108].state);
                    var14_107 = true;
                    break;
                }
                if (var14_107) break;
                var2_2.putParam(-1);
                break;
            }
            case 28: {
                GameImpl.fadeInToPlayState(-1);
                var2_2.putParam(0);
                break;
            }
            case 29: {
                GameImpl.fadeOutToPlayState(-1);
                var2_2.putParam(0);
                break;
            }
            case 30: {
                var4_30 = var2_2.getParam();
                if (var4_30 == 0) {
                    GameImpl.showUI = false;
                    GameImpl.msgSkip = false;
                } else {
                    GameImpl.showUI = true;
                    GameImpl.msgSkip = false;
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 33: {
                var4_31 = var2_2.getParam16();
                for (var15_109 = 0; var15_109 < GameImpl.numTriggers; ++var15_109) {
                    if (GameImpl.triggers[var15_109].type != 6 || GameImpl.triggers[var15_109].id != var4_31) continue;
                    GameImpl.triggers[var15_109].state = 1;
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 34: {
                var4_32 = var2_2.getParam16();
                var5_81 = var2_2.getParam16();
                GameImpl.cameraTarget = null;
                if (GameImpl.gameMode == 2) {
                    var4_32 >>= 1;
                    var5_81 >>= 1;
                }
                Camera.moveCenterToWithSpeed(var4_32 << 8, var5_81 << 8, 4);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 35: {
                var4_33 = var2_2.getParam16();
                var10_114 = this.getAllied(var4_33);
                var2_2.putParam(var10_114.state);
                var2_2.putParam(0);
                break;
            }
            case 36: {
                var4_34 = var2_2.getParam16();
                var5_82 = var2_2.getParam16();
                var10_115 = this.getAllied(var4_34);
                if (var10_115 != null) {
                    var10_115.setState(var5_82);
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 37: {
                var4_35 = var2_2.getParam16();
                var10_116 = this.getAllied(var4_35);
                var10_116.posX = var2_2.getParam16() << 8;
                var10_116.posY = var2_2.getParam16() << 8;
                var10_116.isCovered = false;
                var10_116.setState(0);
                var10_116.pathLength = 0;
                var10_116.pathIndex = 0;
                for (var15_110 = 0; var15_110 < 4; ++var15_110) {
                    var2_2.putParam(0);
                }
                break;
            }
            case 38: {
                var4_36 = var2_2.getParam16();
                var10_117 = this.getAllied(var4_36);
                var10_117.life = var2_2.getParam16();
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 39: {
                var4_37 = var2_2.getParam();
                var5_83 = var2_2.getParam16();
                var6_99 = var2_2.getParam16();
                if (var4_37 != 1) ** GOTO lbl380
                GameImpl.player.addSpeechMessage(var6_99);
                ** GOTO lbl390
lbl380:
                // 1 sources

                if (var4_37 != 2) ** GOTO lbl385
                var10_118 = this.getAllied(var5_83);
                if (var10_118 == null) ** GOTO lbl390
                var10_118.addSpeechMessage(var6_99);
                ** GOTO lbl390
lbl385:
                // 1 sources

                if (var4_37 == 3) {
                    for (var15_111 = 0; var15_111 < GameImpl.numEnemies; ++var15_111) {
                        if (GameImpl.enemies[var15_111].id != var5_83) continue;
                        GameImpl.enemies[var15_111].speechMessage = var6_99;
                        break;
                    }
                }
lbl390:
                // 7 sources

                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 40: {
                GameImpl.setPlayState(2);
                var2_2.putParam(0);
                break;
            }
            case 41: {
                GameImpl.saveLevel();
                var2_2.putParam(0);
                break;
            }
            case 42: {
                var9_123 = Utils.collBoxBox(var2_2.getParam16(), var2_2.getParam16(), var2_2.getParam16(), var2_2.getParam16(), var2_2.getParam16(), var2_2.getParam16(), var2_2.getParam16(), var2_2.getParam16());
                var2_2.putParam(var9_123 == true ? 1 : 0);
                for (var15_112 = 0; var15_112 < 6; ++var15_112) {
                    var2_2.putParam(0);
                }
                break;
            }
            case 43: {
                var4_38 = var2_2.getParam16();
                var10_119 = this.getAllied(var4_38);
                var2_2.putParam(var10_119.currentWaypoint);
                var2_2.putParam(0);
                break;
            }
            case 44: {
                var4_39 = var2_2.getParam16();
                var5_84 = var2_2.getParam16();
                var10_120 = this.getAllied(var4_39);
                var10_120.currentWaypoint = var5_84;
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 45: {
                GameImpl.sniperBulletTimeCounter = var2_2.getParam16();
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 46: {
                var4_40 = var2_2.getParam();
                var15_113 = var4_40 == 1;
                v0 = var16_124 = GameImpl.sniperGoingOut != false && GameImpl.sniperScopeOutCounter < GameImpl.sniperScopeOutPositions.length || GameImpl.sniperGoingOut == false && GameImpl.sniperScopeOutCounter >= 0;
                if (var15_113 != GameImpl.sniperScopeOn && !var16_124) {
                    GameImpl.sniperGoingOut = GameImpl.sniperScopeOn;
                    v1 = GameImpl.sniperScopeOutCounter = GameImpl.sniperGoingOut != false ? 0 : GameImpl.sniperScopeOutPositions.length - 1;
                    if (GameImpl.sniperScopeOn) {
                        GameImpl.sniperScopeOn = false;
                    }
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 47: {
                var4_41 = var2_2.getParam16();
                var5_85 = var2_2.getParam16();
                var6_100 = var2_2.getParam16();
                var10_121 = this.getAllied(var4_41);
                v2 = var5_85;
                var10_121.waypointsFlags[v2] = (short)(var10_121.waypointsFlags[v2] | 1 << var6_100);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 48: {
                var4_42 = var2_2.getParam16();
                var5_86 = var2_2.getParam16();
                var6_101 = var2_2.getParam16();
                var10_122 = this.getAllied(var4_42);
                v3 = var5_86;
                var10_122.waypointsFlags[v3] = (short)(var10_122.waypointsFlags[v3] & ~(1 << var6_101));
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 49: {
                var4_43 = var2_2.getParam16();
                var11_125 = this.getEnemy(var4_43);
                var11_125.setOrientation(var2_2.getParam());
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 50: {
                var4_44 = var2_2.getParam16();
                for (var17_127 = 0; var17_127 < GameImpl.numBarracks; ++var17_127) {
                    if (GameImpl.barracks[var17_127].id != var4_44 || GameImpl.barracks[var17_127].state != 0) continue;
                    GameImpl.barracks[var17_127].activateBarrack(GameImpl.player.posX >> 8, GameImpl.player.posY >> 8);
                    break;
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 51: {
                var4_45 = var2_2.getParam16();
                this.addSniperMessage(var4_45);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 32: {
                GameImpl.raceTime = var2_2.getParam16();
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 53: {
                var4_46 = var2_2.getParam();
                if (Map.useLights != (var4_46 == 1)) {
                    Map.useLights = false;
                    Map._bResetCDB = true;
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 54: {
                var4_47 = var2_2.getParam16();
                var5_87 = var2_2.getParam16();
                GameImpl.destroyCollisionAndSavePos(var4_47, var5_87);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 55: {
                var4_48 = var2_2.getParam();
                GameImpl.levels[GameImpl.currentLevel][6] = var4_48 == 0 ? Utils.clearFlag(GameImpl.levels[GameImpl.currentLevel][6], 2) : Utils.setFlag(GameImpl.levels[GameImpl.currentLevel][6], 2);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 56: {
                var4_49 = var2_2.getParam16();
                var5_88 = var2_2.getParam();
                var6_102 = var2_2.getParam();
                var11_126 = this.getEnemy(var4_49);
                if (var5_88 < var11_126.waypointsFlags.length) {
                    if (var6_102 == 1) {
                        v4 = var5_88;
                        var11_126.waypointsFlags[v4] = (byte)(var11_126.waypointsFlags[v4] | 1);
                    } else {
                        v5 = var5_88;
                        var11_126.waypointsFlags[v5] = (byte)(var11_126.waypointsFlags[v5] & -2);
                    }
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 57: {
                var4_50 = var2_2.getParam16();
                var5_89 = var2_2.getParam16();
                GameImpl.cutSceneScript = var4_50;
                GameImpl.skipSceneScript = var5_89;
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 60: {
                GameImpl.playAreaLeftLimit = var2_2.getParam16();
                GameImpl.playAreaTopLimit = var2_2.getParam16();
                GameImpl.playAreaRightLimit = var2_2.getParam16();
                GameImpl.playAreaBottomLimit = var2_2.getParam16();
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 58: {
                var4_51 = var2_2.getParam16();
                var5_90 = var2_2.getParam16();
                var6_103 = var2_2.getParam16();
                GameImpl.cameraTarget = null;
                if (GameImpl.gameMode == 2) {
                    var4_51 >>= 1;
                    var5_90 >>= 1;
                }
                Camera.moveCenterToWithSpeed(var4_51 << 8, var5_90 << 8, var6_103);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 59: {
                GameImpl.showHiddenDecorators();
                var2_2.putParam(0);
                break;
            }
            case 61: {
                var4_52 = var2_2.getParam16();
                for (var17_128 = 0; var17_128 < GameImpl.numExplodables; ++var17_128) {
                    if (GameImpl.explodables[var17_128].id != var4_52) continue;
                    GameImpl.explodables[var17_128].setState(1);
                }
                break;
            }
            case 69: {
                var4_53 = var2_2.getParam16();
                for (var17_129 = 0; var17_129 < GameImpl.numExplodables; ++var17_129) {
                    if (GameImpl.explodables[var17_129].id != var4_53) continue;
                    GameImpl.explodables[var17_129].setState(2);
                }
                break;
            }
            case 62: {
                if (!GameImpl.achievementCompleted[17]) {
                    GameImpl.achievementCompleted[17] = true;
                    GameImpl.lastCompletedAchievementIDX = 17;
                    GameImpl.saveAchievements();
                }
                var2_2.putParam(0);
                break;
            }
            case 63: {
                GameImpl.incrementLevel();
                GameImpl.skipBriefing = true;
                var2_2.putParam(0);
                break;
            }
            case 64: {
                var4_54 = var2_2.getParam16();
                var7_60 = var2_2.getParam16();
                var8_66 = var2_2.getParam16();
                this.moveObjective(var4_54, var7_60, var8_66);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 65: {
                if (var2_2.getParam() == 0) {
                    GameImpl.forceCinematicBars = false;
                } else {
                    GameImpl.forceCinematicBars = true;
                    GameImpl.cinematicBarHeight = 0;
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 66: {
                var4_55 = var2_2.getParam16();
                var7_61 = var2_2.getParam16();
                var8_67 = var2_2.getParam16();
                for (var17_130 = 0; var17_130 < GameImpl.numEnemies; ++var17_130) {
                    if (GameImpl.enemies[var17_130].id != var4_55 || GameImpl.enemies[var17_130].state == 1 || GameImpl.enemies[var17_130].state == 17) continue;
                    GameImpl.enemies[var17_130].returnTo(var7_61, var8_67);
                    break;
                }
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                var2_2.putParam(0);
                break;
            }
            case 67: {
                var2_2.getParam();
                var2_2.putParam(0);
                var2_2.putParam(GameImpl.sniperScopeOn != false ? 1 : 0);
            }
        }
    }

    public void moveObjective(int n, int n2, int n3) {
        for (int i = 0; i < numObjectives; ++i) {
            if (GameImpl.objectives[i].id != n) continue;
            GameImpl.objectives[i].posX = n2 << 8;
            GameImpl.objectives[i].posY = n3 << 8;
        }
    }

    public AlliedCharacter getAllied(int n) {
        for (int i = 0; i < numAllies; ++i) {
            if (GameImpl.allies[i].id != n) continue;
            return allies[i];
        }
        return null;
    }

    public void tutorialMessage(int n, int n2, int n3, int n4, int n5) {
        GameImpl.hudAnimator._sprite = 15;
        hudAnimator.SetCrtAnim(n5);
        GameImpl.hudAnimator._flags |= 0x800;
        if (n4 == 6) {
            int n6 = n2 << 8;
            int n7 = n3 + 60 + 7 << 8;
            tutorialBoxX = (short)n2;
            tutorialBoxY = (short)n3;
            tutorialText = (short)n;
            previousCameraPosX = Camera.fracPosX + 40960;
            previousCameraPosY = Camera.fracPosY + 30720;
            Camera.moveCenterToWithSpeed(n6, n7, 4);
        } else {
            tutorialBoxX = (short)n2;
            tutorialBoxY = (short)n3;
            tutorialText = (short)n;
        }
        GameImpl.showTutorialMessage(tutorialText, n4, n5);
        GameImpl.setPlayState(4);
    }

    public void alertEnemy(int n, int n2, int n3) {
        for (int i = 0; i < numEnemies; ++i) {
            if (GameImpl.enemies[i].id != n || GameImpl.enemies[i].state == 1 || GameImpl.enemies[i].state == 17) continue;
            GameImpl.enemies[i].destX = n2 << 8;
            GameImpl.enemies[i].destY = n3 << 8;
            enemies[i].setState(11);
            return;
        }
    }

    public void setEnemyFlag(int n, byte by) {
        for (int i = 0; i < numEnemies; ++i) {
            if (GameImpl.enemies[i].id != n) continue;
            GameImpl.enemies[i].flags = (byte)(GameImpl.enemies[i].flags | by);
        }
    }

    public void unsetEnemyFlag(int n, byte by) {
        for (int i = 0; i < numEnemies; ++i) {
            if (GameImpl.enemies[i].id != n) continue;
            GameImpl.enemies[i].flags = (byte)(GameImpl.enemies[i].flags & ~by);
        }
    }

    public Enemy getEnemy(int n) {
        for (int i = 0; i < numEnemies; ++i) {
            if (GameImpl.enemies[i].id != n) continue;
            return enemies[i];
        }
        return null;
    }

    public static void signalTeam(byte by, byte by2) {
        for (int i = 0; i < numAllies; ++i) {
            if (allies[i] == null || GameImpl.allies[i].teamID != by) continue;
            GameImpl.signalAlly(allies[i], by2);
        }
    }

    private static void signalAlly(AlliedCharacter alliedCharacter, byte by) {
        if (alliedCharacter == null) {
            return;
        }
        switch (by) {
            case 1: {
                alliedCharacter.flags = (byte)(alliedCharacter.flags & 0xFFFFFFFE);
                break;
            }
            case 0: {
                alliedCharacter.flags = (byte)(alliedCharacter.flags | 1);
                break;
            }
            case 2: {
                if (alliedCharacter.currentWaypoint >= alliedCharacter.numWaypoints) break;
                int n = alliedCharacter.currentWaypoint;
                alliedCharacter.waypointsFlags[n] = (short)(alliedCharacter.waypointsFlags[n] & 0xFFFFFFFE);
            }
        }
    }

    public static void showMessage(int n, int n2) {
        GameImpl.showMessage(-1, n, n2);
    }

    public static void showMessage(int n, int n2, int n3) {
        GameImpl.showMessageWithAnimation(n, n2, n3, 0);
    }

    public static void showMessageWithAnimation(int n, int n2, int n3, int n4) {
        dialogOffsetY = achievementDisplayTime != -1L ? (short)22 : (short)0;
        currentDialogTitleID = n;
        currentDialogTextID = n2;
        GameImpl.hudAnimator._sprite = 15;
        hudAnimator.SetCrtAnim(n4);
        GameImpl.hudAnimator._flags |= 0x800;
        if (writingAnimator != null) {
            writingAnimator.SetCrtAFrame(0);
        }
        GameImpl.doDialogLayout(n3, n4);
        GameImpl.setPlayState(3);
    }

    public static void showTutorialMessage(int n, int n2, int n3) {
        GameImpl.showTutorialMessage(-1, n, n2, n3);
    }

    public static void showTutorialMessage(int n, int n2, int n3, int n4) {
        currentDialogTitleID = n;
        currentDialogTextID = n2;
        GameImpl.doDialogLayout(n3, n4);
    }

    public int getVariable(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = numEnemies;
                break;
            }
            case 1: {
                n2 = runEnemyAI ? 1 : 0;
                break;
            }
            case 2: {
                n2 = fadingFinished ? 1 : 0;
                break;
            }
            case 3: {
                n2 = 320;
                break;
            }
            case 4: {
                n2 = 240;
                break;
            }
            case 5: {
                n2 = hideTarget ? 1 : 0;
                break;
            }
            case 6: {
                n2 = bombingSkipScript;
            }
        }
        return n2;
    }

    public void setVariable(int n, int n2) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                runEnemyAI = n2 != 0;
                break;
            }
            case 5: {
                hideTarget = n2 != 0;
                break;
            }
            case 6: {
                bombingSkipScript = n2;
            }
        }
    }

    public int getNumberOfGlobalVars() {
        return 50;
    }

    public void drawHud(SDKGraphics sDKGraphics) {
        this.drawNormalHud(sDKGraphics);
    }

    public void drawNormalHud(SDKGraphics sDKGraphics) {
        if (!showUI) {
            return;
        }
        sprites[7].RectFrame(0, 0, 0, 0);
        sprites[7].DrawFrame(0, 5, 231 - XSprite._rect[3], 0);
        int n = XSprite._rect[2];
        int n2 = XSprite._rect[3];
        if (GameImpl.player.state == 8) {
            this.drawHudWeapon(sDKGraphics, -1, n, n2, true, false);
        } else if (GameImpl.player.canStealthKill || GameImpl.player.canComboStealthKill || GameImpl.player.state == 13 || Utils.isFlagSet(levels[currentLevel][6], 2)) {
            this.drawHudWeapon(sDKGraphics, -3, n, n2, true, false);
        } else {
            this.drawHudWeapon(sDKGraphics, hudModel[1], n, n2, !hudChangeToNextWeapon || (frames & 2L) != 0L, false);
        }
        if (!(hudModel[1] == 1 || GameImpl.player.state == 8 || GameImpl.player.state == 13 || GameImpl.player.canStealthKill || GameImpl.player.canComboStealthKill || Utils.isFlagSet(levels[currentLevel][6], 2))) {
            SDKUtils.setFont(fonts[0]);
            sprites[7].RectFrame(8, 0, 0, 0);
            stringBuffer.setLength(0);
            stringBuffer.append(hudModel[2]);
            SDKUtils.drawString(stringBuffer, 5 + (XSprite._rect[2] >> 1), this.getBulletBarOffsetY(), 17);
        } else {
            sprites[7].RectFrame(8, 0, 0, 0);
            sprites[5].DrawFrame(20, 5 + (XSprite._rect[2] >> 1), this.getBulletBarOffsetY(), 17);
        }
        boolean bl = true;
        if (hudModel[4] != 0) {
            if (hudModel[5] % 14 < 7) {
                bl = false;
            }
            short s = hudModel[5];
            hudModel[5] = (short)(s - 1);
            if (s == 0) {
                if (GameImpl.player.machinegun != null && GameImpl.player.machinegun.state == 0) {
                    GameImpl.hudModel[5] = 28;
                } else {
                    GameImpl.hudModel[4] = 0;
                }
            }
        }
        if ((GameImpl.player.numWeapons > 1 || GameImpl.player.state == 8 || GameImpl.player.machinegun != null && GameImpl.player.machinegun.state == 0) && !Utils.isFlagSet(levels[currentLevel][6], 2) && (bl || (hudModel[4] & 1) == 0)) {
            sprites[7].RectFrame(7, 0, 0, 0);
            sprites[7].DrawFrame(7, 10, 239 - XSprite._rect[3], 0);
        }
        if (!Utils.isFlagSet(levels[currentLevel][6], 2)) {
            if (GameImpl.player.machinegun != null && GameImpl.player.machinegun.state == 0) {
                if (bl) {
                    this.drawHudSmallWeapon(-1, n, n2);
                }
            } else {
                for (int i = 0; i < GameImpl.player.numWeapons; ++i) {
                    if (i == GameImpl.player.currentWeapon || !bl && !GameImpl.hudIsFlashingWeapon(GameImpl.player.weaponClass[i].bData[0])) continue;
                    this.drawHudSmallWeapon(GameImpl.player.weaponClass[i].bData[0], n, n2);
                }
                if (GameImpl.player.state == 8) {
                    this.drawHudSmallWeapon(GameImpl.player.weaponClass[GameImpl.player.currentWeapon].bData[0], n, n2);
                }
            }
        }
    }

    public static void drawBombingHud(SDKGraphics sDKGraphics) {
        XSprite.setTempDrawScaled(false);
        sprites[5].DrawFrame(23, 160, 120, 3);
        XSprite.restoreDrawScaled();
        int n = Utils.random(567790, 567990);
        stringBuffer.setLength(0);
        stringBuffer.append("ANG:");
        stringBuffer.append(n);
        SDKUtils.drawString(stringBuffer, 320, 0, 24);
        stringBuffer.setLength(0);
        stringBuffer.append("GBU-28 : ");
        stringBuffer.append(numBombs - numFiredBombs - 1);
        int n2 = SDKUtils.getLineSize();
        int n3 = SDKUtils.getStringSize(stringBuffer);
        int n4 = 2;
        int n5 = 216 - n2;
        if (!hideTarget) {
            GameImpl.FillRect(sDKGraphics, 0x777777, n4, n5, n3 + 4, n2 + 4);
            SDKUtils.drawString(stringBuffer, n4 + 2 + n3 / 2, n5 + 2, 17);
            if (bombingTargetsFlags != null) {
                stringBuffer.setLength(0);
                string = SDKUtils.getString(60, string);
                stringBuffer.append(string).append(" : ");
                stringBuffer.append(bombingTargetsFlags.length - numTargetsDestroyed);
                n2 = SDKUtils.getLineSize();
                n3 = SDKUtils.getStringSize(stringBuffer);
                n4 = 314 - n3;
                n5 = 216 - n2;
                GameImpl.FillRect(sDKGraphics, 0x777777, n4, n5, n3 + 4, n2 + 4);
                SDKUtils.drawString(stringBuffer, n4 + 2 + n3 / 2, n5 + 2, 17);
            }
        }
        int n6 = 240 - n2 * 4 - 6 >> 1;
        stringBuffer.setLength(0);
        stringBuffer.append(Camera.fracPosX + targetX);
        SDKUtils.drawString(stringBuffer, 0, n6, 20);
        stringBuffer.setLength(0);
        stringBuffer.append(Camera.fracPosX + targetY);
        SDKUtils.drawString(stringBuffer, 0, n6 += n2 + 2, 20);
        SDKUtils.drawString(bombingHudFakeCodes[0], 0, n6 += n2 + 2, 20);
        SDKUtils.drawString(bombingHudFakeCodes[1], 0, n6 += n2 + 2, 20);
        n6 = 240 - n2 * 9 - 10 - 42 >> 1;
        stringBuffer.setLength(0);
        stringBuffer.append("N");
        SDKUtils.drawString(stringBuffer, 320, n6, 24);
        stringBuffer.setLength(0);
        stringBuffer.append("T");
        SDKUtils.drawString(stringBuffer, 320, n6 += n2 + 2, 24);
        stringBuffer.setLength(0);
        stringBuffer.append("S");
        SDKUtils.drawString(stringBuffer, 320, n6 += n2 + 14, 24);
        stringBuffer.setLength(0);
        stringBuffer.append("F");
        SDKUtils.drawString(stringBuffer, 320, n6 += n2 + 2, 24);
        stringBuffer.setLength(0);
        stringBuffer.append("O");
        SDKUtils.drawString(stringBuffer, 320, n6 += n2 + 14, 24);
        stringBuffer.setLength(0);
        stringBuffer.append("Z");
        SDKUtils.drawString(stringBuffer, 320, n6 += n2 + 2, 24);
        stringBuffer.setLength(0);
        stringBuffer.append("T");
        SDKUtils.drawString(stringBuffer, 320, n6 += n2 + 14, 24);
        stringBuffer.setLength(0);
        stringBuffer.append("G");
        SDKUtils.drawString(stringBuffer, 320, n6 += n2 + 2, 24);
        stringBuffer.setLength(0);
        stringBuffer.append("T");
        SDKUtils.drawString(stringBuffer, 320, n6 += n2 + 2, 24);
        GameImpl.drawSniperMessages(sDKGraphics);
    }

    private void drawHudSmallWeapon(int n, int n2, int n3) {
        int n4 = 16;
        sprites[7].RectFrame(n4, 0, 0, 0);
        int n5 = 84 - XSprite._rect[2] + 6;
        int n6 = 240 - (9 + n3 >> 2) + -5;
        switch (n) {
            case 1: {
                n4 = 4;
                sprites[7].RectFrame(n4, 0, 0, 0);
                n5 = 84 - XSprite._rect[2] + -2;
                n6 = 240 - (9 + n3) + 3;
                break;
            }
            case 0: {
                n4 = 13;
                sprites[7].RectFrame(n4, 0, 0, 0);
                n5 = 84 - XSprite._rect[2] + 0;
                n6 = 240 - (9 + n3 >> 2) + -2;
                break;
            }
            case 2: {
                n4 = 6;
                sprites[7].RectFrame(n4, 0, 0, 0);
                n5 = 84 - XSprite._rect[2] + 0;
                n6 = 240 - (9 + n3 >> 1) + 3;
                break;
            }
            case 3: {
                n4 = 5;
                sprites[7].RectFrame(n4, 0, 0, 0);
                n5 = 84 - XSprite._rect[2] + -2;
                n6 = 240 - (9 + n3 >> 2) - (9 + n3 >> 1) + 0;
            }
        }
        sprites[7].DrawFrame(n4, n5, n6, 0);
    }

    public static boolean hudIsFlashingWeapon(int n) {
        switch (n) {
            case 1: {
                return (hudModel[4] & 8) == 0;
            }
            case 0: {
                return (hudModel[4] & 0x10) == 0;
            }
            case 2: {
                return (hudModel[4] & 4) == 0;
            }
            case 3: {
                return (hudModel[4] & 2) == 0;
            }
        }
        return true;
    }

    public void drawHudWeapon(SDKGraphics sDKGraphics, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        switch (n) {
            case 1: {
                n8 = 10;
                n6 = 10;
                n7 = 56;
                break;
            }
            case 0: {
                n8 = 20;
                n6 = 3;
                n7 = 56;
                break;
            }
            case 2: {
                n8 = 6;
                n6 = 12;
                n7 = 57;
                break;
            }
            case 3: {
                n8 = 2;
                n6 = 11;
                n7 = 15;
                break;
            }
            case -1: {
                n6 = 17;
                break;
            }
            case -2: {
                n6 = 17;
                break;
            }
            case -3: {
                n6 = 28;
            }
        }
        if (!bl2) {
            int n9;
            n5 = this.getBulletBarOffsetY();
            sprites[7].RectFrame(8, 0, 0, 0);
            n4 = XSprite._rect[3];
            int n10 = XSprite._rect[2];
            if (n == 1) {
                sprites[7].DrawFrame(54, 5, n5 - 11 * n4, 0);
            } else if (n == 0) {
                sprites[7].DrawFrame(55, 5, n5 - 21 * n4, 0);
            } else if (n == 2) {
                sprites[7].DrawFrame(54, 5, n5 - 8 * n4, 0);
            } else {
                for (n9 = 1; n9 <= n8; ++n9) {
                    sprites[7].DrawFrame(8, 5, n5 - n9 * n4, 0);
                }
                sprites[7].RectFrame(9, 0, 0, 0);
                sprites[7].DrawFrame(9, 5, n5 - n8 * n4 - XSprite._rect[3], 0);
            }
            if (n7 > 0) {
                n9 = 1;
                if ((hudModel[4] & 0x40) != 0) {
                    if (hudModel[5] % 14 < 7) {
                        n9 = 0;
                    }
                    short s = hudModel[5];
                    hudModel[5] = (short)(s - 1);
                    if (s == 0) {
                        GameImpl.hudModel[4] = 0;
                    }
                }
                if (n9 != 0) {
                    n5 = this.getBulletBarOffsetY();
                    sprites[7].RectFrame(n7, 0, 0, 0);
                    int n11 = 5 + (n10 - XSprite._rect[2] >> 1);
                    if (n7 != 15) {
                        if (n == 1) {
                            Utils.getClip(sDKGraphics);
                            int n12 = 30 - 3 * hudModel[3];
                            int[] nArray = new int[]{n11, n5 - XSprite._rect[3] + 30 + n12, 12, 3 * hudModel[3]};
                            Utils.setClip(sDKGraphics, nArray);
                            sprites[7].DrawFrame(n7, n11, n5 - XSprite._rect[3], 0);
                            Utils.setClip(sDKGraphics, Utils.iClip);
                        } else if (n == 0) {
                            Utils.getClip(sDKGraphics);
                            int n13 = 60 - 3 * hudModel[3];
                            int[] nArray = new int[]{n11, n5 - XSprite._rect[3] + n13, 12, 3 * hudModel[3]};
                            Utils.setClip(sDKGraphics, nArray);
                            sprites[7].DrawFrame(n7, n11, n5 - XSprite._rect[3], 0);
                            Utils.setClip(sDKGraphics, Utils.iClip);
                        } else if (n == 2) {
                            Utils.getClip(sDKGraphics);
                            int n14 = 20 - 4 * hudModel[3];
                            int[] nArray = new int[]{n11, n5 - XSprite._rect[3] + n14, 12, 4 * hudModel[3]};
                            Utils.setClip(sDKGraphics, nArray);
                            sprites[7].DrawFrame(n7, n11, n5 - XSprite._rect[3], 0);
                            Utils.setClip(sDKGraphics, Utils.iClip);
                        } else {
                            for (int i = 1; i <= hudModel[3]; ++i) {
                                sprites[7].DrawFrame(n7, n11, n5 - i * XSprite._rect[3], 0);
                            }
                        }
                    } else {
                        sprites[7].DrawFrame(n7, n11, n5 - XSprite._rect[3], 0);
                    }
                }
            }
        }
        sprites[7].RectFrame(n6, 0, 0, 0);
        if (bl) {
            n5 = bl2 ? 320 : 0;
            n5 = bl2 ? n5 - 5 - (XSprite._rect[2] - XSprite._rect[0]) : 5 - (XSprite._rect[2] - n2 >> 1);
            n4 = bl2 ? 217 - (n3 << 1) : 231 - (XSprite._rect[3] - n3 >> 1) - n3;
            sprites[7].DrawFrame(n6, n5, n4, 0);
        }
    }

    public int getBulletBarOffsetY() {
        sprites[7].RectFrame(0, 0, 0, 0);
        return 231 - XSprite._rect[3];
    }

    public static void initbombingHudFakeCodes() {
        for (int i = 0; i < 2; ++i) {
            GameImpl.bombingHudFakeCodes[i] = new SDKString(5, 0);
            bombingHudFakeCodes[i].setCharAt(0, (char)Utils.random(65, 90));
            bombingHudFakeCodes[i].setCharAt(1, (char)Utils.random(65, 90));
            bombingHudFakeCodes[i].append(Utils.random(100, 1000));
        }
    }

    public void updateHudModel() {
        if (GameImpl.player.weaponAmmunition[GameImpl.player.currentWeapon] == 0 && !hudChangeToNextWeapon) {
            hudChangeToNextWeapon = true;
            hudChangeToNextWeaponStartFrame = frames;
        }
        if (hudChangeToNextWeapon && GameImpl.player.weaponAmmunition[GameImpl.player.currentWeapon] != 0) {
            hudChangeToNextWeapon = false;
            return;
        }
        if (hudChangeToNextWeapon && frames - hudChangeToNextWeaponStartFrame > 10L) {
            hudChangeToNextWeapon = false;
            this.changeToNextWeapon();
        }
        GameImpl.hudModel[1] = (short)player.getWeponType();
        GameImpl.hudModel[2] = GameImpl.player.weaponAmmunition[GameImpl.player.currentWeapon];
        GameImpl.hudModel[3] = GameImpl.player.weaponMagazine[GameImpl.player.currentWeapon];
        GameImpl.hudModel[0] = (short)GameImpl.player.life;
        if (currentObjective != -1) {
            objectiveOrientation = GameImpl.getExtendedOrientation(GameImpl.objectives[GameImpl.currentObjective].posX - GameImpl.player.posX, GameImpl.objectives[GameImpl.currentObjective].posY - GameImpl.player.posY);
        }
    }

    public static void drawConfirmation(SDKGraphics sDKGraphics, int n) {
        SDKUtils.setFont(fonts[0]);
        string = SDKUtils.getString(n, string);
        SDKUtils.drawString(string, 160, 120, 3);
        string = SDKUtils.getString(63, string);
        stringBuffer.setLength(0);
        stringBuffer.append(string).append(" (Q)");
        SDKUtils.drawString(stringBuffer, 0, 240, 36);
        string = SDKUtils.getString(64, string);
        stringBuffer.setLength(0);
        stringBuffer.append("(P) ").append(string);
        SDKUtils.drawString(stringBuffer, 320, 240, 40);
    }

    public void drawLoadingProgress(SDKGraphics sDKGraphics, int n) {
        sDKGraphics.setColor(0xFFFFFF);
        sDKGraphics.fillRect(0, 210, n * 320 / 100, 10);
    }

    public void draw(SDKGraphics sDKGraphics) {
        try {
            this.clearScreen(sDKGraphics, 0);
            SDKUtils.setGraphics(sDKGraphics);
            XSprite.SetGraphics(sDKGraphics);
            switch (state) {
                case 9: {
                    SDKUtils.setFont(fonts[0]);
                    SDKUtils.getHeaderString(currentLanguage, 1, string);
                    SDKUtils.drawString(string, 160, 61, 17);
                    SDKUtils.setFont(fonts[0]);
                    int n = SDKUtils.getLineSize();
                    int n2 = 120 - (n * numLangsLoaded >> 1);
                    for (int i = 0; i < numLangsLoaded; ++i) {
                        SDKUtils.getHeaderString(i, 0, string);
                        if (i == currentLanguage) {
                            SDKUtils.setFont(fonts[1]);
                            SDKUtils.drawString(string, 160, n2, 17);
                            SDKUtils.setFont(fonts[0]);
                        } else {
                            SDKUtils.drawString(string, 160, n2, 1);
                        }
                        n2 += n;
                    }
                    SDKUtils.getHeaderString(currentLanguage, 2, string);
                    SDKUtils.drawString(string, 0, 240, 36);
                    break;
                }
                case 5: {
                    GameImpl.drawConfirmation(sDKGraphics, 62);
                    break;
                }
                case 7: {
                    GameImpl.drawConfirmation(sDKGraphics, 138);
                    break;
                }
                case 8: {
                    GameImpl.drawConfirmation(sDKGraphics, GameImpl.menu.textDisplay);
                    break;
                }
                case 6: {
                    sDKGraphics.drawImage(splashEA, 160, 120, 3);
                    break;
                }
                case 1: {
                    scopeDraw = false;
                    this.drawGame(sDKGraphics);
                    scopeDraw = false;
                    break;
                }
                case 2: {
                    menu.paint(sDKGraphics);
                    if (!bSetStateMenu) break;
                    bSetStateMenu = false;
                    GameImpl.playSoundRepeated(6);
                    break;
                }
                case 3: {
                    if (!mgInstance.isActive()) break;
                    mgInstance.paint(sDKGraphics);
                    break;
                }
                case 0: {
                    string = SDKUtils.getString(9, string);
                    XSprite.setTempDrawScaled(false);
                    if (sprites[13] != null) {
                        sprites[13].DrawFrame(2, 0, 0, 0);
                    }
                    XSprite.restoreDrawScaled();
                    this.drawLoadingProgress(sDKGraphics, loadingPercent);
                    break;
                }
                case 4: {
                    if (!skipBriefing) {
                        SDKUtils.setFont(fonts[0]);
                        if (levels != null && levels[currentLevel] != null) {
                            if ((string = SDKUtils.getString(levels[currentLevel][4], string)) != null) {
                                if (levels[currentLevel][4] == 223 || levels[currentLevel][4] == 220) {
                                    wrapOffsets = SDKUtils.wrapString(string, wrapOffsets, 280, (short)124);
                                    SDKUtils.drawWrappedString(string, wrapOffsets, 1, wrapOffsets[0], 160, 30 - SDKUtils.getLineSize(), 17);
                                } else {
                                    SDKUtils.drawString(string, 160, 30, 17);
                                }
                            }
                            if ((string = SDKUtils.getString(levels[currentLevel][5], string)) != null) {
                                int n = 0;
                                n = (wrapOffsets = SDKUtils.wrapString(string, wrapOffsets, 280, (short)124))[0] - briefingPage * 8 > 8 ? 8 : wrapOffsets[0] - briefingPage * 8;
                                SDKUtils.drawWrappedString(string, wrapOffsets, briefingPage * 8 + 1, n, 20, 60, 20);
                                int n3 = 1;
                                int n4 = wrapOffsets[0];
                                while ((n4 -= 8) > 0) {
                                    ++n3;
                                }
                                if (n3 > 1) {
                                    stringBuffer.setLength(0);
                                    stringBuffer.append(briefingPage + 1).append(" / ");
                                    stringBuffer.append(n3);
                                    SDKUtils.drawString(stringBuffer, 160, 239, 33);
                                    if (loadLevelState == 11) {
                                        XSprite.setTempDrawScaled(false);
                                        if (briefingPage > 0) {
                                            sprites[7].DrawFrame(43, 130, 231, 0);
                                        }
                                        if (briefingPage < n3 - 1) {
                                            sprites[7].DrawFrame(44, 190, 231, 0);
                                        }
                                    }
                                }
                                XSprite.restoreDrawScaled();
                            }
                        }
                    }
                    if (loadLevelState < 11 || skipBriefing) {
                        this.drawLoadingProgress(sDKGraphics, (loadLevelState + 1) * 100 / 12);
                        break;
                    }
                    SDKUtils.setFont(fonts[0]);
                    string = SDKUtils.getString(66, string);
                    SDKUtils.drawString(string, 320 - SDKUtils.getStringSize(string) >> 1, 203, 6);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void drawSoftkeys(SDKGraphics sDKGraphics) {
        if (playState != 0 || gameMode != 1) {
            XSprite.setTempDrawScaled(false);
        }
        switch (playState) {
            case 3: 
            case 4: 
            case 10: {
                if (playState == 10) {
                    machineGunPlaying = false;
                    sprites[7].DrawFrame(39, 301, 230, 0);
                } else {
                    sprites[7].RectFrame(1, 0, 0, 0);
                    sprites[7].DrawFrame(1, 310 - XSprite._rect[2], 239 - XSprite._rect[3], 0);
                }
            }
            case 2: 
            case 9: 
            case 11: {
                if (playState == 10 || playState == 2 || playState == 9 || playState == 11 || dialogMode != 7) {
                    sprites[7].RectFrame(18, 0, 0, 0);
                    sprites[7].DrawFrame(18, 10, 239 - XSprite._rect[3] + 2, 0);
                    break;
                }
                sprites[7].RectFrame(1, 0, 0, 0);
                sprites[7].DrawFrame(1, 310 - XSprite._rect[2], 239 - XSprite._rect[3], 0);
                break;
            }
            default: {
                if (playState == 1 && cutSceneScript != -1 && skipSceneScript != -1 || gameMode == 2 && bombingSkipScript != -1) {
                    sprites[7].RectFrame(18, 0, 0, 0);
                    sprites[7].DrawFrame(18, 10, 239 - XSprite._rect[3] + 2, 0);
                }
                if (!showUI) break;
                sprites[7].RectFrame(1, 0, 0, 0);
                sprites[7].DrawFrame(1, 310 - XSprite._rect[2], 239 - XSprite._rect[3], 0);
            }
        }
        if (playState != 0 || gameMode != 1) {
            XSprite.restoreDrawScaled();
        }
    }

    public void drawHeavyLine(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5) {
        sDKGraphics.setColor(n);
        sDKGraphics.drawLine(n2 - 1, n3, n4 - 1, n5);
        sDKGraphics.drawLine(n2, n3, n4, n5);
        sDKGraphics.drawLine(n2 + 1, n3, n4 + 1, n5);
    }

    public void drawDialogBox(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4) {
        int n5 = 100;
        if (dialogFrame < dialogPercentages.length) {
            n5 = dialogPercentages[dialogFrame];
            ++dialogFrame;
        }
        int n6 = n3 - (n5 >> 1) * n4 / 100;
        int n7 = n3 + (n5 >> 1) * n4 / 100;
        sDKGraphics.setColor(0);
        sDKGraphics.drawRect(n - 1, n6 - 1, n2 - n + 1, n5 * (n4 + 15) / 100 + 1);
        GameImpl.fakeFillRect(sDKGraphics, n, n6, n2, n5 * (n4 + 15) / 100);
        sprites[7].DrawFrame(19, n2 - 17, n7 - 17 + 15, 0);
        if (n5 == 100) {
            if (currentDialogTitleID != -1) {
                string = SDKUtils.getString(currentDialogTitleID, string);
                SDKUtils.setFont(fonts[1]);
                SDKUtils.drawString(string, n + 5, n6 + 4, 0);
            }
            if (currentDialogTextID != -1) {
                SDKUtils.setFont(fonts[0]);
                string = SDKUtils.getString(currentDialogTextID, string);
                wrapOffsets = SDKUtils.wrapString(string, wrapOffsets, dialogWidth - 10, (short)124);
                SDKUtils.drawWrappedString(string, wrapOffsets, 1, wrapOffsets[0], n + 5, n7 - 4, 36);
            }
        }
    }

    public void drawDialog(SDKGraphics sDKGraphics) {
        XSprite.setTempDrawScaled(false);
        switch (dialogMode) {
            case 1: 
            case 3: 
            case 5: {
                sprites[10].DrawFrame(23, 36, 100 + dialogOffsetY, 0);
                if (GameImpl.hudAnimator._crt_aframe > 6) {
                    if (dialogMode == 1) {
                        sprites[10].DrawFrame(21, 36, 100 + dialogOffsetY, 0);
                    } else if (dialogMode == 3) {
                        sprites[10].DrawFrame(28, 36, 100 + dialogOffsetY, 0);
                    } else {
                        sprites[10].DrawFrame(30, 36, 100 + dialogOffsetY, 0);
                    }
                }
                hudAnimator.DrawCrtAnimOnScreenCoordinates(sDKGraphics, 36, 100 + dialogOffsetY);
                this.drawDialogBox(sDKGraphics, 70, 310, 100 + dialogOffsetY, dialogHeight);
                break;
            }
            case 2: 
            case 4: {
                sprites[10].DrawFrame(24, 284, 100 + dialogOffsetY, 0);
                if (GameImpl.hudAnimator._crt_aframe > 6) {
                    if (dialogMode == 2) {
                        sprites[10].DrawFrame(20, 284, 100 + dialogOffsetY, 0);
                    } else {
                        sprites[10].DrawFrame(29, 284, 100 + dialogOffsetY, 0);
                    }
                }
                hudAnimator.DrawCrtAnimOnScreenCoordinates(sDKGraphics, 284, 100 + dialogOffsetY);
                this.drawDialogBox(sDKGraphics, 10, 250, 100 + dialogOffsetY, dialogHeight);
                break;
            }
            case 8: {
                sprites[10].DrawFrame(23, 36, 100 + dialogOffsetY, 0);
                hudAnimator.DrawCrtAnimOnScreenCoordinates(sDKGraphics, 36, 100 + dialogOffsetY);
                if (hudAnimator.IsCrtAnimEnded()) {
                    writingAnimator.DrawCrtAnimOnScreenCoordinates(sDKGraphics, 36, 100 + dialogOffsetY);
                }
                this.drawDialogBox(sDKGraphics, 70, 310, 100 + dialogOffsetY, dialogHeight);
                break;
            }
            case 6: 
            case 7: {
                sprites[10].DrawFrame(23, 36, 120, 0);
                this.drawDialogBox(sDKGraphics, 70, 310, 120, dialogHeight);
                writingAnimator.DrawCrtAnimOnScreenCoordinates(sDKGraphics, 36, 120);
                break;
            }
            case 9: 
            case 10: {
                this.drawDialogBox(sDKGraphics, 10, 310, 120, dialogHeight);
            }
        }
        XSprite.restoreDrawScaled();
    }

    public void pause() {
        if (soundManager != null) {
            soundManager.stopSounds();
        }
        if (state == 1 && playState != 10 && playState != 9 && playState != 11 && playState != 2 && (!GameImpl.menu.transitionAnimation || isTransitionToGameState || transitionToState != 8)) {
            if (playState != 6 && playState != 7) {
                savedPlayState = playState;
            }
            GameImpl.setState(2);
            menu.setMenuState(2);
        }
    }

    public void resume() {
        soundManager.stopSounds();
        if (state == 2 && soundManager.isSoundEnabled()) {
            Menu.soundStartTimer = 20;
        }
    }

    public void exiting() {
        if (state != 9) {
            GameImpl.saveSettings();
        }
        GameImpl.clean();
    }

    public void appKeyPressed(int n, long l) {
        int n2;
        if (n == 0x400000) {
            Utils.soundVolumeDown();
            return;
        }
        if (n == 0x200000) {
            Utils.soundVolumeUp();
            return;
        }
        if (GameImpl.menu.transitionAnimation) {
            return;
        }
        if (state != 2 && state != 3 || (n2 = mgInstance.processKey(n)) == 1) {
            // empty if block
        }
        switch (state) {
            case 1: {
                if (playState == 11) {
                    if (n != 32 && n != 4096 && n != 16 && n != 524288) break;
                    if ((endLevelAchievementsPage + 1) * 3 < endLevelAchievementsCounter) {
                        ++endLevelAchievementsPage;
                        break;
                    }
                    endLevelAchievementsPage = 0;
                    GameImpl.incrementLevel();
                    break;
                }
                if (playState == 9) {
                    if (n != 32 && n != 4096 && n != 16 && n != 524288) break;
                    if (endLevelAchievementsCounter > 0) {
                        GameImpl.setPlayState(11);
                        break;
                    }
                    GameImpl.incrementLevel();
                    return;
                }
                if ((n == 64 || n == 524288) && playState != 2 && playState != 9 && playState != 11 && playState != 10) {
                    savedPlayState = playState;
                    Camera.setShake(false);
                    GameImpl.fadeOutToPlayState(8);
                }
                if (bombingSkipScript != -1 && n == 32) {
                    vm.spawnInstanceByID(bombingSkipScript, -1);
                }
                if (playState != 2 || n != 32) break;
                GameImpl.setState(2);
                menu.setMenuState(1);
                break;
            }
            case 2: {
                menu.appKeyPressed(n, l);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (skipBriefing) break;
                if (n == 4096 || n == 16) {
                    if (wrapOffsets[0] > (briefingPage + 1) * 8) {
                        ++briefingPage;
                        break;
                    }
                    if (loadLevelState != 11) break;
                    Camera.state = 0;
                    Camera.setShake(false);
                    GameImpl.initGame();
                    for (n2 = 0; n2 < achievementCount; ++n2) {
                        GameImpl.beforeLevelAchievementCompleted[n2] = achievementCompleted[n2];
                    }
                    break;
                }
                if (loadLevelState != 11) break;
                if (n == 1 || n == 512 || n == 4 || n == 2048) {
                    if (briefingPage <= 0) break;
                    --briefingPage;
                    break;
                }
                if (n != 2 && n != 32768 && n != 8 && n != 8192 || wrapOffsets[0] <= (briefingPage + 1) * 8) break;
                ++briefingPage;
            }
        }
    }

    public void appKeyReleased(int n, long l) {
    }

    public void appLetterPressed(int n, long l) {
    }

    public void appLetterReleased(int n, long l) {
    }

    public void updateSoftKeyLabels(String string, String string2) {
    }

    public void appScreenChanged(int n, int n2) {
    }

    public static void loadSounds() {
    }

    private void unloadSounds() {
        for (int i = 0; i < 6; ++i) {
            if (!soundsLoaded[i]) continue;
            soundManager.unloadCachedSound(i + 6);
            GameImpl.soundsLoaded[i] = false;
        }
    }

    public static void playSoundSniper(int n) {
        if (soundManager == null || !soundManager.isSoundEnabled()) {
            return;
        }
        soundManager.setCurrentLoop(1);
        soundManager.playSound(n);
    }

    public static void playSound(int n) {
        if (gameMode == 3 && state == 1) {
            return;
        }
        if (soundManager == null || !soundManager.isSoundEnabled() || machineGunPlaying) {
            return;
        }
        soundManager.setCurrentLoop(1);
        soundManager.setSoundVolume(Utils.soundVolume);
        soundManager.playSound(n);
        GameImpl.soundsLoaded[n - 6] = true;
        soundManager.setSoundVolume(Utils.soundVolume);
    }

    public static void playSoundRepeated(int n) {
        if (gameMode == 3 && state == 1) {
            return;
        }
        if (soundManager == null || !soundManager.isSoundEnabled()) {
            return;
        }
        soundManager.stopSounds();
        soundManager.setCurrentLoop(-1);
        soundManager.setSoundVolume(Utils.soundVolume);
        soundManager.playSound(n);
        GameImpl.soundsLoaded[n - 6] = true;
        soundManager.setSoundVolume(Utils.soundVolume);
    }

    public static void clean() {
        if (vm != null) {
            vm.clean();
        }
        if (player != null) {
            player.clean();
        }
        if (allies != null) {
            for (int i = 0; i < numAllies; ++i) {
                allies[i].clean();
            }
        }
        GameImpl.cleanStructures();
        GameImpl.cleanDecorators();
        if (PathFinder.mCalcGrid != null) {
            PathFinder.mCalcGrid.clear();
        }
    }

    public void appPointerPressed(int n, int n2, long l) {
    }

    public void appPointerReleased(int n, int n2, long l) {
    }

    public void appPointerDragged(int n, int n2, long l) {
    }

    public static void cleanSprites() {
        GameImpl.sprites[0] = null;
        GameImpl.sprites[1] = null;
        GameImpl.sprites[2] = null;
        GameImpl.sprites[16] = null;
        GameImpl.sprites[19] = null;
        GameImpl.sprites[3] = null;
        GameImpl.sprites[4] = null;
        GameImpl.sprites[6] = null;
        GameImpl.sprites[8] = null;
        GameImpl.sprites[5] = null;
        GameImpl.sprites[9] = null;
        GameImpl.sprites[11] = null;
        GameImpl.sprites[12] = null;
        GameImpl.sprites[14] = null;
        GameImpl.sprites[17] = null;
        GameImpl.sprites[18] = null;
        System.gc();
    }

    static {
        staticDecoratorPos = new int[1153];
        staticDecoratorData = new int[1153];
        decoratorsAnim = new Animator[12];
        decoratorsAnimID = new int[12];
        staticDecoratorIds = new short[1153];
        fixedWeights = new int[100];
        fixedIdx = new int[100];
        dynamicWeights = new int[50];
        dynamicIdx = new int[50];
        rectScreen = new int[4];
        rectClip = new int[4];
        rectTemp = new int[4];
        raceTime = -1;
        sniperMsgLenght = -1;
        sniperMsgPos = 0;
        sniperMsgInc = -1;
        sniperMsgLenght2 = -1;
        sniperMsgPos2 = 0;
        sniperMsgInc2 = -1;
        sniperMessages = new int[2];
        sniperReboundPositions = new int[]{-2560, -2560, 2304, 2304, 2304, -2048, -2048, 1280, 1024};
        sniperScopeOutPositions = new int[][]{{200, 120}, {240, 150}, {280, 180}, {320, 210}};
        sniperCoolDownTimer = 0;
        sniperScopeSpeed = 0;
        currentMaxUnlockedLevel = 0;
        currentLanguage = 0;
        isTransitionToGameState = false;
        tileSets = new int[]{6};
        string = new SDKString("");
        stringBuffer = new SDKString(64, 0);
        wrapOffsets = new short[128];
        pGodMode = false;
        godMode = false;
        postponeEndLevel = false;
        postponeChangeLevelMode = false;
        forceCinematicBars = false;
        continueNextLevel = -1;
        standbyTimer = 0;
        postponedTransition = -1;
        cinematicBarHeight = 0;
        saveTimer = 0;
        hudModel = new short[6];
        bombingHudFakeCodes = new SDKString[2];
        displayHints = true;
        objectiveShowMsg = true;
        currentConsecutiveHeadshots = 0;
        currentConsecutiveStealthKills = 0;
        machinegunKillCount = 0;
        achievementCompleted = null;
        beforeLevelAchievementCompleted = null;
        continueAchievementCompleted = null;
        achievementName = null;
        endLevelAchievementsPage = 0;
        endLevelAchievementsCounter = 0;
        saveData = new byte[1024];
        saveDataPart = null;
        destroyedCollisionsPosX = new short[64];
        destroyedCollisionsPosY = new short[64];
        playAreaLeftLimit = -1;
        playAreaRightLimit = -1;
        playAreaTopLimit = -1;
        playAreaBottomLimit = -1;
        MAP_KP_ORIENTATION = new int[][]{{513, 8, 0}, {513, 2, 1}, {513, 6, 7}, {513, 4, 8}, {32770, 8, 4}, {32770, 2, 3}, {32770, 6, 5}, {32770, 0, 8}, {2052, 8, 6}, {2052, 0, 7}, {2052, 4, 5}, {2052, 2, 8}, {8200, 8, 2}, {8200, 7, 0}, {8200, 5, 4}, {8200, 0, 1}, {8200, 4, 3}, {8200, 6, 8}, {65536, 8, 3}, {16384, 8, 5}, {256, 8, 7}, {1024, 8, 1}};
        X_ORIENTATION_FACTOR = new int[]{0, 179, 256, 179, 0, -179, -256, -179, 0};
        Y_ORIENTATION_FACTOR = new int[]{-256, -179, 0, 179, 256, 179, 0, -179, 0};
        CAMERA_OFFSET = new int[][]{{0, -26880}, {18974, -22375}, {27136, 0}, {18974, 14320}, {0, 15360}, {-18974, 14320}, {-27136, 0}, {-18974, -22375}};
        lastHealthLootTime = 0L;
        lastAmmoLootTime = 0L;
        cutSceneScript = -1;
        skipSceneScript = -1;
        dImg = null;
        bCleanMemory = true;
        currentSpriteToLoad = 0;
        SHOTGUN_LEFT_LINE_OFFSET_X = new int[]{-53, 16, 78, 90, 53, -15, -78, -90};
        SHOTGUN_RIGHT_LINE_OFFSET_X = new int[]{54, 90, 78, 16, -54, -90, -79, -16};
        SHOTGUN_LEFT_LINE_OFFSET_Y = new int[]{-77, -91, -55, 15, 78, 90, 53, -16};
        SHOTGUN_RIGHT_LINE_OFFSET_Y = new int[]{-77, -16, 52, 90, 78, 16, -54, -90};
        bSetStateMenu = false;
        dialogPercentages = new int[]{5, 25, 50, 70, 90};
        dialogFrame = 0;
        soundsLoaded = new boolean[6];
        machineGunPlaying = false;
    }
}

