/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.GameImpl;
import com.ea.game.Map;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;

public class Entity
implements Constants {
    public int posX;
    public int posY;
    public int type;
    public int id;
    public int state;
    byte[] bData;
    short[] sData;
    int[] iData;
    public boolean finished;

    public Entity() {
        this.finished = false;
    }

    public Entity(int n) {
        this.type = n;
        switch (n) {
            case 3: {
                this.bData = new byte[12];
                this.sData = new short[8];
                break;
            }
            case 4: {
                this.bData = new byte[4];
                this.sData = new short[2];
                break;
            }
            case 2: {
                this.bData = new byte[6];
                break;
            }
            case 6: {
                this.bData = new byte[6];
                this.state = 0;
                break;
            }
            case 9: {
                this.bData = new byte[5];
                this.sData = new short[1];
                break;
            }
            case 103: {
                this.bData = new byte[5];
                this.iData = new int[9];
                break;
            }
            case 10: {
                this.bData = new byte[2];
                break;
            }
            case 11: {
                this.bData = new byte[8];
                break;
            }
            case 13: {
                this.bData = new byte[4];
                this.sData = new short[3];
                break;
            }
            case 14: {
                this.bData = new byte[1];
                this.sData = new short[2];
                break;
            }
            case 15: {
                this.sData = new short[2];
                break;
            }
            case 105: {
                this.sData = new short[9];
                break;
            }
            case 24: {
                this.bData = new byte[8];
                this.state = 0;
                break;
            }
            case 26: {
                this.bData = new byte[6];
                break;
            }
            case 27: {
                this.bData = new byte[3];
                this.sData = new short[4];
                this.iData = new int[1];
            }
        }
    }

    public void load(SDKInputStream sDKInputStream) {
        try {
            switch (this.type) {
                case 3: {
                    this.id = sDKInputStream.read() & 0xFF;
                    this.loadCollision(sDKInputStream);
                    this.sData[0] = sDKInputStream.readShort();
                    this.bData[6] = (byte)sDKInputStream.read();
                    this.bData[7] = (byte)(sDKInputStream.read() & 0xFF);
                    this.bData[8] = (byte)(sDKInputStream.read() & 0xFF);
                    this.sData[1] = sDKInputStream.readShort();
                    this.bData[9] = (byte)sDKInputStream.read();
                    this.sData[2] = sDKInputStream.readShort();
                    this.sData[3] = sDKInputStream.readShort();
                    this.sData[4] = sDKInputStream.readShort();
                    this.sData[5] = sDKInputStream.readShort();
                    this.sData[6] = sDKInputStream.readShort();
                    this.bData[10] = (byte)sDKInputStream.read();
                    this.bData[11] = (byte)sDKInputStream.read();
                    this.sData[7] = sDKInputStream.readShort();
                    break;
                }
                case 6: {
                    this.id = sDKInputStream.read() & 0xFF;
                    this.bData[5] = (byte)sDKInputStream.read();
                    this.sData = new short[3 + this.bData[5]];
                    this.sData[0] = sDKInputStream.readShort();
                    this.sData[1] = sDKInputStream.readShort();
                    this.loadCollision(sDKInputStream);
                    this.sData[2] = sDKInputStream.readShort();
                    for (int i = 0; i < this.bData[5]; ++i) {
                        this.sData[3 + i] = sDKInputStream.readShort();
                    }
                    break;
                }
                case 24: {
                    this.bData[5] = (byte)sDKInputStream.read();
                    this.sData = new short[4 + this.bData[5]];
                    this.sData[0] = sDKInputStream.readShort();
                    this.sData[1] = sDKInputStream.readShort();
                    this.loadCollision(sDKInputStream);
                    this.sData[2] = sDKInputStream.readShort();
                    this.bData[6] = (byte)(sDKInputStream.read() & 0xFF);
                    this.sData[3] = sDKInputStream.readShort();
                    this.bData[7] = (byte)(sDKInputStream.read() & 0xFF);
                    for (int i = 0; i < this.bData[5]; ++i) {
                        this.sData[4 + i] = sDKInputStream.readShort();
                    }
                    break;
                }
                case 9: {
                    this.id = sDKInputStream.read() & 0xFF;
                    this.bData[0] = (byte)sDKInputStream.read();
                    this.bData[1] = (byte)(sDKInputStream.read() & 0xFF);
                    this.bData[2] = (byte)(sDKInputStream.read() & 0xFF);
                    this.bData[3] = (byte)(sDKInputStream.read() & 0xFF);
                    this.bData[4] = (byte)(sDKInputStream.read() & 0xFF);
                    this.sData[0] = sDKInputStream.readShort();
                    break;
                }
                case 10: {
                    this.id = sDKInputStream.read() & 0xFF;
                    this.bData[0] = (byte)sDKInputStream.read();
                    this.bData[1] = (byte)sDKInputStream.read();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadCollision(SDKInputStream sDKInputStream) throws IOException {
        this.bData[0] = (byte)sDKInputStream.read();
        this.bData[1] = (byte)sDKInputStream.read();
        this.bData[2] = (byte)sDKInputStream.read();
        this.bData[3] = (byte)sDKInputStream.read();
        this.bData[4] = (byte)sDKInputStream.read();
    }

    public void draw(SDKGraphics sDKGraphics) {
    }

    public void update() {
        boolean bl = true;
        switch (this.type) {
            case 6: {
                if (this.state == 1 || !(bl = this.bData[0] == 2 ? Utils.isColliding(this.sData[0], this.sData[1], this.bData, GameImpl.player.posX >> 8, GameImpl.player.posY >> 8, GameImpl.player.bData) : Utils.pointInCircle(GameImpl.player.posX >> 8, GameImpl.player.posY >> 8, this.bData[1] + this.sData[0] + ((this.bData[3] & 0xFF) >> 1), this.bData[2] + this.sData[1] + ((this.bData[3] & 0xFF) >> 1), (this.bData[3] & 0xFF) >> 1))) break;
                int[] nArray = null;
                if (this.bData[5] > 0) {
                    nArray = new int[this.bData[5]];
                    for (int i = 0; i < this.bData[5]; ++i) {
                        nArray[i] = this.sData[3 + i];
                    }
                }
                this.state = 1;
                if (this.sData[2] == -1) break;
                GameImpl.vm.spawnInstanceByID(this.sData[2], -1, nArray);
                break;
            }
            case 24: {
                if (this.state == 2) break;
                bl = this.bData[0] == 2 ? Utils.isColliding(this.sData[0], this.sData[1], this.bData, GameImpl.player.posX >> 8, GameImpl.player.posY >> 8, GameImpl.player.bData) : Utils.pointInCircle(GameImpl.player.posX >> 8, GameImpl.player.posY >> 8, this.bData[1] + this.sData[0] + ((this.bData[3] & 0xFF) >> 1), this.bData[2] + this.sData[1] + ((this.bData[3] & 0xFF) >> 1), (this.bData[3] & 0xFF) >> 1);
                if (bl && this.state == 0) {
                    if (this.sData[2] != -1) {
                        int[] nArray = null;
                        if (this.bData[6] > 0) {
                            nArray = new int[this.bData[6]];
                            for (int i = 0; i < this.bData[6]; ++i) {
                                nArray[i] = this.sData[4 + i];
                            }
                        }
                        GameImpl.vm.spawnInstanceByID(this.sData[2], -1, nArray);
                    }
                    this.state = 1;
                    break;
                }
                if (bl || this.state != 1) break;
                if (this.sData[3] != -1) {
                    int[] nArray = null;
                    if (this.bData[7] > 0) {
                        nArray = new int[this.bData[7]];
                        for (int i = 0; i < this.bData[7]; ++i) {
                            nArray[i] = this.sData[4 + this.bData[6] + i];
                        }
                    }
                    GameImpl.vm.spawnInstanceByID(this.sData[3], -1, nArray);
                }
                this.state = 0;
                break;
            }
            case 105: {
                this.sData[8] = (short)(this.sData[8] + 1);
                if (this.sData[8] % 8 == 0) {
                    XSprite xSprite = GameImpl.sprites[2];
                    int n = xSprite._frames_fm_offset[this.sData[7] + 1] - xSprite._frames_fm_offset[this.sData[7]];
                    int n2 = Utils.random(n);
                    int n3 = xSprite._fmodules_ox[xSprite._frames_fm_offset[this.sData[7]] + n2];
                    int n4 = xSprite._fmodules_oy[xSprite._frames_fm_offset[this.sData[7]] + n2];
                    if (XSprite.drawScaled && GameImpl.gameMode != 3) {
                        n3 >>= 1;
                        n4 >>= 1;
                    }
                    this.sData[5] = (this.sData[5] = (short)(this.sData[5] / 2)) < 2 ? 2 : this.sData[5];
                    GameImpl.spawnBlastAnimation(this.sData[0] + n3 << 8, this.sData[1] + n4 << 8, this.sData[2], this.sData[3], this.sData[5], this.sData[4], (byte)0);
                }
                if (this.sData[8] == 24) {
                    GameImpl.setFlagStaticDecorator(this.sData[6], 64);
                    Map._bResetCDB = true;
                }
                if (this.sData[8] <= 32) break;
                this.finished = true;
            }
        }
    }
}

