/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.AnimatedEntity;
import com.ea.game.Animator;
import com.ea.game.Camera;
import com.ea.game.Character;
import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.Machinegun;
import com.ea.game.Map;
import com.ea.game.PathFinder;
import com.ea.game.SpriteConstants;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;

public class Enemy
extends Entity
implements Constants,
SpriteConstants,
Constants.EnemyConstants {
    public int classId;
    public int returnX = -1;
    public int returnY = -1;
    public int destX;
    public int destY;
    public int alertPosX;
    public int alertPosY;
    public int timer;
    public int shakerCoolDown;
    public int lastFov;
    public int orientation;
    public int life;
    public int maxLife;
    public int magazine;
    public Animator baseAnimator;
    public Animator turretAnimator;
    public Animator targetAnimator;
    public Animator signAnimator;
    public int endGrenadePosX;
    public int endGrenadePosY;
    public AnimatedEntity grenade;
    public Character targetCharacter;
    public int pathLength = 0;
    public int pathIndex = 0;
    public short[] pathX = new short[96];
    public short[] pathY = new short[96];
    public int[] waypoints;
    public byte[] waypointsPause;
    public short[] waypointsScripts;
    public byte[] waypointsFlags;
    public int waypointIndex;
    public int sign;
    public int initialOrientation;
    public boolean isCovered;
    public boolean isAssisting;
    public boolean isShooting;
    public boolean hasDoneAlert;
    public boolean fadeIn;
    public boolean rollForCover;
    public boolean isDyingAfterJump;
    public boolean displaySign;
    public Character lastSeenCharacter;
    public int fadeInPositionX;
    public int fadeInPositionY;
    public int speed;
    public byte flags;
    public int substate;
    public boolean isJumping;
    public int jumpLandingX;
    public int jumpLandingY;
    public int jumpPathIndex;
    public int weaponPosX;
    public int weaponPosY;
    public Machinegun machinegun = null;
    public static int[] A_ENEMY_RIFLE_BURST;
    public static int[] A_ENEMY_DIE_RIFLE_BURST;
    public static int[] A_ENEMY_ALERT;
    public static int[] A_ENEMY_NOTICE;
    public static int[] A_HUD_DAMAGE;
    public int fadeOutCounter = 0;
    public int hearTimer = 0;
    public int speechMessage = -1;

    public static boolean isEnemy(Entity entity) {
        return entity.type == 4;
    }

    public Enemy() {
        super(4);
        this.baseAnimator = new Animator();
        this.turretAnimator = new Animator();
        this.targetAnimator = new Animator();
        this.targetAnimator._sprite = 5;
        this.signAnimator = null;
        this.targetCharacter = GameImpl.player;
        this.isAssisting = false;
        this.isCovered = false;
        this.hasDoneAlert = false;
        this.isJumping = false;
        this.isDyingAfterJump = false;
        this.displaySign = false;
        this.lastSeenCharacter = null;
        this.rollForCover = true;
        this.fadeIn = false;
        this.fadeInPositionX = 0;
        this.fadeInPositionY = 0;
        this.machinegun = null;
        this.grenade = null;
    }

    public boolean isAlertingEnemy() {
        return (this.classId == 2 || this.classId == 7 || this.classId == 10) && !this.hasDoneAlert;
    }

    public void load(SDKInputStream sDKInputStream) {
        try {
            this.id = sDKInputStream.readShort() & 0xFFFF;
            this.posX = sDKInputStream.readShort() << 8;
            this.posY = sDKInputStream.readShort() << 8;
            this.classId = sDKInputStream.read() & 0xFF;
            this.initialOrientation = this.orientation = sDKInputStream.read();
            this.maxLife = this.life = this.getEnemyClass().sData[0];
            this.turretAnimator._sprite = this.baseAnimator._sprite = this.getEnemyClass().bData[6];
            this.baseAnimator.SetCrtAnim(Character.A_BASE_STAND[this.orientation]);
            this.turretAnimator.SetCrtAnim(Character.A_TURRET_IDLE[this.orientation]);
            this.flags = (byte)sDKInputStream.read();
            if (this.isAlertingEnemy() || (this.flags & 0x20) != 0) {
                this.signAnimator = new Animator();
                this.signAnimator._sprite = 0;
                this.signAnimator.SetCrtAnim(336);
            }
            byte by = (byte)(sDKInputStream.read() & 0xFF);
            this.setModuleMapping(by);
            this.bData[0] = (byte)(sDKInputStream.read() & 0xFF);
            this.bData[1] = (byte)(sDKInputStream.read() & 0xFF);
            this.bData[2] = (byte)(sDKInputStream.read() & 0xFF);
            this.bData[3] = (byte)(sDKInputStream.read() & 0xFF);
            this.sData[0] = sDKInputStream.readShort();
            this.magazine = this.getEnemyClass().bData[8];
            int n = (sDKInputStream.read() & 0xFF) << 1;
            if (n > 0 && this.isAlertingEnemy()) {
                this.alertPosX = sDKInputStream.readShort();
                this.alertPosY = sDKInputStream.readShort();
                sDKInputStream.read();
                this.sData[1] = sDKInputStream.readShort();
                sDKInputStream.read();
                n -= 2;
            }
            if (n > 0) {
                this.waypoints = new int[n];
                this.waypointsPause = new byte[n >> 1];
                this.waypointsScripts = new short[n >> 1];
                this.waypointsFlags = new byte[n >> 1];
                for (int i = 0; i < this.waypoints.length >> 1; ++i) {
                    this.waypoints[i << 1] = sDKInputStream.readShort();
                    this.waypoints[(i << 1) + 1] = sDKInputStream.readShort();
                    this.waypointsPause[i] = (byte)(sDKInputStream.read() & 0xFF);
                    this.waypointsScripts[i] = sDKInputStream.readShort();
                    this.waypointsFlags[i] = (byte)(sDKInputStream.read() & 0xFF);
                }
                this.waypointIndex = 0;
                this.sign = 1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModuleMapping(int n) {
        int n2 = 0;
        this.baseAnimator.SetModuleMapping(n);
        this.turretAnimator.SetModuleMapping(n);
        n2 = 1;
        this.baseAnimator.SetPalette(n2);
        this.turretAnimator.SetPalette(n2);
    }

    public void updateSign() {
        if ((this.flags & 0x20) != 0 && GameImpl.player != null) {
            if (this.lastFov != 0) {
                if (this.signAnimator._crt_anim != 335) {
                    this.signAnimator.SetCrtAnim(335);
                }
                this.displaySign = true;
                return;
            }
            if (this.hearTimer < 30) {
                if (this.signAnimator._crt_anim != 336) {
                    this.signAnimator.SetCrtAnim(336);
                }
                this.displaySign = true;
                return;
            }
        }
        this.displaySign = false;
    }

    void init() {
        if (this.state != 11 && this.state != 1 && this.state != 17) {
            if (this.waypoints != null && (this.flags & 2) != 0) {
                this.setState(7);
            } else {
                this.setState(0);
            }
        }
    }

    public static int getWeaponPosXOrientation(int n) {
        XSprite xSprite = GameImpl.sprites[0];
        short s = xSprite._aframes_id[xSprite._animations_af_offset[Character.A_TURRET_SHOOT[n]]];
        return xSprite._fmodules_ox[xSprite._frames_fm_offset[s + 1] - 1];
    }

    public static int getWeaponPosYOrientation(int n) {
        XSprite xSprite = GameImpl.sprites[0];
        short s = xSprite._aframes_id[xSprite._animations_af_offset[Character.A_TURRET_SHOOT[n]]];
        return xSprite._fmodules_oy[xSprite._frames_fm_offset[s + 1] - 1];
    }

    void updateTurretAnimation() {
        int n = this.getTurretAnim(this.getTurretOrientation());
        if (n != this.turretAnimator._crt_anim) {
            this.turretAnimator.SetCrtAnim(n);
            this.turretAnimator.SetCrtAFrame(this.baseAnimator._crt_aframe % this.turretAnimator.GetCrtAnimLength());
            this.weaponPosX = Enemy.getWeaponPosXOrientation(this.getTurretOrientation());
            this.weaponPosY = Enemy.getWeaponPosYOrientation(this.getTurretOrientation());
        }
    }

    int getTurretAnim(int n) {
        switch (this.state) {
            case 0: 
            case 18: {
                if (!this.isCovered) {
                    return Character.A_TURRET_IDLE[n];
                }
                return Character.A_TURRET_IDLE[n];
            }
            case 10: {
                return Character.A_TURRET_MACHINEGUN_SHOOT[n];
            }
            case 15: {
                return Character.A_TURRET_COVER_AIM[n];
            }
            case 16: {
                return Character.A_TURRET_IDLE[n];
            }
            case 9: {
                if (!this.isCovered) {
                    return Character.A_TURRET_AIM[n];
                }
                return Character.A_TURRET_COVER_AIM[n];
            }
            case 2: {
                if (!this.isCovered) {
                    return Character.A_TURRET_SHOOT[n];
                }
                return Character.A_TURRET_COVER_SHOOT[n];
            }
            case 7: {
                if (this.timer < 0) {
                    return Character.A_TURRET_IDLE[this.getMovementOrientation()];
                }
                return Character.A_TURRET_RUN[this.getMovementOrientation()];
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                return Character.A_TURRET_RUN[this.getMovementOrientation()];
            }
            case 12: {
                if (!this.isCovered) {
                    return Character.A_TURRET_RELOAD[n];
                }
                return Character.A_TURRET_COVER_RELOAD[n];
            }
            case 13: {
                if (!this.isCovered) {
                    return Character.A_TURRET_SHOOT[n];
                }
                return Character.A_TURRET_COVER_SHOOT[n];
            }
        }
        return Character.A_TURRET_IDLE[n];
    }

    public int getHeight() {
        int n = 0;
        int[] nArray = GameImpl.sprites[this.baseAnimator._sprite].RectFrame(this.baseAnimator._crt_aframe, 100, 100, 0);
        n += nArray[3];
        nArray = GameImpl.sprites[this.turretAnimator._sprite].RectFrame(this.turretAnimator._crt_aframe, 100, 100, 0);
        return n -= nArray[1];
    }

    int getTurretOrientation() {
        if (this.lastFov == 0 || this.state == 10 || this.state == 11) {
            return this.orientation;
        }
        int n = this.targetCharacter.posX - this.posX >> 8;
        int n2 = this.targetCharacter.posY - this.posY >> 8;
        return GameImpl.getOrientation(n, n2);
    }

    int getMovementOrientation() {
        int n = 0;
        int n2 = 0;
        if (this.pathIndex < this.pathLength - 1) {
            n = this.pathX[this.pathIndex + 1] - this.pathX[this.pathIndex];
            n2 = this.pathY[this.pathIndex + 1] - this.pathY[this.pathIndex];
        } else if (this.pathIndex > 0) {
            n = this.pathX[this.pathIndex] - this.pathX[this.pathIndex - 1];
            n2 = this.pathY[this.pathIndex] - this.pathY[this.pathIndex - 1];
        } else {
            return this.getTurretOrientation();
        }
        return GameImpl.getOrientation(n << 8, n2 << 8);
    }

    public void draw(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        if ((this.flags & 0x10) != 0 && this.speechMessage != -1) {
            if (this.state != 17) {
                SDKUtils.setFont(GameImpl.fonts[1]);
            } else {
                SDKUtils.setFont(GameImpl.fonts[0]);
            }
            SDKUtils.getString(this.speechMessage, GameImpl.string);
            GameImpl.wrapOffsets = SDKUtils.wrapString(GameImpl.string, GameImpl.wrapOffsets, 1280, (short)124);
            SDKUtils.drawWrappedString(GameImpl.string, GameImpl.wrapOffsets, 1, GameImpl.wrapOffsets[0], (this.posX >> 8) - Camera.posX, (this.posY >> 8) - Camera.posY - 27, 33);
            if (this.state == 1 && this.substate != 0) {
                this.baseAnimator.DrawFrame(sDKGraphics, 297, this.posX >> 8, this.posY >> 8);
                return;
            }
        }
        if (this.state == 1 && this.substate == 3) {
            this.baseAnimator.DrawFrame(sDKGraphics, 297, this.posX >> 8, this.posY >> 8);
            return;
        }
        if (this.state == 1 && this.substate == 2 || this.state == 17) {
            return;
        }
        if (this.fadeIn) {
            n2 = 0;
            n = 0;
            if (this.orientation > 4) {
                n2 = 0;
                n = this.fadeInPositionX - Camera.posX - 3;
            } else {
                n2 = this.fadeInPositionX - Camera.posX + 3;
                n = 320 - (this.fadeInPositionX - Camera.posX + 3);
            }
            sDKGraphics.setClip(n2, 0, n, 240);
        }
        n2 = this.posX >> 8;
        n = this.posY >> 8;
        this.baseAnimator.DrawCrtAnim(sDKGraphics, n2, n);
        if (this.drawTurret()) {
            this.turretAnimator.DrawCrtAnim(sDKGraphics, n2, n);
        }
        if (!(!this.isAlertingEnemy() && !this.displaySign || this.state == 1 || GameImpl.player.canComboStealthKill && GameImpl.player.target.enemyTarget == this)) {
            this.signAnimator.DrawCrtAnim(sDKGraphics, n2, n - 60);
        }
        if (this.isOnScreen() && GameImpl.player != null && GameImpl.player.state != 6 && this.state != 1 && this.state != 17 && GameImpl.player.getWeponType() == 2 && GameImpl.player.isInShotgunShootArea(this) && !GameImpl.player.canStealthKill && !GameImpl.player.canComboStealthKill) {
            if (Enemy.canEnemyBeShoot(GameImpl.player.posX >> 8, GameImpl.player.posY >> 8, this.posX >> 8, this.posY >> 8, this, GameImpl.player)) {
                GameImpl.sprites[5].DrawFrame(14, n2 - Camera.posX, n - Camera.posY, 0);
            } else {
                GameImpl.sprites[5].DrawFrame(15, n2 - Camera.posX, n - Camera.posY, 0);
            }
        }
        if (GameImpl.playState != 1 && GameImpl.gameMode == 1 && this.state != 1 && this.life <= this.maxLife >> 1) {
            GameImpl.FillRect(sDKGraphics, 0, (this.posX >> 8) - Camera.posX - 20, (this.posY >> 8) - Camera.posY - 55, 40, 5);
            int n3 = 36 * this.life / this.maxLife;
            GameImpl.FillRect(sDKGraphics, 65280, (this.posX >> 8) - Camera.posX - 18, (this.posY >> 8) - Camera.posY - 54, n3, 3);
        }
        if (this.fadeIn) {
            sDKGraphics.setClip(0, 0, 320, 240);
        }
    }

    public void drawTargetGrenade(SDKGraphics sDKGraphics) {
        if (this.state == 13) {
            this.targetAnimator.DrawCrtAnim(sDKGraphics, this.endGrenadePosX >> 8, this.endGrenadePosY >> 8);
            this.targetAnimator.DrawFrame(sDKGraphics, 27, this.endGrenadePosX >> 8, this.endGrenadePosY >> 8);
        } else if (this.grenade != null && this.grenade.isActive()) {
            this.targetAnimator.DrawCrtAnim(sDKGraphics, this.endGrenadePosX >> 8, this.endGrenadePosY >> 8);
            if (this.grenade.bData[1] < this.grenade.bData[2] / 3) {
                this.targetAnimator.DrawFrame(sDKGraphics, 28, this.endGrenadePosX >> 8, this.endGrenadePosY >> 8);
            } else if (this.grenade.bData[1] < 2 * this.grenade.bData[2] / 3) {
                this.targetAnimator.DrawFrame(sDKGraphics, 29, this.endGrenadePosX >> 8, this.endGrenadePosY >> 8);
            } else {
                this.targetAnimator.DrawFrame(sDKGraphics, 30, this.endGrenadePosX >> 8, this.endGrenadePosY >> 8);
            }
        }
    }

    public boolean drawTurret() {
        if (this.isJumping) {
            return false;
        }
        switch (this.state) {
            case 1: 
            case 14: 
            case 16: {
                return false;
            }
            case 4: {
                if (this.substate == 1) break;
                return false;
            }
            case 0: 
            case 18: {
                if (!this.isCovered) break;
                return false;
            }
        }
        return true;
    }

    public void update() {
        int n;
        if (this.state == 17) {
            return;
        }
        super.update();
        --this.shakerCoolDown;
        if (this.fadeIn && (this.timer > 8 || this.state == 1)) {
            this.fadeIn = false;
        }
        if (this.grenade != null) {
            if (this.grenade.isActive()) {
                this.targetAnimator.UpdateCrtAnim();
            } else {
                this.grenade = null;
            }
        }
        if (this.state == 1) {
            switch (this.substate) {
                case 0: {
                    if (this.baseAnimator.IsCrtAnimEnded()) {
                        this.substate = 1;
                        break;
                    }
                    this.baseAnimator.UpdateCrtAnim();
                    break;
                }
                case 1: {
                    if (++this.fadeOutCounter < 20) break;
                    GameImpl.spawnLoot(this.posX, this.posY);
                    this.substate = 2;
                    break;
                }
            }
            return;
        }
        if (this.state == 14) {
            if (this.baseAnimator.IsCrtAnimEnded()) {
                this.setState(0);
            } else {
                this.posX -= GameImpl.X_ORIENTATION_FACTOR[this.orientation];
                this.posY -= GameImpl.Y_ORIENTATION_FACTOR[this.orientation];
            }
            this.baseAnimator.UpdateCrtAnim();
            return;
        }
        if (this.signAnimator != null) {
            this.signAnimator.UpdateCrtAnim();
        }
        int n2 = 0;
        int n3 = 0;
        Character character = this.targetCharacter;
        this.targetCharacter = GameImpl.player;
        int n4 = this.lastFov;
        this.lastFov = this.getFOV();
        if (this.lastFov != 3) {
            for (n = 0; n < GameImpl.numAllies; ++n) {
                if (GameImpl.allies[n].state == 6 || GameImpl.allies[n].state == 9) continue;
                character = this.targetCharacter;
                this.targetCharacter = GameImpl.allies[n];
                int n5 = this.getFOV();
                if (n5 == 3) {
                    this.lastFov = n5;
                    break;
                }
                if (n2 != 2 && n5 == 2) {
                    n2 = n5;
                    n3 = n;
                }
                this.targetCharacter = character;
            }
        }
        if (this.targetCharacter == GameImpl.player && (this.lastFov == 0 || this.lastFov == 1) && n2 == 2) {
            this.lastFov = n2;
            this.targetCharacter = GameImpl.allies[n3];
        }
        switch (this.lastFov) {
            case 2: {
                if (this.isAlertingEnemy()) {
                    this.setState(4);
                    break;
                }
                if (this.doThrowGrenade()) {
                    this.throwGrenade(this.targetCharacter.posX, this.targetCharacter.posY);
                    break;
                }
                if (this.state == 13 || this.grenade != null || this.state == 10 || this.state == 11) break;
                if (!this.isCovered && this.rollForCover && this.doRollForCover()) {
                    this.findAndGoToCover(this.targetCharacter.posX, this.targetCharacter.posY);
                    break;
                }
                if ((this.flags & 1) == 0 && !this.isAssisting || this.state == 10 || this.state == 11) break;
                this.destX = this.targetCharacter.posX;
                this.destY = this.targetCharacter.posY;
                this.setState(5);
                break;
            }
            case 3: {
                if (this.isAlertingEnemy()) {
                    this.setState(4);
                    break;
                }
                if (this.isJumping || this.state == 10 || this.state == 11 || this.state == 12 || this.state == 13 || this.state == 2) break;
                if (!this.isCovered && this.rollForCover && this.doRollForCover()) {
                    this.findAndGoToCover(this.targetCharacter.posX, this.targetCharacter.posY);
                    break;
                }
                if (this.magazine > 0) {
                    if (this.isCovered) {
                        if (this.state == 16) break;
                        this.setState(15);
                        break;
                    }
                    this.setState(18);
                    break;
                }
                this.setState(12);
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (!(this.state != 5 && this.state != 2 || this.isJumping)) {
                    if (Utils.Distance(this.targetCharacter.posX - this.posX, this.targetCharacter.posY - this.posY) < 14080) {
                        this.setOrientation(GameImpl.getOrientation(this.targetCharacter.posX - this.posX, this.targetCharacter.posY - this.posY));
                    } else {
                        this.setState(9);
                    }
                }
                this.rollForCover = true;
            }
        }
        switch (this.state) {
            case 18: {
                if (this.timer <= this.getEnemyClass().bData[11]) break;
                this.setState(2);
                break;
            }
            case 2: {
                if (!this.isShooting && this.turretAnimator.IsCrtAnimEnded()) {
                    this.timer = 0;
                    this.isShooting = true;
                    this.turretAnimator.UpdateCrtAnim();
                }
                if (this.timer <= this.getEnemyClass().bData[10] || !this.isShooting) break;
                this.isShooting = false;
                if (!this.isCovered) {
                    this.setState(0);
                    break;
                }
                this.setState(16);
                break;
            }
            case 13: {
                if (this.turretAnimator.IsCrtAnimEnded()) {
                    this.grenade = GameImpl.createGrenade(this.posX, this.posY, this.endGrenadePosX, this.endGrenadePosY, -(this.weaponPosY << 8), this.orientation, 1);
                    this.bData[1] = (byte)(this.bData[1] - 1);
                    this.setState(0);
                }
                this.targetAnimator.UpdateCrtAnim();
                break;
            }
            case 0: {
                int n6 = this.getTurretOrientation();
                if (n6 != this.orientation) {
                    this.setOrientation(n6);
                }
                if (this.returnX == -1) break;
                this.setState(9);
                break;
            }
            case 12: {
                if (!this.turretAnimator.IsCrtAnimEnded()) break;
                this.magazine = this.getEnemyClass().bData[8];
                this.setState(0);
                break;
            }
            case 5: {
                if (this.updatePath()) {
                    this.setState(0);
                    break;
                }
                if (Utils.Distance(this.destX - this.targetCharacter.posX, this.destY - this.targetCharacter.posY) >> 8 <= 100) break;
                this.goToArea(this.targetCharacter.posX, this.targetCharacter.posY);
                break;
            }
            case 4: {
                switch (this.substate) {
                    case 0: {
                        if (!this.baseAnimator.IsCrtAnimEnded()) break;
                        this.substate = 1;
                        this.gotoXY(this.alertPosX, this.alertPosY);
                        this.setBaseAnimation();
                        break;
                    }
                    case 1: {
                        if (!this.updatePath()) break;
                        this.substate = 2;
                        this.setBaseAnimation();
                        break;
                    }
                    case 2: {
                        if (!this.baseAnimator.IsCrtAnimEnded()) break;
                        GameImpl.activateBarracks(this.posX >> 8, this.posY >> 8, this.getEnemyClass().sData[7]);
                        this.hasDoneAlert = true;
                        if (this.sData[1] > 0) {
                            GameImpl.vm.spawnInstanceByID(this.sData[1], -1);
                        }
                        this.setState(0);
                    }
                }
                break;
            }
            case 8: {
                if (!this.updatePath()) break;
                this.setState(9);
                break;
            }
            case 9: {
                if (this.timer > 48) {
                    n = -1;
                    if (GameImpl.gameMode == 1 && Utils.randomInt() % 2 == 0 && (n = GameImpl.getCoverPosition(this.posX, this.posY, this.targetCharacter.posX, this.targetCharacter.posY)) != -1) {
                        this.returnX = -1;
                        this.returnY = -1;
                        this.isAssisting = false;
                        this.destX = Map.collision_tile_h * (n & 0xFF) << 8;
                        this.destY = Map.collision_tile_w * (n >> 16) << 8;
                        this.setState(11);
                        break;
                    }
                    this.setState(6);
                    break;
                }
                if (this.timer % 6 != 0) break;
                this.setOrientation((this.orientation + 1) % 8);
                break;
            }
            case 15: {
                if (this.timer <= 20) break;
                this.setState(2);
                break;
            }
            case 16: {
                if (this.timer <= 40) break;
                this.setState(0);
                break;
            }
            case 6: {
                if (!this.updatePath()) break;
                this.returnX = -1;
                this.returnY = -1;
                this.isAssisting = false;
                this.setOrientation(this.initialOrientation);
                this.setState(0);
                break;
            }
            case 7: {
                if (this.waypoints == null || this.waypoints.length <= 0 || this.timer < 0) break;
                if (this.timer == 0) {
                    this.setBaseAnimation();
                }
                if (!this.updatePath()) break;
                this.timer = -this.waypointsPause[this.waypointIndex];
                this.setBaseAnimation();
                if ((this.waypointsFlags[this.waypointIndex] & 1) != 0 && this.waypointsScripts[this.waypointIndex] > 0) {
                    GameImpl.vm.spawnInstanceByID(this.waypointsScripts[this.waypointIndex], -1);
                }
                this.waypointIndex += this.sign;
                int n7 = this.sign > 0 ? (this.waypointIndex < this.waypoints.length >> 1 ? 1 : 0) : (n = this.waypointIndex > -1 ? 1 : 0);
                if (n != 0) {
                    this.gotoXY(this.waypoints[2 * this.waypointIndex], this.waypoints[2 * this.waypointIndex + 1]);
                    break;
                }
                this.waypointIndex = this.sign > 0 ? (this.waypoints.length >> 1) - 1 : 0;
                this.sign *= -1;
                this.gotoXY(this.waypoints[2 * this.waypointIndex], this.waypoints[2 * this.waypointIndex + 1]);
                break;
            }
            case 11: {
                if (this.machinegun != null && this.machinegun.state != 0) {
                    this.setState(0);
                    break;
                }
                if (!this.updatePath()) break;
                if (this.machinegun != null) {
                    this.setState(10);
                    break;
                }
                this.setState(0);
                if (this.targetCharacter == null) break;
                this.setOrientation(GameImpl.getOrientation(this.targetCharacter.posX - this.posX, this.targetCharacter.posY - this.posY));
                break;
            }
            case 10: {
                if (this.lastFov != 0 && this.lastFov != 1 && !this.machinegun.searchCharacterTarget()) {
                    this.machinegun = null;
                    this.setState(0);
                    break;
                }
                this.posX = this.machinegun.getGunnerPositionX();
                this.posY = this.machinegun.getGunnerPositionY();
                this.setOrientation(this.machinegun.orientation);
                break;
            }
            case 1: {
                return;
            }
        }
        this.updateTurretAnimation();
        this.baseAnimator.UpdateCrtAnim();
        if (this.state != 10 || this.machinegun.state == 2) {
            this.turretAnimator.UpdateCrtAnim();
        }
        if (n4 != this.lastFov && this.lastFov != 0 && this.lastFov != 1) {
            GameImpl.activateAssist(this.posX >> 8, this.posY >> 8, this.targetCharacter.posX >> 8, this.targetCharacter.posY >> 8, this.getEnemyClass().sData[6] >> 1);
        }
        ++this.timer;
    }

    public boolean coverNotTooClose(int n, int n2) {
        if (GameImpl.player != null && Utils.Distance(n - GameImpl.player.posX, n2 - GameImpl.player.posY) < 25600) {
            return false;
        }
        for (int i = 0; i < GameImpl.numAllies; ++i) {
            if (Utils.Distance(n - GameImpl.allies[i].posX, n2 - GameImpl.allies[i].posY) >= 25600) continue;
            return false;
        }
        return true;
    }

    public boolean findAndGoToCover(int n, int n2) {
        int n3;
        int n4;
        int n5 = GameImpl.getCoverPosition(this.posX, this.posY, n, n2);
        if (n5 != -1 && this.coverNotTooClose(n4 = Map.collision_tile_h * (n5 & 0xFF) << 8, n3 = Map.collision_tile_w * (n5 >> 16) << 8) && Utils.Distance(n - n4, n2 - n3) <= this.getEnemyClass().sData[3] << 8) {
            this.destX = n4;
            this.destY = n3;
            this.setState(11);
            return true;
        }
        return false;
    }

    public boolean doRollForCover() {
        this.rollForCover = false;
        return Utils.randomInt() % 100 < this.bData[2];
    }

    public boolean didMiss(int n) {
        return Utils.random(100 - (this.getEnemyClass().sData[3] - (n >> 8) >> 1)) > this.bData[0];
    }

    public boolean doThrowGrenade() {
        return this.state != 10 && this.state != 4 && !this.isJumping && this.grenade == null && (this.flags & 4) != 0 && this.bData[1] > 0 && this.state != 13;
    }

    public void throwGrenade(int n, int n2) {
        this.endGrenadePosX = n;
        this.endGrenadePosY = n2;
        this.setState(13);
    }

    public static boolean canEnemyBeShoot(int n, int n2, int n3, int n4, Enemy enemy, Character character) {
        boolean bl = GameImpl.isSomethingInBetween(n, n2, n3, n4, 0);
        boolean bl2 = GameImpl.isSomethingInBetween(n, n2, n3, n4, 1);
        if (!bl && !bl2) {
            return true;
        }
        if (bl) {
            return false;
        }
        return enemy.state == 14 || enemy.state == 2 && enemy.isShooting || enemy.state == 15 || !enemy.isCovered;
    }

    public void shoot() {
        int n;
        Debug.startTimer(2);
        int n2 = this.targetCharacter.posX;
        int n3 = this.targetCharacter.posY + (this.targetCharacter.weaponPosY << 8);
        --this.magazine;
        if (Utils.collPointBox(this.posX >> 8, this.posY >> 8, Camera.posX - 160, Camera.posY - 120, 640, 480)) {
            GameImpl.playSound(11);
        }
        if (this.didMiss(Utils.Distance(this.posX - this.targetCharacter.posX, this.posY - this.targetCharacter.posY))) {
            n = Utils.random(15, 25);
            n2 += Utils.random(2) == 0 ? n << 8 : -(n << 8);
            n = Utils.random(15, 25);
            n3 += Utils.random(2) == 0 ? n << 8 : -(n << 8);
        } else {
            n = 0;
            if (this.targetCharacter.isCovered && this.targetCharacter.state != 2 && this.targetCharacter.state != 7) {
                n = GameImpl.collideBulletWithCover(this.targetCharacter.posX >> 8, this.targetCharacter.posY >> 8, this.posX >> 8, this.posY >> 8, true) ? 1 : 0;
            }
            if (n == 0 && !GameImpl.collideBullet(this.posX >> 8, this.posY >> 8, this.targetCharacter.posX >> 8, this.targetCharacter.posY >> 8)) {
                int n4 = this.targetCharacter.life;
                this.targetCharacter.getShot(this.getEnemyClass().bData[7], this.posX, this.posY);
                if (this.targetCharacter.life != n4) {
                    XSprite xSprite = GameImpl.sprites[this.targetCharacter.turretAnimator._sprite];
                    short s = xSprite._aframes_id[xSprite._animations_af_offset[this.targetCharacter.turretAnimator._crt_anim]];
                    short s2 = xSprite._fmodules_oy[xSprite._frames_fm_offset[s] + 1];
                    GameImpl.spawnTempAnimation(this.targetCharacter.posX, this.targetCharacter.posY + (s2 << 8), 8, 16);
                }
            }
        }
        n = GameImpl.getCollisionPosition(this.posX >> 8, this.posY >> 8, this.targetCharacter.posX >> 8, this.targetCharacter.posY >> 8, 0);
        if (n != -1) {
            n2 = Map.collision_tile_h * (n & 0xFF) << 8;
            n3 = Map.collision_tile_w * (n >> 16) << 8;
        }
        Debug.stopTimer(2);
    }

    public void setBaseAnimation() {
        switch (this.state) {
            case 10: {
                this.baseAnimator.SetCrtAnim(Character.A_BASE_AIM[this.orientation]);
                break;
            }
            case 0: 
            case 18: {
                if (!this.isCovered) {
                    this.baseAnimator.SetCrtAnim(Character.A_BASE_STAND[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(Character.A_BASE_COVER_STAND[this.orientation]);
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                if (!this.isCovered) {
                    this.baseAnimator.SetCrtAnim(Character.A_BASE_AIM[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(Character.A_BASE_COVER_AIM[this.orientation]);
                break;
            }
            case 15: {
                this.baseAnimator.SetCrtAnim(Character.A_BASE_COVER_AIM[this.orientation]);
                break;
            }
            case 16: {
                this.baseAnimator.SetCrtAnim(Character.A_BASE_COVER_STAND[this.orientation]);
                break;
            }
            case 14: {
                this.baseAnimator.SetCrtAnim(A_ENEMY_RIFLE_BURST[this.orientation]);
                break;
            }
            case 4: {
                switch (this.substate) {
                    case 0: {
                        this.baseAnimator.SetCrtAnim(A_ENEMY_NOTICE[this.orientation]);
                        break;
                    }
                    case 1: {
                        if (this.isJumping) {
                            this.baseAnimator.SetCrtAnim(Character.A_JUMP_OVER_COVER[this.orientation]);
                            break;
                        }
                        this.baseAnimator.SetCrtAnim(Character.A_BASE_RUN[this.orientation]);
                        break;
                    }
                    case 2: {
                        this.baseAnimator.SetCrtAnim(A_ENEMY_ALERT[this.orientation]);
                    }
                }
                break;
            }
            case 7: {
                if (this.isJumping) {
                    this.baseAnimator.SetCrtAnim(Character.A_JUMP_OVER_COVER[this.orientation]);
                    break;
                }
                if (this.timer < 0) {
                    this.baseAnimator.SetCrtAnim(Character.A_BASE_STAND[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(Character.A_BASE_RUN[this.orientation]);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                if (this.isJumping) {
                    this.baseAnimator.SetCrtAnim(Character.A_JUMP_OVER_COVER[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(Character.A_BASE_RUN[this.orientation]);
                break;
            }
            case 12: {
                if (!this.isCovered) {
                    this.baseAnimator.SetCrtAnim(Character.A_BASE_AIM[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(Character.A_BASE_COVER_AIM[this.orientation]);
            }
        }
        this.updateTurretAnimation();
    }

    public boolean updatePath() {
        if (this.isJumping) {
            this.doJump();
            return false;
        }
        if (this.pathIndex >= this.pathLength - 1) {
            this.pathIndex = 0;
            this.pathLength = 0;
            return true;
        }
        if (Map.getCollision(this.pathY[this.pathIndex + 1] * Map._coll_map_tw + this.pathX[this.pathIndex + 1]) == 1) {
            for (int i = this.pathIndex + 2; i < this.pathLength; ++i) {
                if (Map.getCollision(this.pathY[i] * Map._coll_map_tw + this.pathX[i]) != 15) continue;
                this.jumpLandingX = this.pathX[i] * Map.collision_tile_h << 8;
                this.jumpLandingY = this.pathY[i] * Map.collision_tile_w << 8;
                this.jumpPathIndex = i;
                this.isJumping = true;
                this.setOrientation(this.getMovementOrientation());
                this.setBaseAnimation();
                this.doJump();
                if (GameImpl.player != null && GameImpl.player.target != null && GameImpl.player.target.enemyTarget == this) {
                    GameImpl.player.target.refreshLimits();
                }
                return false;
            }
            this.isJumping = false;
            return true;
        }
        if (this.isStealthKillTarget()) {
            return false;
        }
        int n = this.pathX[this.pathIndex + 1] - this.pathX[this.pathIndex];
        int n2 = this.pathY[this.pathIndex + 1] - this.pathY[this.pathIndex];
        this.setOrientation(this.getMovementOrientation());
        byte by = this.getEnemyClass().bData[9];
        if (n * n2 != 0) {
            this.posX += n * by * 179;
            this.posY += n2 * by * 179;
        } else {
            this.posX += n * by << 8;
            this.posY += n2 * by << 8;
        }
        if (n > 0 && this.posX >> 8 > this.pathX[this.pathIndex + 1] * Map.collision_tile_h) {
            ++this.pathIndex;
        } else if (n < 0 && this.posX >> 8 < this.pathX[this.pathIndex + 1] * Map.collision_tile_h) {
            ++this.pathIndex;
        } else if (n2 > 0 && this.posY >> 8 > this.pathY[this.pathIndex + 1] * Map.collision_tile_w) {
            ++this.pathIndex;
        } else if (n2 < 0 && this.posY >> 8 < this.pathY[this.pathIndex + 1] * Map.collision_tile_w) {
            ++this.pathIndex;
        }
        this.setCoverState(GameImpl.canCover(this.posX >> 8, this.posY >> 8, this.orientation, this.isCovered));
        return false;
    }

    private void doJump() {
        if (this.baseAnimator.IsCrtAnimEnded()) {
            this.setCoverState(false);
            if (this.isDyingAfterJump) {
                this.setState(1);
            } else {
                this.posX = this.jumpLandingX;
                this.posY = this.jumpLandingY;
                this.pathIndex = this.jumpPathIndex;
                this.isJumping = false;
                this.setBaseAnimation();
                if (GameImpl.player != null && GameImpl.player.target != null && GameImpl.player.target.enemyTarget == this) {
                    GameImpl.player.target.refreshLimits();
                }
            }
        } else if (this.baseAnimator._crt_aframe > 3) {
            int n = this.baseAnimator.GetCrtAnimLength() - this.baseAnimator._crt_aframe - 1;
            if (n > 0) {
                this.posX += (this.jumpLandingX - this.posX) / n;
                this.posY += (this.jumpLandingY - this.posY) / n;
            } else {
                this.posX = this.jumpLandingX;
                this.posY = this.jumpLandingY;
            }
        }
    }

    public void gotoXY(int n, int n2) {
        int[] nArray = new int[]{15, 1};
        this.pathLength = PathFinder.FindPathOn((this.posX >> 8) / Map.collision_tile_h, (this.posY >> 8) / Map.collision_tile_w, n / Map.collision_tile_h, n2 / Map.collision_tile_w, this.pathX, this.pathY, nArray);
        this.pathIndex = 0;
    }

    public void goToArea(int n, int n2) {
        int n3 = this.posX - n;
        int n4 = this.posY - n2;
        int n5 = Math.max(1, Utils.Distance(n3, n4));
        int n6 = Utils.random(-3, 3);
        this.destX = n + n4 * (this.getEnemyClass().sData[3] << 8) * n6 / (3 * n5);
        this.destY = n2 + n3 * (this.getEnemyClass().sData[3] << 8) * n6 / (3 * n5);
        this.gotoXY(this.destX >> 8, this.destY >> 8);
    }

    public void setState(int n) {
        if (this.state == n || this.state == 1) {
            return;
        }
        this.timer = 0;
        this.updateSign();
        this.isJumping = false;
        this.baseAnimator._flags &= 0xFFFFF7FF;
        switch (this.state) {
            case 2: {
                break;
            }
            case 17: {
                this.setOrientation(this.initialOrientation);
            }
        }
        switch (n) {
            case 0: {
                if ((this.flags & 2) == 0) break;
                n = 7;
                break;
            }
            case 12: {
                break;
            }
            case 2: {
                if (GameImpl.gameMode == 2) {
                    n = 0;
                    break;
                }
                this.isShooting = false;
                this.shoot();
                break;
            }
            case 13: {
                this.targetAnimator.SetCrtAnim(1);
                break;
            }
            case 5: 
            case 8: {
                if (this.returnX == -1) {
                    this.returnX = this.posX;
                    this.returnY = this.posY;
                }
                this.isAssisting = true;
                this.goToArea(this.destX, this.destY);
                break;
            }
            case 4: {
                this.signAnimator.SetCrtAnim(335);
                if (this.returnX == -1) {
                    this.returnX = this.posX;
                    this.returnY = this.posY;
                }
                this.substate = 0;
                break;
            }
            case 7: {
                if (this.waypoints == null) break;
                this.gotoXY(this.waypoints[0], this.waypoints[1]);
                break;
            }
            case 6: {
                if (this.returnX != -1) {
                    this.gotoXY(this.returnX >> 8, this.returnY >> 8);
                    break;
                }
                n = 0;
                break;
            }
            case 11: {
                this.gotoXY(this.destX >> 8, this.destY >> 8);
                break;
            }
            case 15: 
            case 16: {
                if (GameImpl.player != null && GameImpl.player.target != null && GameImpl.player.target.enemyTarget == this) {
                    GameImpl.player.target.refreshLimits();
                }
            }
            case 9: {
                this.timer = 0;
                break;
            }
            case 10: {
                this.machinegun.activateMachinegun();
                break;
            }
            case 1: {
                this.baseAnimator._flags |= 0x800;
                if (Character.bigExpl || this.targetCharacter.target.mode == 1) {
                    Character.bigExpl = false;
                    this.baseAnimator.SetCrtAnim(Character.A_DELTA_ANIM_DIE_EXPLOSION[this.orientation]);
                } else if (this.targetCharacter.isBurst) {
                    this.baseAnimator.SetCrtAnim(A_ENEMY_DIE_RIFLE_BURST[this.orientation]);
                } else {
                    this.baseAnimator.SetCrtAnim(Character.A_DELTA_ANIM_DIE_RIFLE[this.orientation]);
                }
                this.substate = 0;
                if (this.sData[0] == -1) break;
                GameImpl.vm.spawnInstanceByID(this.sData[0], -1);
                break;
            }
            case 14: {
                this.shakerCoolDown = 10;
            }
        }
        if (this.state != 19) {
            this.state = n;
            this.setBaseAnimation();
        } else {
            this.state = 1;
            this.substate = 3;
        }
        if (this.state == 1 && this.substate != 3) {
            GameImpl.updateObjectives(1);
        }
    }

    public void setOrientation(int n) {
        if (this.orientation == n) {
            return;
        }
        this.orientation = n;
        this.setBaseAnimation();
    }

    public Entity getEnemyClass() {
        return GameImpl.enemyClasses[this.classId];
    }

    public void takeDamage(int n, int n2, int n3) {
        int n4 = this.life;
        if (!this.isJumping) {
            this.setOrientation(GameImpl.getOrientation(n2 - this.posX, n3 - this.posY));
        }
        this.life -= n;
        if (this.life <= 0) {
            if (GameImpl.gameMode == 1 && n4 == this.maxLife) {
                GameImpl.activateAssist(this.posX >> 8, this.posY >> 8, this.targetCharacter.posX >> 8, this.targetCharacter.posY >> 8, this.getEnemyClass().sData[6] >> 1);
            }
            if (this.isJumping) {
                this.isDyingAfterJump = true;
            } else {
                this.setState(1);
            }
            return;
        }
        if (n4 == this.maxLife && this.targetCharacter != null && GameImpl.gameMode == 1) {
            GameImpl.activateAssist(this.posX >> 8, this.posY >> 8, this.targetCharacter.posX >> 8, this.targetCharacter.posY >> 8, this.getEnemyClass().sData[6]);
        }
        this.isAssisting = true;
        this.rollForCover = true;
        if (n > 0 && !this.isJumping && this.shakerCoolDown <= 0) {
            this.setState(14);
        }
        if (this.targetCharacter != null && !this.targetCharacter.isBurst && this.isAlertingEnemy()) {
            this.setState(4);
        }
    }

    public boolean isOnScreen() {
        int n = (this.posX >> 8) - Camera.posX;
        int n2 = (this.posY >> 8) - Camera.posY;
        if (GameImpl.gameMode == 1 || GameImpl.gameMode == 3) {
            return n >= 0 && n <= 320 && n2 >= 0 && n2 <= 240;
        }
        return n >= 0 && n <= 640 && n2 >= 0 && n2 <= 480;
    }

    public void setCoverState(boolean bl) {
        if (this.isCovered != bl) {
            this.isCovered = bl;
            this.speed = this.isCovered ? this.speed >> 1 : this.speed << 1;
            this.setBaseAnimation();
            if (GameImpl.player != null && GameImpl.player.target != null && GameImpl.player.target.enemyTarget == this) {
                GameImpl.player.target.refreshLimits();
            }
        }
    }

    public void setLastSeenCharacter(int n) {
        if (this.targetCharacter == this.lastSeenCharacter && n == 0) {
            this.lastSeenCharacter = null;
        } else if (this.targetCharacter != this.lastSeenCharacter && (n == 3 || n == 2)) {
            this.lastSeenCharacter = this.targetCharacter;
        }
    }

    public boolean isEntityInSight(int n, int n2, int n3) {
        int n4;
        if (n3 > this.getEnemyClass().sData[4]) {
            return false;
        }
        int n5 = GameImpl.getExtendedOrientation(n - this.posX, n2 - this.posY);
        return Math.abs(n5 - (n4 = this.orientation << 1)) <= 2;
    }

    public boolean isStealthKillTarget() {
        return GameImpl.player != null && GameImpl.player.state == 2 && GameImpl.player.canStealthKill && GameImpl.player.target.enemyTarget == this;
    }

    public int getFOV() {
        if (GameImpl.gameMode == 2 || this.targetCharacter == null || this.targetCharacter.state == 6 || this.targetCharacter.state == 13 || this.targetCharacter.state == 15 || !this.isOnScreen() && this.targetCharacter != this.lastSeenCharacter) {
            this.setLastSeenCharacter(0);
            return 0;
        }
        int n = Utils.Distance(this.posX - this.targetCharacter.posX >> 8, this.posY - this.targetCharacter.posY >> 8);
        if (n > this.getEnemyClass().sData[5]) {
            this.setLastSeenCharacter(0);
            return 0;
        }
        if (n >= 50 && !this.isEntityInSight(this.targetCharacter.posX, this.targetCharacter.posY, n) && this.targetCharacter != this.lastSeenCharacter) {
            this.hearTimer = 30;
            this.setLastSeenCharacter(0);
            this.updateSign();
            return 0;
        }
        if (this.isStealthKillTarget()) {
            this.hearTimer = 30;
            this.setLastSeenCharacter(0);
            this.updateSign();
            return 0;
        }
        if (!this.isEntityInSight(this.targetCharacter.posX, this.targetCharacter.posY, n) && this.hearTimer > 0) {
            --this.hearTimer;
            this.setLastSeenCharacter(0);
            this.updateSign();
            return 0;
        }
        boolean bl = GameImpl.isVisible(this.posX >> 8, this.posY >> 8, this.targetCharacter.posX >> 8, this.targetCharacter.posY >> 8);
        boolean bl2 = bl && this.targetCharacter.isCovered && this.targetCharacter.state != 2 && GameImpl.collideBulletWithCover(this.targetCharacter.posX >> 8, this.targetCharacter.posY >> 8, this.posX >> 8, this.posY >> 8, false) && this.targetCharacter != this.lastSeenCharacter;
        boolean bl3 = bl = bl && !bl2;
        if (n <= this.getEnemyClass().sData[3] && bl) {
            this.setLastSeenCharacter(3);
            return 3;
        }
        if (n <= this.getEnemyClass().sData[4] && (bl || this.state == 5 && this.targetCharacter == this.lastSeenCharacter)) {
            this.setLastSeenCharacter(2);
            return 2;
        }
        if (n <= this.getEnemyClass().sData[5] && bl) {
            this.setLastSeenCharacter(1);
            return 1;
        }
        this.setLastSeenCharacter(0);
        return 0;
    }

    public void goAssist(int n, int n2) {
        if (this.state == 0 || this.state == 7 || this.state == 9) {
            this.destX = n << 8;
            this.destY = n2 << 8;
            this.setState(8);
        }
    }

    public void returnTo(int n, int n2) {
        this.returnX = n << 8;
        this.returnY = n2 << 8;
        this.setState(6);
    }

    public void runFrom(int n, int n2) {
        if (Utils.random(100) > this.bData[3]) {
            if (this.returnX == -1) {
                this.returnX = this.posX;
                this.returnY = this.posY;
            }
            if (!this.findAndGoToCover(n, n2)) {
                int n3 = n << 8;
                int n4 = n2 << 8;
                int n5 = Utils.Distance(n3 - this.posX, n4 - this.posY) >> 8;
                int n6 = 50 - (this.bData[3] >> 2);
                if (n5 > 0 && this.coverNotTooClose(n3 = this.posX + (this.posX - n3) * n6 / n5, n4 = this.posY + (this.posY - n4) * n6 / n5)) {
                    this.destX = n3;
                    this.destY = n4;
                    this.setState(11);
                }
            }
        }
    }

    public void activateFadeIn(int n, int n2) {
        this.fadeIn = true;
        this.fadeInPositionX = n;
        this.fadeInPositionY = n2;
    }

    public void useMachinegun(Machinegun machinegun) {
        this.returnX = this.posX;
        this.returnY = this.posY;
        this.destX = machinegun.getGunnerPositionX();
        this.destY = machinegun.getGunnerPositionY();
        this.machinegun = machinegun;
        this.setState(11);
    }
}

