/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animator;
import com.ea.game.Camera;
import com.ea.game.Character;
import com.ea.game.Enemy;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.SpriteConstants;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;

public class AnimatedEntity
extends Entity
implements SpriteConstants {
    public Animator animator;
    public Animator fiveAnimator;

    public AnimatedEntity() {
    }

    public AnimatedEntity(int n) {
        super(n);
        this.animator = new Animator();
        this.fiveAnimator = null;
        switch (n) {
            case 103: {
                this.animator._sprite = 5;
                break;
            }
            case 11: {
                this.animator._sprite = 4;
                this.setState(0);
                this.fiveAnimator = new Animator();
                this.fiveAnimator._sprite = 7;
                this.fiveAnimator.SetCrtAnim(3);
                break;
            }
            case 13: {
                this.setState(0);
                break;
            }
            case 25: {
                this.animator._sprite = 4;
                break;
            }
            case 26: {
                this.animator._sprite = 7;
                this.animator.SetCrtAnim(1);
                this.setState(0);
                break;
            }
            case 27: {
                this.setState(0);
                this.fiveAnimator = new Animator();
                this.fiveAnimator._sprite = 7;
                this.fiveAnimator.SetCrtAnim(3);
            }
        }
    }

    public static boolean isAnimatedEntity(Entity entity) {
        return entity.type == 11 || entity.type == 13 || entity.type == 15;
    }

    public void load(SDKInputStream sDKInputStream) {
        try {
            switch (this.type) {
                case 11: {
                    this.posX = sDKInputStream.readShort() << 8;
                    this.posY = sDKInputStream.readShort() << 8;
                    this.bData[0] = (byte)sDKInputStream.read();
                    this.bData[1] = (byte)sDKInputStream.read();
                    this.bData[2] = (byte)sDKInputStream.read();
                    this.bData[3] = (byte)sDKInputStream.read();
                    this.bData[4] = (byte)sDKInputStream.read();
                    this.bData[5] = (byte)sDKInputStream.read();
                    this.bData[6] = (byte)sDKInputStream.read();
                    this.bData[7] = 0;
                    break;
                }
                case 13: {
                    this.id = sDKInputStream.read() & 0xFF;
                    this.posX = sDKInputStream.readShort() << 8;
                    this.posY = sDKInputStream.readShort() << 8;
                    this.bData[0] = (byte)sDKInputStream.read();
                    this.bData[1] = (byte)sDKInputStream.read();
                    this.bData[2] = (byte)sDKInputStream.read();
                    this.sData[2] = sDKInputStream.readShort();
                    break;
                }
                case 15: {
                    this.id = sDKInputStream.read() & 0xFF;
                    this.posX = sDKInputStream.readShort() << 8;
                    this.posY = sDKInputStream.readShort() << 8;
                    this.sData[0] = sDKInputStream.readShort();
                    break;
                }
                case 26: {
                    this.posX = sDKInputStream.readShort() << 8;
                    this.posY = sDKInputStream.readShort() << 8;
                    this.bData[0] = (byte)sDKInputStream.read();
                    this.bData[1] = (byte)sDKInputStream.read();
                    this.bData[2] = (byte)sDKInputStream.read();
                    this.bData[3] = (byte)sDKInputStream.read();
                    this.bData[4] = (byte)sDKInputStream.read();
                    this.bData[5] = (byte)sDKInputStream.read();
                    break;
                }
                case 27: {
                    this.id = sDKInputStream.readShort();
                    this.posX = sDKInputStream.readShort() << 8;
                    this.posY = sDKInputStream.readShort() << 8;
                    this.animator._sprite = sDKInputStream.read();
                    this.animator._crt_aframe = sDKInputStream.read();
                    this.bData[0] = (byte)sDKInputStream.read();
                    this.bData[1] = (byte)sDKInputStream.read();
                    this.bData[2] = (byte)sDKInputStream.read();
                    this.sData[0] = sDKInputStream.readShort();
                    this.sData[1] = sDKInputStream.readShort();
                    this.sData[2] = sDKInputStream.readShort();
                    this.sData[3] = sDKInputStream.readShort();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void drawGrenadeTrail(SDKGraphics sDKGraphics) {
        int n = this.iData[7];
        int n2 = this.iData[8];
        sDKGraphics.setColor(0xFF0000);
        for (int i = 1; i < this.bData[1]; ++i) {
            int n3 = this.iData[0] + this.iData[2] * i / this.bData[2];
            int n4 = this.iData[1] + this.iData[3] * i / this.bData[2] - (n += (n2 -= this.iData[6]));
            if (i % 2 == 0) continue;
            sDKGraphics.fillRect((n3 >> 8) - Camera.posX, (n4 >> 8) - Camera.posY, 2, 2);
        }
    }

    public void draw(SDKGraphics sDKGraphics) {
        int n = this.posX;
        int n2 = this.posY;
        switch (this.type) {
            case 103: {
                if (this.bData[1] <= 2) break;
                this.animator.DrawCrtFrame(sDKGraphics, this.posX >> 8, this.posY >> 8);
                this.animator.DrawFrame(sDKGraphics, 13, this.posX >> 8, this.posY + this.iData[4] >> 8);
                if (this.bData[4] != 1) break;
                this.drawGrenadeTrail(sDKGraphics);
                break;
            }
            case 11: {
                if (GameImpl.gameMode != 1) break;
                switch (this.state) {
                    case 1: {
                        this.animator.DrawCrtAnim(sDKGraphics, this.posX >> 8, this.posY >> 8);
                        if (this.animator._crt_aframe <= this.animator.GetCrtAnimLength() >> 1) break;
                        this.drawCrateContents(sDKGraphics);
                        break;
                    }
                    case 0: {
                        this.animator.DrawCrtFrame(sDKGraphics, this.posX >> 8, this.posY >> 8);
                        if (this.isPlayerInOpenCrateRange()) {
                            this.fiveAnimator.DrawCrtAnim(sDKGraphics, this.posX >> 8, this.posY >> 8);
                            break;
                        }
                        GameImpl.sprites[7].DrawFrame(19, (this.posX >> 8) - Camera.posX, (this.posY >> 8) - Camera.posY, 0);
                        break;
                    }
                    case 3: {
                        this.animator.DrawCrtFrame(sDKGraphics, this.posX >> 8, this.posY >> 8);
                        break;
                    }
                    case 2: {
                        this.animator.DrawCrtFrame(sDKGraphics, this.posX >> 8, this.posY >> 8);
                        this.drawCrateContents(sDKGraphics);
                    }
                }
                break;
            }
            case 13: {
                break;
            }
            case 104: {
                this.animator.DrawCrtAnim(sDKGraphics, this.posX >> 8, this.posY >> 8);
                break;
            }
            case 15: {
                if (this.sData[1] == 1) break;
                GameImpl.sprites[2].DrawFrame(this.sData[0], (this.posX >> 8) - Camera.posX, (this.posY >> 8) - Camera.posY, 0);
                break;
            }
            case 25: {
                if (GameImpl.gameMode != 1) break;
                switch (this.state) {
                    case 3: {
                        this.drawGrenade(sDKGraphics);
                        break;
                    }
                    case 6: {
                        this.drawHealth(sDKGraphics);
                        break;
                    }
                    case 1: {
                        this.drawAmmunition(sDKGraphics);
                        break;
                    }
                    case 2: {
                        this.drawAmmunition(sDKGraphics);
                        break;
                    }
                    case 0: {
                        this.drawAmmunition(sDKGraphics);
                    }
                }
                break;
            }
            case 26: {
                if (GameImpl.gameMode != 1) break;
                switch (this.state) {
                    case 0: {
                        GameImpl.sprites[this.bData[0]].DrawFrame(this.bData[1], (this.posX >> 8) - Camera.posX, (this.posY >> 8) - Camera.posY, 0);
                        break;
                    }
                    case 1: {
                        GameImpl.sprites[this.bData[2]].DrawFrame(this.bData[3], (this.posX >> 8) - Camera.posX, (this.posY >> 8) - Camera.posY, 0);
                    }
                }
                GameImpl.sprites[this.bData[0]].RectFrame(this.bData[1], 0, 0, 0);
                int n3 = this.posX + (XSprite._rect[0] + (XSprite._rect[2] - XSprite._rect[0] >> 1) << 8);
                this.animator.DrawCrtAnim(sDKGraphics, n3 >> 8, this.posY >> 8);
                break;
            }
            case 27: {
                this.drawExplodable(sDKGraphics);
            }
        }
        this.posX = n;
        this.posY = n2;
    }

    public void drawExplodable(SDKGraphics sDKGraphics) {
        int n = this.posX >> 8;
        int n2 = this.posY >> 8;
        if (this.animator._crt_aframe != -1) {
            this.animator.DrawFrame(sDKGraphics, this.animator._crt_aframe, n, n2);
        }
        switch (this.state) {
            case 0: {
                if (GameImpl.gameMode != 1) break;
                if (this.isPlayerInActivateExplodableRange()) {
                    this.fiveAnimator.DrawCrtAnim(sDKGraphics, this.posX >> 8, this.posY >> 8);
                    break;
                }
                GameImpl.sprites[7].DrawFrame(19, n - Camera.posX, n2 - Camera.posY, 0);
                break;
            }
            case 1: {
                if (GameImpl.gameMode == 3) break;
                GameImpl.sprites[10].DrawFrame(22, n - Camera.posX + 3, n2 - Camera.posY + 3, 0);
                Object object = SDKUtils.getFont();
                SDKUtils.setFont(GameImpl.fonts[1]);
                GameImpl.convertTimeIntoString(this.bData[2] & 0xFF, GameImpl.stringBuffer);
                SDKUtils.drawString(GameImpl.stringBuffer, n - Camera.posX, n2 - Camera.posY, 0);
                SDKUtils.setFont(object);
            }
        }
    }

    private void drawCrateContents(SDKGraphics sDKGraphics) {
        Entity entity = null;
        block7: for (int i = 1; i <= 3; ++i) {
            entity = this.getCrateClass(i);
            if (entity == null) continue;
            switch (entity.bData[0]) {
                case 3: {
                    this.drawGrenade(sDKGraphics);
                    continue block7;
                }
                case 6: {
                    this.drawHealth(sDKGraphics);
                    continue block7;
                }
                case 1: {
                    this.drawPistol(sDKGraphics);
                    continue block7;
                }
                case 2: {
                    this.drawShotgun(sDKGraphics);
                    continue block7;
                }
                case 0: {
                    this.drawRifle(sDKGraphics);
                }
            }
        }
    }

    private void drawRifle(SDKGraphics sDKGraphics) {
        this.animator.DrawFrame(sDKGraphics, 5, (this.posX >> 8) + -15, (this.posY >> 8) + -5);
    }

    private void drawShotgun(SDKGraphics sDKGraphics) {
        this.animator.DrawFrame(sDKGraphics, 2, (this.posX >> 8) + 10, (this.posY >> 8) + 5);
    }

    private void drawPistol(SDKGraphics sDKGraphics) {
        this.animator.DrawFrame(sDKGraphics, 4, (this.posX >> 8) + 8, (this.posY >> 8) + -15);
    }

    private void drawHealth(SDKGraphics sDKGraphics) {
        this.animator.DrawFrame(sDKGraphics, 3, (this.posX >> 8) + -5, (this.posY >> 8) + -25);
    }

    private void drawAmmunition(SDKGraphics sDKGraphics) {
        this.animator.DrawFrame(sDKGraphics, 8, (this.posX >> 8) + -5, (this.posY >> 8) + -25);
    }

    private void drawGrenade(SDKGraphics sDKGraphics) {
        this.animator.DrawFrame(sDKGraphics, 6, (this.posX >> 8) + -10, (this.posY >> 8) + 10);
    }

    public void updateGrenade() {
        byte by = this.bData[3];
        this.bData[3] = (byte)(by - 1);
        if (by >= 0) {
            return;
        }
        if (this.bData[1] <= this.bData[2]) {
            this.iData[4] = this.iData[4] + this.iData[5];
            this.iData[5] = this.iData[5] - this.iData[6];
            this.posX = this.iData[0] + this.iData[2] * this.bData[1] / this.bData[2];
            this.posY = this.iData[1] + this.iData[3] * this.bData[1] / this.bData[2] - this.iData[4];
            this.bData[1] = (byte)(this.bData[1] + 1);
        } else {
            GameImpl.playSound(10);
            GameImpl.spawnBlastAnimation(this.posX, this.posY, 9, 0, GameImpl.getWeaponClassByType((int)3).bData[3], GameImpl.getWeaponClassByType((int)3).bData[1], this.bData[4] == 0 ? (byte)1 : 2);
            this.bData[4] = 2;
            GameImpl.scareEnemiesAround(this.posX >> 8, this.posY >> 8, 100);
            this.finished = true;
        }
    }

    public void updateCrate() {
        if (GameImpl.gameMode != 1) {
            return;
        }
        switch (this.state) {
            case 0: {
                if (!this.isPlayerInOpenCrateRange()) break;
                this.fiveAnimator.UpdateCrtAnim();
                if (!Character.playerIsNewKeyPressed(4112)) break;
                this.setState(1);
                GameImpl.player.startPickUp();
                break;
            }
            case 1: {
                this.animator.UpdateCrtAnim();
                if (!this.animator.IsCrtAnimEnded()) break;
                this.setState(2);
                break;
            }
            case 2: {
                this.bData[7] = (byte)(this.bData[7] + 1);
                if (this.bData[7] % 3 != 0) break;
                this.getItemFromCrate();
                if (!this.isCrateEmpty()) break;
                this.setState(3);
                GameImpl.player.endPickUp();
                GameImpl.shouldCheckAchievements = true;
                break;
            }
        }
    }

    public void updateBarrack() {
        if (this.state == 1) {
            if (this.bData[3] <= 0) {
                this.spawnEnemy();
                if (this.bData[0] <= 0) {
                    this.setState(2);
                } else {
                    this.bData[3] = this.bData[2];
                }
            } else {
                this.bData[3] = (byte)(this.bData[3] - 1);
            }
        }
    }

    public void update() {
        switch (this.type) {
            case 103: {
                this.updateGrenade();
                break;
            }
            case 11: {
                this.updateCrate();
                break;
            }
            case 13: {
                this.updateBarrack();
                break;
            }
            case 104: {
                if (this.animator.IsCrtAnimEnded()) {
                    this.finished = true;
                    break;
                }
                this.animator.UpdateCrtAnim();
                break;
            }
            case 25: {
                if (GameImpl.gameMode != 1 || Utils.Distance(GameImpl.player.posX - this.posX, GameImpl.player.posY - this.posY) >= 6400) break;
                block9 : switch (this.state) {
                    case 6: {
                        if (GameImpl.player.life == GameImpl.player.maxLife) break;
                        this.restoreHealth();
                        this.finished = true;
                        break;
                    }
                    case 0: {
                        for (int i = 0; i < GameImpl.player.numWeapons; ++i) {
                            if (GameImpl.player.weaponClass[i].bData[0] != 0) continue;
                            if (GameImpl.player.weaponAmmunition[i] >= 99) break block9;
                            this.addSupply(0, this.getWeaponClass((int)0).bData[4]);
                            this.finished = true;
                            break block9;
                        }
                        break;
                    }
                }
                break;
            }
            case 26: {
                if (GameImpl.gameMode != 1) break;
                this.animator.UpdateCrtAnim();
                break;
            }
            case 27: {
                if (this.state == 0 && this.isPlayerInActivateExplodableRange()) {
                    this.fiveAnimator.UpdateCrtAnim();
                }
                if (this.state != 1) break;
                long l = System.currentTimeMillis();
                if ((int)(l & 0xFFFFFFFFFFFFFFFFL) - this.iData[0] > 1000) {
                    this.bData[2] = (byte)(this.bData[2] - 1);
                    this.iData[0] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                }
                if ((this.bData[2] & 0xFF) != 0) break;
                this.setState(2);
            }
        }
    }

    private void spawnEnemy() {
        this.bData[0] = (byte)(this.bData[0] - 1);
        Enemy enemy = new Enemy();
        enemy.sData[0] = this.sData[2];
        enemy.posX = this.posX;
        enemy.posY = this.posY;
        enemy.classId = 1;
        enemy.maxLife = enemy.life = enemy.getEnemyClass().sData[0];
        enemy.bData[0] = 50;
        enemy.initialOrientation = Utils.random(8);
        enemy.turretAnimator._sprite = enemy.baseAnimator._sprite = enemy.getEnemyClass().bData[6];
        enemy.setModuleMapping(Utils.random(2) == 0 ? 10 : 11);
        enemy.flags = (byte)(enemy.flags | 1);
        enemy.setState(0);
        enemy.activateFadeIn(this.posX >> 8, this.posY >> 8);
        enemy.returnX = this.posX + Utils.random(-enemy.getEnemyClass().sData[3], enemy.getEnemyClass().sData[3] << 8);
        enemy.returnY = this.posY + Utils.random(-enemy.getEnemyClass().sData[3], enemy.getEnemyClass().sData[3] << 8);
        GameImpl.addEnemy(enemy);
        GameImpl.constructVisibleEnemies();
        enemy.goAssist(this.sData[0], this.sData[1]);
    }

    private void getItemFromCrate() {
        Entity entity = null;
        for (int i = 1; i <= 3; ++i) {
            entity = this.getCrateClass(i);
            if (entity == null) continue;
            switch (entity.bData[0]) {
                case 3: {
                    this.addSupply(3, this.getAmmoForCrate(i));
                    this.emptyCrateSlot(i);
                    return;
                }
                case 6: {
                    this.restoreHealth();
                    this.emptyCrateSlot(i);
                    return;
                }
                case 1: {
                    this.addSupply(1, this.getAmmoForCrate(i));
                    this.emptyCrateSlot(i);
                    return;
                }
                case 2: {
                    this.addSupply(2, this.getAmmoForCrate(i));
                    this.emptyCrateSlot(i);
                    return;
                }
                case 0: {
                    this.addSupply(0, this.getAmmoForCrate(i));
                    this.emptyCrateSlot(i);
                    return;
                }
            }
            this.emptyCrateSlot(i);
        }
    }

    private boolean isCrateEmpty() {
        for (int i = 1; i <= 3; ++i) {
            if (this.getCrateClass(i) == null) continue;
            return false;
        }
        return true;
    }

    private void restoreHealth() {
        GameImpl.player.lifeTimer = 30;
        GameImpl.player.life = GameImpl.player.maxLife;
    }

    private void addSupply(int n, int n2) {
        GameImpl.hudModel[4] = (short)(GameImpl.hudModel[4] | 0x40);
        GameImpl.hudModel[5] = (short)(GameImpl.hudModel[5] + 28);
        for (int i = 0; i < GameImpl.player.numWeapons; ++i) {
            if (GameImpl.player.weaponClass[i].bData[0] != n) continue;
            int n3 = i;
            GameImpl.player.weaponAmmunition[n3] = (short)(GameImpl.player.weaponAmmunition[n3] + n2);
            if (n == 3) {
                GameImpl.player.weaponMagazine[i] = (byte)GameImpl.player.weaponAmmunition[i];
            }
            if (n == 0 && GameImpl.player.weaponAmmunition[i] > 99) {
                GameImpl.player.weaponAmmunition[i] = 99;
            }
            return;
        }
        if (GameImpl.player.numWeapons == 1) {
            GameImpl.hudModel[4] = (short)(GameImpl.hudModel[4] | 1);
        }
        GameImpl.player.weaponClass[GameImpl.player.numWeapons] = this.getWeaponClass(n);
        GameImpl.player.weaponAmmunition[GameImpl.player.numWeapons] = (short)n2;
        GameImpl.player.weaponMagazine[GameImpl.player.numWeapons] = (byte)Math.min(n2, this.getWeaponClass((int)n).bData[4]);
        ++GameImpl.player.numWeapons;
        GameImpl.hudModel[4] = (short)(GameImpl.hudModel[4] | GameImpl.WEAPON_TYPE_HUD_MAPPING[n]);
    }

    private Entity getWeaponClass(int n) {
        for (int i = 0; i < GameImpl.numWeponClasses; ++i) {
            if (GameImpl.weaponClasses[i].bData[0] != n) continue;
            return GameImpl.weaponClasses[i];
        }
        return GameImpl.weaponClasses[0];
    }

    private int getAmmoForCrate(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = this.bData[2];
                break;
            }
            case 2: {
                n2 = this.bData[4];
                break;
            }
            case 3: {
                n2 = this.bData[6];
            }
        }
        return n2;
    }

    public Entity getCrateClass(int n) {
        byte by = -1;
        switch (n) {
            case 1: {
                by = this.bData[1];
                break;
            }
            case 2: {
                by = this.bData[3];
                break;
            }
            case 3: {
                by = this.bData[5];
            }
        }
        if (by == -1) {
            return null;
        }
        for (int i = 0; i < GameImpl.numCrateClasses; ++i) {
            if (GameImpl.crateClasses[i].bData[0] != by) continue;
            return GameImpl.crateClasses[i];
        }
        return null;
    }

    public void emptyCrateSlot(int n) {
        switch (n) {
            case 1: {
                this.bData[1] = -1;
                break;
            }
            case 2: {
                this.bData[3] = -1;
                break;
            }
            case 3: {
                this.bData[5] = -1;
            }
        }
    }

    public void setState(int n) {
        if (this.state == n) {
            return;
        }
        switch (this.type) {
            case 11: {
                switch (n) {
                    case 1: {
                        this.animator.SetCrtAnim(0);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.bData[7] = 0;
                        this.animator.SetCrtFrame(1);
                        break;
                    }
                    case 0: {
                        this.animator.SetCrtFrame(0);
                    }
                }
                break;
            }
            case 13: {
                switch (n) {
                    case 1: {
                        this.bData[3] = this.bData[1];
                    }
                }
                break;
            }
            case 26: {
                switch (n) {
                    case 1: {
                        this.animator.SetCrtAnim(2);
                        break;
                    }
                    case 0: {
                        this.animator.SetCrtAnim(1);
                    }
                }
                break;
            }
            case 27: {
                if (n == 1) {
                    long l = System.currentTimeMillis();
                    this.iData[0] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                    if (this.sData[2] != -1) {
                        GameImpl.vm.spawnInstanceByID(this.sData[2], -1);
                    }
                    if (this.sData[0] != -1) {
                        GameImpl.objectiveSetState(this.sData[0], 2);
                    }
                    if (!GameImpl.raceLevel || GameImpl.raceTime != -1) break;
                    GameImpl.raceTime = this.bData[2] & 0xFF;
                    GameImpl.raceLastUpdateTime = l;
                    if (GameImpl.raceStartMessage == -1) break;
                    GameImpl.showMessage(-1, GameImpl.raceStartMessage, 10);
                    break;
                }
                if (n != 2) break;
                this.animator._crt_aframe = this.bData[0];
                GameImpl.spawnBlastAnimation(this.posX, this.posY, 9, 1, 106, 100, (byte)0);
                if (this.sData[3] != -1) {
                    GameImpl.vm.spawnInstanceByID(this.sData[3], -1);
                }
                if (this.sData[1] != -1) {
                    GameImpl.objectiveSetState(this.sData[1], 2);
                }
                GameImpl.scareEnemiesAround(this.posX >> 8 >> 8, this.posY, 100);
            }
        }
        this.state = n;
        if (this.type == 27) {
            GameImpl.updateObjectives(3);
        }
    }

    public void cancelBrowsing() {
        this.setState(0);
    }

    public void activateBarrack(int n, int n2) {
        this.sData[0] = (short)n;
        this.sData[1] = (short)n2;
        this.setState(1);
    }

    public boolean isActive() {
        if (this.type == 103) {
            return this.bData[4] != 2;
        }
        return false;
    }

    public boolean isPlayerInActivateExplodableRange() {
        return this.type == 27 && this.state == 0 && Utils.Distance(this.posX - GameImpl.player.posX, this.posY - GameImpl.player.posY) <= this.bData[1] << 8;
    }

    public boolean isPlayerInOpenCrateRange() {
        return this.type == 11 && this.state == 0 && Utils.Distance(this.posX - GameImpl.player.posX, this.posY - GameImpl.player.posY) <= this.bData[0] << 8;
    }
}

