/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gui;

import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gfx.ImageSet;
import javax.microedition.lcdui.Graphics;

public class BitmapFont {
    private String sCharacters;
    public ImageSequence imgCharacters;
    private short[] mapAsciiToImage;
    private short iMaxAscii = 0;
    private short iMinAscii = (short)255;
    private int iFontHeight = 0;
    public boolean uppercaseOnly;
    public int iSpacing = 1;
    public int iSpaceWidth = 4;
    public int iMaxLetterWidth = 0;
    public int iOffsetTop = 0;
    public int iOffsetBottom = 0;
    public int iOffsetLeft = 0;
    public int iOffsetRight = 0;
    public String fontName;
    private static boolean characterRemapped = false;
    private static int[] rect = new int[4];

    public static String slgToUpperCase(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean isUpper = true;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            isUpper = false;
            break;
        }
        if (isUpper) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length() + 6);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            char code = c;
            if (code == '\u00df') {
                buf.append("SS");
                continue;
            }
            buf.append(Character.toUpperCase(c));
        }
        return buf.toString();
    }

    public BitmapFont(ImageSet imageSet, String _fontName) {
        int i;
        if (imageSet == null) {
            System.out.println("\n\n*******************************************************\nImageset is null when loading font " + this.fontName + "!" + "\n*******************************************************\n\n");
            return;
        }
        if (ImageSet.sCharacters == null) {
            System.out.println("Assertion Failure: imageSet.sCharacters != null\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui/BitmapFont.java[91]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.sCharacters = ImageSet.sCharacters;
        ImageSet.sCharacters = null;
        this.fontName = _fontName;
        this.imgCharacters = imageSet.getImageSequence(this.fontName);
        if (this.imgCharacters == null) {
            System.out.println("\n\n*******************************************************\nFailed to open imagesequence " + this.fontName + " to load font!" + "\n*******************************************************\n\n");
            return;
        }
        System.out.println("Loading BitmapFont: " + this.fontName);
        for (i = 0; i < this.imgCharacters.numFrames; i = (int)((short)(i + 1))) {
            this.iMaxLetterWidth = this.imgCharacters.getRectWidth(i) > this.iMaxLetterWidth ? (int)this.imgCharacters.getRectWidth(i) : this.iMaxLetterWidth;
        }
        System.out.println("Extracted Characters: " + this.sCharacters);
        for (i = 0; i < this.sCharacters.length(); i = (int)((short)(i + 1))) {
            if (this.sCharacters.charAt(i) > this.iMaxAscii) {
                this.iMaxAscii = (short)this.sCharacters.charAt(i);
            }
            if (this.sCharacters.charAt(i) >= this.iMinAscii) continue;
            this.iMinAscii = (short)this.sCharacters.charAt(i);
        }
        this.mapAsciiToImage = new short[this.iMaxAscii - this.iMinAscii + 1];
        for (i = 0; i < this.iMaxAscii - this.iMinAscii + 1; i = (int)((short)(i + 1))) {
            this.mapAsciiToImage[i] = -1;
        }
        this.uppercaseOnly = true;
        for (i = 0; i < this.sCharacters.length(); i = (int)((short)(i + 1))) {
            this.mapAsciiToImage[(short)this.sCharacters.charAt((int)i) - this.iMinAscii] = i;
            this.iFontHeight = this.imgCharacters.getRectHeight(i) > this.iFontHeight ? (int)this.imgCharacters.getRectHeight(i) : this.iFontHeight;
            char ch = this.sCharacters.charAt(i);
            if (!this.uppercaseOnly || ch < 'a' || ch > 'z') continue;
            System.out.println("Font considered not uppercase only because of: " + this.sCharacters.charAt(i) + " index: " + i);
            this.uppercaseOnly = false;
        }
    }

    public BitmapFont(BitmapFont source) {
        this.sCharacters = source.sCharacters;
        this.imgCharacters = source.imgCharacters;
        this.iMaxLetterWidth = source.iMaxLetterWidth;
        this.iMaxAscii = source.iMaxAscii;
        this.iMinAscii = source.iMinAscii;
        this.mapAsciiToImage = source.mapAsciiToImage;
        this.iFontHeight = source.iFontHeight;
        this.fontName = source.fontName;
        this.uppercaseOnly = source.uppercaseOnly;
        this.iOffsetTop = source.iOffsetTop;
        this.iOffsetBottom = source.iOffsetBottom;
        this.iOffsetLeft = source.iOffsetLeft;
        this.iOffsetRight = source.iOffsetRight;
    }

    public final short getFontHeight() {
        return (short)(this.iFontHeight + this.iOffsetTop + this.iOffsetBottom);
    }

    public final short getCharacterIndexInternal(char character) {
        int idx = (short)character - this.iMinAscii;
        if (idx >= 0 && idx <= this.iMaxAscii - this.iMinAscii) {
            return this.mapAsciiToImage[idx];
        }
        return -1;
    }

    public final short getCharacterIndex(char character) {
        int idx = (short)character - this.iMinAscii;
        short rtn_idx = this.getCharacterIndexInternal(character);
        return rtn_idx;
    }

    public short getTextWidth(String text) {
        if (this.uppercaseOnly) {
            text = BitmapFont.slgToUpperCase(text);
        }
        int width = 0;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr == ' ' || chr == '\u00a0') {
                width += this.iSpaceWidth;
            } else {
                short idx = this.getCharacterIndex(chr);
                if (idx != -1) {
                    width += this.imgCharacters.getRectWidth(idx) + this.iOffsetLeft + this.iOffsetRight;
                }
            }
            if (i >= length - 1) continue;
            width += this.iSpacing;
        }
        return (short)width;
    }

    public short getFixedWidth(String text) {
        if (this.uppercaseOnly) {
            text = BitmapFont.slgToUpperCase(text);
        }
        short fixedwidth = 0;
        for (int i = 0; i < text.length(); ++i) {
            short idx = this.getCharacterIndex(text.charAt(i));
            if (idx == -1) continue;
            short charwidth = this.imgCharacters.getRectWidth(idx);
            fixedwidth = fixedwidth > charwidth ? fixedwidth : charwidth;
        }
        return fixedwidth;
    }

    public short getTextWidth(String text, int fixedwidth) {
        if (this.uppercaseOnly) {
            text = BitmapFont.slgToUpperCase(text);
        }
        if (fixedwidth == 0) {
            return this.getTextWidth(text);
        }
        return (short)(fixedwidth * text.length() + this.iSpacing * (text.length() - 1));
    }

    public void drawText(Graphics g, String text, int x0, int y0, ClipRect cliprect) {
        if (this.uppercaseOnly) {
            text = BitmapFont.slgToUpperCase(text);
        }
        BitmapFont.rect[0] = cliprect.x0;
        BitmapFont.rect[1] = cliprect.y0;
        BitmapFont.rect[2] = cliprect.w;
        BitmapFont.rect[3] = cliprect.h;
        int length = text.length();
        int x = x0;
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr == ' ' || chr == '\u00a0') {
                x += this.iSpaceWidth;
            } else {
                short idx = this.getCharacterIndex(chr);
                if (idx != -1) {
                    this.imgCharacters.drawImageClipped(g, idx, x + this.iOffsetLeft, y0 + this.iOffsetTop, rect);
                    x += this.imgCharacters.getRectWidth(idx) + this.iOffsetLeft + this.iOffsetRight;
                }
            }
            x += this.iSpacing;
        }
    }

    public void drawText(Graphics g, String text, int x0, int y0, ClipRect cliprect, int fixedwidth) {
        if (this.uppercaseOnly) {
            text = BitmapFont.slgToUpperCase(text);
        }
        if (fixedwidth == 0) {
            this.drawText(g, text, x0, y0, cliprect);
            return;
        }
        BitmapFont.rect[0] = cliprect.x0;
        BitmapFont.rect[1] = cliprect.y0;
        BitmapFont.rect[2] = cliprect.w;
        BitmapFont.rect[3] = cliprect.h;
        int length = text.length();
        int x = x0;
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr == ' ' || chr == '\u00a0') {
                x += fixedwidth;
            } else {
                int idx = chr == '@' ? 70 : (int)this.getCharacterIndex(chr);
                if (idx != -1) {
                    int iCentre = fixedwidth > this.imgCharacters.getRectWidth(idx) ? fixedwidth - this.imgCharacters.getRectWidth(idx) >> 1 : 0;
                    this.imgCharacters.drawImageClipped(g, idx, x + this.iOffsetLeft + iCentre, y0 + this.iOffsetTop, rect);
                    x += fixedwidth + this.iOffsetLeft + this.iOffsetRight;
                }
            }
            x += this.iSpacing;
        }
    }
}

