/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gfx;

import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.sys.FixedPoint;
import javax.microedition.lcdui.Graphics;

public class GfxUtils {
    private static int colour = -1;

    public static final void drawCircle(Graphics g, int x, int y, int r, int points) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        int x0 = 0;
        int y0 = 0;
        int fp_r = r < 0 ? -(-r << 16) : r << 16;
        int fp_i_to_angle = (int)(0x10000000000L / (long)(points < 0 ? -(-points << 16) : points << 16));
        for (int i = 0; i <= points; ++i) {
            int fp_i = i < 0 ? -(-i << 16) : i << 16;
            int x1 = FixedPoint.sinLut(((fp_i ^ fp_i_to_angle) & 0x8000000) != 0 ? -((int)((long)(-fp_i) * (long)fp_i_to_angle >> 16)) : (int)((long)fp_i * (long)fp_i_to_angle >> 16));
            int y1 = FixedPoint.sinLut((((fp_i ^ fp_i_to_angle) & 0x8000000) != 0 ? -((int)((long)(-fp_i) * (long)fp_i_to_angle >> 16)) : (int)((long)fp_i * (long)fp_i_to_angle >> 16)) + 0x400000);
            x1 = ((x1 ^ fp_r) & 0x8000000) != 0 ? -((int)((long)(-x1) * (long)fp_r >> 16)) : (int)((long)x1 * (long)fp_r >> 16);
            x1 = x + (x1 < 0 ? -(-x1 >> 16) : x1 >> 16);
            y1 = ((y1 ^ fp_r) & 0x8000000) != 0 ? -((int)((long)(-y1) * (long)fp_r >> 16)) : (int)((long)y1 * (long)fp_r >> 16);
            y1 = y + (y1 < 0 ? -(-y1 >> 16) : y1 >> 16);
            if (i > 0) {
                g.drawLine(x0, y0, x1, y1);
            }
            x0 = x1;
            y0 = y1;
        }
    }

    public static final void drawPoint(Graphics g, int x, int y) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        g.drawLine(x - 1, y, x + 1, y);
        g.drawLine(x, y - 1, x, y + 1);
    }

    public static void setColor(Graphics g, int col) {
        colour = 0xFF000000 | col;
        g.setColor(colour);
    }

    public static void drawTriangle(Graphics g, int x0, int y0, int x1, int y1, int x2, int y2) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        g.drawLine(x0, y0, x1, y1);
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x0, y0, x2, y2);
    }

    public static final void drawCrossHatch(Graphics g, int col, int x0, int y0, int w, int h) {
        g.setClip(x0, y0, w, h);
        ImageSequence.clipSet = true;
        g.setColor(col);
        for (int x = 0; x < w; x += 2) {
            g.drawLine(x0 + x, y0, x0 + x + w, y0 + w);
        }
        for (int y = 0; y < h; y += 2) {
            g.drawLine(x0, y0 + y, x0 + h, y0 + y + h);
        }
    }

    public static final int lerpColour(int t, int rgb0, int rgb1) {
        int red = (rgb1 >> 16 & 0xFF) - (rgb0 >> 16 & 0xFF);
        int green = (rgb1 >> 8 & 0xFF) - (rgb0 >> 8 & 0xFF);
        int blue = (rgb1 & 0xFF) - (rgb0 & 0xFF);
        red = red < 0 ? -(-red << 16) : red << 16;
        red = ((red ^ t) & 0x8000000) != 0 ? -((int)((long)(-red) * (long)t >> 16)) : (int)((long)red * (long)t >> 16);
        red = (red < 0 ? -(-red >> 16) : red >> 16) + (rgb0 >> 16 & 0xFF);
        green = green < 0 ? -(-green << 16) : green << 16;
        green = ((green ^ t) & 0x8000000) != 0 ? -((int)((long)(-green) * (long)t >> 16)) : (int)((long)green * (long)t >> 16);
        green = (green < 0 ? -(-green >> 16) : green >> 16) + (rgb0 >> 8 & 0xFF);
        blue = blue < 0 ? -(-blue << 16) : blue << 16;
        blue = ((blue ^ t) & 0x8000000) != 0 ? -((int)((long)(-blue) * (long)t >> 16)) : (int)((long)blue * (long)t >> 16);
        blue = (blue < 0 ? -(-blue >> 16) : blue >> 16) + (rgb0 & 0xFF);
        return (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }
}

