/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

class HiscoreTable {
    public static boolean modified = false;
    public static int numTables = 0;
    private static final int cMaxScores = 5;
    private Vector[] levelScores = null;

    public static void SORT_shellSort(Vector v) {
        for (int distance = v.size() / 2; distance > 0; distance /= 2) {
            for (int segment = 0; segment < distance; ++segment) {
                HiscoreTable.SORT_segmentedInsertionSort(v, distance, segment);
            }
        }
    }

    private static void SORT_segmentedInsertionSort(Vector v, int distance, int segment) {
        for (int i = segment + distance; i < v.size(); i += distance) {
            Score b;
            Score a;
            for (int j = i; j >= distance && (a = (Score)v.elementAt(j)).compareTo(b = (Score)v.elementAt(j - distance)) <= 0; j -= distance) {
                HiscoreTable.SORT_swap(v, j, j - distance);
            }
        }
    }

    private static void SORT_swap(Vector v, int i, int j) {
        Object temp = v.elementAt(i);
        v.setElementAt(v.elementAt(j), i);
        v.setElementAt(temp, j);
    }

    public HiscoreTable(int _numTables) {
        numTables = _numTables;
        this.levelScores = new Vector[numTables];
        for (int t = 0; t < numTables; ++t) {
            this.levelScores[t] = new Vector();
            for (int i = 0; i < 5; ++i) {
                int points = 0;
                Score score = new Score(points);
                this.levelScores[t].addElement(score);
            }
        }
        modified = true;
    }

    public void makeDefaultTable(int tables, String[] defaultNames, int[][] defaultScores) {
        if (defaultNames.length != defaultScores[0].length) {
            System.out.println("Assertion Failure: defaultNames.length == defaultScores[0].length\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/HiScoreTable.java[71]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int t = 0; t < tables; ++t) {
            this.levelScores[t].removeAllElements();
            for (int i = 0; i < defaultNames.length; ++i) {
                int points = defaultScores[t][i];
                Score score = new Score(points);
                score.name = defaultNames[i];
                this.levelScores[t].addElement(score);
            }
        }
        modified = true;
    }

    public int getNumScores(int table) {
        if (table < 0 || table >= numTables) {
            System.out.println("Assertion Failure: table >= 0 && table < numTables with msg: " + table + " is out of range max: " + numTables + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/HiScoreTable.java" + "[" + 86 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.levelScores[table].size();
    }

    public int getScore(int table, int position) {
        return ((Score)this.levelScores[table].elementAt((int)position)).points;
    }

    public void setScore(int table, int position, int score) {
        ((Score)this.levelScores[table].elementAt((int)position)).points = score;
        modified = true;
    }

    public String getName(int table, int position) {
        return ((Score)this.levelScores[table].elementAt((int)position)).name;
    }

    public void setName(int table, int position, String name) {
        ((Score)this.levelScores[table].elementAt((int)position)).name = name;
        modified = true;
    }

    public boolean isHiscore(int table, int score) {
        int last_in_table = this.getScore(table, this.getNumScores(table) - 1);
        return score > last_in_table;
    }

    public int getHiscorePlace(int table, int score) {
        for (int i = 0; i < this.getNumScores(table); ++i) {
            if (score <= this.getScore(table, i)) continue;
            return i;
        }
        return -1;
    }

    public int getLowestScore(int table) {
        int score = 999999999;
        int place = -1;
        for (int i = 0; i < this.getNumScores(table); ++i) {
            if (score <= this.getScore(table, i)) continue;
            place = i;
            score = this.getScore(table, i);
        }
        return score;
    }

    public int getLowestPlace(int table) {
        int score = 999999999;
        int place = -1;
        for (int i = 0; i < this.getNumScores(table); ++i) {
            if (score <= this.getScore(table, i)) continue;
            place = i;
            score = this.getScore(table, i);
        }
        return place;
    }

    public void addHiscore(int table, int points, String name) {
        if (!this.isHiscore(table, points)) {
            System.out.println("Assertion Failure: isHiscore(table, points)\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/HiScoreTable.java[147]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Score score = (Score)this.levelScores[table].elementAt(this.getNumScores(table) - 1);
        score.points = points;
        score.name = name;
        HiscoreTable.SORT_shellSort(this.levelScores[table]);
        modified = true;
    }

    public void saveHiscores(DataOutputStream dataStream) {
        System.out.println("Saving hiscores...");
        try {
            dataStream.writeInt(numTables);
            for (int t = 0; t < numTables; ++t) {
                int num = this.getNumScores(t);
                dataStream.writeInt(num);
                for (int i = 0; i < num; ++i) {
                    Score score = (Score)this.levelScores[t].elementAt(i);
                    dataStream.writeInt(score.points);
                    if (score.name != null) {
                        dataStream.writeUTF(score.name);
                    } else {
                        dataStream.writeShort(0);
                    }
                    System.out.println("Writing: " + score.points + " name: " + score.name);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadHiscores(DataInputStream inputStream) throws IOException {
        System.out.println("Loading hiscores...");
        numTables = inputStream.readInt();
        if (numTables != this.levelScores.length) {
            System.out.println("Assertion Failure: numTables == levelScores.length\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/HiScoreTable.java[193]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int t = 0; t < numTables; ++t) {
            int num = inputStream.readInt();
            this.levelScores[t].removeAllElements();
            for (int i = 0; i < num; ++i) {
                int pts = inputStream.readInt();
                Score score = new Score(pts);
                score.name = inputStream.readUTF();
                this.levelScores[t].addElement(score);
                System.out.println("reading: " + score.points + " name: " + score.name);
            }
        }
        modified = false;
    }

    private class Score {
        public int points;
        public String name;

        public Score(int _points) {
            this.points = _points;
        }

        public int compareTo(Object comparator) {
            Score other = (Score)comparator;
            return other.points - this.points;
        }
    }
}

