/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.game.GameScreen;
import com.slg.j2me.game.GameSequence;
import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.sys.FixedPoint;
import com.slg.j2me.lib.sys.VecMath;
import com.slg.j2me.lib.util.CSVLoader;
import com.slg.j2me.lib.util.MultiLingual;
import com.slg.j2me.lib.util.Rand;
import java.util.Vector;

class GameLogic {
    public static Rand random;
    public int currentState = 10;
    public int lastState = -1;
    public int fp_state_time;
    public int fp_state_duration;
    public static final int cOuncesPerPound = 16;
    public static final int cStateWelcome = 0;
    public static final int cStateIdle = 1;
    public static final int cStatePullBack = 2;
    public static final int cStateCasting = 3;
    public static final int cStateLureDropping = 4;
    public static final int cStateFishing = 5;
    public static final int cStateHooked = 6;
    public static final int cStateLanding = 7;
    public static final int cStateCaught = 8;
    public static final int cStateReelingIn = 9;
    public static final int cStateGameOver = 10;
    public static final int cStateArcadeIntro = 11;
    public static final int cStateLineBroke = 12;
    public static final int cStateFishEscaped = 13;
    public static String[] dbgStateNames;
    public static final int cfpOnePercent;
    public static final int cMinTimeToFish = 30;
    public static final int cMaxTimeToFish = 60;
    public static final int cRandomVariance = 10000;
    public static final int cFishTiny = 0;
    public static final int cFishSmall = 1;
    public static final int cFishMedium = 2;
    public static final int cFishLarge = 3;
    public static final int cFishHuge = 4;
    public static final int cFishKempy = 5;
    public static final int cFishTypesMax = 6;
    public static final int cFishAICanCatch = 5;
    public static final int cStatSpeed = 5;
    public static final int cStatMax = 6;
    public static final String[] cFishNames;
    public static final int maxFish = 18;
    public static final int cFishStateStayStill = 0;
    public static final int cFishStateChaseFloat = 1;
    public static final int cFishStateHooked = 2;
    public static final int cFishStateReeled = 3;
    public static final int cFishStateRestAfterBite = 4;
    public static final int cFishStateScared = 5;
    public static final String[] cFishStateNames;
    public static final int eFishChaseLineUp = 0;
    public static final int eFishChaseAttack = 1;
    public static final int eFishChaseBackOff = 2;
    public static final int eFishChaseDone = 3;
    private static final int cfpSpawnPosRangeX;
    private static final int cfpNormalSpawnPosMinY;
    private static final int cfpNormalSpawnPosMaxY;
    private static final int cfpLargeSpawnPosMinY;
    private static final int cfpLargeSpawnPosMaxY;
    private static final int cfpSpawnVelMin;
    private static final int cfpSpawnVelMax;
    private static final int cfpFishScaredVel;
    private static final int cfpFishScaredTimeMin;
    private static final int cfpFishScaredTimeMax;
    private static final int fpChaseDist = 131072;
    public static final int cfpFishMinX;
    public static final int cfpFishMaxX;
    public static final int cfpFishMinY;
    public static final int cfpFishMaxY;
    public static final int cfpFishFarMinY;
    public static final int cfpFishReeledInPosY;
    public static final int eFishDirUp = 0;
    public static final int eFishDirLeft = 1;
    public static final int eFishDirRight = 2;
    public static final int eFishDirMin = 0;
    public static final int eFishDirMax = 2;
    public static final int cFishBiteMin = 30;
    public static final int cFishBiteMax = 900;
    private static final int cfpFishTailFlapRateMax;
    private static final int cfpFishTailFlapSlowRate = 0x1000000;
    private static final int cfpFishHookedStruggleAngleMax = 0x200000;
    private static final int cfpFishAlphaFadeRate = 0x600000;
    public static final int[][] cFishSizes;
    public static final int cfpFishSizeRandomMin;
    public static final int cfpFishSizeRandomMax;
    public int[][] fishPos = new int[18][3];
    public static int[][] fishMouthPos;
    public int[][] fishVel = new int[18][3];
    public int[][] fishSize = new int[18][2];
    public int[] fishRot = new int[18];
    public int[] fishTailPhase = new int[18];
    public int[] fishAlpha = new int[18];
    public int[] fishAlphaPhase = new int[18];
    public int[] fishType = new int[18];
    public int[] fishState = new int[18];
    public int[] fishWeight = new int[18];
    public int[] fishBiteTimer = new int[18];
    public int[] fishScareTimer = new int[18];
    public boolean[] fishFar = new boolean[18];
    public int numFish;
    public int currentFish;
    public int biggestFishType;
    public int fpFishFightStartPosX;
    public int fishFightDir;
    public int fpFishFightEnergy;
    public int fpFishFightNormalizedTension;
    public int fpFishFightTension;
    public int fpFishFightArrowFrame;
    public int fpFishFightTimer;
    public int fishChaseState;
    public int fpFishChaseTimer;
    public int fishChaseAttackCount;
    public int fpFishChaseBackOffDist;
    public static final int cfpFishFightTimeMin;
    public static final int cfpFishFightTimeMax;
    private static final int cfpFishFightWaterRange;
    private static final int cfpFishFightWaterSpeed;
    private static final int cfpFishFightWaterRandomMin;
    private static final int cfpFishFightWaterRandomMax;
    private static final int cfpFishFightAutoScareRadius;
    private static final int cfpFishFightDistanceClose;
    private static final int cfpFishFightDistanceMid;
    private static final int cfpFishFightDistanceFar;
    private static final int cfpFishFightSplashTimeMin;
    private static final int cfpFishFightSplashTimeMax;
    private static final int cfpFishFightStartTensionMin;
    private static final int cfpFishFightStartTensionMax;
    private static final int cfpFishFightTensionInc;
    private static final int cfpFishFightTensionDec;
    private static final int cfpFishChaseBackOffSpeed;
    private static final int cfpFishChaseAttackSpeed;
    private static final int cfpFishChaseLineUpDist;
    private static final int cfpFishChaseBackOffDistMin;
    private static final int cfpFishChaseBackOffDistMax;
    private static final int cfpFishChaseCloseDist;
    private static final int cfpFishChaseStrikeTime;
    private static final int cfpFishChaseStrikeWaitSpeed;
    public static short[] cFishWeightMin;
    public static short[] cFishWeightMax;
    public static short[][] cFishLureAttract;
    public static short[] cFishStartStrength;
    public static short[] cFishStrengthIncRate;
    public static short[] cFishStrengthDecRate;
    public static final int cMaxFishermenTypes = 10;
    public static short[][] cFishermanStats;
    public static final int[] cDayMod;
    private static short[] competitorID;
    private static int[] competitorTimer;
    public static int[][] competitorFish;
    public static int competitorStopCatchingTimer;
    private static int cStrikeLimit;
    public static int strikeTimer;
    int[] fishInWaterScreenPos = new int[4];
    private int fpRandomFirstBubbleTime = FixedPoint.stringToFP("3.0");
    public static int stateAfterTransition;
    public static final int transDone = 0;
    public static final int transOpening = 1;
    public static final int transClosing = 2;
    public static int transitionState;
    public static int transitionTime;
    public static int transitionAmount;
    public static final int cTransitionDuration = 16384;
    public static final int cOOTransitionDuration = 262144;
    public static int currentPlace;
    public static int cutOffCatch;
    private static int[] totalCatch;
    private static int[] chances;
    private int fpRandomSplashFish = 0;
    private static final long cTapTime = 150L;
    private long lastTapTimeDown = 0L;
    private long lastTapTimeLeft = 0L;
    private long lastTapTimeRight = 0L;
    int[] tempDir = new int[3];

    public static int getStat(int fisherID, int stat) {
        if (fisherID < 0 || fisherID >= cFishermanStats.length) {
            System.out.println("Assertion Failure: fisherID >= 0 && fisherID < cFishermanStats.length with msg: " + fisherID + " is out of range" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java" + "[" + 260 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stat < 0 || stat >= 6) {
            System.out.println("Assertion Failure: stat >= 0 && stat < cStatMax with msg: " + stat + " is out of range" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java" + "[" + 261 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cFishermanStats[fisherID][stat];
    }

    public static void SORT_shellSortNC(int[] v, int[] v2, boolean ascending, int[] assoc) {
        if (assoc != null && assoc.length != v.length) {
            System.out.println("Assertion Failure: assoc == null || assoc.length == v.length\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[278]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (v2 != null && v2.length != v.length) {
            System.out.println("Assertion Failure: v2 == null || v2.length == v.length\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[278]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int distance = v.length / 2; distance > 0; distance /= 2) {
            for (int segment = 0; segment < distance; ++segment) {
                GameLogic.SORT_segmentedInsertionSortNC(v, v2, distance, segment, ascending, assoc);
            }
        }
    }

    private static void SORT_segmentedInsertionSortNC(int[] v, int[] v2, int distance, int segment, boolean ascending, int[] assoc) {
        block0: for (int i = segment + distance; i < v.length; i += distance) {
            for (int j = i; j >= distance; j -= distance) {
                int k = j - distance;
                if (!(!ascending && v[j] > v[k] || ascending && v[j] < v[k] || !ascending && v2 != null && v[j] == v[k] && v2[j] > v2[k]) && (!ascending || v2 == null || v[j] != v[k] || v2[j] >= v2[k])) continue block0;
                int temp = v[j];
                v[j] = v[k];
                v[k] = temp;
                if (assoc != null) {
                    temp = assoc[j];
                    assoc[j] = assoc[k];
                    assoc[k] = temp;
                }
                if (v2 == null) continue;
                temp = v2[j];
                v2[j] = v2[k];
                v2[k] = temp;
            }
        }
    }

    public GameLogic() {
        random = new Rand();
        int seed = (int)System.currentTimeMillis();
        random.setSeed(seed);
        this.loadAIData();
    }

    private void loadAIData() {
        int i;
        Vector _lStatData = new Vector();
        String[] _headings = CSVLoader.loadCSV("/fishdata.bin", _lStatData);
        for (i = 0; i < _headings.length; ++i) {
            if (_headings[i].compareTo("MinWeightLbs") == 0) {
                cFishWeightMin = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishWeightMin != null) continue;
                System.out.println("Assertion Failure: cFishWeightMin != null with msg: Error loading MinWeightLbs into cFishWeightMin\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[293]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("MaxWeightLbs") == 0) {
                cFishWeightMax = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishWeightMax != null) continue;
                System.out.println("Assertion Failure: cFishWeightMax != null with msg: Error loading MaxWeightLbs into cFishWeightMax\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[294]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Lure1_Attract_Per") == 0) {
                GameLogic.cFishLureAttract[0] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishLureAttract[0] != null) continue;
                System.out.println("Assertion Failure: cFishLureAttract[0] != null with msg: Error loading Lure1_Attract_Per into cFishLureAttract[0]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[295]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Lure2_Attract_Per") == 0) {
                GameLogic.cFishLureAttract[1] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishLureAttract[1] != null) continue;
                System.out.println("Assertion Failure: cFishLureAttract[1] != null with msg: Error loading Lure2_Attract_Per into cFishLureAttract[1]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[296]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Lure3_Attract_Per") == 0) {
                GameLogic.cFishLureAttract[2] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishLureAttract[2] != null) continue;
                System.out.println("Assertion Failure: cFishLureAttract[2] != null with msg: Error loading Lure3_Attract_Per into cFishLureAttract[2]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[297]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Lure4_Attract_Per") == 0) {
                GameLogic.cFishLureAttract[3] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishLureAttract[3] != null) continue;
                System.out.println("Assertion Failure: cFishLureAttract[3] != null with msg: Error loading Lure4_Attract_Per into cFishLureAttract[3]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[298]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Lure5_Attract_Per") == 0) {
                GameLogic.cFishLureAttract[4] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishLureAttract[4] != null) continue;
                System.out.println("Assertion Failure: cFishLureAttract[4] != null with msg: Error loading Lure5_Attract_Per into cFishLureAttract[4]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[299]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("StartStrength") == 0) {
                cFishStartStrength = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishStartStrength != null) continue;
                System.out.println("Assertion Failure: cFishStartStrength != null with msg: Error loading StartStrength into cFishStartStrength\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[300]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("StrengthIncRate") == 0) {
                cFishStrengthIncRate = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishStrengthIncRate != null) continue;
                System.out.println("Assertion Failure: cFishStrengthIncRate != null with msg: Error loading StrengthIncRate into cFishStrengthIncRate\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[301]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("StrengthDecRate") != 0 || (cFishStrengthDecRate = CSVLoader.getCSVShortArray(_lStatData, i)) != null) continue;
            System.out.println("Assertion Failure: cFishStrengthDecRate != null with msg: Error loading StrengthDecRate into cFishStrengthDecRate\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[302]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        _lStatData.removeAllElements();
        if (cFishLureAttract[0] == null || cFishLureAttract[0].length != 6) {
            System.out.println("Assertion Failure: cFishLureAttract[0] != null && cFishLureAttract[0].length == cFishTypesMax\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[305]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        _lStatData = new Vector();
        _headings = CSVLoader.loadCSV("/fishermen.bin", _lStatData);
        for (i = 0; i < _headings.length; ++i) {
            if (_headings[i].compareTo("Skill1") == 0) {
                GameLogic.cFishermanStats[0] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishermanStats[0] != null) continue;
                System.out.println("Assertion Failure: cFishermanStats[0] != null with msg: Error loading Skill1 into cFishermanStats[0]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[308]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Skill2") == 0) {
                GameLogic.cFishermanStats[1] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishermanStats[1] != null) continue;
                System.out.println("Assertion Failure: cFishermanStats[1] != null with msg: Error loading Skill2 into cFishermanStats[1]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[309]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Skill3") == 0) {
                GameLogic.cFishermanStats[2] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishermanStats[2] != null) continue;
                System.out.println("Assertion Failure: cFishermanStats[2] != null with msg: Error loading Skill3 into cFishermanStats[2]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[310]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Skill4") == 0) {
                GameLogic.cFishermanStats[3] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishermanStats[3] != null) continue;
                System.out.println("Assertion Failure: cFishermanStats[3] != null with msg: Error loading Skill4 into cFishermanStats[3]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[311]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Skill5") == 0) {
                GameLogic.cFishermanStats[4] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishermanStats[4] != null) continue;
                System.out.println("Assertion Failure: cFishermanStats[4] != null with msg: Error loading Skill5 into cFishermanStats[4]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[312]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Skill6") == 0) {
                GameLogic.cFishermanStats[5] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishermanStats[5] != null) continue;
                System.out.println("Assertion Failure: cFishermanStats[5] != null with msg: Error loading Skill6 into cFishermanStats[5]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[313]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Skill7") == 0) {
                GameLogic.cFishermanStats[6] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishermanStats[6] != null) continue;
                System.out.println("Assertion Failure: cFishermanStats[6] != null with msg: Error loading Skill7 into cFishermanStats[6]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[314]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Skill8") == 0) {
                GameLogic.cFishermanStats[7] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishermanStats[7] != null) continue;
                System.out.println("Assertion Failure: cFishermanStats[7] != null with msg: Error loading Skill8 into cFishermanStats[7]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[315]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Skill9") == 0) {
                GameLogic.cFishermanStats[8] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cFishermanStats[8] != null) continue;
                System.out.println("Assertion Failure: cFishermanStats[8] != null with msg: Error loading Skill9 into cFishermanStats[8]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[316]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("Skill10") != 0) continue;
            GameLogic.cFishermanStats[9] = CSVLoader.getCSVShortArray(_lStatData, i);
            if (cFishermanStats[9] != null) continue;
            System.out.println("Assertion Failure: cFishermanStats[9] != null with msg: Error loading Skill10 into cFishermanStats[9]\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[317]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        _lStatData.removeAllElements();
        System.out.println("Fisherman1");
        for (int i2 = 0; i2 < cFishermanStats[0].length; ++i2) {
            System.out.println(" i: " + i2 + " : " + cFishermanStats[0][i2]);
        }
        if (cFishermanStats[0].length != 6) {
            System.out.println("Assertion Failure: cFishermanStats[0].length == cStatMax\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[325]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static int randRange(int min, int max) {
        return Math.abs(random.val()) % (max - min + 1) + min;
    }

    public static boolean randBoolean() {
        return (random.val() & 1) == 1;
    }

    public static int randAngle() {
        return random.val() & 0xFFFFFF;
    }

    public void newGame() {
        System.out.println("GameLogic.newGame()");
        this.lastState = 1;
        this.nextState(1);
    }

    public void initGame() {
        this.initFishInSpot();
    }

    public void nextState(int state) {
        System.out.println("GameLogic::nextState " + dbgStateNames[state]);
        BaseScreen.resetKeys();
        transitionTime = 0;
        transitionState = 0;
        transitionAmount = 0;
        this.lastState = this.currentState;
        this.currentState = state;
        this.fp_state_time = 0;
        int skipState = -1;
        switch (this.currentState) {
            case 0: {
                break;
            }
            case 1: {
                System.out.println("nextStateIdle: Setting currentFish to -1");
                this.currentFish = -1;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.hookCurrentFish();
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.catchCurrentFish();
                break;
            }
            case 10: {
                if (this.currentFish == -1) break;
                this.releaseFish(this.currentFish);
            }
        }
        GameApp.gameScreen.nextState(state);
        if (skipState != -1) {
            this.nextState(skipState);
        }
    }

    public void process() {
        if (transitionState != 0) {
            return;
        }
        int t = Application.fp_deltatime;
        this.fp_state_time += t;
        this.updateFishInWater();
        if (FrontEnd.gameType == 1) {
            this.processAI();
        }
        switch (this.currentState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                if (this.currentFish != -1) break;
                this.checkFishInterest();
                break;
            }
            case 6: {
                this.processFishFight();
                if (this.currentFish == -1) break;
                this.scareFishAwayFromPoint(this.fishPos[this.currentFish], cfpFishFightAutoScareRadius, false);
                if (this.fpFishFightTension < 65536) break;
                this.nextState(12);
            }
        }
        this.fpRandomFirstBubbleTime -= Application.fp_deltatime;
        if (this.fpRandomFirstBubbleTime <= 0) {
            int bubblyFish = GameLogic.randRange(0, 17);
            GameScreen.gameEffects.attachEffect(GameLogic.randRange(12, 14), bubblyFish);
            this.fpRandomFirstBubbleTime = GameLogic.randRange(3, 8) < 0 ? -(-GameLogic.randRange(3, 8) << 16) : GameLogic.randRange(3, 8) << 16;
        }
    }

    public void transitionToNextState(int state) {
        if (transitionState == 2 && stateAfterTransition == state) {
            return;
        }
        if (transitionState != 2 && this.currentState == state) {
            return;
        }
        stateAfterTransition = state;
        transitionState = 2;
        System.out.println("transitionToNextState - going into state " + state);
    }

    public void processTransition() {
        if (transitionState != 0) {
            int n = transitionTime + Application.fp_deltatime < 0 ? 0 : (transitionTime = transitionTime + Application.fp_deltatime > 16384 ? 16384 : transitionTime + Application.fp_deltatime);
            transitionAmount = transitionState == 1 ? (((transitionTime ^ 0x40000) & 0x8000000) != 0 ? -((int)((long)(-transitionTime) * 262144L >> 16)) : (int)((long)transitionTime * 262144L >> 16)) : 65536 - (((transitionTime ^ 0x40000) & 0x8000000) != 0 ? -((int)((long)(-transitionTime) * 262144L >> 16)) : (int)((long)transitionTime * 262144L >> 16));
            if (transitionTime >= 16384) {
                transitionTime = 0;
                if (transitionState == 2) {
                    this.nextState(stateAfterTransition);
                } else {
                    transitionState = 0;
                }
            }
        } else {
            transitionAmount = 65536;
        }
    }

    private static void calculateCutOffWeight() {
        if (totalCatch == null || totalCatch.length != competitorFish.length) {
            totalCatch = new int[competitorFish.length];
        }
        for (int c = 0; c < competitorFish.length; ++c) {
            GameLogic.totalCatch[c] = GameLogic.getFishWeight(competitorFish[c]);
        }
        int pWeight = GameLogic.getFishWeight(competitorFish[0]);
        GameLogic.SORT_shellSortNC(totalCatch, null, false, null);
        cutOffCatch = totalCatch[competitorFish.length / 2];
        for (int c = 0; c < totalCatch.length; ++c) {
            if (pWeight != totalCatch[c]) continue;
            currentPlace = c + 1;
            break;
        }
    }

    public static int getFishWeight(int[] fish) {
        int weight = 0;
        if (fish != null) {
            for (int i = 0; i < fish.length; ++i) {
                weight += fish[i];
            }
        }
        return weight;
    }

    public static int getHeaviestFish(int[] fish) {
        int heaviest = fish[0];
        if (fish != null) {
            for (int i = 0; i < fish.length; ++i) {
                if (fish[i] <= heaviest) continue;
                heaviest = fish[i];
            }
        }
        return heaviest;
    }

    public static int getFishCount(int[] fish) {
        int count = 0;
        if (fish != null) {
            for (int i = 0; i < fish.length; ++i) {
                if (fish[i] <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static void initCompetitors(int num, short[] ids, int maxfish) {
        int c;
        System.out.println("GameLogic.initCompetitors - " + num);
        competitorID = new short[num];
        GameLogic.competitorID[0] = -1;
        int curIndex = 1;
        for (c = 0; c < ids.length; c = (int)((short)(c + 1))) {
            System.out.println("initCompetitors. There are " + ids[c] + " of player skill " + (c + 1));
            for (int i = 0; i < ids[c]; ++i) {
                GameLogic.competitorID[curIndex++] = c;
            }
        }
        competitorTimer = new int[num];
        competitorFish = new int[num][maxfish];
        for (c = 1; c < num; ++c) {
            GameLogic.competitorTimer[c] = GameLogic.getReelTime(competitorID[c]);
            System.out.println("competitorTimer[c]" + competitorTimer[c]);
        }
        currentPlace = 1;
        cutOffCatch = 0;
    }

    public static int getReelTime(int fishermanID) {
        int stat = GameLogic.getStat(fishermanID, 5);
        int diff = 30;
        diff = diff * (100 - stat) / 100;
        int ret = (30 + diff) * 1000;
        int extra = GameLogic.randRange(0, 10000) - 10000 >> 1;
        return ret + extra;
    }

    public void processAI() {
        for (int fm = 1; fm < competitorID.length; ++fm) {
            int n = fm;
            competitorTimer[n] = competitorTimer[n] - Application.lastFrameTime;
            if (competitorTimer[fm] > 0) continue;
            GameLogic.competitorTimer[fm] = GameLogic.getReelTime(competitorID[fm]);
            System.out.println("Fisherman " + fm + " of type: " + competitorID[fm] + " is reeling in ");
            for (int stat = 0; stat < 5; ++stat) {
                int val;
                GameLogic.chances[stat] = val = GameLogic.getStat(competitorID[fm], stat);
                if (stat == 0 || val == 0) continue;
                int n2 = stat;
                chances[n2] = chances[n2] + chances[stat - 1];
            }
            int roll = GameLogic.randRange(1, 100);
            int caught = -1;
            for (int stat = 0; stat < 5; ++stat) {
                if (roll >= chances[stat]) continue;
                caught = stat;
                if (GameLogic.getStat(competitorID[fm], caught) != 0) break;
                System.out.println("Assertion Failure: getStat(competitorID[fm], caught) != 0\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[713]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            if (caught == -1) continue;
            int weight = GameLogic.getRandomFishWeight(caught);
            System.out.println("Fish Type: " + caught + " giving weight " + weight);
            this.fishCaught(fm, caught, weight);
        }
    }

    public static void addFishToCatch(int[] fish, int ounces) {
        int smallest = Integer.MAX_VALUE;
        int smallestIndex = -1;
        for (int i = 0; i < fish.length; ++i) {
            if (fish[i] >= smallest) continue;
            smallest = fish[i];
            smallestIndex = i;
        }
        if (smallestIndex == -1) {
            System.out.println("Assertion Failure: smallestIndex!=-1\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[738]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ounces > smallest) {
            System.out.println("We caught a useful fish, add to catch");
            fish[smallestIndex] = ounces;
        } else {
            System.out.println("This fish is too small, throw it back");
        }
    }

    public void fishCaught(int compID, int fishType, int ounces) {
        System.out.println("GameLogic: " + cFishNames[fishType] + " fish Caught - ounces " + ounces + " - compID " + compID);
        System.out.println("GameScreen.arcadeFishCaught: " + GameScreen.arcadeFishCaught);
        if (FrontEnd.gameType == 1) {
            GameLogic.addFishToCatch(competitorFish[compID], ounces);
            int oldCO = cutOffCatch;
            GameLogic.calculateCutOffWeight();
            if (GameSequence.day != 2) {
                if (compID == 0 || oldCO != cutOffCatch) {
                    GameScreen.updateTickerMsg(GameLogic.getFishWeight(competitorFish[0]));
                }
            } else if (compID != 0 && GameScreen.scrollMessageXpos < -GameScreen.scrollMsgWidth) {
                GameScreen.updateTickerMsg(ounces);
            }
        } else {
            int lbs = ounces / 16;
            int bonus = lbs * GameScreen.cArcadeTimePerPound[GameScreen.arcadeLevel];
            int bonusScore = lbs * GameScreen.cArcadePointsPerPound[GameScreen.arcadeLevel];
            GameLogic.competitorFish[0][GameScreen.arcadeFishCaught] = ounces;
            ++GameScreen.arcadeFishCaught;
            GameScreen.arcadeScore = (GameScreen.arcadeCatch += ounces) * 10;
            System.out.println("Bonus for fish caught in arcade mode " + bonus + " seconds and bonus score " + GameScreen.arcadeScore);
        }
    }

    public void notifyPlayerCheckedIn() {
        int timeLeft = GameScreen.gameTime - competitorStopCatchingTimer;
        System.out.println("notifyPlayerCheckedIn, time left " + timeLeft / 1000);
        if (timeLeft <= 0) {
            return;
        }
        for (int i = 1; i < competitorID.length; ++i) {
            if (competitorTimer[i] > timeLeft) {
                System.out.println("Skipping bloke " + i);
                continue;
            }
            int numAttempts = 1;
            int blokeTime = timeLeft - competitorTimer[i];
            numAttempts += blokeTime / GameLogic.getReelTime(competitorID[i]);
            for (int j = 0; j < numAttempts; ++j) {
                System.out.println("Fisherman (notifyFinished) " + i + " of type: " + competitorID[i] + " is reeling in ");
                for (int stat = 0; stat < 5; ++stat) {
                    int val;
                    GameLogic.chances[stat] = val = GameLogic.getStat(competitorID[i], stat);
                    if (stat == 0 || val == 0) continue;
                    int n = stat;
                    chances[n] = chances[n] + chances[stat - 1];
                }
                int roll = GameLogic.randRange(1, 100);
                int caught = -1;
                for (int stat = 0; stat < 5; ++stat) {
                    if (roll >= chances[stat]) continue;
                    caught = stat;
                    break;
                }
                if (caught == -1) continue;
                int weight = GameLogic.getRandomFishWeight(caught);
                this.fishCaught(i, caught, weight);
            }
        }
    }

    public static int getRandomFishWeight(int type) {
        if (type < 0 || type > 5) {
            System.out.println("Assertion Failure: type >= cFishTiny && type <= cFishKempy with msg: " + type + " is not a known fish type" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java" + "[" + 871 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int weight = 0;
        int min = cFishWeightMin[type] * 16;
        int max = cFishWeightMax[type] * 16;
        weight = GameLogic.randRange(min, max);
        System.out.println("getRandomFishWeight: " + type + " min: " + cFishWeightMin[type] + " max: " + cFishWeightMax[type] + " weight: " + weight);
        return weight;
    }

    public static int getFishTypeFromWeight(int weight) {
        for (int i = 5; i > 0; --i) {
            int min = cFishWeightMin[i] * 16;
            if (weight < min) continue;
            return i;
        }
        return 0;
    }

    public void addFishToSpot(int type) {
        if (this.numFish >= 18) {
            System.out.println("Assertion Failure: numFish < maxFish with msg: MAXFISH is: 18\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[898]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int n = this.numFish++;
        this.fishType[n] = type;
        boolean isBig = false;
        if (FrontEnd.gameType == 1 && type == this.biggestFishType) {
            isBig = true;
        }
        this.fishFar[n] = isBig;
        this.fishPos[n][0] = GameLogic.randRange(-cfpSpawnPosRangeX, cfpSpawnPosRangeX);
        this.fishPos[n][1] = isBig ? GameLogic.randRange(cfpLargeSpawnPosMinY, cfpLargeSpawnPosMaxY) : GameLogic.randRange(cfpNormalSpawnPosMinY, cfpNormalSpawnPosMaxY);
        this.fishPos[n][2] = 0;
        this.fishSetRandomVelocityRandomDirection(n);
        int fpFishScale = GameLogic.randRange(cfpFishSizeRandomMin, cfpFishSizeRandomMax);
        this.fishSize[n][0] = ((cFishSizes[type][0] ^ fpFishScale) & 0x8000000) != 0 ? -((int)((long)(-cFishSizes[type][0]) * (long)fpFishScale >> 16)) : (int)((long)cFishSizes[type][0] * (long)fpFishScale >> 16);
        this.fishSize[n][1] = ((cFishSizes[type][1] ^ fpFishScale) & 0x8000000) != 0 ? -((int)((long)(-cFishSizes[type][1]) * (long)fpFishScale >> 16)) : (int)((long)cFishSizes[type][1] * (long)fpFishScale >> 16);
        this.fishRot[n] = this.angleFromDirXY(this.fishVel[n]);
        this.fishTailPhase[n] = 0;
        this.fishScareTimer[n] = 0;
        this.fishAlpha[n] = 0;
        this.fishAlphaPhase[n] = GameLogic.randAngle();
        this.fishState[n] = 0;
        this.fishWeight[n] = GameLogic.getRandomFishWeight(type);
        this.fishBiteTimer[n] = GameLogic.randRange(30, 900);
    }

    public void addFishToSpot(int type, int num) {
        System.out.println("addFishToSpot " + num + " * " + cFishNames[type]);
        for (int i = 0; i < num; ++i) {
            this.addFishToSpot(type);
        }
    }

    public void setBiggestFishType(int type) {
        this.biggestFishType = type;
    }

    public void fishSetRandomVelocityRandomDirection(int n) {
        int dir;
        int speed = GameLogic.randRange(cfpSpawnVelMin, cfpSpawnVelMax);
        if (this.fishFar[n]) {
            dir = GameLogic.randBoolean() ? 0x800000 : 0;
            dir += GameLogic.randRange(-16, 16);
            dir &= 0xFFFFFF;
        } else {
            dir = GameLogic.randAngle();
        }
        this.fishVel[n][0] = ((speed ^ FixedPoint.sinLut(dir + 0x400000)) & 0x8000000) != 0 ? -((int)((long)(-speed) * (long)FixedPoint.sinLut(dir + 0x400000) >> 16)) : (int)((long)speed * (long)FixedPoint.sinLut(dir + 0x400000) >> 16);
        this.fishVel[n][1] = ((speed ^ FixedPoint.sinLut(dir)) & 0x8000000) != 0 ? -((int)((long)(-speed) * (long)FixedPoint.sinLut(dir) >> 16)) : (int)((long)speed * (long)FixedPoint.sinLut(dir) >> 16);
        this.fishVel[n][2] = 0;
    }

    public void fishSetRandomVelocityCurrentDirection(int n) {
        int speed = GameLogic.randRange(cfpSpawnVelMin, cfpSpawnVelMax);
        int dir = this.angleFromDirXY(this.fishVel[n]);
        this.fishVel[n][0] = ((speed ^ FixedPoint.sinLut(dir + 0x400000)) & 0x8000000) != 0 ? -((int)((long)(-speed) * (long)FixedPoint.sinLut(dir + 0x400000) >> 16)) : (int)((long)speed * (long)FixedPoint.sinLut(dir + 0x400000) >> 16);
        this.fishVel[n][1] = ((speed ^ FixedPoint.sinLut(dir)) & 0x8000000) != 0 ? -((int)((long)(-speed) * (long)FixedPoint.sinLut(dir) >> 16)) : (int)((long)speed * (long)FixedPoint.sinLut(dir) >> 16);
        this.fishVel[n][2] = 0;
    }

    public int angleFromDirXY(int[] dir) {
        int dy;
        int dx;
        int len;
        if (dir.length < 2) {
            System.out.println("Assertion Failure: dir.length >=2\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[988]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((len = FixedPoint.sqrt_bits(((((dx = dir[0]) ^ dx) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)dx >> 16)) : (int)((long)dx * (long)dx >> 16)) + ((((dy = dir[1]) ^ dy) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)dy >> 16)) : (int)((long)dy * (long)dy >> 16)))) == 0) {
            return 0;
        }
        dx = (int)(((long)dx << 16) / (long)len);
        int ang = 0x400000 - FixedPoint.asinLut(dx);
        if (dy < 0) {
            ang = -ang & 0xFFFFFF;
        }
        return ang;
    }

    public void addRandomFish(int numberOfFish) {
        if (numberOfFish <= 0 || numberOfFish > 18) {
            System.out.println("Assertion Failure: (numberOfFish>0) && (numberOfFish<=maxFish)\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[1012]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < numberOfFish; ++i) {
            this.addFishToSpot(GameLogic.randRange(0, 1));
        }
    }

    public void initFishInSpot() {
        this.numFish = 0;
        this.currentFish = -1;
    }

    private void limitFishToBoundary(int i) {
        int minY;
        if (this.fishPos[i][0] < cfpFishMinX) {
            this.fishPos[i][0] = cfpFishMinX;
            this.fishVel[i][0] = -this.fishVel[i][0];
        }
        if (this.fishPos[i][0] > cfpFishMaxX) {
            this.fishPos[i][0] = cfpFishMaxX;
            this.fishVel[i][0] = -this.fishVel[i][0];
        }
        int n = minY = this.fishFar[i] ? cfpFishFarMinY : cfpFishMinY;
        if (this.fishPos[i][1] < minY && this.fishVel[i][1] < 0) {
            this.fishVel[i][1] = -this.fishVel[i][1];
        }
        if (this.fishPos[i][1] > cfpFishMaxY && this.fishVel[i][1] > 0) {
            this.fishVel[i][1] = -this.fishVel[i][1];
        }
    }

    private boolean isFishInterested(int fishID) {
        if (this.fishState[fishID] != 0) {
            return false;
        }
        if (this.fishBiteTimer[fishID] > 0) {
            return false;
        }
        int flen = FixedPoint.sqrt_bits(VecMath.distsq2d(GameScreen.floatPos, fishMouthPos[fishID]));
        if (flen < 131072) {
            int dy;
            int dx = GameScreen.floatPos[0] - fishMouthPos[fishID][0];
            int dot = (((dx ^ this.fishVel[fishID][0]) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)this.fishVel[fishID][0] >> 16)) : (int)((long)dx * (long)this.fishVel[fishID][0] >> 16)) + ((((dy = GameScreen.floatPos[1] - fishMouthPos[fishID][1]) ^ this.fishVel[fishID][1]) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)this.fishVel[fishID][1] >> 16)) : (int)((long)dy * (long)this.fishVel[fishID][1] >> 16));
            if (dot > 0) {
                int lure = GameScreen.getCurrent(3);
                int chance = cFishLureAttract[lure][this.fishType[fishID]] + 10;
                int roll = GameLogic.randRange(0, 99);
                System.out.println("Lure chance: " + chance + " rolled: " + roll);
                this.fishBiteTimer[fishID] = 30;
                if (FrontEnd.gameType == 0) {
                    chance = 99;
                }
                if (roll < chance) {
                    return true;
                }
            }
        }
        return false;
    }

    private void hookCurrentFish() {
        if (this.currentFish < 0 || this.currentFish >= this.numFish) {
            System.out.println("Assertion Failure: currentFish >= 0 && currentFish < numFish with msg: " + this.currentFish + " is not a valid fish" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java" + "[" + 1103 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fishState[this.currentFish] = 2;
        this.fishFightDir = GameLogic.randRange(0, 2);
        this.fpFishFightEnergy = this.fishStartStrength();
        this.fpFishFightNormalizedTension = GameScreen.calculateNormalisedTension();
        this.fpFishFightTension = FixedPoint.linearInterpolate(this.fpFishFightNormalizedTension, cfpFishFightStartTensionMin, cfpFishFightStartTensionMax);
        this.fpFishFightArrowFrame = 0;
        this.fpFishFightTimer = GameLogic.randRange(cfpFishFightTimeMin, cfpFishFightTimeMax);
        this.fpFishFightStartPosX = this.fishPos[this.currentFish][0];
    }

    private void catchCurrentFish() {
        if (this.currentFish < 0 || this.currentFish >= this.numFish) {
            System.out.println("Assertion Failure: currentFish >= 0 && currentFish < numFish with msg: " + this.currentFish + " is not a valid fish" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java" + "[" + 1117 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fishState[this.currentFish] = 3;
        this.fishCaught(0, this.fishType[this.currentFish], this.fishWeight[this.currentFish]);
    }

    public boolean hasFishOn() {
        return this.currentState == 6 || this.currentState == 7 || this.currentState == 8;
    }

    public boolean isReelingIn() {
        return this.currentState == 9 || this.currentState == 12;
    }

    public boolean isFishReeledIn() {
        int Ydist;
        if (this.currentFish < 0 || this.currentFish >= this.numFish) {
            System.out.println("Assertion Failure: currentFish >= 0 && currentFish < numFish with msg: " + this.currentFish + " is not a valid fish" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java" + "[" + 1131 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (Ydist = this.fishPos[this.currentFish][1] - GameScreen.rodPos[1]) <= cfpFishReeledInPosY;
    }

    public void reelInFish(int fpAmountY) {
        if (this.currentFish < 0 || this.currentFish >= this.numFish) {
            System.out.println("Assertion Failure: currentFish >= 0 && currentFish < numFish with msg: " + this.currentFish + " is not a valid fish" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java" + "[" + 1137 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int[] nArray = this.fishPos[this.currentFish];
        nArray[1] = nArray[1] - fpAmountY;
    }

    public int getCurrentFishWeight() {
        if (this.currentFish < 0 || this.currentFish >= this.numFish) {
            System.out.println("Assertion Failure: currentFish >= 0 && currentFish < numFish with msg: " + this.currentFish + " is not a valid fish" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java" + "[" + 1142 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.fishWeight[this.currentFish];
    }

    private boolean checkFishInterest() {
        for (int i = 0; i < this.numFish; ++i) {
            if (!this.isFishInterested(i)) continue;
            this.fishState[i] = 1;
            this.fishChaseState = 0;
            this.fpFishChaseTimer = 0;
            this.fishChaseAttackCount = this.fishType[i] == 5 ? GameLogic.randRange(6, 8) : GameLogic.randRange(0, 3);
            System.out.println("*** fishChaseAttackCount: " + this.fishChaseAttackCount);
            this.currentFish = i;
            GameScreen.worldToScreenPos(this.fishInWaterScreenPos, fishMouthPos[i]);
            int sx = this.fishInWaterScreenPos[0];
            int sy = this.fishInWaterScreenPos[1];
            GameScreen.gameEffects.addEffect(1, sx, sy);
            return true;
        }
        return false;
    }

    private void processFishFight() {
        int dt;
        if (this.currentFish < 0 || this.currentFish >= this.numFish) {
            System.out.println("Assertion Failure: currentFish >= 0 && currentFish < numFish with msg: " + this.currentFish + " is not a valid fish" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java" + "[" + 1184 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fpFishFightArrowFrame += ((0x100000 ^ (dt = Application.fp_deltatime)) & 0x8000000) != 0 ? -((int)(-1048576L * (long)dt >> 16)) : (int)(0x100000L * (long)dt >> 16);
        this.fpFishFightArrowFrame &= (GameScreen.gfxDownArrow.numFrames < 0 ? -(-GameScreen.gfxDownArrow.numFrames << 16) : GameScreen.gfxDownArrow.numFrames << 16) - 1;
        boolean fishTooHeavy = this.fpFishFightNormalizedTension >= 65536;
        this.fpFishFightTimer -= dt;
        if (this.fpFishFightTimer <= 0) {
            this.fpFishFightTimer = GameLogic.randRange(cfpFishFightTimeMin, cfpFishFightTimeMax);
            this.fishFightDir = GameLogic.randRange(0, 2);
            this.fpFishFightEnergy += this.fishStrengthIncRate();
            if (this.fpFishFightEnergy >= 65536) {
                System.out.println("Fish released");
                this.fpFishFightEnergy = 65536;
                this.releaseFish(this.currentFish);
                this.nextState(13);
                GameScreen.textGameInfo.clearText();
                GameScreen.textGameInfo.formatText(GameScreen.fontGame, "" + MultiLingual.get(145) + "\n");
                GameScreen.textGameInfo.formatText(GameScreen.speechFont, "" + MultiLingual.get(159) + "");
                GameScreen.textGameInfo.layout();
                return;
            }
        }
        boolean playerFight = false;
        boolean playerReeling = ScreenLayout.keysDown(16);
        switch (this.fishFightDir) {
            case 0: {
                if (ScreenLayout.keysPressed(8)) {
                    playerFight = true;
                }
                if (!ScreenLayout.keysDown(8)) break;
                long currentTime = System.currentTimeMillis();
                if (this.lastTapTimeDown != 0L && currentTime - this.lastTapTimeDown <= 150L) break;
                this.lastTapTimeDown = currentTime;
                playerFight = true;
                break;
            }
            case 1: {
                if (ScreenLayout.keysPressed(4)) {
                    playerFight = true;
                }
                if (!ScreenLayout.keysDown(4)) break;
                long currentTime = System.currentTimeMillis();
                if (this.lastTapTimeRight != 0L && currentTime - this.lastTapTimeRight <= 150L) break;
                this.lastTapTimeRight = currentTime;
                playerFight = true;
                break;
            }
            case 2: {
                if (ScreenLayout.keysPressed(2)) {
                    playerFight = true;
                }
                if (!ScreenLayout.keysDown(2)) break;
                long currentTime = System.currentTimeMillis();
                if (this.lastTapTimeLeft != 0L && currentTime - this.lastTapTimeLeft <= 150L) break;
                this.lastTapTimeLeft = currentTime;
                playerFight = true;
            }
        }
        if (playerFight) {
            this.fpFishFightEnergy -= this.fishStrengthDecRate();
            if (this.fpFishFightEnergy <= 0) {
                this.fpFishFightEnergy = 0;
            }
            if (!playerReeling) {
                int fpDecTension;
                int n = fpDecTension = ((cfpFishFightTensionDec ^ 131072 - this.fpFishFightEnergy >> 1) & 0x8000000) != 0 ? -((int)((long)(-cfpFishFightTensionDec) * (long)(131072 - this.fpFishFightEnergy >> 1) >> 16)) : (int)((long)cfpFishFightTensionDec * (long)(131072 - this.fpFishFightEnergy >> 1) >> 16);
                if (!fishTooHeavy) {
                    this.fpFishFightTension -= fpDecTension;
                }
                if (this.fpFishFightTension <= 0) {
                    this.fpFishFightTension = 0;
                }
            }
        }
        if (playerReeling || fishTooHeavy) {
            int fpIncTension;
            int n = fpIncTension = ((cfpFishFightTensionInc ^ this.fpFishFightEnergy) & 0x8000000) != 0 ? -((int)((long)(-cfpFishFightTensionInc) * (long)this.fpFishFightEnergy >> 16)) : (int)((long)cfpFishFightTensionInc * (long)this.fpFishFightEnergy >> 16);
            if (!playerReeling) {
                fpIncTension >>= 2;
            }
            this.fpFishFightTension += ((fpIncTension ^ dt) & 0x8000000) != 0 ? -((int)((long)(-fpIncTension) * (long)dt >> 16)) : (int)((long)fpIncTension * (long)dt >> 16);
            if (this.fpFishFightTension > 65536) {
                this.fpFishFightTension = 65536;
            }
        }
        this.fishPos[this.currentFish][0] = this.fpFishFightStartPosX;
        int fpRand = FixedPoint.linearInterpolate(this.fpFishFightTension, cfpFishFightWaterRandomMin, cfpFishFightWaterRandomMax);
        int[] nArray = this.fishPos[this.currentFish];
        nArray[0] = nArray[0] + (((GameLogic.randRange(-fpRand, fpRand) ^ dt) & 0x8000000) != 0 ? -((int)((long)(-GameLogic.randRange(-fpRand, fpRand)) * (long)dt >> 16)) : (int)((long)GameLogic.randRange(-fpRand, fpRand) * (long)dt >> 16));
        int cfpFishFightPosXDragCentreSpeed = FixedPoint.stringToFP("5");
        if (this.fpFishFightStartPosX > 0) {
            this.fpFishFightStartPosX -= ((cfpFishFightPosXDragCentreSpeed ^ dt) & 0x8000000) != 0 ? -((int)((long)(-cfpFishFightPosXDragCentreSpeed) * (long)dt >> 16)) : (int)((long)cfpFishFightPosXDragCentreSpeed * (long)dt >> 16);
            this.fpFishFightStartPosX = this.fpFishFightStartPosX > 0 ? this.fpFishFightStartPosX : 0;
        } else if (this.fpFishFightStartPosX < 0) {
            this.fpFishFightStartPosX += ((cfpFishFightPosXDragCentreSpeed ^ dt) & 0x8000000) != 0 ? -((int)((long)(-cfpFishFightPosXDragCentreSpeed) * (long)dt >> 16)) : (int)((long)cfpFishFightPosXDragCentreSpeed * (long)dt >> 16);
            this.fpFishFightStartPosX = this.fpFishFightStartPosX < 0 ? this.fpFishFightStartPosX : 0;
        }
        this.fishRot[this.currentFish] = GameLogic.randRange(0x200000, 0x600000);
        this.fpRandomSplashFish -= dt;
        if (this.fpRandomSplashFish <= 0) {
            GameScreen.worldToScreenPos(this.fishInWaterScreenPos, this.fishPos[this.currentFish]);
            int sx = this.fishInWaterScreenPos[0];
            int sy = this.fishInWaterScreenPos[1];
            int Ydist = this.fishPos[this.currentFish][1] - GameScreen.rodPos[1];
            if (Ydist <= cfpFishFightDistanceClose) {
                GameScreen.gameEffects.addFishHead(this.fishType[this.currentFish], sx, sy);
                boolean doBothSplashes = this.fishType[this.currentFish] < 2 ? GameLogic.randBoolean() : true;
                if (doBothSplashes) {
                    GameScreen.gameEffects.addEffect(3, sx, sy);
                    GameScreen.gameEffects.addEffect(4, sx, sy);
                } else {
                    GameScreen.gameEffects.addEffect(GameLogic.randBoolean() ? 3 : 4, sx, sy);
                }
            } else if (Ydist <= cfpFishFightDistanceMid) {
                GameScreen.gameEffects.addEffect(GameLogic.randBoolean() ? 3 : 4, sx, sy);
            } else if (Ydist <= cfpFishFightDistanceFar) {
                GameScreen.gameEffects.addEffect(2, sx, sy);
            } else {
                GameScreen.gameEffects.addEffect(0, sx, sy);
            }
            this.fpRandomSplashFish = GameLogic.randRange(cfpFishFightSplashTimeMin, cfpFishFightSplashTimeMax);
        }
    }

    private void updateFishInWater() {
        int dt = Application.fp_deltatime;
        for (int i = 0; i < this.numFish; ++i) {
            this.fishBiteTimer[i] = 0 > this.fishBiteTimer[i] - Application.lastFrameTime ? 0 : this.fishBiteTimer[i] - Application.lastFrameTime;
            switch (this.fishState[i]) {
                case 0: 
                case 5: {
                    int[] nArray = this.fishPos[i];
                    nArray[0] = nArray[0] + (((this.fishVel[i][0] ^ dt) & 0x8000000) != 0 ? -((int)((long)(-this.fishVel[i][0]) * (long)dt >> 16)) : (int)((long)this.fishVel[i][0] * (long)dt >> 16));
                    int[] nArray2 = this.fishPos[i];
                    nArray2[1] = nArray2[1] + (((this.fishVel[i][1] ^ dt) & 0x8000000) != 0 ? -((int)((long)(-this.fishVel[i][1]) * (long)dt >> 16)) : (int)((long)this.fishVel[i][1] * (long)dt >> 16));
                    this.limitFishToBoundary(i);
                    this.updateFishRot(i);
                }
            }
            if (this.fishState[i] == 1) {
                if (i != this.currentFish) {
                    System.out.println("Assertion Failure: i == currentFish\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[1401]");
                    try {
                        throw new Exception();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.updateInterestedFish(i);
            }
            if (this.fishState[i] == 5) {
                int n = i;
                this.fishScareTimer[n] = this.fishScareTimer[n] - dt;
                if (this.fishScareTimer[i] <= 0) {
                    this.fishScareTimer[i] = 0;
                    this.fishState[i] = 0;
                    this.fishSetRandomVelocityRandomDirection(i);
                }
            }
            if (this.fishState[i] != 2 && this.fishState[i] != 1) {
                this.fishAlpha[i] = (FixedPoint.sinLut(this.fishAlphaPhase[i]) + 65536 >> 2) + 32768;
                int n = i;
                this.fishAlphaPhase[n] = this.fishAlphaPhase[n] + (((0x600000 ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)(-6291456L * (long)Application.fp_deltatime >> 16)) : (int)(0x600000L * (long)Application.fp_deltatime >> 16));
                int n2 = i;
                this.fishAlphaPhase[n2] = this.fishAlphaPhase[n2] & 0xFFFFFF;
            } else {
                this.fishAlpha[i] = 65536;
            }
            this.updateFishTailFlapping(i);
            int mouthOffset = this.fishSize[i][1] + (this.fishSize[i][0] >> 1);
            GameLogic.fishMouthPos[i][0] = this.fishPos[i][0] + (((mouthOffset ^ FixedPoint.sinLut(this.fishRot[i] + 0x400000)) & 0x8000000) != 0 ? -((int)((long)(-mouthOffset) * (long)FixedPoint.sinLut(this.fishRot[i] + 0x400000) >> 16)) : (int)((long)mouthOffset * (long)FixedPoint.sinLut(this.fishRot[i] + 0x400000) >> 16));
            GameLogic.fishMouthPos[i][1] = this.fishPos[i][1] + (((mouthOffset ^ FixedPoint.sinLut(this.fishRot[i])) & 0x8000000) != 0 ? -((int)((long)(-mouthOffset) * (long)FixedPoint.sinLut(this.fishRot[i]) >> 16)) : (int)((long)mouthOffset * (long)FixedPoint.sinLut(this.fishRot[i]) >> 16));
        }
    }

    private void updateFishRot(int n) {
        boolean wasHigher;
        int wanted = this.angleFromDirXY(this.fishVel[n]);
        int current = this.fishRot[n];
        int fpRotBlendRate = this.fishState[n] == 5 ? 0x1000000 : 0x200000;
        int fpRotBlend = ((fpRotBlendRate ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-fpRotBlendRate) * (long)Application.fp_deltatime >> 16)) : (int)((long)fpRotBlendRate * (long)Application.fp_deltatime >> 16);
        boolean rotLeft = false;
        int fpDeltaAngle = wanted - current;
        if (fpDeltaAngle < -8388608) {
            fpDeltaAngle += 0x1000000;
        } else if (fpDeltaAngle > 0x800000) {
            fpDeltaAngle -= 0x1000000;
        }
        if (fpDeltaAngle > 0) {
            rotLeft = true;
        }
        boolean bl = wasHigher = current > wanted;
        current = rotLeft ? (current += fpRotBlend) : (current -= fpRotBlend);
        if (current > wanted != wasHigher) {
            current = wanted;
        }
        this.fishRot[n] = current &= 0xFFFFFF;
    }

    private void updateFishTailFlapping(int n) {
        int dt = Application.fp_deltatime;
        boolean doFlap = false;
        switch (this.fishState[n]) {
            case 2: 
            case 5: {
                doFlap = true;
            }
        }
        if (doFlap) {
            int fpTailFlapRate = ((cfpFishTailFlapRateMax ^ dt) & 0x8000000) != 0 ? -((int)((long)(-cfpFishTailFlapRateMax) * (long)dt >> 16)) : (int)((long)cfpFishTailFlapRateMax * (long)dt >> 16);
            int n2 = n;
            this.fishTailPhase[n2] = this.fishTailPhase[n2] + fpTailFlapRate;
            int n3 = n;
            this.fishTailPhase[n3] = this.fishTailPhase[n3] & 0xFFFFFF;
        } else if (this.fishTailPhase[n] != 0) {
            int fpTailStopRate = ((0x1000000 ^ dt) & 0x8000000) != 0 ? -((int)(-16777216L * (long)dt >> 16)) : (int)(0x1000000L * (long)dt >> 16);
            int n4 = n;
            this.fishTailPhase[n4] = this.fishTailPhase[n4] + fpTailStopRate;
            if (this.fishTailPhase[n] > 0x1000000) {
                this.fishTailPhase[n] = 0;
            }
        }
    }

    public void scareFishAwayFromPoint(int[] pos, int radius, boolean all) {
        if (pos.length < 2) {
            System.out.println("Assertion Failure: pos.length >= 2\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[1503]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int px = pos[0];
        int py = pos[1];
        int radius2 = ((radius ^ radius) & 0x8000000) != 0 ? -((int)((long)(-radius) * (long)radius >> 16)) : (int)((long)radius * (long)radius >> 16);
        block5: for (int i = 0; i < this.numFish; ++i) {
            switch (this.fishState[i]) {
                case 0: 
                case 5: {
                    int dx = this.fishPos[i][0] - px;
                    int dy = this.fishPos[i][1] - py;
                    int len2 = (((dx ^ dx) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)dx >> 16)) : (int)((long)dx * (long)dx >> 16)) + (((dy ^ dy) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)dy >> 16)) : (int)((long)dy * (long)dy >> 16));
                    if (!all && len2 > radius2) continue block5;
                    int len = FixedPoint.sqrt_bits(len2);
                    if (len > 0) {
                        dx = (int)(((long)dx << 16) / (long)len);
                        dy = (int)(((long)dy << 16) / (long)len);
                    } else {
                        dx = 65536;
                        dy = 0;
                    }
                    this.fishVel[i][0] = ((dx ^ cfpFishScaredVel) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)cfpFishScaredVel >> 16)) : (int)((long)dx * (long)cfpFishScaredVel >> 16);
                    this.fishVel[i][1] = ((dy ^ cfpFishScaredVel) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)cfpFishScaredVel >> 16)) : (int)((long)dy * (long)cfpFishScaredVel >> 16);
                    this.fishState[i] = 5;
                    int n = this.fishScareTimer[i] = this.fishScareTimer[i] > GameLogic.randRange(cfpFishScaredTimeMin, cfpFishScaredTimeMax) ? this.fishScareTimer[i] : GameLogic.randRange(cfpFishScaredTimeMin, cfpFishScaredTimeMax);
                    if (i != this.currentFish) continue block5;
                    System.out.println("SETTING CURRENT FISH TO -1 in SCARE");
                    this.currentFish = -1;
                }
            }
        }
    }

    public void releaseFish(int n) {
        if (n < 0) {
            System.out.println("Assertion Failure: n >= 0\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[1554]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (n == -1) {
            return;
        }
        if (this.fishState[n] != 3) {
            this.fishVel[n][0] = 0;
            this.fishVel[n][1] = cfpFishScaredVel;
            this.fishState[n] = 5;
            int n2 = this.fishScareTimer[n] = this.fishScareTimer[n] > GameLogic.randRange(cfpFishScaredTimeMin, cfpFishScaredTimeMax) ? this.fishScareTimer[n] : GameLogic.randRange(cfpFishScaredTimeMin, cfpFishScaredTimeMax);
        }
        if (this.currentFish == n) {
            System.out.println("Setting fish to -1 in releaseFish");
            this.currentFish = -1;
            GameScreen.gameEffects.hideFightingFishHead();
        }
    }

    private void updateInterestedFish(int n) {
        int dy;
        if (n < 0 || n >= this.numFish) {
            System.out.println("Assertion Failure: (n>=0) && (n<numFish)\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[1575]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.fishState[n] != 1) {
            System.out.println("Assertion Failure: fishState[n] == cFishStateChaseFloat\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameLogic.java[1576]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int dt = Application.fp_deltatime;
        this.tempDir[0] = GameScreen.floatPos[0] - this.fishPos[n][0];
        this.tempDir[1] = GameScreen.floatPos[1] - this.fishPos[n][1];
        this.tempDir[2] = GameScreen.floatPos[2] - this.fishPos[n][2];
        int dx = this.tempDir[0];
        int len = FixedPoint.sqrt_bits((((dx ^ dx) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)dx >> 16)) : (int)((long)dx * (long)dx >> 16)) + ((((dy = this.tempDir[1]) ^ dy) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)dy >> 16)) : (int)((long)dy * (long)dy >> 16)));
        if (len > 0) {
            dx = (int)(((long)dx << 16) / (long)len);
            dy = (int)(((long)dy << 16) / (long)len);
        }
        int rot = this.angleFromDirXY(this.tempDir);
        if (this.fishChaseState != 3) {
            this.fishRot[n] = rot;
        }
        this.tempDir[0] = GameScreen.floatPos[0] - fishMouthPos[n][0];
        this.tempDir[1] = GameScreen.floatPos[1] - fishMouthPos[n][1];
        this.tempDir[2] = GameScreen.floatPos[2] - fishMouthPos[n][2];
        int mdx = this.tempDir[0];
        int mdy = this.tempDir[1];
        len = FixedPoint.sqrt_bits((((mdx ^ mdx) & 0x8000000) != 0 ? -((int)((long)(-mdx) * (long)mdx >> 16)) : (int)((long)mdx * (long)mdx >> 16)) + (((mdy ^ mdy) & 0x8000000) != 0 ? -((int)((long)(-mdy) * (long)mdy >> 16)) : (int)((long)mdy * (long)mdy >> 16)));
        switch (this.fishChaseState) {
            case 0: {
                int speed = cfpFishChaseBackOffSpeed;
                this.fishVel[n][0] = -(((dx ^ speed) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)speed >> 16)) : (int)((long)dx * (long)speed >> 16));
                this.fishVel[n][1] = -(((dy ^ speed) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)speed >> 16)) : (int)((long)dy * (long)speed >> 16));
                int[] nArray = this.fishPos[n];
                nArray[0] = nArray[0] + (((this.fishVel[n][0] ^ dt) & 0x8000000) != 0 ? -((int)((long)(-this.fishVel[n][0]) * (long)dt >> 16)) : (int)((long)this.fishVel[n][0] * (long)dt >> 16));
                int[] nArray2 = this.fishPos[n];
                nArray2[1] = nArray2[1] + (((this.fishVel[n][1] ^ dt) & 0x8000000) != 0 ? -((int)((long)(-this.fishVel[n][1]) * (long)dt >> 16)) : (int)((long)this.fishVel[n][1] * (long)dt >> 16));
                if (len < cfpFishChaseLineUpDist) break;
                this.fishChaseState = 1;
                break;
            }
            case 1: {
                int ndy;
                if (len < cfpFishChaseCloseDist) {
                    GameScreen.worldToScreenPos(this.fishInWaterScreenPos, fishMouthPos[this.currentFish]);
                    int sx = this.fishInWaterScreenPos[0];
                    int sy = this.fishInWaterScreenPos[1];
                    if (this.fishChaseAttackCount > 0) {
                        GameScreen.gameEffects.addEffect(1, sx, sy);
                        this.fpFishChaseBackOffDist = GameLogic.randRange(cfpFishChaseBackOffDistMin, cfpFishChaseBackOffDistMax);
                        this.fishChaseState = 2;
                        --this.fishChaseAttackCount;
                        break;
                    }
                    GameScreen.gameEffects.addEffect(2, sx, sy);
                    this.fpFishChaseTimer = cfpFishChaseStrikeTime;
                    int speed = cfpFishChaseStrikeWaitSpeed;
                    this.fishVel[n][0] = ((dx ^ speed) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)speed >> 16)) : (int)((long)dx * (long)speed >> 16);
                    this.fishVel[n][1] = ((dy ^ speed) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)speed >> 16)) : (int)((long)dy * (long)speed >> 16);
                    this.fishChaseState = 3;
                    if (!FrontEnd.vibration) break;
                    Application.display.vibrate(100);
                    break;
                }
                int speed = cfpFishChaseAttackSpeed;
                this.fishVel[n][0] = ((dx ^ speed) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)speed >> 16)) : (int)((long)dx * (long)speed >> 16);
                this.fishVel[n][1] = ((dy ^ speed) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)speed >> 16)) : (int)((long)dy * (long)speed >> 16);
                int[] nArray = this.fishPos[n];
                nArray[0] = nArray[0] + (((this.fishVel[n][0] ^ dt) & 0x8000000) != 0 ? -((int)((long)(-this.fishVel[n][0]) * (long)dt >> 16)) : (int)((long)this.fishVel[n][0] * (long)dt >> 16));
                int[] nArray3 = this.fishPos[n];
                nArray3[1] = nArray3[1] + (((this.fishVel[n][1] ^ dt) & 0x8000000) != 0 ? -((int)((long)(-this.fishVel[n][1]) * (long)dt >> 16)) : (int)((long)this.fishVel[n][1] * (long)dt >> 16));
                int mouthOffset = this.fishSize[n][1] + (this.fishSize[n][0] >> 1);
                int mouthOffsetX = ((mouthOffset ^ FixedPoint.sinLut(this.fishRot[n] + 0x400000)) & 0x8000000) != 0 ? -((int)((long)(-mouthOffset) * (long)FixedPoint.sinLut(this.fishRot[n] + 0x400000) >> 16)) : (int)((long)mouthOffset * (long)FixedPoint.sinLut(this.fishRot[n] + 0x400000) >> 16);
                int mouthOffsetY = ((mouthOffset ^ FixedPoint.sinLut(this.fishRot[n])) & 0x8000000) != 0 ? -((int)((long)(-mouthOffset) * (long)FixedPoint.sinLut(this.fishRot[n]) >> 16)) : (int)((long)mouthOffset * (long)FixedPoint.sinLut(this.fishRot[n]) >> 16);
                GameLogic.fishMouthPos[n][0] = this.fishPos[n][0] + mouthOffsetX;
                GameLogic.fishMouthPos[n][1] = this.fishPos[n][1] + mouthOffsetY;
                this.tempDir[0] = GameScreen.floatPos[0] - fishMouthPos[n][0];
                this.tempDir[1] = GameScreen.floatPos[1] - fishMouthPos[n][1];
                this.tempDir[2] = GameScreen.floatPos[2] - fishMouthPos[n][2];
                int ndx = this.tempDir[0];
                int dot = (((ndx ^ this.fishVel[n][0]) & 0x8000000) != 0 ? -((int)((long)(-ndx) * (long)this.fishVel[n][0] >> 16)) : (int)((long)ndx * (long)this.fishVel[n][0] >> 16)) + ((((ndy = this.tempDir[1]) ^ this.fishVel[n][1]) & 0x8000000) != 0 ? -((int)((long)(-ndy) * (long)this.fishVel[n][1] >> 16)) : (int)((long)ndy * (long)this.fishVel[n][1] >> 16));
                if (dot > 0) break;
                GameLogic.fishMouthPos[n][0] = GameScreen.floatPos[0];
                GameLogic.fishMouthPos[n][1] = GameScreen.floatPos[1];
                this.fishPos[n][0] = fishMouthPos[n][0] - mouthOffsetX;
                this.fishPos[n][1] = fishMouthPos[n][1] - mouthOffsetY;
                break;
            }
            case 2: {
                int speed = cfpFishChaseBackOffSpeed;
                this.fishVel[n][0] = -(((dx ^ speed) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)speed >> 16)) : (int)((long)dx * (long)speed >> 16));
                this.fishVel[n][1] = -(((dy ^ speed) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)speed >> 16)) : (int)((long)dy * (long)speed >> 16));
                int[] nArray = this.fishPos[n];
                nArray[0] = nArray[0] + (((this.fishVel[n][0] ^ dt) & 0x8000000) != 0 ? -((int)((long)(-this.fishVel[n][0]) * (long)dt >> 16)) : (int)((long)this.fishVel[n][0] * (long)dt >> 16));
                int[] nArray4 = this.fishPos[n];
                nArray4[1] = nArray4[1] + (((this.fishVel[n][1] ^ dt) & 0x8000000) != 0 ? -((int)((long)(-this.fishVel[n][1]) * (long)dt >> 16)) : (int)((long)this.fishVel[n][1] * (long)dt >> 16));
                if (len < this.fpFishChaseBackOffDist) break;
                this.fishChaseState = 1;
                break;
            }
            case 3: {
                int[] nArray = this.fishPos[n];
                nArray[0] = nArray[0] + (((this.fishVel[n][0] ^ dt) & 0x8000000) != 0 ? -((int)((long)(-this.fishVel[n][0]) * (long)dt >> 16)) : (int)((long)this.fishVel[n][0] * (long)dt >> 16));
                int[] nArray5 = this.fishPos[n];
                nArray5[1] = nArray5[1] + (((this.fishVel[n][1] ^ dt) & 0x8000000) != 0 ? -((int)((long)(-this.fishVel[n][1]) * (long)dt >> 16)) : (int)((long)this.fishVel[n][1] * (long)dt >> 16));
                this.fpFishChaseTimer -= dt;
                if (this.fpFishChaseTimer > 0) break;
                this.releaseFish(n);
                this.nextState(13);
                GameScreen.textGameInfo.clearText();
                GameScreen.textGameInfo.formatText(GameScreen.fontGame, "" + MultiLingual.get(149) + "\n");
                GameScreen.textGameInfo.formatText(GameScreen.speechFont, "" + MultiLingual.get(160) + "");
                GameScreen.textGameInfo.layout();
            }
        }
    }

    private int fishStartStrength() {
        return cFishStartStrength[this.fishType[this.currentFish]] * cfpOnePercent;
    }

    private int fishStrengthIncRate() {
        int ret = cFishStrengthIncRate[this.fishType[this.currentFish]] * 66;
        return ret;
    }

    private int fishStrengthDecRate() {
        int ret = cFishStrengthDecRate[this.fishType[this.currentFish]] * 66;
        return ret;
    }

    public int getFishFightEnergy() {
        return this.fpFishFightEnergy;
    }

    public int getFishFightTension() {
        return this.fpFishFightTension;
    }

    public int getFishFightNormalizedTension() {
        return this.fpFishFightNormalizedTension;
    }

    public boolean isPossibleToStrike() {
        return this.currentFish != -1 && this.fishState[this.currentFish] == 1 && this.fishChaseState == 3;
    }

    public static String cFishSizeNames(int i) {
        switch (i) {
            case 0: {
                return "" + MultiLingual.get(125) + "";
            }
            case 1: {
                return "" + MultiLingual.get(126) + "";
            }
            case 2: {
                return "" + MultiLingual.get(127) + "";
            }
            case 3: {
                return "" + MultiLingual.get(128) + "";
            }
            case 4: {
                return "" + MultiLingual.get(129) + "";
            }
            case 5: {
                return "" + MultiLingual.get(130) + "";
            }
        }
        return "";
    }

    static {
        dbgStateNames = new String[]{"Welcome", "Idle", "Pullback", "Casting", "LureDropping", "Fishing", "Strike", "Hooked", "Landing", "Caught", "ReelingIn", "GameOver", "ArcadeIntro", "LineBroke", "FishEscaped"};
        cfpOnePercent = FixedPoint.stringToFP("0.01");
        cFishNames = new String[]{"Tiny", "Small", "Medium", "Large", "Huge", "Scary"};
        cFishStateNames = new String[]{"Still", "Chase", "Hooked", "Reeled", "Rest", "Scared"};
        cfpSpawnPosRangeX = FixedPoint.stringToFP("20.0");
        cfpNormalSpawnPosMinY = FixedPoint.stringToFP("-8.0");
        cfpNormalSpawnPosMaxY = FixedPoint.stringToFP("2.0");
        cfpLargeSpawnPosMinY = FixedPoint.stringToFP("12.0");
        cfpLargeSpawnPosMaxY = FixedPoint.stringToFP("18.0");
        cfpSpawnVelMin = FixedPoint.stringToFP("0.5");
        cfpSpawnVelMax = FixedPoint.stringToFP("2.0");
        cfpFishScaredVel = FixedPoint.stringToFP("5");
        cfpFishScaredTimeMin = FixedPoint.stringToFP("3");
        cfpFishScaredTimeMax = FixedPoint.stringToFP("5");
        cfpFishMinX = FixedPoint.stringToFP("-21.0");
        cfpFishMaxX = FixedPoint.stringToFP("21.0");
        cfpFishMinY = FixedPoint.stringToFP("-16.0");
        cfpFishMaxY = FixedPoint.stringToFP("18.0");
        cfpFishFarMinY = FixedPoint.stringToFP("12");
        cfpFishReeledInPosY = FixedPoint.stringToFP("4");
        cfpFishTailFlapRateMax = FixedPoint.stringToFP("800");
        cFishSizes = new int[][]{{FixedPoint.stringToFP("0.4"), FixedPoint.stringToFP("0.6")}, {FixedPoint.stringToFP("0.7"), FixedPoint.stringToFP("0.8")}, {FixedPoint.stringToFP("0.8"), FixedPoint.stringToFP("0.9")}, {FixedPoint.stringToFP("0.8"), FixedPoint.stringToFP("0.9")}, {FixedPoint.stringToFP("0.8"), FixedPoint.stringToFP("0.9")}, {FixedPoint.stringToFP("0.8"), FixedPoint.stringToFP("0.9")}};
        cfpFishSizeRandomMin = FixedPoint.stringToFP("0.7");
        cfpFishSizeRandomMax = FixedPoint.stringToFP("1.0");
        fishMouthPos = new int[18][3];
        cfpFishFightTimeMin = FixedPoint.stringToFP("1.0");
        cfpFishFightTimeMax = FixedPoint.stringToFP("3.0");
        cfpFishFightWaterRange = FixedPoint.stringToFP("7");
        cfpFishFightWaterSpeed = FixedPoint.stringToFP("15");
        cfpFishFightWaterRandomMin = FixedPoint.stringToFP("2");
        cfpFishFightWaterRandomMax = FixedPoint.stringToFP("10");
        cfpFishFightAutoScareRadius = FixedPoint.stringToFP("6");
        cfpFishFightDistanceClose = FixedPoint.stringToFP("14");
        cfpFishFightDistanceMid = FixedPoint.stringToFP("22");
        cfpFishFightDistanceFar = FixedPoint.stringToFP("25");
        cfpFishFightSplashTimeMin = FixedPoint.stringToFP("0.4");
        cfpFishFightSplashTimeMax = FixedPoint.stringToFP("1.2");
        cfpFishFightStartTensionMin = FixedPoint.stringToFP("0.2");
        cfpFishFightStartTensionMax = FixedPoint.stringToFP("0.8");
        cfpFishFightTensionInc = FixedPoint.stringToFP("0.2");
        cfpFishFightTensionDec = FixedPoint.stringToFP("0.02");
        cfpFishChaseBackOffSpeed = FixedPoint.stringToFP("2");
        cfpFishChaseAttackSpeed = FixedPoint.stringToFP("8");
        cfpFishChaseLineUpDist = FixedPoint.stringToFP("2");
        cfpFishChaseBackOffDistMin = FixedPoint.stringToFP("2");
        cfpFishChaseBackOffDistMax = FixedPoint.stringToFP("5");
        cfpFishChaseCloseDist = FixedPoint.stringToFP("0.5");
        cfpFishChaseStrikeTime = FixedPoint.stringToFP("1.25");
        cfpFishChaseStrikeWaitSpeed = FixedPoint.stringToFP("1.5");
        cFishWeightMin = null;
        cFishWeightMax = null;
        cFishLureAttract = new short[5][];
        cFishStartStrength = null;
        cFishStrengthIncRate = null;
        cFishStrengthDecRate = null;
        cFishermanStats = new short[10][];
        cDayMod = new int[]{40, 60, 80, 100, 100};
        competitorID = null;
        competitorTimer = null;
        competitorFish = null;
        competitorStopCatchingTimer = 30000;
        cStrikeLimit = 2000;
        strikeTimer = 0;
        stateAfterTransition = -1;
        transitionState = 1;
        transitionTime = 0;
        transitionAmount = 0;
        currentPlace = 1;
        cutOffCatch = 0;
        totalCatch = null;
        chances = new int[5];
    }
}

