/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gfx;

import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.sys.Application;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class ImageSet {
    private Hashtable hashImageSeqCache = new Hashtable();
    private static Image imagesetimage = null;
    private static String imagesetname;
    private static Vector vecImagesets;
    private String[] source_is_anim = null;
    public static String sCharacters;
    public static final byte cFlagIsAFont = 1;
    public static final byte cFlagContainsOffsets = 2;
    public static final byte cFlagContainsSlicedImages = 4;
    public static final byte cRecordFlagXCropped = 1;
    public static final byte cRecordFlagYCropped = 2;
    public static final byte cRecordFlagSliceIndex = 4;
    public byte flags;
    public static int totalVideoMemoryUsed;

    public ImageSet(String fileName, boolean loadImages) {
        sCharacters = "";
        boolean iFrames = false;
        boolean i = false;
        System.out.println("\nTrying to Load binary imageset: " + fileName + ".idx");
        InputStream inputstream = this.getClass().getResourceAsStream(fileName + ".idx");
        if (inputstream != null) {
            this.loadImageSetBinary(fileName, inputstream, loadImages);
        } else {
            System.out.println("\n\n*******************************************************\nError: Unable to open " + fileName + "\n*******************************************************\n\n");
        }
        vecImagesets.addElement(this);
        Application.gc();
        System.out.println("Loaded Imageset");
    }

    private void loadImageSetBinary(String fileName, InputStream inputstream, boolean loadImages) {
        DataInputStream reader = new DataInputStream(inputstream);
        Application.printMemoryStatus();
        int dot = fileName.indexOf(".");
        String nameImageSet = fileName.substring(1, dot);
        try {
            int i;
            ImageSequence imageSeq;
            String labelName;
            int frames;
            short version = reader.readShort();
            this.flags = reader.readByte();
            short files = reader.readShort();
            int entries = reader.readShort();
            System.out.println("loadImageSetBinary: " + nameImageSet + " file version: " + version + " entries: " + entries + " files: " + files);
            int entry = 0;
            while (entry < entries) {
                frames = reader.readShort();
                labelName = reader.readUTF();
                System.out.println("labelName: " + labelName + " frames: " + frames);
                imageSeq = (ImageSequence)this.hashImageSeqCache.get(labelName);
                if (imageSeq != null) {
                    System.out.println("Assertion Failure: imageSeq == null with msg: " + labelName + " already exists!" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java" + "[" + 121 + "]");
                    try {
                        throw new Exception();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                imageSeq = new ImageSequence();
                this.hashImageSeqCache.put(labelName, imageSeq);
                imageSeq.setup(this.flags, frames, files);
                for (i = 0; i < frames; ++i) {
                    byte sequenceFlags = reader.readByte();
                    byte frameIndex = reader.readByte();
                    int charCode = -1;
                    String texName = frameIndex > 9 ? nameImageSet + "_" + frameIndex + ".png" : nameImageSet + "_0" + frameIndex + ".png";
                    imageSeq.addImageIfNew(texName);
                    if (imageSeq.imageIndex != null) {
                        imageSeq.imageIndex[i] = (byte)imageSeq.getImageIndex(texName);
                        if (imageSeq.imageIndex[i] == -1) {
                            System.out.println("Assertion Failure: imageSeq.imageIndex[i] != -1\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[146]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    short x = 0;
                    short y = 0;
                    short w = 0;
                    short h = 0;
                    if ((sequenceFlags & 4) != 0) {
                        w = reader.readByte();
                        h = reader.readByte();
                        for (int j = 0; j < 3; ++j) {
                            short a = reader.readShort();
                        }
                    } else {
                        x = reader.readShort();
                        y = reader.readShort();
                        w = reader.readShort();
                        h = reader.readShort();
                    }
                    short offsetx = 0;
                    short offsety = 0;
                    short offsetw = 0;
                    short offseth = 0;
                    if ((sequenceFlags & 1) != 0) {
                        offsetx = reader.readShort();
                        offsetw = reader.readShort();
                    }
                    if ((sequenceFlags & 2) != 0) {
                        offsety = reader.readShort();
                        offseth = reader.readShort();
                    }
                    if ((this.flags & 1) != 0) {
                        charCode = reader.readShort();
                    }
                    imageSeq.setRect(i, x, y, w, h, offsetx, offsety, offsetw, offseth);
                    if (loadImages) {
                        ImageSet.loadImage(imageSeq, i);
                    }
                    if ((this.flags & 1) != 0) {
                        if (charCode == -1) {
                            System.out.println("Assertion Failure: charCode != -1\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[197]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        sCharacters = sCharacters + (char)charCode;
                    }
                    ++entry;
                }
            }
            if ((this.flags & 4) != 0) {
                entries = reader.readShort();
                entry = 0;
                while (entry < entries) {
                    frames = reader.readShort();
                    labelName = reader.readUTF();
                    System.out.println("labelName: " + labelName + " frames: " + frames);
                    imageSeq = (ImageSequence)this.hashImageSeqCache.get(labelName);
                    if (imageSeq != null) {
                        System.out.println("Assertion Failure: imageSeq == null with msg: " + labelName + " already exists!" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java" + "[" + 213 + "]");
                        try {
                            throw new Exception();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    imageSeq = new ImageSequence();
                    this.hashImageSeqCache.put(labelName, imageSeq);
                    imageSeq.setup((byte)0, frames, 1);
                    for (i = 0; i < frames; ++i) {
                        short x = reader.readShort();
                        short y = reader.readShort();
                        short w = reader.readShort();
                        short h = reader.readShort();
                        imageSeq.setRect(i, x, y, w, h, 0, 0, 0, 0);
                        System.out.println(" x: " + x + " y: " + y + " w: " + w + " h: " + h);
                        ++entry;
                    }
                }
            }
            System.out.println("Finished loading imageset...");
            reader.close();
        }
        catch (IOException err) {
            System.out.println("\n\n*******************************************************\nFailed reading imageset " + err.toString() + " " + nameImageSet + "\n*******************************************************\n\n");
        }
        Application.printMemoryStatus();
    }

    public void destruct() {
        vecImagesets.removeElement(this);
    }

    public int getNumFrames(String sequenceName) {
        ImageSequence imageSeq = (ImageSequence)this.hashImageSeqCache.get(sequenceName);
        if (imageSeq == null) {
            return -1;
        }
        return imageSeq.numFrames;
    }

    public static Image loadImage(String filename) {
        Image image = ImageSet.findImageGlobal(filename);
        if (image != null) {
            return image;
        }
        Application.gc();
        Application.printMemoryStatus();
        try {
            System.out.println("Loading PNG " + filename);
            image = Image.createImage((String)filename);
            Application.printMemoryStatus();
            return image;
        }
        catch (Exception err) {
            System.out.println("null image");
            System.out.println("Imageset.loadImage(" + filename + ") Failed (too big/missing?)! " + err.toString());
            System.out.println("** Failed loading PNG " + filename + " **");
            return null;
        }
    }

    public ImageSequence getImageSequence(String sequenceName) {
        return (ImageSequence)this.hashImageSeqCache.get(sequenceName);
    }

    public static Image makeImage(String imageset, ClipRect clip) {
        Image imagesetImage = ImageSet.getImageSet(imageset);
        if (imagesetImage != null) {
            int width = (clip.x0 + clip.w < imagesetImage.getWidth() ? clip.x0 + clip.w : imagesetImage.getWidth()) - clip.x0;
            int height = (clip.y0 + clip.h < imagesetImage.getHeight() ? clip.y0 + clip.h : imagesetImage.getHeight()) - clip.y0;
            Image frame = Image.createImage((Image)imagesetImage, (int)clip.x0, (int)clip.y0, (int)width, (int)height, (int)0);
            return frame;
        }
        return null;
    }

    private String getSequenceName(String line) {
        String ret = null;
        try {
            int start = line.indexOf(47);
            int end = line.indexOf(95, start);
            ret = new String(line.substring(start + 1, end));
        }
        catch (Exception ex) {
            System.out.println("ImageSet.getSequenceName Exception on line " + line);
            ex.printStackTrace();
        }
        return ret;
    }

    private String getImageSetName(String line) {
        int start = 0;
        int end = line.indexOf(47, start);
        return new String(line.substring(start, end));
    }

    public static Image getImageSet(String name) {
        if (imagesetimage == null || imagesetname.compareTo(name) != 0) {
            imagesetimage = null;
            imagesetimage = ImageSet.loadImage("/" + name);
            imagesetname = name;
        }
        return imagesetimage;
    }

    public static void loadImage(ImageSequence imageSeq, int i) {
        byte index;
        byte by = index = imageSeq.imageIndex != null ? imageSeq.imageIndex[i] : (byte)0;
        if (imageSeq.imageFrame[index] == null) {
            String filename = (String)imageSeq.vecImageFilenames.elementAt(index);
            imageSeq.imageFrame[index] = ImageSet.getImageSet(filename);
        }
    }

    public void unloadImages() {
        Enumeration seqs;
        System.out.println("ImageSet.unloadImages()");
        if (this.hashImageSeqCache == null) {
            System.out.println("Assertion Failure: hashImageSeqCache != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[366]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((seqs = this.hashImageSeqCache.elements()) == null) {
            System.out.println("Assertion Failure: seqs != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[368]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (seqs.hasMoreElements()) {
            ImageSequence seq = (ImageSequence)seqs.nextElement();
            if (seq == null) {
                System.out.println("Assertion Failure: seq != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[371]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            seq.unload();
        }
    }

    public void reloadImages() {
        Enumeration seqs;
        System.out.println("ImageSet.reloadImages()");
        if (this.hashImageSeqCache == null) {
            System.out.println("Assertion Failure: hashImageSeqCache != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[378]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((seqs = this.hashImageSeqCache.elements()) == null) {
            System.out.println("Assertion Failure: seqs != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[380]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (seqs.hasMoreElements()) {
            ImageSequence seq = (ImageSequence)seqs.nextElement();
            if (seq == null) {
                System.out.println("Assertion Failure: seq != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[383]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            seq.reload();
        }
    }

    public static Image findImageGlobal(String filename) {
        for (int i = 0; i < vecImagesets.size(); ++i) {
            Image image = ((ImageSet)vecImagesets.elementAt(i)).findImage(filename);
            if (image == null) continue;
            return image;
        }
        return null;
    }

    public Image findImage(String filename) {
        Enumeration seqs;
        if (this.hashImageSeqCache == null) {
            System.out.println("Assertion Failure: hashImageSeqCache != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[398]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((seqs = this.hashImageSeqCache.elements()) == null) {
            System.out.println("Assertion Failure: seqs != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[400]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (seqs.hasMoreElements()) {
            ImageSequence seq = (ImageSequence)seqs.nextElement();
            if (seq == null) {
                System.out.println("Assertion Failure: seq != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[403]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (seq.imageFrame == null) {
                System.out.println("Assertion Failure: seq.imageFrame != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[404]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (int i = 0; i < seq.vecImageFilenames.size(); ++i) {
                String str = (String)seq.vecImageFilenames.elementAt(i);
                if (seq.imageFrame[i] == null || !filename.equals("/" + str)) continue;
                return seq.imageFrame[i];
            }
        }
        return null;
    }

    public void printResidentImages() {
        Enumeration seqs;
        if (this.hashImageSeqCache == null) {
            System.out.println("Assertion Failure: hashImageSeqCache != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[418]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((seqs = this.hashImageSeqCache.elements()) == null) {
            System.out.println("Assertion Failure: seqs != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[420]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Hashtable hashNames = new Hashtable();
        while (seqs.hasMoreElements()) {
            ImageSequence seq = (ImageSequence)seqs.nextElement();
            if (seq == null) {
                System.out.println("Assertion Failure: seq != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[426]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (seq.imageFrame == null) {
                System.out.println("Assertion Failure: seq.imageFrame != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSet.java[427]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (int i = 0; i < seq.vecImageFilenames.size(); ++i) {
                if (seq.imageFrame[i] == null) continue;
                hashNames.put(seq.imageFrame[i], seq.vecImageFilenames.elementAt(i));
            }
        }
        seqs = hashNames.elements();
        Enumeration seqskey = hashNames.keys();
        while (seqs.hasMoreElements()) {
            String name = (String)seqs.nextElement();
            Image image = (Image)seqskey.nextElement();
            int bytes_used = 4 * image.getWidth() * image.getHeight();
            totalVideoMemoryUsed += bytes_used;
            int kb_used = bytes_used / 1024;
            System.out.println("Image: " + name + " " + image.getWidth() + "x" + image.getHeight() + "=" + kb_used + "kb, loaded at: " + image);
        }
    }

    public static void printResidentImagesGlobal() {
        System.out.println("\n-----------------------------------------------------------\n\nprintResidentImagesGlobal():");
        totalVideoMemoryUsed = 0;
        for (int i = 0; i < vecImagesets.size(); ++i) {
            ImageSet is = (ImageSet)vecImagesets.elementAt(i);
            is.printResidentImages();
        }
        int kb_used = totalVideoMemoryUsed / 1024;
        System.out.println("Total Video Memory Used: " + kb_used + "kb");
        System.out.println("\n-----------------------------------------------------------\n\n");
    }

    static {
        vecImagesets = new Vector();
        totalVideoMemoryUsed = 0;
    }
}

