/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.util;

import com.slg.j2me.lib.sys.FixedPoint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BitVector {
    private int m_size = 0;
    private int[] m_array = null;

    public BitVector(int size, int[] data) {
        this.resize(size);
        this.setData(data);
    }

    public BitVector(int size) {
        this.resize(size);
    }

    public String toString() {
        String ret = new String();
        if (this.m_array != null) {
            for (int i = this.m_array.length - 1; i >= 0; --i) {
                ret = ret.concat(FixedPoint.maskToString(this.m_array[i], 32));
                ret = ret.concat(" ");
            }
        }
        return ret;
    }

    public void resize(int size) {
        if (this.m_size != size) {
            this.m_size = size;
            int newSize = 0;
            if (size > 0) {
                newSize = (size - 1) / 32 + 1;
            } else {
                newSize = 0;
                this.m_array = null;
            }
            if (newSize > 0) {
                int[] newarray = new int[newSize];
                int min = newSize < (this.m_array != null ? this.m_array.length : 0) ? newSize : (this.m_array != null ? this.m_array.length : 0);
                for (int i = 0; i < min; ++i) {
                    newarray[i] = this.m_array[i];
                }
                this.m_array = newarray;
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.m_array.length; ++i) {
            this.m_array[i] = 0;
        }
    }

    public void setBit(int bit) {
        if (bit < 0 || bit >= this.m_size) {
            System.out.println("Assertion Failure: bit >= 0 && bit < m_size with msg: " + bit + " is out of bounds" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\util/BitVector.java" + "[" + 108 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int n = bit >> 5;
        this.m_array[n] = this.m_array[n] | 1 << (bit & 0x1F);
    }

    public boolean isBitSet(int bit) {
        if (bit < 0 || bit >= this.m_size) {
            System.out.println("Assertion Failure: bit >= 0 && bit < m_size with msg: " + bit + " is out of bounds" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\util/BitVector.java" + "[" + 116 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (this.m_array[bit >> 5] & 1 << (bit & 0x1F)) != 0;
    }

    public void flipBit(int bit) {
        if (bit < 0 || bit >= this.m_size) {
            System.out.println("Assertion Failure: bit >= 0 && bit < m_size with msg: " + bit + " is out of bounds" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\util/BitVector.java" + "[" + 123 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int n = bit >> 5;
        this.m_array[n] = this.m_array[n] ^ 1 << (bit & 0x1F);
    }

    public void clearBit(int bit) {
        if (bit < 0 || bit >= this.m_size) {
            System.out.println("Assertion Failure: bit >= 0 && bit < m_size with msg: " + bit + " is out of bounds" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\util/BitVector.java" + "[" + 130 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int n = bit >> 5;
        this.m_array[n] = this.m_array[n] & ~(1 << (bit & 0x1F));
    }

    public void setData(int[] data) {
        if (data.length != this.m_array.length) {
            System.out.println("Assertion Failure: data.length == m_array.length with msg: The source and dest data have different sizes\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\util/BitVector.java[137]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < data.length; ++i) {
            this.m_array[i] = data[i];
        }
    }

    public int[] getData() {
        return this.m_array;
    }

    public int size() {
        return this.m_size;
    }

    public boolean anySet() {
        for (int i = 0; i < this.m_array.length; ++i) {
            if (this.m_array[i] == 0) continue;
            return true;
        }
        return false;
    }

    public boolean noneSet() {
        for (int i = 0; i < this.m_array.length; ++i) {
            if (this.m_array[i] == 0) continue;
            return false;
        }
        return true;
    }

    public int getNextSetBit(int from) {
        for (int i = from; i < this.m_size; ++i) {
            if (!this.isBitSet(i)) continue;
            return i;
        }
        return -1;
    }

    public void performOR(BitVector rhs) {
        int[] rhsData = rhs.getData();
        if (rhsData.length != this.m_array.length) {
            System.out.println("Assertion Failure: rhsData.length == m_array.length with msg: Must be of same size!\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\util/BitVector.java[189]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < this.m_array.length; ++i) {
            int n = i;
            this.m_array[n] = this.m_array[n] | rhsData[i];
        }
    }

    public void performAND(BitVector rhs) {
        int[] rhsData = rhs.getData();
        if (rhsData.length != this.m_array.length) {
            System.out.println("Assertion Failure: rhsData.length == m_array.length with msg: Must be of same size!\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\util/BitVector.java[198]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < this.m_array.length; ++i) {
            int n = i;
            this.m_array[n] = this.m_array[n] & rhsData[i];
        }
    }

    public void performXOR(BitVector rhs) {
        int[] rhsData = rhs.getData();
        if (rhsData.length != this.m_array.length) {
            System.out.println("Assertion Failure: rhsData.length == m_array.length with msg: Must be of same size!\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\util/BitVector.java[207]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < this.m_array.length; ++i) {
            int n = i;
            this.m_array[n] = this.m_array[n] ^ rhsData[i];
        }
    }

    public void inverseIntersection(BitVector rhs) {
        this.performXOR(rhs);
        this.performAND(rhs);
    }

    public void load(DataInputStream stream) throws IOException {
        int size = stream.readInt();
        this.resize(size);
        for (int i = 0; i < this.m_array.length; ++i) {
            this.m_array[i] = stream.readInt();
            System.out.println("BIT:" + this.m_array[i]);
        }
    }

    public void save(DataOutputStream stream) throws IOException {
        stream.writeInt(this.m_size);
        for (int i = 0; i < this.m_array.length; ++i) {
            stream.writeInt(this.m_array[i]);
        }
    }
}

