/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gui.layout;

import com.slg.j2me.game.GameApp;
import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.gui.BitmapFont;
import com.slg.j2me.lib.gui.Transition;
import com.slg.j2me.lib.gui.control.ControlHandler;
import com.slg.j2me.lib.gui.control.GuiContainer;
import com.slg.j2me.lib.gui.control.GuiControl;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import com.slg.j2me.lib.gui.layout.TextScrollLayout;
import com.slg.j2me.lib.sys.Application;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class ScreenStack
extends BaseScreen
implements ControlHandler {
    public static ScreenStack instance;
    protected Vector screenStack;
    public static ScreenLayout currentContainer;
    public static ScreenLayout nextScreen;
    public Image backgroundImage = null;
    public int colBackground = -1;
    public int menuButtons = 0;
    private int lastKeyCode = 0;
    public static int menuButtonHeight;
    public static TextScrollLayout confirmDialog;
    public static int confirmYesEvent;
    public static int confirmNoEvent;
    private boolean popPreviousScreenOnScreenOpen = false;
    public static BitmapFont font;
    public static BitmapFont fontSmall;
    public static BitmapFont fontSmallTight;
    public static ImageSequence gfxButtonIcons;
    public static final int eScreenOpening = 0;
    public static final int eScreenOpen = 1;
    public static final int eScreenForward = 2;
    public static final int eScreenBack = 3;
    public static int screenState;
    public static final int eventTransitionFinished = 1;
    public static final int eventWipeFinished = 2;
    private static Vector taskList;
    private static Vector eventList;
    public static GuiControl ctrlLeftSoftKey;
    public static GuiControl ctrlRightSoftKey;
    public static int wipeDirection;
    public static int lastWipeDirection;
    public static Image imgWipeScreen;
    public static GuiControl wipeContainer;
    public static ClipRect wipeClip;
    public static int wipeOffsetX;
    public static int wipeOffsetY;
    public static boolean wipeInProgress;
    private String lastImage = "";
    private boolean confirmTransition = false;
    int buttonsChanged = 0;
    int controlsAdded = 3;
    static final int cHighButton = 1;
    static final int cWideButton = 4;
    private static ClipRect textClip;

    public ScreenStack() {
        super(false);
        instance = this;
        this.screenStack = new Vector();
    }

    public abstract void open();

    public abstract void onScreenOpen(ScreenLayout var1);

    public abstract void controlExecuted(ScreenLayout var1, GuiControl var2);

    public void setBackgroundColour(int colour) {
        this.colBackground = colour;
    }

    public void loadImage(String filename) {
        if (this.backgroundImage != null && filename.equals(this.lastImage)) {
            return;
        }
        this.lastImage = filename;
        this.backgroundImage = ImageSet.loadImage(filename);
        if (this.backgroundImage != null) {
            BaseScreen.forcePaint();
        }
    }

    public void open(ScreenLayout screenToOpen) {
        this.screenStack.setSize(0);
        System.out.println("CLEARING EVENTS!!\n");
        ScreenStack.clearTasks();
        ScreenStack.clearEvents();
        this.pushScreen(screenToOpen, false);
        this.doScreenState(0);
    }

    public void popScreenUntil(ScreenLayout screen, ScreenLayout screen2) {
        this.outputScreenStack();
        System.out.println("popScreenUntil");
        ScreenLayout top = (ScreenLayout)this.screenStack.elementAt(this.screenStack.size() - 1);
        int sanity = this.screenStack.size() + 2;
        while (screen != top && screen2 != top && --sanity > 0) {
            top = (ScreenLayout)this.screenStack.elementAt(this.screenStack.size() - 1);
            if (screen != top && screen2 != top) {
                top.close();
                this.screenStack.removeElementAt(this.screenStack.size() - 1);
                continue;
            }
            if (screen == top) {
                currentContainer = screen;
                continue;
            }
            if (screen2 != top) continue;
            currentContainer = screen2;
        }
        if (sanity <= 0) {
            System.out.println("Assertion Failure: sanity>0\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/ScreenStack.java[228]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.menuButtons = 0;
        if (ScreenStack.currentContainer.controlHandler == null) {
            ScreenStack.currentContainer.controlHandler = this;
        }
        if (currentContainer != GameApp.gameScreen) {
            this.onScreenOpen(currentContainer);
        }
        currentContainer.open();
        BaseScreen.resetKeys();
        this.outputScreenStack();
    }

    public void popPreviousScreen() {
        if (this.screenStack.size() > 1) {
            this.screenStack.removeElementAt(this.screenStack.size() - 2);
        } else if (this.screenStack.size() <= 1) {
            System.out.println("Assertion Failure: screenStack.size()>1\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/ScreenStack.java[254]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void pushScreen(ScreenLayout container, boolean transition) {
        System.out.println("FrontEnd.pushScreen()");
        this.outputScreenStack();
        nextScreen = container;
        if (transition) {
            this.doScreenState(2);
        } else {
            this.doScreenState(1);
            this.pushScreenInternal();
        }
        this.outputScreenStack();
    }

    public void popScreen(boolean transition) {
        System.out.println("FrontEnd.back()");
        if (transition) {
            this.doScreenState(3);
        } else {
            this.doScreenState(1);
            this.popScreenInternal();
        }
    }

    public void popScreens(int how_many, boolean transition) {
        for (int i = 1; i < how_many; ++i) {
            this.popScreenInternal();
        }
        this.popScreen(transition);
    }

    private boolean popScreenInternal() {
        System.out.println("FrontEnd.popScreenInternal()");
        BaseScreen.resetKeys();
        if (currentContainer != null) {
            currentContainer.close();
            this.screenStack.removeElementAt(this.screenStack.size() - 1);
            if (this.screenStack.size() > 0) {
                currentContainer = (ScreenLayout)this.screenStack.elementAt(this.screenStack.size() - 1);
                this.onScreenOpen(currentContainer);
                currentContainer.open();
            } else {
                currentContainer = null;
            }
        }
        if (currentContainer == null) {
            this.open();
        }
        return currentContainer != null;
    }

    public ScreenLayout getPreviousScreen() {
        if (this.screenStack.size() > 1) {
            return (ScreenLayout)this.screenStack.elementAt(this.screenStack.size() - 2);
        }
        return null;
    }

    private void pushScreenInternal() {
        System.out.println("FrontEnd.pushScreenInternal()");
        if (nextScreen == null) {
            System.out.println("Assertion Failure: nextScreen != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/ScreenStack.java[357]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (nextScreen == null) {
            return;
        }
        if (currentContainer != null) {
            currentContainer.close();
        }
        currentContainer = nextScreen;
        this.screenStack.addElement(nextScreen);
        if (ScreenStack.currentContainer.controlHandler == null) {
            ScreenStack.currentContainer.controlHandler = this;
        }
        this.menuButtons = 0;
        if (nextScreen != GameApp.gameScreen) {
            this.onScreenOpen(nextScreen);
        }
        BaseScreen.resetKeys();
        currentContainer.open();
        if (this.popPreviousScreenOnScreenOpen) {
            System.out.println("popping previous dialog");
            this.popPreviousScreen();
            this.popPreviousScreenOnScreenOpen = false;
        }
    }

    public void outputScreenStack() {
        for (int i = this.screenStack.size() - 1; i >= 0; --i) {
            ScreenLayout s = (ScreenLayout)this.screenStack.elementAt(i);
            if (s == null) continue;
            System.out.println("[" + i + "] = " + s + ": " + s.dbgname);
        }
        System.out.println("MenuButtons: " + this.menuButtons);
    }

    public void pushDialog(ScreenLayout dialog) {
        BaseScreen.resetKeys();
        currentContainer = dialog;
        ScreenStack.currentContainer.controlHandler = this;
        currentContainer.open();
        this.screenStack.addElement(currentContainer);
    }

    public void popDialog() {
        BaseScreen.resetKeys();
        if (currentContainer != null) {
            currentContainer.close();
            this.screenStack.removeElement(currentContainer);
            if (this.screenStack.size() > 0) {
                currentContainer = (ScreenLayout)this.screenStack.elementAt(this.screenStack.size() - 1);
                this.onScreenOpen(currentContainer);
            } else {
                currentContainer = null;
            }
        }
    }

    public void openConfirmDialog(String message, int eventYes, int eventNo, boolean noTransition) {
        confirmYesEvent = eventYes;
        confirmNoEvent = eventNo;
        this.confirmTransition = !noTransition;
        confirmDialog = new TextScrollLayout();
        ScreenStack.confirmDialog.textLayout.iLayoutFlags = 3;
        ScreenStack.confirmDialog.clipRect.y0 = 0;
        ScreenStack.confirmDialog.clipRect.h = (short)(BaseScreen.displayHeight - menuButtonHeight);
        ScreenStack.confirmDialog.textLayout.formatText(fontSmall, message);
        confirmDialog.layout();
        System.out.println("openConfirmDialog: " + message);
        this.pushScreen(confirmDialog, !noTransition);
    }

    public void handleEvent(int event) {
        System.out.println("handleEvent() - " + event);
        block0 : switch (event) {
            case 1: {
                switch (screenState) {
                    case 0: {
                        this.doScreenState(1);
                        break block0;
                    }
                    case 2: {
                        if (wipeDirection != 0) {
                            lastWipeDirection = wipeDirection;
                            this.startWipe();
                            instance.pushScreenInternal();
                            break block0;
                        }
                        lastWipeDirection = 0;
                        instance.pushScreenInternal();
                        this.doScreenState(0);
                        break block0;
                    }
                    case 3: {
                        if (lastWipeDirection != 0) {
                            if ((lastWipeDirection & 1) != 0) {
                                wipeDirection = 2;
                            }
                            if ((lastWipeDirection & 4) != 0) {
                                wipeDirection = 8;
                            }
                            this.startWipe();
                            instance.popScreenInternal();
                            break block0;
                        }
                        instance.popScreenInternal();
                        this.doScreenState(0);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                wipeDirection = 0;
                wipeInProgress = false;
                this.doScreenState(0);
            }
        }
    }

    public void startWipe() {
        imgWipeScreen = Image.createImage((int)BaseScreen.displayWidth, (int)BaseScreen.displayHeight);
        Graphics g = imgWipeScreen.getGraphics();
        this.paintInternal(g);
        ScreenStack.wipeContainer.clipRect.x0 = 0;
        ScreenStack.wipeContainer.clipRect.y0 = 0;
        ScreenStack.doTransition(wipeContainer, wipeDirection, 0, 500);
        ScreenStack.addEvent(2, 500);
        if ((wipeDirection & 0xC) != 0) {
            wipeOffsetX = 0;
            wipeOffsetY = (wipeDirection & 4) != 0 ? (int)ScreenStack.wipeClip.h : (int)(-ScreenStack.wipeClip.h);
        } else {
            wipeOffsetY = 0;
            wipeOffsetX = (wipeDirection & 1) != 0 ? (int)ScreenStack.wipeClip.w : (int)(-ScreenStack.wipeClip.w);
        }
        wipeInProgress = true;
    }

    public void drawButton(Graphics g, int side, String label, int y0, int h, int t, int icon) {
        int y1 = y0 + (h - fontSmallTight.getFontHeight()) / 2;
        int y2 = y0 + (h - gfxButtonIcons.getRectHeight(icon)) / 2;
        y1 = y1 < BaseScreen.displayHeight - fontSmallTight.getFontHeight() ? y1 : BaseScreen.displayHeight - fontSmallTight.getFontHeight();
        y2 = y2 < BaseScreen.displayHeight - gfxButtonIcons.getRectHeight(icon) ? y2 : BaseScreen.displayHeight - gfxButtonIcons.getRectHeight(icon);
        int bw = gfxButtonIcons.getRectWidth(4) + BaseScreen.getScaledX(4);
        ScreenStack.textClip.w = fontSmallTight.getTextWidth(label);
        ScreenStack.textClip.h = fontSmallTight.getFontHeight();
        ScreenStack.textClip.y0 = (short)y1;
        if (side == 0) {
            int dx = ScreenStack.textClip.w * t < 0 ? -(-(ScreenStack.textClip.w * t) >> 16) : ScreenStack.textClip.w * t >> 16;
            ScreenStack.textClip.x0 = (short)bw;
            fontSmallTight.drawText(g, label, bw - dx, y1, textClip);
            short w = gfxButtonIcons.getRectWidth(icon);
            gfxButtonIcons.drawImage(g, icon, (bw - w) / 2, y2);
        } else {
            ScreenStack.textClip.x0 = (short)(BaseScreen.displayWidth - ScreenStack.textClip.w - bw);
            int dx = ScreenStack.textClip.w * t < 0 ? -(-(ScreenStack.textClip.w * t) >> 16) : ScreenStack.textClip.w * t >> 16;
            fontSmallTight.drawText(g, label, BaseScreen.displayWidth - ScreenStack.textClip.w - bw + dx, y1, textClip);
            short w = gfxButtonIcons.getRectWidth(icon);
            gfxButtonIcons.drawImage(g, icon, BaseScreen.displayWidth - bw + (bw - w) / 2, y2);
        }
    }

    public void paintInternal(Graphics g) {
        if (currentContainer == null) {
            g.setColor(this.colBackground);
            g.fillRect(0, 0, BaseScreen.displayWidth, BaseScreen.displayHeight);
        }
        if (currentContainer != null) {
            currentContainer.paint(g);
        } else if (this.backgroundImage != null) {
            g.drawImage(this.backgroundImage, (BaseScreen.displayWidth - this.backgroundImage.getWidth()) / 2, (BaseScreen.displayHeight - this.backgroundImage.getHeight()) / 2, 0x10 | 4);
        }
    }

    private void dismissDialog(ScreenLayout dialog) {
        if (this.getPreviousScreen() == dialog) {
            System.out.println("\n\n*******************************************************\nprevious screen is now our dialog, remove it\n*******************************************************\n\n");
            this.popPreviousScreen();
        } else if (currentContainer == dialog && nextScreen == null) {
            System.out.println("\n\n*******************************************************\nNo action taken, popping confirm screen\n*******************************************************\n\n");
            this.popScreen(true);
        } else if (currentContainer == dialog && nextScreen != null) {
            System.out.println("\n\n*******************************************************\nnew screen has been pushed\n*******************************************************\n\n");
            this.popPreviousScreenOnScreenOpen = true;
        } else {
            System.out.println("\n\n*******************************************************\nunknown state\n*******************************************************\n\n");
        }
    }

    public void process() {
        super.process();
        if (!BaseScreen.pauseDialogShown) {
            ScreenStack.processEvents();
            ScreenStack.processTasks();
            if (!wipeInProgress) {
                if (currentContainer == confirmDialog) {
                    if (screenState == 1) {
                        if (BaseScreen.keysPressed(32768)) {
                            this.popScreen(this.confirmTransition);
                            this.handleEvent(confirmYesEvent);
                            return;
                        }
                        if (BaseScreen.keysPressed(65536) && confirmNoEvent != -1) {
                            this.popScreen(this.confirmTransition);
                            this.handleEvent(confirmNoEvent);
                            return;
                        }
                    }
                } else {
                    if (screenState == 1) {
                        if ((this.menuButtons & 1) != 0 && BaseScreen.keysPressed(65536)) {
                            System.out.println("BUTTON_BACK");
                            this.popScreen(true);
                            return;
                        }
                        if (BaseScreen.keysPressed(32768)) {
                            ScreenStack.currentContainer.controlHandler.controlExecuted(currentContainer, ctrlLeftSoftKey);
                        }
                        if (BaseScreen.keysPressed(65536)) {
                            ScreenStack.currentContainer.controlHandler.controlExecuted(currentContainer, ctrlRightSoftKey);
                        }
                    }
                    if (currentContainer != null) {
                        currentContainer.process();
                    }
                }
            }
        }
    }

    public static final void doTransition(GuiContainer control, int trans_type, int delay, int time) {
        int dx = 0;
        int dy = 0;
        if ((trans_type & 1) != 0) {
            dx = -(control.clipRect.x0 + control.clipRect.w + 16);
        }
        if ((trans_type & 2) != 0) {
            dx = BaseScreen.displayWidth - control.clipRect.x0 + 16;
        }
        if ((trans_type & 4) != 0) {
            dy = -(control.clipRect.y0 + control.clipRect.h + 16);
        }
        if ((trans_type & 8) != 0) {
            dy = BaseScreen.displayHeight - control.clipRect.y0 + 16;
        }
        if ((trans_type & 0x10) != 0) {
            control.clipRect.x0 = (short)(control.clipRect.x0 + dx);
            control.clipRect.y0 = (short)(control.clipRect.y0 + dy);
            dx = -dx;
            dy = -dy;
        }
        Transition trans = new Transition(delay, time, control, 0, dx, dy);
        ScreenStack.startTask(trans);
    }

    public void doScreenState(int newState) {
        if (newState != screenState || newState == 2) {
            int n = this.setScreenState(newState);
        } else {
            System.out.println("Not setting ScreenState, already in state " + newState);
        }
    }

    protected int setScreenState(int newState) {
        if (screenState == 0 && (newState == 2 || newState == 3)) {
            ScreenStack.clearTasks();
            ScreenStack.clearEvents();
        }
        screenState = newState;
        return 0;
    }

    public static final void startTask(Transition task) {
        taskList.addElement(task);
    }

    public static final void clearTasks() {
        taskList.removeAllElements();
    }

    public static final void finishTask(Transition task) {
        taskList.removeElement(task);
    }

    public static final void processTasks() {
        for (int i = 0; i < taskList.size(); ++i) {
            Transition task = (Transition)taskList.elementAt(i);
            task.process();
        }
    }

    public static final void processEvents() {
        for (int i = 0; i < eventList.size(); ++i) {
            int[] eh = (int[])eventList.elementAt(i);
            eh[1] = eh[1] - Application.lastFrameTime;
            if (eh[1] > 0) continue;
            System.out.println("Firing event " + eh[0]);
            instance.handleEvent(eh[0]);
            eventList.removeElementAt(i);
            --i;
        }
    }

    public static final void addEvent(int event, int delay) {
        System.out.println("Adding Event " + event);
        int[] eh = new int[]{event, delay};
        eventList.addElement(eh);
    }

    public static final void clearEvents() {
        for (int i = 0; i < eventList.size(); ++i) {
            int[] eh = (int[])eventList.elementAt(i);
            if (eh[0] >= 2) continue;
            eventList.removeElementAt(i);
            --i;
        }
    }

    static {
        menuButtonHeight = 16;
        confirmDialog = new TextScrollLayout();
        confirmYesEvent = 1;
        confirmNoEvent = 2;
        screenState = 0;
        taskList = new Vector();
        eventList = new Vector();
        ctrlLeftSoftKey = new GuiControl(true);
        ctrlRightSoftKey = new GuiControl(true);
        wipeDirection = 0;
        lastWipeDirection = 0;
        imgWipeScreen = null;
        wipeContainer = new GuiControl(false);
        wipeClip = new ClipRect(0, 0, BaseScreen.displayWidth, BaseScreen.displayHeight);
        wipeOffsetX = 0;
        wipeOffsetY = 0;
        wipeInProgress = false;
        textClip = new ClipRect(0, 0, 0, 0);
    }
}

