/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.game.GameLogic;
import com.slg.j2me.game.GameScreen;
import com.slg.j2me.game.GameSequence;
import com.slg.j2me.game.HiscoreTable;
import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.GfxUtils;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.gui.BitmapFont;
import com.slg.j2me.lib.gui.image.TextImage;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.sys.FixedPoint;
import com.slg.j2me.lib.util.MultiLingual;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class WeighInScreen
extends ScreenLayout {
    private TextImage textTitle;
    private static int cNumFinalists = 4;
    private static final int cNumFish = 3;
    private static final int cDropTime = 400;
    private static final int cSplashTime = 200;
    private static final int cFishWiggleTime = 200;
    private static final int cBlinkTime = 500;
    private static int dropTimer = -1;
    private static int fishTimer = 0;
    private static int swapTimer = 0;
    private static int blinkTimer = 0;
    private static int fishFrame = 0;
    private static int drawFishSize = 0;
    private static final int cSwapTime = 1000;
    private static int fishY = 0;
    private static final String[] cNames = new String[]{"F. Miller", "F. Sala", "M. Lewis", "K. Harris", "S. Green", "H. Hill", "F. Lopez", "A. Carter", "I. King", "J. Price", "V. Cox", "N. Wood"};
    private int iWeightCounterToProcess = -1;
    private int iFishToProcess = -1;
    private int[] weightCounterAmounts;
    private int[] weightIncrements;
    private int[] weightCounterTargets;
    private int[] iPaintOrder;
    private int[] iOldOrder;
    private String[] strPlayerNames;
    private int usedNames = 0;
    private static ImageSet isWeigh;
    private static ImageSet isSplash;
    private static ImageSet isDigits;
    private static ImageSequence gfxTankOverlay;
    private static ImageSequence gfxTankNumbers;
    private static ImageSequence gfxTankBars;
    private static ImageSequence[] gfxTankFish;
    private static ImageSequence gfxSplashLeft;
    private static ImageSequence gfxSplashRight;
    private Image weighInBG;
    private static BitmapFont fontDigits;
    static boolean bHaveDigitsFont;
    private static String strPound;
    private static String strOunce;
    private static String totalstrPound;
    private static String totalstrOunce;
    private static int totalWeight;
    private static int totalpounds;
    private static int totalounces;
    int cTankX;
    int cTankY;
    int numberX;
    int numberY;
    int splashFrame = 0;
    int sequenceTimer = -1;
    private boolean startedCounting = false;

    private static final String cFishIntro(int i) {
        switch (i) {
            case 0: {
                return "" + MultiLingual.get(369) + "";
            }
            case 1: {
                return "" + MultiLingual.get(370) + "";
            }
            case 2: {
                return "" + MultiLingual.get(371) + "";
            }
        }
        return "";
    }

    public WeighInScreen() {
        super("WeighInScreen");
        System.out.println("WeighinScreen Constructor");
        isWeigh = new ImageSet("/weigh.is", false);
        WeighInScreen.gfxTankFish[0] = isWeigh.getImageSequence("tank-fish-small");
        WeighInScreen.gfxTankFish[1] = isWeigh.getImageSequence("tank-fish");
        WeighInScreen.gfxTankFish[2] = isWeigh.getImageSequence("tank-fish-big");
        gfxTankOverlay = isWeigh.getImageSequence("tank-overlay");
        gfxTankNumbers = isWeigh.getImageSequence("weigh-in-numbers");
        gfxTankBars = isWeigh.getImageSequence("weigh-in-bars");
        if (gfxTankNumbers == null) {
            System.out.println("Assertion Failure: gfxTankNumbers != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[116]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxTankBars == null) {
            System.out.println("Assertion Failure: gfxTankBars != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[117]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxTankFish[0] == null) {
            System.out.println("Assertion Failure: gfxTankFish[0] != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[118]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxTankFish[1] == null) {
            System.out.println("Assertion Failure: gfxTankFish[1] != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[119]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxTankFish[2] == null) {
            System.out.println("Assertion Failure: gfxTankFish[2] != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[120]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxTankOverlay == null) {
            System.out.println("Assertion Failure: gfxTankOverlay != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[121]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        isSplash = new ImageSet("/effects.is", false);
        gfxSplashLeft = isSplash.getImageSequence("splash-big-left");
        gfxSplashRight = isSplash.getImageSequence("splash-big-right");
        if (gfxSplashLeft == null) {
            System.out.println("Assertion Failure: gfxSplashLeft != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[126]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxSplashRight == null) {
            System.out.println("Assertion Failure: gfxSplashRight != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[127]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int iHeight = BaseScreen.getScaledY(10);
        this.textTitle = new TextImage(ScreenStack.font, "" + MultiLingual.get(368) + "");
        bHaveDigitsFont = false;
        fontDigits = ScreenStack.fontSmall;
    }

    public void load() {
        System.out.println("WeighInScreen.load()");
        this.weighInBG = ImageSet.loadImage("/weigh-in.png");
        try {
            isWeigh.reloadImages();
            isSplash.reloadImages();
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nWeighInScreen.load() - exception: " + e + "\n*******************************************************\n\n");
            e.printStackTrace();
        }
        this.cTankX = BaseScreen.getScaledX(107);
        this.cTankY = BaseScreen.getScaledY(83);
        this.numberX = BaseScreen.getScaledX(5);
        this.numberY = BaseScreen.displayHeight - gfxTankNumbers.getRectHeight(0) - 1;
    }

    public void unload() {
        System.out.println("WeighInScreen.unload()");
        this.weighInBG = null;
        try {
            isWeigh.unloadImages();
            isSplash.unloadImages();
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nWeighInScreen.load() - exception: " + e + "\n*******************************************************\n\n");
            e.printStackTrace();
        }
    }

    private String getUnusedName() {
        if (FrontEnd.gameType == 0) {
            return "";
        }
        int roll = GameLogic.randRange(0, cNames.length - 1);
        int left = cNames.length - FixedPoint.getBitCount(this.usedNames);
        if (left <= 0) {
            System.out.println("Assertion Failure: left > 0\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[230]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int count = 0;
        while (true) {
            int name;
            if ((this.usedNames & 1 << (name = count % cNames.length)) == 0 && count >= roll) {
                this.usedNames |= 1 << name;
                return cNames[name];
            }
            ++count;
        }
    }

    public void open() {
        this.load();
        cNumFinalists = FrontEnd.gameType == 0 ? 1 : 4;
        this.weightCounterAmounts = new int[cNumFinalists];
        this.weightIncrements = new int[cNumFinalists];
        this.weightCounterTargets = new int[cNumFinalists];
        this.iPaintOrder = new int[cNumFinalists];
        this.iOldOrder = new int[cNumFinalists];
        this.strPlayerNames = new String[cNumFinalists];
        System.out.println("WeighInScreen.open");
        totalWeight = 0;
        totalpounds = 0;
        totalounces = 0;
        if (FrontEnd.gameType == 0) {
            super.open();
            this.usedNames = 0;
            this.iPaintOrder[0] = 0;
            this.weightCounterTargets[0] = 0;
            this.weightCounterAmounts[0] = 0;
            for (int f = 0; f < GameLogic.competitorFish[0].length; ++f) {
                System.out.println("FISH: " + GameLogic.competitorFish[0][f]);
            }
            this.iWeightCounterToProcess = -1;
            this.iFishToProcess = GameScreen.arcadeFishCaught;
            int iHeight = BaseScreen.getScaledY(10);
            this.textTitle = new TextImage(ScreenStack.font, "" + MultiLingual.get(368) + "");
            this.textTitle.clipRect.x0 = (short)(BaseScreen.displayWidth - this.textTitle.clipRect.w >> 1);
            fishY = 0;
            fishFrame = 0;
            this.sequenceTimer = -1;
            this.startedCounting = false;
        } else {
            if (GameLogic.competitorFish.length != 4) {
                System.out.println("Assertion Failure: GameLogic.competitorFish.length == 4\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[304]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            super.open();
            this.usedNames = 0;
            this.iPaintOrder[0] = 0;
            this.iPaintOrder[1] = 1;
            this.iPaintOrder[2] = 2;
            this.iPaintOrder[3] = 3;
            for (int i = 0; i < cNumFinalists; ++i) {
                this.weightCounterTargets[i] = 0;
                this.weightCounterAmounts[i] = 0;
                this.strPlayerNames[i] = i == 0 ? "" + MultiLingual.get(322) + "" : this.getUnusedName();
                GameLogic.SORT_shellSortNC(GameLogic.competitorFish[i], null, true, null);
                System.out.println("Player: " + this.strPlayerNames[i] + " HAS FISH ");
                for (int f = 0; f < GameLogic.competitorFish[i].length; ++f) {
                    System.out.println("FISH: " + GameLogic.competitorFish[i][f]);
                }
            }
            this.iWeightCounterToProcess = -1;
            this.iFishToProcess = -1;
            int iHeight = BaseScreen.getScaledY(10);
            this.textTitle = new TextImage(ScreenStack.font, "" + MultiLingual.get(368) + "");
            this.textTitle.clipRect.x0 = (short)(BaseScreen.displayWidth - this.textTitle.clipRect.w >> 1);
            fishFrame = 0;
        }
        this.sequenceTimer = -1;
    }

    public void close() {
        super.close();
        this.unload();
    }

    public void layout() {
        super.layout();
    }

    private boolean hasCounterReachedTargetWeight() {
        return this.iWeightCounterToProcess == -1 || this.weightCounterAmounts[this.iPaintOrder[this.iWeightCounterToProcess]] >= this.weightCounterTargets[this.iPaintOrder[this.iWeightCounterToProcess]] && dropTimer <= 0;
    }

    private int lerpPercent(int percent, int a, int b) {
        if (percent < 0 || percent > 100) {
            System.out.println("Assertion Failure: percent >= 0 && percent <= 100 with msg: " + percent + " is invalid" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java" + "[" + 376 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int res = (b - a) * percent;
        return res / 100;
    }

    private int findPlace(int[] places, int player) {
        for (int i = 0; i < places.length; ++i) {
            if (places[i] != player) continue;
            return i;
        }
        System.out.println("Assertion Failure: false\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[385]");
        try {
            throw new Exception();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void paint(Graphics g) {
        if (FrontEnd.gameType == 0) {
            this.paintArcade(g);
        } else {
            int player;
            if (this.weighInBG != null) {
                if (ImageSequence.clipSet) {
                    g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                    ImageSequence.clipSet = false;
                }
                g.drawImage(this.weighInBG, 0, 0, 20);
            } else {
                if (ImageSequence.clipSet) {
                    g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                    ImageSequence.clipSet = false;
                }
                g.setColor(8828866);
                g.fillRect(0, 0, BaseScreen.displayWidth, BaseScreen.displayHeight);
            }
            super.paint(g);
            int spacingY = (gfxTankNumbers.getRectHeight(0) - 4 * gfxTankBars.getRectHeight(0)) / 3;
            gfxTankNumbers.drawImage(g, 0, this.numberX, this.numberY);
            if (this.iWeightCounterToProcess >= 0 && this.iWeightCounterToProcess < cNumFinalists) {
                if (swapTimer == 0 && this.iWeightCounterToProcess == 0 && this.iFishToProcess < 3) {
                    short w = ScreenStack.font.getTextWidth(WeighInScreen.cFishIntro(this.iFishToProcess));
                    ScreenStack.font.drawText(g, WeighInScreen.cFishIntro(this.iFishToProcess), BaseScreen.displayWidth / 2 - w / 2, this.textTitle.clipRect.y0 + this.textTitle.clipRect.h * 3 / 2, BaseScreen.visibleRect);
                }
                int iIndex = this.iPaintOrder[this.iWeightCounterToProcess];
                if (swapTimer == 0) {
                    int n = this.weightCounterAmounts[iIndex] = this.weightCounterTargets[iIndex] < this.weightCounterAmounts[iIndex] + 1 ? this.weightCounterTargets[iIndex] : this.weightCounterAmounts[iIndex] + 1;
                    if (dropTimer > 0) {
                        int n2 = dropTimer = 0 > dropTimer - Application.lastFrameTime ? 0 : dropTimer - Application.lastFrameTime;
                    }
                }
                if (this.hasCounterReachedTargetWeight()) {
                    this.weightCounterAmounts[iIndex] = this.weightCounterTargets[iIndex];
                }
                ImageSequence isFish = gfxTankFish[drawFishSize];
                if ((fishTimer -= Application.lastFrameTime) <= 0) {
                    fishTimer += 200;
                    if (++fishFrame >= isFish.numFrames) {
                        fishFrame = 0;
                    }
                }
                int fishIndex = fishFrame;
                int fishOffset = 0;
                fishOffset = drawFishSize == 0 ? 36 : (drawFishSize == 1 ? 28 : 20);
                fishOffset = BaseScreen.getScaledX(fishOffset);
                if (this.iFishToProcess < 3 && swapTimer == 0 && dropTimer >= 0 && gfxTankOverlay != null) {
                    int fishX = this.cTankX + fishOffset;
                    int fishDestY = this.cTankY + gfxTankOverlay.getRectHeight(0) - (isFish.getRectHeight(fishIndex) + BaseScreen.getScaledY(10)) + isFish.getRectHeight(fishIndex);
                    fishY = this.lerpPercent((400 - dropTimer) * 100 / 400, 0, fishDestY);
                    isFish.drawImage(g, fishIndex, fishX, fishY - isFish.getRectHeight(fishIndex));
                    if (gfxSplashLeft != null && dropTimer > 0 && dropTimer < 200) {
                        int splashFrame = this.lerpPercent((200 - dropTimer) * 100 / 200, 0, WeighInScreen.gfxSplashLeft.numFrames - 1);
                        gfxSplashLeft.drawImage(g, splashFrame, fishX, this.cTankY - BaseScreen.getScaledY(5));
                        gfxSplashRight.drawImage(g, splashFrame, fishX, this.cTankY - BaseScreen.getScaledY(5));
                    }
                }
                if (gfxTankOverlay != null) {
                    gfxTankOverlay.drawImage(g, 0, this.cTankX, this.cTankY);
                }
            }
            int cIndent = BaseScreen.getScaledX(3);
            int cDigitPound = BaseScreen.getScaledX(105);
            int cDigitOunce = BaseScreen.getScaledX(157);
            int placeX = this.numberX + gfxTankNumbers.getRectWidth(0);
            if (spacingY < 0) {
                System.out.println("Assertion Failure: spacingY >= 0\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/WeighInScreen.java[554]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            BitmapFont textFont = ScreenStack.fontSmall;
            swapTimer = 0 > swapTimer - Application.lastFrameTime ? 0 : swapTimer - Application.lastFrameTime;
            int currentPlayerY = -(gfxTankBars.getRectHeight(0) + 1);
            for (int i = cNumFinalists - 1; i >= 0; --i) {
                int player2 = this.iPaintOrder[i];
                int placeY = this.numberY + i * (gfxTankBars.getRectHeight(0) + spacingY);
                if (swapTimer > 0) {
                    int oldplace = this.findPlace(this.iOldOrder, player2);
                    int per = (1000 - swapTimer) * 100 / 1000;
                    int oldY = this.numberY + oldplace * (gfxTankBars.getRectHeight(0) + spacingY);
                    int diff = this.lerpPercent(per, oldY, placeY);
                    placeY = oldY + diff;
                }
                int currentFishPlayer = this.iWeightCounterToProcess == -1 ? -1 : this.iPaintOrder[this.iWeightCounterToProcess];
                gfxTankBars.drawImage(g, 0, placeX, placeY);
                if (currentFishPlayer == player2 && swapTimer == 0) {
                    currentPlayerY = placeY;
                }
                int pounds = this.weightCounterAmounts[player2] / 16;
                int ounces = this.weightCounterAmounts[player2] % 16;
                int textY = placeY + (gfxTankBars.getRectHeight(0) - textFont.getFontHeight()) / 2;
                strPound = pounds >= 10 ? "" + pounds : "0" + pounds;
                strOunce = ounces >= 10 ? "" + ounces : "0" + ounces;
                textFont.drawText(g, this.strPlayerNames[player2], placeX + cIndent, textY + 1, BaseScreen.visibleRect);
                fontDigits.drawText(g, strPound, placeX + cDigitPound + BaseScreen.getScaledX(4), textY + 1, BaseScreen.visibleRect);
                fontDigits.drawText(g, strOunce, placeX + cDigitOunce + BaseScreen.getScaledX(4), textY + 1, BaseScreen.visibleRect);
            }
            GfxUtils.setColor(g, 0xFFFF00);
            g.drawRect(placeX - 1, currentPlayerY - 1, gfxTankBars.getRectWidth(0) + 1, gfxTankBars.getRectHeight(0) + 1);
            if (this.iWeightCounterToProcess != -1 && this.weightCounterTargets[player = this.iPaintOrder[this.iWeightCounterToProcess]] <= 0) {
                short w = ScreenStack.fontSmall.getTextWidth("" + MultiLingual.get(372) + "");
                ScreenStack.fontSmall.drawText(g, "" + MultiLingual.get(372) + "", BaseScreen.displayWidth / 2 - w / 2, this.textTitle.clipRect.y0 + this.textTitle.clipRect.h * 3 / 2 + ScreenStack.font.getFontHeight(), BaseScreen.visibleRect);
            }
            if (this.sequenceTimer == -1) {
                int ypos = this.textTitle.clipRect.y0 + this.textTitle.clipRect.h * 5 / 2;
                GameScreen.drawCenteredText(g, ScreenStack.fontSmall, "" + MultiLingual.get(131) + "", ypos += ScreenStack.fontSmall.getFontHeight());
            }
        }
    }

    public void process() {
        if (ScreenLayout.keysPressed(16) && this.sequenceTimer == -1) {
            this.sequenceTimer = 0;
        }
        if (this.sequenceTimer > -1) {
            ++this.sequenceTimer;
        }
        if (FrontEnd.gameType == 0) {
            this.processArcade();
        } else {
            try {
                if ((blinkTimer -= Application.lastFrameTime) <= 0) {
                    blinkTimer += 1000;
                }
                boolean lbLayout = false;
                if (ScreenLayout.keysPressed(16) || this.sequenceTimer > 8) {
                    this.sequenceTimer = 0;
                    if (swapTimer > 0 || !this.hasCounterReachedTargetWeight()) {
                        return;
                    }
                    System.out.println("FirePRESSED: iWeightCounterToProcess " + this.iWeightCounterToProcess + " iFishToProcess " + this.iFishToProcess);
                    if (this.iFishToProcess == 3) {
                        int playerPlace = this.findPlace(this.iPaintOrder, 0);
                        GameSequence.weighInOver(playerPlace);
                        this.checkBiggestCatchRecord();
                        FrontEnd.instance.popScreen(true);
                    } else {
                        this.iWeightCounterToProcess = (this.iWeightCounterToProcess + 1) % cNumFinalists;
                        int player = this.iPaintOrder[this.iWeightCounterToProcess];
                        if (this.iWeightCounterToProcess == 0) {
                            int i;
                            boolean bPerformedSwap;
                            ++this.iFishToProcess;
                            System.out.println("SWAPPING: iWeightCounterToProcess " + this.iWeightCounterToProcess + " iFishToProcess " + this.iFishToProcess);
                            for (int i2 = 0; i2 < this.iOldOrder.length; ++i2) {
                                this.iOldOrder[i2] = this.iPaintOrder[i2];
                            }
                            System.out.println("DOING SORT!");
                            boolean anythingMoved = false;
                            do {
                                bPerformedSwap = false;
                                for (i = 0; i < cNumFinalists - 1; ++i) {
                                    if (this.weightCounterAmounts[this.iPaintOrder[i]] >= this.weightCounterAmounts[this.iPaintOrder[i + 1]]) continue;
                                    int iTemp = this.iPaintOrder[i];
                                    this.iPaintOrder[i] = this.iPaintOrder[i + 1];
                                    this.iPaintOrder[i + 1] = iTemp;
                                    bPerformedSwap = true;
                                    anythingMoved = true;
                                }
                            } while (bPerformedSwap);
                            if (anythingMoved) {
                                System.out.println("MOVE NEEDED");
                                swapTimer = 1000;
                            } else {
                                System.out.println("NO MOVE NEEDED");
                            }
                            if (this.iFishToProcess != -1 && this.iFishToProcess < 3) {
                                System.out.println("UPDATING FISH TARGETS - ADDING FISH " + this.iFishToProcess);
                                for (i = 0; i < cNumFinalists; ++i) {
                                    System.out.println("Player " + i + " name: " + this.strPlayerNames[i] + " adding fish: " + GameLogic.competitorFish[i][this.iFishToProcess]);
                                    int n = i;
                                    this.weightCounterTargets[n] = this.weightCounterTargets[n] + GameLogic.competitorFish[i][this.iFishToProcess];
                                }
                            }
                        }
                        if (this.iFishToProcess < 3) {
                            System.out.println("PLAYER: " + player);
                            System.out.println("FISHTOPROCESS: " + this.iFishToProcess);
                            int thisFishWeight = GameLogic.competitorFish[player][this.iFishToProcess];
                            int thisFishType = GameLogic.getFishTypeFromWeight(thisFishWeight);
                            GameApp.gameScreen.checkUpdateBiggestFishRecord(thisFishWeight);
                            drawFishSize = thisFishType >= 3 ? 2 : (thisFishType == 2 ? 1 : 0);
                            System.out.println("Setting fish size to " + drawFishSize + ", from weight " + (thisFishWeight >> 4));
                            if (this.weightCounterTargets[player] > this.weightCounterAmounts[player]) {
                                dropTimer = 400;
                            } else {
                                System.out.println("Fish for " + this.strPlayerNames[player] + " weighs nothing");
                            }
                        }
                    }
                }
                if (lbLayout) {
                    this.layout();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paintArcade(Graphics g) {
        int player;
        if (this.weighInBG != null) {
            if (ImageSequence.clipSet) {
                g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                ImageSequence.clipSet = false;
            }
            g.drawImage(this.weighInBG, 0, 0, 20);
        } else {
            if (ImageSequence.clipSet) {
                g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                ImageSequence.clipSet = false;
            }
            g.setColor(8828866);
            g.fillRect(0, 0, BaseScreen.displayWidth, BaseScreen.displayHeight);
        }
        ImageSequence isFish = gfxTankFish[drawFishSize];
        if ((fishTimer -= Application.lastFrameTime) <= 0) {
            fishTimer += 200;
            if (++fishFrame >= isFish.numFrames) {
                fishFrame = 0;
            }
        }
        int fishIndex = fishFrame;
        int fishOffset = 0;
        fishOffset = drawFishSize == 0 ? 36 : (drawFishSize == 1 ? 28 : 20);
        fishOffset = BaseScreen.getScaledX(fishOffset);
        if (gfxTankOverlay != null && GameLogic.competitorFish[0][this.iFishToProcess] > 0) {
            int fishX = this.cTankX + fishOffset;
            int fishDestY = this.cTankY + gfxTankOverlay.getRectHeight(0) - (isFish.getRectHeight(fishIndex) + BaseScreen.getScaledY(10)) + isFish.getRectHeight(fishIndex);
            fishY = fishY >= fishDestY ? fishDestY : (fishY += BaseScreen.getScaledY(16));
            isFish.drawImage(g, fishIndex, fishX, fishY - isFish.getRectHeight(fishIndex));
            if (gfxSplashLeft != null && fishY >= this.cTankY && this.splashFrame < WeighInScreen.gfxSplashLeft.numFrames - 1) {
                this.splashFrame = this.splashFrame < WeighInScreen.gfxSplashLeft.numFrames - 1 ? ++this.splashFrame : 0;
                int splx = this.cTankX + gfxTankOverlay.getRectWidth(0) / 2 - gfxSplashLeft.getRectWidth(this.splashFrame) / 2;
                gfxSplashLeft.drawImage(g, this.splashFrame, splx, this.cTankY - BaseScreen.getScaledY(5));
                gfxSplashRight.drawImage(g, this.splashFrame, splx, this.cTankY - BaseScreen.getScaledY(5));
            }
        }
        if (gfxTankOverlay != null) {
            gfxTankOverlay.drawImage(g, 0, this.cTankX, this.cTankY);
        }
        int weightX = this.numberX + BaseScreen.getScaledX(15);
        int weightY = this.numberY + BaseScreen.getScaledY(22);
        BitmapFont textFont = ScreenStack.fontSmall;
        swapTimer = 0 > swapTimer - Application.lastFrameTime ? 0 : swapTimer - Application.lastFrameTime;
        int weight = GameLogic.competitorFish[0][this.iFishToProcess];
        int pounds = weight / 16;
        int ounces = weight % 16;
        strPound = pounds >= 10 ? "" + pounds : "0" + pounds;
        strOunce = ounces >= 10 ? "" + ounces : "0" + ounces;
        textFont.drawText(g, "" + MultiLingual.get(375) + ": " + strPound + "lb " + strOunce + "oz", weightX, weightY, BaseScreen.visibleRect);
        if (this.sequenceTimer == 0 && this.iFishToProcess > 0) {
            totalpounds = (totalWeight += weight) / 16;
            totalounces = totalWeight % 16;
        }
        totalstrPound = totalpounds >= 10 ? "" + totalpounds : "0" + totalpounds;
        totalstrOunce = totalounces >= 10 ? "" + totalounces : "0" + totalounces;
        textFont.drawText(g, "" + MultiLingual.get(376) + "" + " " + "" + MultiLingual.get(375) + "" + " " + totalstrPound + "lb " + totalstrOunce + "oz", weightX, weightY + BaseScreen.getScaledY(30), BaseScreen.visibleRect);
        if (this.iFishToProcess == 0) {
            textFont.drawText(g, "" + MultiLingual.get(376) + "" + " " + "" + MultiLingual.get(377) + "" + " " + GameScreen.arcadeScore, weightX, weightY + BaseScreen.getScaledY(60), BaseScreen.visibleRect);
        }
        if (this.iWeightCounterToProcess != -1 && this.weightCounterTargets[player = 0] <= 0) {
            short w = ScreenStack.fontSmall.getTextWidth("" + MultiLingual.get(372) + "");
            ScreenStack.fontSmall.drawText(g, "" + MultiLingual.get(372) + "", BaseScreen.displayWidth / 2 - w / 2, this.textTitle.clipRect.y0 + this.textTitle.clipRect.h * 3 / 2 + ScreenStack.font.getFontHeight(), BaseScreen.visibleRect);
        }
        if (this.sequenceTimer == -1) {
            int ypos = this.textTitle.clipRect.y0 + this.textTitle.clipRect.h * 5 / 2;
            GameScreen.drawCenteredText(g, ScreenStack.fontSmall, "" + MultiLingual.get(131) + "", ypos += ScreenStack.fontSmall.getFontHeight());
        }
    }

    public void processArcade() {
        if ((blinkTimer -= Application.lastFrameTime) <= 0) {
            blinkTimer += 1000;
        }
        boolean lbLayout = false;
        int thisFishWeight = GameLogic.competitorFish[0][this.iFishToProcess];
        int thisFishType = GameLogic.getFishTypeFromWeight(thisFishWeight);
        drawFishSize = thisFishType >= 3 ? 2 : (thisFishType == 2 ? 1 : 0);
        if (ScreenLayout.keysPressed(16) && !this.startedCounting || this.sequenceTimer > 45) {
            this.startedCounting = true;
            System.out.println("PROCESS ARCADE - NEXT !!!");
            System.out.println("FirePRESSED: iWeightCounterToProcess " + this.iWeightCounterToProcess + " iFishToProcess " + this.iFishToProcess);
            this.sequenceTimer = 0;
            if (this.iFishToProcess == 0) {
                GameScreen.setupArcadeHiScoreTable();
                FrontEnd.instance.popScreen(true);
            } else {
                System.out.println("FISH WEIGHT:" + thisFishWeight);
                System.out.println("Setting fish size to " + drawFishSize + ", from weight " + (thisFishWeight >> 4));
                GameApp.gameScreen.checkUpdateBiggestFishRecord(thisFishWeight);
                if (thisFishWeight > 0) {
                    dropTimer = 400;
                } else {
                    System.out.println("Fish weighs nothing");
                }
                --this.iFishToProcess;
                fishY = 0;
                this.splashFrame = 0;
            }
        }
        if (lbLayout) {
            this.layout();
        }
    }

    void checkBiggestCatchRecord() {
        int playerCatch = this.weightCounterAmounts[0];
        HiscoreTable table = GameApp.hiscoreTable;
        if (table == null) {
            return;
        }
        int tableIndex = 0;
        int hiscorePlace = table.getHiscorePlace(tableIndex, playerCatch);
        if (hiscorePlace != -1) {
            table.addHiscore(tableIndex, playerCatch, "" + MultiLingual.get(315) + "");
            GameApp.autoSave();
        }
    }

    static {
        gfxTankFish = new ImageSequence[3];
        bHaveDigitsFont = true;
        totalstrPound = "0";
        totalstrOunce = "0";
        totalWeight = 0;
        totalpounds = 0;
        totalounces = 0;
    }
}

