/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.game.GameLogic;
import com.slg.j2me.game.GameSequence;
import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gfx.GfxUtils;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.gui.BitmapFont;
import com.slg.j2me.lib.gui.control.GuiContainer;
import com.slg.j2me.lib.gui.image.IconImage;
import com.slg.j2me.lib.gui.image.TextImage;
import com.slg.j2me.lib.gui.layout.CellLayout;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import com.slg.j2me.lib.gui.layout.TextScrollLayout;
import com.slg.j2me.lib.snd.SoundBank;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.sys.FixedPoint;
import com.slg.j2me.lib.util.MultiLingual;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ShopScreen
extends CellLayout {
    public static final int numRods = 5;
    public static final int numReels = 5;
    public static final int numLines = 5;
    public static final int numLures = 5;
    public static final int numSpecials = 2;
    private ImageSet isShop;
    private ImageSequence gfxPanels;
    private ImageSequence gfxTypes;
    private ImageSequence[] gfxItems = new ImageSequence[5];
    private Image imgBackground;
    private Image imgBillyBob;
    private GuiContainer controlMainBuy;
    private GuiContainer controlMainSell;
    private TextImage controlMainBuyText;
    private TextImage controlMainSellText;
    private GuiContainer controlPanelGrey;
    private GuiContainer controlPanelBlue;
    private GuiContainer controlPanelRed;
    private CellLayout itemSelectLayout = new CellLayout(6);
    private GuiContainer[] controlItemTypes = new GuiContainer[5];
    private static final int numMissions = 3;
    private static final int cTopMissionRow = 1;
    private static final int cMissionDescRow = 4;
    private CellLayout missionSelectLayout = new CellLayout(5);
    private static final int cItemTopRow = 3;
    private static final int cItemBottomRow = 4;
    private static final int cRootBuy = 0;
    private static final int cRootSell = 2;
    public static int[] numItems = new int[5];
    private GuiContainer[][] controlItem = new GuiContainer[5][];
    private TextImage controlMoney;
    private TextImage[] itemTypeNames = new TextImage[5];
    private TextImage[][] itemDescBuy = new TextImage[5][];
    private TextImage[][] itemDescSell = new TextImage[5][];
    private int[][] itemPrice = new int[5][];
    private static final int cCursorLevelNone = 0;
    private static final int cCursorLevelRoot = 1;
    private static final int cCursorLevelItemType = 2;
    private static final int cCursorLevelItem = 3;
    private int cursorLevel;
    private int cursorRoot;
    private int cursorItemType;
    private int cursorItem;
    private int cursorItemX;
    private int cursorItemY;
    private int cursorMission;
    private int cursorFlash = 0;
    private int fpCursorFlashTime = 0;
    private int itemNumTopRow;
    private int itemNumBottomRow;
    private int itemFirstTopRow;
    private int itemFirstBottomRow;
    private int itemLastTopRow;
    private int itemLastBottomRow;
    private int cursorPanelSizeX = 1;
    private int cursorPanelSizeY = 1;
    public static boolean[][] inventory = new boolean[5][];
    public TextScrollLayout dialogImage = null;
    private static final int cButtonsYesNo = 0;
    private static final int cButtonsOK = 1;
    private static final int cEventNone = 0;
    private static final int cEventBuy = 1;
    private static final int cEventSell = 2;
    private static final int cEventExit = 3;
    private static final int cEventDoneBBIntro = 4;
    private static final int cEventDoneBBOutro = 5;
    private int attemptBuySellType;
    private int attemptBuySellIndex;
    private int yesEvent;
    private int buttonType;
    private boolean quitDialogActive = false;
    public TextScrollLayout bbLayout = null;
    private int fpBBTransWipe;
    private int bbState;
    private int bbEvent;
    private static final int cStateInit = 0;
    private static final int cStateWipeIn = 1;
    private static final int cStateNormal = 2;
    private static final int cStateWipeOut = 3;
    private static final int cStateBBIntro = 4;
    private static final int cStateBBOutro = 5;
    private static final int cStateDone = 6;
    private int state = 0;
    private int fpFrontTransWipe;
    private int fpFrontTransWipeSpeed;
    private static final int fpFrontTransWipeTime = FixedPoint.stringToFP("0.3");
    private static int cCentre = 3;
    private static int softkeyHeight = 16;
    int tipIndex = 0;

    public ShopScreen() {
        super(3, "ShopScreen");
        ShopScreen.numItems[0] = 5;
        ShopScreen.numItems[1] = 5;
        ShopScreen.numItems[2] = 5;
        ShopScreen.numItems[3] = 5;
        ShopScreen.numItems[4] = 2;
        for (int i = 0; i < 5; ++i) {
            int num = numItems[i];
            this.controlItem[i] = new GuiContainer[num];
            this.itemDescBuy[i] = new TextImage[num];
            this.itemDescSell[i] = new TextImage[num];
            this.itemPrice[i] = new int[num];
            ShopScreen.inventory[i] = new boolean[num];
        }
        this.setupItemPrices();
        ShopScreen.resetInventory();
        this.init();
        softkeyHeight = ScreenStack.fontSmallTight.getFontHeight() > FrontEnd.gfxStick.getRectHeight(3) ? ScreenStack.fontSmallTight.getFontHeight() : FrontEnd.gfxStick.getRectHeight(3);
    }

    public void open() {
        System.out.println("ShopScreen.open()");
        this.isShop.reloadImages();
        this.imgBackground = ImageSet.loadImage("/shop.png");
        this.imgBillyBob = ImageSet.loadImage("/billy-bob.png");
        super.open();
        this.setupSound();
    }

    public void close() {
        this.imgBackground = null;
        this.imgBillyBob = null;
        this.isShop.unloadImages();
    }

    public void setupSound() {
        int tune = 7;
        if (FrontEnd.sound && !BaseScreen.pauseDialogShown && SoundBank.currentSound != tune) {
            SoundBank.play(0, tune, true, 0);
        }
    }

    private void init() {
        this.loadGfx();
        this.setupMenuText();
        this.setRow(0, 0, 0);
        this.setRow(1, 3, -1);
        this.setRow(2, 1, 1);
        this.setCell(1, 0, this.controlMainBuy, 1, cCentre);
        this.setCell(1, 1, this.controlMoney, 1, cCentre);
        this.layout();
        this.itemSelectLayout.setRow(0, 5, 3);
        this.itemSelectLayout.setRow(1, 1, 2);
        this.itemSelectLayout.setRow(2, 1, 1);
        this.itemSelectLayout.setRow(3, 6, 3);
        this.itemSelectLayout.setRow(4, 6, 3);
        this.itemSelectLayout.setRow(5, 1, 1);
        for (int i = 0; i < 5; ++i) {
            this.itemSelectLayout.setCell(0, i, this.controlItemTypes[i], 1, cCentre);
        }
        this.setPanelBuy();
        this.setItemType(0);
        this.cursorLevel = 1;
        this.cursorRoot = 0;
        this.cursorItemType = 0;
        this.cursorItem = 0;
        this.updateItemCursorFromIndex();
        this.updateItemText();
        this.state = 0;
        this.fpFrontTransWipe = 65536;
        this.fpBBTransWipe = 65536;
        this.fpFrontTransWipeSpeed = (int)(0x100000000L / (long)fpFrontTransWipeTime);
        this.clipRect.x0 = (short)(BaseScreen.displayWidth - 1);
    }

    public void setupMenuText() {
        BitmapFont font = ScreenStack.fontSmall;
        this.controlMoney = new TextImage(font, "$" + GameSequence.playerCash);
        this.controlMainBuyText = new TextImage(font, "" + MultiLingual.get(226) + "");
        this.controlMainSellText = new TextImage(font, "" + MultiLingual.get(227) + "");
        this.controlMainBuy = new IconImage(this.gfxPanels, 0);
        this.controlMainSell = new IconImage(this.gfxPanels, 0);
        this.controlPanelGrey = new IconImage(this.gfxPanels, 2);
        this.controlPanelBlue = new IconImage(this.gfxPanels, 1);
        this.controlPanelRed = new IconImage(this.gfxPanels, 3);
        for (int i = 0; i < 5; ++i) {
            int num = numItems[i];
            this.controlItemTypes[i] = new IconImage(this.gfxTypes, i);
            this.itemTypeNames[i] = new TextImage(font, ShopScreen.strTypeName(i));
            for (int j = 0; j < num; ++j) {
                this.controlItem[i][j] = new IconImage(this.gfxItems[i], j);
                this.itemDescBuy[i][j] = new TextImage(font, ShopScreen.strItemName(i, j) + "  $" + this.itemPrice[i][j]);
                this.itemDescSell[i][j] = new TextImage(font, ShopScreen.strItemName(i, j) + "  $" + this.getSellPrice(this.itemPrice[i][j]));
            }
        }
    }

    private void setPanelBuy() {
        this.setCell(2, 0, this.itemSelectLayout, 1, 1);
        this.setItemType(0);
        this.cursorItemType = 0;
        this.layout();
    }

    private void setPanelSell() {
        this.setCell(2, 0, this.itemSelectLayout, 1, 1);
        this.setItemType(0);
        this.cursorItemType = 0;
        this.layout();
    }

    private void setItemType(int t) {
        boolean show;
        int i;
        GuiContainer[] elements = this.controlItem[t];
        int numElements = numItems[t];
        this.itemNumBottomRow = numElements >> 1;
        this.itemNumTopRow = numElements - this.itemNumBottomRow;
        this.itemFirstTopRow = 5 - this.itemNumTopRow >> 1;
        this.itemLastTopRow = this.itemFirstTopRow + this.itemNumTopRow - 1;
        this.itemFirstBottomRow = 5 - this.itemNumBottomRow >> 1;
        this.itemLastBottomRow = this.itemFirstBottomRow + this.itemNumBottomRow - 1;
        int n = 0;
        for (i = 0; i < 5; ++i) {
            if (i < this.itemFirstTopRow || i > this.itemLastTopRow) {
                this.itemSelectLayout.setCell(3, i + 1, null, 1, cCentre);
                continue;
            }
            show = true;
            if (this.cursorRoot == 2 && !inventory[t][n]) {
                show = false;
            }
            this.itemSelectLayout.setCell(3, i + 1, show ? elements[i - this.itemFirstTopRow] : new TextImage(ScreenStack.fontSmall, " ? "), 1, cCentre);
            ++n;
        }
        this.itemSelectLayout.setCell(3, 0, null, 0, 0);
        for (i = 0; i < 5; ++i) {
            if (i < this.itemFirstBottomRow || i > this.itemLastBottomRow) {
                this.itemSelectLayout.setCell(4, i + 1, null, 4, cCentre);
                continue;
            }
            show = true;
            if (this.cursorRoot == 2 && !inventory[t][n]) {
                show = false;
            }
            this.itemSelectLayout.setCell(4, i + 1, show ? elements[this.itemNumTopRow + i - this.itemFirstBottomRow] : new TextImage(ScreenStack.fontSmall, " ? "), 4, cCentre);
            ++n;
        }
        if (this.itemNumTopRow != this.itemNumBottomRow) {
            this.itemSelectLayout.setCell(4, 0, null, 1, cCentre);
            this.itemSelectLayout.setCell(4, 5, null, 3, cCentre);
        } else {
            this.itemSelectLayout.setCell(4, 0, null, 0, 0);
        }
        this.itemSelectLayout.setCell(2, 0, this.itemTypeNames[t], 1, cCentre);
        this.layout();
    }

    public void paint(Graphics g) {
        boolean drawShopIcons;
        boolean bl = drawShopIcons = this.state == 2 || this.state == 1 || this.state == 3;
        if (this.quitDialogActive) {
            drawShopIcons = false;
        }
        if (this.imgBackground == null) {
            System.out.println("Assertion Failure: imgBackground!=null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[453]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        g.drawImage(this.imgBackground, 0, 0, 0x10 | 4);
        int billyX = BaseScreen.getScaledX(67);
        int billyY = BaseScreen.getScaledY(81);
        if (this.imgBillyBob == null) {
            System.out.println("Assertion Failure: imgBillyBob!=null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[476]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        g.drawImage(this.imgBillyBob, billyX, billyY, 0x10 | 4);
        if (drawShopIcons) {
            GuiContainer panel;
            int i;
            for (int i2 = 0; i2 < 5; ++i2) {
                this.drawCellOverlay(g, this.itemSelectLayout, 0, i2, false, this.controlPanelBlue);
            }
            int type = this.cursorItemType;
            int n = 0;
            for (i = this.itemFirstTopRow; i <= this.itemLastTopRow; ++i) {
                panel = this.getBackgroundPanelForItem(type, n);
                if (panel == null) {
                    System.out.println("Assertion Failure: panel != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[497]");
                    try {
                        throw new Exception();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.drawCellOverlay(g, this.itemSelectLayout, 3, i + 1, false, panel);
                ++n;
            }
            for (i = this.itemFirstBottomRow; i <= this.itemLastBottomRow; ++i) {
                panel = this.getBackgroundPanelForItem(type, n);
                if (panel == null) {
                    System.out.println("Assertion Failure: panel != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[506]");
                    try {
                        throw new Exception();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.drawCellOverlay(g, this.itemSelectLayout, 4, i + 1, false, panel);
                ++n;
            }
            if (this.state == 2) {
                int colDim = 0xFF2020;
                int col = 128 + (this.cursorFlash >> 1);
                int colLight = col | col << 8 | col << 16;
                switch (this.cursorLevel) {
                    case 1: {
                        int i3;
                        for (i3 = 0; i3 < 5; ++i3) {
                            if (i3 == this.cursorItemType) continue;
                            this.hilightCell(g, this.itemSelectLayout, 0, i3, false, 0, true);
                        }
                        this.hilightCell(g, this, 1, this.cursorRoot, true, colLight, false);
                        break;
                    }
                    case 2: {
                        this.hilightCell(g, this, 1, 2 - this.cursorRoot, true, 0, true);
                        this.hilightCell(g, this.itemSelectLayout, 0, this.cursorItemType, false, colLight, false);
                        break;
                    }
                    case 3: {
                        int i3;
                        this.hilightCell(g, this, 1, 2 - this.cursorRoot, true, 0, true);
                        for (i3 = 0; i3 < 5; ++i3) {
                            if (i3 == this.cursorItemType) continue;
                            this.hilightCell(g, this.itemSelectLayout, 0, i3, false, 0, true);
                        }
                        this.hilightCell(g, this.itemSelectLayout, this.cursorItemY + 3, this.cursorItemX + 1, false, colLight, false);
                    }
                }
            }
        }
        if (drawShopIcons) {
            super.paint(g);
            this.drawCellOverlay(g, this, 1, 0, true, this.controlMainBuyText);
        }
        int buttonBarHeight = softkeyHeight;
        int buttonBarPos = BaseScreen.displayHeight - buttonBarHeight;
        if (this.dialogImage != null) {
            ClipRect cr = this.dialogImage.clipRect;
            int x0 = cr.x0 - 2;
            short y0 = cr.y0;
            int w = cr.w + 2;
            short h = cr.h;
            g.setColor(0);
            g.fillRect(x0, (int)y0, w, (int)h);
            g.setColor(0xFFFFFF);
            g.drawRect(x0, (int)y0, w, (int)h);
            this.dialogImage.paint(g);
            if (this.buttonType == 0) {
                FrontEnd.instance.drawButton(g, 0, "" + MultiLingual.get(95) + "", buttonBarPos, buttonBarHeight, 0, 0);
                FrontEnd.instance.drawButton(g, 1, "" + MultiLingual.get(96) + "", buttonBarPos, buttonBarHeight, 0, 1);
            } else if (this.buttonType == 1) {
                FrontEnd.instance.drawButton(g, 0, "" + MultiLingual.get(91) + "", buttonBarPos, buttonBarHeight, 0, 0);
            }
            if (this.dialogImage.textLayout.rectDocument.h > this.dialogImage.clipRect.h) {
                FrontEnd.gfxStick.drawImage(g, 3, (BaseScreen.displayWidth - FrontEnd.gfxStick.getRectWidth(3)) / 2, buttonBarPos + (buttonBarHeight - FrontEnd.gfxStick.getRectHeight(3) >> 1));
            }
        } else if (this.bbLayout != null) {
            this.bbLayout.paint(g);
            if (this.bbState == 2) {
                FrontEnd.instance.drawButton(g, 0, "" + MultiLingual.get(91) + "", buttonBarPos, buttonBarHeight, 0, 0);
                if (this.bbLayout.textLayout.rectDocument.h > this.bbLayout.clipRect.h) {
                    FrontEnd.gfxStick.drawImage(g, 3, (BaseScreen.displayWidth - FrontEnd.gfxStick.getRectWidth(3)) / 2, buttonBarPos + (buttonBarHeight - FrontEnd.gfxStick.getRectHeight(3) >> 1));
                }
            }
        } else {
            FrontEnd.instance.drawButton(g, 1, "" + MultiLingual.get(98) + "", buttonBarPos, buttonBarHeight, 0, 2);
            if (this.cursorLevel == 3) {
                if (this.cursorRoot == 0) {
                    FrontEnd.instance.drawButton(g, 0, "" + MultiLingual.get(99) + "", buttonBarPos, buttonBarHeight, 0, 3);
                } else {
                    FrontEnd.instance.drawButton(g, 0, "" + MultiLingual.get(100) + "", buttonBarPos, buttonBarHeight, 0, 3);
                }
            }
            int s = 4;
            ImageSequence gfxStick = FrontEnd.gfxStick;
            int displayWidth = BaseScreen.displayWidth;
            int y = buttonBarPos;
            gfxStick.drawImage(g, s, displayWidth - gfxStick.getRectWidth(s) >> 1, y);
        }
    }

    private void hilightCell(Graphics g, CellLayout layout, int row, int column, boolean rootLevel, int colour, boolean greyOut) {
        GuiContainer container = layout.cellContainers[row][column];
        if (container == null) {
            return;
        }
        ClipRect cr = container.clipRect;
        int x0 = cr.x0;
        int w = cr.w;
        int y0 = cr.y0;
        int h = cr.h;
        if (!rootLevel) {
            x0 -= this.cursorPanelSizeX - w >> 1;
            w = this.cursorPanelSizeX - 1;
            y0 -= this.cursorPanelSizeY - h >> 1;
            h = this.cursorPanelSizeY - 1;
        }
        if (!rootLevel) {
            cr = this.itemSelectLayout.clipRect;
            x0 += cr.x0;
            y0 += cr.y0;
        }
        if (greyOut) {
            GfxUtils.drawCrossHatch(g, colour, x0, y0, w, h);
            if (ImageSequence.clipSet) {
                g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                ImageSequence.clipSet = false;
            }
        } else {
            g.setColor(colour);
            g.drawRect(x0, y0, w, h);
            g.drawRect(x0 + 1, y0 + 1, w - 2, h - 2);
            g.drawRect(x0 + 2, y0 + 2, w - 4, h - 4);
        }
    }

    private void drawCellOverlay(Graphics g, CellLayout layout, int row, int column, boolean rootLevel, GuiContainer overlay) {
        GuiContainer container = layout.cellContainers[row][column];
        if (container == null) {
            return;
        }
        ClipRect cr = container.clipRect;
        int marginX = cr.w - overlay.clipRect.w >> 1;
        int marginY = cr.h - overlay.clipRect.h >> 1;
        overlay.clipRect.x0 = (short)(cr.x0 + (short)marginX);
        overlay.clipRect.y0 = (short)(cr.y0 + (short)marginY);
        if (!rootLevel) {
            cr = this.itemSelectLayout.clipRect;
            overlay.clipRect.x0 = (short)(overlay.clipRect.x0 + cr.x0);
            overlay.clipRect.y0 = (short)(overlay.clipRect.y0 + cr.y0);
        }
        overlay.clipRect.x0 = (short)(overlay.clipRect.x0 + this.clipRect.x0);
        overlay.clipRect.y0 = (short)(overlay.clipRect.y0 + this.clipRect.y0);
        overlay.paint(g);
    }

    GuiContainer getBackgroundPanelForItem(int t, int n) {
        if (inventory[t][n]) {
            return this.controlPanelBlue;
        }
        if (this.cursorRoot == 2) {
            return this.controlPanelGrey;
        }
        if (this.itemPrice[t][n] > GameSequence.playerCash) {
            return this.controlPanelRed;
        }
        return this.controlPanelGrey;
    }

    public void process() {
        this.setupSound();
        if (this.dialogImage != null) {
            this.updateDialog();
        } else if (this.bbLayout != null) {
            this.updateBBDialog();
        } else {
            switch (this.state) {
                case 0: {
                    this.state = 4;
                    this.clipRect.x0 = (short)(BaseScreen.displayWidth - 1);
                    this.openBBDialog(this.getBBIntroText(), true, 4);
                    break;
                }
                case 1: {
                    this.fpFrontTransWipe -= ((this.fpFrontTransWipeSpeed ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-this.fpFrontTransWipeSpeed) * (long)Application.fp_deltatime >> 16)) : (int)((long)this.fpFrontTransWipeSpeed * (long)Application.fp_deltatime >> 16);
                    if (this.fpFrontTransWipe <= 0) {
                        this.fpFrontTransWipe = 0;
                        this.state = 2;
                    }
                    this.clipRect.x0 = this.getClipRectX0FromWipeValue(this.fpFrontTransWipe, true);
                    break;
                }
                case 3: {
                    this.fpFrontTransWipe += ((this.fpFrontTransWipeSpeed ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-this.fpFrontTransWipeSpeed) * (long)Application.fp_deltatime >> 16)) : (int)((long)this.fpFrontTransWipeSpeed * (long)Application.fp_deltatime >> 16);
                    if (this.fpFrontTransWipe >= 65536) {
                        this.fpFrontTransWipe = 65536;
                        this.state = 5;
                        this.openBBDialog(this.getBBOutroText(), true, 5);
                    }
                    this.clipRect.x0 = this.getClipRectX0FromWipeValue(this.fpFrontTransWipe, false);
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 2: {
                    if (ScreenLayout.keysPressed(65536)) {
                        this.openConfirmDialog("" + MultiLingual.get(231) + "", 3);
                        this.quitDialogActive = true;
                        break;
                    }
                    this.updateCursor();
                }
            }
        }
        super.process();
    }

    private void updateCursor() {
        this.fpCursorFlashTime += ((FixedPoint.stringToFP("2.0") ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.stringToFP("2.0")) * (long)Application.fp_deltatime >> 16)) : (int)((long)FixedPoint.stringToFP("2.0") * (long)Application.fp_deltatime >> 16);
        if (this.fpCursorFlashTime > 65536) {
            this.fpCursorFlashTime = 0;
        }
        this.cursorFlash = this.fpCursorFlashTime > 32768 ? ((((0xFF0000 ^ 2 * (65536 - this.fpCursorFlashTime)) & 0x8000000) != 0 ? -((int)(-16711680L * (long)(2 * (65536 - this.fpCursorFlashTime)) >> 16)) : (int)(0xFF0000L * (long)(2 * (65536 - this.fpCursorFlashTime)) >> 16)) < 0 ? -(-(((0xFF0000 ^ 2 * (65536 - this.fpCursorFlashTime)) & 0x8000000) != 0 ? -((int)(-16711680L * (long)(2 * (65536 - this.fpCursorFlashTime)) >> 16)) : (int)(0xFF0000L * (long)(2 * (65536 - this.fpCursorFlashTime)) >> 16)) >> 16) : (((0xFF0000 ^ 2 * (65536 - this.fpCursorFlashTime)) & 0x8000000) != 0 ? -((int)(-16711680L * (long)(2 * (65536 - this.fpCursorFlashTime)) >> 16)) : (int)(0xFF0000L * (long)(2 * (65536 - this.fpCursorFlashTime)) >> 16)) >> 16) : ((((0xFF0000 ^ 2 * this.fpCursorFlashTime) & 0x8000000) != 0 ? -((int)(-16711680L * (long)(2 * this.fpCursorFlashTime) >> 16)) : (int)(0xFF0000L * (long)(2 * this.fpCursorFlashTime) >> 16)) < 0 ? -(-(((0xFF0000 ^ 2 * this.fpCursorFlashTime) & 0x8000000) != 0 ? -((int)(-16711680L * (long)(2 * this.fpCursorFlashTime) >> 16)) : (int)(0xFF0000L * (long)(2 * this.fpCursorFlashTime) >> 16)) >> 16) : (((0xFF0000 ^ 2 * this.fpCursorFlashTime) & 0x8000000) != 0 ? -((int)(-16711680L * (long)(2 * this.fpCursorFlashTime) >> 16)) : (int)(0xFF0000L * (long)(2 * this.fpCursorFlashTime) >> 16)) >> 16);
        switch (this.cursorLevel) {
            case 1: {
                int oldPos = this.cursorRoot;
                if (ScreenLayout.keysPressed(2)) {
                    this.cursorRoot = 0;
                }
                if (this.cursorRoot != oldPos) {
                    switch (this.cursorRoot) {
                        case 0: {
                            this.setPanelBuy();
                            break;
                        }
                        case 2: {
                            this.setPanelSell();
                        }
                    }
                }
                if (!ScreenLayout.keysPressed(8)) break;
                this.cursorLevel = 2;
                break;
            }
            case 2: {
                int oldPos = this.cursorItemType;
                if (ScreenLayout.keysPressed(2) && this.cursorItemType > 0) {
                    --this.cursorItemType;
                } else if (ScreenLayout.keysPressed(4) && this.cursorItemType < 4) {
                    ++this.cursorItemType;
                }
                if (this.cursorItemType != oldPos) {
                    this.updateItemTypeFromCursor();
                }
                if (ScreenLayout.keysPressed(8)) {
                    this.cursorLevel = 3;
                    this.cursorItem = 0;
                    this.updateItemCursorFromIndex();
                    this.updateItemText();
                    break;
                }
                if (!ScreenLayout.keysPressed(1)) break;
                this.cursorLevel = 1;
                break;
            }
            case 3: {
                if (this.cursorItemY == 0) {
                    if (ScreenLayout.keysPressed(2) && this.cursorItemX > this.itemFirstTopRow) {
                        --this.cursorItemX;
                    } else if (ScreenLayout.keysPressed(4) && this.cursorItemX < this.itemLastTopRow) {
                        ++this.cursorItemX;
                    } else if (ScreenLayout.keysPressed(8)) {
                        this.cursorItemY = 1;
                        if (this.itemSelectLayout.cellContainers[4][this.cursorItemX + 1] == null) {
                            this.cursorItemX = this.itemLastBottomRow;
                        }
                    } else if (ScreenLayout.keysPressed(1)) {
                        this.cursorLevel = 2;
                        this.updateItemText();
                    }
                } else if (ScreenLayout.keysPressed(2) && this.cursorItemX > this.itemFirstBottomRow) {
                    --this.cursorItemX;
                } else if (ScreenLayout.keysPressed(4) && this.cursorItemX < this.itemLastBottomRow) {
                    ++this.cursorItemX;
                } else if (ScreenLayout.keysPressed(1)) {
                    this.cursorItemY = 0;
                    if (this.itemSelectLayout.cellContainers[3][this.cursorItemX + 1] == null) {
                        this.cursorItemX = this.itemFirstTopRow - 1;
                    }
                }
                int oldItem = this.cursorItem;
                this.updateItemCursorFromPos();
                if (this.cursorItem != oldItem) {
                    this.updateItemText();
                }
                if (!ScreenLayout.keysPressed(32768)) break;
                System.out.println("cursorRoot: " + this.cursorRoot);
                if (this.cursorRoot == 0) {
                    this.attemptBuyItem(this.cursorItemType, this.cursorItem);
                    break;
                }
                if (this.cursorRoot != 2) break;
                this.attemptSellItem(this.cursorItemType, this.cursorItem);
                break;
            }
        }
    }

    private void updateItemCursorFromPos() {
        this.cursorItem = this.cursorItemY == 0 ? this.cursorItemX - this.itemFirstTopRow : this.cursorItemX - this.itemFirstBottomRow + this.itemNumTopRow;
    }

    private void updateItemCursorFromIndex() {
        if (this.cursorItem < this.itemNumTopRow) {
            this.cursorItemX = this.cursorItem + this.itemFirstTopRow;
            this.cursorItemY = 0;
        } else {
            this.cursorItemX = this.cursorItem - this.itemNumTopRow + this.itemFirstBottomRow;
            this.cursorItemY = 1;
        }
    }

    public void updateItemTypeFromCursor() {
        this.setItemType(this.cursorItemType);
    }

    private void updateItemText() {
        if (this.cursorLevel != 3) {
            this.itemSelectLayout.setCell(5, 0, null, 1, cCentre);
        } else if (this.cursorRoot == 0) {
            this.itemSelectLayout.setCell(5, 0, this.itemDescBuy[this.cursorItemType][this.cursorItem], 1, cCentre);
        } else if (this.cursorRoot == 2) {
            boolean show = inventory[this.cursorItemType][this.cursorItem];
            this.itemSelectLayout.setCell(5, 0, show ? this.itemDescSell[this.cursorItemType][this.cursorItem] : null, 1, cCentre);
        }
        this.layout();
    }

    private void updateMoneyText() {
        this.controlMoney = new TextImage(ScreenStack.fontSmall, "$" + GameSequence.playerCash);
        this.setCell(1, 1, this.controlMoney, 1, cCentre);
        this.layout();
    }

    public static String strTypeName(int t) {
        switch (t) {
            case 0: {
                return "" + MultiLingual.get(199) + "";
            }
            case 1: {
                return "" + MultiLingual.get(200) + "";
            }
            case 2: {
                return "" + MultiLingual.get(201) + "";
            }
            case 3: {
                return "" + MultiLingual.get(202) + "";
            }
            case 4: {
                return "" + MultiLingual.get(203) + "";
            }
        }
        return "?";
    }

    public static String strItemName(int t, int n) {
        switch (t) {
            case 0: {
                switch (n) {
                    case 0: {
                        return "" + MultiLingual.get(204) + "";
                    }
                    case 1: {
                        return "" + MultiLingual.get(205) + "";
                    }
                    case 2: {
                        return "" + MultiLingual.get(206) + "";
                    }
                    case 3: {
                        return "" + MultiLingual.get(207) + "";
                    }
                    case 4: {
                        return "" + MultiLingual.get(208) + "";
                    }
                }
                break;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        return "" + MultiLingual.get(209) + "";
                    }
                    case 1: {
                        return "" + MultiLingual.get(210) + "";
                    }
                    case 2: {
                        return "" + MultiLingual.get(211) + "";
                    }
                    case 3: {
                        return "" + MultiLingual.get(212) + "";
                    }
                    case 4: {
                        return "" + MultiLingual.get(213) + "";
                    }
                }
                break;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        return "" + MultiLingual.get(214) + "";
                    }
                    case 1: {
                        return "" + MultiLingual.get(215) + "";
                    }
                    case 2: {
                        return "" + MultiLingual.get(216) + "";
                    }
                    case 3: {
                        return "" + MultiLingual.get(217) + "";
                    }
                    case 4: {
                        return "" + MultiLingual.get(218) + "";
                    }
                }
                break;
            }
            case 3: {
                switch (n) {
                    case 0: {
                        return "" + MultiLingual.get(219) + "";
                    }
                    case 1: {
                        return "" + MultiLingual.get(220) + "";
                    }
                    case 2: {
                        return "" + MultiLingual.get(221) + "";
                    }
                    case 3: {
                        return "" + MultiLingual.get(222) + "";
                    }
                    case 4: {
                        return "" + MultiLingual.get(223) + "";
                    }
                }
                break;
            }
            case 4: {
                switch (n) {
                    case 0: {
                        return "" + MultiLingual.get(224) + "";
                    }
                    case 1: {
                        return "" + MultiLingual.get(225) + "";
                    }
                }
            }
        }
        return "?";
    }

    public static String strItemDescription(int t, int n) {
        switch (t) {
            case 0: {
                switch (n) {
                    case 0: {
                        return "" + MultiLingual.get(268) + "";
                    }
                    case 1: {
                        return "" + MultiLingual.get(269) + "";
                    }
                    case 2: {
                        return "" + MultiLingual.get(270) + "";
                    }
                    case 3: {
                        return "" + MultiLingual.get(271) + "";
                    }
                    case 4: {
                        return "" + MultiLingual.get(272) + "";
                    }
                }
                break;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        return "" + MultiLingual.get(273) + "";
                    }
                    case 1: {
                        return "" + MultiLingual.get(274) + "";
                    }
                    case 2: {
                        return "" + MultiLingual.get(275) + "";
                    }
                    case 3: {
                        return "" + MultiLingual.get(276) + "";
                    }
                    case 4: {
                        return "" + MultiLingual.get(277) + "";
                    }
                }
                break;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        return "" + MultiLingual.get(278) + "";
                    }
                    case 1: {
                        return "" + MultiLingual.get(279) + "";
                    }
                    case 2: {
                        return "" + MultiLingual.get(280) + "";
                    }
                    case 3: {
                        return "" + MultiLingual.get(281) + "";
                    }
                    case 4: {
                        return "" + MultiLingual.get(282) + "";
                    }
                }
                break;
            }
            case 3: {
                switch (n) {
                    case 0: {
                        return "" + MultiLingual.get(283) + "";
                    }
                    case 1: {
                        return "" + MultiLingual.get(284) + "";
                    }
                    case 2: {
                        return "" + MultiLingual.get(285) + "";
                    }
                    case 3: {
                        return "" + MultiLingual.get(286) + "";
                    }
                    case 4: {
                        return "" + MultiLingual.get(287) + "";
                    }
                }
                break;
            }
            case 4: {
                switch (n) {
                    case 0: {
                        return "" + MultiLingual.get(288) + "";
                    }
                    case 1: {
                        return "" + MultiLingual.get(289) + "";
                    }
                }
            }
        }
        return "?";
    }

    private void setupItemPrices() {
        this.itemPrice[0][0] = 166;
        this.itemPrice[0][1] = 240;
        this.itemPrice[0][2] = 500;
        this.itemPrice[0][3] = 830;
        this.itemPrice[0][4] = 1700;
        this.itemPrice[1][0] = 48;
        this.itemPrice[1][1] = 170;
        this.itemPrice[1][2] = 240;
        this.itemPrice[1][3] = 610;
        this.itemPrice[1][4] = 1070;
        this.itemPrice[2][0] = 40;
        this.itemPrice[2][1] = 90;
        this.itemPrice[2][2] = 140;
        this.itemPrice[2][3] = 270;
        this.itemPrice[2][4] = 540;
        this.itemPrice[3][0] = 50;
        this.itemPrice[3][1] = 110;
        this.itemPrice[3][2] = 260;
        this.itemPrice[3][3] = 400;
        this.itemPrice[3][4] = 700;
        this.itemPrice[4][0] = 400;
        this.itemPrice[4][1] = 800;
    }

    private int getSellPrice(int n) {
        return n * 2 / 3;
    }

    private void loadGfx() {
        this.isShop = new ImageSet("/shop.is", false);
        this.gfxPanels = this.isShop.getImageSequence("shop-panel");
        this.gfxTypes = this.isShop.getImageSequence("type-icon");
        this.gfxItems[0] = this.isShop.getImageSequence("rod-icon");
        this.gfxItems[1] = this.isShop.getImageSequence("reel-icon");
        this.gfxItems[2] = this.isShop.getImageSequence("line-icon");
        this.gfxItems[3] = this.isShop.getImageSequence("lure-icon");
        this.gfxItems[4] = this.isShop.getImageSequence("special-icon");
        if (this.gfxPanels == null) {
            System.out.println("Assertion Failure: gfxPanels != null\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[1315]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cursorPanelSizeX = this.gfxPanels.getRectWidth(1);
        this.cursorPanelSizeY = this.gfxPanels.getRectHeight(1);
    }

    private void unloadGfx() {
        this.isShop = null;
        this.imgBackground = null;
        this.imgBillyBob = null;
    }

    public static boolean playerHasItem(int t, int n) {
        if (t < 0 || t >= 5) {
            System.out.println("Assertion Failure: (t>=0) && (t<GameScreen.cNumTypes)\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[1331]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (n < 0 || n >= numItems[t]) {
            System.out.println("Assertion Failure: (n>=0) && (n<numItems[t])\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[1332]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return inventory[t][n];
    }

    public static boolean playerHasRod(int n) {
        return ShopScreen.playerHasItem(0, n);
    }

    public static boolean playerHasReel(int n) {
        return ShopScreen.playerHasItem(1, n);
    }

    public static boolean playerHasLine(int n) {
        return ShopScreen.playerHasItem(2, n);
    }

    public static boolean playerHasLure(int n) {
        return ShopScreen.playerHasItem(3, n);
    }

    public static boolean playerHasSpecialItem(int n) {
        return ShopScreen.playerHasItem(4, n);
    }

    public static boolean playerHasBoat1() {
        return ShopScreen.playerHasItem(4, 0);
    }

    public static boolean playerHasBoat2() {
        return ShopScreen.playerHasItem(4, 1);
    }

    public int numItemsHeldOfThisType(int t) {
        if (t < 0 || t >= 5) {
            System.out.println("Assertion Failure: (t>=0) && (t<GameScreen.cNumTypes)\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[1351]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int total = 0;
        for (int i = 0; i < numItems[t]; ++i) {
            if (!inventory[t][i]) continue;
            ++total;
        }
        return total;
    }

    public int getBestItemOfType(int t) {
        if (t < 0 || t >= 5) {
            System.out.println("Assertion Failure: (t>=0) && (t<GameScreen.cNumTypes)\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[1364]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = numItems[t] - 1; i >= 0; --i) {
            if (!inventory[t][i]) continue;
            return i;
        }
        return -1;
    }

    public static void resetInventory() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < numItems[i]; ++j) {
                ShopScreen.inventory[i][j] = false;
            }
        }
        ShopScreen.inventory[0][0] = true;
        ShopScreen.inventory[1][0] = true;
        ShopScreen.inventory[2][0] = true;
        ShopScreen.inventory[3][0] = true;
    }

    private void attemptBuyItem(int t, int n) {
        if (t < 0 || t >= 5) {
            System.out.println("Assertion Failure: (t>=0) && (t<GameScreen.cNumTypes)\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[1394]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (n < 0 || n >= numItems[t]) {
            System.out.println("Assertion Failure: (n>=0) && (n<numItems[t])\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[1395]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int price = this.itemPrice[t][n];
        if (inventory[t][n]) {
            this.openMessageBox(ShopScreen.strItemName(t, n) + "\n\n" + ShopScreen.strItemDescription(t, n) + "\n\n" + "" + MultiLingual.get(234) + "");
        } else if (price > GameSequence.playerCash) {
            this.openMessageBox("" + MultiLingual.get(232) + "");
        } else {
            this.attemptBuySellType = t;
            this.attemptBuySellIndex = n;
            this.openConfirmDialog(ShopScreen.strItemName(t, n) + "\n\n" + ShopScreen.strItemDescription(t, n) + "\n\n" + "" + MultiLingual.get(229) + "", 1);
        }
    }

    private void attemptSellItem(int t, int n) {
        if (t < 0 || t >= 5) {
            System.out.println("Assertion Failure: (t>=0) && (t<GameScreen.cNumTypes)\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[1424]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (n < 0 || n >= numItems[t]) {
            System.out.println("Assertion Failure: (n>=0) && (n<numItems[t])\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/game/ShopScreen.java[1425]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int price = this.itemPrice[t][n];
        if (!inventory[t][n]) {
            this.openMessageBox("" + MultiLingual.get(237) + "");
        } else if (t != 4 && this.numItemsHeldOfThisType(t) == 1) {
            this.openMessageBox("" + MultiLingual.get(233) + "");
        } else {
            this.attemptBuySellType = t;
            this.attemptBuySellIndex = n;
            this.openConfirmDialog("" + MultiLingual.get(230) + "", 2);
        }
    }

    private void openConfirmDialog(String message, int onYesEvent) {
        this.openDialog(message, 0, onYesEvent);
    }

    private void openMessageBox(String message) {
        this.openDialog(message, 1, 0);
    }

    private void openDialog(String message, int buttons, int onYesEvent) {
        this.dialogImage = new TextScrollLayout();
        this.dialogImage.textLayout.iLayoutFlags = cCentre;
        this.dialogImage.clipRect.x0 = (short)8;
        this.dialogImage.clipRect.y0 = (short)8;
        this.dialogImage.clipRect.h = (short)(BaseScreen.displayHeight - this.dialogImage.clipRect.y0 - softkeyHeight);
        this.dialogImage.clipRect.w = (short)(BaseScreen.displayWidth - 16);
        this.dialogImage.textLayout.clearText();
        this.dialogImage.textLayout.formatText(ScreenStack.fontSmall, message);
        this.dialogImage.open();
        if (this.dialogImage.textLayout.rectDocument.h < this.dialogImage.clipRect.h) {
            this.dialogImage.clipRect.y0 = (short)(this.dialogImage.clipRect.y0 + (this.dialogImage.clipRect.h - this.dialogImage.textLayout.rectDocument.h) >> 1);
            this.dialogImage.clipRect.h = (short)(this.dialogImage.textLayout.rectDocument.h + 1);
            this.dialogImage.open();
        }
        this.buttonType = buttons;
        this.yesEvent = onYesEvent;
    }

    void updateDialog() {
        if (this.buttonType == 1) {
            if (ScreenLayout.keysPressed(32768)) {
                this.dialogImage = null;
            }
        } else if (this.buttonType == 0) {
            if (ScreenLayout.keysPressed(32768)) {
                this.dialogImage = null;
                if (this.yesEvent == 3) {
                    this.quitDialogActive = false;
                    this.state = 3;
                    GameApp.autoSave();
                } else {
                    int t = this.attemptBuySellType;
                    int n = this.attemptBuySellIndex;
                    int price = this.itemPrice[t][n];
                    if (this.yesEvent == 1) {
                        ShopScreen.inventory[t][n] = true;
                        GameSequence.playerCash -= price;
                        this.updateMoneyText();
                    } else if (this.yesEvent == 2) {
                        ShopScreen.inventory[t][n] = false;
                        GameSequence.playerCash += this.getSellPrice(price);
                        this.updateMoneyText();
                        this.updateItemText();
                        this.updateItemTypeFromCursor();
                    }
                }
            } else if (ScreenLayout.keysPressed(65536)) {
                this.dialogImage = null;
                this.quitDialogActive = false;
            }
        }
    }

    private void openBBDialog(String message, boolean transition, int event) {
        this.bbLayout = new TextScrollLayout();
        this.bbLayout.textLayout.iLayoutFlags = cCentre;
        this.bbLayout.clipRect.x0 = transition ? (short)(BaseScreen.displayWidth - 1) : (short)0;
        this.bbLayout.clipRect.y0 = (short)(BaseScreen.displayHeight >> 1);
        this.bbLayout.clipRect.h = (short)(BaseScreen.displayHeight - this.bbLayout.clipRect.y0 - softkeyHeight);
        this.bbLayout.textLayout.clearText();
        this.bbLayout.textLayout.formatText(ScreenStack.fontSmall, message);
        this.bbLayout.open();
        if (transition) {
            this.bbState = 1;
            this.fpBBTransWipe = 65536;
        } else {
            this.bbState = 2;
        }
        this.bbEvent = event;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getBBIntroText() {
        GameSequence gs = FrontEnd.instance.gameSequence;
        if (GameSequence.competition == 0) {
            if (GameSequence.day <= 1) {
                return "" + MultiLingual.get(239) + "";
            }
        }
        if (GameSequence.competition == 0) {
            if (GameSequence.day == 2) {
                return "" + MultiLingual.get(240) + "";
            }
        }
        int speechIndex = GameLogic.randRange(0, gs.strShopKeeperSpeechLength() - 1);
        return "" + MultiLingual.get(238) + "\n\n" + GameSequence.strShopKeeperSpeech(speechIndex);
    }

    private String getBBOutroText() {
        GameSequence gs = FrontEnd.instance.gameSequence;
        String text = "" + MultiLingual.get(243) + "\n" + GameSequence.strShopKeeperTips(this.tipIndex) + "\n\n" + MultiLingual.get(356) + "";
        ++this.tipIndex;
        if (this.tipIndex >= gs.strShopKeeperTipsLength()) {
            this.tipIndex = 0;
        }
        return text;
    }

    private void updateBBDialog() {
        block0 : switch (this.bbState) {
            case 1: {
                this.fpBBTransWipe -= ((this.fpFrontTransWipeSpeed ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-this.fpFrontTransWipeSpeed) * (long)Application.fp_deltatime >> 16)) : (int)((long)this.fpFrontTransWipeSpeed * (long)Application.fp_deltatime >> 16);
                if (this.fpBBTransWipe <= 0) {
                    this.fpBBTransWipe = 0;
                    this.bbState = 2;
                }
                this.bbLayout.clipRect.x0 = this.getClipRectX0FromWipeValue(this.fpBBTransWipe, true);
                break;
            }
            case 3: {
                this.fpBBTransWipe += ((this.fpFrontTransWipeSpeed ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-this.fpFrontTransWipeSpeed) * (long)Application.fp_deltatime >> 16)) : (int)((long)this.fpFrontTransWipeSpeed * (long)Application.fp_deltatime >> 16);
                if (this.fpBBTransWipe >= 65536) {
                    this.fpBBTransWipe = 65536;
                    this.bbState = 6;
                }
                this.bbLayout.clipRect.x0 = this.getClipRectX0FromWipeValue(this.fpBBTransWipe, false);
                break;
            }
            case 2: {
                if (!ScreenLayout.keysPressed(32768)) break;
                this.bbState = 3;
                break;
            }
            case 6: {
                this.bbLayout = null;
                switch (this.bbEvent) {
                    case 4: {
                        this.state = 1;
                        this.updateMoneyText();
                        break block0;
                    }
                    case 5: {
                        this.state = 0;
                        this.exit();
                    }
                }
            }
        }
    }

    private short getClipRectX0FromWipeValue(int fpx, boolean dampen) {
        int x;
        int lerp = dampen ? (((fpx ^ fpx) & 0x8000000) != 0 ? -((int)((long)(-fpx) * (long)fpx >> 16)) : (int)((long)fpx * (long)fpx >> 16)) : fpx;
        int n = x = lerp * BaseScreen.displayWidth < 0 ? -(-(lerp * BaseScreen.displayWidth) >> 16) : lerp * BaseScreen.displayWidth >> 16;
        if (x > BaseScreen.displayWidth - 1) {
            x = BaseScreen.displayWidth - 1;
        }
        return (short)x;
    }

    private void exit() {
        this.resetCursor();
        GameApp.frontEnd.mapScreen.resetBoat();
        GameApp.gameScreen.updateSelectedItems();
        GameApp.frontEnd.popScreenUntil(GameApp.frontEnd.gameSequence, null);
        GameApp.frontEnd.pushScreen(GameApp.frontEnd.mapScreen, false);
    }

    public void resetCursor() {
        this.setPanelBuy();
        this.setItemType(0);
        this.cursorLevel = 1;
        this.cursorRoot = 0;
        this.cursorItemType = 0;
        this.cursorItem = 0;
        this.updateItemCursorFromIndex();
        this.updateItemText();
        this.setPanelBuy();
        this.setItemType(0);
        this.quitDialogActive = false;
    }
}

