/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gfx;

import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gfx.GfxUtils;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import com.slg.j2me.lib.snd.SoundBank;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.util.MultiLingual;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public abstract class BaseScreen
extends GameCanvas {
    public static boolean forceRedraw = true;
    public static ClipRect visibleRect = new ClipRect(0, 0, 240, 320);
    public static int displayWidth = 240;
    public static int displayHeight = 320;
    public static int cPointerMenuBarH = 60;
    public static int cPointerMenuBarY = displayHeight - cPointerMenuBarH;
    private static int cMaxRectStack = 5;
    private static ClipRect[] rectStack = new ClipRect[cMaxRectStack];
    private static int rectStackTop = 0;
    public static boolean pauseDialogShown = false;
    public static boolean isInProcessLoop = false;
    public static boolean resumeSoundAfterPause = false;
    public static int fp_sx = 65536;
    public static int fp_sy = 65536;
    public static int screensShown = 0;
    public static int frameNumber = 0;
    public static int liveInputState = 0;
    private static int liveQuickPressRelease = 0;
    public static int lastInputState = 0;
    public static int quickPressRelease = 0;
    public static int userInputState = 0;
    public static int numberKey = -1;
    public static boolean cheatsEnabled = false;
    public static final int[] cheatSequence = new int[]{49, 51, 55, 57};
    public static int cheatIndex = 0;
    public static Vector keyDebug = new Vector();
    public static BaseScreen currentScreen = null;
    public static String tempDBG = "";
    public static boolean takingScreenshot = false;
    public static Image imgDarkScreen;
    private static String lastMsg;
    private static int count;

    public BaseScreen(boolean supressKeyEvents) {
        super(false);
        this.setFullScreenMode(true);
        for (int i = 0; i < rectStack.length; ++i) {
            BaseScreen.rectStack[i] = new ClipRect(0, 0, displayWidth, displayHeight);
        }
        displayWidth = this.getWidth();
        displayHeight = this.getHeight();
        System.out.println("displayWidth " + displayWidth + " displayHeight " + displayHeight);
    }

    public abstract void paintInternal(Graphics var1);

    public static void setDefaultRes(int w, int h) {
        fp_sx = (int)(((long)(displayWidth < 0 ? -(-displayWidth << 16) : displayWidth << 16) << 16) / (long)(w < 0 ? -(-w << 16) : w << 16));
        fp_sy = (int)(((long)(displayHeight < 0 ? -(-displayHeight << 16) : displayHeight << 16) << 16) / (long)(h < 0 ? -(-h << 16) : h << 16));
    }

    public static int getScaledX(int x) {
        int fp_nx = ((fp_sx ^ (x < 0 ? -(-x << 16) : x << 16)) & 0x8000000) != 0 ? -((int)((long)(-fp_sx) * (long)(x < 0 ? -(-x << 16) : x << 16) >> 16)) : (int)((long)fp_sx * (long)(x < 0 ? -(-x << 16) : x << 16) >> 16);
        return fp_nx < 0 ? -(-fp_nx >> 16) : fp_nx >> 16;
    }

    public static int getScaledY(int y) {
        int fp_ny = ((fp_sy ^ (y < 0 ? -(-y << 16) : y << 16)) & 0x8000000) != 0 ? -((int)((long)(-fp_sy) * (long)(y < 0 ? -(-y << 16) : y << 16) >> 16)) : (int)((long)fp_sy * (long)(y < 0 ? -(-y << 16) : y << 16) >> 16);
        return fp_ny < 0 ? -(-fp_ny >> 16) : fp_ny >> 16;
    }

    public static void pushVisibleRect(ClipRect newRect) {
        if (rectStackTop >= cMaxRectStack) {
            System.out.println("Assertion Failure: rectStackTop<cMaxRectStack\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/BaseScreen.java[233]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseScreen.rectStack[BaseScreen.rectStackTop].x0 = BaseScreen.visibleRect.x0;
        BaseScreen.rectStack[BaseScreen.rectStackTop].y0 = BaseScreen.visibleRect.y0;
        BaseScreen.rectStack[BaseScreen.rectStackTop].w = BaseScreen.visibleRect.w;
        BaseScreen.rectStack[BaseScreen.rectStackTop].h = BaseScreen.visibleRect.h;
        int x1 = newRect.x0 + newRect.w;
        int y1 = newRect.y0 + newRect.h;
        int x2 = BaseScreen.visibleRect.x0 + BaseScreen.visibleRect.w;
        int y2 = BaseScreen.visibleRect.y0 + BaseScreen.visibleRect.h;
        BaseScreen.visibleRect.x0 = newRect.x0 > BaseScreen.visibleRect.x0 ? newRect.x0 : BaseScreen.visibleRect.x0;
        BaseScreen.visibleRect.y0 = newRect.y0 > BaseScreen.visibleRect.y0 ? newRect.y0 : BaseScreen.visibleRect.y0;
        BaseScreen.visibleRect.w = (short)((x1 < x2 ? x1 : x2) - BaseScreen.visibleRect.x0);
        BaseScreen.visibleRect.h = (short)((y1 < y2 ? y1 : y2) - BaseScreen.visibleRect.y0);
        ++rectStackTop;
    }

    public static void popVisibleRect() {
        if (rectStackTop > 0) {
            BaseScreen.visibleRect.x0 = BaseScreen.rectStack[--BaseScreen.rectStackTop].x0;
            BaseScreen.visibleRect.y0 = BaseScreen.rectStack[BaseScreen.rectStackTop].y0;
            BaseScreen.visibleRect.w = BaseScreen.rectStack[BaseScreen.rectStackTop].w;
            BaseScreen.visibleRect.h = BaseScreen.rectStack[BaseScreen.rectStackTop].h;
        } else {
            System.out.println("\n\n*******************************************************\nCan't pop visible rect, stack empty!\n*******************************************************\n\n");
        }
    }

    public static void clearVisibleRect() {
        while (rectStackTop > 0) {
            BaseScreen.popVisibleRect();
        }
    }

    public static void setCurrent(BaseScreen screen) {
        currentScreen = screen;
        Application.display.setCurrent((Displayable)screen);
    }

    public static void forcePaint() {
        if (currentScreen != null) {
            currentScreen.repaint();
            currentScreen.serviceRepaints();
        } else {
            System.out.println("BaseScreen.forcePaint() - currentScreen==null!");
        }
    }

    public void paint(Graphics g) {
        if (takingScreenshot) {
            return;
        }
        BaseScreen.clearVisibleRect();
        if (pauseDialogShown) {
            this.drawDarkscreen(g);
            this.drawPauseDialog(g);
        } else if (!Application.isLoading) {
            if (imgDarkScreen != null) {
                imgDarkScreen = null;
            }
            try {
                this.paintInternal(g);
            }
            catch (Exception e) {
                System.out.println("\n\n*******************************************************\nBaseScreen.paint() Exception in paintInternal()! " + e + "\n*******************************************************\n\n");
                e.printStackTrace();
            }
        }
        if (Application.isLoading) {
            this.drawLoadingDialog(g);
            Application.lastDrawnScreenWasLoading = true;
        } else {
            Application.lastDrawnScreenWasLoading = false;
        }
        forceRedraw = false;
        ++frameNumber;
    }

    protected void hideNotify() {
        System.out.println("hideNotify() " + --screensShown);
        if (Application.instance != null && screensShown <= 0) {
            Application.instance.doPause();
        }
        BaseScreen.resetKeys();
        super.hideNotify();
    }

    protected void showNotify() {
        if (pauseDialogShown) {
            SoundBank.stop(0);
        }
        System.out.println("showNotify() " + ++screensShown);
        BaseScreen.resetKeys();
        forceRedraw = true;
        super.showNotify();
    }

    public static void beginInputProcessing() {
        userInputState = liveInputState;
        quickPressRelease = liveQuickPressRelease;
        isInProcessLoop = true;
        tempDBG = tempDBG + "B";
    }

    public static void endInputProcessing() {
        isInProcessLoop = false;
        liveQuickPressRelease &= ~quickPressRelease;
        lastInputState = userInputState;
        if (resumeSoundAfterPause) {
            Application.instance.resumeSound();
            resumeSoundAfterPause = false;
        }
        tempDBG = tempDBG + "E";
    }

    public static boolean keysDown(int keys) {
        if (!isInProcessLoop) {
            System.out.println("Assertion Failure: isInProcessLoop\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/BaseScreen.java[520]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ((userInputState | quickPressRelease) & keys) != 0;
    }

    public static boolean keysPressed(int keys) {
        if (!isInProcessLoop) {
            System.out.println("Assertion Failure: isInProcessLoop\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/BaseScreen.java[525]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ((userInputState ^ lastInputState) & userInputState & keys) != 0 || (quickPressRelease & keys) != 0;
    }

    public static boolean keysReleased(int keys) {
        if (!isInProcessLoop) {
            System.out.println("Assertion Failure: isInProcessLoop\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/BaseScreen.java[530]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ((userInputState ^ lastInputState) & lastInputState & keys) != 0 || (quickPressRelease & keys) != 0;
    }

    public final void keyPressed(int keyCode) {
        System.out.println("keyPress");
        if (!Application.loaded) {
            return;
        }
        Application.applicationPaused = false;
        if (pauseDialogShown) {
            return;
        }
        if (cheatIndex >= cheatSequence.length) {
            cheatIndex = 0;
        }
        if (keyCode == cheatSequence[cheatIndex]) {
            if (++cheatIndex == cheatSequence.length) {
                cheatIndex = 0;
                System.out.println("CHEAT: ENABLED!");
                cheatsEnabled = true;
                FrontEnd.showCheatMessage = 90;
            }
        } else {
            cheatIndex = 0;
        }
        numberKey = -1;
        if (keyCode >= 48 && keyCode <= 57) {
            numberKey = keyCode - 48;
            liveInputState |= 0x20000;
        }
        if (keyCode == -6) {
            liveInputState |= 0x8000;
        }
        if (keyCode == -7) {
            liveInputState |= 0x10000;
        }
        try {
            switch (this.getGameAction(keyCode)) {
                case 2: {
                    liveInputState |= 2;
                    break;
                }
                case 5: {
                    liveInputState |= 4;
                    break;
                }
                case 6: {
                    liveInputState |= 8;
                    break;
                }
                case 1: {
                    liveInputState |= 1;
                    break;
                }
                case 8: {
                    if (keyCode == -6 || keyCode == -7 || keyCode == -11) break;
                    liveInputState |= 0x10;
                }
            }
            switch (keyCode) {
                case 49: {
                    liveInputState |= 0x20;
                    break;
                }
                case 50: {
                    liveInputState |= 1;
                    break;
                }
                case 51: {
                    liveInputState |= 0x40;
                    break;
                }
                case 52: {
                    liveInputState |= 2;
                    break;
                }
                case 53: {
                    liveInputState |= 0x10;
                    break;
                }
                case 54: {
                    liveInputState |= 4;
                    break;
                }
                case 55: {
                    liveInputState |= 0x80;
                    break;
                }
                case 56: {
                    liveInputState |= 8;
                    break;
                }
                case 57: {
                    liveInputState |= 0x100;
                    break;
                }
                case 48: {
                    liveInputState |= 0x1000;
                    break;
                }
                case 35: {
                    liveInputState |= 0x2000;
                    break;
                }
                case 42: {
                    liveInputState |= 0x4000;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void keyReleased(int keyCode) {
        System.out.println("xxkeyreleased");
        super.keyReleased(keyCode);
        if (!Application.loaded) {
            return;
        }
        if (pauseDialogShown && BaseScreen.isUnpauseKey(keyCode)) {
            BaseScreen.closePauseDialog();
            return;
        }
        int stateBefore = liveInputState;
        if (keyCode == -6) {
            liveInputState &= 0xFFFF7FFF;
        }
        if (keyCode == -7) {
            liveInputState &= 0xFFFEFFFF;
        }
        if (keyCode >= 48 && keyCode <= 57) {
            liveInputState &= 0xFFFDFFFF;
        }
        try {
            switch (this.getGameAction(keyCode)) {
                case 2: {
                    liveInputState &= 0xFFFFFFFD;
                    break;
                }
                case 5: {
                    liveInputState &= 0xFFFFFFFB;
                    break;
                }
                case 6: {
                    liveInputState &= 0xFFFFFFF7;
                    break;
                }
                case 1: {
                    liveInputState &= 0xFFFFFFFE;
                    break;
                }
                case 8: {
                    liveInputState &= 0xFFFFFFEF;
                }
            }
            switch (keyCode) {
                case 49: {
                    liveInputState &= 0xFFFFFFDF;
                    break;
                }
                case 50: {
                    liveInputState &= 0xFFFFFFFE;
                    break;
                }
                case 51: {
                    liveInputState &= 0xFFFFFFBF;
                    break;
                }
                case 52: {
                    liveInputState &= 0xFFFFFFFD;
                    break;
                }
                case 53: {
                    liveInputState &= 0xFFFFFFEF;
                    break;
                }
                case 54: {
                    liveInputState &= 0xFFFFFFFB;
                    break;
                }
                case 55: {
                    liveInputState &= 0xFFFFFF7F;
                    break;
                }
                case 56: {
                    liveInputState &= 0xFFFFFFF7;
                    break;
                }
                case 57: {
                    liveInputState &= 0xFFFFFEFF;
                    break;
                }
                case 48: {
                    liveInputState &= 0xFFFFEFFF;
                    break;
                }
                case 35: {
                    liveInputState &= 0xFFFFDFFF;
                    break;
                }
                case 42: {
                    liveInputState &= 0xFFFFBFFF;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int keyCleared = stateBefore ^ liveInputState;
        System.out.println("keyCleared = " + keyCleared);
        if (keyCleared != 0 && (keyCleared & userInputState) == 0) {
            System.out.println("ssliveQuickPressRelease = " + (liveQuickPressRelease |= keyCleared));
        }
    }

    public static void resetKeys() {
        liveInputState = 0;
        liveQuickPressRelease = 0;
        userInputState = 0;
        numberKey = -1;
        lastInputState = 0;
        quickPressRelease = 0;
    }

    public static void openPauseDialog() {
        pauseDialogShown = true;
    }

    public static void closePauseDialog() {
        Application.setAppLoading();
        pauseDialogShown = false;
        resumeSoundAfterPause = true;
    }

    public static boolean isUnpauseKey(int keycode) {
        return keycode == 53;
    }

    public void drawPauseDialog(Graphics g) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, displayWidth * 2, displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        if (ScreenStack.font != null) {
            short w1;
            short w0 = ScreenStack.font.getTextWidth("" + MultiLingual.get(1) + "");
            int w = (w0 > (w1 = ScreenStack.font.getTextWidth("" + MultiLingual.get(3) + "")) ? w0 : w1) + 16;
            w = w < displayWidth ? w : displayWidth;
            int h = ScreenStack.font.getFontHeight() * 2;
            int x0 = (displayWidth - w) / 2;
            int y0 = displayHeight / 2 - ScreenStack.font.getFontHeight();
            g.setColor(13004800);
            g.fillRect(x0, y0 - 4, w, h + 8);
            g.setColor(0xFF0000);
            g.drawRect(x0, y0 - 4, w - 2, h + 8);
            g.drawRect(x0 - 1, y0 - 5, w, h + 10);
            ScreenStack.font.drawText(g, "" + MultiLingual.get(1) + "", (displayWidth - w0) / 2, y0, visibleRect);
            ScreenStack.font.drawText(g, "" + MultiLingual.get(3) + "", (displayWidth - w1) / 2, displayHeight / 2, visibleRect);
        }
    }

    public void drawLoadingDialog(Graphics g) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, displayWidth * 2, displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        if (ScreenStack.font != null) {
            String loading = "" + MultiLingual.get(0) + "";
            short w = ScreenStack.fontSmall.getTextWidth(loading);
            int h = ScreenStack.fontSmall.getFontHeight() + 2;
            int x0 = (displayWidth - w) / 2;
            int y0 = displayHeight - h;
            g.setColor(0);
            g.fillRect(0, y0 - 4, displayWidth, h + 8);
            g.setColor(0xFFFFFF);
            g.fillRect(0, y0 - 4, displayWidth, 2);
            ScreenStack.fontSmall.drawText(g, loading, (displayWidth - w) / 2, y0 + (h - ScreenStack.font.getFontHeight()) / 2, visibleRect);
        }
        System.out.println("LOADING...");
    }

    public void process() {
    }

    public Image takeScreenShot() {
        try {
            System.out.println("takeScreenShot() - capture current screen");
            takingScreenshot = true;
            Image screenshot = Image.createImage((int)displayWidth, (int)displayHeight);
            if (screenshot == null) {
                takingScreenshot = false;
                return null;
            }
            Graphics rendertarget = screenshot.getGraphics();
            if (rendertarget == null) {
                takingScreenshot = false;
                return null;
            }
            this.paintInternal(rendertarget);
            takingScreenshot = false;
            return screenshot;
        }
        catch (Exception exception) {
            takingScreenshot = false;
            return null;
        }
    }

    public void drawDarkscreen(Graphics g) {
        if (imgDarkScreen == null && (imgDarkScreen = this.takeScreenShot()) != null) {
            imgDarkScreen = GfxUtils.createDarkImage(imgDarkScreen, 0, 0, displayWidth, displayHeight);
        }
        if (imgDarkScreen != null) {
            if (ImageSequence.clipSet) {
                g.setClip(0, 0, displayWidth * 2, displayHeight * 2);
                ImageSequence.clipSet = false;
            }
            g.drawImage(imgDarkScreen, 0, 0, 20);
        } else {
            GfxUtils.drawCrossHatch(g, 0, 0, 0, displayWidth, displayHeight);
        }
    }

    public static void debugToScreen(String msg) {
        int max = displayHeight / Font.getDefaultFont().getHeight() - 1;
        int size = keyDebug.size();
        String tmp = msg;
        if (msg.equals(lastMsg)) {
            for (int i = 0; i < count; ++i) {
                tmp = tmp + ".";
            }
            keyDebug.removeElementAt(size - 1);
            if (++count > 4) {
                count = 0;
            }
        } else {
            count = 0;
        }
        keyDebug.addElement(tmp);
        lastMsg = msg;
        if (size == max) {
            keyDebug.removeElementAt(0);
        }
        currentScreen.forcePaint();
    }

    static {
        lastMsg = "";
        count = 0;
    }
}

