/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.slg.j2me.game.GameApp;
import com.slg.j2me.game.GameLogic;
import com.slg.j2me.game.GameScreen;
import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.GfxUtils;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.sys.FixedPoint;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameEffects {
    public static ImageSet isEffects;
    private ImageSequence[] gfxEffects = new ImageSequence[15];
    private String[] fxNames = new String[]{"ripple-big", "ripple-small", "splash-medium", "splash-big-left", "splash-big-right", "fish-head-splash-big", "fish-head-splash-mid", "fish-head-splash-small", "money-shot-small", "money-shot-med", "money-shot-large", "money-shot-vlarge", "bubble-small", "bubble-medium", "bubble-large"};
    static final int effectStateDead = 0;
    static final int effectStateAlive = 1;
    public static final int cEffectIdRippleBig = 0;
    public static final int cEffectIdRippleSmall = 1;
    public static final int cEffectIdSplashMedium = 2;
    public static final int cEffectIdBigSplashLeft = 3;
    public static final int cEffectIdBigSplashRight = 4;
    public static final int cEffectFishHeadL = 5;
    public static final int cEffectFishHeadM = 6;
    public static final int cEffectFishHeadS = 7;
    public static final int cEffectFishMoneyShotS = 8;
    public static final int cEffectFishMoneyShotM = 9;
    public static final int cEffectFishMoneyShotL = 10;
    public static final int cEffectFishMoneyShotXL = 11;
    public static final int cEffectFishBubbleS = 12;
    public static final int cEffectFishBubbleM = 13;
    public static final int cEffectFishBubbleL = 14;
    public static final int cEffectNumTypes = 15;
    public static final int eCentre = 0;
    public static final int eLeft = 1;
    public static final int eTop = 1;
    public static final int eRight = 2;
    public static final int eBottom = 2;
    public static final int[][] anchor;
    public static final boolean[] isLooping;
    public static final int eAnimSpeedFast = 5000;
    public static final int eAnimSpeedDefault = 7500;
    public static final int eAnimSpeedSlow = 10000;
    public static final int[] cAnimSpeed;
    public boolean fishHeadOn = false;
    public boolean fishHeadDrawn = false;
    static final int cMaxEffects = 10;
    int[] effectXpos = new int[10];
    int[] effectYpos = new int[10];
    int[] effectId = new int[10];
    int[] effectState = new int[10];
    int[] effectCurrFrame = new int[10];
    int[] effectAnimClock = new int[10];
    int[] effectAnimSpeed = new int[10];
    boolean[] effectAnimDir = new boolean[10];
    int[] effectGeneralVar = new int[10];
    int[] effectLayer = new int[10];
    int[] attachedFish = new int[10];
    int fp_waterAngle = FixedPoint.stringToFP("0.71");
    int[] fishInWaterScreenPos = new int[4];
    private static int[] floatScreenPos;
    private int fpTrophyPhase0 = 0;
    private int fpTrophyPhase1 = 32768;
    private int[] trophyColours = new int[]{0xFF0000, 0xFF0080, 0xFF00FF, 0x8000FF, 255, 255, 0x8000FF, 0xFF00FF, 0xFF0080};
    private int trophyColourIndex = 0;
    private static final int numConfetti = 30;
    private static int confetti_time;
    private static int[][] confetti_pos;
    private static int[][] confetti_vel;

    public GameEffects() {
        int i;
        isEffects = new ImageSet("/effects.is", false);
        for (i = 0; i < 15; ++i) {
            this.gfxEffects[i] = isEffects.getImageSequence(this.fxNames[i]);
            if (this.gfxEffects[i] != null) continue;
            System.out.println("Assertion Failure: gfxEffects[i] != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameEffects.java[198]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < 10; ++i) {
            this.effectCurrFrame[i] = 0;
            this.effectAnimClock[i] = 0;
            this.effectAnimSpeed[i] = 7500;
            this.effectAnimDir[i] = true;
        }
        this.killAllEffects();
    }

    public void hideMoneyShot() {
    }

    public void hideFightingFishHead() {
        if (this.fishHeadOn) {
            int len = this.effectState.length;
            for (int i = 0; i < len; ++i) {
                switch (this.effectId[i]) {
                    case 5: 
                    case 6: 
                    case 7: {
                        this.effectState[i] = 0;
                    }
                }
            }
            this.fishHeadOn = false;
        }
    }

    public void attachEffect(int id, int fishID) {
        if (fishID < 0) {
            System.out.println("Assertion Failure: fishID >= 0\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameEffects.java[242]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GameScreen.worldToScreenPos(this.fishInWaterScreenPos, GameLogic.fishMouthPos[fishID]);
        int sx = this.fishInWaterScreenPos[0];
        int sy = this.fishInWaterScreenPos[1];
        this.addEffect(id, sx, sy, fishID);
    }

    public void addEffect(int id, int x, int y) {
        this.addEffect(id, x, y, -1);
    }

    public void addEffect(int id, int x, int y, int attach) {
        for (int i = 0; i < this.effectState.length && (!this.fishHeadOn || id != 5 && id != 6 && id != 7); ++i) {
            if (this.effectState[i] != 0) continue;
            this.effectState[i] = 1;
            this.effectXpos[i] = x;
            this.effectYpos[i] = y;
            this.effectId[i] = id;
            this.effectCurrFrame[i] = 0;
            this.effectAnimClock[i] = cAnimSpeed[id];
            this.effectAnimSpeed[i] = cAnimSpeed[id];
            this.effectAnimDir[i] = true;
            this.effectLayer[i] = 0;
            this.attachedFish[i] = attach;
            ImageSequence gfx = this.gfxEffects[id];
            if (gfx == null) break;
            switch (id) {
                case 5: 
                case 6: 
                case 7: {
                    this.fishHeadOn = true;
                    this.fishHeadDrawn = false;
                    this.effectGeneralVar[i] = GameLogic.randRange(10, 20);
                    break;
                }
                case 3: 
                case 4: {
                    this.effectCurrFrame[i] = GameLogic.randRange(0, this.gfxEffects[3].numFrames - 1);
                }
            }
            break;
        }
    }

    public void addMoneyShot(int fishType, int x, int y) {
        int fx = 8;
        switch (fishType) {
            case 0: 
            case 1: {
                fx = 8;
                break;
            }
            case 2: {
                fx = 9;
                break;
            }
            case 3: 
            case 4: {
                fx = 10;
                break;
            }
            case 5: {
                fx = 11;
            }
        }
        this.addEffect(fx, x, y, 0);
    }

    public void setMoneyShotLayer(int layer) {
        for (int i = 0; i < this.effectState.length; ++i) {
            if (this.effectState[i] == 0 || this.effectId[i] < 8 || this.effectId[i] > 11) continue;
            this.effectLayer[i] = layer;
            return;
        }
    }

    public void addFishHead(int fishType, int x, int y) {
        int fx = 7;
        switch (fishType) {
            case 0: 
            case 1: {
                fx = 7;
                break;
            }
            case 2: 
            case 3: {
                fx = 6;
                break;
            }
            case 4: 
            case 5: {
                fx = 5;
            }
        }
        this.addEffect(fx, x, y, -1);
    }

    public void killAllEffects() {
        for (int i = 0; i < this.effectState.length; ++i) {
            this.effectState[i] = 0;
        }
    }

    public void moveEffects() {
        ImageSequence gfx = null;
        block9: for (int i = 0; i < this.effectState.length; ++i) {
            if (this.effectState[i] == 0) continue;
            int id = this.effectId[i];
            gfx = this.gfxEffects[id];
            if (gfx != null) {
                if (this.attachedFish[i] != -1) {
                    GameScreen.worldToScreenPos(this.fishInWaterScreenPos, GameLogic.fishMouthPos[this.attachedFish[i]]);
                    this.effectXpos[i] = this.fishInWaterScreenPos[0];
                    this.effectYpos[i] = this.fishInWaterScreenPos[1];
                }
                int n = this.effectAnimClock[i] = 0 > this.effectAnimClock[i] - Application.fp_deltatime ? 0 : this.effectAnimClock[i] - Application.fp_deltatime;
                if (this.effectAnimClock[i] <= 0) {
                    this.effectAnimClock[i] = this.effectAnimSpeed[i];
                    boolean done = false;
                    if (this.effectAnimDir[i]) {
                        int n2 = i;
                        this.effectCurrFrame[n2] = this.effectCurrFrame[n2] + 1;
                        if (this.effectCurrFrame[i] >= gfx.numFrames) {
                            done = true;
                        }
                    } else {
                        int n3 = i;
                        this.effectCurrFrame[n3] = this.effectCurrFrame[n3] - 1;
                        if (this.effectCurrFrame[i] < 0) {
                            done = true;
                        }
                    }
                    if (done) {
                        if (isLooping[id]) {
                            boolean flip = false;
                            switch (id) {
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    flip = true;
                                    this.effectAnimClock[i] = GameLogic.randRange(5000, 10000);
                                }
                            }
                            if (flip) {
                                if (this.effectAnimDir[i]) {
                                    int n4 = i;
                                    this.effectCurrFrame[n4] = this.effectCurrFrame[n4] - 2;
                                    this.effectCurrFrame[i] = this.effectCurrFrame[i] > 0 ? this.effectCurrFrame[i] : 0;
                                    this.effectAnimDir[i] = false;
                                } else {
                                    int n5 = i;
                                    this.effectCurrFrame[n5] = this.effectCurrFrame[n5] + 2;
                                    this.effectCurrFrame[i] = this.effectCurrFrame[i] < gfx.numFrames - 1 ? this.effectCurrFrame[i] : gfx.numFrames - 1;
                                    this.effectAnimDir[i] = true;
                                }
                            } else {
                                this.effectCurrFrame[i] = 0;
                            }
                            switch (id) {
                                case 5: 
                                case 6: 
                                case 7: {
                                    int n6 = i;
                                    this.effectGeneralVar[n6] = this.effectGeneralVar[n6] - 1;
                                    if (this.effectGeneralVar[n6] <= 0) {
                                        this.effectGeneralVar[i] = GameLogic.randRange(15, 20);
                                    }
                                    if (this.effectGeneralVar[i] != 10) break;
                                    this.addEffect(2, this.effectXpos[i], this.effectYpos[i]);
                                }
                            }
                        } else {
                            this.effectState[i] = 0;
                            if (id == 2) {
                                this.addEffect(0, this.effectXpos[i], this.effectYpos[i]);
                            }
                        }
                    }
                }
            }
            switch (id) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    GameScreen.worldToScreenPos(floatScreenPos, GameScreen.floatPos);
                    this.effectXpos[i] = floatScreenPos[0];
                    this.effectYpos[i] = floatScreenPos[1];
                    if (GameScreen.game.currentState != 8) {
                        if (GameScreen.game.currentState != 7) continue block9;
                    }
                    int n = i;
                    this.effectYpos[n] = this.effectYpos[n] + GameApp.gameScreen.bigBoatYwave;
                }
            }
        }
    }

    public void drawEffects(Graphics g, int layer) {
        ImageSequence gfx = null;
        for (int i = 0; i < this.effectState.length; ++i) {
            if (this.effectState[i] == 0 || this.effectLayer[i] != layer) continue;
            int id = this.effectId[i];
            gfx = this.gfxEffects[id];
            int ex = this.effectXpos[i];
            int ey = this.effectYpos[i];
            if (gfx != null) {
                int anchorX = anchor[id][0];
                int anchorY = anchor[id][1];
                if (anchorX == 0) {
                    ex -= gfx.getRectWidth(0) >> 1;
                } else if (anchorX == 2) {
                    ex -= gfx.getRectWidth(0);
                }
                if (anchorY == 0) {
                    ey -= gfx.getRectHeight(0) >> 1;
                } else if (anchorY == 2) {
                    ey -= gfx.getRectHeight(0);
                }
            }
            switch (id) {
                case 5: 
                case 6: 
                case 7: {
                    if (this.effectGeneralVar[i] <= 10) {
                        gfx = null;
                        this.fishHeadDrawn = false;
                        break;
                    }
                    this.fishHeadDrawn = true;
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    ey -= BaseScreen.getScaledY(4);
                    break;
                }
                case 11: {
                    ey -= BaseScreen.getScaledY(4);
                }
            }
            if (gfx == null) continue;
            gfx.drawImage(g, this.effectCurrFrame[i], ex, ey);
        }
    }

    public void DrawWaterWithInOutAnimation(Graphics g, Image img, int startx, int yStart, int yOffset, int iDistortStart, int fpAngleUpdate, int amplitude, boolean paused) {
        int amplitudeX = 0;
        int amplitudeY = 0;
        int fp_ang = this.fp_waterAngle;
        for (int y = 0; y < img.getHeight(); ++y) {
            amplitudeX = FixedPoint.stringToFP("2.0");
            int up_down_animation_offset = (((FixedPoint.sinLut(fp_ang) ^ amplitudeX) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_ang)) * (long)amplitudeX >> 16)) : (int)((long)FixedPoint.sinLut(fp_ang) * (long)amplitudeX >> 16)) < 0 ? -(-(((FixedPoint.sinLut(fp_ang) ^ amplitudeX) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_ang)) * (long)amplitudeX >> 16)) : (int)((long)FixedPoint.sinLut(fp_ang) * (long)amplitudeX >> 16)) >> 16) : (((FixedPoint.sinLut(fp_ang) ^ amplitudeX) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_ang)) * (long)amplitudeX >> 16)) : (int)((long)FixedPoint.sinLut(fp_ang) * (long)amplitudeX >> 16)) >> 16;
            g.setClip(0, yStart + yOffset + y, BaseScreen.displayWidth, 1);
            g.drawImage(img, startx, yStart + yOffset + up_down_animation_offset, 0x10 | 4);
            amplitudeX += amplitude;
            amplitudeY += amplitude;
            fp_ang += fpAngleUpdate;
            fp_ang &= 0xFFFFFF;
        }
        if (!paused) {
            this.fp_waterAngle += ((0x320000 ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)(-3276800L * (long)Application.fp_deltatime >> 16)) : (int)(0x320000L * (long)Application.fp_deltatime >> 16);
            this.fp_waterAngle &= 0xFFFFFF;
        }
        g.setClip(0, 0, BaseScreen.displayWidth, BaseScreen.displayHeight);
    }

    public void drawTrophyBackground(Graphics g) {
        int w = BaseScreen.displayWidth;
        int h = BaseScreen.displayHeight;
        int cx = w >> 1;
        int cy = h >> 1;
        if (w > h) {
            h = w;
        } else {
            w = h;
        }
        int rx0 = ((w ^ this.fpTrophyPhase0) & 0x8000000) != 0 ? -((int)((long)(-w) * (long)this.fpTrophyPhase0 >> 16)) : (int)((long)w * (long)this.fpTrophyPhase0 >> 16);
        int ry0 = ((h ^ this.fpTrophyPhase0) & 0x8000000) != 0 ? -((int)((long)(-h) * (long)this.fpTrophyPhase0 >> 16)) : (int)((long)h * (long)this.fpTrophyPhase0 >> 16);
        int rx1 = ((w ^ this.fpTrophyPhase1) & 0x8000000) != 0 ? -((int)((long)(-w) * (long)this.fpTrophyPhase1 >> 16)) : (int)((long)w * (long)this.fpTrophyPhase1 >> 16);
        int ry1 = ((h ^ this.fpTrophyPhase1) & 0x8000000) != 0 ? -((int)((long)(-h) * (long)this.fpTrophyPhase1 >> 16)) : (int)((long)h * (long)this.fpTrophyPhase1 >> 16);
        int numCols = this.trophyColours.length;
        int trophyCol0 = this.trophyColours[this.trophyColourIndex];
        int nextIndex = this.trophyColourIndex - 1;
        if (nextIndex < 0) {
            nextIndex = numCols - 1;
        }
        int trophyCol1 = this.trophyColours[nextIndex];
        if (this.fpTrophyPhase0 < this.fpTrophyPhase1) {
            int col1 = GfxUtils.lerpColour(this.fpTrophyPhase1, trophyCol1, 0);
            int col0 = GfxUtils.lerpColour(this.fpTrophyPhase0, trophyCol0, col1);
            g.setColor(col1);
            g.fillArc(cx - (rx1 >> 1), cy - (ry1 >> 1), rx1, ry1, 0, 360);
            g.setColor(col0);
            g.fillArc(cx - (rx0 >> 1), cy - (ry0 >> 1), rx0, ry0, 0, 360);
        } else {
            int col0 = GfxUtils.lerpColour(this.fpTrophyPhase0, trophyCol0, 0);
            int col1 = GfxUtils.lerpColour(this.fpTrophyPhase1, trophyCol1, col0);
            g.setColor(col0);
            g.fillArc(cx - (rx0 >> 1), cy - (ry0 >> 1), rx0, ry0, 0, 360);
            g.setColor(col1);
            g.fillArc(cx - (rx1 >> 1), cy - (ry1 >> 1), rx1, ry1, 0, 360);
        }
        int fpAdd = 1000;
        this.fpTrophyPhase0 += fpAdd;
        if (this.fpTrophyPhase0 >= 65536) {
            ++this.trophyColourIndex;
            if (this.trophyColourIndex >= numCols) {
                this.trophyColourIndex = 0;
            }
        }
        this.fpTrophyPhase0 &= 0xFFFF;
        this.fpTrophyPhase1 += fpAdd;
        this.fpTrophyPhase1 &= 0xFFFF;
    }

    public static void resetConfetti(int i) {
        GameEffects.confetti_pos[i][0] = GameLogic.randRange(0, BaseScreen.displayWidth < 0 ? -(-BaseScreen.displayWidth << 16) : BaseScreen.displayWidth << 16);
        GameEffects.confetti_pos[i][1] = -GameLogic.randRange(0x100000, BaseScreen.displayHeight < 0 ? -(-BaseScreen.displayHeight << 16) : BaseScreen.displayHeight << 16);
        GameEffects.confetti_vel[i][0] = GameLogic.randRange(-1048576, 0x100000);
        GameEffects.confetti_vel[i][1] = GameLogic.randRange(0x180000, 0x280000);
    }

    public static void initConfetti() {
        for (int i = 0; i < 30; ++i) {
            GameEffects.resetConfetti(i);
        }
        confetti_time = 0;
    }

    public static void drawConfetti(Graphics g, ImageSequence[] confetti) {
        if ((confetti_time += Application.lastFrameTime) > 500) {
            confetti_time = 0;
        }
        for (int i = 0; i < 30; ++i) {
            GameEffects.confetti_pos[i][0] = confetti_pos[i][0] + (((confetti_vel[i][0] ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-confetti_vel[i][0]) * (long)Application.fp_deltatime >> 16)) : (int)((long)confetti_vel[i][0] * (long)Application.fp_deltatime >> 16));
            GameEffects.confetti_pos[i][1] = confetti_pos[i][1] + (((confetti_vel[i][1] ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-confetti_vel[i][1]) * (long)Application.fp_deltatime >> 16)) : (int)((long)confetti_vel[i][1] * (long)Application.fp_deltatime >> 16));
            if (confetti_pos[i][0] < -524288 || confetti_pos[i][0] > (BaseScreen.displayWidth + 8 < 0 ? -(-(BaseScreen.displayWidth + 8) << 16) : BaseScreen.displayWidth + 8 << 16) || confetti_pos[i][1] > (BaseScreen.displayHeight + 8 < 0 ? -(-(BaseScreen.displayHeight + 8) << 16) : BaseScreen.displayHeight + 8 << 16)) {
                GameEffects.resetConfetti(i);
            }
            confetti[i & 3].drawImage(g, confetti_time > 250 ? 1 : 0, confetti_pos[i][0] < 0 ? -(-confetti_pos[i][0] >> 16) : confetti_pos[i][0] >> 16, confetti_pos[i][1] < 0 ? -(-confetti_pos[i][1] >> 16) : confetti_pos[i][1] >> 16);
        }
    }

    public void unload() {
        isEffects.unloadImages();
    }

    public void reload() {
        isEffects.reloadImages();
    }

    static {
        anchor = new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 2}, {0, 2}, {0, 2}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}};
        isLooping = new boolean[]{false, false, false, false, false, true, true, true, true, true, true, true, false, false, false};
        cAnimSpeed = new int[]{5000, 5000, 7500, 7500, 7500, 7500, 7500, 7500, 7500, 7500, 7500, 7500, 10000, 10000, 10000};
        floatScreenPos = new int[4];
        confetti_time = 0;
        confetti_pos = new int[30][2];
        confetti_vel = new int[30][2];
    }
}

