/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.game.GameScreen;
import com.slg.j2me.game.HiscoreTable;
import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import com.slg.j2me.lib.snd.SoundBank;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.sys.FixedPoint;
import com.slg.j2me.lib.util.MultiLingual;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class GameApp
extends Application {
    public static final String[] recordStoreNames = new String[]{"career", "quick"};
    public static GameScreen gameScreen = null;
    public static FrontEnd frontEnd = null;
    public static HiscoreTable hiscoreTable = null;
    public static int lastTunePlaying = -1;
    public static final int eTuneMenu = 0;
    public static final int eTuneWin = 1;
    public static final int eTuneLose = 2;
    public static final int eTuneBite = 3;
    public static final int eTuneCatch = 4;
    public static final int eTuneSailing = 5;
    public static final int eTuneFishing = 6;
    public static final int eTuneShop = 7;
    public static boolean playCaught = true;
    public static boolean playWon = true;
    public static final String[] midifiles = new String[]{"/menu.mid", "/win.mid", "/lose.mid", "/bite_edit.mid", "/catch.mid", "/sailing.mid", "/fishing2.mid", "/shop.mid"};
    public static final boolean[] tuneLoop = new boolean[]{true, false, false, true, false, true, true, true};
    private static final String[] defaultNames = new String[]{"MATT", "MARK", "PAUL", "STEVE", "CHRIS"};
    private static final int[][] defaultScores = new int[][]{{560, 480, 400, 320, 240}, {224, 192, 160, 128, 96}, {5005, 2004, 1504, 1003, 753}};
    public static final int cHiscoreBiggestCatch = 0;
    public static final int cHiscoreBiggestFish = 1;
    public static final int cHiscoreArcadeScore = 2;
    public static final int cHiscoreNumVisisbleTables = 3;
    public static final int cHiscoreNumTables = 3;
    public static int scoreArcadePersonalBest = 100;
    public static int scoreArcadeAllTimeBest = 625;

    public static synchronized RecordStore RS_open(String storeName) {
        try {
            return RecordStore.openRecordStore((String)storeName, (boolean)true);
        }
        catch (RecordStoreException ex) {
            System.out.println("\n\n*******************************************************\nUnable to access " + storeName + "\n*******************************************************\n\n");
            return null;
        }
    }

    public static synchronized void RS_delete(String storeName) {
        try {
            RecordStore.deleteRecordStore((String)storeName);
        }
        catch (RecordStoreNotFoundException e) {
        }
        catch (RecordStoreException rse) {
            System.out.println("\n\n*******************************************************\nRecordStoreException: " + (Object)((Object)rse) + "\n*******************************************************\n\n");
        }
    }

    public static synchronized boolean RS_exists(String rs_name) {
        System.out.println("Checking " + rs_name + " exists...");
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)rs_name, (boolean)false);
            if (rs != null) {
                rs.closeRecordStore();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GameApp() {
        block27: {
            System.out.println("-----------------APPLICATION-ENTRY-POINT----------------------");
            System.out.println("Loading locale...");
            RecordStore rs = null;
            try {
                rs = GameApp.RS_open("locale");
                if (rs != null) {
                    if (rs == null) {
                        System.out.println("Assertion Failure: rs!=null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[223]");
                        try {
                            throw new Exception();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    byte[] byteArray = null;
                    ByteArrayInputStream byteInputStream = null;
                    FilterInputStream dataInputStream = null;
                    try {
                        byteArray = rs.getRecord(1);
                        if (byteArray == null) {
                            System.out.println("Assertion Failure: byteArray != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[223]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if ((byteInputStream = new ByteArrayInputStream(byteArray)) == null) {
                            System.out.println("Assertion Failure: byteInputStream != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[223]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if ((dataInputStream = new DataInputStream(byteInputStream)) == null) {
                            System.out.println("Assertion Failure: dataInputStream != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[223]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        MultiLingual.loadLocale((DataInputStream)dataInputStream);
                    }
                    catch (Exception e) {
                        System.out.println("\n\n*******************************************************\nRS_readdata exception " + e + "\n*******************************************************\n\n");
                        rs.closeRecordStore();
                    }
                    finally {
                        try {
                            byteInputStream.close();
                            dataInputStream.close();
                        }
                        catch (Exception e) {
                            System.out.println("\n\n*******************************************************\nRS_readdata exception " + e + "\n*******************************************************\n\n");
                        }
                    }
                    rs.closeRecordStore();
                    break block27;
                }
                System.out.println("\n\n*******************************************************\nRS_Load: record store null on open - locale\n*******************************************************\n\n");
            }
            catch (Exception e) {
                System.out.println("RS_Load: Failed to load recordstore! " + e + " " + "locale");
            }
        }
        MultiLingual.load("/ml.bin");
        FixedPoint.startup();
        BaseScreen.setDefaultRes(240, 320);
        frontEnd = new FrontEnd();
        frontEnd.setBackgroundColour(0xFFFFFF);
        BaseScreen.setCurrent(frontEnd);
        frontEnd.loadImage("/plr1logo.png");
        Application.logoTime = System.currentTimeMillis();
        this.backgroundLoad();
        System.out.println("--------------------CONSTRUCTOR-COMPLETE-----------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        block35: {
            System.out.println("-------------STARTING-BACKGROUND-LOADING---------------------");
            try {
                hiscoreTable = new HiscoreTable(3);
                hiscoreTable.makeDefaultTable(3, defaultNames, defaultScores);
            }
            catch (Exception ex) {
                System.out.println("\n\n*******************************************************\nException in hiscore table creation " + ex + "\n*******************************************************\n\n");
                ex.printStackTrace();
                Application.logError(2);
            }
            System.out.println("-------------------------------------------------------------");
            System.out.println("MIDIBank.startup()");
            try {
                SoundBank.setChannelSounds(0, midifiles);
            }
            catch (Exception e) {
                System.out.println("\n\n*******************************************************\nException in midi startup() " + e + "\n*******************************************************\n\n");
                e.printStackTrace();
                Application.logError(2);
            }
            System.out.println("-------------------------------------------------------------");
            System.out.println("FrontEnd.startup()");
            try {
                frontEnd.startup();
            }
            catch (Exception e) {
                System.out.println("\n\n*******************************************************\nException in FrontEnd.startup() " + e + "\n*******************************************************\n\n");
                e.printStackTrace();
                Application.logError(1);
            }
            System.out.println("Loading frontEnd...");
            RecordStore rs = null;
            try {
                rs = GameApp.RS_open("frontEnd");
                if (rs != null) {
                    if (rs == null) {
                        System.out.println("Assertion Failure: rs!=null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[295]");
                        try {
                            throw new Exception();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    byte[] byteArray = null;
                    ByteArrayInputStream byteInputStream = null;
                    FilterInputStream dataInputStream = null;
                    try {
                        byteArray = rs.getRecord(1);
                        if (byteArray == null) {
                            System.out.println("Assertion Failure: byteArray != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[295]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if ((byteInputStream = new ByteArrayInputStream(byteArray)) == null) {
                            System.out.println("Assertion Failure: byteInputStream != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[295]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if ((dataInputStream = new DataInputStream(byteInputStream)) == null) {
                            System.out.println("Assertion Failure: dataInputStream != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[295]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        frontEnd.loadOptions((DataInputStream)dataInputStream);
                    }
                    catch (Exception e) {
                        System.out.println("\n\n*******************************************************\nRS_readdata exception " + e + "\n*******************************************************\n\n");
                        rs.closeRecordStore();
                    }
                    finally {
                        try {
                            byteInputStream.close();
                            dataInputStream.close();
                        }
                        catch (Exception e) {
                            System.out.println("\n\n*******************************************************\nRS_readdata exception " + e + "\n*******************************************************\n\n");
                        }
                    }
                    rs.closeRecordStore();
                    break block35;
                }
                System.out.println("\n\n*******************************************************\nRS_Load: record store null on open - frontEnd\n*******************************************************\n\n");
            }
            catch (Exception e) {
                System.out.println("RS_Load: Failed to load recordstore! " + e + " " + "frontEnd");
            }
        }
        Application.printMemoryStatus();
        System.out.println("-------------------------------------------------------------");
        frontEnd.loadTitleScreen();
        System.out.println("-------------------------------------------------------------");
        System.out.println("Creating GameScreen()");
        try {
            gameScreen = new GameScreen();
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nException in GameScreen constructor " + e + "\n*******************************************************\n\n");
            e.printStackTrace();
            Application.logError(3);
        }
        System.out.println("Created GameScreen()");
        System.out.println("-------------------------------------------------------------");
        System.out.println("-------------------------------------------------------------");
        GameApp.autoLoad();
        System.out.println("----------------BACKGROUND-LOADING-COMPLETE-------------------");
    }

    public void process() {
        frontEnd.process();
    }

    public void startApp() throws MIDletStateChangeException {
        if (Application.loaded) {
            GameApp.autoLoad();
        }
        if (Application.applicationPaused) {
            this.unPause();
        }
    }

    public void pauseApp() {
        System.out.println("pauseApp()");
        this.doPause();
    }

    public void doPause() {
        System.out.println("doPause()");
        if (!Application.applicationPaused) {
            lastTunePlaying = SoundBank.currentSound;
            SoundBank.shutdown();
        }
        Application.applicationPaused = true;
    }

    public void unPause() {
        System.out.println("unPause()");
        if (Application.applicationPaused) {
            Application.applicationPaused = false;
            BaseScreen.forceRedraw = true;
            BaseScreen.openPauseDialog();
        }
    }

    public void resumeSound() {
        SoundBank.setChannelSounds(0, midifiles);
        boolean loop = true;
        if (lastTunePlaying == 1 || lastTunePlaying == 2 || lastTunePlaying == 4) {
            loop = false;
        }
        if (ScreenStack.currentContainer == gameScreen) {
            gameScreen.setupSound();
        } else if (lastTunePlaying != -1) {
            SoundBank.enableSound(false);
            SoundBank.enableSound(true);
            if (lastTunePlaying == 1 || lastTunePlaying == 2) {
                if (playWon) {
                    SoundBank.play(0, lastTunePlaying, loop, 0);
                }
            } else {
                SoundBank.play(0, lastTunePlaying, loop, 0);
            }
        }
        lastTunePlaying = -1;
    }

    public void destroyApp(boolean unconditional) {
        try {
            if (Application.loaded) {
                SoundBank.shutdown();
                GameApp.saveOptions();
            }
            super.destroyApp(unconditional);
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nException in destroyApp() " + e.toString() + "\n*******************************************************\n\n");
            e.printStackTrace();
        }
    }

    public static boolean checkStoreExists(int menutype) {
        System.out.println("Testing to see if " + recordStoreNames[menutype] + " exists");
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreNames[menutype], (boolean)false);
            if (rs != null) {
                System.out.println("IT exists!");
                rs.closeRecordStore();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("IT does not exist");
        return false;
    }

    public static void deleteStore(int menutype) {
        System.out.println("RECORDSTORE: DELETESTORE! " + menutype);
        if (menutype == -1) {
            System.out.println("Assertion Failure: menutype != FrontEnd.eMenuMain\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[632]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (menutype != -1) {
            System.out.println("RECORDSTORE: Deleting store " + recordStoreNames[menutype]);
            GameApp.RS_delete(recordStoreNames[menutype]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void autoLoad() {
        block27: {
            try {
                System.out.println("Loading hiscore...");
                RecordStore rs = null;
                rs = GameApp.RS_open("hiscore");
                if (rs != null) {
                    if (rs == null) {
                        System.out.println("Assertion Failure: rs!=null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[644]");
                        try {
                            throw new Exception();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    byte[] byteArray = null;
                    ByteArrayInputStream byteInputStream = null;
                    FilterInputStream dataInputStream = null;
                    try {
                        byteArray = rs.getRecord(1);
                        if (byteArray == null) {
                            System.out.println("Assertion Failure: byteArray != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[644]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if ((byteInputStream = new ByteArrayInputStream(byteArray)) == null) {
                            System.out.println("Assertion Failure: byteInputStream != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[644]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if ((dataInputStream = new DataInputStream(byteInputStream)) == null) {
                            System.out.println("Assertion Failure: dataInputStream != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/GameApp.java[644]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        hiscoreTable.loadHiscores((DataInputStream)dataInputStream);
                    }
                    catch (Exception e) {
                        System.out.println("\n\n*******************************************************\nRS_readdata exception " + e + "\n*******************************************************\n\n");
                        rs.closeRecordStore();
                    }
                    finally {
                        try {
                            byteInputStream.close();
                            dataInputStream.close();
                        }
                        catch (Exception e) {
                            System.out.println("\n\n*******************************************************\nRS_readdata exception " + e + "\n*******************************************************\n\n");
                        }
                    }
                    rs.closeRecordStore();
                    break block27;
                }
                System.out.println("\n\n*******************************************************\nRS_Load: record store null on open - hiscore\n*******************************************************\n\n");
            }
            catch (Exception ex) {
                System.out.println("\n\n*******************************************************\nError loading hiscore tables - rewriting\n*******************************************************\n\n");
                ex.printStackTrace();
                hiscoreTable.makeDefaultTable(3, defaultNames, defaultScores);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void autoSave() {
        block36: {
            FilterOutputStream dataOutputStream;
            ByteArrayOutputStream byteOutputStream;
            RecordStore rs;
            block34: {
                block32: {
                    System.out.println("***** autoSave *******");
                    System.out.println("deleting old recordstore locale");
                    GameApp.RS_delete("locale");
                    System.out.println("Saving locale...");
                    try {
                        rs = GameApp.RS_open("locale");
                        if (rs != null) {
                            byteOutputStream = null;
                            dataOutputStream = null;
                            try {
                                byteOutputStream = new ByteArrayOutputStream();
                                dataOutputStream = new DataOutputStream(byteOutputStream);
                                MultiLingual.saveLocale((DataOutputStream)dataOutputStream);
                                rs.addRecord(byteOutputStream.toByteArray(), 0, byteOutputStream.size());
                            }
                            finally {
                                try {
                                    byteOutputStream.close();
                                    dataOutputStream.close();
                                }
                                catch (Exception e) {
                                    System.out.println("\n\n*******************************************************\nRS_writedata exception " + e + "\n*******************************************************\n\n");
                                }
                            }
                            rs.closeRecordStore();
                            break block32;
                        }
                        System.out.println("\n\n*******************************************************\nRS_Save: record store null on open - locale\n*******************************************************\n\n");
                    }
                    catch (Exception e) {
                        System.out.println("\n\n*******************************************************\nRS_Save: Failed to save recordstore! " + e + " " + "locale" + "\n*******************************************************\n\n");
                    }
                }
                if (HiscoreTable.modified) {
                    System.out.println("deleting old recordstore hiscore");
                    GameApp.RS_delete("hiscore");
                    System.out.println("Saving hiscore...");
                    try {
                        rs = GameApp.RS_open("hiscore");
                        if (rs != null) {
                            byteOutputStream = null;
                            dataOutputStream = null;
                            try {
                                byteOutputStream = new ByteArrayOutputStream();
                                dataOutputStream = new DataOutputStream(byteOutputStream);
                                hiscoreTable.saveHiscores((DataOutputStream)dataOutputStream);
                                rs.addRecord(byteOutputStream.toByteArray(), 0, byteOutputStream.size());
                            }
                            finally {
                                try {
                                    byteOutputStream.close();
                                    dataOutputStream.close();
                                }
                                catch (Exception e) {
                                    System.out.println("\n\n*******************************************************\nRS_writedata exception " + e + "\n*******************************************************\n\n");
                                }
                            }
                            rs.closeRecordStore();
                            break block34;
                        }
                        System.out.println("\n\n*******************************************************\nRS_Save: record store null on open - hiscore\n*******************************************************\n\n");
                    }
                    catch (Exception e) {
                        System.out.println("\n\n*******************************************************\nRS_Save: Failed to save recordstore! " + e + " " + "hiscore" + "\n*******************************************************\n\n");
                    }
                }
            }
            System.out.println("deleting old recordstore frontEnd");
            GameApp.RS_delete("frontEnd");
            System.out.println("Saving frontEnd...");
            try {
                rs = GameApp.RS_open("frontEnd");
                if (rs != null) {
                    byteOutputStream = null;
                    dataOutputStream = null;
                    try {
                        byteOutputStream = new ByteArrayOutputStream();
                        dataOutputStream = new DataOutputStream(byteOutputStream);
                        frontEnd.saveOptions((DataOutputStream)dataOutputStream);
                        rs.addRecord(byteOutputStream.toByteArray(), 0, byteOutputStream.size());
                    }
                    finally {
                        try {
                            byteOutputStream.close();
                            dataOutputStream.close();
                        }
                        catch (Exception e) {
                            System.out.println("\n\n*******************************************************\nRS_writedata exception " + e + "\n*******************************************************\n\n");
                        }
                    }
                    rs.closeRecordStore();
                    break block36;
                }
                System.out.println("\n\n*******************************************************\nRS_Save: record store null on open - frontEnd\n*******************************************************\n\n");
            }
            catch (Exception e) {
                System.out.println("\n\n*******************************************************\nRS_Save: Failed to save recordstore! " + e + " " + "frontEnd" + "\n*******************************************************\n\n");
            }
        }
        System.out.println("...autoSave OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveOptions() {
        block36: {
            FilterOutputStream dataOutputStream;
            ByteArrayOutputStream byteOutputStream;
            RecordStore rs;
            block34: {
                block32: {
                    System.out.println("saveOptions...");
                    System.out.println("deleting old recordstore locale");
                    GameApp.RS_delete("locale");
                    System.out.println("Saving locale...");
                    try {
                        rs = GameApp.RS_open("locale");
                        if (rs != null) {
                            byteOutputStream = null;
                            dataOutputStream = null;
                            try {
                                byteOutputStream = new ByteArrayOutputStream();
                                dataOutputStream = new DataOutputStream(byteOutputStream);
                                MultiLingual.saveLocale((DataOutputStream)dataOutputStream);
                                rs.addRecord(byteOutputStream.toByteArray(), 0, byteOutputStream.size());
                            }
                            finally {
                                try {
                                    byteOutputStream.close();
                                    dataOutputStream.close();
                                }
                                catch (Exception e) {
                                    System.out.println("\n\n*******************************************************\nRS_writedata exception " + e + "\n*******************************************************\n\n");
                                }
                            }
                            rs.closeRecordStore();
                            break block32;
                        }
                        System.out.println("\n\n*******************************************************\nRS_Save: record store null on open - locale\n*******************************************************\n\n");
                    }
                    catch (Exception e) {
                        System.out.println("\n\n*******************************************************\nRS_Save: Failed to save recordstore! " + e + " " + "locale" + "\n*******************************************************\n\n");
                    }
                }
                System.out.println("deleting old recordstore frontEnd");
                GameApp.RS_delete("frontEnd");
                System.out.println("Saving frontEnd...");
                try {
                    rs = GameApp.RS_open("frontEnd");
                    if (rs != null) {
                        byteOutputStream = null;
                        dataOutputStream = null;
                        try {
                            byteOutputStream = new ByteArrayOutputStream();
                            dataOutputStream = new DataOutputStream(byteOutputStream);
                            frontEnd.saveOptions((DataOutputStream)dataOutputStream);
                            rs.addRecord(byteOutputStream.toByteArray(), 0, byteOutputStream.size());
                        }
                        finally {
                            try {
                                byteOutputStream.close();
                                dataOutputStream.close();
                            }
                            catch (Exception e) {
                                System.out.println("\n\n*******************************************************\nRS_writedata exception " + e + "\n*******************************************************\n\n");
                            }
                        }
                        rs.closeRecordStore();
                        break block34;
                    }
                    System.out.println("\n\n*******************************************************\nRS_Save: record store null on open - frontEnd\n*******************************************************\n\n");
                }
                catch (Exception e) {
                    System.out.println("\n\n*******************************************************\nRS_Save: Failed to save recordstore! " + e + " " + "frontEnd" + "\n*******************************************************\n\n");
                }
            }
            if (HiscoreTable.modified) {
                System.out.println("deleting old recordstore hiscore");
                GameApp.RS_delete("hiscore");
                System.out.println("Saving hiscore...");
                try {
                    rs = GameApp.RS_open("hiscore");
                    if (rs != null) {
                        byteOutputStream = null;
                        dataOutputStream = null;
                        try {
                            byteOutputStream = new ByteArrayOutputStream();
                            dataOutputStream = new DataOutputStream(byteOutputStream);
                            hiscoreTable.saveHiscores((DataOutputStream)dataOutputStream);
                            rs.addRecord(byteOutputStream.toByteArray(), 0, byteOutputStream.size());
                        }
                        finally {
                            try {
                                byteOutputStream.close();
                                dataOutputStream.close();
                            }
                            catch (Exception e) {
                                System.out.println("\n\n*******************************************************\nRS_writedata exception " + e + "\n*******************************************************\n\n");
                            }
                        }
                        rs.closeRecordStore();
                        break block36;
                    }
                    System.out.println("\n\n*******************************************************\nRS_Save: record store null on open - hiscore\n*******************************************************\n\n");
                }
                catch (Exception e) {
                    System.out.println("\n\n*******************************************************\nRS_Save: Failed to save recordstore! " + e + " " + "hiscore" + "\n*******************************************************\n\n");
                }
            }
        }
        System.out.println("...saveOptions OK");
    }
}

