/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.game.GameLogic;
import com.slg.j2me.game.GameScreen;
import com.slg.j2me.game.GameSequence;
import com.slg.j2me.game.ShopScreen;
import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.GfxUtils;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.gui.BitmapFont;
import com.slg.j2me.lib.gui.control.ControlHandler;
import com.slg.j2me.lib.gui.control.GuiControl;
import com.slg.j2me.lib.gui.image.TextImage;
import com.slg.j2me.lib.gui.layout.MenuLayout;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import com.slg.j2me.lib.snd.SoundBank;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.sys.FixedPoint;
import com.slg.j2me.lib.util.BitVector;
import com.slg.j2me.lib.util.MultiLingual;
import com.slg.j2me.lib.util.Rand;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MapScreen
extends ScreenLayout
implements ControlHandler {
    private static final int fpBoatThrustSlow = FixedPoint.stringToFP("25.0");
    private static final int fpBoatThrustMedium = FixedPoint.stringToFP("30.0");
    private static final int fpBoatThrustFast = FixedPoint.stringToFP("35.0");
    private static final int fpBoatSpecialThrust = FixedPoint.stringToFP("35.0");
    private static final int fpBoatRotSpeed = FixedPoint.stringToFP("90.0");
    private static final int fpBoatBounceAmplitude = FixedPoint.stringToFP("1.5");
    private static final int fpBoatBounceFrequency = FixedPoint.stringToFP("180");
    private static final int fpBoatSlowRate = FixedPoint.stringToFP("0.98");
    private static final int fpBoatSize = FixedPoint.stringToFP("4");
    private static final int maxParticleLife = 10;
    private static final int maxParticles = 10;
    private static final int particleSize = 1;
    private static final int particleSpreadX = 3;
    private static final int particleSpreadY = 3;
    private static final int particleColourStart = 11587839;
    private static final int particleColourEnd = 1847870;
    private static final int maxRipples = 16;
    private static final int fpRippleSpawnTime = FixedPoint.stringToFP("0.25");
    private static final int fpRippleLifeTime = FixedPoint.stringToFP("2");
    private static final int fpRippleSizeMin = FixedPoint.stringToFP("2");
    private static final int fpRippleSizeMax = FixedPoint.stringToFP("20");
    private static final int fpRippleSpread = FixedPoint.stringToFP("2");
    private static final int rippleArcDegrees = 120;
    private static final int rippleAngleSpreadDegrees = 90;
    private static final int rippleColourStart = 8438015;
    private static final int rippleColourEnd = 1847870;
    private static final int fpBoatHilightRadius = FixedPoint.stringToFP("6");
    private static final int fpBoatHilightExpandRadius = FixedPoint.stringToFP("16");
    private static final int boatHilightColour = 172546;
    private static final int fpSpotRadius = FixedPoint.stringToFP("3");
    private static final int fpSpotExpandRadius = FixedPoint.stringToFP("2");
    private static final int fpCurrSpotRadius = FixedPoint.stringToFP("4");
    private static final int fpCurrSpotExpandRadius = FixedPoint.stringToFP("7");
    private static final int spotCentreSize = 5;
    private static final int spotColour = 16734976;
    private static final int currSpotColour = 65280;
    private static final int spotCentreColour = 0xFF0000;
    private static final int fpFlashFrequency = FixedPoint.stringToFP("100");
    private static final int numLocations = 5;
    public static final int numFishingSpots = 9;
    private static final int fishingSpotRadius = BaseScreen.getScaledX(16);
    private static final int fishingSpotRadius2 = fishingSpotRadius * fishingSpotRadius;
    public static final int cLocationIsland = 0;
    public static final int cLocationShack = 1;
    public static final int cLocationLighthouse = 2;
    public static final int cLocationMarina = 3;
    public static final int cLocationRiver = 4;
    private static final int startX = 240;
    private static final int startY = 262;
    private static final int startRot = FixedPoint.stringToFP("224");
    private static final int startLocation = 0;
    private Image imgLake;
    private ImageSet isMap;
    private ImageSequence gfxSmallBoat;
    private ImageSequence gfxMidBoat;
    private ImageSequence gfxFastBoat;
    private ImageSequence gfxSonar;
    private BitVector colMap = null;
    private int colGranularity = 1;
    private ImageSequence gfxMenu;
    private int mapWidth;
    private int mapHeight;
    private int fpBoatX;
    private int fpBoatY;
    private int fpBoatVelX;
    private int fpBoatVelY;
    private int fpScrollX;
    private int fpScrollY;
    private int fpBoatAngle;
    private int fpBoatBounceAngle;
    private int fpBoatBounceOffset;
    private int boatFrame;
    private int sonarFrame;
    private int sonarAnimDelay;
    private ImageSequence gfxBoat = null;
    private int[] particleXpos = new int[10];
    private int[] particleYpos = new int[10];
    private int[] particleLife = new int[10];
    private int particleClock = 0;
    private int particleInitClock = 0;
    private int[][] fpRipplePos = new int[16][2];
    private int[][] fpRippleDir = new int[16][2];
    private int[] fpRippleLife = new int[16];
    private int[] fpRippleRadius = new int[16];
    private int[] rippleAngle = new int[16];
    private boolean[] rippleStopped = new boolean[16];
    private int nextRipple;
    private int fpRippleClock = 0;
    private boolean drawHilight;
    private boolean useNewSonar;
    private boolean bKeepSpot;
    private int fpFlashAngle;
    private int[][] locationBoundaryStartPos = new int[5][2];
    private int[][] locationBoundaryEndPos = new int[5][2];
    private int[][] fpLocationBoundaryDir = new int[5][2];
    private static boolean[] locationLocked = new boolean[5];
    private static boolean[] locationDefaultLockState = new boolean[5];
    public static int currentLocation = -1;
    private int lockedLocationID = -1;
    public static int currentFishingSpot = -1;
    private int[][] fishingSpotPos = new int[9][6];
    private int[] fishingSpotLocation = new int[9];
    private int findFishingSpotTimer;
    private boolean showCatchFishWarning;
    public static boolean[] fishingSpotPopulated;
    public static int[][] fishingSpotPopulation;
    public static int[] fishingSpotPopulationSize;
    public static MenuLayout currentMenu;
    public static MenuLayout menuPause;
    public static GuiControl controlPauseTitle;
    public static GuiControl controlResume;
    public static GuiControl controlMainMenu;
    private boolean isPaused = false;
    private boolean areYouSure = false;
    static final int cBorderX;
    static final int cBorderY;
    public static Rand random;
    private int randomiseTimer;
    private int spotsShown;
    public static int fishPoulationArcade;
    public static boolean bNewGame;
    int expandMult = 3;
    int sonarMax = 32;
    int sonarMin;
    int sonarCurrent = this.sonarMin = 4;
    int red = 50;
    int redfade = 0;

    public MapScreen() {
        bNewGame = true;
        this.init();
        this.initLocation(0, 184, 256, 266, 306, false);
        this.initLocation(1, 258, 183, 315, 238, true);
        this.initLocation(2, 148, 221, 142, 274, true);
        this.initLocation(3, 159, 285, 185, 302, true);
        this.initLocation(4, 289, 365, 235, 435, true);
        this.initFishingSpot(0, 195, 35, 179, 14, 255, 61, 1);
        this.initFishingSpot(1, 297, 134, 287, 64, 306, 207, 1);
        this.initFishingSpot(2, 277, 305, 207, 234, 294, 326, 0);
        this.initFishingSpot(3, 184, 172, 157, 152, 211, 184, 0);
        this.initFishingSpot(4, 75, 134, 45, 104, 110, 147, 2);
        this.initFishingSpot(5, 65, 201, 54, 184, 107, 261, 2);
        this.initFishingSpot(6, 125, 380, 78, 368, 143, 384, 3);
        this.initFishingSpot(7, 285, 442, 267, 413, 323, 457, 4);
        this.findFishingSpotTimer = 300;
        MapScreen.lockDefaultLocations();
        this.createPauseMenu();
        fishingSpotPopulated = new boolean[9];
        fishingSpotPopulation = new int[9][18];
        fishingSpotPopulationSize = new int[9];
        fishPoulationArcade = MapScreen.randRange(8, 20);
    }

    private void initLocation(int id, int sx, int sy, int ex, int ey, boolean defaultLocked) {
        this.locationBoundaryStartPos[id][0] = this.getMapScaledX(sx);
        this.locationBoundaryStartPos[id][1] = this.getMapScaledY(sy);
        this.locationBoundaryEndPos[id][0] = this.getMapScaledX(ex);
        this.locationBoundaryEndPos[id][1] = this.getMapScaledY(ey);
        MapScreen.locationDefaultLockState[id] = defaultLocked;
        int dirX = this.locationBoundaryEndPos[id][0] - this.locationBoundaryStartPos[id][0] < 0 ? -(-(this.locationBoundaryEndPos[id][0] - this.locationBoundaryStartPos[id][0]) << 16) : this.locationBoundaryEndPos[id][0] - this.locationBoundaryStartPos[id][0] << 16;
        int dirY = this.locationBoundaryEndPos[id][1] - this.locationBoundaryStartPos[id][1] < 0 ? -(-(this.locationBoundaryEndPos[id][1] - this.locationBoundaryStartPos[id][1]) << 16) : this.locationBoundaryEndPos[id][1] - this.locationBoundaryStartPos[id][1] << 16;
        int len = FixedPoint.sqrt_bits((((dirX ^ dirX) & 0x8000000) != 0 ? -((int)((long)(-dirX) * (long)dirX >> 16)) : (int)((long)dirX * (long)dirX >> 16)) + (((dirY ^ dirY) & 0x8000000) != 0 ? -((int)((long)(-dirY) * (long)dirY >> 16)) : (int)((long)dirY * (long)dirY >> 16))) + 2;
        this.fpLocationBoundaryDir[id][0] = (int)(((long)dirX << 16) / (long)len);
        this.fpLocationBoundaryDir[id][1] = (int)(((long)dirY << 16) / (long)len);
    }

    private void initFishingSpot(int id, int px, int py, int minx, int miny, int maxx, int maxy, int location) {
        this.fishingSpotPos[id][0] = this.getMapScaledX(px);
        this.fishingSpotPos[id][1] = this.getMapScaledY(py);
        this.fishingSpotPos[id][2] = this.getMapScaledX(minx);
        this.fishingSpotPos[id][3] = this.getMapScaledY(miny);
        this.fishingSpotPos[id][4] = this.getMapScaledX(maxx);
        this.fishingSpotPos[id][5] = this.getMapScaledY(maxy);
        this.fishingSpotLocation[id] = location;
        this.randomiseFishingSpots();
    }

    public static int randRange(int min, int max) {
        random = new Rand();
        int seed = (int)System.currentTimeMillis();
        random.setSeed(seed);
        return Math.abs(random.val()) % (max - min + 1) + min;
    }

    public void randomiseFishingSpots() {
        int x = 0;
        int y = 0;
        for (int i = 0; i < 6; ++i) {
            x = MapScreen.randRange(this.fishingSpotPos[i][2], this.fishingSpotPos[i][4]);
            y = MapScreen.randRange(this.fishingSpotPos[i][3], this.fishingSpotPos[i][5]);
            this.fishingSpotPos[i][0] = x;
            this.fishingSpotPos[i][1] = y;
        }
        this.randomiseTimer = 0;
        this.findFishingSpotTimer = 300;
    }

    private void init() {
        this.imgLake = ImageSet.loadImage("/lakemap.png");
        this.isMap = new ImageSet("/map.is", false);
        this.gfxSmallBoat = this.isMap.getImageSequence("map-boat");
        this.gfxMidBoat = this.isMap.getImageSequence("mid-boat");
        this.gfxFastBoat = this.isMap.getImageSequence("fast-boat");
        this.gfxSonar = this.isMap.getImageSequence("sonar");
        this.gfxMenu = this.isMap.getImageSequence("pausemenu");
        if (this.gfxSmallBoat == null) {
            System.out.println("Assertion Failure: gfxSmallBoat != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/MapScreen.java[384]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.gfxMidBoat == null) {
            System.out.println("Assertion Failure: gfxMidBoat != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/MapScreen.java[385]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.gfxFastBoat == null) {
            System.out.println("Assertion Failure: gfxFastBoat != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/MapScreen.java[386]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.gfxMenu == null) {
            System.out.println("Assertion Failure: gfxMenu != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/MapScreen.java[387]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mapWidth = this.imgLake.getWidth();
        this.mapHeight = this.imgLake.getHeight();
        this.loadCollisionData("/lakemap-heightmap.bin");
        this.resetBoat();
    }

    private void loadCollisionData(String filename) {
        try {
            DataInputStream is = new DataInputStream(this.getClass().getResourceAsStream(filename));
            this.colGranularity = is.readByte();
            this.colMap = new BitVector(0);
            this.colMap.load(is);
            System.out.println("******** Loaded collision data for map ***** ");
        }
        catch (Exception ex) {
            System.out.println("\n\n*******************************************************\nCouldn't load the collision data from: " + filename + "\n*******************************************************\n\n");
            System.out.println(ex);
        }
    }

    private int getFPScaled(int fpInitial) {
        return (((int)(((long)fpInitial << 16) / 23592960L) ^ (this.mapWidth < 0 ? -(-this.mapWidth << 16) : this.mapWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-((int)(((long)fpInitial << 16) / 23592960L))) * (long)(this.mapWidth < 0 ? -(-this.mapWidth << 16) : this.mapWidth << 16) >> 16)) : (int)((long)((int)(((long)fpInitial << 16) / 23592960L)) * (long)(this.mapWidth < 0 ? -(-this.mapWidth << 16) : this.mapWidth << 16) >> 16);
    }

    private int getMapScaledX(int initialx) {
        int fpX = (((int)(((long)(initialx < 0 ? -(-initialx << 16) : initialx << 16) << 16) / 23592960L) ^ (this.mapWidth < 0 ? -(-this.mapWidth << 16) : this.mapWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-((int)(((long)(initialx < 0 ? -(-initialx << 16) : initialx << 16) << 16) / 23592960L))) * (long)(this.mapWidth < 0 ? -(-this.mapWidth << 16) : this.mapWidth << 16) >> 16)) : (int)((long)((int)(((long)(initialx < 0 ? -(-initialx << 16) : initialx << 16) << 16) / 23592960L)) * (long)(this.mapWidth < 0 ? -(-this.mapWidth << 16) : this.mapWidth << 16) >> 16);
        return fpX < 0 ? -(-fpX >> 16) : fpX >> 16;
    }

    private int getMapScaledY(int initialy) {
        int fpY = (((int)(((long)(initialy < 0 ? -(-initialy << 16) : initialy << 16) << 16) / 0x1E00000L) ^ (this.mapHeight < 0 ? -(-this.mapHeight << 16) : this.mapHeight << 16)) & 0x8000000) != 0 ? -((int)((long)(-((int)(((long)(initialy < 0 ? -(-initialy << 16) : initialy << 16) << 16) / 0x1E00000L))) * (long)(this.mapHeight < 0 ? -(-this.mapHeight << 16) : this.mapHeight << 16) >> 16)) : (int)((long)((int)(((long)(initialy < 0 ? -(-initialy << 16) : initialy << 16) << 16) / 0x1E00000L)) * (long)(this.mapHeight < 0 ? -(-this.mapHeight << 16) : this.mapHeight << 16) >> 16);
        return fpY < 0 ? -(-fpY >> 16) : fpY >> 16;
    }

    public void resetBoat() {
        int i;
        this.fpBoatX = this.getMapScaledX(240) < 0 ? -(-this.getMapScaledX(240) << 16) : this.getMapScaledX(240) << 16;
        this.fpBoatY = this.getMapScaledY(262) < 0 ? -(-this.getMapScaledY(262) << 16) : this.getMapScaledY(262) << 16;
        this.fpBoatVelX = 0;
        this.fpBoatVelY = 0;
        this.fpScrollX = 0;
        this.fpScrollY = 0;
        this.fpBoatAngle = startRot;
        this.fpBoatBounceAngle = 0;
        this.fpBoatBounceOffset = 0;
        for (i = 0; i < 10; ++i) {
            this.particleLife[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            this.fpRippleLife[i] = 0;
        }
        this.nextRipple = 0;
        this.fpRippleClock = 0;
        if (this.gfxSonar != null) {
            this.useNewSonar = true;
        }
        this.sonarFrame = 0;
        this.sonarAnimDelay = 0;
        this.drawHilight = true;
        this.fpFlashAngle = 0;
        currentLocation = -1;
        currentFishingSpot = -1;
        this.showCatchFishWarning = false;
        this.refreshUnlockedStuff();
        this.gfxBoat = GameApp.frontEnd.shopScreen == null ? this.gfxSmallBoat : (ShopScreen.playerHasBoat2() ? this.gfxFastBoat : (ShopScreen.playerHasBoat1() ? this.gfxMidBoat : this.gfxSmallBoat));
        if (FrontEnd.gameType == 0) {
            this.gfxBoat = this.gfxSmallBoat;
        }
    }

    public void setupPauseMenuText() {
        BitmapFont pmFont = ScreenStack.fontSmallTight;
        MapScreen.controlPauseTitle.controlImage = new TextImage(ScreenStack.font, "" + MultiLingual.get(113) + "");
        MapScreen.controlResume.controlImage = new TextImage(pmFont, "" + MultiLingual.get(117) + "");
        MapScreen.controlMainMenu.controlImage = new TextImage(pmFont, "" + MultiLingual.get(116) + "");
        menuPause.layout();
    }

    public void createPauseMenu() {
        this.setupPauseMenuText();
        menuPause.addControl(controlPauseTitle);
        menuPause.addControl(controlResume);
        menuPause.addControl(controlMainMenu);
        MapScreen.menuPause.clipRect.w = (short)BaseScreen.displayWidth;
        MapScreen.menuPause.clipRect.x0 = 0;
        MapScreen.menuPause.clipRect.y0 = (short)((BaseScreen.displayHeight - MapScreen.menuPause.clipRect.h) / 2);
        MapScreen.menuPause.controlHandler = this;
        GameScreen.updateMenuHeight(menuPause);
        menuPause.open();
    }

    public void controlExecuted(ScreenLayout container, GuiControl control) {
        if (container == menuPause) {
            if (control == controlResume) {
                this.isPaused = false;
            }
            if (control == controlMainMenu) {
                this.areYouSure = true;
            }
        }
    }

    public void open() {
        Application.setAppLoading();
        if (this.imgLake == null) {
            this.imgLake = ImageSet.loadImage("/lakemap.png");
        }
        this.isMap.reloadImages();
        if (FrontEnd.gameType == 0) {
            MapScreen.unlockAreaForCompetition(4);
            this.fpBoatVelX = 0;
            this.fpBoatVelY = 0;
        } else {
            GameSequence cfr_ignored_0 = FrontEnd.instance.gameSequence;
            MapScreen.unlockAreaForCompetition(GameSequence.competition);
            if (GameScreen.gameTime == 0) {
                this.resetBoat();
                this.fpBoatVelX = 0;
                this.fpBoatVelY = 0;
            }
        }
        this.spotsShown = 0;
        this.bKeepSpot = false;
        this.randomiseFishingSpots();
    }

    public void close() {
        this.imgLake = null;
        this.isMap.unloadImages();
    }

    public void layout() {
    }

    public boolean isObstructed(int screenX, int screenY) {
        if (screenX <= 0 || screenX >= this.mapWidth - 1 || screenY <= 0 || screenY >= this.mapHeight - 1) {
            return true;
        }
        int x = screenX / this.colGranularity;
        int y = screenY / this.colGranularity;
        int colmapW = this.mapWidth / this.colGranularity + (this.mapWidth % this.colGranularity == 0 ? 0 : 1);
        int pixel = x + y * colmapW;
        return this.colMap.isBitSet(pixel);
    }

    public void paint(Graphics g) {
        int backgroundOffsetX = this.fpScrollX < 0 ? -(-this.fpScrollX >> 16) : this.fpScrollX >> 16;
        int backgroundOffsetY = this.fpScrollY < 0 ? -(-this.fpScrollY >> 16) : this.fpScrollY >> 16;
        int boatPosX = this.fpBoatX - this.fpScrollX < 0 ? -(-(this.fpBoatX - this.fpScrollX) >> 16) : this.fpBoatX - this.fpScrollX >> 16;
        int boatPosY = this.fpBoatY - this.fpScrollY - this.fpBoatBounceOffset < 0 ? -(-(this.fpBoatY - this.fpScrollY - this.fpBoatBounceOffset) >> 16) : this.fpBoatY - this.fpScrollY - this.fpBoatBounceOffset >> 16;
        int boatPosYNoBounce = this.fpBoatY - this.fpScrollY < 0 ? -(-(this.fpBoatY - this.fpScrollY) >> 16) : this.fpBoatY - this.fpScrollY >> 16;
        g.drawImage(this.imgLake, -backgroundOffsetX, -backgroundOffsetY, 0x10 | 4);
        if (this.isPaused) {
            this.drawLocked(g);
            if (!this.areYouSure) {
                FrontEnd.instance.drawMenuBars(g, currentMenu);
                currentMenu.paint(g);
            }
        } else {
            this.drawRipples(g);
            this.drawParticles(g);
            if (this.useNewSonar) {
                this.drawHilight = true;
            }
            if (this.drawHilight) {
                g.setColor(172546);
                g.drawArc(boatPosX - (this.sonarCurrent >> 1), boatPosYNoBounce - (this.sonarCurrent >> 1) + 0, this.sonarCurrent, this.sonarCurrent, 0, 360);
                if (this.useNewSonar) {
                    this.gfxSonar.drawImage(g, this.sonarFrame, boatPosX - (this.gfxSonar.getRectWidth(this.sonarFrame) >> 1), boatPosY - (this.gfxSonar.getRectHeight(this.sonarFrame) >> 1));
                    if (this.sonarAnimDelay % 2 == 0) {
                        if (this.sonarCurrent < this.sonarMax) {
                            this.sonarCurrent += this.expandMult;
                            if (this.expandMult > 1) {
                                --this.expandMult;
                            }
                        } else {
                            this.sonarCurrent = this.sonarMin;
                            this.expandMult = 3;
                        }
                    }
                    if (this.sonarAnimDelay > 8) {
                        this.sonarFrame = this.sonarFrame < 7 ? ++this.sonarFrame : 0;
                        this.sonarAnimDelay = 0;
                    } else {
                        ++this.sonarAnimDelay;
                    }
                }
            }
            if (this.redfade == 0) {
                if (this.red < 255) {
                    this.red += 5;
                } else {
                    this.redfade = 1;
                }
            } else if (this.red > 50) {
                this.red -= 5;
            } else {
                this.redfade = 0;
            }
            this.spotsShown = 0;
            for (int i = 0; i < 9; ++i) {
                int ringColour;
                int radius;
                int fpRadius;
                if (locationLocked[this.fishingSpotLocation[i]]) continue;
                if (i == currentFishingSpot) {
                    fpRadius = (((fpCurrSpotExpandRadius ^ FixedPoint.sinLut(this.fpFlashAngle)) & 0x8000000) != 0 ? -((int)((long)(-fpCurrSpotExpandRadius) * (long)FixedPoint.sinLut(this.fpFlashAngle) >> 16)) : (int)((long)fpCurrSpotExpandRadius * (long)FixedPoint.sinLut(this.fpFlashAngle) >> 16)) + fpCurrSpotExpandRadius >> 1;
                    radius = fpRadius + fpCurrSpotRadius < 0 ? -(-(fpRadius + fpCurrSpotRadius) >> 16) : fpRadius + fpCurrSpotRadius >> 16;
                    ringColour = 65280;
                } else {
                    fpRadius = (((fpSpotExpandRadius ^ FixedPoint.sinLut(this.fpFlashAngle)) & 0x8000000) != 0 ? -((int)((long)(-fpSpotExpandRadius) * (long)FixedPoint.sinLut(this.fpFlashAngle) >> 16)) : (int)((long)fpSpotExpandRadius * (long)FixedPoint.sinLut(this.fpFlashAngle) >> 16)) + fpSpotExpandRadius >> 1;
                    radius = fpRadius + fpSpotRadius < 0 ? -(-(fpRadius + fpSpotRadius) >> 16) : fpRadius + fpSpotRadius >> 16;
                    ringColour = 16734976;
                }
                int cx = this.fishingSpotPos[i][0] - backgroundOffsetX;
                int cy = this.fishingSpotPos[i][1] - backgroundOffsetY;
                int spotsize = fishPoulationArcade / 2;
                if (!this.useNewSonar) {
                    g.setColor(0xFF0000);
                    g.fillRect(cx - 2, cy - 2, 5, 5);
                    g.setColor(ringColour);
                    g.drawArc(cx - radius, cy - radius + 0, radius << 1, radius << 1, 0, 360);
                    continue;
                }
                if (i != currentFishingSpot) continue;
                g.setColor(this.red, 0, 0);
                g.fillArc(cx - (spotsize >> 1) + 1, cy - (spotsize >> 1) + 1, spotsize, spotsize, 0, 360);
                g.setColor(this.red, this.red, this.red);
                g.drawArc(cx - (spotsize >> 1), cy - (spotsize >> 1) + 0, spotsize, spotsize, 0, 360);
                this.bKeepSpot = true;
                ++this.spotsShown;
            }
            if (this.spotsShown == 0) {
                this.bKeepSpot = false;
            }
            this.drawLocked(g);
            this.gfxBoat.drawImage(g, this.boatFrame, boatPosX - (this.gfxBoat.getRectWidth(this.boatFrame) >> 1), boatPosY - (this.gfxBoat.getRectHeight(this.boatFrame) >> 1));
            int locationTextY = BaseScreen.getScaledY(220);
            if (currentLocation != -1) {
                GameScreen.drawCenteredText(g, ScreenStack.font, MapScreen.strLocations(currentLocation), locationTextY);
                GameApp.gameScreen.drawPressFire(g, true);
            } else if (this.lockedLocationID != -1) {
                GameScreen.drawCenteredText(g, ScreenStack.font, MapScreen.strLocations(this.lockedLocationID), locationTextY);
                GameScreen.drawCenteredText(g, ScreenStack.font, this.strLocationLockedMessages(this.lockedLocationID), locationTextY + ScreenStack.font.getFontHeight());
            }
            GameApp.gameScreen.drawTicker(g);
        }
        GameApp.gameScreen.drawPlace(g);
        GameApp.gameScreen.drawGameTime(g);
        if (!this.isPaused) {
            int x = BaseScreen.displayWidth - this.gfxMenu.getRectWidth(0) - cBorderX;
            int y = BaseScreen.displayHeight - this.gfxMenu.getRectHeight(0) - cBorderY;
            this.gfxMenu.drawImage(g, 0, x, y);
        } else if (this.areYouSure) {
            int baseY = BaseScreen.displayHeight - ScreenStack.font.getFontHeight() >> 1;
            String confirmQuit_1 = "" + MultiLingual.get(80) + "";
            String confirmQuit_2 = "" + MultiLingual.get(81) + "";
            GameScreen.drawCenteredText(g, ScreenStack.fontSmall, confirmQuit_1, baseY);
            GameScreen.drawCenteredText(g, ScreenStack.fontSmall, confirmQuit_2, baseY + ScreenStack.font.getFontHeight());
            short bar_y0 = FrontEnd.instance.iconMenuBar.clipRect.y0;
            FrontEnd.instance.drawButton(g, 0, "" + MultiLingual.get(95) + "", bar_y0, ScreenStack.menuButtonHeight, 0, 0);
            FrontEnd.instance.drawButton(g, 1, "" + MultiLingual.get(96) + "", bar_y0, ScreenStack.menuButtonHeight, 0, 1);
        } else {
            short bar_y0 = FrontEnd.instance.iconMenuBar.clipRect.y0;
            FrontEnd.instance.drawButton(g, 0, "" + MultiLingual.get(94) + "", bar_y0, ScreenStack.menuButtonHeight, 0, 0);
        }
        if (this.findFishingSpotTimer > 0 && !this.isPaused) {
            GameScreen.drawCenteredText(g, ScreenStack.fontSmall, "" + MultiLingual.get(111) + "", BaseScreen.displayHeight >> 2);
            GameScreen.drawCenteredText(g, ScreenStack.fontSmall, "" + MultiLingual.get(112) + "", (BaseScreen.displayHeight >> 2) + ScreenStack.font.getFontHeight());
            --this.findFishingSpotTimer;
        }
    }

    private void drawLocked(Graphics g) {
        int backgroundOffsetX = this.fpScrollX < 0 ? -(-this.fpScrollX >> 16) : this.fpScrollX >> 16;
        int backgroundOffsetY = this.fpScrollY < 0 ? -(-this.fpScrollY >> 16) : this.fpScrollY >> 16;
        g.setColor(0xFF0000);
        for (int i = 0; i < 5; ++i) {
            if (!locationLocked[i]) continue;
            int sx = this.locationBoundaryStartPos[i][0] - backgroundOffsetX;
            int sy = this.locationBoundaryStartPos[i][1] - backgroundOffsetY;
            int ex = this.locationBoundaryEndPos[i][0] - backgroundOffsetX;
            int ey = this.locationBoundaryEndPos[i][1] - backgroundOffsetY;
            g.drawLine(sx, sy, ex, ey);
        }
    }

    public void process() {
        GameScreen g = GameApp.gameScreen;
        if (this.isPaused) {
            if (this.areYouSure) {
                if (ScreenLayout.keysDown(32768)) {
                    if (FrontEnd.menuType != -1) {
                        GameApp.autoSave();
                    }
                    GameApp.frontEnd.pushScreen(FrontEnd.menuMain, true);
                    this.isPaused = false;
                    this.areYouSure = false;
                    FrontEnd.instance.reload();
                } else if (ScreenLayout.keysDown(65536)) {
                    BaseScreen.resetKeys();
                    this.isPaused = false;
                    this.areYouSure = false;
                    this.setupSound();
                }
            } else {
                currentMenu.process();
                BaseScreen.resetKeys();
            }
            return;
        }
        this.setupSound();
        if (ScreenLayout.keysPressed(65536)) {
            this.pushScreen(menuPause, true);
            this.isPaused = true;
            this.areYouSure = false;
            this.setupSound();
            return;
        }
        if (this.randomiseTimer < 600) {
            if (!this.bKeepSpot) {
                ++this.randomiseTimer;
            }
        } else {
            this.randomiseFishingSpots();
            System.out.println("RANDOMISE !!");
            this.randomiseTimer = 0;
        }
        this.updateParticles();
        this.updateRipples();
        this.updateHilights();
        this.updateBoatMovement();
        this.updateScrolling();
        g.updateFlashing();
        if (FrontEnd.gameType == 0) {
            if (GameScreen.gameTime > 0) {
                GameScreen.gameTime = 0 > GameScreen.gameTime - Application.lastFrameTime ? 0 : GameScreen.gameTime - Application.lastFrameTime;
            } else if (currentLocation < 0) {
                currentLocation = 0;
            }
            if (ScreenLayout.keysPressed(16) && currentLocation != -1) {
                int background = 0;
                switch (currentLocation) {
                    case 0: {
                        background = 0;
                        break;
                    }
                    case 1: {
                        background = 1;
                        break;
                    }
                    case 2: {
                        background = 3;
                        break;
                    }
                    case 3: {
                        background = 2;
                        break;
                    }
                    case 4: {
                        background = 4;
                    }
                }
                if (!bNewGame) {
                    GameApp.frontEnd.continueQuickGame(background);
                } else {
                    GameApp.frontEnd.startQuickGame(background);
                }
                return;
            }
        } else {
            GameScreen.game.processAI();
            if (GameScreen.gameTime > 0) {
                GameScreen.gameTime = 0 > GameScreen.gameTime - Application.lastFrameTime ? 0 : GameScreen.gameTime - Application.lastFrameTime;
            } else {
                GameSequence cfr_ignored_0 = FrontEnd.instance.gameSequence;
                GameSequence.gameOver(false);
                GameApp.gameScreen.setGameOver();
                FrontEnd.instance.popScreenUntil(FrontEnd.instance.gameSequence, null);
            }
            if (ScreenLayout.keysPressed(16) && currentLocation != -1) {
                int background = 0;
                switch (currentLocation) {
                    case 0: {
                        background = 0;
                        break;
                    }
                    case 1: {
                        background = 1;
                        break;
                    }
                    case 2: {
                        background = 3;
                        break;
                    }
                    case 3: {
                        background = 2;
                        break;
                    }
                    case 4: {
                        background = 4;
                    }
                }
                GameApp.frontEnd.startGame(background);
                return;
            }
        }
    }

    public void setupSound() {
        if (this.isPaused) {
            if (SoundBank.currentSound != -1) {
                SoundBank.stop(0);
            }
        } else {
            int tune = 5;
            if (FrontEnd.sound && !BaseScreen.pauseDialogShown && SoundBank.currentSound != tune) {
                SoundBank.play(0, tune, true, 0);
            }
        }
    }

    public void pushScreen(ScreenLayout container, boolean transition) {
        currentMenu = (MenuLayout)container;
        GameScreen.updateMenuHeight(currentMenu);
        MapScreen.currentMenu.iSelected = 0;
        currentMenu.open();
    }

    private void updateHilights() {
        this.fpFlashAngle += ((fpFlashFrequency ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-fpFlashFrequency) * (long)Application.fp_deltatime >> 16)) : (int)((long)fpFlashFrequency * (long)Application.fp_deltatime >> 16);
        this.fpFlashAngle &= 0xFFFFFF;
        currentFishingSpot = this.getFishingSpot(this.fpBoatX < 0 ? -(-this.fpBoatX >> 16) : this.fpBoatX >> 16, this.fpBoatY < 0 ? -(-this.fpBoatY >> 16) : this.fpBoatY >> 16);
        currentLocation = currentFishingSpot == -1 ? -1 : this.fishingSpotLocation[currentFishingSpot];
    }

    private int getFishingSpot(int posX, int posY) {
        for (int i = 0; i < 9; ++i) {
            int dy;
            int dx;
            int dist2;
            if (locationLocked[this.fishingSpotLocation[i]] || (dist2 = (dx = this.fishingSpotPos[i][0] - posX) * dx + (dy = this.fishingSpotPos[i][1] - posY) * dy) > fishingSpotRadius2) continue;
            return i;
        }
        return -1;
    }

    private boolean hasPlayerGotAnyFish() {
        if (GameLogic.competitorFish == null) {
            return false;
        }
        return GameLogic.getFishWeight(GameLogic.competitorFish[0]) > 0;
    }

    private int getBarrierCollision(int px, int py, int radius) {
        for (int i = 0; i < 5; ++i) {
            int dirY;
            int dy;
            if (!locationLocked[i]) continue;
            int sx = this.locationBoundaryStartPos[i][0];
            int ex = this.locationBoundaryEndPos[i][0];
            if (px < sx && px < ex || px > sx && px > ex) continue;
            int sy = this.locationBoundaryStartPos[i][1];
            int ey = this.locationBoundaryEndPos[i][1];
            if (py < sy && py < ey || py > sy && py > ey) continue;
            int radius2 = radius * radius;
            int dirX = this.fpLocationBoundaryDir[i][0];
            int dx = px - sx < 0 ? -(-(px - sx) << 16) : px - sx << 16;
            int dot = (((dx ^ dirX) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)dirX >> 16)) : (int)((long)dx * (long)dirX >> 16)) + ((((dy = py - sy < 0 ? -(-(py - sy) << 16) : py - sy << 16) ^ (dirY = this.fpLocationBoundaryDir[i][1])) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)dirY >> 16)) : (int)((long)dy * (long)dirY >> 16));
            dx = sx + ((((dirX ^ dot) & 0x8000000) != 0 ? -((int)((long)(-dirX) * (long)dot >> 16)) : (int)((long)dirX * (long)dot >> 16)) < 0 ? -(-(((dirX ^ dot) & 0x8000000) != 0 ? -((int)((long)(-dirX) * (long)dot >> 16)) : (int)((long)dirX * (long)dot >> 16)) >> 16) : (((dirX ^ dot) & 0x8000000) != 0 ? -((int)((long)(-dirX) * (long)dot >> 16)) : (int)((long)dirX * (long)dot >> 16)) >> 16);
            dy = sy + ((((dirY ^ dot) & 0x8000000) != 0 ? -((int)((long)(-dirY) * (long)dot >> 16)) : (int)((long)dirY * (long)dot >> 16)) < 0 ? -(-(((dirY ^ dot) & 0x8000000) != 0 ? -((int)((long)(-dirY) * (long)dot >> 16)) : (int)((long)dirY * (long)dot >> 16)) >> 16) : (((dirY ^ dot) & 0x8000000) != 0 ? -((int)((long)(-dirY) * (long)dot >> 16)) : (int)((long)dirY * (long)dot >> 16)) >> 16);
            if ((dx = px - dx) * dx + (dy = py - dy) * dy > radius2) {
                return -1;
            }
            return i;
        }
        return -1;
    }

    private void updateBoatMovement() {
        int fpRotSpeed;
        this.fpBoatBounceOffset = ((fpBoatBounceAmplitude ^ FixedPoint.sinLut(this.fpBoatBounceAngle)) & 0x8000000) != 0 ? -((int)((long)(-fpBoatBounceAmplitude) * (long)FixedPoint.sinLut(this.fpBoatBounceAngle) >> 16)) : (int)((long)fpBoatBounceAmplitude * (long)FixedPoint.sinLut(this.fpBoatBounceAngle) >> 16);
        this.fpBoatBounceAngle += ((fpBoatBounceFrequency ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-fpBoatBounceFrequency) * (long)Application.fp_deltatime >> 16)) : (int)((long)fpBoatBounceFrequency * (long)Application.fp_deltatime >> 16);
        this.fpBoatBounceAngle &= 0xFFFFFF;
        int n = fpRotSpeed = ((fpBoatRotSpeed ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-fpBoatRotSpeed) * (long)Application.fp_deltatime >> 16)) : (int)((long)fpBoatRotSpeed * (long)Application.fp_deltatime >> 16);
        if (ScreenLayout.keysDown(2)) {
            this.fpBoatAngle += fpRotSpeed;
            this.fpBoatAngle &= 0xFFFFFF;
            this.drawHilight = false;
        }
        if (ScreenLayout.keysDown(4)) {
            this.fpBoatAngle -= fpRotSpeed;
            this.fpBoatAngle &= 0xFFFFFF;
            this.drawHilight = false;
        }
        if (this.gfxBoat.numFrames != 16) {
            System.out.println("Assertion Failure: gfxBoat.numFrames == 16\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/MapScreen.java[1375]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.boatFrame = this.fpBoatAngle + 524288 >> 4 < 0 ? -(-(this.fpBoatAngle + 524288 >> 4) >> 16) : this.fpBoatAngle + 524288 >> 4 >> 16;
        this.boatFrame &= 0xF;
        boolean thrusted = false;
        int fpDirX = 0;
        int fpDirY = 0;
        if (ScreenLayout.keysDown(1)) {
            int fpThrust = ((this.getBoatThrust() ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-this.getBoatThrust()) * (long)Application.fp_deltatime >> 16)) : (int)((long)this.getBoatThrust() * (long)Application.fp_deltatime >> 16);
            fpDirX = FixedPoint.sinLut(this.fpBoatAngle);
            fpDirY = FixedPoint.sinLut(this.fpBoatAngle + 0x400000);
            this.fpBoatVelX = ((fpDirX ^ fpThrust) & 0x8000000) != 0 ? -((int)((long)(-fpDirX) * (long)fpThrust >> 16)) : (int)((long)fpDirX * (long)fpThrust >> 16);
            this.fpBoatVelY = ((fpDirY ^ fpThrust) & 0x8000000) != 0 ? -((int)((long)(-fpDirY) * (long)fpThrust >> 16)) : (int)((long)fpDirY * (long)fpThrust >> 16);
            ++this.particleInitClock;
            if (this.particleInitClock > 6) {
                this.particleInitClock = 0;
                int particleX = this.fpBoatX - (((fpDirX ^ fpBoatSize) & 0x8000000) != 0 ? -((int)((long)(-fpDirX) * (long)fpBoatSize >> 16)) : (int)((long)fpDirX * (long)fpBoatSize >> 16)) < 0 ? -(-(this.fpBoatX - (((fpDirX ^ fpBoatSize) & 0x8000000) != 0 ? -((int)((long)(-fpDirX) * (long)fpBoatSize >> 16)) : (int)((long)fpDirX * (long)fpBoatSize >> 16))) >> 16) : this.fpBoatX - (((fpDirX ^ fpBoatSize) & 0x8000000) != 0 ? -((int)((long)(-fpDirX) * (long)fpBoatSize >> 16)) : (int)((long)fpDirX * (long)fpBoatSize >> 16)) >> 16;
                int particleY = this.fpBoatY - (((fpDirY ^ fpBoatSize) & 0x8000000) != 0 ? -((int)((long)(-fpDirY) * (long)fpBoatSize >> 16)) : (int)((long)fpDirY * (long)fpBoatSize >> 16)) < 0 ? -(-(this.fpBoatY - (((fpDirY ^ fpBoatSize) & 0x8000000) != 0 ? -((int)((long)(-fpDirY) * (long)fpBoatSize >> 16)) : (int)((long)fpDirY * (long)fpBoatSize >> 16))) >> 16) : this.fpBoatY - (((fpDirY ^ fpBoatSize) & 0x8000000) != 0 ? -((int)((long)(-fpDirY) * (long)fpBoatSize >> 16)) : (int)((long)fpDirY * (long)fpBoatSize >> 16)) >> 16;
                this.initParticle(particleX, particleY);
                this.initParticle(particleX, particleY);
                this.initParticle(particleX, particleY);
            }
            thrusted = true;
            this.drawHilight = false;
        }
        this.fpBoatX += this.fpBoatVelX;
        this.fpBoatY += this.fpBoatVelY;
        boolean stopped = false;
        if (this.isObstructed(this.fpBoatX < 0 ? -(-this.fpBoatX >> 16) : this.fpBoatX >> 16, this.fpBoatY < 0 ? -(-this.fpBoatY >> 16) : this.fpBoatY >> 16)) {
            stopped = true;
        }
        this.lockedLocationID = this.getBarrierCollision(this.fpBoatX < 0 ? -(-this.fpBoatX >> 16) : this.fpBoatX >> 16, this.fpBoatY < 0 ? -(-this.fpBoatY >> 16) : this.fpBoatY >> 16, 3);
        if (this.lockedLocationID != -1) {
            stopped = true;
        }
        if (stopped) {
            this.fpBoatX -= this.fpBoatVelX;
            this.fpBoatY -= this.fpBoatVelY;
            this.fpBoatVelX = -this.fpBoatVelX >> 2;
            this.fpBoatVelY = -this.fpBoatVelY >> 2;
        }
        if (thrusted && !stopped) {
            this.fpRippleClock += Application.fp_deltatime;
            if (this.fpRippleClock >= fpRippleSpawnTime) {
                this.fpRippleClock = 0;
                this.initRipple(this.fpBoatX - (((fpDirX ^ fpBoatSize) & 0x8000000) != 0 ? -((int)((long)(-fpDirX) * (long)fpBoatSize >> 16)) : (int)((long)fpDirX * (long)fpBoatSize >> 16)), this.fpBoatY - (((fpDirY ^ fpBoatSize) & 0x8000000) != 0 ? -((int)((long)(-fpDirY) * (long)fpBoatSize >> 16)) : (int)((long)fpDirY * (long)fpBoatSize >> 16)), this.fpBoatAngle, fpDirX, fpDirY);
            }
        }
        int fpBoatMinX = this.gfxBoat.getRectWidth(this.boatFrame) >> 1 < 0 ? -(-(this.gfxBoat.getRectWidth(this.boatFrame) >> 1) << 16) : this.gfxBoat.getRectWidth(this.boatFrame) >> 1 << 16;
        int fpBoatMinY = this.gfxBoat.getRectHeight(this.boatFrame) >> 1 < 0 ? -(-(this.gfxBoat.getRectHeight(this.boatFrame) >> 1) << 16) : this.gfxBoat.getRectHeight(this.boatFrame) >> 1 << 16;
        int fpBoatMaxX = (this.mapWidth < 0 ? -(-this.mapWidth << 16) : this.mapWidth << 16) - fpBoatMinX;
        int fpBoatMaxY = (this.mapHeight < 0 ? -(-this.mapHeight << 16) : this.mapHeight << 16) - fpBoatMinY;
        if (this.fpBoatX < fpBoatMinX) {
            this.fpBoatX = fpBoatMinX;
        } else if (this.fpBoatX > fpBoatMaxX) {
            this.fpBoatX = fpBoatMaxX;
        }
        if (this.fpBoatY < fpBoatMinY) {
            this.fpBoatY = fpBoatMinY;
        } else if (this.fpBoatY > fpBoatMaxY) {
            this.fpBoatY = fpBoatMaxY;
        }
        this.fpBoatVelX = ((this.fpBoatVelX ^ fpBoatSlowRate) & 0x8000000) != 0 ? -((int)((long)(-this.fpBoatVelX) * (long)fpBoatSlowRate >> 16)) : (int)((long)this.fpBoatVelX * (long)fpBoatSlowRate >> 16);
        this.fpBoatVelY = ((this.fpBoatVelY ^ fpBoatSlowRate) & 0x8000000) != 0 ? -((int)((long)(-this.fpBoatVelY) * (long)fpBoatSlowRate >> 16)) : (int)((long)this.fpBoatVelY * (long)fpBoatSlowRate >> 16);
    }

    private int getBoatThrust() {
        if (ShopScreen.playerHasBoat2()) {
            return this.getFPScaled(fpBoatThrustFast);
        }
        if (ShopScreen.playerHasBoat1()) {
            return this.getFPScaled(fpBoatThrustMedium);
        }
        return this.getFPScaled(fpBoatThrustSlow);
    }

    private void updateScrolling() {
        int fpMaxScrollX = this.mapWidth - BaseScreen.displayWidth < 0 ? -(-(this.mapWidth - BaseScreen.displayWidth) << 16) : this.mapWidth - BaseScreen.displayWidth << 16;
        int fpMaxScrollY = this.mapHeight - BaseScreen.displayHeight < 0 ? -(-(this.mapHeight - BaseScreen.displayHeight) << 16) : this.mapHeight - BaseScreen.displayHeight << 16;
        this.fpScrollX = this.fpBoatX - (BaseScreen.displayWidth >> 1 < 0 ? -(-(BaseScreen.displayWidth >> 1) << 16) : BaseScreen.displayWidth >> 1 << 16);
        this.fpScrollY = this.fpBoatY - (BaseScreen.displayHeight >> 1 < 0 ? -(-(BaseScreen.displayHeight >> 1) << 16) : BaseScreen.displayHeight >> 1 << 16);
        if (this.fpScrollX < 0) {
            this.fpScrollX = 0;
        } else if (this.fpScrollX > fpMaxScrollX) {
            this.fpScrollX = fpMaxScrollX;
        }
        if (this.fpScrollY < 0) {
            this.fpScrollY = 0;
        } else if (this.fpScrollY > fpMaxScrollY) {
            this.fpScrollY = fpMaxScrollY;
        }
    }

    private void initParticle(int x, int y) {
        for (int i = 0; i < 10; ++i) {
            if (this.particleLife[i] > 0) continue;
            this.particleXpos[i] = x + GameLogic.randRange(-3, 3);
            this.particleYpos[i] = y + GameLogic.randRange(-3, 3);
            this.particleLife[i] = 10;
            break;
        }
    }

    private void updateParticles() {
        if (++this.particleClock > 2) {
            this.particleClock = 0;
            for (int i = 0; i < 10; ++i) {
                if (this.particleLife[i] <= 0) continue;
                int n = i;
                this.particleLife[n] = this.particleLife[n] - 1;
            }
        }
    }

    private void drawParticles(Graphics g) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        int scrollX = this.fpScrollX < 0 ? -(-this.fpScrollX >> 16) : this.fpScrollX >> 16;
        int scrollY = this.fpScrollY < 0 ? -(-this.fpScrollY >> 16) : this.fpScrollY >> 16;
        for (int i = 0; i < 10; ++i) {
            if (this.particleLife[i] <= 0) continue;
            int t = (int)(((long)(this.particleLife[i] < 0 ? -(-this.particleLife[i] << 16) : this.particleLife[i] << 16) << 16) / 655360L);
            int drawColor = GfxUtils.lerpColour(t, 1847870, 11587839);
            g.setColor(drawColor);
            g.fillRect(this.particleXpos[i] - scrollX, this.particleYpos[i] - scrollY, 1, 1);
        }
    }

    void initRipple(int fpX, int fpY, int fpAngle, int fpDirX, int fpDirY) {
        int i = this.nextRipple++;
        if (this.nextRipple == 16) {
            this.nextRipple = 0;
        }
        this.fpRipplePos[i][0] = fpX + GameLogic.randRange(-fpRippleSpread, fpRippleSpread);
        this.fpRipplePos[i][1] = fpY + GameLogic.randRange(-fpRippleSpread, fpRippleSpread);
        this.fpRippleDir[i][0] = fpDirX;
        this.fpRippleDir[i][1] = fpDirY;
        this.fpRippleLife[i] = fpRippleLifeTime;
        this.fpRippleRadius[i] = fpRippleSizeMin;
        this.rippleAngle[i] = (fpAngle + 0xC00000 < 0 ? -(-(fpAngle + 0xC00000) >> 16) : fpAngle + 0xC00000 >> 16) * 360 >> 8;
        int n = i;
        this.rippleAngle[n] = this.rippleAngle[n] + GameLogic.randRange(-90, 90);
        this.rippleStopped[i] = false;
    }

    void updateRipples() {
        int dt = Application.fp_deltatime;
        for (int i = 0; i < 16; ++i) {
            if (this.fpRippleLife[i] <= 0) continue;
            int n = i;
            this.fpRippleLife[n] = this.fpRippleLife[n] - dt;
            if (this.fpRippleLife[i] < 0) {
                this.fpRippleLife[i] = 0;
                continue;
            }
            this.rippleStopped[i] = this.checkRippleCollision(i);
        }
    }

    void drawRipples(Graphics g) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        for (int i = 0; i < 16; ++i) {
            int fpRadius;
            int cy;
            if (this.fpRippleLife[i] <= 0) continue;
            int fpLerp = 65536 - (int)(((long)this.fpRippleLife[i] << 16) / (long)fpRippleLifeTime);
            int cx = this.fpRipplePos[i][0] - this.fpScrollX < 0 ? -(-(this.fpRipplePos[i][0] - this.fpScrollX) >> 16) : this.fpRipplePos[i][0] - this.fpScrollX >> 16;
            int n = cy = this.fpRipplePos[i][1] - this.fpScrollY < 0 ? -(-(this.fpRipplePos[i][1] - this.fpScrollY) >> 16) : this.fpRipplePos[i][1] - this.fpScrollY >> 16;
            if (this.rippleStopped[i]) {
                fpRadius = this.fpRippleRadius[i];
            } else {
                this.fpRippleRadius[i] = fpRadius = (((fpRippleSizeMax - fpRippleSizeMin ^ fpLerp) & 0x8000000) != 0 ? -((int)((long)(-(fpRippleSizeMax - fpRippleSizeMin)) * (long)fpLerp >> 16)) : (int)((long)(fpRippleSizeMax - fpRippleSizeMin) * (long)fpLerp >> 16)) + fpRippleSizeMin;
            }
            int radius = fpRadius < 0 ? -(-fpRadius >> 16) : fpRadius >> 16;
            int colour = GfxUtils.lerpColour(fpLerp, 8438015, 1847870);
            int angle = this.rippleAngle[i];
            g.setColor(colour);
            g.drawArc(cx - radius, cy - radius + 0, radius << 1, radius << 1, angle - 60, 120);
        }
    }

    private boolean checkRippleCollision(int i) {
        int fpRadius = this.fpRippleRadius[i];
        int fpX = this.fpRipplePos[i][0];
        int fpY = this.fpRipplePos[i][1];
        int fpDirX = this.fpRippleDir[i][0];
        int fpDirY = this.fpRippleDir[i][1];
        for (int j = 0; j < 3; ++j) {
            int fpTestY;
            int fpTestX = fpX + (((fpDirX ^ fpRadius) & 0x8000000) != 0 ? -((int)((long)(-fpDirX) * (long)fpRadius >> 16)) : (int)((long)fpDirX * (long)fpRadius >> 16));
            if (this.isObstructed(fpTestX < 0 ? -(-fpTestX >> 16) : fpTestX >> 16, (fpTestY = fpY + (((fpDirY ^ fpRadius) & 0x8000000) != 0 ? -((int)((long)(-fpDirY) * (long)fpRadius >> 16)) : (int)((long)fpDirY * (long)fpRadius >> 16))) < 0 ? -(-fpTestY >> 16) : fpTestY >> 16)) {
                return true;
            }
            if (j == 0) {
                int tmp = -fpDirX;
                fpDirX = fpDirY;
                fpDirY = tmp;
                continue;
            }
            if (j != 1) continue;
            fpDirX = -fpDirX;
            fpDirY = -fpDirY;
        }
        return false;
    }

    public static String strLocations(int i) {
        if (i < 0 || i >= 5) {
            System.out.println("Assertion Failure: (i>=0) && (i<numLocations)\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/MapScreen.java[1686]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        switch (i) {
            case 0: {
                return "" + MultiLingual.get(101) + "";
            }
            case 1: {
                return "" + MultiLingual.get(102) + "";
            }
            case 2: {
                return "" + MultiLingual.get(103) + "";
            }
            case 3: {
                return "" + MultiLingual.get(104) + "";
            }
            case 4: {
                return "" + MultiLingual.get(105) + "";
            }
        }
        return "";
    }

    private String strLocationLockedMessages(int i) {
        if (i < 0 || i >= 5) {
            System.out.println("Assertion Failure: (i>=0) && (i<numLocations)\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/MapScreen.java[1700]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        switch (i) {
            case 0: {
                return "" + MultiLingual.get(106) + "";
            }
            case 1: {
                return "" + MultiLingual.get(107) + "";
            }
            case 2: {
                return "" + MultiLingual.get(108) + "";
            }
            case 3: {
                return "" + MultiLingual.get(109) + "";
            }
            case 4: {
                return "" + MultiLingual.get(110) + "";
            }
        }
        return "";
    }

    public static void lockDefaultLocations() {
        for (int i = 0; i < 5; ++i) {
            MapScreen.locationLocked[i] = locationDefaultLockState[i];
        }
    }

    public static void unlockAllLocations() {
        for (int i = 0; i < 5; ++i) {
            MapScreen.locationLocked[i] = false;
        }
    }

    public static void unlockLocation(int i) {
        if (i < 0 || i >= 5) {
            System.out.println("Assertion Failure: (i>=0) && (i<numLocations)\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/MapScreen.java[1726]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MapScreen.locationLocked[i] = false;
    }

    public static boolean isLocationLocked(int i) {
        if (i < 0 || i >= 5) {
            System.out.println("Assertion Failure: (i>=0) && (i<numLocations)\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/game/MapScreen.java[1732]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return locationLocked[i];
    }

    private void refreshUnlockedStuff() {
    }

    public static void unlockAreaForCompetition(int comp) {
        switch (comp) {
            case 0: {
                MapScreen.locationLocked[0] = false;
                MapScreen.locationLocked[1] = true;
                MapScreen.locationLocked[2] = true;
                MapScreen.locationLocked[3] = true;
                MapScreen.locationLocked[4] = true;
                break;
            }
            case 1: {
                MapScreen.locationLocked[0] = false;
                MapScreen.locationLocked[1] = false;
                MapScreen.locationLocked[2] = true;
                MapScreen.locationLocked[3] = true;
                MapScreen.locationLocked[4] = true;
                break;
            }
            case 2: {
                MapScreen.locationLocked[0] = false;
                MapScreen.locationLocked[1] = false;
                MapScreen.locationLocked[2] = false;
                MapScreen.locationLocked[3] = true;
                MapScreen.locationLocked[4] = true;
                break;
            }
            case 3: {
                MapScreen.locationLocked[0] = false;
                MapScreen.locationLocked[1] = false;
                MapScreen.locationLocked[2] = false;
                MapScreen.locationLocked[3] = false;
                MapScreen.locationLocked[4] = true;
                break;
            }
            case 4: {
                MapScreen.locationLocked[0] = false;
                MapScreen.locationLocked[1] = false;
                MapScreen.locationLocked[2] = false;
                MapScreen.locationLocked[3] = false;
                MapScreen.locationLocked[4] = false;
            }
        }
    }

    public static void resetPopulation() {
        for (int i = 0; i < 9; ++i) {
            MapScreen.fishingSpotPopulated[i] = false;
        }
    }

    static {
        currentMenu = null;
        menuPause = new MenuLayout();
        controlPauseTitle = new GuiControl(false);
        controlResume = new GuiControl(true);
        controlMainMenu = new GuiControl(true);
        cBorderX = BaseScreen.getScaledX(3);
        cBorderY = BaseScreen.getScaledY(3);
        fishPoulationArcade = 8;
    }
}

