/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.sys;

import com.slg.j2me.lib.sys.FixedPoint;

public class VecMath {
    public static final String toString_v2(int[] vec) {
        return "[" + FixedPoint.toString_fp(vec[0]) + "," + FixedPoint.toString_fp(vec[1]) + "]";
    }

    public static final String toString_v3(int[] vec) {
        return "[" + FixedPoint.toString_fp(vec[0]) + "," + FixedPoint.toString_fp(vec[1]) + "," + FixedPoint.toString_fp(vec[2]) + "]";
    }

    public static final String toString_m33(int[] mat) {
        String str = new String();
        for (int i = 0; i < 9; i += 3) {
            str = str + "[" + FixedPoint.toString_fp(mat[i + 0]) + "," + FixedPoint.toString_fp(mat[i + 1]) + "," + FixedPoint.toString_fp(mat[i + 2]) + "]\n";
        }
        return str;
    }

    public static final String toString_m44(int[] mat) {
        String str = new String();
        for (int i = 0; i < 16; i += 4) {
            str = str + "[" + FixedPoint.toString_fp(mat[i + 0]) + "," + FixedPoint.toString_fp(mat[i + 1]) + "," + FixedPoint.toString_fp(mat[i + 2]) + "," + FixedPoint.toString_fp(mat[i + 3]) + "]\n";
        }
        return str;
    }

    public static final int len3d(int[] in) {
        long llensq = ((long)in[0] * (long)in[0] >> 16) + ((long)in[1] * (long)in[1] >> 16) + ((long)in[2] * (long)in[2] >> 16);
        int lensq = (int)llensq;
        if (llensq <= 16L) {
            return 0;
        }
        if (llensq < 0x200000L) {
            int[] scaled_in = new int[]{in[0] < 0 ? -(-in[0] << 5) : in[0] << 5, in[1] < 0 ? -(-in[1] << 5) : in[1] << 5, in[2] < 0 ? -(-in[2] << 5) : in[2] << 5};
            lensq = (int)(((long)scaled_in[0] * (long)scaled_in[0] >> 16) + ((long)scaled_in[1] * (long)scaled_in[1] >> 16) + ((long)scaled_in[2] * (long)scaled_in[2] >> 16));
            int len = FixedPoint.sqrt_bits(lensq);
            return len >> 5;
        }
        if (llensq > Integer.MAX_VALUE) {
            int[] scaled_in = new int[]{in[0] < 0 ? -(-in[0] >> 8) : in[0] >> 8, in[1] < 0 ? -(-in[1] >> 8) : in[1] >> 8, in[2] < 0 ? -(-in[2] >> 8) : in[2] >> 8};
            lensq = (int)(((long)scaled_in[0] * (long)scaled_in[0] >> 16) + ((long)scaled_in[1] * (long)scaled_in[1] >> 16) + ((long)scaled_in[2] * (long)scaled_in[2] >> 16));
            int len = FixedPoint.sqrt_bits(lensq);
            return len << 8;
        }
        int len = FixedPoint.sqrt_bits(lensq);
        return len;
    }

    public static final int norm3d(int[] out, int[] in) {
        int oolen;
        long llensq = ((long)in[0] * (long)in[0] >> 16) + ((long)in[1] * (long)in[1] >> 16) + ((long)in[2] * (long)in[2] >> 16);
        int lensq = (int)llensq;
        if (llensq <= 16L) {
            out[2] = 0;
            out[1] = 0;
            out[0] = 0;
            return 0;
        }
        if (llensq < 0x200000L) {
            int oolen2;
            int[] scaled_in = new int[]{in[0] < 0 ? -(-in[0] << 5) : in[0] << 5, in[1] < 0 ? -(-in[1] << 5) : in[1] << 5, in[2] < 0 ? -(-in[2] << 5) : in[2] << 5};
            lensq = (int)(((long)scaled_in[0] * (long)scaled_in[0] >> 16) + ((long)scaled_in[1] * (long)scaled_in[1] >> 16) + ((long)scaled_in[2] * (long)scaled_in[2] >> 16));
            int len = FixedPoint.sqrt_bits(lensq);
            if (len == 0) {
                System.out.println("Assertion Failure: len != 0\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/VecMath.java[196]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            out[0] = ((scaled_in[0] ^ (oolen2 = (int)(0x100000000L / (long)len))) & 0x8000000) != 0 ? -((int)((long)(-scaled_in[0]) * (long)oolen2 >> 16)) : (int)((long)scaled_in[0] * (long)oolen2 >> 16);
            out[1] = ((scaled_in[1] ^ oolen2) & 0x8000000) != 0 ? -((int)((long)(-scaled_in[1]) * (long)oolen2 >> 16)) : (int)((long)scaled_in[1] * (long)oolen2 >> 16);
            out[2] = ((scaled_in[2] ^ oolen2) & 0x8000000) != 0 ? -((int)((long)(-scaled_in[2]) * (long)oolen2 >> 16)) : (int)((long)scaled_in[2] * (long)oolen2 >> 16);
            return len >> 5;
        }
        if (llensq > Integer.MAX_VALUE) {
            int oolen3;
            int[] scaled_in = new int[]{in[0] < 0 ? -(-in[0] >> 8) : in[0] >> 8, in[1] < 0 ? -(-in[1] >> 8) : in[1] >> 8, in[2] < 0 ? -(-in[2] >> 8) : in[2] >> 8};
            lensq = (int)(((long)scaled_in[0] * (long)scaled_in[0] >> 16) + ((long)scaled_in[1] * (long)scaled_in[1] >> 16) + ((long)scaled_in[2] * (long)scaled_in[2] >> 16));
            int len = FixedPoint.sqrt_bits(lensq);
            if (len == 0) {
                System.out.println("Assertion Failure: len != 0\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/VecMath.java[206]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            out[0] = ((scaled_in[0] ^ (oolen3 = (int)(0x100000000L / (long)len))) & 0x8000000) != 0 ? -((int)((long)(-scaled_in[0]) * (long)oolen3 >> 16)) : (int)((long)scaled_in[0] * (long)oolen3 >> 16);
            out[1] = ((scaled_in[1] ^ oolen3) & 0x8000000) != 0 ? -((int)((long)(-scaled_in[1]) * (long)oolen3 >> 16)) : (int)((long)scaled_in[1] * (long)oolen3 >> 16);
            out[2] = ((scaled_in[2] ^ oolen3) & 0x8000000) != 0 ? -((int)((long)(-scaled_in[2]) * (long)oolen3 >> 16)) : (int)((long)scaled_in[2] * (long)oolen3 >> 16);
            return len << 8;
        }
        int len = FixedPoint.sqrt_bits(lensq);
        if (len == 0) {
            System.out.println("Assertion Failure: len != 0\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/VecMath.java[214]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        out[0] = ((in[0] ^ (oolen = (int)(0x100000000L / (long)len))) & 0x8000000) != 0 ? -((int)((long)(-in[0]) * (long)oolen >> 16)) : (int)((long)in[0] * (long)oolen >> 16);
        out[1] = ((in[1] ^ oolen) & 0x8000000) != 0 ? -((int)((long)(-in[1]) * (long)oolen >> 16)) : (int)((long)in[1] * (long)oolen >> 16);
        out[2] = ((in[2] ^ oolen) & 0x8000000) != 0 ? -((int)((long)(-in[2]) * (long)oolen >> 16)) : (int)((long)in[2] * (long)oolen >> 16);
        return len;
    }

    public static final int len2d(int[] in) {
        long llensq = ((long)in[0] * (long)in[0] >> 16) + ((long)in[1] * (long)in[1] >> 16);
        int lensq = (int)llensq;
        if (llensq <= 16L) {
            return 0;
        }
        if (llensq < 0x200000L) {
            int[] scaled_in = new int[]{in[0] < 0 ? -(-in[0] << 5) : in[0] << 5, in[1] < 0 ? -(-in[1] << 5) : in[1] << 5};
            lensq = (int)(((long)scaled_in[0] * (long)scaled_in[0] >> 16) + ((long)scaled_in[1] * (long)scaled_in[1] >> 16));
            int len = FixedPoint.sqrt_bits(lensq);
            return len >> 5;
        }
        if (llensq > Integer.MAX_VALUE) {
            int[] scaled_in = new int[]{in[0] < 0 ? -(-in[0] >> 8) : in[0] >> 8, in[1] < 0 ? -(-in[1] >> 8) : in[1] >> 8};
            lensq = (int)(((long)scaled_in[0] * (long)scaled_in[0] >> 16) + ((long)scaled_in[1] * (long)scaled_in[1] >> 16));
            int len = FixedPoint.sqrt_bits(lensq);
            return len << 8;
        }
        int len = FixedPoint.sqrt_bits(lensq);
        return len;
    }

    public static final int norm2d(int[] out, int[] in) {
        int oolen;
        long llensq = ((long)in[0] * (long)in[0] >> 16) + ((long)in[1] * (long)in[1] >> 16);
        int lensq = (int)llensq;
        if (llensq <= 16L) {
            out[1] = 0;
            out[0] = 0;
            return 0;
        }
        if (llensq < 0x200000L) {
            int oolen2;
            int[] scaled_in = new int[]{in[0] < 0 ? -(-in[0] << 5) : in[0] << 5, in[1] < 0 ? -(-in[1] << 5) : in[1] << 5};
            lensq = (int)(((long)scaled_in[0] * (long)scaled_in[0] >> 16) + ((long)scaled_in[1] * (long)scaled_in[1] >> 16));
            int len = FixedPoint.sqrt_bits(lensq);
            if (len == 0) {
                System.out.println("Assertion Failure: len != 0\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/VecMath.java[254]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            out[0] = ((scaled_in[0] ^ (oolen2 = (int)(0x100000000L / (long)len))) & 0x8000000) != 0 ? -((int)((long)(-scaled_in[0]) * (long)oolen2 >> 16)) : (int)((long)scaled_in[0] * (long)oolen2 >> 16);
            out[1] = ((scaled_in[1] ^ oolen2) & 0x8000000) != 0 ? -((int)((long)(-scaled_in[1]) * (long)oolen2 >> 16)) : (int)((long)scaled_in[1] * (long)oolen2 >> 16);
            return len >> 5;
        }
        if (llensq > Integer.MAX_VALUE) {
            int oolen3;
            int[] scaled_in = new int[]{in[0] < 0 ? -(-in[0] >> 8) : in[0] >> 8, in[1] < 0 ? -(-in[1] >> 8) : in[1] >> 8};
            lensq = (int)(((long)scaled_in[0] * (long)scaled_in[0] >> 16) + ((long)scaled_in[1] * (long)scaled_in[1] >> 16));
            int len = FixedPoint.sqrt_bits(lensq);
            if (len == 0) {
                System.out.println("Assertion Failure: len != 0\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/VecMath.java[263]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            out[0] = ((scaled_in[0] ^ (oolen3 = (int)(0x100000000L / (long)len))) & 0x8000000) != 0 ? -((int)((long)(-scaled_in[0]) * (long)oolen3 >> 16)) : (int)((long)scaled_in[0] * (long)oolen3 >> 16);
            out[1] = ((scaled_in[1] ^ oolen3) & 0x8000000) != 0 ? -((int)((long)(-scaled_in[1]) * (long)oolen3 >> 16)) : (int)((long)scaled_in[1] * (long)oolen3 >> 16);
            return len << 8;
        }
        int len = FixedPoint.sqrt_bits(lensq);
        if (len == 0) {
            System.out.println("Assertion Failure: len != 0\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/VecMath.java[270]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        out[0] = ((in[0] ^ (oolen = (int)(0x100000000L / (long)len))) & 0x8000000) != 0 ? -((int)((long)(-in[0]) * (long)oolen >> 16)) : (int)((long)in[0] * (long)oolen >> 16);
        out[1] = ((in[1] ^ oolen) & 0x8000000) != 0 ? -((int)((long)(-in[1]) * (long)oolen >> 16)) : (int)((long)in[1] * (long)oolen >> 16);
        return len;
    }

    public static final int lensq3d(int[] a) {
        if ((a[0] < 0 ? -a[0] : a[0]) > 0xB50000 || (a[1] < 0 ? -a[1] : a[1]) > 0xB50000 || (a[2] < 0 ? -a[2] : a[2]) > 0xB50000) {
            System.out.println("\n\n*******************************************************\nFP_LENSQ_3D : input out of range!\n*******************************************************\n\n");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (int)((long)a[0] * (long)a[0] >> 16) + (int)((long)a[1] * (long)a[1] >> 16) + (int)((long)a[2] * (long)a[2] >> 16);
    }

    public static final int lensq2d(int[] a) {
        if ((a[0] < 0 ? -a[0] : a[0]) > 0xB50000 || (a[1] < 0 ? -a[1] : a[1]) > 0xB50000) {
            System.out.println("\n\n*******************************************************\nFP_LENSQ_2D : input out of range!\n*******************************************************\n\n");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (int)((long)a[0] * (long)a[0] >> 16) + (int)((long)a[1] * (long)a[1] >> 16);
    }

    public static final int distsq3d(int[] a, int[] b) {
        if ((a[0] - b[0] < 0 ? -(a[0] - b[0]) : a[0] - b[0]) > 0xB50000 || (a[1] - b[1] < 0 ? -(a[1] - b[1]) : a[1] - b[1]) > 0xB50000 || (a[2] - b[2] < 0 ? -(a[2] - b[2]) : a[2] - b[2]) > 0xB50000) {
            System.out.println("\n\n*******************************************************\nFP_DISTSQ_3D : input out of range!\n*******************************************************\n\n");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (int)((long)(a[0] - b[0]) * (long)(a[0] - b[0]) >> 16) + (int)((long)(a[1] - b[1]) * (long)(a[1] - b[1]) >> 16) + (int)((long)(a[2] - b[2]) * (long)(a[2] - b[2]) >> 16);
    }

    public static final int distsq2d(int[] a, int[] b) {
        if ((a[0] - b[0] < 0 ? -(a[0] - b[0]) : a[0] - b[0]) > 0xB50000 || (a[1] - b[1] < 0 ? -(a[1] - b[1]) : a[1] - b[1]) > 0xB50000) {
            System.out.println("\n\n*******************************************************\nFP_DISTSQ_2D : input out of range, dx: " + FixedPoint.toString_fp(a[0] - b[0] < 0 ? -(a[0] - b[0]) : a[0] - b[0]) + " dy: " + FixedPoint.toString_fp(a[1] - b[1] < 0 ? -(a[1] - b[1]) : a[1] - b[1]) + "\n*******************************************************\n\n");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (int)((long)(a[0] - b[0]) * (long)(a[0] - b[0]) >> 16) + (int)((long)(a[1] - b[1]) * (long)(a[1] - b[1]) >> 16);
    }

    public static final void unitTest() {
        System.out.println("------------------------------------------------------------");
        System.out.println("VecMath::unitTest()");
        System.out.println("");
        int len = 0;
        int[] vec3 = new int[]{256, -256, 128};
        int[] norm3 = new int[]{0, 0, 0};
        for (int i = 0; i < 23; ++i) {
            len = VecMath.norm3d(norm3, vec3);
            System.out.println("vec3=" + VecMath.toString_v3(vec3) + " |vec3|=" + FixedPoint.toString_fp(len) + " => " + VecMath.toString_v3(norm3));
            vec3[0] = ((vec3[0] ^ 0x20000) & 0x8000000) != 0 ? -((int)((long)(-vec3[0]) * 131072L >> 16)) : (int)((long)vec3[0] * 131072L >> 16);
            vec3[1] = ((vec3[1] ^ 0x20000) & 0x8000000) != 0 ? -((int)((long)(-vec3[1]) * 131072L >> 16)) : (int)((long)vec3[1] * 131072L >> 16);
            vec3[2] = ((vec3[2] ^ 0x20000) & 0x8000000) != 0 ? -((int)((long)(-vec3[2]) * 131072L >> 16)) : (int)((long)vec3[2] * 131072L >> 16);
        }
        int[] vec2 = new int[]{256, -256};
        int[] norm2 = new int[]{0, 0};
        for (int i = 0; i < 23; ++i) {
            len = VecMath.norm2d(norm2, vec2);
            System.out.println("vec2=" + VecMath.toString_v2(vec2) + " |vec2|=" + FixedPoint.toString_fp(len) + " => " + VecMath.toString_v2(norm2));
            vec2[0] = ((vec2[0] ^ 0x20000) & 0x8000000) != 0 ? -((int)((long)(-vec2[0]) * 131072L >> 16)) : (int)((long)vec2[0] * 131072L >> 16);
            vec2[1] = ((vec2[1] ^ 0x20000) & 0x8000000) != 0 ? -((int)((long)(-vec2[1]) * 131072L >> 16)) : (int)((long)vec2[1] * 131072L >> 16);
        }
        System.out.println("------------------------------------------------------------");
        System.out.println("");
    }
}

