/*
 * Decompiled with CFR 0.152.
 */
package std;

import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import std.musicMng;

public class mmapiMusicMng
extends musicMng {
    private int nSounds;
    int currentSoundId = -1;
    private int currentSoundLoop;
    private boolean allocateAll;
    Vector sfx_info = new Vector();
    public int frames;
    public static long time;
    public static long timeT;
    String path;
    String[] names;
    private Player[] players;
    private VolumeControl[] volumeControls;
    private int FILE_TYPE = -1;
    private final int TYPE_WAV;
    private final int TYPE_MID;
    private final int TYPE_MP3;
    private final int TYPE_AMR;
    private final int TYPE_GEN;

    public mmapiMusicMng(String string, String[] stringArray) {
        this.TYPE_WAV = 0;
        this.TYPE_MID = 1;
        this.TYPE_MP3 = 2;
        this.TYPE_AMR = 3;
        this.TYPE_GEN = 4;
        this.path = string;
        this.names = stringArray;
        this.nSounds = stringArray.length;
        this.players = new Player[this.nSounds];
        this.volumeControls = new VolumeControl[this.nSounds];
        this.currentSoundId = -1;
        this.currentSoundLoop = 0;
        this.allocateAll = false;
        this.sfx_info.removeAllElements();
    }

    private void load(int n) {
        try {
            if (n >= 0 && n < this.nSounds && this.names[n] != null) {
                String string = this.names[n].toLowerCase().substring(this.names[n].lastIndexOf(46) + 1);
                if (string.compareTo("mid") == 0 || string.compareTo("midi") == 0) {
                    this.FILE_TYPE = 1;
                }
                if (this.players[n] == null) {
                    String[] stringArray = new String[]{"x-wav", "midi", "mpeg", "amr", "gen"};
                    String string2 = "audio/" + stringArray[this.FILE_TYPE];
                    InputStream inputStream = this.getInputStream(this.names[n]);
                    switch (this.FILE_TYPE) {
                        case 1: {
                            this.players[n] = Manager.createPlayer((InputStream)inputStream, (String)string2);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deallocate(int n) {
        if (n >= 0 && n < this.nSounds && this.players[n] != null) {
            try {
                this.players[n].deallocate();
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.players[n].close();
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.players[n] = null;
            this.volumeControls[n] = null;
        }
    }

    public void start(int n, int n2) {
        if (active && n >= 0 && n < this.nSounds) {
            if (n2 == 0) {
                n2 = -1;
            }
            this.stop(this.currentSoundId);
            this.load(n);
            int n3 = 0;
            try {
                n3 = this.players[n].getState();
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (this.FILE_TYPE) {
                case 0: 
                case 1: {
                    switch (n3) {
                        case 100: {
                            try {
                                this.players[n].realize();
                                while (this.players[n].getState() != 200) {
                                    Thread.yield();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                if (this.volumeControls[n] == null) {
                                    this.volumeControls[n] = (VolumeControl)this.players[n].getControl("VolumeControl");
                                }
                                this.volumeControls[n].setLevel(this.volume);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        case 200: {
                            try {
                                this.players[n].prefetch();
                                while (this.players[n].getState() != 300) {
                                    Thread.yield();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            try {
                if (this.FILE_TYPE != 4) {
                    this.players[n].setLoopCount(n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (this.FILE_TYPE) {
                case 1: {
                    try {
                        this.players[n].setMediaTime(-1L);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                switch (this.FILE_TYPE) {
                    default: 
                }
                this.players[n].start();
                Thread.yield();
                time = System.currentTimeMillis();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentSoundId = n;
        this.currentSoundLoop = n2;
    }

    private void stop(int n) {
        if (active && n >= 0 && n < this.nSounds && this.players[n] != null) {
            try {
                this.players[n].stop();
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.deallocate(n);
        }
    }

    public void setVolume(int n) {
        this.volume = n;
        if (this.volume < 0) {
            this.volume = 0;
        }
        if (this.volume > 100) {
            this.volume = 100;
        }
        if (this.currentSoundId >= 0 && this.currentSoundId < this.nSounds && this.volumeControls[this.currentSoundId] != null) {
            try {
                this.volumeControls[this.currentSoundId].setLevel(this.volume);
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isSoundOn() {
        if (!active) {
            return false;
        }
        if (this.currentSoundId >= 0 && this.currentSoundId < this.nSounds && this.players[this.currentSoundId] != null) {
            int n = 0;
            try {
                n = this.players[this.currentSoundId].getState();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n == 400;
        }
        return false;
    }

    public void stopAll() {
        this.stop(this.currentSoundId);
        this.sfx_info.removeAllElements();
    }

    public void pause() {
        this.stop(this.currentSoundId);
    }

    public void resume() {
        this.start(this.currentSoundId, this.currentSoundLoop);
    }

    public InputStream getInputStream(String string) {
        return this.path.getClass().getResourceAsStream(this.path + string);
    }
}

