/*
 * Decompiled with CFR 0.152.
 */
import base.graphicObject;
import core.gameObject;
import gfx.text;
import std.math;

public class simulatorPlayer
extends gameObject {
    simulatorTeam myTeam;
    simulatorTeam rivalTeam;
    boolean possession;
    int posesionCount;
    static final int[] posesionCounts = new int[]{30, 50, 70, 100};
    int inactiveCount;
    int myTacticPos;
    public playersDb db;
    simulatorBall ball;
    int ballDis;
    int ballDisX;
    int ballDisY;
    int playerDis;
    public static final int disputeRandomFactor = 100;
    public static final int disputeMoralFactor = 500;

    public simulatorPlayer(graphicObject graphicObject2, playersDb playersDb2, simulatorBall simulatorBall2, int n, simulatorTeam simulatorTeam2, simulatorTeam simulatorTeam3) {
        super(graphicObject2);
        this.db = playersDb2;
        this.ball = simulatorBall2;
        this.myTacticPos = n + n;
        this.myTeam = simulatorTeam2;
        this.rivalTeam = simulatorTeam3;
    }

    public void init() {
        this.possession = false;
        this.posesionCount = 0;
        this.inactiveCount = 0;
    }

    public void tick() {
        switch (this.myTeam.mode) {
            case 0: {
                this.moveToMyPos(60);
                break;
            }
            case 1: {
                if (this.inactiveCount > 0) {
                    --this.inactiveCount;
                    return;
                }
                if (this.ball.myPlayerDes == this && this.moveToBall(30) < 1213) {
                    this.setPossession();
                }
                if (this.possession) {
                    if (--this.posesionCount == 0) {
                        this.decides();
                        break;
                    }
                    switch (this.db.demarcation) {
                        case 0: {
                            this.moveToMyPos(40);
                            break;
                        }
                        case 1: {
                            simulatorPlayer simulatorPlayer2 = this.rivalTeam.getNearPlayer(this, false);
                            if (simulatorPlayer2.playerDis < this.myTeam.playerDefDisMin && game.getProbabilityResult(30, 100)) {
                                this.decides();
                                break;
                            }
                            this.advance(50);
                            break;
                        }
                        case 2: {
                            simulatorPlayer simulatorPlayer3 = this.rivalTeam.getNearPlayer(this, false);
                            if (simulatorPlayer3.playerDis < this.myTeam.playerMedDisMin && game.getProbabilityResult(10, 100)) {
                                this.decides();
                                break;
                            }
                            if (Math.abs(playMatchState.simulatorGroundXLimit * this.rivalTeam.ground - this.myRep.x) > playMatchState.simulatorGroundXLimit >> 1) {
                                this.advance(60);
                                break;
                            }
                            if (this.moveToGoal() >= this.myTeam.playerGoalDisMin) break;
                            this.tiroShot();
                            break;
                        }
                        case 3: {
                            simulatorPlayer simulatorPlayer4 = this.rivalTeam.getNearPlayer(this, false);
                            if (simulatorPlayer4.playerDis < this.myTeam.playerDelDisMin && game.getProbabilityResult(5, 100)) {
                                this.decides();
                                break;
                            }
                            if (this.moveToGoal() >= this.myTeam.playerGoalDisMin) break;
                            this.tiroShot();
                        }
                    }
                    break;
                }
                if (!this.myTeam.possession) {
                    if (this.db.demarcation == 0) {
                        if (this.ball.moving && this.ballDis < this.myTeam.goalKeeperBallDisMin) {
                            if (this.moveToBall(120) >= 1213) break;
                            if (this.getDisputeValue() > this.ball.myPlayerOr.getDisputeValue()) {
                                this.setPossession();
                                break;
                            }
                            this.inactiveCount = 10;
                            break;
                        }
                        if (this.ballDis < this.myTeam.ballDisMin) {
                            if (this.moveToBall(100) >= 1213) break;
                            this.setPossession();
                            break;
                        }
                        this.moveToMyPos(60);
                        break;
                    }
                    int n = 80;
                    int n2 = this.myTeam.ballDisMin;
                    switch (this.db.demarcation) {
                        case 1: {
                            n = 100;
                            n2 = this.myTeam.defBallDisMin;
                        }
                    }
                    if (!(this != this.myTeam.getPlayerToBall() && this.ballDis >= n2 || this.ball.myPlayer != null && this.ball.myPlayer.db.demarcation == 0)) {
                        if (this.moveToBall(n) >= 1213) break;
                        this.setPossession();
                        break;
                    }
                    this.moveToMyPos(60);
                    break;
                }
                this.moveToMyPos(60);
                break;
            }
            case 2: {
                this.moveTo(50, 0, playMatchState.simulatorGroundYLimit + 2048);
            }
        }
    }

    private void decides() {
        switch (this.db.demarcation) {
            case 0: {
                if (game.getProbabilityResult(this.myTeam.porteroTiroLargoProb, 10)) {
                    this.bomboShot();
                    break;
                }
                this.paseShot(false);
                break;
            }
            case 1: {
                if (Math.abs(playMatchState.simulatorGroundXLimit * this.myTeam.ground - this.myRep.x) < playMatchState.simulatorGroundXLimit >> 1 && game.getProbabilityResult(this.myTeam.defensaTiroLargoProb, 10)) {
                    this.bomboShot();
                    break;
                }
                if (this.paseShot(true)) break;
                this.paseShot(false);
                break;
            }
            case 2: {
                if (this.paseShot(true)) break;
                if (game.getProbabilityResult(this.myTeam.medioTiroProb, 10)) {
                    if (this.moveToGoal() >= this.myTeam.playerGoalDisMin) break;
                    this.tiroShot();
                    break;
                }
                if (!game.getProbabilityResult(2, 10)) break;
                this.paseShot(false);
                break;
            }
            case 3: {
                simulatorPlayer simulatorPlayer2 = this.myTeam.getNearPlayer(playMatchState.simulatorGroundXLimit * this.rivalTeam.ground, 0);
                if (simulatorPlayer2 != this && this.paseShot(true) || this.moveToGoal() >= this.myTeam.playerGoalDisMin) break;
                this.tiroShot();
            }
        }
    }

    public int getBallXpos() {
        return this.myRep.x + 768 * this.rivalTeam.ground;
    }

    public int getBallYpos() {
        return this.myRep.y;
    }

    private void bomboShot() {
        this.ball.move(0, (playMatchState.simulatorGroundXLimit >> 1) * this.rivalTeam.ground, game.random.nextInt() % playMatchState.simulatorGroundYLimit);
        playMatchState.setTextState(texts.LONG_PASS + text.newString(this.db.name).toUpperCase(), myState.smallFont, 3, 5);
    }

    private void tiroShot() {
        this.ball.move(1, playMatchState.simulatorGroundXLimit * this.rivalTeam.ground, game.random.nextInt() % (playMatchState.simulatorGoalWidth * 130 / 100));
        playMatchState.setTextState(texts.GOAL_SHOOT + text.newString(this.db.name).toUpperCase(), myState.smallFont, 3, 5);
    }

    private boolean paseShot(boolean bl) {
        simulatorPlayer simulatorPlayer2 = this.myTeam.getNearPlayer(this, bl);
        if (simulatorPlayer2 != this) {
            this.ball.move(2, simulatorPlayer2.myRep.x, simulatorPlayer2.myRep.y);
            this.ball.myPlayerDes = simulatorPlayer2;
            return true;
        }
        return false;
    }

    private void advance(int n) {
        int n2 = this.db.speed * n / 19 * this.rivalTeam.ground;
        this.myRep.setPosition(this.myRep.x + n2, this.myRep.y);
    }

    private void moveToMyPos(int n) {
        this.moveTo(n, this.getMyPosX(), this.getMyPosY());
    }

    public int getMyPosX() {
        int n = this.myTeam.myTactic[this.myTacticPos + 1];
        if (this.db.demarcation != 0) {
            n += simulatorTeam.lineasDes[this.myTeam.lineas];
        }
        n = (n << 8) * this.myTeam.ground;
        n += (this.ball.myRep.x - n) * 8 / 100;
        return n;
    }

    public int getMyPosY() {
        int n = (this.myTeam.myTactic[this.myTacticPos] << 8) * this.myTeam.ground;
        n += (this.ball.myRep.y - n) * 15 / 100;
        return n;
    }

    private int moveToBall(int n) {
        return this.moveTo(n, this.ball.myRep.x, this.ball.myRep.y);
    }

    private int moveToGoal() {
        playMatchState.setTextState(text.newString(this.db.name).toUpperCase() + texts.HEADS_GOAL, myState.smallFont, 5, 5);
        return this.moveTo(100, playMatchState.simulatorGroundXLimit * this.rivalTeam.ground, 0);
    }

    private int moveTo(int n, int n2, int n3) {
        int n4;
        int n5 = n2 - this.myRep.x;
        int n6 = n3 - this.myRep.y;
        int n7 = math.sqr(n5 * n5 + n6 * n6);
        if (n7 > (n4 = this.db.speed * n / 19)) {
            int n8 = (n5 << 8) / n7;
            int n9 = (n6 << 8) / n7;
            this.myRep.setPosition(this.myRep.x + (n4 * n8 >> 8), this.myRep.y + (n4 * n9 >> 8));
        } else {
            this.myRep.setPosition(n2, n3);
        }
        return n7;
    }

    public void setPossession() {
        if (this.ball.getHeight() < 2432) {
            if (this.ball.myPlayer != null) {
                simulatorPlayer simulatorPlayer2 = this.ball.myPlayer;
                if (this.getDisputeValue() > simulatorPlayer2.getDisputeValue()) {
                    simulatorPlayer2.inactiveCount = 10;
                    simulatorPlayer2.possession = false;
                    playMatchState.setTextState(text.newString(this.db.name).toUpperCase() + texts.TAKES_BALL, myState.smallFont, 5, 3);
                } else {
                    this.inactiveCount = 10;
                    return;
                }
            }
            this.myTeam.possession = true;
            this.possession = true;
            this.rivalTeam.possession = false;
            this.posesionCount = posesionCounts[this.db.demarcation];
            this.ball.setPossession(this);
        }
    }

    private int getDisputeValue() {
        return this.myTeam.disputeFactor[this.db.demarcation] + this.db.quality + this.db.moral * 500 / 1000 + game.random.nextInt() % 100;
    }
}

