/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.container;
import base.layer;
import base.panel;
import core.rectangle;
import javax.microedition.lcdui.Graphics;

public abstract class graphicObject
extends rectangle {
    public container parent;
    public layer myLayer;
    public boolean background;
    public boolean active;
    public boolean removed;
    public boolean dirty;
    public boolean visible = true;
    public int xf;
    public int yf;
    public int xf_Old;
    public int yf_Old;
    public int w_Old;
    public int h_Old;
    public int anchor = 20;
    protected boolean sized;
    protected boolean located;
    protected rectangle dirtyArea = new rectangle();

    public boolean setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.dirty();
            if (!this.visible) {
                this.removeFromBackground();
            }
            return true;
        }
        return false;
    }

    public void stickToBackground(boolean bl) {
        if (!bl) {
            this.removeFromBackground();
        }
        this.background = bl;
        this.dirtyRequest();
    }

    protected void removeFromBackground() {
        if (this.background && this.myLayer != null) {
            ((panel)this.myLayer.parent).removeBackgroundObject(this);
        }
    }

    public void setX(int n) {
        this.x = n;
        this.dirtyRequest();
    }

    public void setY(int n) {
        this.y = n;
        this.dirtyRequest();
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.dirtyRequest();
    }

    public void setDim(int n, int n2) {
        if (!this.sized) {
            this.w_Old = this.w = n;
            this.h_Old = this.h = n2;
            this.sized = true;
        } else {
            this.w_Old = this.w;
            this.h_Old = this.h;
            this.w = n;
            this.h = n2;
            this.dirtyRequest();
        }
    }

    public void dirtyRequest() {
        if (this.visible) {
            this.dirty();
        }
    }

    public void dirty() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.parent != null) {
                this.parent.dirtyContent();
            }
        }
    }

    public void setLayer(layer layer2) {
        this.myLayer = layer2;
    }

    public void getScreenCords(int n, int n2) {
        if (this.dirty) {
            this.getMyScreenCords(n, n2);
        }
    }

    protected void getMyScreenCords(int n, int n2) {
        if (this.located) {
            this.xf_Old = this.xf;
            this.yf_Old = this.yf;
            this.myLayer.getScreenCords(this);
            this.xf += n;
            this.yf += n2;
        } else {
            this.myLayer.getScreenCords(this);
            this.xf += n;
            this.yf += n2;
            this.xf_Old = this.xf;
            this.yf_Old = this.yf;
            this.located = true;
        }
    }

    public void addDirtyArea(rectangle rectangle2) {
        if (this.dirty) {
            this.getDirtyArea(this.dirtyArea);
            rectangle2.add(this.dirtyArea);
        }
    }

    protected void getDirtyArea(rectangle rectangle2) {
        rectangle2.x = this.xf < this.xf_Old ? this.xf : this.xf_Old;
        rectangle2.y = this.yf < this.yf_Old ? this.yf : this.yf_Old;
        int n = this.xf + this.w;
        rectangle2.w = this.xf_Old + this.w_Old;
        if (n > rectangle2.w) {
            rectangle2.w = n;
        }
        int n2 = this.yf + this.h;
        rectangle2.h = this.yf_Old + this.h_Old;
        if (n2 > rectangle2.h) {
            rectangle2.h = n2;
        }
        this.w_Old = this.w;
        this.h_Old = this.h;
    }

    protected void getMyArea(rectangle rectangle2) {
        rectangle2.x = this.xf;
        rectangle2.y = this.yf;
        rectangle2.w = this.xf + this.w;
        rectangle2.h = this.yf + this.h;
    }

    public void remove() {
        this.removed = true;
        if (this.parent != null) {
            this.parent.removeElement(this);
        }
    }

    public void destroy() {
        this.removeFromBackground();
        this.myLayer = null;
        this.active = false;
    }

    public abstract void paint(Graphics var1, rectangle var2);
}

