/*
 * Decompiled with CFR 0.152.
 */
package gfx;

import gfx.uiTableRep;
import std.actionCallback;
import std.activable;
import std.dataFilter;
import std.scrollable;

public abstract class uiTableWindowedRep
extends uiTableRep
implements scrollable {
    int offx;
    int offy;
    int table_w;
    int table_h;
    int content_w;
    int content_h;
    int scrollX;
    int scrollY;
    int nControlsW;
    int cursorY;

    public uiTableWindowedRep(dataFilter dataFilter2, int n, int n2, int n3, int n4) {
        super(dataFilter2);
        this.table_w = n;
        this.table_h = n2;
        this.scrollX = n3;
        this.scrollY = n4;
        this.nControlsW = n2 / n4;
        this.cursorY = this.nControlsW - 1;
    }

    public void setTablePosition(int n, int n2) {
        this.offx = n;
        this.offy = n2;
    }

    public void setTablePositionToLastRow() {
        this.setTablePosition(this.offx, this.content_h - this.table_h);
    }

    public boolean moveControl(actionCallback actionCallback2, int n, byte by, int n2, int n3) {
        ((activable)((Object)this.getComponent(n2))).desactive();
        ((activable)((Object)this.getComponent(n3))).active();
        actionCallback2.action(this, n);
        switch (by) {
            case 2: {
                if (this.cursorY <= 0) break;
                --this.cursorY;
                return true;
            }
            case 3: {
                if (this.cursorY >= this.nControlsW - 1) break;
                ++this.cursorY;
                return true;
            }
        }
        return false;
    }

    public boolean scroll(byte by, actionCallback actionCallback2, int n) {
        switch (by) {
            case 0: {
                if (this.offx <= 0) break;
                this.setTablePosition(this.offx - this.scrollX, this.offy);
                actionCallback2.action(this, n);
                return true;
            }
            case 1: {
                if (this.offx + this.table_w >= this.content_w) break;
                this.setTablePosition(this.offx + this.scrollX, this.offy);
                actionCallback2.action(this, n);
                return true;
            }
            case 2: {
                if (this.offy <= 0) break;
                this.setTablePosition(this.offx, this.offy - this.scrollY);
                actionCallback2.action(this, n);
                return true;
            }
            case 3: {
                if (this.offy + this.table_h >= this.content_h) break;
                this.setTablePosition(this.offx, this.offy + this.scrollY);
                actionCallback2.action(this, n);
                return true;
            }
        }
        return false;
    }

    public byte getPossibleScroll() {
        byte by = 0;
        if (this.offx > 0) {
            by = (byte)(by | 1);
        }
        if (this.offx + this.table_w < this.content_w) {
            by = (byte)(by | 2);
        }
        if (this.offy > 0) {
            by = (byte)(by | 4);
        }
        if (this.offy + this.table_h < this.content_h) {
            by = (byte)(by | 8);
        }
        return by;
    }

    public boolean getScrollBarW() {
        return this.table_w < this.content_w;
    }

    public boolean getScrollBarH() {
        return this.table_h < this.content_h;
    }

    public int getScrollWPos() {
        int n = this.content_w - this.table_w;
        if (n > 0) {
            return (this.offx << 10) / n;
        }
        return -1;
    }

    public int getScrollHPos() {
        int n = this.content_h - this.table_h;
        if (n > 0) {
            return (this.offy << 10) / n;
        }
        return -1;
    }

    public int getCurrentRow() {
        return this.offy / this.scrollY + this.cursorY;
    }
}

