/*
 * Decompiled with CFR 0.152.
 */
package gfx;

import base.container;
import base.graphicObject;
import gfx.uiWindowRep;
import std.actionCallback;
import std.scrollable;

public abstract class uiScrollableWindowRep
extends uiWindowRep
implements scrollable {
    public boolean scrollable;
    public graphicObject contentOff;
    public int windowWidth;
    public int windowHeight;
    public int contentWidth;
    public int contentHeight;
    public int contentWidthDif;
    public int contentHeightDif;
    public static int defaultScrollAddX = 12;
    public static int defaultScrollAddY = 12;
    public static int defaultScrollSpeed = 4;
    public int scrollAddX = defaultScrollAddX;
    public int scrollAddY = defaultScrollAddY;
    public int scrollSpeed = defaultScrollSpeed;

    public void setWindowDim(int n, int n2) {
        container container2 = new container();
        container2.setDim(n, n2);
        this.setContent(container2);
        this.windowWidth = n;
        this.windowHeight = n2;
        this.scrollable = true;
    }

    public void setContent(graphicObject graphicObject2) {
        this.contentWidth = graphicObject2.w;
        this.contentHeight = graphicObject2.h;
        if (this.scrollable) {
            this.contentOff = graphicObject2;
            ((container)this.myContent).removeAllElements();
            ((container)this.myContent).addElement(this.contentOff);
        } else {
            this.windowWidth = graphicObject2.w;
            this.windowHeight = graphicObject2.h;
            super.setContent(graphicObject2);
        }
        this.contentWidthDif = this.contentWidth - this.windowWidth;
        this.contentHeightDif = this.contentHeight - this.windowHeight;
    }

    public byte getPossibleScroll() {
        byte by = 0;
        if (this.contentOff.x < 0) {
            by = (byte)(by | 1);
        }
        if (this.contentOff.x > -this.contentWidthDif) {
            by = (byte)(by | 2);
        }
        if (this.contentOff.y < 0) {
            by = (byte)(by | 4);
        }
        if (this.contentOff.y > -this.contentHeightDif) {
            by = (byte)(by | 8);
        }
        return by;
    }

    public boolean scroll(byte by, actionCallback actionCallback2, int n) {
        switch (by) {
            case 0: {
                if (this.contentOff.x >= 0) break;
                this.scrollLeft(this.scrollAddX, actionCallback2, n);
                return true;
            }
            case 1: {
                if (this.contentOff.x <= -this.contentWidthDif) break;
                this.scrollRight(this.scrollAddX, actionCallback2, n);
                return true;
            }
            case 2: {
                if (this.contentOff.y >= 0) break;
                this.scrollUp(this.scrollAddY, actionCallback2, n);
                return true;
            }
            case 3: {
                if (this.contentOff.y <= -this.contentHeightDif) break;
                this.scrollDown(this.scrollAddY, actionCallback2, n);
                return true;
            }
        }
        return false;
    }

    public boolean getScrollBarW() {
        return this.windowWidth < this.contentWidth;
    }

    public boolean getScrollBarH() {
        return this.windowHeight < this.contentHeight;
    }

    public int getScrollWPos() {
        if (this.contentOff != null && this.contentWidthDif > 0) {
            return Math.min(Math.max((-this.contentOff.x << 10) / this.contentWidthDif, 0), 1024);
        }
        return -1;
    }

    public int getScrollHPos() {
        if (this.contentOff != null && this.contentHeightDif > 0) {
            return Math.min(Math.max((-this.contentOff.y << 10) / this.contentHeightDif, 0), 1024);
        }
        return -1;
    }

    public void remove() {
        this.contentOff = null;
        super.remove();
    }

    public abstract void scrollLeft(int var1, actionCallback var2, int var3);

    public abstract void scrollRight(int var1, actionCallback var2, int var3);

    public abstract void scrollUp(int var1, actionCallback var2, int var3);

    public abstract void scrollDown(int var1, actionCallback var2, int var3);

    public abstract void refreshScrollerIndicator();
}

