/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.graphicObject;
import base.layer;
import base.panel;
import core.rectangle;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class container
extends graphicObject {
    int nElements = 0;
    public Vector elements = new Vector();
    public Vector removedElements = new Vector();
    boolean limited;
    rectangle contentDirtyArea = new rectangle();

    public boolean setVisible(boolean bl) {
        if (super.setVisible(bl)) {
            this.dirtyAll();
            return true;
        }
        return false;
    }

    public void addElement(graphicObject graphicObject2) {
        graphicObject2.active = true;
        graphicObject2.parent = this;
        graphicObject2.setLayer(this.myLayer);
        this.elements.addElement(graphicObject2);
        ++this.nElements;
        graphicObject2.dirtyRequest();
        this.dirtyRequest();
    }

    public void removeElement(graphicObject graphicObject2) {
        if (graphicObject2 != null && graphicObject2.parent != null) {
            if (graphicObject2 instanceof container) {
                ((container)graphicObject2).dirtyAllRequest();
            } else {
                graphicObject2.dirtyRequest();
            }
            this.removedElements.addElement(graphicObject2);
            graphicObject2.parent = null;
            if (!graphicObject2.removed) {
                graphicObject2.remove();
            }
            this.dirtyRequest();
        }
    }

    protected void removeFromBackground() {
        for (int i = 0; i < this.nElements; ++i) {
            ((graphicObject)this.elements.elementAt(i)).removeFromBackground();
        }
        super.removeFromBackground();
    }

    public void changeElement(graphicObject graphicObject2, graphicObject graphicObject3) {
        int n = this.elements.indexOf(graphicObject2);
        if (n >= 0) {
            this.removeElement(graphicObject2);
            graphicObject3.parent = this;
            graphicObject3.setLayer(this.myLayer);
            this.elements.insertElementAt(graphicObject3, n);
            ++this.nElements;
            graphicObject3.dirtyRequest();
        }
    }

    public void removeAllElements() {
        for (int i = this.nElements - 1; i >= 0; --i) {
            this.removeElement((graphicObject)this.elements.elementAt(i));
        }
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.dirtyAllRequest();
    }

    public void setDim(int n, int n2) {
        super.setDim(n, n2);
        this.limited = true;
    }

    public void dirtyContent() {
        this.dirty();
    }

    public void dirtyAllRequest() {
        if (this.visible) {
            this.dirtyAll();
        }
    }

    protected void dirtyAll() {
        this.dirty();
        for (int i = 0; i < this.nElements; ++i) {
            graphicObject graphicObject2 = (graphicObject)this.elements.elementAt(i);
            if (graphicObject2 instanceof container) {
                ((container)graphicObject2).dirtyAll();
                continue;
            }
            graphicObject2.dirty();
        }
    }

    public void setLayer(layer layer2) {
        if (this.myLayer != layer2) {
            super.setLayer(layer2);
            for (int i = 0; i < this.nElements; ++i) {
                ((graphicObject)this.elements.elementAt(i)).setLayer(layer2);
            }
        }
    }

    public void getScreenCords(int n, int n2) {
        if (this.dirty) {
            this.getMyScreenCords(n, n2);
            for (int i = 0; i < this.nElements; ++i) {
                ((graphicObject)this.elements.elementAt(i)).getScreenCords(this.xf, this.yf);
            }
        }
    }

    public void addDirtyArea(rectangle rectangle2) {
        if (this.dirty) {
            if (this.limited) {
                this.contentDirtyArea.initAsImposibleRectangle();
                for (int i = 0; i < this.nElements; ++i) {
                    ((graphicObject)this.elements.elementAt(i)).addDirtyArea(this.contentDirtyArea);
                }
                this.getDirtyArea(this.dirtyArea);
                this.contentDirtyArea.intersection(this.dirtyArea);
                rectangle2.add(this.contentDirtyArea);
            } else {
                for (int i = 0; i < this.nElements; ++i) {
                    ((graphicObject)this.elements.elementAt(i)).addDirtyArea(rectangle2);
                }
            }
        }
    }

    public void paint(Graphics graphics, rectangle rectangle2) {
        if (this.limited) {
            this.contentDirtyArea.init(this.xf, this.yf, this.xf + this.w, this.yf + this.h);
            this.contentDirtyArea.intersection(rectangle2);
            this.myPaint(graphics, this.contentDirtyArea);
        } else {
            this.myPaint(graphics, rectangle2);
        }
    }

    protected void myPaint(Graphics graphics, rectangle rectangle2) {
        for (int i = 0; i < this.nElements; ++i) {
            graphicObject graphicObject2 = (graphicObject)this.elements.elementAt(i);
            if (!graphicObject2.removed && graphicObject2.visible) {
                if (graphicObject2.background && graphicObject2.dirty) {
                    ((panel)graphicObject2.myLayer.parent).addBackgroundObject(graphicObject2);
                }
                if ((graphicObject2 instanceof container && !((container)graphicObject2).limited || graphicObject2.xf < rectangle2.w && graphicObject2.yf < rectangle2.h && graphicObject2.xf + graphicObject2.w > rectangle2.x && graphicObject2.yf + graphicObject2.h > rectangle2.y) && (!graphicObject2.background || graphicObject2.dirty)) {
                    graphicObject2.paint(graphics, rectangle2);
                }
            }
            graphicObject2.dirty = false;
        }
    }

    public void clean() {
        int n;
        for (n = 0; n < this.nElements; ++n) {
            graphicObject graphicObject2 = (graphicObject)this.elements.elementAt(n);
            if (!(graphicObject2 instanceof container)) continue;
            ((container)graphicObject2).clean();
        }
        n = this.removedElements.size();
        for (int i = 0; i < n; ++i) {
            graphicObject graphicObject3 = (graphicObject)this.removedElements.elementAt(i);
            if (graphicObject3.active) {
                graphicObject3.destroy();
            }
            this.elements.removeElement(graphicObject3);
        }
        this.nElements -= n;
        this.removedElements.removeAllElements();
    }

    public void destroy() {
        for (int i = 0; i < this.nElements; ++i) {
            graphicObject graphicObject2 = (graphicObject)this.elements.elementAt(i);
            if (!graphicObject2.active) continue;
            graphicObject2.destroy();
        }
        super.destroy();
    }
}

