/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class VideoCanvas
extends Canvas
implements CommandListener,
PlayerListener {
    private PlayerController controller;
    private MIDlet midlet;
    private Displayable returnScreen;
    private String sVideoFile;
    private Command stopCommand;
    private Command replayCommand;
    private Command backCommand;
    private Player player;
    private boolean initDone;
    private boolean volActive;
    private boolean playPending = false;
    private String sMimeType = null;
    private HttpConnection connection = null;
    private InputStream is = null;

    public VideoCanvas(MIDlet mIDlet, Displayable displayable, String string, String string2, boolean bl) {
        this.midlet = mIDlet;
        this.returnScreen = displayable;
        this.volActive = bl;
        this.sVideoFile = string;
        this.controller = new PlayerController();
        this.sMimeType = string2;
        this.replayCommand = new Command("Replay", 1, 1);
        this.stopCommand = new Command("Stop", 1, 2);
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    public static String guessContentType(String string) {
        String string2 = "";
        String string3 = "";
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        if (string2.indexOf("mpg") > -1 || string.indexOf("avi") > -1) {
            string3 = "video/mpeg";
        } else if (string2.indexOf("3gp") > -1) {
            string3 = "video/3gpp";
        } else if (string2.indexOf("mid") > -1 || string2.indexOf("kar") > -1) {
            string3 = "audio/midi";
        } else if (string2.indexOf("wav") > -1) {
            string3 = "audio/x-wav";
        } else if (string2.indexOf("jts") > -1) {
            string3 = "audio/x-tone-seq";
        } else if (string2.indexOf("amr") > -1) {
            string3 = "audio/amr";
        } else if (string2.indexOf("awb") > -1) {
            string3 = "audio/amr-wb";
        }
        return string3;
    }

    public final void prepareToPlay() {
        this.controller.start();
        this.playPending = true;
    }

    public final void showNotify() {
        if (this.playPending) {
            this.playPending = false;
            this.controller.playVideo();
        }
    }

    public final void paint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(-1);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
        graphics.drawString("Loading...", this.getWidth() >> 1, this.getHeight() >> 1, 17);
    }

    public final void commandAction(Command command, Displayable displayable) {
        if (command == this.stopCommand) {
            this.controller.stopVideo();
        } else if (command == this.replayCommand) {
            this.controller.playVideo();
        } else if (command == this.backCommand) {
            this.discardPlayer();
        }
    }

    public final void keyPressed(int n) {
        if (this.getGameAction(n) == 8) {
            int n2 = this.player.getState();
            if (n2 == 400) {
                this.controller.stopVideo();
            } else {
                this.controller.playVideo();
            }
        }
    }

    private final InputStream urlToStream(String string, boolean bl) throws IOException {
        this.connection = (HttpConnection)Connector.open((String)string);
        DataInputStream dataInputStream = this.connection.openDataInputStream();
        if (!bl) {
            byte[] byArray = new byte[1024];
            int n = -1;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = dataInputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            dataInputStream.close();
            this.connection.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
        return dataInputStream;
    }

    public final void doStop() {
        if (this.player != null) {
            try {
                this.player.stop();
                try {
                    this.player.setMediaTime(0L);
                }
                catch (Exception exception) {}
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public final void doPlay() {
        try {
            int n;
            if (!this.initDone || this.player == null) {
                this.initPlayer();
            }
            if ((n = this.player.getState()) == 0) {
                this.player.prefetch();
            } else if (n == 100) {
                this.player.realize();
            } else if (n == 200) {
                this.player.prefetch();
            }
            this.player.start();
        }
        catch (Exception exception) {
            this.discardPlayer();
        }
    }

    public final void initPlayer() {
        try {
            this.initDone = false;
            boolean bl = this.sVideoFile.startsWith("http://");
            this.is = bl ? this.urlToStream(this.sVideoFile, true) : ((Object)((Object)this)).getClass().getResourceAsStream(this.sVideoFile);
            this.player = Manager.createPlayer((InputStream)this.is, (String)this.sMimeType);
            this.player.addPlayerListener((PlayerListener)this);
            this.player.prefetch();
            this.player.realize();
            VideoControl videoControl = (VideoControl)this.player.getControl("VideoControl");
            VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
            if (!this.volActive && volumeControl != null) {
                volumeControl.setLevel(0);
            }
            if (videoControl != null) {
                videoControl.initDisplayMode(1, (Object)this);
                videoControl.setDisplayFullScreen(true);
                videoControl.setDisplayLocation(0, 0);
                videoControl.setDisplaySize(this.getWidth(), this.getHeight());
                videoControl.setVisible(true);
            }
            this.initDone = true;
        }
        catch (IOException iOException) {
            this.discardPlayer();
        }
        catch (MediaException mediaException) {
            this.discardPlayer();
        }
        catch (SecurityException securityException) {
            this.discardPlayer();
        }
        catch (Exception exception) {
            this.discardPlayer();
        }
    }

    public final void discardPlayer() {
        block9: {
            try {
                if (this.player == null) break block9;
                this.controller.setStopped();
                this.player.close();
                this.player = null;
                try {
                    if (this.is != null) {
                        try {
                            this.is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.is = null;
                    }
                    if (this.connection == null) break block9;
                    try {
                        this.connection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connection = null;
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.returnScreen);
    }

    public final void playerUpdate(final Player player, final String string, final Object object) {
        Display display = Display.getDisplay((MIDlet)this.midlet);
        display.callSerially(new Runnable(){

            public final void run() {
                VideoCanvas.this.updateEvent(player, string, object);
            }
        });
    }

    public final void updateEvent(Player player, String string, Object object) {
        if (string == "endOfMedia" || string == "stopped" || string == "stoppedAtTime") {
            this.addCommand(this.replayCommand);
            this.removeCommand(this.stopCommand);
        } else if (string == "closed") {
            this.addCommand(this.replayCommand);
            this.removeCommand(this.stopCommand);
        } else if (string == "started") {
            this.removeCommand(this.replayCommand);
            this.addCommand(this.stopCommand);
        } else if (string.equals("error")) {
            // empty if block
        }
    }

    public class PlayerController
    extends Thread {
        private boolean running;
        private Object controllLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void playVideo() {
            Object object = this.controllLock;
            synchronized (object) {
                this.controllLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stopVideo() {
            Object object = this.controllLock;
            synchronized (object) {
                VideoCanvas.this.doStop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setStopped() {
            this.running = false;
            Object object = this.controllLock;
            synchronized (object) {
                this.controllLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            VideoCanvas.this.doPlay();
            this.running = true;
            while (this.running) {
                try {
                    Object object = this.controllLock;
                    synchronized (object) {
                        this.controllLock.wait();
                        if (!this.running) {
                            break;
                        }
                        VideoCanvas.this.doPlay();
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

