/*
 * Decompiled with CFR 0.152.
 */
import core.mng;
import std.math;

public class simulatorTeam
extends mng {
    public int lineas;
    public static final int[] lineasDes = new int[]{-4, 0, 4};
    public boolean contrataque;
    public int ballDisMin;
    public int defBallDisMin;
    public int goalKeeperBallDisMin;
    public int playerDefDisMin;
    public int playerMedDisMin;
    public int playerDelDisMin;
    public int playerGoalDisMin;
    public int porteroTiroLargoProb = 8;
    public int defensaTiroLargoProb = 3;
    public int medioTiroProb = 2;
    public int mode;
    public int ground;
    public boolean possession;
    public int goals;
    public teamsDb db;
    public int[] myTactic;
    public simulatorBall ball;
    public int playerToBallID;
    static final int rachaFactor = 5000;
    static final int localFactor = 30000;
    static final int trainingFactor = 2000;
    static final int[] premiumPropFactor = new int[]{40, 30, 20, 10};
    static final int[] demarcationFactor = new int[]{1000000, 100000, 0, 0};
    static final int mediaFactor = 10000;
    public int[] disputeFactor = new int[4];

    public simulatorTeam(teamsDb teamsDb2, int n, simulatorBall simulatorBall2, boolean bl) {
        this.db = teamsDb2;
        this.ground = n;
        this.ball = simulatorBall2;
        int n2 = (teamsDb2.cache - teamsDb2.position) * 5000;
        if (bl) {
            n2 += 30000;
        }
        for (int i = 0; i < 4; ++i) {
            this.disputeFactor[i] = (n2 + demarcationFactor[i] + teamsDb2.tiePremium * premiumPropFactor[i] / 50 + teamsDb2.winPremium * premiumPropFactor[3 - i] / 50) / 10000;
        }
        this.lineas = 1;
        this.contrataque = false;
        this.ballDisMin = 3072;
        this.defBallDisMin = 4300;
        this.goalKeeperBallDisMin = 4300;
        this.playerDefDisMin = 3072;
        this.playerMedDisMin = 2764;
        this.playerDelDisMin = 2457;
        this.playerGoalDisMin = 6144;
    }

    public void init() {
        for (int i = 0; i < this.size(); ++i) {
            simulatorPlayer simulatorPlayer2 = (simulatorPlayer)this.elementAt(i);
            simulatorPlayer2.myRep.setPosition(0, playMatchState.simulatorGroundYLimit);
        }
        this.toInitPos();
    }

    public void toInitPos() {
        this.toInitPos(this.ground + 1 >> 1);
    }

    public void toInitPos(int n) {
        this.mode = 0;
        this.myTactic = teamsDb.tactics[this.db.tactic][3 + n];
    }

    public void start() {
        this.mode = 1;
        for (int i = 0; i < this.size(); ++i) {
            simulatorPlayer simulatorPlayer2 = (simulatorPlayer)this.elementAt(i);
            simulatorPlayer2.init();
            simulatorPlayer2.myRep.setPosition(simulatorPlayer2.getMyPosX(), simulatorPlayer2.getMyPosY());
        }
    }

    public void finish() {
        this.mode = 2;
    }

    public void tick() {
        if (this.mode == 1) {
            this.myTactic = this.getMyTactic();
            int n = this.ball.myRep.x;
            int n2 = this.ball.myRep.y;
            int n3 = Integer.MAX_VALUE;
            for (int i = this.size() - 1; i >= 0; --i) {
                int n4;
                simulatorPlayer simulatorPlayer2 = (simulatorPlayer)this.elementAt(i);
                int n5 = n - simulatorPlayer2.myRep.x;
                int n6 = n2 - simulatorPlayer2.myRep.y;
                simulatorPlayer2.ballDisX = n5;
                simulatorPlayer2.ballDisY = n6;
                simulatorPlayer2.ballDis = n4 = math.sqr((n5 >>= 1) * n5 + (n6 >>= 1) * n6) << 1;
                if (n4 >= n3) continue;
                n3 = n4;
                this.playerToBallID = i;
            }
        }
        super.tick();
    }

    public int[] getMyTactic() {
        int n = this.ball.myRep.x / (playMatchState.simulatorGroundWidth / 6) * this.ground;
        int n2 = 2;
        if (n == 0) {
            n2 = 1;
            if (this.contrataque) {
                n2 = 0;
            }
        } else if (n > 0) {
            n2 = 0;
        }
        if (!this.possession & n2 > 0) {
            --n2;
        }
        return teamsDb.tactics[this.db.tactic][n2];
    }

    public simulatorPlayer getPlayerToBall() {
        return (simulatorPlayer)this.elementAt(this.playerToBallID);
    }

    public simulatorPlayer getNearPlayer(simulatorPlayer simulatorPlayer2, boolean bl) {
        int n = simulatorPlayer2.myRep.x;
        int n2 = simulatorPlayer2.myRep.y;
        int n3 = n2 * this.ground;
        int n4 = Integer.MAX_VALUE;
        int n5 = simulatorPlayer2.myTeam.indexOf(simulatorPlayer2);
        for (int i = this.size() - 1; i >= 0; --i) {
            int n6;
            int n7;
            int n8;
            simulatorPlayer simulatorPlayer3 = (simulatorPlayer)this.elementAt(i);
            if ((bl || simulatorPlayer2 == simulatorPlayer3) && (!bl || n3 <= simulatorPlayer3.myRep.y * this.ground) || (n8 = math.sqr((n7 = simulatorPlayer3.myRep.x - n >> 1) * n7 + (n6 = simulatorPlayer3.myRep.y - n2 >> 1) * n6) << 1) >= n4) continue;
            n4 = n8;
            n5 = i;
        }
        simulatorPlayer simulatorPlayer4 = (simulatorPlayer)this.elementAt(n5);
        simulatorPlayer4.playerDis = n4;
        return simulatorPlayer4;
    }

    public simulatorPlayer getNearPlayer(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        for (int i = this.size() - 1; i >= 0; --i) {
            simulatorPlayer simulatorPlayer2 = (simulatorPlayer)this.elementAt(i);
            int n5 = simulatorPlayer2.myRep.x - n >> 1;
            int n6 = simulatorPlayer2.myRep.y - n2 >> 1;
            int n7 = math.sqr(n5 * n5 + n6 * n6) << 1;
            if (n7 >= n3) continue;
            n3 = n7;
            n4 = i;
        }
        return (simulatorPlayer)this.elementAt(n4);
    }

    public void saqueDeBanda() {
        simulatorPlayer simulatorPlayer2 = this.getPlayerToBall();
        simulatorPlayer2.myRep.setPosition(this.ball.myRep.x, this.ball.myRep.y);
        simulatorPlayer2.setPossession();
        playMatchState.setTextState(texts.GOAL_KICK, myState.smallFont, 5, 5);
    }

    public void saqueDePuerta() {
        simulatorPlayer simulatorPlayer2 = (simulatorPlayer)this.elementAt(0);
        simulatorPlayer2.setPossession();
        playMatchState.setTextState(texts.GOAL_KICK, myState.smallFont, 5, 5);
    }
}

