/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageFont {
    private static final int BMF_BIT_FIELD_SMOOTH = 0;
    private static final int BMF_BIT_FIELD_UNICODE = 1;
    private static final int BMF_BIT_FIELD_ITALIC = 4;
    private static final int BMF_BIT_FIELD_BOLDS = 8;
    private static final int BMF_CHAR_ID = 0;
    private static final int BMF_CHAR_X = 1;
    private static final int BMF_CHAR_Y = 2;
    private static final int BMF_CHAR_WIDTH = 3;
    private static final int BMF_CHAR_HEIGHT = 4;
    private static final int BMF_CHAR_XOFFSET = 5;
    private static final int BMF_CHAR_YOFFSET = 6;
    private static final int BMF_CHAR_XADVANCE = 7;
    private static final int BMF_CHAR_PAGE = 8;
    private static final int BMF_CHAR_CHNL = 9;
    protected int width_;
    protected int hSpacing_;
    protected int vSpacing_;
    int bmfFontSize;
    int bmfBitField;
    int bmfCharSet;
    int bmfStrechtH;
    int bmfaa;
    int bmfPaddingUp;
    int bmfPaddingRight;
    int bmfPaddingDown;
    int bmfPaddingLeft;
    int bmfSpacingHoriz;
    int bmfSpacingVert;
    int bmfOutline;
    int bmfLineHeight;
    int bmfBase;
    int bmfScaleW;
    int bmfScaleH;
    int bmfPages;
    int bmfCommonBitField;
    int bmfAlphaChannel;
    int bmfRedChannel;
    int bmfGreenChannel;
    int bmfBlueChannel;
    int[][] bmfChars;
    int[] charMapping;
    String bmfFontName;
    Image bmfBitmap;
    int height;
    int[] charsWidth;
    int[][] pxPos;
    int[] charPos;

    public ImageFont(Image image, String fontFileName) {
        InputStream is = ((Object)((Object)Main.midlet)).getClass().getResourceAsStream("/" + fontFileName + ".fnt");
        this.bmfBitmap = image;
        this.bmfFontName = "";
        DataInputStream dis = new DataInputStream(is);
        try {
            int i;
            char c;
            dis.readInt();
            dis.read();
            dis.readInt();
            this.bmfFontSize = dis.readShort();
            this.bmfBitField = dis.read();
            this.bmfCharSet = dis.read();
            this.bmfStrechtH = dis.read() | dis.read() << 16;
            this.bmfaa = dis.read();
            this.bmfPaddingUp = dis.read();
            this.bmfPaddingRight = dis.read();
            this.bmfPaddingDown = dis.read();
            this.bmfPaddingLeft = dis.read();
            this.bmfSpacingHoriz = dis.read();
            this.bmfSpacingVert = dis.read();
            this.bmfOutline = dis.read();
            while ((c = (char)dis.read()) != '\u0000') {
                this.bmfFontName = this.bmfFontName + c;
            }
            dis.read();
            dis.readInt();
            this.bmfLineHeight = dis.read() | dis.read() << 8;
            this.bmfBase = dis.read() | dis.read() << 8;
            this.bmfScaleW = dis.read() | dis.read() << 8;
            this.bmfScaleH = dis.read() | dis.read() << 8;
            this.bmfPages = dis.read() | dis.read() << 8;
            this.bmfCommonBitField = dis.read();
            this.bmfAlphaChannel = dis.read();
            this.bmfRedChannel = dis.read();
            this.bmfGreenChannel = dis.read();
            this.bmfBlueChannel = dis.read();
            dis.read();
            int n = dis.read() | dis.read() << 8 | dis.read() << 16 | dis.read() << 24;
            for (int i2 = 0; i2 < n; ++i2) {
                dis.read();
            }
            dis.read();
            n = dis.read() | dis.read() << 8 | dis.read() << 16 | dis.read() << 24;
            int maxCharId = 0;
            this.bmfChars = new int[n /= 20][10];
            for (i = 0; i < n; ++i) {
                this.bmfChars[i][0] = dis.read() | dis.read() << 8 | dis.read() << 16 | dis.read() << 24;
                maxCharId = Math.max(maxCharId, this.bmfChars[i][0]);
                this.bmfChars[i][1] = dis.read() | dis.read() << 8;
                this.bmfChars[i][2] = dis.read() | dis.read() << 8;
                this.bmfChars[i][3] = dis.read() | dis.read() << 8;
                this.bmfChars[i][4] = dis.read() | dis.read() << 8;
                this.bmfChars[i][5] = this.convertFrom16Bit(dis.read() | dis.read() << 8);
                this.bmfChars[i][6] = this.convertFrom16Bit(dis.read() | dis.read() << 8);
                this.bmfChars[i][7] = dis.read() | dis.read() << 8;
                this.bmfChars[i][8] = dis.read();
                this.bmfChars[i][9] = dis.read();
            }
            this.charMapping = new int[maxCharId + 1];
            for (i = 0; i < maxCharId + 1; ++i) {
                this.charMapping[i] = -1;
            }
            for (i = 0; i < n; ++i) {
                this.charMapping[this.bmfChars[i][0]] = i;
            }
            this.height = this.bmfLineHeight;
            this.width_ = this.getCharWidth('W');
            this.hSpacing_ = this.bmfSpacingHoriz;
            this.vSpacing_ = this.bmfSpacingVert;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    int convertFrom16Bit(int value) {
        if (value >= 32768) {
            return value - 65536;
        }
        return value;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCharWidth(char c) {
        int index = -1;
        if (c < this.charMapping.length) {
            index = this.charMapping[c];
        }
        if (index == -1) {
            index = this.charMapping[32];
        }
        return this.bmfChars[index][7];
    }

    public void write(Graphics g, String s, int x, int y, int anchor) {
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        if ((8 & anchor) == 8) {
            x -= this.getStringWidth(s);
        }
        if ((1 & anchor) == 1) {
            x -= this.getStringWidth(s) / 2;
        }
        if ((0x20 & anchor) == 32) {
            y -= this.getHeight() - 1;
        }
        if ((2 & anchor) == 2) {
            y -= this.getHeight() / 2;
        }
        for (int i = 0; i < s.length(); ++i) {
            int index = -1;
            if (s.charAt(i) < this.charMapping.length) {
                index = this.charMapping[s.charAt(i)];
            }
            if (index != -1) {
                g.setClip(x + this.bmfChars[index][5], y + this.bmfChars[index][6], this.bmfChars[index][3], this.bmfChars[index][4]);
                g.drawImage(this.bmfBitmap, x - this.bmfChars[index][1] + this.bmfChars[index][5], y - this.bmfChars[index][2] + this.bmfChars[index][6], 0x10 | 4);
            }
            x += this.getCharWidth(s.charAt(i));
        }
        g.setClip(cx, cy, cw, ch);
    }

    public int getStringWidth(String s) {
        int x = 0;
        for (int i = 0; i < s.length(); ++i) {
            x += this.getCharWidth(s.charAt(i));
        }
        return x;
    }

    ImageFont() {
    }

    public void write(Graphics g, String[] s, int x, int y, int anchor, int offset, int num) {
        if ((0x20 & anchor) > 0) {
            y -= this.height * s.length;
        }
        if ((2 & anchor) > 0) {
            y -= this.height * s.length / 2;
        }
        if (num == 0) {
            num = s.length - offset;
        }
        for (int i = offset; i < offset + num; ++i) {
            this.write(g, s[i], x, y + (i - offset) * this.getHeight(), anchor);
        }
    }
}

