/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class TileSet {
    int[][] pos;
    ImageHandle img;

    public TileSet(ImageHandle img, int[][] pos, boolean process) {
        this.img = img;
        this.pos = pos;
        if (process) {
            for (int i = 0; i < pos.length; ++i) {
                pos[i][2] = pos[i][2] - pos[i][0];
                pos[i][3] = pos[i][3] - pos[i][1];
            }
        }
    }

    public TileSet(ImageHandle img, int[][] pos) {
        this(img, pos, true);
    }

    public TileSet(ImageHandle img, int width, int height) {
        this.img = img;
        int tileWidth = img.getImage().getWidth() / width;
        int tileHeight = img.getImage().getHeight() / height;
        this.pos = new int[width * height][];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.pos[x + y * width] = new int[]{x * tileWidth, y * tileHeight, tileWidth, tileHeight};
            }
        }
    }

    public int getWidth(int id) {
        return this.pos[id][2];
    }

    public int getHeight(int id) {
        return this.pos[id][3];
    }

    public void paint(Graphics g, int x, int y, int id, int anchor, boolean mirror) {
        DispManager.saveClip(g);
        y = this.transformY(y, id, anchor);
        x = this.transformX(x, id, anchor);
        g.setClip(x, y, this.pos[id][2], this.pos[id][3]);
        if (!mirror) {
            g.drawImage(this.img.getImage(), x - this.pos[id][0], y - this.pos[id][1], 0x10 | 4);
        } else {
            Sprite s = this.img.getMirror();
            s.setPosition(x - (this.img.getImage().getWidth() - this.pos[id][0] - this.getWidth(id)), y - this.pos[id][1]);
            s.paint(g);
        }
        DispManager.loadClip(g);
    }

    protected int transformY(int y, int id, int anchor) {
        if ((0x20 & anchor) > 0) {
            return y - this.getHeight(id) + 1;
        }
        if ((2 & anchor) > 0) {
            return y - this.getHeight(id) / 2;
        }
        return y;
    }

    protected int transformX(int x, int id, int anchor) {
        if ((8 & anchor) > 0) {
            return x - this.getWidth(id);
        }
        if ((1 & anchor) > 0) {
            return x - this.getWidth(id) / 2;
        }
        return x;
    }
}

