/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class ImageHandle {
    private static Hashtable images = new Hashtable(30);
    String imgName;
    private Image img;
    private Sprite mirror;

    private ImageHandle(String imgName) {
        this.imgName = imgName;
        images.put(imgName, this);
    }

    public static ImageHandle getImage(String name) {
        if (images.get(name) == null) {
            return new ImageHandle(name);
        }
        return (ImageHandle)images.get(name);
    }

    public Sprite getMirror() {
        if (this.mirror == null) {
            this.mirror = new Sprite(this.getImage());
            this.mirror.setTransform(2);
        }
        return this.mirror;
    }

    public void drop() {
        this.img = null;
        this.mirror = null;
    }

    public static void dropAll() {
        Enumeration e = images.elements();
        while (e.hasMoreElements()) {
            ((ImageHandle)e.nextElement()).drop();
        }
    }

    public Image getImage() {
        if (this.img == null) {
            try {
                this.img = Image.createImage((String)("/" + this.imgName + ".png"));
            }
            catch (IOException ex) {
                System.out.println("blad w czasie wczytywania obrazka: " + this.imgName);
            }
        }
        return this.img;
    }

    public static Image replaceColor(Image m, int f, int t) {
        int[] data = new int[m.getHeight() * m.getWidth()];
        m.getRGB(data, 0, m.getWidth(), 0, 0, m.getWidth(), m.getHeight());
        for (int i = 0; i < data.length; ++i) {
            int a = data[i];
            if ((a & 0xFF000000) != 0 && f == (a & 0xFFFFFF)) {
                a = a & 0xFF000000 | t;
            }
            data[i] = a;
        }
        return Image.createRGBImage((int[])data, (int)m.getWidth(), (int)m.getHeight(), (boolean)true);
    }
}

