/*
 * Decompiled with CFR 0.152.
 */
package screens;

import game.Apearance;
import game.Scenario;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lib.Fonts;
import lib.Lib;
import main.FrameOfScenario;
import main.GameManager;
import main.MusicManager;
import screens.MenuScreen;
import screens.elements.Hint;
import screens.elements.PhotoSessionModus;

public class DialogScreen {
    public static int COLOR_DIALOG_BKG_PLAYER_LIGHT = 0xFFFFFF;
    public static int COLOR_DIALOG_BKG_PLAYER_DARK = 0xCCCCFF;
    public static int COLOR_DIALOG_BKG_OTHER_WOMAN = 0xFFCCCC;
    public static int COLOR_DIALOG_BKG_INFO = 0xFFFFFF;
    public static int COLOR_CHANGE_STEP = 328960;
    public static int DIALOG_ARROW_MARGIN = 1;
    public static int DIALOG_ARROW_MOVEMENT_STEP = 50;
    public static int DIALOG_ARROW_MOVEMENT_SIZE = 500;
    public static final int TALKING_NON = 0;
    public static final int TALKING_PLAYER = 1;
    public static final int TALKING_LADY = 2;
    private static int arrowDialogOffset = 0;
    private static int arrowDialogMovementDirection;
    private static int colorDialogPlayer;
    private static int colorChangeDirection;
    public static FrameOfScenario currentFrame;
    private static int previousFrameId;
    public static int whosTalking;
    public static int playerTextSelected;
    public static int[][][] curentTextShownWrapped;
    public static boolean isArcadeModeActive;
    private static boolean isArcadeDialogDiscard;
    private static boolean isArcadeGameWon;
    public static final int ARCADE_STATE_NONE = -1;
    public static final int ARCADE_STATE_DIALOG = 1;
    public static final int ARCADE_STATE_HORIZONTAL = 2;
    public static final int ARCADE_STATE_VERTICAL = 3;
    public static final int ARCADE_STATE_PRESENTATION = 4;
    public static final int ARCADE_STATE_PROMPT = 5;
    public static int arcadeState;
    public static boolean isImageBlured;
    private static int requestedArcadeNextFrame;
    private static int boxHeight;
    public static int currentImageId;
    public static int continueFrameId;
    public static int continueInitialClothes;
    public static boolean stopAnimateGame;
    public static int currentClothes;
    public static boolean currentClothesVisible;
    public static Image imgLadyBlured;
    public static int DIALOG_TEXT_INTERLINE;
    public static int DIALOG_TEXT_OFFSET;
    public static int DIALOG_BOX_ADDITIONAL_SPACE;

    public static void showGameScreen(boolean newGame) {
        colorChangeDirection = COLOR_CHANGE_STEP;
        colorDialogPlayer = COLOR_DIALOG_BKG_PLAYER_LIGHT;
        arrowDialogMovementDirection = DIALOG_ARROW_MOVEMENT_STEP;
        arrowDialogOffset = 0;
        arrowDialogMovementDirection = DIALOG_ARROW_MOVEMENT_STEP;
        GameManager.isContinueIconEnabled = false;
        continueFrameId = -1;
        continueInitialClothes = -1;
        currentImageId = -1;
        for (int i = 0; i < Scenario.size(); ++i) {
            FrameOfScenario fos = Scenario.elementAt(i);
            if (fos.type != 86) continue;
            Scenario.setFramesStates(i, 0);
        }
        GameManager.current.startOperation(4, 10);
        if (newGame) {
            currentFrame = null;
            whosTalking = -1;
            currentImageId = 0;
            Scenario.initFrameStates();
        }
        DialogScreen.nextGameStep();
        GameManager.current.startOperation(6);
    }

    public static void showGameScreen(int initialFrame) {
        currentFrame = new FrameOfScenario(0, 0, 73, 1, 1);
        DialogScreen.currentFrame.nextId[0] = initialFrame;
        currentImageId = -1;
        DialogScreen.showGameScreen(false);
    }

    public static void paint_GameDialog(Graphics g) {
        PhotoSessionModus.doUpdateParameteres();
        g.drawImage(GameManager.imgCurrentImage, GameManager.current.getWidth() / 2, GameManager.current.getHeight() / 2, 3);
        boxHeight = curentTextShownWrapped != null ? curentTextShownWrapped[playerTextSelected].length * (Fonts.fontDialog.getHeight() + DIALOG_TEXT_INTERLINE) + DIALOG_BOX_ADDITIONAL_SPACE + 2 * DIALOG_TEXT_INTERLINE : 0;
        GameManager.current.getHeight();
        GameManager.current.getWidth();
        int upperBox = GameManager.current.getHeight() - boxHeight;
        if (isArcadeModeActive && Hint.shownHintId < 0) {
            PhotoSessionModus.paint(g);
        }
        if (arcadeState != 2 && arcadeState != 3 && whosTalking != 0) {
            int margY;
            boolean blinking = false;
            if (whosTalking == 1 && (DialogScreen.currentFrame.type == 68 || DialogScreen.currentFrame.type == 67 || DialogScreen.currentFrame.type == 74 || DialogScreen.currentFrame.type == 86) && DialogScreen.currentFrame.selectionsCount > 1 || whosTalking == 1 && arcadeState == 1 && DialogScreen.currentFrame.selectionsCount > 3) {
                blinking = true;
            }
            if (whosTalking == 1 && (DialogScreen.currentFrame.type == 74 || DialogScreen.currentFrame.type == 86)) {
                blinking = false;
            }
            if (whosTalking == 1) {
                if (DialogScreen.currentFrame.headIds[playerTextSelected] >= 0) {
                    margY = 1;
                    Lib.drawSprite(g, GameManager.imgFaces, 5, upperBox - margY - GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight() * DialogScreen.currentFrame.headIds[playerTextSelected], 0);
                }
                if (blinking) {
                    g.setColor(colorDialogPlayer);
                } else if (DialogScreen.currentFrame.headIds[playerTextSelected] >= 0) {
                    g.setColor(COLOR_DIALOG_BKG_PLAYER_DARK);
                } else {
                    g.setColor(COLOR_DIALOG_BKG_INFO);
                }
            } else if (whosTalking == 2 && DialogScreen.currentFrame.headIds[playerTextSelected + DialogScreen.currentFrame.selectionsCount] >= 0) {
                margY = 1;
                Lib.drawSprite(g, GameManager.imgFaces, 5, upperBox - margY - GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight() * DialogScreen.currentFrame.headIds[playerTextSelected + DialogScreen.currentFrame.selectionsCount], 0);
            }
            switch (DialogScreen.currentFrame.headIds[playerTextSelected + (whosTalking == 2 ? DialogScreen.currentFrame.selectionsCount : 0)]) {
                case 0: {
                    if (blinking) {
                        g.setColor(colorDialogPlayer);
                        break;
                    }
                    g.setColor(COLOR_DIALOG_BKG_PLAYER_DARK);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    g.setColor(COLOR_DIALOG_BKG_OTHER_WOMAN);
                    break;
                }
                default: {
                    g.setColor(COLOR_DIALOG_BKG_INFO);
                }
            }
            int boxRoundSize = 12;
            int boxTopOffset = 0;
            int boxRightOffset = 1;
            int boxHeightDiff = 0;
            g.fillRoundRect(0, upperBox - boxTopOffset - 1, GameManager.current.getWidth() - boxRightOffset, boxHeight - boxHeightDiff, boxRoundSize, boxRoundSize);
            g.setColor(Apearance.COLOR_WHITE);
            g.drawRoundRect(0, upperBox - boxTopOffset - 1, GameManager.current.getWidth() - boxRightOffset, boxHeight - boxHeightDiff, boxRoundSize, boxRoundSize);
            g.setColor(Apearance.COLOR_BLACK);
            g.drawRoundRect(1, upperBox - boxTopOffset, GameManager.current.getWidth() - boxRightOffset - 2, boxHeight - boxHeightDiff - 2, boxRoundSize, boxRoundSize);
            g.setColor(Apearance.COLOR_DIALOG_TEXT);
            if (curentTextShownWrapped != null) {
                Lib.drawTextLines(g, curentTextShownWrapped[playerTextSelected], GameManager.current.getWidth() / 2, (GameManager.current.getHeight() + upperBox + DIALOG_TEXT_OFFSET) / 2, Fonts.fontDialog, true, DIALOG_TEXT_INTERLINE);
            }
            if (blinking) {
                Lib.drawSprite(g, GameManager.imgArrows, DIALOG_ARROW_MARGIN + arrowDialogOffset / 100 + 1, (GameManager.current.getHeight() + upperBox) / 2 - GameManager.imgArrows.getHeight() / 4 - 1, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, 0, 0);
                Lib.drawSprite(g, GameManager.imgArrows, GameManager.current.getWidth() - DIALOG_ARROW_MARGIN - GameManager.imgArrows.getWidth() / 2 - arrowDialogOffset / 100, (GameManager.current.getHeight() + upperBox) / 2 - GameManager.imgArrows.getHeight() / 4 - 1, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, GameManager.imgArrows.getWidth() / 2, 0);
            }
        }
        Hint.drawHint(g, Hint.shownHintId);
    }

    public static void keyPressed_GameDialog(int key) throws InterruptedException {
        if (Hint.shownHintId == 3) {
            PhotoSessionModus.arrowHudOffset = -PhotoSessionModus.WINNING_AREA_RADIUS - 1;
            Hint.shownHintId = -1;
            DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, true);
            PhotoSessionModus.enableHudArrowCapture = true;
            return;
        }
        Hint.shownHintId = -1;
        if (key == GameManager.KEY_SOFTKEY2 || key == -GameManager.KEY_SOFTKEY2) {
            MenuScreen.showInGameMain(true);
            return;
        }
        if (GameManager.current.getGameAction(key) == 8) {
            DialogScreen.nextGameStep();
            return;
        }
        int selectionCount = -1;
        if ((DialogScreen.currentFrame.type == 68 || DialogScreen.currentFrame.type == 67) && whosTalking == 1) {
            selectionCount = DialogScreen.currentFrame.selectionsCount;
        }
        if (DialogScreen.currentFrame.type == 65 && arcadeState == 1 && whosTalking == 1) {
            selectionCount = DialogScreen.currentFrame.selectionsCount - 2;
        }
        if (selectionCount > 0) {
            switch (GameManager.current.getGameAction(key)) {
                case 5: {
                    ++playerTextSelected;
                    playerTextSelected = Lib.mod(playerTextSelected, selectionCount);
                    if (DialogScreen.skipEmptyFrame()) {
                        return;
                    }
                    GameManager.current.repaint();
                    return;
                }
                case 2: {
                    --playerTextSelected;
                    playerTextSelected = Lib.mod(playerTextSelected, selectionCount);
                    if (DialogScreen.skipEmptyFrame()) {
                        return;
                    }
                    GameManager.current.repaint();
                    return;
                }
            }
        }
        if (DialogScreen.currentFrame.type == 65) {
            return;
        }
        if (key == 1 || key == 6 || key == 2 || key == 5) {
            return;
        }
        if (whosTalking != 1 || DialogScreen.currentFrame.textPlayer.length <= 1) {
            Hint.hintUsed[1] = false;
            Hint.enableShowHint(1);
            GameManager.current.repaint();
        }
    }

    static void closeGame() {
        stopAnimateGame = true;
        currentFrame = null;
        currentImageId = -1;
        isArcadeModeActive = false;
        whosTalking = -1;
        arcadeState = -1;
        requestedArcadeNextFrame = -1;
        playerTextSelected = 0;
        currentClothesVisible = false;
        isImageBlured = false;
    }

    public static void nextGameStep() {
        try {
            DialogScreen.nextGameStepImpl();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        if (DialogScreen.currentFrame.type == 69 && whosTalking != 1) {
            return;
        }
        DialogScreen.skipEmptyFrame();
    }

    public static boolean skipEmptyFrame() {
        if (curentTextShownWrapped != null && arcadeState != 2 && arcadeState != 3 && curentTextShownWrapped[playerTextSelected][0][0] == Fonts.fontMapper.mapString("(-)")[0]) {
            DialogScreen.nextGameStep();
            return true;
        }
        return false;
    }

    private static void nextGameStepImpl() throws InterruptedException {
        if (!(arcadeState != 2 && arcadeState != 3 || PhotoSessionModus.enableHudArrowCapture)) {
            return;
        }
        if (whosTalking == 1 && arcadeState != 5 && DialogScreen.currentFrame.type != 69) {
            whosTalking = 2;
            curentTextShownWrapped = DialogScreen.currentFrame.textLady;
            GameManager.current.repaint();
            return;
        }
        if (isArcadeModeActive) {
            if (arcadeState == 1) {
                arcadeState = 5;
                whosTalking = 1;
                curentTextShownWrapped = DialogScreen.currentFrame.textPlayer;
                currentClothes = DialogScreen.currentFrame.nextId[2 * playerTextSelected + 1];
                DialogScreen.loadClothes(currentClothes);
                Scenario.setFramesStates(DialogScreen.currentFrame.id, playerTextSelected + 1);
                requestedArcadeNextFrame = 2 * playerTextSelected + 2;
                playerTextSelected = curentTextShownWrapped.length - 2;
                DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, true);
                GameManager.current.repaint();
                return;
            }
            if (arcadeState == 5) {
                arcadeState = 2;
                PhotoSessionModus.enableHudArrowCapture = true;
                if (!Hint.hintUsed[3]) {
                    Hint.enableShowHint(3);
                    Hint.hintUsed[3] = true;
                    PhotoSessionModus.enableHudArrowCapture = false;
                }
                whosTalking = 2;
                curentTextShownWrapped = DialogScreen.currentFrame.textLady;
                DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, true);
                GameManager.current.repaint();
                return;
            }
            if (arcadeState == 2) {
                PhotoSessionModus.enableHudArrowCapture = false;
                GameManager.current.repaint();
                GameManager.current.serviceRepaints();
                whosTalking = 2;
                Thread.sleep(700L);
                arcadeState = 3;
                PhotoSessionModus.arrowHudOffsetVertical = PhotoSessionModus.arrowHudOffset;
                DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, false);
                PhotoSessionModus.enableHudArrowCapture = true;
                return;
            }
            if (arcadeState == 3) {
                PhotoSessionModus.enableHudArrowCapture = false;
                GameManager.current.repaint();
                GameManager.current.serviceRepaints();
                Thread.sleep(350L);
                MusicManager.playFX();
                if (PhotoSessionModus.isWon()) {
                    isArcadeGameWon = true;
                    isImageBlured = false;
                } else {
                    isArcadeGameWon = false;
                    isImageBlured = true;
                }
                arcadeState = 4;
                whosTalking = 2;
                playerTextSelected = DialogScreen.currentFrame.selectionsCount - 2;
                curentTextShownWrapped = DialogScreen.currentFrame.textLady;
                DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, true);
                GameManager.current.repaint();
                return;
            }
            if (arcadeState == 4) {
                if (isArcadeGameWon) {
                    playerTextSelected = DialogScreen.currentFrame.selectionsCount - 1;
                    whosTalking = 1;
                    curentTextShownWrapped = DialogScreen.currentFrame.textPlayer;
                    isArcadeModeActive = false;
                    GameManager.isContinueIconEnabled = false;
                    GameManager.current.repaint();
                    return;
                }
                isArcadeModeActive = false;
                if (isArcadeGameWon) {
                    arcadeState = -1;
                }
                requestedArcadeNextFrame = -1;
                GameManager.isContinueIconEnabled = false;
                playerTextSelected = 0;
                whosTalking = 1;
            }
        }
        if (currentFrame == null) {
            currentFrame = Scenario.firstElement();
            whosTalking = 1;
            isImageBlured = false;
        } else if (!isArcadeModeActive) {
            if (DialogScreen.currentFrame.type == 69) {
                curentTextShownWrapped = DialogScreen.currentFrame.textLady;
                whosTalking = 2;
                GameManager.current.startOperation(4, 89);
                return;
            }
            if (DialogScreen.currentFrame.type == 74) {
                requestedArcadeNextFrame = Scenario.getFramesStates(DialogScreen.currentFrame.nextId[0]) + 1;
            }
            if (requestedArcadeNextFrame > 0) {
                DialogScreen.switchCurrentFrameTo(DialogScreen.currentFrame.nextId[requestedArcadeNextFrame]);
                requestedArcadeNextFrame = -1;
                if (DialogScreen.currentFrame.type != 65 && arcadeState == 4) {
                    arcadeState = -1;
                }
            } else {
                if (!isArcadeModeActive && DialogScreen.currentFrame.type != 65 && arcadeState == 4) {
                    arcadeState = -1;
                }
                DialogScreen.switchCurrentFrameTo(DialogScreen.currentFrame.nextId[playerTextSelected]);
            }
            if (isArcadeDialogDiscard) {
                isArcadeDialogDiscard = false;
                if (DialogScreen.currentFrame.type == 65) {
                    isArcadeModeActive = true;
                    whosTalking = 2;
                    arcadeState = 1;
                    if (Scenario.getFramesStates(DialogScreen.currentFrame.id) > 0) {
                        playerTextSelected = Scenario.getFramesStates(DialogScreen.currentFrame.id) - 1;
                    }
                    DialogScreen.nextGameStep();
                    return;
                }
                currentFrame = Scenario.elementAt(DialogScreen.currentFrame.nextId[playerTextSelected]);
            }
        }
        if (!isArcadeModeActive) {
            whosTalking = 1;
            if (DialogScreen.currentFrame.type != 74 && DialogScreen.currentFrame.type != 86) {
                if (!Hint.hintUsed[2] && DialogScreen.currentFrame.textPlayer.length > 1) {
                    Hint.enableShowHint(2);
                    Hint.hintUsed[2] = true;
                } else if (!Hint.hintUsed[0]) {
                    Hint.enableShowHint(0);
                    Hint.hintUsed[0] = true;
                }
            }
            if (DialogScreen.currentFrame.type == 65) {
                isArcadeModeActive = true;
                arcadeState = 1;
                whosTalking = 1;
                currentClothesVisible = true;
                if (continueFrameId < 0) {
                    continueFrameId = DialogScreen.currentFrame.id;
                    continueInitialClothes = currentClothes;
                    DialogScreen.loadClothes(currentClothes);
                    GameManager.isContinueIconEnabled = false;
                }
            }
            if (DialogScreen.currentFrame.type == 74) {
                playerTextSelected = Scenario.getFramesStates(DialogScreen.currentFrame.nextId[0]);
            } else if (DialogScreen.currentFrame.type == 86) {
                playerTextSelected = Scenario.getFramesStates(DialogScreen.currentFrame.id);
                if (playerTextSelected >= DialogScreen.currentFrame.selectionsCount) {
                    playerTextSelected = DialogScreen.currentFrame.selectionsCount - 1;
                }
            } else {
                playerTextSelected = 0;
            }
            if (DialogScreen.currentFrame.type == 67) {
                currentClothes = DialogScreen.currentFrame.nextId[DialogScreen.currentFrame.selectionsCount];
                DialogScreen.loadClothes(currentClothes);
                currentClothesVisible = true;
                DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, true);
            }
        }
        curentTextShownWrapped = DialogScreen.currentFrame.textPlayer;
        DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, false);
        GameManager.current.repaint();
    }

    private static void clearPartsMemory() {
        if (GameManager.imgClothesParts != null) {
            for (int i = 0; i < GameManager.imgClothesParts.length; ++i) {
                GameManager.imgClothesParts[i] = null;
            }
        }
        System.gc();
        GameManager.imgClothesParts = new Image[Apearance.CLOTHES_PARTS_POSITIONS_X.length];
    }

    private static void loadClothes(int clothes) {
        int i;
        boolean missingParts = false;
        for (i = 0; i < GameManager.imgClothesParts.length; ++i) {
            if ((clothes & Lib.POWERS[i + 1]) != Lib.POWERS[i + 1] || GameManager.imgClothesParts[i] != null) continue;
            missingParts = true;
            break;
        }
        if (missingParts) {
            DialogScreen.clearPartsMemory();
            for (i = 0; i < GameManager.imgClothesParts.length; ++i) {
                if ((clothes & Lib.POWERS[i + 1]) != Lib.POWERS[i + 1] || GameManager.imgClothesParts[i] != null) continue;
                GameManager.imgClothesParts[i] = Lib.loadImage("/part" + (i + 1) + ".png");
            }
        }
    }

    private static void switchCurrentFrameTo(int nextFrameId) {
        if (DialogScreen.currentFrame.type != 65) {
            Scenario.setFramesStates(DialogScreen.currentFrame.id, playerTextSelected + 1);
        }
        if (nextFrameId == 999) {
            nextFrameId = previousFrameId;
            isArcadeDialogDiscard = true;
        }
        previousFrameId = DialogScreen.currentFrame.id;
        currentFrame = Scenario.elementAt(nextFrameId);
        if (DialogScreen.currentFrame.imageId != currentImageId) {
            currentClothesVisible = false;
        }
    }

    public static void opAnimateGame() throws InterruptedException {
        System.out.println("OP_GAME started");
        stopAnimateGame = false;
        while (!stopAnimateGame) {
            if (arcadeState == 2 || arcadeState == 3) {
                PhotoSessionModus.doAnimateArcade();
                continue;
            }
            DialogScreen.doAnimateDialog();
        }
        stopAnimateGame = false;
        System.out.println("    OP_GAME stopped");
    }

    private static void doAnimateDialog() throws InterruptedException {
        if (whosTalking == 1) {
            if ((colorDialogPlayer += colorChangeDirection) <= COLOR_DIALOG_BKG_PLAYER_DARK) {
                colorDialogPlayer = COLOR_DIALOG_BKG_PLAYER_DARK;
                colorChangeDirection = -colorChangeDirection;
            }
            if (colorDialogPlayer >= COLOR_DIALOG_BKG_PLAYER_LIGHT) {
                colorDialogPlayer = COLOR_DIALOG_BKG_PLAYER_LIGHT;
                colorChangeDirection = -colorChangeDirection;
            }
            if ((arrowDialogOffset += arrowDialogMovementDirection) < 0) {
                arrowDialogOffset = 0;
                arrowDialogMovementDirection = -arrowDialogMovementDirection;
            }
            if (arrowDialogOffset > DIALOG_ARROW_MOVEMENT_SIZE) {
                arrowDialogOffset = DIALOG_ARROW_MOVEMENT_SIZE;
                arrowDialogMovementDirection = -arrowDialogMovementDirection;
            }
            GameManager.current.repaint();
            Thread.sleep(MenuScreen.MENU_ANIMATION_BASE_INTERVAL);
        } else if (arcadeState != 2 && arcadeState != 3) {
            Thread.sleep(MenuScreen.MENU_ANIMATION_BASE_INTERVAL);
        }
    }

    public static void requestImageUpdate(int requestedImageId, boolean forceUpdate) {
        if (GameManager.imgCurrentImage == null || !GameManager.imgCurrentImage.isMutable()) {
            GameManager.imgCurrentImage = Image.createImage((int)GameManager.current.getWidth(), (int)GameManager.current.getHeight());
        }
        if (requestedImageId == 64) {
            requestedImageId = currentImageId;
        }
        if (currentImageId != requestedImageId) {
            GameManager.imgCurrentBackground = null;
            forceUpdate = true;
            System.gc();
            GameManager.imgCurrentBackground = Lib.loadImage("/" + (char)requestedImageId + ".png");
            currentImageId = DialogScreen.currentFrame.imageId;
        }
        Graphics g = GameManager.imgCurrentImage.getGraphics();
        if (forceUpdate) {
            g.drawImage(GameManager.imgCurrentBackground, GameManager.current.getWidth() / 2, GameManager.current.getHeight() / 2, 3);
            if (arcadeState == 4 || arcadeState == 2 || arcadeState == 3 || arcadeState == 1 || arcadeState == 5 || currentClothesVisible) {
                for (int part = 0; part < Apearance.CLOTHES_PARTS_POSITIONS_X.length; ++part) {
                    if ((currentClothes & Lib.POWERS[part + 1]) <= 0) continue;
                    g.drawImage(GameManager.imgClothesParts[part], GameManager.current.getWidth() / 2 - 120 + Apearance.CLOTHES_PARTS_POSITIONS_X[part], GameManager.current.getHeight() / 2 - 160 + Apearance.CLOTHES_PARTS_POSITIONS_Y[part], 0);
                }
            }
            if (arcadeState == 4) {
                if (isImageBlured && imgLadyBlured != null) {
                    g.drawImage(imgLadyBlured, GameManager.current.getWidth() / 2, GameManager.current.getHeight() / 2, 3);
                }
                if (GameManager.imgFilmFrame != null) {
                    g.drawImage(GameManager.imgFilmFrame, GameManager.current.getWidth() / 2, GameManager.current.getHeight() / 2, 3);
                }
            }
            if (isArcadeModeActive && (arcadeState == 2 || arcadeState == 3) && GameManager.imgHud != null && Hint.shownHintId < 0) {
                g.drawImage(GameManager.imgHud, GameManager.current.getWidth() / 2, GameManager.current.getHeight() / 2, 3);
            }
        }
    }

    static {
        currentFrame = null;
        previousFrameId = 0;
        whosTalking = 0;
        playerTextSelected = 0;
        curentTextShownWrapped = null;
        isArcadeModeActive = false;
        isArcadeDialogDiscard = false;
        isArcadeGameWon = false;
        arcadeState = -1;
        isImageBlured = false;
        requestedArcadeNextFrame = -1;
        boxHeight = 0;
        currentImageId = -1;
        continueFrameId = -1;
        continueInitialClothes = -1;
        stopAnimateGame = false;
        currentClothesVisible = false;
        imgLadyBlured = null;
        DIALOG_TEXT_INTERLINE = 0;
        DIALOG_TEXT_OFFSET = -1;
        DIALOG_BOX_ADDITIONAL_SPACE = 5;
    }
}

