/*
 * Decompiled with CFR 0.152.
 */
package lib;

import font.VectorFont;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.GameManager;

public class Lib {
    public static final int[] POWERS = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000};

    public static Image loadImageNOTHROWERR(String fileName) {
        try {
            return Image.createImage((String)fileName);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Image loadImage(String fileName) {
        try {
            return Image.createImage((String)fileName);
        }
        catch (Throwable ex) {
            GameManager.showErrorScreen("Can't load image:\\" + fileName + "\\" + ex.toString() + "\\" + ex.getMessage());
            System.out.println("Can't load image:\\" + fileName + "\\" + ex.toString() + "\\" + ex.getMessage());
            return null;
        }
    }

    public static void drawSprite(Graphics g, Image img, int posX, int posY, int width, int height, int offsetX, int offsetY) {
        int x = g.getClipX();
        int y = g.getClipY();
        int w = g.getClipWidth();
        int h = g.getClipHeight();
        int xp = Math.max(posX, x);
        int yp = Math.max(posY, y);
        int xr = Math.min(posX + width, x + w);
        int yr = Math.min(posY + height, y + h);
        g.setClip(xp, yp, xr - xp, yr - yp);
        if (xp < 0 || yp < 0 || xr - xp <= 0 || yr - yp <= 0) {
            g.setClip(x, y, w, h);
            g.clipRect(x, y, w, h);
            return;
        }
        g.clipRect(xp, yp, xr - xp, yr - yp);
        g.drawImage(img, posX - offsetX, posY - offsetY, 20);
        g.setClip(x, y, w, h);
        g.clipRect(x, y, w, h);
    }

    public static void drawTextLines(Graphics g, int[][] textLines, int posX, int posY, VectorFont font, boolean isCenteredVertically, int interline) {
        int topY = isCenteredVertically ? posY - textLines.length * (font.getHeight() + interline) / 2 : posY;
        for (int i = 0; i < textLines.length; ++i) {
            font.drawString(g, textLines[i], posX, topY + i * (font.getHeight() + interline), 17);
        }
    }

    public static int mod(int a2, int b) {
        if (a2 >= 0) {
            return a2 % b;
        }
        return (a2 + (-a2 / b + 1) * b) % b;
    }

    public static void drawStringOutlined(Graphics g, int[] string, int posX, int posY, int align, int colorOutline, VectorFont font) {
        int colorPrev = g.getColor();
        g.setColor(colorOutline);
        font.drawString(g, string, posX + 1, posY + 1, align);
        font.drawString(g, string, posX - 1, posY, align);
        font.drawString(g, string, posX + 1, posY, align);
        font.drawString(g, string, posX, posY - 1, align);
        font.drawString(g, string, posX, posY + 1, align);
        font.drawString(g, string, posX - 1, posY - 1, align);
        font.drawString(g, string, posX - 1, posY + 1, align);
        font.drawString(g, string, posX + 1, posY - 1, align);
        font.drawString(g, string, posX + 1, posY + 1, align);
        g.setColor(colorPrev);
        font.drawString(g, string, posX, posY, align);
    }
}

