/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import main.GameManager;

public class TextInputStream {
    private InputStreamReader isr;
    private int lastChar = -1;
    private static final int BOM = 65279;
    private String readedFile;
    private int currentLineStart = 0;
    private int currentLineEnd;
    private boolean isLastLine = false;

    public TextInputStream(InputStream is) throws UnsupportedEncodingException, IOException {
        this.isr = this.isr = new InputStreamReader(is, "UTF-8");
        int chunkSize = 2000;
        this.readedFile = new String();
        char[] array = new char[chunkSize];
        int numberOfReadedBytes = 0;
        try {
            while ((numberOfReadedBytes = this.isr.read(array, 0, chunkSize)) == chunkSize) {
                this.readedFile = this.readedFile.concat(new String(array, 0, numberOfReadedBytes));
            }
            this.readedFile = this.readedFile.concat(new String(array, 0, numberOfReadedBytes));
        }
        catch (Exception ex) {
            GameManager.showErrorScreen("Exception reading: " + ex.getMessage());
        }
        if (this.readedFile.indexOf("\u010f\u00bb\u017c") == 0 || this.readedFile.indexOf(0xEFBBBF) == 0) {
            this.readedFile = this.readedFile.substring(3, this.readedFile.length());
        }
        if (this.readedFile.indexOf(65279) == 0) {
            this.readedFile = this.readedFile.substring(1, this.readedFile.length());
        }
    }

    public String readLine() throws EOFException, IOException {
        String line;
        if (this.isLastLine) {
            throw new EOFException();
        }
        this.currentLineEnd = this.readedFile.indexOf(13, this.currentLineStart);
        if (this.currentLineEnd == -1 && !this.isLastLine) {
            this.isLastLine = true;
            line = this.readedFile.substring(this.currentLineStart, this.readedFile.length());
        } else {
            line = this.readedFile.substring(this.currentLineStart, this.currentLineEnd);
        }
        this.currentLineStart = this.currentLineEnd;
        ++this.currentLineStart;
        if (this.readedFile.charAt(this.currentLineStart) == '\n') {
            ++this.currentLineStart;
        }
        return line;
    }

    public void close() throws IOException {
        this.isr.close();
    }
}

