/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gui.layout;

import com.ea.sdk.SDKAutoConstants;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.gui.BitmapFont;
import com.slg.j2me.lib.gui.Transition;
import com.slg.j2me.lib.gui.control.ControlHandler;
import com.slg.j2me.lib.gui.control.GuiContainer;
import com.slg.j2me.lib.gui.control.GuiControl;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import com.slg.j2me.lib.gui.layout.TextScrollLayout;
import java.util.Vector;

public abstract class ScreenStack
implements ControlHandler {
    public static ClipRect visibleRect = new ClipRect(0, 0, SDKAutoConstants.getScreenWidth(), SDKAutoConstants.getScreenHeight());
    public static int displayWidth = SDKAutoConstants.getScreenWidth();
    public static int displayHeight = SDKAutoConstants.getScreenHeight();
    public static int cPointerMenuBarY = displayHeight - 24;
    private static int cMaxRectStack = 5;
    private static ClipRect[] rectStack = new ClipRect[cMaxRectStack];
    private static int rectStackTop = 0;
    public static boolean pauseDialogShown = false;
    private static boolean isInProcessLoop = false;
    private static int resumeSoundAfterPause = 0;
    private static final int resumeSoundAfterPauseTime = 40;
    public static int fp_sx = 65536;
    public static int fp_sy = 65536;
    public static int frameNumber = 0;
    private static int liveInputState = 0;
    private static int liveQuickPressRelease = 0;
    public static int lastInputState = 0;
    public static int quickPressRelease = 0;
    public static int userInputState = 0;
    public static int numberKey = -1;
    public static ScreenStack instance;
    protected Vector screenStack;
    public static ScreenLayout currentContainer;
    public static ScreenLayout nextScreen;
    public SDKImage backgroundImage = null;
    public int colBackground = -1;
    public int menuButtons = 0;
    private int lastKeyCode = 0;
    public int menuButtonHeight = 16;
    public static TextScrollLayout confirmDialog;
    public static int confirmYesEvent;
    public static int confirmNoEvent;
    private boolean popPreviousScreenOnScreenOpen = false;
    public static BitmapFont font;
    public static BitmapFont fontSmall;
    public static ImageSequence gfxButtonIcons;
    public static final int eScreenOpening = 0;
    public static final int eScreenOpen = 1;
    public static final int eScreenForward = 2;
    public static final int eScreenBack = 3;
    public static int screenState;
    public static final int eventTransitionFinished = 1;
    public static final int eventWipeFinished = 2;
    private static Vector taskList;
    private static Vector eventList;
    public static GuiControl ctrlLeftSoftKey;
    public static GuiControl ctrlRightSoftKey;
    public static int wipeDirection;
    public static int lastWipeDirection;
    public static SDKImage imgWipeScreen;
    public static GuiControl wipeContainer;
    public static ClipRect wipeClip;
    public static int wipeOffsetX;
    public static int wipeOffsetY;
    public static boolean wipeInProgress;
    private String lastImage = "";
    private boolean confirmTransition = false;
    int buttonsChanged = 0;
    int controlsAdded = 3;
    static final int cHighButton = 1;
    static final int cWideButton = 4;
    private static ClipRect textClip;
    public static ScreenStack currentScreen;
    public static boolean takingScreenshot;

    public static void setResumeSoundAfterPause() {
        resumeSoundAfterPause = 40;
    }

    public ScreenStack() {
        displayWidth = SDKAutoConstants.getScreenWidth();
        displayHeight = SDKAutoConstants.getScreenHeight();
        for (int i = 0; i < rectStack.length; ++i) {
            ScreenStack.rectStack[i] = new ClipRect(0, 0, displayWidth, displayHeight);
        }
        instance = this;
        this.screenStack = new Vector();
        imgWipeScreen = SDKUtils.createImage(displayWidth, displayHeight);
    }

    public abstract void open();

    public abstract void onScreenOpen(ScreenLayout var1);

    public abstract void controlExecuted(ScreenLayout var1, GuiControl var2);

    public void setBackgroundColour(int n) {
        this.colBackground = n;
    }

    public void loadImage(String string) {
        if (this.backgroundImage != null && string.equals(this.lastImage)) {
            return;
        }
        this.lastImage = string;
        this.backgroundImage = ImageSet.loadImage(string);
    }

    public void open(ScreenLayout screenLayout) {
        this.screenStack.setSize(0);
        ScreenStack.clearTasks();
        ScreenStack.clearEvents();
        this.pushScreen(screenLayout, false);
        this.doScreenState(0);
    }

    public void popPreviousScreen() {
        if (this.screenStack.size() > 1) {
            this.screenStack.removeElementAt(this.screenStack.size() - 2);
        }
    }

    public void pushScreen(ScreenLayout screenLayout, boolean bl) {
        nextScreen = screenLayout;
        if (bl) {
            this.doScreenState(2);
        } else {
            this.doScreenState(1);
            this.pushScreenInternal();
        }
    }

    public void popScreen(boolean bl) {
        if (bl) {
            this.doScreenState(3);
        } else {
            this.doScreenState(1);
            this.popScreenInternal();
        }
    }

    private boolean popScreenInternal() {
        ScreenStack.resetKeys();
        if (currentContainer != null) {
            currentContainer.close();
            this.screenStack.removeElementAt(this.screenStack.size() - 1);
            if (this.screenStack.size() > 0) {
                currentContainer = (ScreenLayout)this.screenStack.elementAt(this.screenStack.size() - 1);
                this.onScreenOpen(currentContainer);
                currentContainer.open();
            } else {
                currentContainer = null;
            }
        }
        if (currentContainer == null) {
            this.open();
        }
        return currentContainer != null;
    }

    public ScreenLayout getPreviousScreen() {
        if (this.screenStack.size() > 1) {
            return (ScreenLayout)this.screenStack.elementAt(this.screenStack.size() - 2);
        }
        return null;
    }

    private void pushScreenInternal() {
        if (nextScreen == null) {
            return;
        }
        if (currentContainer != null) {
            currentContainer.close();
        }
        currentContainer = nextScreen;
        this.screenStack.addElement(nextScreen);
        if (ScreenStack.currentContainer.controlHandler == null) {
            ScreenStack.currentContainer.controlHandler = this;
        }
        this.menuButtons = 0;
        nextScreen = null;
        this.onScreenOpen(currentContainer);
        ScreenStack.resetKeys();
        currentContainer.open();
        if (this.popPreviousScreenOnScreenOpen) {
            this.popPreviousScreen();
            this.popPreviousScreenOnScreenOpen = false;
        }
    }

    public void openConfirmDialog(SDKString sDKString, int n, int n2, boolean bl) {
        confirmYesEvent = n;
        confirmNoEvent = n2;
        this.confirmTransition = !bl;
        confirmDialog = new TextScrollLayout();
        ScreenStack.confirmDialog.textLayout.iLayoutFlags = 3;
        ScreenStack.confirmDialog.clipRect.y0 = 0;
        ScreenStack.confirmDialog.clipRect.h = (short)(displayHeight - this.menuButtonHeight);
        ScreenStack.confirmDialog.textLayout.formatText(fontSmall, sDKString);
        confirmDialog.layout();
        this.pushScreen(confirmDialog, !bl);
    }

    public void handleEvent(int n) {
        block0 : switch (n) {
            case 1: {
                switch (screenState) {
                    case 0: {
                        this.doScreenState(1);
                        break block0;
                    }
                    case 2: {
                        if (wipeDirection != 0) {
                            lastWipeDirection = wipeDirection;
                            this.startWipe();
                            instance.pushScreenInternal();
                            break block0;
                        }
                        lastWipeDirection = 0;
                        instance.pushScreenInternal();
                        this.doScreenState(0);
                        break block0;
                    }
                    case 3: {
                        if (lastWipeDirection != 0) {
                            if ((lastWipeDirection & 1) != 0) {
                                wipeDirection = 2;
                            }
                            if ((lastWipeDirection & 4) != 0) {
                                wipeDirection = 8;
                            }
                            this.startWipe();
                            instance.popScreenInternal();
                            break block0;
                        }
                        instance.popScreenInternal();
                        this.doScreenState(0);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                wipeDirection = 0;
                wipeInProgress = false;
                this.doScreenState(0);
            }
        }
    }

    public void startWipe() {
        SDKGraphics sDKGraphics = imgWipeScreen.getGraphics();
        SDKUtils.setGraphics(sDKGraphics);
        this.paintInternal(sDKGraphics);
        ScreenStack.wipeContainer.clipRect.x0 = 0;
        ScreenStack.wipeContainer.clipRect.y0 = 0;
        ScreenStack.doTransition(wipeContainer, wipeDirection, 0, 500);
        ScreenStack.addEvent(2, 500);
        if ((wipeDirection & 0xC) != 0) {
            wipeOffsetX = 0;
            wipeOffsetY = (wipeDirection & 4) != 0 ? (int)ScreenStack.wipeClip.h : (int)(-ScreenStack.wipeClip.h);
        } else {
            wipeOffsetY = 0;
            wipeOffsetX = (wipeDirection & 1) != 0 ? (int)ScreenStack.wipeClip.w : (int)(-ScreenStack.wipeClip.w);
        }
        wipeInProgress = true;
    }

    public void drawButton(SDKGraphics sDKGraphics, int n, SDKString sDKString, int n2, int n3, int n4, int n5) {
        if (SDKAutoConstants.getReversedSoftkeys()) {
            n = 1 - n;
        }
        int n6 = n2 + (n3 - font.getFontHeight()) / 2;
        n6 = GameApp.min(n6, displayHeight - font.getFontHeight());
        int n7 = ScreenStack.getScaledX(12);
        ScreenStack.textClip.w = font.getTextWidth(sDKString);
        ScreenStack.textClip.h = font.getFontHeight();
        ScreenStack.textClip.y0 = (short)n6;
        if (n == 0) {
            int n8 = ScreenStack.textClip.w * n4 < 0 ? -(-(ScreenStack.textClip.w * n4) >> 16) : ScreenStack.textClip.w * n4 >> 16;
            ScreenStack.textClip.x0 = (short)n7;
            font.drawText(sDKGraphics, sDKString, n7 - n8, n6, textClip);
        } else {
            int n9 = ScreenStack.textClip.w * n4 < 0 ? -(-(ScreenStack.textClip.w * n4) >> 16) : ScreenStack.textClip.w * n4 >> 16;
            ScreenStack.textClip.x0 = (short)(displayWidth - ScreenStack.textClip.w - n7);
            font.drawText(sDKGraphics, sDKString, displayWidth - ScreenStack.textClip.w - n7 + n9, n6, textClip);
        }
    }

    public void paintInternal(SDKGraphics sDKGraphics) {
        if (currentContainer == null) {
            sDKGraphics.setColor(this.colBackground);
            sDKGraphics.fillRect(0, 0, displayWidth, displayHeight);
        }
        if (currentContainer != null) {
            currentContainer.paint(sDKGraphics);
        } else if (this.backgroundImage != null) {
            sDKGraphics.drawImage(this.backgroundImage, (displayWidth - this.backgroundImage.getWidth()) / 2, (displayHeight - this.backgroundImage.getHeight()) / 2, 0x10 | 4);
        }
    }

    private void dismissDialog(ScreenLayout screenLayout) {
        if (this.getPreviousScreen() == screenLayout) {
            this.popPreviousScreen();
        } else if (currentContainer == screenLayout && nextScreen == null) {
            this.popScreen(true);
        } else if (currentContainer == screenLayout && nextScreen != null) {
            this.popPreviousScreenOnScreenOpen = true;
        }
    }

    public void process() {
        if (!pauseDialogShown) {
            ScreenStack.processEvents();
            ScreenStack.processTasks();
            if (!wipeInProgress) {
                if (currentContainer == confirmDialog) {
                    if (screenState == 1) {
                        int n;
                        int n2 = n = confirmNoEvent == -1 ? 32784 : 32768;
                        if (ScreenStack.keysPressed(n)) {
                            TextScrollLayout textScrollLayout = confirmDialog;
                            this.handleEvent(confirmYesEvent);
                            this.dismissDialog(textScrollLayout);
                            return;
                        }
                        if (ScreenStack.keysPressed(65536) && confirmNoEvent != -1) {
                            TextScrollLayout textScrollLayout = confirmDialog;
                            this.handleEvent(confirmNoEvent);
                            this.dismissDialog(textScrollLayout);
                            return;
                        }
                    }
                } else {
                    if (screenState == 1) {
                        if ((this.menuButtons & 1) != 0 && ScreenStack.keysPressed(327680)) {
                            this.popScreen(true);
                            return;
                        }
                        if (ScreenStack.keysPressed(32768)) {
                            ScreenStack.currentContainer.controlHandler.controlExecuted(currentContainer, ctrlLeftSoftKey);
                        }
                        if (ScreenStack.keysPressed(65536)) {
                            ScreenStack.currentContainer.controlHandler.controlExecuted(currentContainer, ctrlRightSoftKey);
                        }
                    }
                    if (currentContainer != null) {
                        currentContainer.process();
                    }
                }
            }
        }
    }

    public static final void doTransition(GuiContainer guiContainer, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if ((n & 1) != 0) {
            n4 = -(guiContainer.clipRect.x0 + guiContainer.clipRect.w);
        }
        if ((n & 2) != 0) {
            n4 = displayWidth - guiContainer.clipRect.x0;
        }
        if ((n & 4) != 0) {
            n5 = -(guiContainer.clipRect.y0 + guiContainer.clipRect.h);
        }
        if ((n & 8) != 0) {
            n5 = displayHeight - guiContainer.clipRect.y0;
        }
        if ((n & 0x10) != 0) {
            guiContainer.clipRect.x0 = (short)(guiContainer.clipRect.x0 + n4);
            guiContainer.clipRect.y0 = (short)(guiContainer.clipRect.y0 + n5);
            n4 = -n4;
            n5 = -n5;
        }
        Transition transition = new Transition(n2, n3, guiContainer, 0, n4, n5);
        ScreenStack.startTask(transition);
    }

    public void doScreenState(int n) {
        if (n != screenState || n == 2) {
            int n2 = this.setScreenState(n);
            ScreenStack.addEvent(1, n2);
        }
    }

    protected int setScreenState(int n) {
        screenState = n;
        return 0;
    }

    public static final void startTask(Transition transition) {
        taskList.addElement(transition);
    }

    public static final void clearTasks() {
        taskList.removeAllElements();
    }

    public static final void finishTask(Transition transition) {
        taskList.removeElement(transition);
    }

    public static final void processTasks() {
        for (int i = 0; i < taskList.size(); ++i) {
            Transition transition = (Transition)taskList.elementAt(i);
            transition.process();
        }
    }

    public static final void processEvents() {
        for (int i = 0; i < eventList.size(); ++i) {
            int[] nArray = (int[])eventList.elementAt(i);
            nArray[1] = nArray[1] - GameApp.lastFrameTime;
            if (nArray[1] > 0) continue;
            instance.handleEvent(nArray[0]);
            eventList.removeElementAt(i);
            --i;
        }
    }

    public static final void addEvent(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        eventList.addElement(nArray);
    }

    public static final void clearEvents() {
        for (int i = 0; i < eventList.size(); ++i) {
            int[] nArray = (int[])eventList.elementAt(i);
            if (nArray[0] >= 2) continue;
            eventList.removeElementAt(i);
            --i;
        }
    }

    public static void setDefaultRes(int n, int n2) {
        fp_sx = GameApp.div(displayWidth < 0 ? -(-displayWidth << 16) : displayWidth << 16, n < 0 ? -(-n << 16) : n << 16);
        fp_sy = GameApp.div(displayHeight < 0 ? -(-displayHeight << 16) : displayHeight << 16, n2 < 0 ? -(-n2 << 16) : n2 << 16);
    }

    public static int getScaledX(int n) {
        int n2 = GameApp.mul(fp_sx, n < 0 ? -(-n << 16) : n << 16);
        return n2 < 0 ? -(-n2 >> 16) : n2 >> 16;
    }

    public static int getScaledY(int n) {
        int n2 = GameApp.mul(fp_sy, n < 0 ? -(-n << 16) : n << 16);
        return n2 < 0 ? -(-n2 >> 16) : n2 >> 16;
    }

    public static void pushVisibleRect(ClipRect clipRect) {
        ScreenStack.rectStack[ScreenStack.rectStackTop].x0 = ScreenStack.visibleRect.x0;
        ScreenStack.rectStack[ScreenStack.rectStackTop].y0 = ScreenStack.visibleRect.y0;
        ScreenStack.rectStack[ScreenStack.rectStackTop].w = ScreenStack.visibleRect.w;
        ScreenStack.rectStack[ScreenStack.rectStackTop].h = ScreenStack.visibleRect.h;
        int n = clipRect.x0 + clipRect.w;
        int n2 = clipRect.y0 + clipRect.h;
        int n3 = ScreenStack.visibleRect.x0 + ScreenStack.visibleRect.w;
        int n4 = ScreenStack.visibleRect.y0 + ScreenStack.visibleRect.h;
        ScreenStack.visibleRect.x0 = GameApp.max(clipRect.x0, ScreenStack.visibleRect.x0);
        ScreenStack.visibleRect.y0 = GameApp.max(clipRect.y0, ScreenStack.visibleRect.y0);
        ScreenStack.visibleRect.w = (short)(GameApp.min(n, n3) - ScreenStack.visibleRect.x0);
        ScreenStack.visibleRect.h = (short)(GameApp.min(n2, n4) - ScreenStack.visibleRect.y0);
        ++rectStackTop;
    }

    public static void popVisibleRect() {
        if (rectStackTop > 0) {
            ScreenStack.visibleRect.x0 = ScreenStack.rectStack[--ScreenStack.rectStackTop].x0;
            ScreenStack.visibleRect.y0 = ScreenStack.rectStack[ScreenStack.rectStackTop].y0;
            ScreenStack.visibleRect.w = ScreenStack.rectStack[ScreenStack.rectStackTop].w;
            ScreenStack.visibleRect.h = ScreenStack.rectStack[ScreenStack.rectStackTop].h;
        }
    }

    public static void clearVisibleRect() {
        while (rectStackTop > 0) {
            ScreenStack.popVisibleRect();
        }
    }

    public static void setCurrent(ScreenStack screenStack) {
        currentScreen = screenStack;
    }

    public static void forcePaint() {
        if (SDKCanvas.getInstance() != null) {
            SDKCanvas.getInstance().repaint();
            SDKCanvas.getInstance().serviceRepaints();
        }
    }

    public static void paintCurrent(SDKGraphics sDKGraphics) {
        if (currentScreen != null) {
            currentScreen.paint(sDKGraphics);
        }
    }

    public void paint(SDKGraphics sDKGraphics) {
        if (takingScreenshot) {
            return;
        }
        ScreenStack.clearVisibleRect();
        if (!GameApp.isLoading) {
            try {
                this.paintInternal(sDKGraphics);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (GameApp.isLoading) {
            this.drawLoadingDialog(sDKGraphics);
            GameApp.lastDrawnScreenWasLoading = true;
        } else {
            GameApp.lastDrawnScreenWasLoading = false;
        }
        if (pauseDialogShown) {
            this.drawDarkscreen(sDKGraphics);
            this.drawPauseDialog(sDKGraphics);
        }
        ++frameNumber;
    }

    public void drawDarkscreen(SDKGraphics sDKGraphics) {
        this.drawCrossHatch(sDKGraphics, 0, 0, 0, displayWidth, displayHeight);
    }

    public void drawPauseDialog(SDKGraphics sDKGraphics) {
        if (ImageSequence.clipSet) {
            sDKGraphics.setClip(0, 0, displayWidth * 2, displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        if (font != null) {
            SDKString sDKString = SDKUtils.getString(194, null);
            SDKString sDKString2 = SDKUtils.getString(4, null);
            short s = font.getTextWidth(sDKString);
            short s2 = font.getTextWidth(sDKString2);
            int n = GameApp.max((int)s, (int)s2) + 16;
            n = GameApp.min(n, displayWidth);
            int n2 = font.getFontHeight() * 2;
            int n3 = (displayWidth - n) / 2;
            int n4 = displayHeight / 2 - font.getFontHeight();
            sDKGraphics.setColor(13004800);
            sDKGraphics.fillRect(n3, n4 - 4, n, n2 + 8);
            sDKGraphics.setColor(0xFF0000);
            sDKGraphics.drawRect(n3, n4 - 4, n - 2, n2 + 8);
            sDKGraphics.drawRect(n3 - 1, n4 - 5, n, n2 + 10);
            fontSmall.drawText(sDKGraphics, sDKString, (displayWidth - s) / 2, n4, visibleRect);
            fontSmall.drawText(sDKGraphics, sDKString2, (displayWidth - s2) / 2, displayHeight / 2, visibleRect);
        }
    }

    private void drawCrossHatch(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        sDKGraphics.setClip(n2, n3, n4, n5);
        ImageSequence.clipSet = true;
        sDKGraphics.setColor(n);
        for (n6 = 0; n6 < n4; n6 += 2) {
            sDKGraphics.drawLine(n2 + n6, n3, n2 + n6 + n4, n3 + n4);
        }
        for (n6 = 0; n6 < n5; n6 += 2) {
            sDKGraphics.drawLine(n2, n3 + n6, n2 + n5, n3 + n6 + n5);
        }
    }

    public static void beginInputProcessing() {
        userInputState = liveInputState;
        quickPressRelease = liveQuickPressRelease;
        isInProcessLoop = true;
    }

    public static void endInputProcessing() {
        isInProcessLoop = false;
        liveQuickPressRelease &= ~quickPressRelease;
        lastInputState = userInputState;
        if (resumeSoundAfterPause > 0 && --resumeSoundAfterPause == 0) {
            GameApp.instance.resumeSound();
        }
    }

    public static boolean keysDown(int n) {
        return ((userInputState | quickPressRelease) & n) != 0;
    }

    public static boolean keysPressed(int n) {
        return ((userInputState ^ lastInputState) & userInputState & n) != 0 || (quickPressRelease & n) != 0;
    }

    public static boolean keysReleased(int n) {
        return ((userInputState ^ lastInputState) & lastInputState & n) != 0 || (quickPressRelease & n) != 0;
    }

    protected final void keyPressed(int n) {
        if (!GameApp.loaded) {
            return;
        }
        GameApp.applicationPaused = false;
        if (pauseDialogShown) {
            ScreenStack.closePauseDialog();
            return;
        }
        numberKey = -1;
        if (n >= 128 && n <= 65536) {
            numberKey = n - 128;
            liveInputState |= 0x20000;
        }
        try {
            switch (n) {
                case 4: {
                    liveInputState |= 2;
                    break;
                }
                case 8: {
                    liveInputState |= 4;
                    break;
                }
                case 2: {
                    liveInputState |= 8;
                    break;
                }
                case 1: {
                    liveInputState |= 1;
                    break;
                }
                case 16: {
                    liveInputState |= 0x10;
                    break;
                }
                case 256: {
                    liveInputState |= 0x20;
                    break;
                }
                case 512: {
                    liveInputState |= 1;
                    break;
                }
                case 1024: {
                    liveInputState |= 0x40;
                    break;
                }
                case 2048: {
                    liveInputState |= 2;
                    break;
                }
                case 4096: {
                    liveInputState |= 0x10;
                    break;
                }
                case 8192: {
                    liveInputState |= 4;
                    break;
                }
                case 16384: {
                    liveInputState |= 0x80;
                    break;
                }
                case 32768: {
                    liveInputState |= 8;
                    break;
                }
                case 65536: {
                    liveInputState |= 0x100;
                    break;
                }
                case 128: {
                    liveInputState |= 0x1000;
                    break;
                }
                case 262144: {
                    liveInputState |= 0x2000;
                    break;
                }
                case 131072: {
                    liveInputState |= 0x4000;
                    break;
                }
                case 524288: {
                    liveInputState |= 0x40000;
                    break;
                }
                case 32: {
                    if (SDKAutoConstants.getReversedSoftkeys()) {
                        liveInputState |= 0x10000;
                        break;
                    }
                    liveInputState |= 0x8000;
                    break;
                }
                case 64: {
                    if (SDKAutoConstants.getReversedSoftkeys()) {
                        liveInputState |= 0x8000;
                        break;
                    }
                    liveInputState |= 0x10000;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void keyReleased(int n) {
        if (!GameApp.loaded) {
            return;
        }
        int n2 = liveInputState;
        if (n >= 128 && n <= 65536) {
            liveInputState &= 0xFFFDFFFF;
        }
        try {
            switch (n) {
                case 4: {
                    liveInputState &= 0xFFFFFFFD;
                    break;
                }
                case 8: {
                    liveInputState &= 0xFFFFFFFB;
                    break;
                }
                case 2: {
                    liveInputState &= 0xFFFFFFF7;
                    break;
                }
                case 1: {
                    liveInputState &= 0xFFFFFFFE;
                    break;
                }
                case 16: {
                    liveInputState &= 0xFFFFFFEF;
                    break;
                }
                case 256: {
                    liveInputState &= 0xFFFFFFDF;
                    break;
                }
                case 512: {
                    liveInputState &= 0xFFFFFFFE;
                    break;
                }
                case 1024: {
                    liveInputState &= 0xFFFFFFBF;
                    break;
                }
                case 2048: {
                    liveInputState &= 0xFFFFFFFD;
                    break;
                }
                case 4096: {
                    liveInputState &= 0xFFFFFFEF;
                    break;
                }
                case 8192: {
                    liveInputState &= 0xFFFFFFFB;
                    break;
                }
                case 16384: {
                    liveInputState &= 0xFFFFFF7F;
                    break;
                }
                case 32768: {
                    liveInputState &= 0xFFFFFFF7;
                    break;
                }
                case 65536: {
                    liveInputState &= 0xFFFFFEFF;
                    break;
                }
                case 128: {
                    liveInputState &= 0xFFFFEFFF;
                    break;
                }
                case 262144: {
                    liveInputState &= 0xFFFFDFFF;
                    break;
                }
                case 131072: {
                    liveInputState &= 0xFFFFBFFF;
                    break;
                }
                case 524288: {
                    liveInputState &= 0xFFFBFFFF;
                    break;
                }
                case 32: {
                    if (SDKAutoConstants.getReversedSoftkeys()) {
                        liveInputState &= 0xFFFEFFFF;
                        break;
                    }
                    liveInputState &= 0xFFFF7FFF;
                    break;
                }
                case 64: {
                    if (SDKAutoConstants.getReversedSoftkeys()) {
                        liveInputState &= 0xFFFF7FFF;
                        break;
                    }
                    liveInputState &= 0xFFFEFFFF;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = n2 ^ liveInputState;
        if (n3 != 0 && (n3 & userInputState) == 0) {
            liveQuickPressRelease |= n3;
        }
    }

    public static void resetKeys() {
        liveInputState = 0;
        liveQuickPressRelease = 0;
        userInputState = 0;
        numberKey = -1;
        lastInputState = 0;
        quickPressRelease = 0;
    }

    public void drawLoadingDialog(SDKGraphics sDKGraphics) {
        if (ImageSequence.clipSet) {
            sDKGraphics.setClip(0, 0, displayWidth * 2, displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        if (font != null) {
            SDKString sDKString = SDKUtils.getString(3, null);
            short s = fontSmall.getTextWidth(sDKString);
            int n = fontSmall.getFontHeight() * 2;
            int n2 = (displayWidth - s) / 2;
            int n3 = displayHeight - n;
            sDKGraphics.setColor(0);
            sDKGraphics.fillRect(0, n3 - 4, displayWidth, n + 8);
            sDKGraphics.setColor(0xFFFFFF);
            sDKGraphics.fillRect(0, n3 - 4, displayWidth, 2);
            fontSmall.drawText(sDKGraphics, sDKString, (displayWidth - s) / 2, n3 + (n - fontSmall.getFontHeight()) / 2, visibleRect);
        }
    }

    public static void onKeyPressed(int n) {
        if (currentScreen != null) {
            currentScreen.keyPressed(n);
        }
    }

    public static void onKeyReleased(int n) {
        if (currentScreen != null) {
            currentScreen.keyReleased(n);
        }
    }

    public static void openPauseDialog() {
        pauseDialogShown = true;
    }

    public static void closePauseDialog() {
        pauseDialogShown = false;
        ScreenStack.setResumeSoundAfterPause();
    }

    static {
        confirmDialog = new TextScrollLayout();
        confirmYesEvent = 1;
        confirmNoEvent = 2;
        screenState = 0;
        taskList = new Vector();
        eventList = new Vector();
        ctrlLeftSoftKey = new GuiControl(true);
        ctrlRightSoftKey = new GuiControl(true);
        wipeDirection = 0;
        lastWipeDirection = 0;
        imgWipeScreen = null;
        wipeContainer = new GuiControl(false);
        wipeClip = new ClipRect(0, 0, displayWidth, displayHeight);
        wipeOffsetX = 0;
        wipeOffsetY = 0;
        wipeInProgress = false;
        textClip = new ClipRect(0, 0, 0, 0);
        currentScreen = null;
        takingScreenshot = false;
    }
}

