/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gui.layout;

import com.ea.sdk.SDKGraphics;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gui.control.GuiContainer;
import com.slg.j2me.lib.gui.layout.ScreenLayout;

public class CellLayout
extends ScreenLayout {
    public GuiContainer[][] cellContainers;
    public int[][] cellProportions;
    public int[][] cellLayout;
    public int[] rowProportions;
    public int cellRows;
    ClipRect oldRect;
    ClipRect newRect = new ClipRect(0, 0, 0, 0);

    public CellLayout(int n, String string) {
        super(string);
        this.init(n);
    }

    public CellLayout(int n) {
        this.init(n);
    }

    private void init(int n) {
        this.cellRows = n;
        this.cellContainers = new GuiContainer[n][];
        this.cellProportions = new int[n][];
        this.cellLayout = new int[n][];
        this.rowProportions = new int[n];
    }

    public void setRow(int n, int n2, int n3) {
        this.rowProportions[n] = n3;
        this.cellProportions[n] = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.cellProportions[n][i] = 1;
        }
        this.cellLayout[n] = new int[n2];
        this.cellContainers[n] = new GuiContainer[n2];
    }

    public void setRowFlags(int n, int n2, int n3) {
        this.rowProportions[n] = n2;
    }

    public void setCell(int n, int n2, GuiContainer guiContainer, int n3, int n4) {
        this.cellProportions[n][n2] = n3;
        this.cellLayout[n][n2] = n4;
        this.cellContainers[n][n2] = guiContainer;
    }

    public void setCellFlags(int n, int n2, int n3, int n4) {
        this.cellProportions[n][n2] = n3;
        this.cellLayout[n][n2] = n4;
    }

    public void open() {
        this.layout();
    }

    public void close() {
        for (int i = 0; i < this.cellRows; ++i) {
            if (this.cellContainers[i] == null) continue;
            for (int j = 0; j < this.cellContainers[i].length; ++j) {
                GuiContainer guiContainer = this.cellContainers[i][j];
                if (!(guiContainer instanceof ScreenLayout)) continue;
                ScreenLayout screenLayout = (ScreenLayout)guiContainer;
                screenLayout.close();
            }
        }
    }

    public void layout() {
        try {
            int n;
            int n2;
            int n3;
            int n4 = 0;
            for (int i = 0; i < this.cellRows; ++i) {
                if (this.rowProportions[i] < 0) continue;
                n4 += this.rowProportions[i];
            }
            int[] nArray = new int[this.cellRows];
            int[] nArray2 = new int[this.cellRows];
            int n5 = 0;
            int n6 = 0;
            int n7 = this.clipRect.h;
            for (n3 = 0; n3 < this.cellRows; ++n3) {
                n2 = 0;
                if (this.cellContainers[n3] != null) {
                    for (n = 0; n < this.cellContainers[n3].length; ++n) {
                        if (this.cellContainers[n3][n] == null) continue;
                        try {
                            this.cellContainers[n3][n].initialise();
                            n2 = GameApp.max(n2, (int)this.cellContainers[n3][n].clipRect.h);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.rowProportions[n3] >= 0) continue;
                n6 += n2;
            }
            if ((n7 -= n6) == 0 || n4 == 0) {
                n7 = 0;
                this.clipRect.h = (short)n6;
                n4 = 1;
            }
            n6 = 0;
            for (n3 = 0; n3 < this.cellRows; ++n3) {
                nArray[n3] = n6 + n5 * n7 / n4;
                if (this.rowProportions[n3] >= 0) {
                    n5 += this.rowProportions[n3];
                } else {
                    n2 = 0;
                    if (this.cellContainers[n3] != null) {
                        for (n = 0; n < this.cellContainers[n3].length; ++n) {
                            if (this.cellContainers[n3][n] == null) continue;
                            n2 = GameApp.max(n2, (int)this.cellContainers[n3][n].clipRect.h);
                        }
                    }
                    n6 += n2;
                }
                nArray2[n3] = n6 + n5 * n7 / n4 - nArray[n3];
            }
            n3 = 0;
            for (n2 = 0; n2 < this.cellRows; ++n2) {
                int n8;
                if (this.cellProportions[n2] == null) continue;
                n4 = 0;
                n6 = 0;
                n5 = 0;
                n7 = this.clipRect.w;
                for (n8 = 0; n8 < this.cellProportions[n2].length; ++n8) {
                    if (this.cellProportions[n2][n8] >= 0) {
                        n4 += this.cellProportions[n2][n8];
                        continue;
                    }
                    n6 += this.cellContainers[n2][n8].clipRect.w;
                }
                if ((n7 -= n6) == 0 || n4 == 0) {
                    n7 = 0;
                    n3 = GameApp.max(n3, n6);
                    n4 = 1;
                } else {
                    n3 = this.clipRect.w;
                }
                try {
                    n6 = 0;
                    for (n8 = 0; n8 < this.cellProportions[n2].length; ++n8) {
                        GuiContainer guiContainer = this.cellContainers[n2][n8];
                        if (guiContainer != null) {
                            int n9 = n5 * n7 / n4 + n6;
                            int n10 = nArray[n2];
                            if (this.cellProportions[n2][n8] >= 0) {
                                n5 += this.cellProportions[n2][n8];
                            } else {
                                n6 += guiContainer.clipRect.w;
                            }
                            int n11 = n5 * n7 / n4 + n6 - n9;
                            int n12 = nArray2[n2];
                            if ((this.cellLayout[n2][n8] & 2) != 0) {
                                guiContainer.clipRect.y0 = n12 - guiContainer.clipRect.h > 0 ? (short)(n10 + (n12 - guiContainer.clipRect.h) / 2) : (short)n10;
                            } else {
                                guiContainer.clipRect.y0 = (short)n10;
                                guiContainer.clipRect.h = (short)n12;
                            }
                            if ((this.cellLayout[n2][n8] & 1) != 0) {
                                guiContainer.clipRect.x0 = n11 - guiContainer.clipRect.w > 0 ? (short)(n9 + (n11 - guiContainer.clipRect.w) / 2) : (short)n9;
                            } else {
                                guiContainer.clipRect.x0 = (short)n9;
                                guiContainer.clipRect.w = (short)n11;
                            }
                            if (!(guiContainer instanceof ScreenLayout)) continue;
                            ScreenLayout screenLayout = (ScreenLayout)guiContainer;
                            screenLayout.layout();
                            continue;
                        }
                        n5 += this.cellProportions[n2][n8];
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n3 != 0) {
                this.clipRect.w = (short)n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(SDKGraphics sDKGraphics) {
        for (int i = 0; i < this.cellRows; ++i) {
            if (this.cellContainers[i] == null || this.rowProportions[i] == 0) continue;
            for (int j = 0; j < this.cellContainers[i].length; ++j) {
                GuiContainer guiContainer = this.cellContainers[i][j];
                try {
                    if (guiContainer == null) continue;
                    this.oldRect = guiContainer.clipRect;
                    this.newRect.x0 = (short)(this.clipRect.x0 + guiContainer.clipRect.x0);
                    this.newRect.y0 = (short)(this.clipRect.y0 + guiContainer.clipRect.y0);
                    this.newRect.w = (short)(GameApp.min(this.newRect.x0 + guiContainer.clipRect.w, this.clipRect.x0 + this.clipRect.w) - this.newRect.x0);
                    this.newRect.h = (short)(GameApp.min(this.newRect.y0 + guiContainer.clipRect.h, this.clipRect.y0 + this.clipRect.h) - this.newRect.y0);
                    if (this.newRect.w > 0 && this.newRect.h > 0) {
                        guiContainer.clipRect = this.newRect;
                        guiContainer.paint(sDKGraphics);
                    }
                    guiContainer.clipRect = this.oldRect;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void process() {
        for (int i = 0; i < this.cellRows; ++i) {
            if (this.cellContainers[i] == null) continue;
            for (int j = 0; j < this.cellContainers[i].length; ++j) {
                GuiContainer guiContainer = this.cellContainers[i][j];
                if (guiContainer == null || !(guiContainer instanceof ScreenLayout)) continue;
                ScreenLayout screenLayout = (ScreenLayout)guiContainer;
                screenLayout.process();
            }
        }
    }
}

