/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gfx;

import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKUtils;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gfx.ImageSequence;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ImageSet {
    private Hashtable hashImageSeqCache = new Hashtable();
    private static SDKImage imagesetimage = null;
    private static String imagesetname;
    private static Vector vecImagesets;
    private String[] source_is_anim = null;
    public static String sCharacters;
    public static final byte cFlagIsAFont = 1;
    public static final byte cFlagContainsOffsets = 2;
    public static final byte cFlagContainsSlicedImages = 4;
    public static final byte cRecordFlagXCropped = 1;
    public static final byte cRecordFlagYCropped = 2;
    public static final byte cRecordFlagSliceIndex = 4;
    public byte flags;
    public static int totalVideoMemoryUsed;

    public ImageSet(String string, boolean bl) {
        sCharacters = "";
        InputStream inputStream = this.getClass().getResourceAsStream(string + ".idx");
        try {
            this.loadImageSetBinary(string, inputStream, bl);
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        vecImagesets.addElement(this);
        GameApp.gc();
    }

    private void loadImageSetBinary(String string, InputStream inputStream, boolean bl) {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        GameApp.printMemoryStatus("ImageSet.loadImageSetBinary() Start");
        int n = string.indexOf(".");
        String string2 = string.substring(1, n);
        try {
            int n2;
            int n3;
            short s;
            int n4;
            ImageSequence imageSequence;
            String string3;
            int n5;
            short s2 = dataInputStream.readShort();
            this.flags = dataInputStream.readByte();
            short s3 = dataInputStream.readShort();
            int n6 = dataInputStream.readShort();
            int n7 = 0;
            while (n7 < n6) {
                n5 = dataInputStream.readShort();
                string3 = dataInputStream.readUTF();
                imageSequence = (ImageSequence)this.hashImageSeqCache.get(string3);
                imageSequence = new ImageSequence();
                this.hashImageSeqCache.put(string3, imageSequence);
                imageSequence.setup(this.flags, n5, s3);
                for (n4 = 0; n4 < n5; ++n4) {
                    short s4;
                    int n8;
                    s = dataInputStream.readByte();
                    n3 = -1;
                    n2 = s >> 4;
                    String string4 = n2 > 9 ? string2 + "_" + n2 + ".png" : string2 + "_0" + n2 + ".png";
                    imageSequence.addImageIfNew(string4);
                    if (imageSequence.imageIndex != null) {
                        imageSequence.imageIndex[n4] = (byte)imageSequence.getImageIndex(string4);
                    }
                    short s5 = 0;
                    short s6 = 0;
                    short s7 = 0;
                    short s8 = 0;
                    if ((s & 4) != 0) {
                        s7 = dataInputStream.readByte();
                        s8 = dataInputStream.readByte();
                        for (n8 = 0; n8 < 3; ++n8) {
                            s4 = dataInputStream.readShort();
                        }
                    } else {
                        s5 = dataInputStream.readShort();
                        s6 = dataInputStream.readShort();
                        s7 = dataInputStream.readShort();
                        s8 = dataInputStream.readShort();
                    }
                    n8 = 0;
                    s4 = 0;
                    short s9 = 0;
                    short s10 = 0;
                    if ((s & 1) != 0) {
                        n8 = dataInputStream.readShort();
                        s9 = dataInputStream.readShort();
                    }
                    if ((s & 2) != 0) {
                        s4 = dataInputStream.readShort();
                        s10 = dataInputStream.readShort();
                    }
                    if ((this.flags & 1) != 0) {
                        n3 = dataInputStream.readShort();
                    }
                    imageSequence.setRect(n4, s5, s6, s7, s8, n8, s4, s9, s10);
                    if (bl) {
                        ImageSet.loadImage(imageSequence, n4);
                    }
                    if ((this.flags & 1) != 0) {
                        sCharacters = sCharacters + (char)n3;
                    }
                    ++n7;
                }
            }
            if ((this.flags & 4) != 0) {
                n6 = dataInputStream.readShort();
                n7 = 0;
                while (n7 < n6) {
                    n5 = dataInputStream.readShort();
                    string3 = dataInputStream.readUTF();
                    imageSequence = (ImageSequence)this.hashImageSeqCache.get(string3);
                    imageSequence = new ImageSequence();
                    this.hashImageSeqCache.put(string3, imageSequence);
                    imageSequence.setup((byte)0, n5, 1);
                    for (n4 = 0; n4 < n5; ++n4) {
                        s = dataInputStream.readShort();
                        n3 = dataInputStream.readShort();
                        n2 = dataInputStream.readShort();
                        short s11 = dataInputStream.readShort();
                        imageSequence.setRect(n4, s, n3, n2, s11, 0, 0, 0, 0);
                        ++n7;
                    }
                }
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        GameApp.printMemoryStatus("ImageSet.loadImageSetBinary() End");
    }

    public void destruct() {
        vecImagesets.removeElement(this);
    }

    public int getNumFrames(String string) {
        ImageSequence imageSequence = (ImageSequence)this.hashImageSeqCache.get(string);
        if (imageSequence == null) {
            return -1;
        }
        return imageSequence.numFrames;
    }

    public static SDKImage loadImage(String string) {
        SDKImage sDKImage = ImageSet.findImageGlobal(string);
        if (sDKImage != null) {
            return sDKImage;
        }
        GameApp.gc();
        GameApp.printMemoryStatus("ImageSet.loadImage() pre CreateImage");
        try {
            sDKImage = SDKUtils.createImage(string);
            GameApp.printMemoryStatus("ImageSet.loadImage() post CreateImage");
            return sDKImage;
        }
        catch (Exception exception) {
            System.out.println("** Failed loading PNG " + string + " **");
            return null;
        }
    }

    public ImageSequence getImageSequence(String string) {
        return (ImageSequence)this.hashImageSeqCache.get(string);
    }

    public static SDKImage makeImage(String string, ClipRect clipRect) {
        SDKImage sDKImage = ImageSet.getImageSet(string);
        if (sDKImage != null) {
            SDKImage sDKImage2 = SDKUtils.createImage(clipRect.w, clipRect.h);
            sDKImage2.getGraphics().drawImage(sDKImage, -clipRect.x0, -clipRect.y0, 20);
            return sDKImage2;
        }
        return null;
    }

    private String getSequenceName(String string) {
        String string2 = null;
        try {
            int n = string.indexOf(47);
            int n2 = string.indexOf(95, n);
            string2 = new String(string.substring(n + 1, n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private String getImageSetName(String string) {
        int n = 0;
        int n2 = string.indexOf(47, n);
        return new String(string.substring(n, n2));
    }

    public static SDKImage getImageSet(String string) {
        if (imagesetimage == null || imagesetname.compareTo(string) != 0) {
            imagesetimage = null;
            imagesetimage = ImageSet.loadImage("/" + string);
            imagesetname = string;
        }
        return imagesetimage;
    }

    public static void loadImage(ImageSequence imageSequence, int n) {
        byte by;
        byte by2 = by = imageSequence.imageIndex != null ? imageSequence.imageIndex[n] : (byte)0;
        if (imageSequence.imageFrame[by] == null) {
            String string = (String)imageSequence.vecImageFilenames.elementAt(by);
            imageSequence.imageFrame[by] = ImageSet.getImageSet(string);
        }
    }

    public void unloadImages() {
        Enumeration enumeration = this.hashImageSeqCache.elements();
        while (enumeration.hasMoreElements()) {
            ImageSequence imageSequence = (ImageSequence)enumeration.nextElement();
            imageSequence.unload();
        }
    }

    public void reloadImages() {
        Enumeration enumeration = this.hashImageSeqCache.elements();
        while (enumeration.hasMoreElements()) {
            ImageSequence imageSequence = (ImageSequence)enumeration.nextElement();
            imageSequence.reload();
        }
    }

    public static SDKImage findImageGlobal(String string) {
        for (int i = 0; i < vecImagesets.size(); ++i) {
            SDKImage sDKImage = ((ImageSet)vecImagesets.elementAt(i)).findImage(string);
            if (sDKImage == null) continue;
            return sDKImage;
        }
        return null;
    }

    public SDKImage findImage(String string) {
        Enumeration enumeration = this.hashImageSeqCache.elements();
        while (enumeration.hasMoreElements()) {
            ImageSequence imageSequence = (ImageSequence)enumeration.nextElement();
            for (int i = 0; i < imageSequence.vecImageFilenames.size(); ++i) {
                String string2 = (String)imageSequence.vecImageFilenames.elementAt(i);
                if (imageSequence.imageFrame[i] == null || !string.equals("/" + string2)) continue;
                return imageSequence.imageFrame[i];
            }
        }
        return null;
    }

    public void printResidentImages() {
        Object object;
        Enumeration enumeration = this.hashImageSeqCache.elements();
        Hashtable hashtable = new Hashtable();
        while (enumeration.hasMoreElements()) {
            object = (ImageSequence)enumeration.nextElement();
            for (int i = 0; i < ((ImageSequence)object).vecImageFilenames.size(); ++i) {
                if (((ImageSequence)object).imageFrame[i] == null) continue;
                hashtable.put(((ImageSequence)object).imageFrame[i], ((ImageSequence)object).vecImageFilenames.elementAt(i));
            }
        }
        enumeration = hashtable.elements();
        object = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            SDKImage sDKImage = (SDKImage)object.nextElement();
            int n = 4 * sDKImage.getWidth() * sDKImage.getHeight();
            totalVideoMemoryUsed += n;
            int n2 = n / 1024;
        }
    }

    public static void printResidentImagesGlobal() {
        int n;
        System.out.println("\n-----------------------------------------------------------\n\nprintResidentImagesGlobal():");
        totalVideoMemoryUsed = 0;
        for (n = 0; n < vecImagesets.size(); ++n) {
            ImageSet imageSet = (ImageSet)vecImagesets.elementAt(n);
            imageSet.printResidentImages();
        }
        n = totalVideoMemoryUsed / 1024;
        System.out.println("Total Video Memory Used: " + n + "kb");
        System.out.println("\n-----------------------------------------------------------\n\n");
    }

    static {
        vecImagesets = new Vector();
        totalVideoMemoryUsed = 0;
    }
}

