/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import com.slg.j2me.game.Boxer;
import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.game.GameLogic;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.gui.BitmapFont;
import com.slg.j2me.lib.gui.control.ControlHandler;
import com.slg.j2me.lib.gui.control.GuiContainer;
import com.slg.j2me.lib.gui.control.GuiControl;
import com.slg.j2me.lib.gui.image.TextImage;
import com.slg.j2me.lib.gui.layout.CellLayout;
import com.slg.j2me.lib.gui.layout.MenuLayout;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import com.slg.j2me.lib.gui.layout.TextLayout;

public class GameScreen
extends ScreenLayout
implements ControlHandler {
    private static SDKString strNewLine = new SDKString("\n");
    private static SDKString strEmpty = new SDKString("");
    private static SDKString strColonSpace = new SDKString(": ");
    public static GameLogic game = null;
    public static Boxer[] boxer = new Boxer[]{null, null};
    public static final int numBoxers = 2;
    public static boolean isPaused = false;
    public static int usePhotoForPlayer = -1;
    public static boolean godMode = false;
    public static int m_x = 0;
    public static int m_y = 0;
    private static final int mapCount = 1;
    private int levelLoaded = -1;
    private short[] mapData = new short[]{1, 2, 2, 2, 2, 3, 4, 4, 4, 4};
    private int[] mapXScale;
    private int[] mapYScale;
    public int[] mapWidth;
    public int[] mapHeight;
    private int[] totalLayerWidth;
    private int[] totalLayerHeight;
    public int tileWidth;
    public int tileHeight;
    private int tileSetWidth;
    private int tileSetHeight;
    private String strTileSet;
    private SDKImage imgTiles;
    private int realTileWidth = 0;
    private int realTileHeight = 0;
    public static int fp_tileScale = 65536;
    public SDKString strTime = null;
    public SDKString strRound = null;
    public int timeWidth;
    public int roundWidth;
    public TextLayout textInfo = new TextLayout();
    public TextLayout characterSpeechText1 = new TextLayout();
    public TextLayout characterSpeechText2 = new TextLayout();
    public CellLayout characterSpeechTextCL = new CellLayout(1);
    private int backupX;
    private int backupY;
    private int backupP1X;
    private int backupP1Y;
    private int backupP2X;
    private int backupP2Y;
    int effect_frame = 0;
    int readyTimer = 0;
    private static final int cRealTimeScaleFactor = GameApp.stringToFP("0.9");
    public static BitmapFont fontGame;
    public static ImageSet isFontGame;
    public static ImageSequence gfxFaceBreakerBar;
    private int displayWidth = ScreenStack.displayWidth;
    private int displayHeight = ScreenStack.displayHeight;
    public static int startingDistBetweenPlayers;
    public SDKImage imgShadow = null;
    public int boxer_infront = 0;
    MenuLayout menuPause = new MenuLayout();
    MenuLayout menuPractice = new MenuLayout();
    MenuLayout menuPracticeAI = new MenuLayout();
    GuiControl ctrlPracticeTitle = new GuiControl(false);
    GuiControl ctrlPracticeAITitle = new GuiControl(false);
    GuiControl ctrlPracticeAI = new GuiControl(this.menuPracticeAI);
    GuiControl ctrlChangeCharacter = new GuiControl(true);
    GuiControl ctrlPauseTitle = new GuiControl(false);
    GuiControl ctrlWin = new GuiControl(true);
    GuiControl ctrlGod = new GuiControl(true);
    GuiControl ctrlExit = new GuiControl(true);
    GuiControl[] ctrlAILevel = new GuiControl[3];
    GuiControl[] ctrlPracticeAIMode = new GuiControl[4];
    GuiControl ctrlOptions = new GuiControl(true);
    GuiControl ctrlHelp = new GuiControl(true);
    MenuLayout menuOptions = new MenuLayout();
    GuiControl ctrlOptionsTitle = new GuiControl(false);
    GuiControl ctrlVibrate = new GuiControl(true);
    MenuLayout menuCurrent = null;
    private boolean isFrench = false;
    public static final int cBoxerLevelBorder = 20;
    public static final int cIntroTextDuration = 500;
    public static final int cOutroTextDuration = 500;
    public static final int cFightTextDuration = 250;
    private byte triggerScreenFlash = (byte)-1;
    private static final int cEnergyBarOffsetX;
    private static final int cEnergyBarOffsetY;
    private static final int cRoundsWonOffsetX;
    private static final int cRoundsWonOffsetY;
    private static final int cFaceBreakerBarOffsetX;
    private static final int cFaceBreakerBarOffsetY;

    public GameScreen(GameLogic gameLogic) {
        game = gameLogic;
        fontGame = FrontEnd.fontLargeRed;
        GameScreen.boxer[0] = new Boxer(game, 0);
        GameScreen.boxer[1] = new Boxer(game, 1);
        this.loadLevel(0);
        this.loadTileset();
        FrontEnd.instance.fpBoxerAnimationScaling = fp_tileScale;
        this.unloadTileset();
        this.textInfo.iLayoutFlags = 3;
        this.textInfo.open();
        this.characterSpeechText1.iLayoutFlags = 385;
        this.characterSpeechText2.iLayoutFlags = 257;
        this.characterSpeechTextCL.setRow(0, 2, -1);
        this.characterSpeechTextCL.setCell(0, 0, this.characterSpeechText1, -1, 3);
        this.characterSpeechTextCL.setCell(0, 1, this.characterSpeechText2, 1, 2);
        this.characterSpeechTextCL.layout();
        this.characterSpeechTextCL.clipRect.y0 = 0;
        this.characterSpeechTextCL.clipRect.x0 = 0;
        this.characterSpeechTextCL.clipRect.w = (short)ScreenStack.displayWidth;
        this.characterSpeechTextCL.open();
        SDKString sDKString = SDKUtils.getString(3, null);
        this.strTime = new SDKString(16, sDKString.getEncoding());
        this.strRound = new SDKString(16, sDKString.getEncoding());
        this.setupPauseMenu();
        gfxFaceBreakerBar = FrontEnd.isControls.getImageSequence("facebreaker-bar");
    }

    public void clearCharacters() {
        for (int i = 0; i < 2; ++i) {
            boxer[i].clear();
        }
    }

    public void setCharacters(int n, int n2) {
        this.clearCharacters();
        boxer[0].init(n, GameApp.frontEnd.fpBoxerAnimationScaling);
        boxer[1].init(n2, GameApp.frontEnd.fpBoxerAnimationScaling);
    }

    public void setupPauseMenu() {
        int n;
        for (n = 0; n < this.ctrlAILevel.length; ++n) {
            this.ctrlAILevel[n] = new GuiControl(true);
        }
        for (n = 0; n < this.ctrlPracticeAIMode.length; ++n) {
            this.ctrlPracticeAIMode[n] = new GuiControl(true);
        }
        this.setupPauseMenuText();
        this.menuPause.addControl(this.ctrlPauseTitle);
        this.menuPause.addControl(this.ctrlHelp);
        this.menuPause.addControl(this.ctrlExit);
        this.menuPause.controlHandler = this;
        this.updateMenuHeight(this.menuPause);
        this.menuPause.open();
        this.menuOptions.addControl(this.ctrlOptionsTitle);
        this.menuOptions.addControl(this.ctrlVibrate);
        this.menuOptions.controlHandler = this;
        this.updateMenuHeight(this.menuOptions);
        this.menuOptions.open();
        this.menuPractice.addControl(this.ctrlPracticeTitle);
        this.menuPractice.addControl(this.ctrlPracticeAI);
        this.menuPractice.addControl(this.ctrlChangeCharacter);
        this.menuPractice.addControl(this.ctrlHelp);
        this.menuPractice.addControl(this.ctrlExit);
        this.menuPractice.controlHandler = this;
        this.updateMenuHeight(this.menuPractice);
        this.menuPractice.open();
        this.menuPracticeAI.addControl(this.ctrlPracticeAITitle);
        for (n = 0; n < this.ctrlPracticeAIMode.length; ++n) {
            this.menuPracticeAI.addControl(this.ctrlPracticeAIMode[n]);
        }
        this.menuPracticeAI.controlHandler = this;
        this.updateMenuHeight(this.menuPracticeAI);
        this.menuPracticeAI.open();
    }

    public void setupPauseMenuText() {
        this.ctrlPauseTitle.controlImage = new TextImage(fontGame, SDKUtils.getString(133, null));
        this.ctrlGod.controlImage = new TextImage(ScreenStack.font, new SDKString("CHEAT: GOD"));
        this.ctrlWin.controlImage = new TextImage(ScreenStack.font, new SDKString("CHEAT: WIN"));
        this.ctrlHelp.controlImage = new TextImage(ScreenStack.font, SDKUtils.getString(10, null));
        this.ctrlExit.controlImage = new TextImage(ScreenStack.font, SDKUtils.getString(134, null));
        this.ctrlOptions.controlImage = new TextImage(ScreenStack.font, SDKUtils.getString(9, null));
        this.ctrlOptionsTitle.controlImage = new TextImage(fontGame, SDKUtils.getString(9, null));
        this.ctrlVibrate.controlImage = FrontEnd.controlOptionsVibrate.controlImage;
        this.ctrlPracticeTitle.controlImage = new TextImage(fontGame, SDKUtils.getString(135, null));
        this.ctrlPracticeAI.controlImage = new TextImage(ScreenStack.font, SDKUtils.getString(136, null));
        this.ctrlChangeCharacter.controlImage = new TextImage(ScreenStack.font, SDKUtils.getString(137, null));
        this.ctrlPracticeAITitle.controlImage = new TextImage(FrontEnd.fontWhite, SDKUtils.getString(138, null));
        for (int i = 0; i < this.ctrlPracticeAIMode.length; ++i) {
            this.ctrlPracticeAIMode[i].controlImage = new TextImage(ScreenStack.font, SDKUtils.getString(128 + i, null));
        }
    }

    public void updateMenuHeight(MenuLayout menuLayout) {
        menuLayout.clipRect.h = 0;
        for (int i = 0; i < menuLayout.controlList.size(); ++i) {
            GuiControl guiControl = (GuiControl)menuLayout.controlList.elementAt(i);
            if (guiControl.hidden) continue;
            menuLayout.clipRect.h = (short)(menuLayout.clipRect.h + GameApp.max(guiControl.clipRect.h, FrontEnd.gfxBar.getRectHeight(0)));
        }
        menuLayout.clipRect.y0 = (short)((this.displayHeight - menuLayout.clipRect.h) / 2);
    }

    public void pushScreen(ScreenLayout screenLayout, boolean bl) {
        this.menuCurrent = (MenuLayout)screenLayout;
        this.updateMenuHeight(this.menuCurrent);
        this.menuCurrent.open();
        if (GameApp.soundIsPlaying) {
            SDKSoundManager.getManager().stopSounds();
            GameApp.soundIsPlaying = false;
        }
    }

    public void controlExecuted(ScreenLayout screenLayout, GuiControl guiControl) {
        if (guiControl == this.ctrlExit) {
            ScreenStack.wipeDirection = 8;
            isPaused = false;
            FrontEnd.instance.open();
        }
        if (guiControl == this.ctrlPracticeAI) {
            this.menuPracticeAI.iSelected = GameScreen.boxer[1].aiLevel + 1;
            this.menuPracticeAI.open();
        }
        if (guiControl == this.ctrlOptions) {
            this.pushScreen(this.menuOptions, false);
        }
        if (screenLayout == this.menuOptions && guiControl == this.ctrlVibrate) {
            FrontEnd.instance.controlExecuted(FrontEnd.menuOptions, FrontEnd.controlOptionsVibrate);
        }
        if (guiControl == this.ctrlHelp) {
            FrontEnd.instance.pushScreen(FrontEnd.menuHelp, true);
        }
        if (guiControl == this.ctrlChangeCharacter) {
            ScreenStack.wipeDirection = 4;
            isPaused = false;
            FrontEnd.instance.pushScreen(FrontEnd.characterSelect, true);
            FrontEnd.instance.setupSound();
            FrontEnd.boxersSelection = true;
        }
        if (screenLayout == this.menuPracticeAI) {
            for (int i = 0; i < this.ctrlPracticeAIMode.length; ++i) {
                if (guiControl != this.ctrlPracticeAIMode[i]) continue;
                boxer[1].setAILevel(i);
                isPaused = false;
                break;
            }
        }
    }

    public void setupSound() {
        if (GameApp.soundIsPlaying) {
            SDKSoundManager.getManager().stopSounds();
            GameApp.soundIsPlaying = false;
        }
        SDKSoundManager.getManager().setSoundEnabled(FrontEnd.sound);
    }

    public void reload() {
        if (GameLogic.gameMode == 3) {
            game.newGame();
        }
        GameApp.setAppLoading();
        this.loadTileset();
        boxer[0].reload();
        boxer[1].reload();
    }

    public void unload() {
        this.unloadTileset();
        boxer[0].unload();
        boxer[1].unload();
    }

    public void open() {
        FrontEnd.instance.unload();
        this.controlHandler = this;
        this.layout();
        boxer[0].init(GameLogic.boxer1, GameApp.frontEnd.fpBoxerAnimationScaling);
        boxer[1].init(GameLogic.boxer2, GameApp.frontEnd.fpBoxerAnimationScaling);
        this.reload();
        this.setupSound();
        this.restoreBoxerPositions();
        this.updateRound();
        this.isFrench = SDKUtils.getString(191, null).toString().equals("FR");
    }

    public void storeBoxerPositions() {
        this.backupX = m_x;
        this.backupY = m_y;
        this.backupP1X = GameScreen.boxer[0].actorPos[0];
        this.backupP1Y = GameScreen.boxer[0].actorPos[1];
        this.backupP2X = GameScreen.boxer[1].actorPos[0];
        this.backupP2Y = GameScreen.boxer[1].actorPos[1];
    }

    public void restoreBoxerPositions() {
        m_x = this.backupX;
        m_y = this.backupY;
        GameScreen.boxer[0].actorPos[0] = this.backupP1X;
        GameScreen.boxer[0].actorPos[1] = this.backupP1Y;
        GameScreen.boxer[1].actorPos[0] = this.backupP2X;
        GameScreen.boxer[1].actorPos[1] = this.backupP2Y;
    }

    public void resetBoxerPositions() {
        GameScreen.boxer[0].actorPos[0] = this.totalLayerWidth[0] / 2 - GameScreen.getInverseScaledPos(this.displayWidth / 3) < 0 ? -(-(this.totalLayerWidth[0] / 2 - GameScreen.getInverseScaledPos(this.displayWidth / 3)) << 16) : this.totalLayerWidth[0] / 2 - GameScreen.getInverseScaledPos(this.displayWidth / 3) << 16;
        GameScreen.boxer[1].actorPos[0] = this.totalLayerWidth[0] / 2 + GameScreen.getInverseScaledPos(this.displayWidth / 3) < 0 ? -(-(this.totalLayerWidth[0] / 2 + GameScreen.getInverseScaledPos(this.displayWidth / 3)) << 16) : this.totalLayerWidth[0] / 2 + GameScreen.getInverseScaledPos(this.displayWidth / 3) << 16;
        GameScreen.boxer[0].actorPos[1] = Boxer.cfpFloorHeight = (this.totalLayerHeight[0] << 1) / 3 < 0 ? -(-((this.totalLayerHeight[0] << 1) / 3) << 16) : (this.totalLayerHeight[0] << 1) / 3 << 16;
        GameScreen.boxer[1].actorPos[1] = Boxer.cfpFloorHeight;
        startingDistBetweenPlayers = GameScreen.getInverseScaledPos(this.displayWidth / 3) * 2 < 0 ? -(-(GameScreen.getInverseScaledPos(this.displayWidth / 3) * 2) << 16) : GameScreen.getInverseScaledPos(this.displayWidth / 3) * 2 << 16;
        this.storeBoxerPositions();
    }

    public void close() {
        this.storeBoxerPositions();
        this.unload();
        FrontEnd.instance.reload();
    }

    public void layout() {
    }

    public void paint(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        int n3;
        block12: {
            block13: {
                int n4 = GameApp.min(GameScreen.getScaledPos(this.totalLayerHeight[0]), this.displayHeight);
                int n5 = ScreenStack.displayHeight - n4 >> 1;
                sDKGraphics.setColor(0);
                sDKGraphics.fillRect(0, 0, this.displayWidth, n5 + 100);
                sDKGraphics.fillRect(0, n5 + n4 - 100, ScreenStack.displayWidth, n5 + 100);
                this.drawTiles(sDKGraphics, 0);
                if (this.triggerScreenFlash >= 0) {
                    sDKGraphics.setColor(0xFF0000);
                    sDKGraphics.fillRect(0, 0, ScreenStack.displayWidth, ScreenStack.displayHeight);
                    this.triggerScreenFlash = (byte)(this.triggerScreenFlash - 1);
                }
                this.drawRing(sDKGraphics);
                Boxer cfr_ignored_0 = boxer[0];
                if (Boxer.isAttackAnim(GameScreen.boxer[0].animator.anim_id)) {
                    this.boxer_infront = 0;
                } else {
                    Boxer cfr_ignored_1 = boxer[1];
                    if (Boxer.isAttackAnim(GameScreen.boxer[1].animator.anim_id)) {
                        this.boxer_infront = 1;
                    }
                }
                boxer[1 - this.boxer_infront].drawShadow(sDKGraphics);
                boxer[this.boxer_infront].drawShadow(sDKGraphics);
                boxer[1 - this.boxer_infront].draw(sDKGraphics);
                boxer[this.boxer_infront].draw(sDKGraphics);
                this.drawGui(sDKGraphics);
                if (isPaused) break block12;
                if (GameScreen.game.state != 3) break block13;
                if (GameScreen.game.roundTime <= 0xB40000) break block12;
            }
            if (this.characterSpeechText2.controlList.size() > 0) {
                if (ImageSequence.clipSet) {
                    sDKGraphics.setClip(0, 0, ScreenStack.displayWidth * 2, ScreenStack.displayHeight * 2);
                    ImageSequence.clipSet = false;
                }
                sDKGraphics.setColor(0);
                n3 = this.characterSpeechTextCL.clipRect.x0;
                n2 = this.characterSpeechTextCL.clipRect.y0 - ScreenStack.getScaledY(6);
                n = this.characterSpeechTextCL.clipRect.h + ScreenStack.getScaledY(12);
                sDKGraphics.fillRect(n3, n2, this.characterSpeechTextCL.clipRect.w, n);
                sDKGraphics.setColor(0xFFFFFF);
                sDKGraphics.fillRect(n3, n2 - 2, this.characterSpeechTextCL.clipRect.w, 2);
                sDKGraphics.fillRect(n3, n2 + n, this.characterSpeechTextCL.clipRect.w, 2);
                this.characterSpeechTextCL.paint(sDKGraphics);
            }
            this.textInfo.paint(sDKGraphics);
        }
        if (isPaused && this.menuCurrent != null) {
            FrontEnd.instance.drawMenuBars(sDKGraphics, this.menuCurrent);
            n3 = this.displayWidth;
            n2 = 0;
            for (n = 0; n < this.menuCurrent.controlList.size(); ++n) {
                GuiContainer guiContainer = (GuiContainer)this.menuCurrent.controlList.elementAt(n);
                n3 = GameApp.min(n3, guiContainer.clipRect.x0);
                n2 = GameApp.max(n2, guiContainer.clipRect.x0 + guiContainer.clipRect.w);
            }
            n3 -= FrontEnd.fontWhite.getFontHeight();
            n2 += FrontEnd.fontWhite.getFontHeight();
            if (ImageSequence.clipSet) {
                sDKGraphics.setClip(0, 0, ScreenStack.displayWidth * 2, ScreenStack.displayHeight * 2);
                ImageSequence.clipSet = false;
            }
            sDKGraphics.setColor(-1);
            sDKGraphics.fillRect(n3, this.menuCurrent.clipRect.y0, n2 - n3, this.menuCurrent.clipRect.h);
            sDKGraphics.setColor(0);
            sDKGraphics.drawRect(n3, this.menuCurrent.clipRect.y0, n2 - n3, this.menuCurrent.clipRect.h);
            sDKGraphics.drawRect(n3 + 1, this.menuCurrent.clipRect.y0 + 1, n2 - n3 - 2, this.menuCurrent.clipRect.h - 2);
            this.menuCurrent.paint(sDKGraphics);
        }
    }

    public void continueGame() {
        this.onNextState(GameScreen.game.state);
    }

    public void process() {
        this.processInput();
        if (isPaused) {
            System.gc();
            return;
        }
        GameApp.fp_deltatime = GameApp.mulp(GameApp.fp_deltatime, cRealTimeScaleFactor);
        this.processBoxers();
        if (GameScreen.game.state == 2) {
            this.readyTimer += GameApp.fp_deltatime;
            if (this.readyTimer > 98304) {
                game.nextState(3);
            }
        }
        game.process();
    }

    private void processBoxers() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0x140000;
        int n6 = n4 = this.totalLayerWidth[0] - 20 < 0 ? -(-(this.totalLayerWidth[0] - 20) << 16) : this.totalLayerWidth[0] - 20 << 16;
        if (GameScreen.game.state == 3) {
            boxer[0].processPlayer();
            boxer[1].processAI();
        }
        if ((n3 = GameScreen.boxer[0].rectBody[0] + GameScreen.boxer[0].rectBody[2]) > (n2 = GameScreen.boxer[1].rectBody[0])) {
            n = GameScreen.getInverseScaledPos(n3 - n2) / 2 + 1;
            GameScreen.boxer[0].actorPos[0] = GameScreen.boxer[0].actorPos[0] - (n < 0 ? -(-n << 16) : n << 16);
            GameScreen.boxer[1].actorPos[0] = GameScreen.boxer[1].actorPos[0] + (n < 0 ? -(-n << 16) : n << 16);
            GameScreen.boxer[0].actorVel[0] = GameScreen.boxer[0].actorVel[0] * 9 / 10;
            GameScreen.boxer[1].actorVel[0] = GameScreen.boxer[1].actorVel[0] * 9 / 10;
        }
        for (n = 0; n < 2; ++n) {
            if (GameScreen.boxer[n].actorPos[0] < n5) {
                GameScreen.boxer[n].actorVel[0] = GameApp.abs(GameScreen.boxer[n].actorVel[0]) + 0x400000;
            } else if (GameScreen.boxer[n].actorPos[0] > n4) {
                GameScreen.boxer[n].actorVel[0] = -GameApp.abs(GameScreen.boxer[n].actorVel[0]) - 0x400000;
            }
            GameScreen.boxer[n].actorPos[0] = GameApp.bound(GameScreen.boxer[n].actorPos[0], n5, n4);
            boxer[n].processAnimation();
        }
    }

    public void doPauseMenu() {
        if (this.menuCurrent == this.menuPractice || this.menuCurrent == this.menuPause || !isPaused) {
            isPaused = !isPaused;
        }
        FrontEnd.mainLayout.layout();
        if (isPaused) {
            if (GameLogic.gameMode == 3) {
                this.pushScreen(this.menuPractice, true);
            } else {
                this.pushScreen(this.menuPause, true);
            }
        }
    }

    private void setCharSpeechY() {
        this.characterSpeechTextCL.clipRect.y0 = (short)(ScreenStack.displayHeight - (FrontEnd.gfxBar.getRectHeight(0) + this.characterSpeechTextCL.clipRect.h + ScreenStack.getScaledY(8)));
    }

    public void processInput() {
        if (ScreenLayout.keysPressed(65536)) {
            this.doPauseMenu();
        }
        if (isPaused && this.menuCurrent != null) {
            this.menuCurrent.process();
            ScreenStack.resetKeys();
            return;
        }
        switch (GameScreen.game.state) {
            case 0: {
                if (!ScreenLayout.keysPressed(32784)) break;
                game.nextState(1);
                break;
            }
            case 1: {
                if (!ScreenLayout.keysPressed(32784)) break;
                game.nextState(2);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (!ScreenLayout.keysPressed(32768)) break;
                game.newRound();
                break;
            }
            case 6: {
                if (!ScreenLayout.keysPressed(32768)) break;
                this.exitGame();
            }
        }
    }

    public void onNextState(int n) {
        this.textInfo.clipRect.x0 = 0;
        this.textInfo.clipRect.y0 = (short)(-ScreenStack.getScaledY(40));
        this.characterSpeechTextCL.clipRect.x0 = 0;
        int n2 = GameScreen.boxer[1].actorCharacter;
        GameScreen.boxer[0].glowKeyTime = 0;
        GameScreen.boxer[1].glowKeyTime = 0;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.textInfo.clearText();
                this.characterSpeechText1.clearText();
                this.characterSpeechText2.clearText();
                if (GameScreen.game.round != 1) break;
                this.characterSpeechText2.formatText(FrontEnd.fontWhite, SDKUtils.getString(23 + GameLogic.boxer2, null));
                this.characterSpeechText2.formatText(FrontEnd.fontWhite, strColonSpace);
                this.characterSpeechText2.formatText(FrontEnd.fontWhite, SDKUtils.getString(143 + GameLogic.boxer2, null));
                this.characterSpeechTextCL.layout();
                this.characterSpeechTextCL.layout();
                this.setCharSpeechY();
                int n3 = ScreenStack.currentContainer != this ? 1000 : 0;
                ScreenStack.doTransition(this.characterSpeechTextCL, 17, n3, 500);
                break;
            }
            case 2: {
                this.readyTimer = 0;
                this.characterSpeechText1.clearText();
                this.characterSpeechText2.clearText();
                this.textInfo.clearText();
                this.textInfo.formatText(fontGame, SDKUtils.getString(78, null));
                this.textInfo.layout();
                ScreenStack.doTransition(this.textInfo, 17, 0, 500);
                break;
            }
            case 3: {
                this.characterSpeechText1.clearText();
                this.characterSpeechText2.clearText();
                this.textInfo.clearText();
                this.textInfo.formatText(fontGame, SDKUtils.getString(79, null));
                this.textInfo.layout();
                ScreenStack.doTransition(this.textInfo, 17, 0, 250);
                boxer[0].playAnimation(0);
                boxer[1].playAnimation(0);
                break;
            }
            case 4: {
                this.characterSpeechText1.clearText();
                this.characterSpeechText2.clearText();
                this.textInfo.clearText();
                break;
            }
            case 5: {
                this.characterSpeechText1.clearText();
                this.characterSpeechText2.clearText();
                this.textInfo.clearText();
                this.textInfo.formatText(fontGame, SDKUtils.getString(80, null));
                this.textInfo.layout();
                ScreenStack.doTransition(this.textInfo, 17, 0, 500);
                break;
            }
            case 6: {
                GameApp.frontEnd.initConfetti();
                this.characterSpeechText1.clearText();
                this.characterSpeechText2.clearText();
                this.textInfo.clearText();
                this.characterSpeechText2.formatText(FrontEnd.fontWhite, SDKUtils.getString(23 + n2, null));
                this.characterSpeechText2.formatText(FrontEnd.fontWhite, strColonSpace);
                if (GameScreen.game.roundsWon[0] > GameScreen.game.roundsWon[1] || GameScreen.game.performedFB == 0) {
                    this.textInfo.formatText(fontGame, SDKUtils.getString(81, null));
                    this.characterSpeechText2.formatText(FrontEnd.fontWhite, SDKUtils.getString(155 + n2, null));
                } else {
                    this.textInfo.formatText(fontGame, SDKUtils.getString(82, null));
                    this.characterSpeechText2.formatText(FrontEnd.fontWhite, SDKUtils.getString(149 + n2, null));
                }
                this.characterSpeechTextCL.layout();
                this.characterSpeechTextCL.layout();
                this.setCharSpeechY();
                this.textInfo.layout();
                ScreenStack.doTransition(this.characterSpeechTextCL, 17, 0, 500);
            }
        }
        ScreenStack.resetKeys();
    }

    public void exitGame() {
        ScreenStack.wipeDirection = 8;
        FrontEnd.instance.setupSound();
        if (GameScreen.game.roundsWon[0] > GameScreen.game.roundsWon[1] || GameScreen.game.performedFB == 0) {
            FrontEnd.instance.pushScreen(FrontEnd.statsScreen, true);
            if (FrontEnd.unlockedBelts == GameLogic.belt + 1) {
                FrontEnd.setBeltProgress(GameLogic.boxer1, GameLogic.match + 1);
            }
        } else if (GameLogic.gameMode == 1) {
            if (GameScreen.game.continues > 0) {
                SDKString sDKString = new SDKString(100, 0);
                sDKString.append(SDKUtils.getString(112, null)).append("\n").append(GameScreen.game.continues).append(" ").append(SDKUtils.getString(113, null));
                FrontEnd.instance.openConfirmDialog(sDKString, 7, 8, true);
            } else {
                FrontEnd.instance.openConfirmDialog(SDKUtils.getString(111, null), 8, -1, true);
            }
        } else {
            FrontEnd.instance.open();
        }
    }

    public void doScreenFlash(byte by) {
        this.triggerScreenFlash = by;
    }

    public static int getScaledPos(int n) {
        int n2 = GameApp.mul(fp_tileScale, n < 0 ? -(-n << 16) : n << 16);
        return n2 < 0 ? -(-n2 >> 16) : n2 >> 16;
    }

    public static int getInverseScaledPos(int n) {
        int n2 = GameApp.div(n < 0 ? -(-n << 16) : n << 16, fp_tileScale);
        return n2 < 0 ? -(-n2 >> 16) : n2 >> 16;
    }

    public void loadLevel(int n) {
        if (this.levelLoaded == n) {
            return;
        }
        this.mapXScale = new int[1];
        this.mapYScale = new int[1];
        this.mapWidth = new int[1];
        this.mapHeight = new int[1];
        this.totalLayerWidth = new int[1];
        this.totalLayerHeight = new int[1];
        for (int i = 0; i < 1; ++i) {
            this.strTileSet = "/gym.png";
            this.mapWidth[i] = 11;
            this.mapHeight[i] = 10;
            this.tileWidth = 64;
            this.tileHeight = 64;
            this.totalLayerWidth[i] = this.mapWidth[i] * this.tileWidth;
            this.totalLayerHeight[i] = this.mapHeight[i] * this.tileHeight;
        }
        this.levelLoaded = n;
        GameApp.printMemoryStatus("GameScreen.loadLevel() post map read");
    }

    public void loadTileset() {
        try {
            this.imgTiles = SDKUtils.createImage(this.strTileSet);
            this.tileSetWidth = this.imgTiles.getWidth();
            this.tileSetHeight = this.imgTiles.getHeight();
            this.realTileHeight = this.realTileWidth = this.tileSetWidth / 4;
            fp_tileScale = GameApp.div(this.realTileWidth << 16, this.tileWidth << 16);
            int n = this.displayWidth / this.realTileWidth;
            int n2 = this.displayHeight / this.realTileHeight;
            for (int i = 0; i < 1; ++i) {
                this.mapXScale[i] = this.mapWidth[0] - n != 0 ? GameApp.div(this.mapWidth[i] - n << 16, this.mapWidth[0] - n << 16) : 65536;
                this.mapYScale[i] = this.mapHeight[0] - n2 != 0 ? GameApp.div(this.mapHeight[i] - n2 << 16, this.mapHeight[0] - n2 << 16) : 65536;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unloadTileset() {
        this.imgTiles = null;
    }

    public void drawTiles(SDKGraphics sDKGraphics, int n) {
        sDKGraphics.setColor(0);
        sDKGraphics.setClip(0, 0, 176, 220);
        sDKGraphics.fillRect(0, 0, 176, 220);
        sDKGraphics.setColor(15524807);
        sDKGraphics.fillRect(0, 45, 176, 114);
        if (ImageSequence.clipSet) {
            sDKGraphics.setClip(0, 0, ScreenStack.displayWidth * 2, ScreenStack.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
    }

    public void updateTime() {
        int n = (GameScreen.game.roundTime < 0 ? -(-GameScreen.game.roundTime >> 16) : GameScreen.game.roundTime >> 16) % 60;
        int n2 = (GameScreen.game.roundTime < 0 ? -(-GameScreen.game.roundTime >> 16) : GameScreen.game.roundTime >> 16) / 60;
        this.strTime.setLength(0);
        this.strTime.append(n2).append(":").append(GameApp.formatNumber(n, 2, '0'));
        this.timeWidth = ScreenStack.fontSmall.getTextWidth(this.strTime);
    }

    public void updateRound() {
        this.strRound.setLength(0);
        if (GameLogic.gameMode == 3) {
            this.strRound.append(SDKUtils.getString(16, null));
        } else {
            this.strRound.append(SDKUtils.getString(127, null)).append(" ").append(GameScreen.game.round);
        }
        this.roundWidth = ScreenStack.fontSmall.getTextWidth(this.strRound);
    }

    public void drawGui(SDKGraphics sDKGraphics) {
        int n;
        try {
            ScreenStack.fontSmall.drawText(sDKGraphics, this.strRound, this.displayWidth / 2 - this.roundWidth / 2, ScreenStack.getScaledY(8), ScreenStack.visibleRect);
            if (GameLogic.gameMode != 3) {
                ScreenStack.fontSmall.drawText(sDKGraphics, this.strTime, this.displayWidth / 2 - this.timeWidth / 2, ScreenStack.getScaledY(24), ScreenStack.visibleRect);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = 36;
        int n3 = 5;
        int n4 = cEnergyBarOffsetY - 20;
        if (GameScreen.game.boxerEnergy[0] > 0x320000) {
            sDKGraphics.setColor(0xFF0000);
            sDKGraphics.fillRect(cEnergyBarOffsetX, n4, n2, n3);
            n = GameScreen.game.boxerEnergy[0] - 0x320000 < 0 ? -(-(GameScreen.game.boxerEnergy[0] - 0x320000) >> 16) : GameScreen.game.boxerEnergy[0] - 0x320000 >> 16;
            sDKGraphics.setColor(65280);
            sDKGraphics.fillRect(cEnergyBarOffsetX, n4, n2 * n / 100, n3);
        } else {
            sDKGraphics.setColor(0);
            sDKGraphics.fillRect(cEnergyBarOffsetX, n4, n2, n3);
            n = GameScreen.game.boxerEnergy[0] < 0 ? -(-GameScreen.game.boxerEnergy[0] >> 16) : GameScreen.game.boxerEnergy[0] >> 16;
            sDKGraphics.setColor(0xFF0000);
            sDKGraphics.fillRect(cEnergyBarOffsetX, n4, n2 * n / 50, n3);
        }
        sDKGraphics.setColor(24958);
        sDKGraphics.drawRect(cEnergyBarOffsetX, n4, n2, n3);
        if (GameScreen.game.boxerEnergy[1] > 0x320000) {
            sDKGraphics.setColor(0xFF0000);
            sDKGraphics.fillRect(this.displayWidth - cEnergyBarOffsetX - n2, n4, n2, n3);
            n = GameScreen.game.boxerEnergy[1] - 0x320000 < 0 ? -(-(GameScreen.game.boxerEnergy[1] - 0x320000) >> 16) : GameScreen.game.boxerEnergy[1] - 0x320000 >> 16;
            sDKGraphics.setColor(65280);
            sDKGraphics.fillRect(this.displayWidth - cEnergyBarOffsetX - n2 * n / 100, n4, n2 * n / 100, n3);
        } else {
            sDKGraphics.setColor(0);
            sDKGraphics.fillRect(this.displayWidth - cEnergyBarOffsetX - n2, n4, n2, n3);
            n = GameScreen.game.boxerEnergy[1] < 0 ? -(-GameScreen.game.boxerEnergy[1] >> 16) : GameScreen.game.boxerEnergy[1] >> 16;
            sDKGraphics.setColor(0xFF0000);
            sDKGraphics.fillRect(this.displayWidth - cEnergyBarOffsetX - n2 * n / 50, n4, n2 * n / 50, n3);
        }
        sDKGraphics.setColor(24958);
        sDKGraphics.drawRect(this.displayWidth - cEnergyBarOffsetX - n2, n4, n2, n3);
        if (GameLogic.gameMode != 3) {
            n = GameScreen.game.roundsWon[0];
            int n5 = GameScreen.game.roundsWon[1];
            int n6 = cRoundsWonOffsetY;
            int n7 = 6;
            int n8 = 2;
            switch (n) {
                case 0: {
                    sDKGraphics.setColor(0x444444);
                    sDKGraphics.fillRect(cRoundsWonOffsetX, n6, n7, n7);
                    sDKGraphics.fillRect(cRoundsWonOffsetX + n7 + n8, n6, n7, n7);
                    break;
                }
                case 1: {
                    sDKGraphics.setColor(0xFF0000);
                    sDKGraphics.fillRect(cRoundsWonOffsetX, n6, n7, n7);
                    sDKGraphics.setColor(0x444444);
                    sDKGraphics.fillRect(cRoundsWonOffsetX + n7 + n8, n6, n7, n7);
                    break;
                }
                case 2: {
                    sDKGraphics.setColor(0xFF0000);
                    sDKGraphics.fillRect(cRoundsWonOffsetX, n6, n7, n7);
                    sDKGraphics.fillRect(cRoundsWonOffsetX + n7 + n8, n6, n7, n7);
                }
            }
            switch (n5) {
                case 0: {
                    sDKGraphics.setColor(0x444444);
                    sDKGraphics.fillRect(this.displayWidth - n7 * 2 - n8 * 2, n6, n7, n7);
                    sDKGraphics.fillRect(this.displayWidth - n7 - n8, n6, n7, n7);
                    break;
                }
                case 1: {
                    sDKGraphics.setColor(0x444444);
                    sDKGraphics.fillRect(this.displayWidth - n7 * 2 - n8 * 2, cRoundsWonOffsetY, n7, n7);
                    sDKGraphics.setColor(0xFF0000);
                    sDKGraphics.fillRect(this.displayWidth - n7 - n8, cRoundsWonOffsetY, n7, n7);
                    break;
                }
                case 2: {
                    sDKGraphics.setColor(0xFF0000);
                    sDKGraphics.fillRect(this.displayWidth - n7 * 2 - n8 * 2, cRoundsWonOffsetY, n7, n7);
                    sDKGraphics.fillRect(this.displayWidth - n7 - n8, cRoundsWonOffsetY, n7, n7);
                }
            }
        }
        if (GameScreen.game.state == 1 || GameScreen.game.state == 0 || GameScreen.game.state == 5 || GameScreen.game.state == 6 || isPaused) {
            FrontEnd.instance.iconMenuBar.clipRect.y0 = (short)(ScreenStack.displayHeight - FrontEnd.gfxBar.getRectHeight(0));
            FrontEnd.instance.iconMenuBar.clipRect.h = FrontEnd.gfxBar.getRectHeight(0);
            FrontEnd.gfxBar.drawImage(sDKGraphics, 0, 0, FrontEnd.instance.iconMenuBar.clipRect.y0);
            FrontEnd.instance.drawButtonBar(sDKGraphics);
        } else {
            this.drawFaceBreakerBar(sDKGraphics, cFaceBreakerBarOffsetX, this.displayHeight - gfxFaceBreakerBar.getRectHeight(0) - cFaceBreakerBarOffsetY, 0);
            this.drawFaceBreakerBar(sDKGraphics, this.displayWidth - cFaceBreakerBarOffsetX - gfxFaceBreakerBar.getRectWidth(0), this.displayHeight - gfxFaceBreakerBar.getRectHeight(0) - cFaceBreakerBarOffsetY, 1);
        }
    }

    public void drawFaceBreakerBar(SDKGraphics sDKGraphics, int n, int n2, int n3) {
        int n4 = game.getFaceBreakerSegment(n3);
        gfxFaceBreakerBar.drawImage(sDKGraphics, n4, n, n2);
    }

    private void drawRing(SDKGraphics sDKGraphics) {
        ScreenStack.setDefaultRes(176, 204);
        int n = 110;
        int n2 = ScreenStack.getScaledX(9);
        int n3 = ScreenStack.getScaledY(n);
        int n4 = ScreenStack.getScaledY(30);
        int n5 = 0;
        int n6 = this.displayWidth - n2;
        sDKGraphics.setColor(11700585);
        sDKGraphics.fillRect(n5, n3, n2, n4);
        sDKGraphics.fillRect(n6, n3, n2, n4);
        int n7 = n2;
        int n8 = ScreenStack.getScaledY(n + 6);
        int n9 = ScreenStack.getScaledY(n + 14);
        int n10 = ScreenStack.getScaledY(n + 22);
        int n11 = ScreenStack.getScaledY(2);
        int n12 = this.displayWidth - n7 * 2;
        sDKGraphics.setColor(5948514);
        sDKGraphics.fillRect(n7, n8, n12, n11);
        sDKGraphics.fillRect(n7, n9, n12, n11);
        sDKGraphics.fillRect(n7, n10, n12, n11);
        ScreenStack.setDefaultRes(240, 320);
    }

    static {
        startingDistBetweenPlayers = 0;
        cEnergyBarOffsetX = ScreenStack.getScaledX(4);
        cEnergyBarOffsetY = ScreenStack.getScaledY(64);
        cRoundsWonOffsetX = ScreenStack.getScaledX(4);
        cRoundsWonOffsetY = ScreenStack.getScaledY(48);
        cFaceBreakerBarOffsetX = ScreenStack.getScaledX(6);
        cFaceBreakerBarOffsetY = ScreenStack.getScaledY(8);
    }
}

