/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKUtils;
import com.slg.j2me.game.Boxer;
import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.game.GameScreen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;

public class GameLogic {
    public static final int modeFight = 0;
    public static final int modeBrawl = 1;
    public static final int modeSurvival = 2;
    public static final int modePractice = 3;
    public static final int modePhoto = 4;
    public static int gameMode = 0;
    public static final int Romeo = 0;
    public static final int Spin = 1;
    public static final int Kiriko = 2;
    public static final int Voodoo = 3;
    public static final int Steve = 4;
    public static final int Socks = 5;
    public static final int Sparrow = 6;
    public static final int Molotov = 7;
    public static final int Pummel = 8;
    public static final int Everyone = 9;
    public static final String[] strBoxers = new String[]{SDKUtils.getString(23, null).toString(), SDKUtils.getString(24, null).toString(), SDKUtils.getString(25, null).toString(), SDKUtils.getString(26, null).toString(), SDKUtils.getString(27, null).toString(), SDKUtils.getString(28, null).toString()};
    public static final int[] boxerColour = new int[]{0xFF2727, 2271279, 16711868, 14463001, 3424616, 0x767676};
    private static final int[] fightAIDifficulty = new int[]{1, 3, 5, 7, 9};
    private static final int[] cAIHitPointBoost = new int[]{40, 44, 46, 48, 50, 51, 52, 54, 56, 58, 60};
    public static final String[] strBelts = new String[]{SDKUtils.getString(18, null).toString(), SDKUtils.getString(19, null).toString(), SDKUtils.getString(20, null).toString(), SDKUtils.getString(21, null).toString(), SDKUtils.getString(22, null).toString()};
    public static final int[][] beltBoxers = new int[][]{{0, 1, 2}, {1, 2, 5}, {0, 1, 2, 5}};
    public static final int[][] beltAIDifficulty = new int[][]{{1, 2, 4}, {3, 4, 6}, {5, 7, 8, 10}};
    public static int[][] statsPlayer = new int[2][35];
    public static Random random;
    public static final int stateExchange = 0;
    public static final int stateIntro = 1;
    public static final int stateReady = 2;
    public static final int stateMatch = 3;
    public static final int stateRoundEnding = 4;
    public static final int stateRoundOver = 5;
    public static final int stateGameOver = 6;
    public int state = 6;
    public static final int cRoundDuration = 0xB40000;
    public static final int cRoundTimeSpeed = 98304;
    public static final int cNumRounds = 2;
    public static final int cRechargeEnergy = 0x320000;
    public static final int cArmourEnergy = 0x640000;
    public static final int cFullEnergy = 0x960000;
    public static final int cRechargePerSec = 2;
    public static final int cMaxFaceBreakerBar = 0x5A0000;
    public static final int cDamageScale = 16384;
    public static final int cNumContinues = 5;
    public int round = 0;
    public int[] roundsWon = new int[]{0, 0};
    public int continues = 5;
    public int performedFB = -1;
    public int roundTime = 0;
    public int[] boxerEnergy = new int[]{0x960000, 0x960000};
    public int[] boxerFaceBreakerBar = new int[]{0, 0};
    private int roundEndingWinner;
    public int roundEndingDuration;
    public static int boxer1;
    public static int boxer2;
    public static int aiDifficulty;
    public static int belt;
    public static int match;
    public static int[] boxers;
    public static final int cStatNormaliser = 50;
    public static String[] strStatsHeadings;
    public static String[] strMovesHeadings;
    public static Vector vecStatsData;
    public static Vector vecMovesData;
    public static final int cStatBoxerID = 0;
    public static final int cStatWalkSpeed = 1;
    public static final int cStatJabModifier = 2;
    public static final int cStatHighAttackModifier = 3;
    public static final int cStatLowAttackModifier = 4;
    public static final int cStatParryRate = 5;
    public static final int cStatBlockRate = 6;
    public static final int cStatMoodNuts = 7;
    public static final int cStatMoodAgressive = 8;
    public static final int cStatMoodPlayful = 9;
    public static final int cStatMoodPassive = 10;
    public static final int cStatHitPoints = 11;
    public static final int cMoveSeqBoxerID = 0;
    public static final int cMoveSeqMinLevel = 1;
    public static final int cMoveSeqMaxLevel = 2;
    public static final int cMoveSeqMoveType = 3;
    public static final int cMoveSeqAnimStart = 4;
    public static final int cMoveTypeAttack = 0;
    public static final int cMoveTypeDefence = 1;
    public static final int cMoveTypeBreaker = 2;
    public static final int numMoveTypes = 3;
    public static final short cLoopForever = 1000;
    public static final int cPunchJab1Damage = 81920;
    public static final int cPunchJab2Damage = 81920;
    public static final int cPunchJab3Damage = 81920;
    public static final int cPunchCrossDamage = 163840;
    public static final int cPunchLowDamage = 131072;
    public static final int cPunchLowStrongDamage = 196608;
    public static final int cPunchHighStrongDamage = 245760;
    public static final int cThrowDamage = 0;
    public static final int cGroundBreaker1Damage = 163840;
    public static final int cGroundBreaker2Damage = 229376;
    public static final int cSkyBreaker1Damage = 196608;
    public static final int cSkyBreaker2Damage = 294912;
    public static final int cFaceBreaker1Damage = 0x190000;
    public static final int cFaceBreaker2Damage = 0x320000;
    public static final int cFaceBreaker3Damage = 0x640000;
    public static final byte cTypeUnknown = 0;
    public static final byte cTypeString = 1;
    public static final byte cTypeByte = 2;
    public static final byte cTypeShort = 3;
    public static final byte cTypeInteger = 4;
    public static final byte cTypeLong = 5;
    public static final byte cTypeFloat = 6;
    public static final byte cTypeDouble = 7;

    public boolean isMatchInProgress() {
        return this.state != 6;
    }

    public void endGame() {
        GameApp.deleteGame();
        this.state = 6;
    }

    public int getBoxerStat(int n, int n2) {
        byte[] byArray = GameLogic.getCSVByteArray(vecStatsData, 0);
        byte[] byArray2 = GameLogic.getCSVByteArray(vecStatsData, n2);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != n) continue;
            return byArray2[i];
        }
        return 50;
    }

    public byte[][] getMatchingMoves(int n, int n2, int n3) {
        int n4;
        byte[] byArray = GameLogic.getCSVByteArray(vecMovesData, 0);
        byte[] byArray2 = GameLogic.getCSVByteArray(vecMovesData, 1);
        byte[] byArray3 = GameLogic.getCSVByteArray(vecMovesData, 2);
        byte[] byArray4 = GameLogic.getCSVByteArray(vecMovesData, 3);
        int n5 = strMovesHeadings.length - 4;
        byte[][] byArrayArray = new byte[n5][];
        for (n4 = 0; n4 < n5; ++n4) {
            byArrayArray[n4] = GameLogic.getCSVByteArray(vecMovesData, 4 + n4);
        }
        n4 = byArray.length;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            if (byArray[i] != n && (byArray[i] != 9 || n == 8) || n3 < byArray2[i] || n3 > byArray3[i] || n2 != byArray4[i]) continue;
            ++n6;
        }
        if (n6 == 0) {
            return null;
        }
        byte[][] byArray5 = new byte[n6][n5];
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            if (byArray[i] != n && (byArray[i] != 9 || n == 8) || n3 < byArray2[i] || n3 > byArray3[i] || n2 != byArray4[i]) continue;
            String string = "";
            for (int j = 0; j < n5; ++j) {
                try {
                    byArray5[n7][j] = byArrayArray[j][i];
                    if (byArray5[n7][j] == -1) continue;
                    if (j > 0) {
                        string = string + Boxer.animExportNames[byArray5[n7][j]] + " ";
                        continue;
                    }
                    string = string + "p=" + byArray5[n7][j] + " ";
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n7;
        }
        return byArray5;
    }

    public GameLogic() {
        random = new Random();
        strStatsHeadings = GameLogic.loadCSV("/boxer_stats.bin", vecStatsData);
        strMovesHeadings = GameLogic.loadCSV("/boxer_moves.bin", vecMovesData);
    }

    public static int randRange(int n, int n2) {
        return Math.abs(random.nextInt()) % (n2 - n + 1) + n;
    }

    public int getAIDifficulty() {
        if (gameMode == 1) {
            return beltAIDifficulty[belt][match] - 1;
        }
        if (gameMode == 3) {
            return 0;
        }
        return fightAIDifficulty[FrontEnd.unlockedBelts - 1];
    }

    public static int getOpponentBoxer() {
        if (gameMode == 1) {
            return boxers[match];
        }
        return boxer2;
    }

    public int getFaceBreakerSegment(int n) {
        int n2 = 3 * GameApp.div(this.boxerFaceBreakerBar[n] + 0x190000, 0x5A0000);
        return n2 < 0 ? -(-n2 >> 16) : n2 >> 16;
    }

    public int getBoxerFaceDamage(int n) {
        int n2 = GameApp.div(this.boxerEnergy[n], 0x960000);
        n2 = GameApp.bound((n2 = GameApp.mul(n2, 152917)) < 0 ? -(-n2 >> 16) : n2 >> 16, 0, 2);
        return 2 - n2;
    }

    public void newGame() {
        this.round = 0;
        this.roundsWon[0] = 0;
        this.roundsWon[1] = 0;
        if (gameMode == 1) {
            boxer2 = GameLogic.getOpponentBoxer();
        }
        GameApp.gameScreen.setCharacters(boxer1, boxer2);
        aiDifficulty = this.getAIDifficulty();
        GameScreen.boxer[1].setAILevel(aiDifficulty);
        this.clearStats();
        this.newRound();
    }

    public void clearStats() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < statsPlayer[i].length; ++j) {
                GameLogic.statsPlayer[i][j] = 0;
            }
        }
    }

    public void newBrawlGame(int n) {
        belt = n;
        match = 0;
        this.continues = 5;
        this.initBeltBoxers(boxer1);
        GameApp.gameScreen.loadLevel(belt);
    }

    public void newRound() {
        ++this.round;
        this.roundTime = 0xB4FFFF;
        this.boxerEnergy[0] = 0x960000;
        this.boxerEnergy[1] = 0x960000;
        this.boxerFaceBreakerBar[0] = 0;
        this.boxerFaceBreakerBar[1] = 0;
        this.performedFB = -1;
        GameApp.gameScreen.updateRound();
        GameApp.gameScreen.updateTime();
        GameScreen.boxer[0].numSpecialAttacks = 0;
        GameScreen.boxer[1].numSpecialAttacks = 0;
        if (gameMode == 3) {
            if (this.round == 1) {
                GameApp.gameScreen.resetBoxerPositions();
                this.nextState(3);
            }
        } else {
            GameApp.gameScreen.resetBoxerPositions();
            if (this.round == 1) {
                this.nextState(1);
            } else {
                this.nextState(2);
            }
        }
    }

    public void endRound(int n) {
        if (gameMode != 3 && this.performedFB == -1) {
            this.roundsWon[n] = GameApp.bound(this.roundsWon[n] + 1, 0, 2);
        }
        if (n == 0) {
            FrontEnd.gameJustCompleted = false;
            GameScreen.boxer[0].playAnimation(30, (short)1000);
            if (this.boxerEnergy[1] <= 0) {
                GameScreen.boxer[1].playAnimation(15);
            } else {
                GameScreen.boxer[1].playAnimation(0);
            }
            this.roundEndingDuration = GameApp.max(GameScreen.boxer[0].animator.getDuration(), GameScreen.boxer[1].animator.getDuration());
        } else {
            if (this.boxerEnergy[0] <= 0) {
                GameScreen.boxer[0].playAnimation(15);
            } else {
                GameScreen.boxer[0].playAnimation(0);
            }
            GameScreen.boxer[1].playAnimation(30, (short)1000);
            this.roundEndingDuration = GameApp.max(GameScreen.boxer[0].animator.getDuration(), GameScreen.boxer[1].animator.getDuration());
        }
        this.roundEndingWinner = n;
        this.nextState(4);
    }

    private void roundOver(int n) {
        if (gameMode != 3) {
            if (this.roundsWon[n] >= 2 || this.performedFB > -1) {
                this.gameOver(n);
            } else {
                if (GameScreen.boxer[1 - n].animator.anim_id == 15) {
                    GameScreen.boxer[1 - n].queueAnimation(16);
                }
                this.nextState(5);
            }
        }
    }

    public void gameOver(int n) {
        this.nextState(6);
    }

    public void initBeltBoxers(int n) {
        if (belt == 4) {
            boxers = beltBoxers[belt];
        } else {
            int n2;
            int n3;
            boxers = new int[beltBoxers[belt].length - 1];
            boolean bl = false;
            for (n3 = 0; n3 < beltBoxers[belt].length; ++n3) {
                if (beltBoxers[belt][n3] != n) continue;
                bl = true;
            }
            if (bl) {
                n3 = 0;
                for (n2 = 0; n2 < beltBoxers[belt].length; ++n2) {
                    if (beltBoxers[belt][n2] == n) continue;
                    GameLogic.boxers[n3++] = beltBoxers[belt][n2];
                }
            } else {
                n3 = 0;
                for (n2 = 1; n2 < beltBoxers[belt].length; ++n2) {
                    if (beltBoxers[belt][n2] == n) continue;
                    GameLogic.boxers[n3++] = beltBoxers[belt][n2];
                }
            }
            for (n3 = 0; n3 < boxers.length - 1; ++n3) {
                n2 = GameLogic.randRange(0, boxers.length - 2);
                int n4 = boxers[n3];
                GameLogic.boxers[n3] = boxers[n2];
                GameLogic.boxers[n2] = n4;
            }
        }
    }

    public boolean inCloseRange() {
        return GameApp.abs(GameScreen.boxer[0].actorPos[0] - GameScreen.boxer[1].actorPos[0]) < 0xA00000;
    }

    public boolean inAttackRange() {
        return GameApp.abs(GameScreen.boxer[0].actorPos[0] - GameScreen.boxer[1].actorPos[0]) < 0x800000;
    }

    public int getAttackDamage(int n, int n2, int n3) {
        switch (n) {
            case 3: {
                return 81920;
            }
            case 31: {
                return 81920;
            }
            case 32: {
                return 81920;
            }
            case 6: {
                return 163840;
            }
            case 5: {
                return 131072;
            }
            case 4: {
                return 196608;
            }
            case 19: {
                return 245760;
            }
            case 27: {
                return 0;
            }
            case 20: {
                return 163840;
            }
            case 21: {
                return 229376;
            }
            case 22: {
                return 196608;
            }
            case 23: {
                return 294912;
            }
            case 24: {
                return 0x190000;
            }
            case 25: {
                return 0x320000;
            }
            case 26: {
                return 0x640000;
            }
        }
        return 0;
    }

    public int getHitDuration(int n) {
        switch (n) {
            case 3: {
                return GameApp.stringToFP("0.20");
            }
            case 31: {
                return GameApp.stringToFP("0.15");
            }
            case 32: {
                return GameApp.stringToFP("0.15");
            }
            case 5: {
                return GameApp.stringToFP("0.15");
            }
            case 6: {
                return GameApp.stringToFP("0.2");
            }
            case 19: {
                return GameApp.stringToFP("0.2");
            }
            case 4: {
                return GameApp.stringToFP("0.2");
            }
            case 27: {
                return GameApp.stringToFP("0.1");
            }
            case 20: {
                return GameApp.stringToFP("1.0");
            }
            case 21: {
                return GameApp.stringToFP("1.0");
            }
            case 22: {
                return GameApp.stringToFP("1.0");
            }
            case 23: {
                return GameApp.stringToFP("1.0");
            }
            case 24: {
                return GameApp.stringToFP("1.0");
            }
            case 25: {
                return GameApp.stringToFP("1.0");
            }
            case 26: {
                return GameApp.stringToFP("1.0");
            }
        }
        return 0;
    }

    public static boolean isCollision(int[] nArray, int[] nArray2) {
        return nArray[0] < nArray2[0] + nArray2[2] && nArray[1] < nArray2[1] + nArray2[3] && nArray[0] + nArray[2] > nArray2[0] && nArray[1] + nArray[3] > nArray2[1];
    }

    public boolean doAttack(int n, int n2) {
        int n3 = 1 - n;
        Boxer boxer = GameScreen.boxer[n];
        Boxer boxer2 = GameScreen.boxer[n3];
        boolean bl = GameLogic.isCollision(boxer.rectLeftFist, boxer2.rectBody);
        boolean bl2 = GameLogic.isCollision(boxer.rectRightFist, boxer2.rectBody);
        boolean bl3 = GameLogic.isCollision(boxer.rectLeftFoot, boxer2.rectBody);
        boolean bl4 = GameLogic.isCollision(boxer.rectRightFoot, boxer2.rectBody);
        boolean bl5 = GameLogic.isCollision(boxer.rectHead, boxer2.rectBody);
        if (!(Boxer.isBreakerAttack(n2) || boxer2.animator.anim_id != 15 && boxer2.animator.anim_id != 16 && this.boxerEnergy[n3] != 0)) {
            return false;
        }
        if (Boxer.isBreakerAttack(boxer2.animator.anim_id)) {
            return false;
        }
        if (bl || bl2 || bl3 || bl4 || bl5) {
            int n4;
            int n5;
            int n6 = bl ? 9 : (bl2 ? 6 : (bl3 ? 15 : (bl4 ? 12 : 3)));
            if (this.boxerEnergy[n3] != 0 || !Boxer.isBreakerFinalAnim(n2)) {
                int[] nArray = statsPlayer[n];
                int n7 = n2;
                nArray[n7] = nArray[n7] + 1;
            }
            if (boxer2.animator.anim_id == 9 && n2 != 27 && !Boxer.isBreakerAttack(n2)) {
                int[] nArray = statsPlayer[n3];
                nArray[9] = nArray[9] + 1;
                boxer.doParried(n2);
                boxer.aiSeqPos = -1;
                return true;
            }
            if (n2 == 27) {
                if (!Boxer.isAttackAnim(boxer2.animator.anim_id)) {
                    boxer2.playAnimation(28);
                    this.boxerHit(n3, 27);
                    boxer2.fp_hit_duration = this.getHitDuration(27);
                    boxer2.actorVel[0] = boxer2.actorPos[0] < boxer.actorPos[0] ? -GameApp.mul(917504, 983040) : GameApp.mul(917504, 983040);
                    return true;
                }
                return false;
            }
            if ((boxer2.animator.anim_id == 7 || boxer2.animator.anim_id == 8) && 19 != n2 && !Boxer.isBreakerFinalAnim(n2) && !Boxer.isHitEmAgainAnim(n2) && (boxer2.animator.anim_id == 7 && Boxer.isHighAttack(n2) || boxer2.animator.anim_id == 8 && Boxer.isLowAttack(n2))) {
                int[] nArray = statsPlayer[n3];
                nArray[7] = nArray[7] + 1;
                boxer.fp_hit_duration = 16384;
                boxer2.actorVel[0] = boxer2.actorPos[0] < boxer.actorPos[0] ? -GameApp.mul(0x100000, 196608) : GameApp.mul(0x100000, 196608);
                ++boxer.aiWasBlockedCount;
                return true;
            }
            if (Boxer.isBreakerAttack(n2)) {
                if (Boxer.isBreakerFinalAnim(n2)) {
                    boxer2.playAnimation(15);
                    if (this.boxerEnergy[n3] > 0 && (n3 != 1 || gameMode != 1 || GameLogic.getOpponentBoxer() != 8)) {
                        boxer2.queueAnimation(16);
                    }
                } else if (Boxer.isHighAttack(n2)) {
                    boxer2.playAnimation(18);
                } else {
                    boxer2.playAnimation(13);
                }
                this.boxerHit(n3, n2);
                if (boxer.actorCharacter == 7 && n2 == 24) {
                    boxer.fp_hit_duration = 21845;
                }
                boxer2.fp_hit_duration = this.getHitDuration(n2);
                boxer2.actorVel[0] = boxer2.actorPos[0] < boxer.actorPos[0] ? -GameApp.mul(917504, 655360) : GameApp.mul(917504, 655360);
            } else {
                if (Boxer.isHighAttack(n2)) {
                    if (n2 == 3 || n2 == 31 || n2 == 32) {
                        boxer2.playAnimation(11);
                    } else if (n2 == 19) {
                        boxer2.playAnimation(13);
                    } else {
                        boxer2.playAnimation(12);
                    }
                    this.boxerHit(n3, n2);
                    boxer2.fp_hit_duration = this.getHitDuration(n2);
                } else if (Boxer.isLowAttack(n2)) {
                    if (n2 == 4) {
                        boxer2.playAnimation(33);
                    } else {
                        n5 = boxer.actorCharacter;
                        n4 = boxer2.actorCharacter;
                        boxer2.playAnimation(14);
                    }
                    this.boxerHit(n3, n2);
                    boxer2.fp_hit_duration = this.getHitDuration(n2);
                }
                boxer2.actorVel[0] = boxer2.actorPos[0] < boxer.actorPos[0] ? -GameApp.mul(0x100000, 262144) : GameApp.mul(0x100000, 262144);
            }
            if (Boxer.isAttackAnim(n2)) {
                n5 = boxer.getBoneX(n6);
                n4 = boxer.getBoneY(n6);
                if (!Boxer.isBreakerAttack(n2)) {
                    this.boxerFaceBreakerBar[n] = GameApp.bound(this.boxerFaceBreakerBar[n] + this.getAttackDamage(n2, n, n3), 0, 0x5A0000);
                }
                this.processAttackCommon(n2, n);
            }
            return true;
        }
        return false;
    }

    private void processAttackCommon(int n, int n2) {
        Boxer boxer = GameScreen.boxer[n2];
        if (n == 26) {
            int n3 = n2;
            this.roundsWon[n3] = this.roundsWon[n3] + 1;
            this.boxerEnergy[1 - n2] = 0;
            this.performedFB = n2;
        }
    }

    private int getAIHitPointBoost(int n) {
        int n2 = GameScreen.boxer[n].aiLevel;
        n2 = GameApp.bound(n2, 0, cAIHitPointBoost.length);
        return cAIHitPointBoost[n2];
    }

    public void boxerHit(int n, int n2) {
        boolean bl;
        boolean bl2;
        int n3 = 1 - n;
        int n4 = this.getAttackDamage(n2, n3, n);
        int n5 = 50;
        if (n2 == 3 || n2 == 3 || n2 == 3) {
            n5 = this.getBoxerStat(n3, 2);
        } else if (Boxer.isHighAttack(n2)) {
            n5 = this.getBoxerStat(n3, 3);
        } else if (Boxer.isLowAttack(n2)) {
            n5 = this.getBoxerStat(n3, 4);
        }
        n4 = n4 * 50 / n5;
        n4 = n4 * 50 / this.getBoxerStat(n, 11);
        n4 = n4 * 50 / this.getAIHitPointBoost(n);
        boolean bl3 = bl2 = this.boxerEnergy[n] > 0x320000;
        if (n != 0 || !GameScreen.godMode) {
            this.boxerFaceBreakerBar[n] = 0;
        }
        GameScreen.boxer[n].notifyHit(n4);
        boolean bl4 = bl = this.boxerEnergy[n] > 0;
        if (n != 0 || !GameScreen.godMode) {
            this.boxerEnergy[n] = GameApp.bound(this.boxerEnergy[n] - n4, 0, 0x960000);
        }
        if (FrontEnd.vibrate) {
            SDKSoundManager.getManager().vibrate((n4 < 0 ? -(-n4 >> 16) : n4 >> 16) * 2);
        }
        if (this.boxerEnergy[n] == 0 && bl) {
            GameApp.gameScreen.doScreenFlash((byte)2);
            if (Boxer.isHitEmAgainAnim(n2)) {
                int n6 = n2 + 1;
                while (Boxer.isHitEmAgainAnim(n6)) {
                    ++n6;
                }
                int[] nArray = statsPlayer[n3];
                int n7 = n6;
                nArray[n7] = nArray[n7] + 1;
            }
        }
    }

    public void nextState(int n) {
        this.state = n;
        GameApp.gameScreen.onNextState(n);
        switch (this.state) {
            case 1: {
                if (!GameScreen.boxer[0].isAnimationQueued(16)) {
                    GameScreen.boxer[0].stopAnimation();
                }
                if (GameScreen.boxer[1].isAnimationQueued(16)) break;
                GameScreen.boxer[1].stopAnimation();
            }
        }
    }

    public void process() {
        if (this.state == 3) {
            int n;
            this.roundTime -= GameApp.mul(GameApp.fp_deltatime, 98304);
            this.roundTime = GameApp.bound(this.roundTime, 0, 0xB50000);
            GameApp.gameScreen.updateTime();
            if (gameMode == 3) {
                if (this.boxerEnergy[0] <= 0) {
                    this.boxerEnergy[0] = 0x960000;
                }
                if (this.boxerEnergy[1] <= 0) {
                    this.boxerEnergy[1] = 0x960000;
                }
            } else {
                if (this.roundTime <= 0) {
                    this.roundTime = 0;
                    n = this.boxerEnergy[0] > this.boxerEnergy[1] ? 0 : 1;
                    this.endRound(n);
                }
                n = GameScreen.boxer[0].animator.anim_id;
                int n2 = GameScreen.boxer[1].animator.anim_id;
                if (!Boxer.isBreakerAttack(n) && !Boxer.isBreakerAttack(n2)) {
                    for (int i = 0; i < 2; ++i) {
                        if (this.boxerEnergy[i] != 0) continue;
                        this.endRound(1 - i);
                    }
                }
            }
            for (n = 0; n < 2; ++n) {
                if (this.boxerEnergy[n] <= 0 || this.boxerEnergy[n] >= 0x320000) continue;
                this.boxerEnergy[n] = GameApp.bound(this.boxerEnergy[n] + GameApp.fp_deltatime * 2, 0, 0x320000);
            }
        } else if (this.state == 4) {
            if (this.roundEndingDuration > 0) {
                this.roundEndingDuration -= GameApp.fp_deltatime;
            } else {
                this.roundOver(this.roundEndingWinner);
            }
        }
    }

    public void saveGame(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(this.continues);
            dataOutputStream.writeInt(boxer1);
            dataOutputStream.writeInt(belt);
            dataOutputStream.writeInt(match);
            dataOutputStream.writeInt(boxers.length);
            for (int i = 0; i < boxers.length; ++i) {
                dataOutputStream.writeInt(boxers[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadGame(DataInputStream dataInputStream) {
        try {
            this.continues = dataInputStream.readInt();
            boxer1 = dataInputStream.readInt();
            belt = dataInputStream.readInt();
            match = dataInputStream.readInt();
            int n = dataInputStream.readInt();
            boxers = new int[n];
            for (int i = 0; i < n; ++i) {
                GameLogic.boxers[i] = dataInputStream.readInt();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String[] loadCSV(String string, Vector vector) {
        String[] stringArray = null;
        try {
            Object[] objectArray;
            int n;
            InputStream inputStream = GameApp.instance.getClass().getResourceAsStream(string);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n2 = dataInputStream.readShort();
            int n3 = dataInputStream.readShort();
            stringArray = new String[n2];
            byte[] byArray = new byte[n2];
            block10: for (n = 0; n < n2; ++n) {
                stringArray[n] = dataInputStream.readUTF();
                byArray[n] = dataInputStream.readByte();
                switch (byArray[n]) {
                    case 1: {
                        objectArray = new String[n3];
                        vector.addElement(objectArray);
                        continue block10;
                    }
                    case 2: {
                        objectArray = new byte[n3];
                        vector.addElement(objectArray);
                        continue block10;
                    }
                    default: {
                        throw new Exception("Error - unknown datatype in binary CSV file: " + byArray[n]);
                    }
                }
            }
            block11: for (n = 0; n < n2; ++n) {
                switch (byArray[n]) {
                    case 1: {
                        int n4;
                        objectArray = (String[])vector.elementAt(n);
                        for (n4 = 0; n4 < n3; ++n4) {
                            objectArray[n4] = dataInputStream.readUTF();
                        }
                        continue block11;
                    }
                    case 2: {
                        int n4;
                        objectArray = (byte[])vector.elementAt(n);
                        for (n4 = 0; n4 < n3; ++n4) {
                            objectArray[n4] = (String)dataInputStream.readByte();
                        }
                        continue block11;
                    }
                    default: {
                        throw new Exception("Error - unknown datatype in binary CSV file: " + byArray[n]);
                    }
                }
            }
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return stringArray;
    }

    public static byte[] getCSVByteArray(Vector vector, int n) {
        return (byte[])vector.elementAt(n);
    }

    public static String[] getCSVStringArray(Vector vector, int n) {
        return (String[])vector.elementAt(n);
    }

    static {
        boxer1 = 0;
        boxer2 = 1;
        aiDifficulty = 1;
        belt = 0;
        match = 0;
        vecStatsData = new Vector();
        vecMovesData = new Vector();
    }
}

