/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gfx;

import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import java.util.Vector;

public class ImageSequence {
    public static final int IS_X = 0;
    public static final int IS_Y = 1;
    public static final int IS_WIDTH = 2;
    public static final int IS_HEIGHT = 3;
    public static final int IS_OFFSETX = 4;
    public static final int IS_OFFSETY = 5;
    public static final int IS_ORIGWIDTH = 6;
    public static final int IS_ORIGHEIGHT = 7;
    public static final int IS_MAX = 8;
    byte flags;
    public int numFrames;
    public int currentFrame;
    public short[] clipRects;
    public byte clipRectsStride;
    public Vector vecImageFilenames = new Vector();
    public SDKImage[] imageFrame;
    public byte[] imageIndex;
    private static int[] tempClip = new int[4];
    private static int[] clip = new int[4];
    public static boolean clipSet = false;

    public void setup(byte by, int n, int n2) {
        this.flags = by;
        this.numFrames = n;
        if ((this.flags & 2) != 0) {
            // empty if block
        }
        this.clipRectsStride = (byte)((this.flags & 2) != 0 ? 8 : 4);
        this.clipRects = new short[this.numFrames * this.clipRectsStride];
        if (n2 > 1) {
            this.imageIndex = new byte[this.numFrames];
        }
        this.imageFrame = new SDKImage[n2];
    }

    public short getRectWidth(int n) {
        if ((this.flags & 2) != 0) {
            return this.clipRects[n * this.clipRectsStride + 6];
        }
        return this.clipRects[n * this.clipRectsStride + 2];
    }

    public short getRectHeight(int n) {
        if ((this.flags & 2) != 0) {
            return this.clipRects[n * this.clipRectsStride + 7];
        }
        return this.clipRects[n * this.clipRectsStride + 3];
    }

    public short getClipRectX(int n) {
        return this.clipRects[n * this.clipRectsStride + 0];
    }

    public short getClipRectY(int n) {
        return this.clipRects[n * this.clipRectsStride + 1];
    }

    public short getClipRectWidth(int n) {
        return this.clipRects[n * this.clipRectsStride + 2];
    }

    public short getClipRectHeight(int n) {
        return this.clipRects[n * this.clipRectsStride + 3];
    }

    private short getOffsetX(int n) {
        if ((this.flags & 2) != 0) {
            return this.clipRects[n * this.clipRectsStride + 4];
        }
        return 0;
    }

    private short getOffsetY(int n) {
        if ((this.flags & 2) != 0) {
            return this.clipRects[n * this.clipRectsStride + 5];
        }
        return 0;
    }

    public void setRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.clipRects[n * this.clipRectsStride + 0] = (short)n2;
        this.clipRects[n * this.clipRectsStride + 1] = (short)n3;
        this.clipRects[n * this.clipRectsStride + 2] = (short)n4;
        this.clipRects[n * this.clipRectsStride + 3] = (short)n5;
        if ((2 & this.flags) != 0) {
            this.clipRects[n * this.clipRectsStride + 4] = (short)n6;
            this.clipRects[n * this.clipRectsStride + 5] = (short)n7;
            this.clipRects[n * this.clipRectsStride + 6] = (short)n8;
            this.clipRects[n * this.clipRectsStride + 7] = (short)n9;
        }
    }

    public int addImageIfNew(String string) {
        int n = this.getImageIndex(string);
        if (n == -1) {
            n = this.vecImageFilenames.size();
            this.vecImageFilenames.addElement(string);
        }
        return n;
    }

    public int getImageIndex(String string) {
        for (int i = 0; i < this.vecImageFilenames.size(); ++i) {
            String string2 = (String)this.vecImageFilenames.elementAt(i);
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public SDKImage getImage(int n) {
        if (this.imageIndex == null) {
            return this.imageFrame[0];
        }
        return this.imageFrame[this.imageIndex[n]];
    }

    public static ImageSequence createFromImage(String string) {
        ImageSequence imageSequence = new ImageSequence();
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        imageSequence.addImageIfNew(string);
        imageSequence.setup((byte)0, 1, 1);
        imageSequence.imageFrame[0] = ImageSet.loadImage("/" + string);
        if (imageSequence.imageFrame[0] != null) {
            imageSequence.setRect(0, 0, 0, imageSequence.imageFrame[0].getWidth(), imageSequence.imageFrame[0].getHeight(), 0, 0, 0, 0);
        } else {
            imageSequence.setRect(0, 0, 0, 0, 0, 0, 0, 0, 0);
        }
        return imageSequence;
    }

    public void unload() {
        for (int i = 0; i < this.imageFrame.length; ++i) {
            this.imageFrame[i] = null;
        }
    }

    public void reload() {
        for (int i = 0; i < this.vecImageFilenames.size(); ++i) {
            String string = (String)this.vecImageFilenames.elementAt(i);
            if (this.imageFrame[i] != null) continue;
            this.imageFrame[i] = ImageSet.loadImage("/" + string);
        }
    }

    public void drawImage(SDKGraphics sDKGraphics, int n, int n2, int n3) {
        if ((2 & this.flags) != 0) {
            n2 += this.getOffsetX(n);
            n3 += this.getOffsetY(n);
        }
        ImageSequence.tempClip[0] = ScreenStack.visibleRect.x0;
        ImageSequence.tempClip[1] = ScreenStack.visibleRect.y0;
        ImageSequence.tempClip[2] = ScreenStack.visibleRect.w;
        ImageSequence.tempClip[3] = ScreenStack.visibleRect.h;
        this.drawImageClipped(sDKGraphics, n, n2, n3, tempClip);
    }

    public void drawImageTrans(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4) {
        try {
            if (this.getImage(n) == null) {
                return;
            }
            if (n2 + this.getClipRectWidth(n) > ScreenStack.visibleRect.x0 && n2 - ScreenStack.visibleRect.x0 < ScreenStack.displayWidth && n3 + this.getClipRectHeight(n) > ScreenStack.visibleRect.y0 && n3 - ScreenStack.visibleRect.y0 < ScreenStack.displayHeight) {
                if (clipSet) {
                    sDKGraphics.setClip(0, 0, ScreenStack.displayWidth * 2, ScreenStack.displayHeight * 2);
                    clipSet = false;
                }
                int n5 = GameApp.min(this.getClipRectX(n) + this.getClipRectWidth(n), this.getImage(n).getWidth()) - this.getClipRectX(n);
                int n6 = GameApp.min(this.getClipRectY(n) + this.getClipRectHeight(n), this.getImage(n).getHeight()) - this.getClipRectY(n);
                sDKGraphics.drawRegion(this.getImage(n), this.getClipRectX(n), this.getClipRectY(n), n5, n6, n4, n2, n3, 20);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawImageClipped(SDKGraphics sDKGraphics, int n, int n2, int n3, int[] nArray) {
        try {
            if (this.getImage(n) == null) {
                return;
            }
            ImageSequence.clip[0] = GameApp.max(n2, nArray[0]);
            ImageSequence.clip[1] = GameApp.max(n3, nArray[1]);
            int n4 = GameApp.min(this.getClipRectX(n) + this.getClipRectWidth(n), this.getImage(n).getWidth()) - this.getClipRectX(n);
            int n5 = GameApp.min(this.getClipRectY(n) + this.getClipRectHeight(n), this.getImage(n).getHeight()) - this.getClipRectY(n);
            ImageSequence.clip[2] = GameApp.min(n2 + n4, nArray[0] + nArray[2]) - clip[0];
            ImageSequence.clip[3] = GameApp.min(n3 + n5, nArray[1] + nArray[3]) - clip[1];
            if (clip[2] > 0 && clip[3] > 0) {
                if (clipSet) {
                    sDKGraphics.setClip(0, 0, ScreenStack.displayWidth * 2, ScreenStack.displayHeight * 2);
                    clipSet = false;
                }
                sDKGraphics.drawRegion(this.getImage(n), this.getClipRectX(n) + (clip[0] - n2), this.getClipRectY(n) + (clip[1] - n3), clip[2], clip[3], 0, clip[0], clip[1], 20);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

