/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.ea.sdk.ResourceLoader;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKMoreGames;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKUtils;
import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.game.GameLogic;
import com.slg.j2me.game.GameScreen;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class GameApp
implements ResourceLoader,
Runnable {
    public static GameApp instance = null;
    public static boolean drawingEnabled = true;
    public static boolean loaded = false;
    public static boolean applicationPaused = false;
    public static boolean isLoading = false;
    public static boolean lastDrawnScreenWasLoading = false;
    public static long startingMemory = 0L;
    public static long logoTime;
    public static long timeLastFrame;
    public static int lastFrameTime;
    public static int fp_deltatime;
    public static GameScreen gameScreen;
    public static FrontEnd frontEnd;
    public static GameLogic gameLogic;
    public static boolean optionsLoaded;
    public static final int eTuneMenu = 0;
    public static boolean soundIsPlaying;
    public static final String[] sfxfiles;
    protected static SDKCanvas canvas;
    public static boolean bMoreGamesActive;
    public static final String strMGTheSimpsons2 = "SMSNS2";
    public static SDKMoreGames mgInstance;
    private static final int MAX_BLOCK_SIZE = 32768;
    private static final byte[] blockBuf;

    public byte[] loadResource(int n) {
        return GameApp.getResourceFromJar(sfxfiles[n]);
    }

    public static synchronized RecordStore RS_open(String string) {
        try {
            return RecordStore.openRecordStore((String)string, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            return null;
        }
    }

    public static synchronized void RS_delete(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public static synchronized boolean RS_exists(String string) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            if (recordStore != null) {
                recordStore.closeRecordStore();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public GameApp(SDKCanvas sDKCanvas) {
        instance = this;
        canvas = sDKCanvas;
        GameApp.gc();
        startingMemory = Runtime.getRuntime().freeMemory();
        GameApp.printMemoryStatus("Application()");
        ScreenStack.setDefaultRes(240, 320);
        SDKSoundManager.getManager().setLoader(this);
        frontEnd = new FrontEnd();
        frontEnd.setBackgroundColour(0xFFFFFF);
        ScreenStack.setCurrent(frontEnd);
        frontEnd.loadImage("/ea_logo.png");
        logoTime = System.currentTimeMillis();
        this.backgroundLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOptions() {
        block14: {
            if (GameApp.optionsExists()) {
                RecordStore recordStore = null;
                try {
                    recordStore = GameApp.RS_open("frontEnd");
                    if (recordStore == null) break block14;
                    byte[] byArray = null;
                    ByteArrayInputStream byteArrayInputStream = null;
                    FilterInputStream filterInputStream = null;
                    try {
                        byArray = recordStore.getRecord(1);
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        filterInputStream = new DataInputStream(byteArrayInputStream);
                        frontEnd.loadOptions((DataInputStream)filterInputStream);
                    }
                    catch (Exception exception) {
                        recordStore.closeRecordStore();
                    }
                    finally {
                        try {
                            byteArrayInputStream.close();
                            filterInputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void load() {
        try {
            frontEnd.loadFonts();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initMoreGames();
        try {
            frontEnd.startup();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GameApp.printMemoryStatus("GameApp.load() pre frontEnd.loadTitleScreen()");
        frontEnd.loadTitleScreen();
        try {
            gameLogic = new GameLogic();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            gameScreen = new GameScreen(gameLogic);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GameApp.autoLoad();
    }

    public void process() {
        if (loaded) {
            if (bMoreGamesActive) {
                if (!mgInstance.isActive()) {
                    bMoreGamesActive = false;
                } else {
                    mgInstance.update();
                }
            } else {
                frontEnd.process();
            }
        }
    }

    public void init() {
        if (loaded) {
            GameApp.autoLoad();
        }
        if (applicationPaused) {
            this.unPause();
        }
    }

    public void pauseApp() {
        this.doPause();
    }

    public void doPause() {
        if (!applicationPaused) {
            if (soundIsPlaying) {
                SDKSoundManager.getManager().stopSounds();
                soundIsPlaying = false;
            }
            GameApp.autoSave();
        }
        applicationPaused = true;
    }

    public void unPause() {
        if (applicationPaused) {
            applicationPaused = false;
            ScreenStack.openPauseDialog();
            ScreenStack.resetKeys();
            if (ScreenStack.currentContainer == gameScreen) {
                if (!GameScreen.isPaused && gameScreen != null) {
                    gameScreen.doPauseMenu();
                }
            }
        }
    }

    public void resumeSound() {
        if (ScreenStack.currentContainer == gameScreen) {
            gameScreen.setupSound();
        } else {
            frontEnd.setupSound();
        }
    }

    public static boolean optionsExists() {
        return GameApp.RS_exists("frontEnd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadGame() {
        block13: {
            RecordStore recordStore = null;
            try {
                recordStore = GameApp.RS_open("game");
                if (recordStore == null) break block13;
                byte[] byArray = null;
                ByteArrayInputStream byteArrayInputStream = null;
                FilterInputStream filterInputStream = null;
                try {
                    byArray = recordStore.getRecord(1);
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    filterInputStream = new DataInputStream(byteArrayInputStream);
                    GameApp.loadGame((DataInputStream)filterInputStream);
                }
                catch (Exception exception) {
                    recordStore.closeRecordStore();
                }
                finally {
                    try {
                        byteArrayInputStream.close();
                        filterInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean gameExists() {
        return GameApp.RS_exists("game");
    }

    public static void deleteGame() {
        GameApp.RS_delete("game");
    }

    public static void loadGame(DataInputStream dataInputStream) {
        try {
            gameLogic.loadGame(dataInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void saveGame(DataOutputStream dataOutputStream) {
        try {
            gameLogic.saveGame(dataOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveGame() {
        block9: {
            GameApp.RS_delete("game");
            try {
                RecordStore recordStore = GameApp.RS_open("game");
                if (recordStore == null) break block9;
                ByteArrayOutputStream byteArrayOutputStream = null;
                FilterOutputStream filterOutputStream = null;
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                    GameApp.saveGame((DataOutputStream)filterOutputStream);
                    recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                }
                finally {
                    try {
                        byteArrayOutputStream.close();
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void autoLoad() {
    }

    public static void autoSave() {
        GameApp.saveOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveOptions() {
        block9: {
            GameApp.RS_delete("frontEnd");
            try {
                RecordStore recordStore = GameApp.RS_open("frontEnd");
                if (recordStore == null) break block9;
                ByteArrayOutputStream byteArrayOutputStream = null;
                FilterOutputStream filterOutputStream = null;
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                    frontEnd.saveOptions((DataOutputStream)filterOutputStream);
                    recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                }
                finally {
                    try {
                        byteArrayOutputStream.close();
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void appKeyPressed(int n, long l) {
        byte by;
        ScreenStack.onKeyPressed(n);
        if (bMoreGamesActive && (by = mgInstance.processKey(n)) == 1) {
            FrontEnd.controlMoreGames.hidden = !mgInstance.isAvailable();
            FrontEnd.menuMain.layout();
        }
    }

    public void appKeyReleased(int n, long l) {
        ScreenStack.onKeyReleased(n);
    }

    public void initMoreGames() {
        mgInstance = new SDKMoreGames(ScreenStack.displayWidth, ScreenStack.displayHeight);
        mgInstance.setProductData(GameApp.loadAsByteArray("/moregames"));
        Object[] objectArray = new Object[5];
        objectArray[0] = FrontEnd.fontBlack.sdkFont;
        objectArray[3] = FrontEnd.fontBlack.sdkFont;
        objectArray[4] = FrontEnd.fontBlack.sdkFont;
        objectArray[1] = FrontEnd.fontBlack.sdkFont;
        objectArray[2] = Font.getDefaultFont();
        mgInstance.setFonts(objectArray);
    }

    public static void openMoreGames() {
        try {
            SDKUtils.loadStringsChunk(2);
            mgInstance.reset("mnu");
            bMoreGamesActive = true;
        }
        catch (Exception exception) {
            System.out.println("Exception in openMoreGames(): " + exception);
            exception.printStackTrace();
        }
    }

    public static byte[] loadAsByteArray(String string) {
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            inputStream = "".getClass().getResourceAsStream(string);
            int n = inputStream.available();
            byArray = new byte[n];
            inputStream.read(byArray, 0, n);
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("loadAsByteArray():" + exception);
        }
        return byArray;
    }

    public static void printMemoryStatus(String string) {
        GameApp.gc();
    }

    public static byte[] getResourceFromJar(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = instance.getClass().getResourceAsStream(string);
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void waitForLogoTimeout() {
        long l = System.currentTimeMillis();
        long l2 = 2500L - (l - logoTime);
        if (l2 > 0L) {
            try {
                Thread.sleep(l2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logoTime = System.currentTimeMillis();
    }

    protected final void backgroundLoad() {
        try {
            Thread thread = new Thread(this);
            thread.start();
        }
        catch (Error error) {
            GameApp.quit();
        }
    }

    public static void setAppLoading() {
        if (!lastDrawnScreenWasLoading) {
            isLoading = true;
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ScreenStack.forcePaint();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void run() {
        this.load();
        ScreenStack.resetKeys();
        loaded = true;
        timeLastFrame = System.currentTimeMillis();
    }

    public void processInternal() {
        if (applicationPaused) {
            try {
                this.wait(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            timeLastFrame = System.currentTimeMillis();
            return;
        }
        long l = System.currentTimeMillis();
        if (isLoading) {
            isLoading = false;
            timeLastFrame = l;
        }
        lastFrameTime = (int)(l - timeLastFrame);
        timeLastFrame = l;
        lastFrameTime = GameApp.bound(lastFrameTime, 10, 100);
        fp_deltatime = lastFrameTime * 66;
        if (ScreenStack.pauseDialogShown) {
            lastFrameTime = 0;
            fp_deltatime = 0;
        }
        ScreenStack.beginInputProcessing();
        try {
            this.process();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ScreenStack.endInputProcessing();
    }

    public static final void quit() {
        SDKMIDlet.exit();
        instance = null;
    }

    public static final void gc() {
        System.gc();
    }

    public static final String formatNumber(int n, int n2, char c) {
        String string = "";
        int n3 = 1;
        for (int i = 1; i < n2; ++i) {
            if (n / n3 < 10) {
                string = string + c;
            }
            n3 *= 10;
        }
        if (n == 0) {
            return string + c;
        }
        return string + n;
    }

    public static byte[] loadBlock(String string) {
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            inputStream = "".getClass().getResourceAsStream(string);
            if (inputStream != null) {
                int n = inputStream.read(blockBuf);
                int n2 = 0;
                int n3 = 32768;
                while (n > 0) {
                    n = inputStream.read(blockBuf, n2 += n, n3 -= n);
                }
                inputStream.close();
                byArray = new byte[n2];
                System.arraycopy(blockBuf, 0, byArray, 0, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    public void pause() {
        this.doPause();
    }

    public void resume() {
        this.unPause();
    }

    public void update(long l) {
        this.processInternal();
    }

    public void draw(SDKGraphics sDKGraphics) {
        if (drawingEnabled) {
            ScreenStack.paintCurrent(sDKGraphics);
        }
    }

    public void exiting() {
    }

    public void appPointerDragged(int n, int n2, long l) {
    }

    public void appPointerReleased(int n, int n2, long l) {
    }

    public void appPointerPressed(int n, int n2, long l) {
    }

    public void appLetterPressed(int n, long l) {
    }

    public void appLetterReleased(int n, long l) {
    }

    public static final int mulp(int n, int n2) {
        return (int)((long)n * (long)n2 >> 16);
    }

    public static final int mul(int n, int n2) {
        return ((n ^ n2) & 0x8000000) != 0 ? -GameApp.mulp(-n, n2) : GameApp.mulp(n, n2);
    }

    public static final int div(int n, int n2) {
        return (int)(((long)n << 16) / (long)n2);
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static final short max(short s, short s2) {
        return s > s2 ? s : s2;
    }

    public static final int bound(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static final short bound(short s, short s2, short s3) {
        return s < s2 ? s2 : (s > s3 ? s3 : s);
    }

    public static final int sign(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public static final int linearInterpolate(int n, int n2, int n3) {
        int n4 = GameApp.bound(n, 0, 65536);
        int n5 = n3 - n2;
        return GameApp.mul(n5, n4) + n2;
    }

    public static final int sinLut(int n) {
        if ((n &= 0xFFFFFF) < 0x400000) {
            return n >> 6;
        }
        if (n < 0x800000) {
            return 65536 - (n - 0x400000 >> 6);
        }
        if (n < 0xC00000) {
            return -(n - 0x800000 >> 6);
        }
        return -(65536 - (n - 0xC00000 >> 6));
    }

    public static final String toString_fp(int n) {
        long l;
        boolean bl;
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        String string = (l = (long)(n & 0xFFFF) * 100000L / 65536L) < 10L ? "0000" : (l < 100L ? "000" : (l < 1000L ? "00" : (l < 10000L ? "0" : "")));
        return (bl ? "-" : "") + (n >> 16) + "." + string + l;
    }

    public static final int stringToFP(String string) {
        long l = 0L;
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                if (n != 0) {
                    // empty if block
                }
                n = 1;
                continue;
            }
            if (c == '-') {
                if (bl || l != 0L) {
                    // empty if block
                }
                bl = true;
                continue;
            }
            if (c < '0' || c > '9') continue;
            l *= 10L;
            n *= 10;
            l += (long)(c - 48);
        }
        if (bl) {
            l = -l;
        }
        if (n > 1) {
            return GameApp.div((int)l, n);
        }
        return (int)l < 0 ? -(-((int)l) << 16) : (int)l << 16;
    }

    static {
        timeLastFrame = System.currentTimeMillis();
        lastFrameTime = 20;
        fp_deltatime = 0;
        gameScreen = null;
        frontEnd = null;
        gameLogic = null;
        optionsLoaded = false;
        soundIsPlaying = false;
        sfxfiles = new String[]{"/menu.mid"};
        canvas = null;
        bMoreGamesActive = false;
        blockBuf = new byte[32768];
    }
}

