/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.game.GameLogic;
import com.slg.j2me.game.GameScreen;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import java.io.DataInputStream;
import java.io.InputStream;

class Boxer {
    GameLogic game;
    Boxer animator = this;
    public int actorCharacter = -1;
    public int playerIndex;
    public int[] actorPos = new int[2];
    public int[] actorVel = new int[2];
    public int[] rectBody = new int[4];
    public int[] rectLeftFist = new int[4];
    public int[] rectHead = this.rectLeftFist;
    public int[] rectRightFist = this.rectLeftFist;
    public int[] rectLeftFoot = this.rectLeftFist;
    public int[] rectRightFoot = this.rectLeftFist;
    public boolean dashing = false;
    public int facing = 0;
    public int glowKeyTime = 0;
    public int glowAnimTime = 0;
    public int fp_delay_time = 0;
    public int delayCount = 0;
    public static final int delayDuration = 1024;
    public int fp_parry_wait = 0;
    public static final int cParryWaitDuration = 32768;
    private boolean heldOnLastFrame = false;
    public int fp_hit_duration = 0;
    public int fp_held_duration = 0;
    public int specialFPS = 12;
    private boolean startAttack = false;
    public static boolean performingFB = false;
    public byte stunnedRecoveryCounter;
    public int walkSpeed = 65536;
    public static final int cWalkPixelsPerSec = 0x800000;
    public static int cfpFloorHeight = 0;
    public static final int cActorDrag = 0x2000000;
    public static final int cActorRestitution = 16384;
    public static final int cActorGravity = GameApp.stringToFP("500.0");
    public static final int cActorPushBack = 0x100000;
    public static final int cActorPushBreaker = 917504;
    public static final int cActorLift = 0x100000;
    public static final int cFistGlowTime = 32768;
    public static final int cActorRopeBounce = 0x400000;
    public static final int eAnimStand = 0;
    public static final int eAnimWalkForward = 1;
    public static final int eAnimWalkBack = 2;
    public static final int eAnimPunchJab1 = 3;
    public static final int eAnimPunchLowStrong = 4;
    public static final int eAnimPunchLow = 5;
    public static final int eAnimPunchCross = 6;
    public static final int eAnimBlockHigh = 7;
    public static final int eAnimBlockLow = 8;
    public static final int eAnimParry = 9;
    public static final int eAnimDodge = 10;
    public static final int eAnimHitJab = 11;
    public static final int eAnimHitHigh = 12;
    public static final int eAnimHitHard = 13;
    public static final int eAnimHitLow = 14;
    public static final int eAnimFall = 15;
    public static final int eAnimGetUp = 16;
    public static final int eAnimStunned = 17;
    public static final int eAnimHitIntoAir = 18;
    public static final int eAnimPunchHighStrong = 19;
    public static final int eAnimGroundBreaker1 = 20;
    public static final int eAnimGroundBreaker2 = 21;
    public static final int eAnimSkyBreaker1 = 22;
    public static final int eAnimSkyBreaker2 = 23;
    public static final int eAnimFaceBreaker1 = 24;
    public static final int eAnimFaceBreaker2 = 25;
    public static final int eAnimFaceBreaker3 = 26;
    public static final int eAnimThrow = 27;
    public static final int eAnimThrown = 28;
    public static final int eAnimGrab = 29;
    public static final int eAnimCelebrate = 30;
    public static final int eAnimPunchJab2 = 31;
    public static final int eAnimPunchJab3 = 32;
    public static final int eAnimHitLowHard = 33;
    public static final int eAnimPowerUp = 34;
    public static final int eAnimSpecial = 99;
    public static final int eAnimSpecial2 = 99;
    public static final int eAnimMax = 35;
    public static final String[] animExportNames = new String[]{"Stand", "WalkForward", "WalkBack", "PunchJab1", "PunchLowStrong", "PunchLow", "PunchCross", "BlockHigh", "BlockLow", "Parry", "Dodge", "HitJab", "HitHigh", "HitHard", "HitLow", "Fall", "GetUp", "Stunned", "HitIntoAir", "PunchHighStrong", "GroundBreaker1", "GroundBreaker2", "SkyBreaker1", "SkyBreaker2", "FaceBreaker1", "FaceBreaker2", "FaceBreaker3", "Throw", "Thrown", "Grab", "Celebrate", "PunchJab2", "PunchJab3", "HitLowHard", "PowerUp"};
    public static final int Waist = 0;
    public static final int Abdomen = 1;
    public static final int Chest = 2;
    public static final int Head = 3;
    public static final int RightUpperArm = 4;
    public static final int RightForeArm = 5;
    public static final int RightFist = 6;
    public static final int LeftUpperArm = 7;
    public static final int LeftForeArm = 8;
    public static final int LeftFist = 9;
    public static final int RightThigh = 10;
    public static final int RightLeg = 11;
    public static final int RightFoot = 12;
    public static final int LeftThigh = 13;
    public static final int LeftLeg = 14;
    public static final int LeftFoot = 15;
    public static final String[] strBoxerFiles = new String[]{"romeo", "spin", "kiriko", "voodoo", "steve", "socks", "sparrow", "molotov", "pummel"};
    public int numSpecialAttacks = 0;
    public static final int[][] comboSequences = new int[][]{{22, 16, 23}, {20, 16, 21}, {24, 16, 25}, {25, 16, 26}, {6, 16, 3}, {32, 16, 6}, {31, 16, 32}, {3, 16, 31}, {5, 8, 4}, {4, 8, 5}, {3, 8, 5}, {31, 8, 5}, {32, 8, 4}, {6, 8, 4}, {0, 4, 27}, {0, 1, 19}, {0, 16, 3}, {0, 8, 5}};
    private boolean doubleTapLeft = false;
    private boolean doubleTapRight = false;
    public static final int cDoubleTapTime = 500;
    private long lastLeftTap = 0L;
    private long lastRightTap = 0L;
    private long lastAttackDown = 0L;
    private static final short[] cPerCharacterTauntLoopCount = new short[]{1, 0, 4, 5, 0, 0, 3, 0, 5};
    private boolean lastAttackWasSuccessful = false;
    private int fp_AI_timer = 0;
    private int aiDecisionTime = 0;
    public int aiLevel = 0;
    public int aiMood = 0;
    public int aiSeqType = 0;
    public int aiSeqPos = 0;
    private int aiBlockCount = 0;
    private int aiBlockParryLimit = 0;
    private static final int[] cAIDecisionTime = new int[]{GameApp.stringToFP("0.70"), GameApp.stringToFP("0.60"), GameApp.stringToFP("0.55"), GameApp.stringToFP("0.50"), GameApp.stringToFP("0.46"), GameApp.stringToFP("0.43"), GameApp.stringToFP("0.40"), GameApp.stringToFP("0.35"), GameApp.stringToFP("0.30"), GameApp.stringToFP("0.20")};
    private static final int[] cAIBlockParryLimit = new int[]{10, 9, 8, 7, 6, 5, 4, 4, 3, 2};
    public static final byte[][] cAIAttackingMoves = new byte[][]{{10, 1}, {10, 3, 31, 32, 6}, {10, 3, 31, 19}, {10, 5, 4}};
    public static final byte[][] cAIDefensiveMoves = new byte[][]{{10, 9, 9, 2}, {10, 0, 7}, {10, 0, 8}};
    public static final byte[][] cAIMixedMoves = new byte[][]{{10, 9, 3, 2}, {10, 0, 7}, {10, 0, 8}, {10, 1}, {10, 3, 31, 32, 6}, {10, 3, 31, 19}, {10, 5, 4}};
    public byte[] aiMoveSeq;
    byte[][] ai_attacking_moves;
    byte[][] ai_defensive_moves;
    byte[][] ai_breaker_moves;
    public static final int moodNuts = 0;
    public static final int moodAgressive = 1;
    public static final int moodPlayful = 2;
    public static final int moodPassive = 3;
    public static final int numAIMoods = 4;
    public static final int[][] ai_mood_modifiers = new int[][]{{75, 0, 150}, {70, 10, 70}, {50, 15, 30}, {50, 20, 20}};
    private boolean aiIsFirstMood = true;
    private int practiceAnim = 0;
    private boolean practiceAutoCycle = false;
    public int aiWasBlockedCount = 0;
    private int lastAnim = -1;
    private int animQueue = -1;
    private short animQueueLoops = 0;
    int animQueueAttack = -1;
    int lastAttackAnim = -1;
    public byte specialAttackCounter;
    public static final int cAnimFinished = 1;
    public static final int cAnimLooped = 2;
    public static final int cAnimTypeLooping = 1;
    public boolean smoothAnimation = true;
    public int globalScale = GameApp.div(0x800000, GameApp.stringToFP("240.0"));
    public ImageSet isBrushes;
    public int bone_dx;
    public int bone_dy;
    public int[] serialisedBoneData;
    AnimationRecord[] compiledAnims;
    public int anim_id = -1;
    public int anim_num_frames;
    public int anim_fps;
    public int anim_flags;
    public int current_frame_flags;
    public int anim_frame_time;
    public int anim_frame_duration;
    public int anim_frame_lerp;
    public short anim_loop_count;
    public int frame_id;
    public int next_frame_id;
    public short currentboneDataIndex;
    public short currentboneDataCount;
    public short nextboneDataIndex;
    public short nextboneDataCount;
    public int minX = 0;
    public int maxX = 0;
    public int minY = 0;
    public int maxY = 0;
    private static int[] calcFrameExtentsRect = new int[4];
    private static int[] getBoneBrushRectTemp = new int[4];
    public boolean flippedHorizontally = false;
    public static final byte cBoneDataZOrderOffset = 28;
    public static final byte cBoneDataIndexOffset = 20;
    public static final byte cBoneDataXOffset = 10;
    public static final byte cBoneDataYOffset = 0;
    boolean weDontOwnImageset = false;
    public ImageSequence brushSet;
    String strImageSet;

    public Boxer(GameLogic gameLogic, int n) {
        this.game = gameLogic;
        this.facing = this.playerIndex = n;
    }

    public void init(int n, int n2) {
        this.animQueue = -1;
        n2 = GameApp.mul(n2, GameApp.stringToFP("1.5"));
        if (this.actorCharacter != n) {
            this.clear();
            this.actorCharacter = n;
            this.walkSpeed = 0x800000 * this.game.getBoxerStat(this.actorCharacter, 1) / 50;
            this.animator.loadAnimations(strBoxerFiles[n]);
            this.animator.globalScale = n2;
            this.animator.smoothAnimation = false;
            this.animator.flippedHorizontally = this.playerIndex == 1;
        }
        this.stopAnimation();
    }

    public void clear() {
        this.animator.destruct();
        this.actorCharacter = -1;
    }

    public void notifyHit(int n) {
        if (this.animator.anim_id == 34) {
            this.stopAnimation();
        }
        this.aiSeqPos = -1;
        this.aiBlockCount = 0;
    }

    public void doBreakerIntercept(int n) {
        int n2 = 0;
        switch (n) {
            case 20: {
                n2 = GameApp.mul(917504, 983040);
                break;
            }
            case 22: {
                n2 = GameApp.mul(917504, 0x140000);
                break;
            }
            case 24: {
                n2 = GameApp.mul(917504, 0x140000);
                break;
            }
            case 25: {
                n2 = GameApp.mul(917504, 0x190000);
            }
        }
        this.actorVel[0] = this.playerIndex == 0 ? n2 : -n2;
    }

    public void doMoveBoost(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = GameApp.mul(917504, 524288);
                break;
            }
            case 2: {
                n2 = -GameApp.mul(917504, 524288);
                break;
            }
            case 10: {
                n2 = -GameApp.mul(917504, 458752);
            }
        }
        this.actorVel[0] = this.playerIndex == 0 ? n2 : -n2;
    }

    public void doParried(int n) {
        this.playAnimation(17);
    }

    public void processPlayer() {
        if (GameLogic.gameMode == 3 && GameScreen.boxer[1].aiLevel == 4) {
            return;
        }
        Boxer boxer = GameScreen.boxer[1 - this.playerIndex];
        int n = boxer.animator.anim_id;
        if (!this.doubleTapLeft && ScreenStack.keysPressed(2)) {
            if (GameApp.timeLastFrame - this.lastLeftTap < 500L) {
                this.doubleTapLeft = true;
            }
            this.lastLeftTap = GameApp.timeLastFrame;
        }
        if (!this.doubleTapRight && ScreenStack.keysPressed(4)) {
            if (GameApp.timeLastFrame - this.lastRightTap < 500L) {
                this.doubleTapRight = true;
            }
            this.lastRightTap = GameApp.timeLastFrame;
        }
        if (GameApp.timeLastFrame - this.lastRightTap > 500L) {
            this.doubleTapRight = false;
        }
        if (this.animator.anim_id == 0 || this.animator.anim_id == 7 || this.animator.anim_id == 8 || this.animator.anim_id == 1 || this.animator.anim_id == 2 || this.animator.anim_id == 34 || Boxer.isAttackAnim(this.animator.anim_id)) {
            int n2;
            if (Boxer.isAttackAnim(this.animator.anim_id)) {
                if (Boxer.isHitEmAgainAnim(this.animator.anim_id) && this.animQueue == -1 && this.heldOnLastFrame && this.fp_held_duration > 16384) {
                    this.heldOnLastFrame = false;
                    this.stopAnimation();
                    this.game.boxerFaceBreakerBar[this.playerIndex] = 0;
                }
                if (Boxer.isBreakerAttack(this.animator.anim_id) && this.animator.getDuration() - this.animator.getTime() > 16384) {
                    return;
                }
                if (this.animator.getDuration() - this.animator.getTime() > 16384) {
                    return;
                }
            }
            int n3 = GameApp.mul(GameApp.fp_deltatime, this.walkSpeed);
            if (this.animQueue == -1) {
                if (ScreenStack.keysDown(2) && this.doubleTapLeft && this.animator.anim_id != 10) {
                    this.actorPos[0] = this.actorPos[0] - n3;
                    if (this.animator.anim_id != 2) {
                        this.queueAnimation(2);
                        return;
                    }
                }
                if (ScreenStack.keysDown(4) && !this.doubleTapRight) {
                    this.actorPos[0] = this.actorPos[0] + n3;
                    if (this.animator.anim_id != 1) {
                        this.queueAnimation(1);
                        return;
                    }
                }
                if (!(this.animator.anim_id != 2 && this.animator.anim_id != 1 || ScreenStack.keysDown(6))) {
                    this.stopAnimation();
                    this.doubleTapLeft = false;
                    this.doubleTapRight = false;
                }
                if (this.animator.anim_id == 7 || this.animator.anim_id == 8) {
                    if (!ScreenStack.keysDown(2)) {
                        this.stopAnimation();
                    } else {
                        if (Boxer.isLowAttack(n) && this.animator.anim_id == 7) {
                            this.playAnimation(8);
                        }
                        if (Boxer.isHighAttack(n) && this.animator.anim_id == 8) {
                            this.playAnimation(7);
                        }
                    }
                }
            }
            if (this.fp_delay_time > 0) {
                return;
            }
            int n4 = -1;
            if (ScreenStack.keysPressed(16)) {
                n4 = 16;
            }
            if (ScreenStack.keysPressed(1)) {
                n4 = 1;
            }
            if (ScreenStack.keysPressed(8)) {
                n4 = 8;
            }
            if (ScreenStack.keysPressed(4) && this.doubleTapRight && this.game.inCloseRange()) {
                n4 = 4;
            }
            if (n4 != -1) {
                this.lastAttackDown = System.currentTimeMillis();
            } else if (!ScreenStack.keysDown(25)) {
                this.lastAttackDown = 0L;
            }
            if (ScreenStack.keysDown(16) && this.game.getFaceBreakerSegment(this.playerIndex) > 0) {
                if (this.glowKeyTime < 32768 && this.glowKeyTime + GameApp.fp_deltatime > 32768 && this.animator.anim_id != 34) {
                    this.playAnimation(34);
                }
                this.glowKeyTime += GameApp.fp_deltatime;
            }
            if (ScreenStack.keysReleased(16)) {
                this.glowKeyTime = 0;
            }
            if (ScreenStack.keysPressed(16) && this.animator.anim_id == 34) {
                n2 = this.game.getFaceBreakerSegment(this.playerIndex);
                if (n2 == 1) {
                    this.playAnimation(20);
                    return;
                }
                if (n2 == 2) {
                    this.playAnimation(22);
                    return;
                }
                if (n2 == 3) {
                    this.playAnimation(24);
                    return;
                }
            }
            if (n4 != -1) {
                for (n2 = 0; n2 < comboSequences.length; ++n2) {
                    if (n4 != comboSequences[n2][1] || this.animator.anim_id != comboSequences[n2][0] && 0 != comboSequences[n2][0]) continue;
                    this.queueAnimation(comboSequences[n2][2]);
                    return;
                }
            }
            if (ScreenStack.keysPressed(2) && !this.doubleTapLeft && this.fp_parry_wait <= 0) {
                if (Boxer.isHighAttack(n)) {
                    this.queueAnimation(9);
                } else if (Boxer.isLowAttack(n)) {
                    this.queueAnimation(9);
                } else {
                    this.queueAnimation(7);
                }
                return;
            }
        } else if (Boxer.isBeingHitAnim(this.animator.anim_id)) {
            if (ScreenStack.keysPressed(2) && this.fp_parry_wait <= 0) {
                if (Boxer.isLowAttack(n)) {
                    this.queueAnimation(8);
                } else {
                    this.queueAnimation(7);
                }
                return;
            }
        } else if (this.animator.anim_id == 17 && ScreenStack.keysPressed(1048575)) {
            this.stunnedRecoveryCounter = (byte)(this.stunnedRecoveryCounter - 1);
            if (this.stunnedRecoveryCounter < 0) {
                this.stopAnimation();
            }
        }
    }

    public int getNextAIMood() {
        int n;
        if (this.aiIsFirstMood) {
            this.aiIsFirstMood = false;
            return 1;
        }
        if (this.game.boxerEnergy[this.playerIndex] < 0x190000) {
            return 0;
        }
        int n2 = 0;
        for (n = 0; n < 4; ++n) {
            n2 += this.game.getBoxerStat(this.actorCharacter, 7 + n);
        }
        n = GameLogic.randRange(0, n2);
        for (int i = 0; i < 4; ++i) {
            if ((n -= this.game.getBoxerStat(this.actorCharacter, 7 + i)) > 0) continue;
            return i;
        }
        return 0;
    }

    public int getNextAIMoveType() {
        int n;
        int n2 = 0;
        for (n = 0; n < 3; ++n) {
            n2 += ai_mood_modifiers[this.aiMood][n];
        }
        n = GameLogic.randRange(0, n2);
        for (int i = 0; i < 3; ++i) {
            if ((n -= ai_mood_modifiers[this.aiMood][i]) > 0) continue;
            return i;
        }
        return 0;
    }

    public byte[] getNextAIMoveSeq(int n) {
        try {
            switch (n) {
                case 0: {
                    return this.pickWeightedMove(this.ai_attacking_moves);
                }
                case 1: {
                    return this.pickWeightedMove(this.ai_defensive_moves);
                }
                case 2: {
                    int n2 = this.game.getFaceBreakerSegment(this.playerIndex);
                    if (n2 > 0) {
                        return this.ai_breaker_moves[n2 - 1];
                    }
                    return this.getNextAIMoveSeq(0);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private byte[] pickWeightedMove(byte[][] byArray) {
        int n;
        if (byArray.length == 1) {
            return byArray[0];
        }
        int n2 = 0;
        for (n = 0; n < byArray.length; ++n) {
            n2 += byArray[n][0];
        }
        n = GameLogic.randRange(0, n2);
        for (int i = 0; i < byArray.length; ++i) {
            if ((n -= byArray[i][0]) > 0) continue;
            return byArray[i];
        }
        return null;
    }

    public void setAILevel(int n) {
        this.aiLevel = GameApp.bound(n, 0, 9);
        this.aiDecisionTime = 0;
        this.aiMood = 2;
        this.aiBlockCount = 0;
        this.aiSeqType = 0;
        this.aiSeqPos = -1;
        this.aiIsFirstMood = true;
        int n2 = GameApp.bound(this.game.getBoxerStat(this.actorCharacter, 5), 1, 100);
        if (GameLogic.gameMode == 3) {
            this.aiDecisionTime = cAIDecisionTime[6];
            this.aiBlockParryLimit = cAIBlockParryLimit[6] * 50 / n2;
            switch (this.aiLevel) {
                case 0: {
                    this.aiMoveSeq = cAIMixedMoves[0];
                    break;
                }
                case 1: {
                    this.aiMoveSeq = cAIDefensiveMoves[0];
                    this.ai_breaker_moves = cAIMixedMoves;
                    this.ai_attacking_moves = cAIDefensiveMoves;
                    this.ai_defensive_moves = cAIDefensiveMoves;
                    break;
                }
                case 2: {
                    this.aiMoveSeq = cAIMixedMoves[0];
                    this.ai_breaker_moves = cAIAttackingMoves;
                    this.ai_attacking_moves = cAIMixedMoves;
                    this.ai_defensive_moves = cAIDefensiveMoves;
                    break;
                }
                case 3: {
                    this.aiMoveSeq = cAIAttackingMoves[0];
                    this.ai_breaker_moves = cAIAttackingMoves;
                    this.ai_attacking_moves = cAIAttackingMoves;
                    this.ai_defensive_moves = cAIDefensiveMoves;
                    break;
                }
                case 4: {
                    this.aiMoveSeq = cAIMixedMoves[0];
                }
            }
        } else {
            this.aiDecisionTime = cAIDecisionTime[this.aiLevel];
            this.aiBlockParryLimit = cAIBlockParryLimit[6] * 50 / n2;
            this.ai_attacking_moves = this.game.getMatchingMoves(this.actorCharacter, 0, this.aiLevel);
            this.ai_defensive_moves = this.game.getMatchingMoves(this.actorCharacter, 1, this.aiLevel);
            this.ai_breaker_moves = this.game.getMatchingMoves(this.actorCharacter, 2, this.aiLevel);
            this.aiMoveSeq = this.ai_defensive_moves[0];
        }
        this.playAnimation(0);
    }

    public void processAI() {
        if (this.game.state != 3) {
            return;
        }
        if (GameLogic.gameMode == 3 && this.aiLevel == 4) {
            if (ScreenStack.keysPressed(2)) {
                --this.practiceAnim;
                this.stopAnimation();
            }
            if (ScreenStack.keysPressed(4)) {
                ++this.practiceAnim;
                this.stopAnimation();
            }
            if (ScreenStack.keysPressed(16)) {
                this.practiceAutoCycle = !this.practiceAutoCycle;
            }
        }
        int n = GameApp.mul(GameApp.fp_deltatime, this.walkSpeed);
        int n2 = this.animator.anim_id;
        int n3 = this.getBoxerRange();
        int n4 = GameScreen.boxer[1 - this.playerIndex].animator.anim_id;
        int n5 = GameScreen.boxer[1 - this.playerIndex].lastAttackAnim;
        if (this.aiSeqPos == -1 && this.fp_delay_time <= 0 && this.fp_hit_duration <= 0 && (n2 == 0 || n2 == 7 || n2 == 8 || n2 == 1 || this.heldOnLastFrame)) {
            this.fp_AI_timer += GameApp.fp_deltatime;
            if (this.fp_AI_timer > this.aiDecisionTime) {
                this.fp_AI_timer = 0;
                if (GameLogic.gameMode == 3) {
                    switch (this.aiLevel) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (n3 > ScreenStack.getScaledX(120)) {
                                this.playAnimation(1);
                                break;
                            }
                            this.doDefensiveAI();
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.doAIDecision();
                            break;
                        }
                        case 4: {
                            if (this.animator.anim_id != 0) break;
                            while (this.practiceAnim < 0) {
                                this.practiceAnim += this.animator.compiledAnims.length - 1 - 0 + 1;
                            }
                            while (this.practiceAnim > this.animator.compiledAnims.length - 1) {
                                this.practiceAnim -= this.animator.compiledAnims.length - 1 - 0 + 1;
                            }
                            this.playAnimation(this.practiceAnim);
                            this.animator.anim_flags = 0;
                            if (!this.practiceAutoCycle) break;
                            ++this.practiceAnim;
                        }
                    }
                } else {
                    this.doAIDecision();
                }
            }
        }
        if (!(GameLogic.gameMode == 3 && this.aiLevel == 0 || n3 >= ScreenStack.getScaledX(64) || n4 != 19 || n5 != 19 && this.fp_AI_timer <= this.aiDecisionTime / 2)) {
            System.out.println("!!!!!  AARGH! Strong Punch");
            this.doMoveBoost(10);
            if (n5 == 19) {
                this.queueAnimation(9);
            }
        }
        if (n2 == 1) {
            this.actorPos[0] = this.actorPos[0] - n;
            if (n3 < ScreenStack.getScaledX(80) && Boxer.isAttackAnim(n4) && this.fp_AI_timer > this.aiDecisionTime / 2) {
                this.fp_AI_timer = this.aiDecisionTime;
                this.aiSeqPos = -1;
            }
        }
        if (n2 == 2) {
            int n6;
            this.actorPos[0] = this.actorPos[0] + n;
            if (this.playerIndex == 1 && (n6 = this.actorPos[0] - GameScreen.boxer[0].actorPos[0]) > GameScreen.startingDistBetweenPlayers) {
                this.fp_AI_timer = this.aiDecisionTime;
                this.aiSeqPos = -1;
                this.stopAnimation();
            }
        }
    }

    private void nextAIMove() {
        if (this.game.state != 3) {
            return;
        }
        if (this.aiSeqPos != -1 && this.aiMoveSeq != null && this.aiSeqPos < this.aiMoveSeq.length && this.aiMoveSeq[this.aiSeqPos] != -1) {
            this.playAnimation(this.aiMoveSeq[this.aiSeqPos++]);
        } else {
            this.aiSeqPos = -1;
            this.playAnimation(0);
        }
        this.fp_AI_timer = 0;
    }

    private void doAIDecision() {
        int n = this.animator.anim_id;
        int n2 = this.getBoxerRange();
        int n3 = GameScreen.boxer[1 - this.playerIndex].animator.anim_id;
        if (n2 > ScreenStack.getScaledX(120)) {
            if (GameLogic.randRange(0, 100) > 50) {
                this.playAnimation(30);
            } else {
                this.playAnimation(1);
            }
        } else if (Boxer.isAttackAnim(n3)) {
            this.doDefensiveAI();
        } else {
            if (this.aiSeqPos == -1 || this.aiMoveSeq[this.aiSeqPos] == -1) {
                if (this.aiWasBlockedCount > 2) {
                    this.playAnimation(27);
                    this.aiWasBlockedCount = 0;
                    return;
                }
                this.aiWasBlockedCount = 0;
                this.aiSeqPos = 1;
                int n4 = this.aiSeqType;
                byte[] byArray = this.aiMoveSeq;
                int n5 = 10;
                while ((n4 == this.aiSeqType && byArray == this.aiMoveSeq || this.aiMoveSeq == null) && --n5 > 0) {
                    this.aiMood = this.getNextAIMood();
                    this.aiSeqType = this.getNextAIMoveType();
                    this.aiMoveSeq = this.getNextAIMoveSeq(this.aiSeqType);
                }
            }
            this.playAnimation(this.aiMoveSeq[this.aiSeqPos++]);
        }
    }

    private int getBoxerRange() {
        int n = GameScreen.boxer[0].rectBody[0] + GameScreen.boxer[0].rectBody[2];
        int n2 = GameScreen.boxer[1].rectBody[0];
        return n2 - n;
    }

    private void doDefensiveAI() {
        int n = this.animator.anim_id;
        int n2 = this.getBoxerRange();
        int n3 = GameScreen.boxer[1 - this.playerIndex].animator.anim_id;
        if (n == 7 || n == 8) {
            ++this.aiBlockCount;
        }
        if (this.aiBlockCount < this.aiBlockParryLimit) {
            if (n3 == 27) {
                this.playAnimation(9);
            } else if (!(n3 != 19 && this.aiMood != 0 || GameLogic.gameMode == 3 && this.aiLevel < 2)) {
                System.out.println("$$$$$$$$$$$$");
                this.playAnimation(3);
                this.fp_AI_timer = this.aiDecisionTime;
            } else if (Boxer.isLowAttack(n3)) {
                this.playAnimation(8);
            } else {
                this.playAnimation(7);
            }
        } else {
            System.out.println("AI Block Limit - Escaping!");
            this.aiBlockCount = 0;
            this.aiSeqPos = 1;
            this.aiMoveSeq = this.ai_defensive_moves[0];
            this.playAnimation(this.aiMoveSeq[this.aiSeqPos++]);
            this.actorVel[0] = -GameApp.mul(917504, 524288);
        }
    }

    public boolean holdOnLastFrame(int n) {
        if (GameLogic.gameMode == 3 && this.aiLevel == 4) {
            return false;
        }
        return n == 15 || n == 7 || n == 8 || n == 22 || n == 20 || n == 24 || n == 25;
    }

    public static boolean isLoopingSpecialAnim(int n) {
        return n == 0 || n == 1 || n == 3 || n == 6;
    }

    public static boolean isAttackAnim(int n) {
        return n == 3 || n == 31 || n == 32 || n == 4 || n == 5 || n == 19 || n == 6 || n == 27 || n == 22 || n == 23 || n == 20 || n == 21 || n == 24 || n == 25 || n == 26;
    }

    public static boolean isHighAttack(int n) {
        return n == 3 || n == 31 || n == 32 || n == 6 || n == 19 || n == 27 || n == 22 || n == 23 || n == 24 || n == 25;
    }

    public static boolean isLowAttack(int n) {
        return n == 4 || n == 5 || n == 20 || n == 21 || n == 25;
    }

    public static boolean isFaceBreakerAttack(int n) {
        return n == 24 || n == 25 || n == 26;
    }

    public static boolean isBreakerAttack(int n) {
        return n == 24 || n == 25 || n == 26 || n == 22 || n == 23 || n == 20 || n == 21;
    }

    public static boolean isBreakerFinalAnim(int n) {
        return n == 26 || n == 23 || n == 21;
    }

    public static boolean isHitEmAgainAnim(int n) {
        return n == 24 || n == 25 || n == 22 || n == 20;
    }

    public static boolean isBeingHitAnim(int n) {
        return n == 11 || n == 12 || n == 13 || n == 14 || n == 33 || n == 28;
    }

    public static boolean isDefensiveAnim(int n) {
        return n == 7 || n == 8 || n == 9;
    }

    public void processAnimation() {
        int n;
        if (this.fp_delay_time > 0) {
            this.fp_delay_time -= GameApp.fp_deltatime;
        }
        if (this.fp_parry_wait > 0) {
            this.fp_parry_wait -= GameApp.fp_deltatime;
        }
        if (this.fp_hit_duration > 0) {
            this.fp_hit_duration -= GameApp.fp_deltatime;
        }
        this.fp_held_duration = this.heldOnLastFrame ? (this.fp_held_duration += GameApp.fp_deltatime) : 0;
        int n2 = this.animator.animate(GameApp.fp_deltatime);
        if (n2 == 1) {
            if (this.animator.anim_id == 9 || this.animator.anim_id == 9) {
                this.fp_parry_wait = 32768;
            }
            if (this.animator.anim_id == 9 && this.playerIndex == 0 && ScreenStack.keysDown(8)) {
                this.queueAnimation(7);
            }
            if (this.animator.anim_id == 9 && this.playerIndex == 0 && ScreenStack.keysDown(8)) {
                this.queueAnimation(8);
            }
            n = this.animator.anim_id;
            if (Boxer.isAttackAnim(this.animator.anim_id) && this.startAttack) {
                System.out.println("!!!!!   test doattack()");
                if (this.game.doAttack(this.playerIndex, this.animator.anim_id)) {
                    this.startAttack = false;
                    this.delayCount = 0;
                    this.lastAttackWasSuccessful = true;
                } else {
                    this.animQueue = -1;
                    this.lastAttackWasSuccessful = false;
                    this.aiSeqPos = -1;
                    ++this.delayCount;
                    this.fp_delay_time += this.delayCount * 1024;
                }
            }
            if (this.fp_hit_duration <= 0 && n == this.animator.anim_id) {
                if (this.animQueue != -1) {
                    this.playAnimation(this.animQueue, this.animQueueLoops);
                    return;
                }
                if (!this.holdOnLastFrame(this.animator.anim_id)) {
                    if (this.game.state != 6) {
                        this.stopAnimation();
                    }
                } else if (Boxer.isHitEmAgainAnim(this.animator.anim_id) && this.startAttack) {
                    this.heldOnLastFrame = false;
                    this.stopAnimation();
                } else if (Boxer.isHitEmAgainAnim(this.animator.anim_id) && this.playerIndex == 0 && this.game.boxerEnergy[1] == 0) {
                    this.playAnimation(this.animator.anim_id + 1);
                } else {
                    this.heldOnLastFrame = true;
                }
            }
        }
        n = this.animator.getCurrentFrameFlags();
        if (this.lastAnim != this.animator.anim_id) {
            n = 1;
        }
        if (Boxer.isAttackAnim(this.animator.anim_id) && n == 1) {
            this.startAttack = true;
            System.out.println("!!!!!   test3 doattack()    " + Boxer.isAttackAnim(this.animator.anim_id));
        }
        if (this.startAttack) {
            if (this.game.doAttack(this.playerIndex, this.animator.anim_id)) {
                this.startAttack = false;
                this.delayCount = 0;
                this.lastAttackWasSuccessful = true;
            } else {
                this.lastAttackWasSuccessful = false;
            }
        }
        this.lastAnim = this.animator.anim_id;
        if (this.playerIndex == 1 && this.aiSeqPos != -1 && this.fp_hit_duration <= 0 && (n2 == 2 || n2 == 1)) {
            this.nextAIMove();
        }
        if (this.actorVel[0] != 0 || this.actorVel[1] != 0) {
            this.actorPos[0] = this.actorPos[0] + GameApp.mul(this.actorVel[0], GameApp.fp_deltatime);
            this.actorPos[1] = this.actorPos[1] + GameApp.mul(this.actorVel[1], GameApp.fp_deltatime);
            if (this.actorPos[1] == cfpFloorHeight) {
                if (this.actorVel[0] != 0) {
                    int n3 = GameApp.mul(0x2000000, GameApp.fp_deltatime);
                    this.actorVel[0] = this.actorVel[0] - (this.actorVel[0] > 0 ? 1 : (this.actorVel[0] < 0 ? -1 : 0)) * n3;
                    if (GameApp.abs(this.actorVel[0]) < n3) {
                        this.actorVel[0] = 0;
                    }
                }
            } else {
                if (this.actorPos[1] > cfpFloorHeight) {
                    this.actorPos[1] = cfpFloorHeight;
                    this.actorVel[1] = GameApp.abs(this.actorVel[1]) > 65536 ? -GameApp.abs(GameApp.mul(16384, this.actorVel[1])) : 0;
                    this.actorVel[0] = this.actorVel[0] / 2;
                }
                if (this.actorPos[1] < cfpFloorHeight) {
                    this.actorVel[1] = this.actorVel[1] + GameApp.mul(cActorGravity, GameApp.fp_deltatime);
                }
            }
        }
        this.updateBoxerBoneRects();
        if (this.animator.anim_id != -1) {
            // empty if block
        }
    }

    public void updateBoxerBoneRects() {
        int n = GameScreen.getScaledPos(this.actorPos[0] < 0 ? -(-this.actorPos[0] >> 16) : this.actorPos[0] >> 16) + GameScreen.m_x;
        int n2 = GameScreen.getScaledPos(this.actorPos[1] < 0 ? -(-this.actorPos[1] >> 16) : this.actorPos[1] >> 16) + GameScreen.m_y;
        this.animator.getBoneBrushRect(255, this.rectBody);
        this.rectBody[0] = this.rectBody[0] + n;
        this.rectBody[1] = this.rectBody[1] + n2;
        this.rectLeftFist[0] = this.rectBody[0];
        this.rectLeftFist[1] = this.rectBody[1];
        this.rectLeftFist[2] = this.rectBody[2];
        this.rectLeftFist[3] = this.rectBody[3];
        this.rectBody[0] = this.rectBody[0] + this.rectBody[2] / 4;
        this.rectBody[2] = this.rectBody[2] / 2;
    }

    public void queueAnimation(int n) {
        this.queueAnimation(n, (short)0);
    }

    public void queueAnimation(int n, short s) {
        if (this.animator.anim_id == 0 || this.animator.anim_id == 1 || this.animator.anim_id == 2 || this.animator.anim_id == 7 || this.animator.anim_id == 8) {
            this.playAnimation(n, s);
        } else {
            this.animQueue = n;
            this.animQueueLoops = s;
        }
    }

    public boolean isAnimationQueued(int n) {
        return this.animQueue == n;
    }

    public void playAnimation(int n) {
        this.playAnimation(n, (short)0);
    }

    public void playAnimation(int n, short s) {
        if (ScreenStack.currentContainer == GameApp.gameScreen && (this.game.state == 5 || this.game.state == 6)) {
            return;
        }
        if (n != 34 && !Boxer.isBreakerAttack(n) && this.glowKeyTime > 0) {
            this.glowKeyTime = 0;
        }
        this.animQueue = -1;
        int n2 = this.animator.anim_id;
        if (Boxer.isAttackAnim(n2)) {
            this.lastAttackAnim = n2;
        }
        this.startAttack = false;
        this.heldOnLastFrame = false;
        if (Boxer.isHitEmAgainAnim(n2) && Boxer.isBreakerAttack(n)) {
            this.doBreakerIntercept(n2);
        }
        if (n == -1) {
            this.animator.playAnimationInternal(0, s);
        } else {
            this.animator.playAnimationInternal(n, s);
        }
        this.modifyAnimFramerate(n);
        if (Boxer.isBreakerAttack(n2) && !Boxer.isBreakerAttack(n)) {
            this.game.boxerFaceBreakerBar[this.playerIndex] = 0;
        }
        if (n2 != -1 && n2 != 7 && n2 != 8 && n2 != 9) {
            int n3 = this.animator.compiledAnims[n2].frameDataBoneArrayIndex.length;
            short s2 = Boxer.decodeSerialisedBoneDataPosX(this.animator.serialisedBoneData[this.animator.compiledAnims[n2].frameDataBoneArrayIndex[n3 - 1]]);
            short s3 = Boxer.decodeSerialisedBoneDataPosX(this.animator.serialisedBoneData[this.animator.compiledAnims[this.animator.anim_id].frameDataBoneArrayIndex[0]]);
            int n4 = this.playerIndex == 0 ? s2 - s3 : s3 - s2;
            this.actorPos[0] = this.actorPos[0] + (n4 < 0 ? -(-n4 << 16) : n4 << 16);
        }
        if (this.playerIndex == 0) {
            if (Boxer.isFaceBreakerAttack(n) && !Boxer.isFaceBreakerAttack(n2)) {
                performingFB = true;
            } else if (Boxer.isFaceBreakerAttack(n2) && !Boxer.isFaceBreakerAttack(n)) {
                performingFB = false;
            }
        } else {
            boolean bl = performingFB = this.aiSeqType == 2;
        }
        if (!Boxer.isAttackAnim(n) && n != 9 && n != 8 && n != 7) {
            int[] nArray = GameLogic.statsPlayer[this.playerIndex];
            int n5 = n;
            nArray[n5] = nArray[n5] + 1;
        }
        if (n == 17) {
            this.stunnedRecoveryCounter = (byte)4;
        }
    }

    public void modifyAnimFramerate(int n) {
        if (n == 1 || n == 2) {
            this.animator.setFPS(18);
        }
        if (Boxer.isAttackAnim(n) && !Boxer.isBreakerAttack(n)) {
            if (this.actorCharacter == 8) {
                this.animator.setFPS(16);
            }
            if (this.actorCharacter == 2 || this.actorCharacter == 6) {
                this.animator.setFPS(13);
            }
        }
        if (n == 18 || n == 13) {
            this.animator.setFPS(9);
        }
        if (Boxer.isBreakerAttack(n)) {
            this.animator.setFPS(16);
        }
    }

    public void stopAnimation() {
        this.playAnimation(0);
    }

    public int getBoneX(int n) {
        int n2 = GameScreen.getScaledPos(this.actorPos[0] < 0 ? -(-this.actorPos[0] >> 16) : this.actorPos[0] >> 16) + GameScreen.m_x;
        return n2 += this.animator.bone_dx;
    }

    public int getBoneY(int n) {
        int n2 = GameScreen.getScaledPos(this.actorPos[1] < 0 ? -(-this.actorPos[1] >> 16) : this.actorPos[1] >> 16) + GameScreen.m_y;
        return n2 += this.animator.bone_dy;
    }

    public void drawShadow(SDKGraphics sDKGraphics) {
        int n = this.getBoneX(0);
        int n2 = GameScreen.getScaledPos(cfpFloorHeight < 0 ? -(-cfpFloorHeight >> 16) : cfpFloorHeight >> 16) + GameScreen.m_y;
        SDKImage sDKImage = GameApp.gameScreen.imgShadow;
        if (sDKImage != null) {
            sDKGraphics.drawImage(sDKImage, n -= sDKImage.getWidth() >> 1, n2 -= sDKImage.getHeight() >> 1, 0x10 | 4);
        }
    }

    public void draw(SDKGraphics sDKGraphics) {
        int n = GameScreen.getScaledPos(this.actorPos[0] < 0 ? -(-this.actorPos[0] >> 16) : this.actorPos[0] >> 16) + GameScreen.m_x;
        int n2 = GameScreen.getScaledPos(this.actorPos[1] < 0 ? -(-this.actorPos[1] >> 16) : this.actorPos[1] >> 16) + GameScreen.m_y;
        this.animator.draw(sDKGraphics, n, n2, this.game.boxerEnergy[0] <= 0x320000);
    }

    public static int decodeSerialisedBoneDataZOrder(int n) {
        return n >> 28 & 0xF;
    }

    public static short decodeSerialisedBoneDataIndex(int n) {
        return (short)(n >> 20 & 0xFF);
    }

    public static short decodeSerialisedBoneDataPosX(int n) {
        if ((n >> 10 & 0x200) != 0) {
            return (short)(-(~(n >> 10) & 0x1FF) - 1);
        }
        return (short)(n >> 10 & 0x1FF);
    }

    public static short decodeSerialisedBoneDataPosY(int n) {
        if ((n >> 0 & 0x200) != 0) {
            return (short)(-(~(n >> 0) & 0x1FF) - 1);
        }
        return (short)(n >> 0 & 0x1FF);
    }

    public void playAnimationInternal(int n) {
        this.playAnimationInternal(n, (short)0);
    }

    public void playAnimationInternal(int n, short s) {
        if (n < 0 || n >= this.compiledAnims.length) {
            return;
        }
        this.anim_id = n;
        this.anim_num_frames = this.compiledAnims[this.anim_id].frameDataBoneArrayIndex.length;
        this.anim_fps = this.compiledAnims[this.anim_id].framesPerSecond;
        this.anim_flags = this.compiledAnims[this.anim_id].flags;
        this.frame_id = 0;
        this.anim_frame_time = 0;
        this.anim_frame_lerp = 0;
        this.anim_frame_duration = 65536 / this.anim_fps;
        int n2 = GameApp.stringToFP("1.135");
        this.anim_frame_duration = GameApp.mul(this.anim_frame_duration, n2);
        if ((this.anim_flags & 1) != 0) {
            this.anim_loop_count = Short.MAX_VALUE;
        } else {
            if (s > 0) {
                this.anim_flags |= 1;
            }
            this.anim_loop_count = s;
        }
        this.doNextFrame(0);
        this.animate(0);
    }

    public void setFPS(int n) {
        this.anim_fps = n;
        this.anim_frame_duration = 65536 / this.anim_fps;
    }

    public int getTime() {
        return this.frame_id * this.anim_frame_duration + this.anim_frame_time;
    }

    public int getDuration() {
        return this.anim_num_frames * this.anim_frame_duration;
    }

    public int getAnimDuration(int n) {
        return GameApp.div(this.compiledAnims[n].frameDataBoneArrayIndex.length < 0 ? -(-this.compiledAnims[n].frameDataBoneArrayIndex.length << 16) : this.compiledAnims[n].frameDataBoneArrayIndex.length << 16, this.compiledAnims[n].framesPerSecond < 0 ? -(-this.compiledAnims[n].framesPerSecond << 16) : this.compiledAnims[n].framesPerSecond << 16);
    }

    public int getCurrentFrameWidth() {
        return this.maxX - this.minX;
    }

    public int getCurrentFrameHeight() {
        return this.maxY - this.minY;
    }

    private void setImageSet(ImageSet imageSet) {
        this.weDontOwnImageset = true;
        this.isBrushes = imageSet;
    }

    public void unload() {
        if (this.isBrushes != null && !this.weDontOwnImageset) {
            this.isBrushes.unloadImages();
        }
    }

    public void reload() {
        if (this.isBrushes != null && !this.weDontOwnImageset) {
            this.isBrushes.reloadImages();
        }
    }

    public int animate(int n) {
        if (this.anim_id == -1) {
            return 0;
        }
        int n2 = this.tick(n);
        this.bone_dx = this.getBoneX(0, false);
        this.bone_dy = this.getBoneY(0, false);
        this.calcFrameExtents();
        this.current_frame_flags = n2 >> 16;
        return n2;
    }

    public int getCurrentFrameFlags() {
        return this.current_frame_flags;
    }

    private int tick(int n) {
        this.anim_frame_time += n;
        int n2 = 0;
        while (this.anim_frame_time >= this.anim_frame_duration) {
            this.anim_frame_time -= this.anim_frame_duration;
            n2 |= this.doNextFrame(this.frame_id + 1);
        }
        this.anim_frame_lerp = this.anim_frame_time * this.anim_fps;
        this.anim_frame_lerp = GameApp.bound(this.anim_frame_lerp, 0, 65536);
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int doNextFrame(int n) {
        int n2;
        block3: {
            n2 = 0;
            if (n >= this.anim_num_frames) {
                if ((this.anim_flags & 1) != 0 && this.anim_loop_count > 0) {
                    this.frame_id = 0;
                    n2 |= 2;
                    this.anim_loop_count = (short)(this.anim_loop_count - 1);
                    break block3;
                } else {
                    this.currentboneDataIndex = this.nextboneDataIndex;
                    this.currentboneDataCount = this.nextboneDataCount;
                    return n2 |= 1;
                }
            }
            this.frame_id = n;
        }
        this.next_frame_id = this.frame_id + 1 >= this.anim_num_frames ? ((this.anim_flags & 1) != 0 && this.anim_loop_count > 0 ? 0 : this.frame_id) : this.frame_id + 1;
        this.currentboneDataIndex = this.compiledAnims[this.anim_id].frameDataBoneArrayIndex[this.frame_id];
        this.currentboneDataCount = this.compiledAnims[this.anim_id].frameDataNumBones[this.frame_id];
        this.nextboneDataIndex = this.compiledAnims[this.anim_id].frameDataBoneArrayIndex[this.next_frame_id];
        this.nextboneDataCount = this.compiledAnims[this.anim_id].frameDataNumBones[this.next_frame_id];
        byte by = this.compiledAnims[this.anim_id].frameDataFlags[this.frame_id];
        return by << 16 | n2;
    }

    private void calcFrameExtents() {
        try {
            short s;
            this.minX = 65536;
            this.maxX = 0;
            this.minY = 65536;
            this.maxY = 0;
            short s2 = s = 0;
            short s3 = Boxer.decodeSerialisedBoneDataIndex(this.serialisedBoneData[s + this.currentboneDataIndex]);
            if (s3 >= 0 && s3 < this.brushSet.numFrames) {
                this.getBrushRect(this.bone_dx, this.bone_dy, s3, calcFrameExtentsRect);
                if (calcFrameExtentsRect[0] < this.minX) {
                    this.minX = calcFrameExtentsRect[0];
                }
                if (calcFrameExtentsRect[0] + calcFrameExtentsRect[2] > this.maxX) {
                    this.maxX = calcFrameExtentsRect[0] + calcFrameExtentsRect[2];
                }
                if (calcFrameExtentsRect[1] < this.minY) {
                    this.minY = calcFrameExtentsRect[1];
                }
                if (calcFrameExtentsRect[1] + calcFrameExtentsRect[3] > this.maxY) {
                    this.maxY = calcFrameExtentsRect[1] + calcFrameExtentsRect[3];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getBoneByName(String string) {
        return 0;
    }

    public int getBoneX(int n, boolean bl) {
        n = 0;
        if (this.smoothAnimation) {
            int n2 = 0;
            n2 = bl ? GameApp.linearInterpolate(this.anim_frame_lerp, Boxer.decodeSerialisedBoneDataPosX(this.serialisedBoneData[this.currentboneDataIndex + n]), Boxer.decodeSerialisedBoneDataPosX(this.serialisedBoneData[this.nextboneDataIndex + n])) : Boxer.decodeSerialisedBoneDataPosX(this.serialisedBoneData[this.currentboneDataIndex + n]);
            n2 = this.globalScale * n2;
            if (!this.flippedHorizontally) {
                return n2 < 0 ? -(-n2 >> 16) : n2 >> 16;
            }
            return -n2 < 0 ? -(-(-n2) >> 16) : -n2 >> 16;
        }
        if (!this.flippedHorizontally) {
            return this.globalScale * Boxer.decodeSerialisedBoneDataPosX(this.serialisedBoneData[this.currentboneDataIndex + n]) < 0 ? -(-(this.globalScale * Boxer.decodeSerialisedBoneDataPosX(this.serialisedBoneData[this.currentboneDataIndex + n])) >> 16) : this.globalScale * Boxer.decodeSerialisedBoneDataPosX(this.serialisedBoneData[this.currentboneDataIndex + n]) >> 16;
        }
        return -this.globalScale * Boxer.decodeSerialisedBoneDataPosX(this.serialisedBoneData[this.currentboneDataIndex + n]) < 0 ? -(-(-this.globalScale * Boxer.decodeSerialisedBoneDataPosX(this.serialisedBoneData[this.currentboneDataIndex + n])) >> 16) : -this.globalScale * Boxer.decodeSerialisedBoneDataPosX(this.serialisedBoneData[this.currentboneDataIndex + n]) >> 16;
    }

    public int getBoneY(int n, boolean bl) {
        n = 0;
        if (this.smoothAnimation) {
            int n2 = 0;
            n2 = bl ? GameApp.linearInterpolate(this.anim_frame_lerp, Boxer.decodeSerialisedBoneDataPosY(this.serialisedBoneData[this.currentboneDataIndex + n]), Boxer.decodeSerialisedBoneDataPosY(this.serialisedBoneData[this.nextboneDataIndex + n])) : Boxer.decodeSerialisedBoneDataPosY(this.serialisedBoneData[this.currentboneDataIndex + n]);
            n2 = this.globalScale * n2;
            return n2 < 0 ? -(-n2 >> 16) : n2 >> 16;
        }
        return this.globalScale * Boxer.decodeSerialisedBoneDataPosY(this.serialisedBoneData[this.currentboneDataIndex + n]) < 0 ? -(-(this.globalScale * Boxer.decodeSerialisedBoneDataPosY(this.serialisedBoneData[this.currentboneDataIndex + n])) >> 16) : this.globalScale * Boxer.decodeSerialisedBoneDataPosY(this.serialisedBoneData[this.currentboneDataIndex + n]) >> 16;
    }

    public void draw(SDKGraphics sDKGraphics, int n, int n2, boolean bl) {
        if (this.anim_id == -1) {
            return;
        }
        try {
            short s;
            short s2 = s = 0;
            short s3 = Boxer.decodeSerialisedBoneDataIndex(this.serialisedBoneData[s + this.currentboneDataIndex]);
            if (s3 < this.brushSet.numFrames && s3 != 255 && s3 != -1) {
                this.drawBrush(sDKGraphics, s3, n + this.bone_dx, n2 + this.bone_dy, bl, this.flippedHorizontally);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getBoneBrushRect(int n, int[] nArray) {
        boolean bl = false;
        nArray[0] = 65535;
        nArray[1] = 65535;
        nArray[2] = -65536;
        nArray[3] = -65536;
        try {
            short s;
            short s2 = s = 0;
            short s3 = Boxer.decodeSerialisedBoneDataIndex(this.serialisedBoneData[s + this.currentboneDataIndex]);
            if (s3 >= 0 && s3 < this.brushSet.numFrames && (n & 1 << s2) != 0) {
                this.getBrushRect(this.bone_dx, this.bone_dy, s3, getBoneBrushRectTemp);
                if (getBoneBrushRectTemp[0] < nArray[0]) {
                    nArray[0] = getBoneBrushRectTemp[0];
                }
                if (getBoneBrushRectTemp[0] + getBoneBrushRectTemp[2] > nArray[2]) {
                    nArray[2] = getBoneBrushRectTemp[0] + getBoneBrushRectTemp[2];
                }
                if (getBoneBrushRectTemp[1] < nArray[1]) {
                    nArray[1] = getBoneBrushRectTemp[1];
                }
                if (getBoneBrushRectTemp[1] + getBoneBrushRectTemp[3] > nArray[3]) {
                    nArray[3] = getBoneBrushRectTemp[1] + getBoneBrushRectTemp[3];
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            nArray[2] = nArray[2] - nArray[0];
            nArray[3] = nArray[3] - nArray[1];
        }
        return bl;
    }

    public void loadAnimations(String string, ImageSet imageSet) {
        try {
            GameApp.printMemoryStatus("TwistedAnimator.loadAnimations() PRE TA BIN DATA");
            this.loadBinaryAnimations(string + ".bin");
            GameApp.printMemoryStatus("TwistedAnimator.loadAnimations() POST TA BIN DATA");
            this.setImageSet(imageSet);
            this.brushSet = this.isBrushes.getImageSequence("brush");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadAnimations(String string) {
        try {
            GameApp.printMemoryStatus("TwistedAnimator.loadAnimations() PRE TA BIN DATA");
            this.loadBinaryAnimations(string + ".bin");
            GameApp.printMemoryStatus("TwistedAnimator.loadAnimations() POST TA BIN DATA");
            this.isBrushes = new ImageSet("/" + this.strImageSet + ".is", false);
            this.brushSet = this.isBrushes.getImageSequence("brush");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyAnimations(Boxer boxer) {
        try {
            this.compiledAnims = boxer.compiledAnims;
            this.serialisedBoneData = boxer.serialisedBoneData;
            this.isBrushes = boxer.isBrushes;
            this.brushSet = boxer.brushSet;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destruct() {
        this.compiledAnims = null;
        this.serialisedBoneData = null;
        this.brushSet = null;
        if (this.isBrushes != null) {
            this.isBrushes.unloadImages();
            this.isBrushes.destruct();
            this.isBrushes = null;
        }
    }

    public void drawBrush(SDKGraphics sDKGraphics, int n, int n2, int n3, boolean bl, boolean bl2) {
        if (this.brushSet != null) {
            int n4 = n2 - (this.brushSet.getRectWidth(n) >> 1);
            int n5 = n3;
            if (bl2) {
                this.brushSet.drawImageTrans(sDKGraphics, n, n4, n5, 2);
            } else {
                this.brushSet.drawImage(sDKGraphics, n, n4, n5);
            }
        }
    }

    public void getBrushRect(int n, int n2, int n3, int[] nArray) {
        nArray[0] = n - (this.brushSet.getRectWidth(n3) >> 1);
        nArray[1] = n2;
        nArray[2] = this.brushSet.getRectWidth(n3);
        nArray[3] = this.brushSet.getRectHeight(n3);
    }

    public boolean pointOverlaps(int n, int n2, int n3, int n4, int n5) {
        short s = this.brushSet.getRectWidth(n3);
        short s2 = this.brushSet.getRectHeight(n3);
        return n4 >= n && n4 < n + s && n5 >= n2 && n5 < n2 + s2;
    }

    public void loadBinaryAnimations(String string) {
        InputStream inputStream = GameApp.instance.getClass().getResourceAsStream("/" + string);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int n;
            this.strImageSet = dataInputStream.readUTF();
            byte by = dataInputStream.readByte();
            this.compiledAnims = new AnimationRecord[by];
            int n2 = 0;
            for (n = 0; n < this.compiledAnims.length; ++n) {
                int n3;
                AnimationRecord animationRecord;
                this.compiledAnims[n] = animationRecord = new AnimationRecord();
                short s = dataInputStream.readShort();
                animationRecord.frameDataBoneArrayIndex = new short[s];
                animationRecord.frameDataNumBones = new byte[s];
                animationRecord.frameDataFlags = new byte[s];
                for (n3 = 0; n3 < animationRecord.frameDataNumBones.length; ++n3) {
                    animationRecord.frameDataNumBones[n3] = dataInputStream.readByte();
                }
                for (n3 = 0; n3 < animationRecord.frameDataBoneArrayIndex.length; ++n3) {
                    int n4 = n2;
                    n2 = (short)(n2 + 1);
                    animationRecord.frameDataBoneArrayIndex[n3] = n4;
                }
                for (n3 = 0; n3 < animationRecord.frameDataFlags.length; ++n3) {
                    animationRecord.frameDataFlags[n3] = dataInputStream.readByte();
                }
                animationRecord.framesPerSecond = dataInputStream.readByte();
                animationRecord.flags = dataInputStream.readByte();
            }
            n = dataInputStream.readShort();
            this.serialisedBoneData = new int[n];
            for (int i = 0; i < this.serialisedBoneData.length; ++i) {
                this.serialisedBoneData[i] = dataInputStream.readInt();
            }
            dataInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class AnimationRecord {
        public String name;
        public short[] frameDataBoneArrayIndex;
        public short[] frameDataBrushArrayIndex;
        public byte[] frameDataNumBones;
        public byte[] frameDataNumBrushes;
        public byte[] frameDataFlags;
        public short framesPerSecond;
        public byte flags;
    }
}

