/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class Player {
    static Animation[] m_anims;
    static int[] blood;
    public static int m_currentLev;
    static Actor[] m_actors;
    static Actor[] displaylist_sort;
    static int m_nActors;
    static short[] m_actorRoomID;
    public static short s_freeRoomID;
    public static boolean s_actorDie;
    static short[] activeZones;
    static byte[] s_indexbytes;
    static int s_blockNum;
    static byte[] m_outStream;
    static String[] m_text;
    static String[] m_levText;
    static int[] m_actorOffset;
    static byte[] m_originData;
    static long[] resInfo;
    static long[] palette;
    static long curInfo;
    static long curPal;
    static byte[] record;
    public static int m_camX;
    public static int m_camY;
    public static int m_tkImgID;
    public static int mapW;
    public static int mapH;
    public static int pMapW;
    public static int pMapH;
    private static int tileCntPerLn;
    public static byte[] mapBuf;
    public static short[] phyBuf;
    static int phyBufLen;
    private static int prevMapX0;
    private static int prevMapY0;
    private static int prevMapX1;
    private static int prevMapY1;
    public static Image backImg;
    public static Graphics backG;
    static Actor focusActor;
    static int m_maxCamX;
    static int m_minCamX;
    static int m_maxCamY;
    static int m_minCamY;
    public static byte focusX;
    public static byte focusY;

    public Player() {
        m_actors = new Actor[30];
        for (int i = 0; i < 30; ++i) {
            Player.m_actors[i] = new Actor();
            m_actors[i].cleanRoom();
        }
        displaylist_sort = new Actor[30];
        m_actorRoomID = new short[130];
        backImg = Image.createImage((int)144, (int)144);
        backG = backImg.getGraphics();
        m_tkImgID = -1;
    }

    public static Actor allocActor(int n, boolean bl) {
        if (s_freeRoomID < 30) {
            Actor actor = m_actors[s_freeRoomID];
            actor.m_roomID = s_freeRoomID;
            if (bl) {
                actor.m_actorID = n;
                Player.m_actorRoomID[n] = s_freeRoomID;
                actor.loadActor(m_originData, m_actorOffset[n]);
                int n2 = m_actorOffset[n] + 4;
                m_originData[n2] = (byte)(m_originData[n2] | 8);
            } else {
                for (int i = 100; i < 130; ++i) {
                    if (m_actorRoomID[i] != -1) continue;
                    actor.m_actorID = i;
                    Player.m_actorRoomID[i] = s_freeRoomID;
                    break;
                }
                actor.loadActor(n);
            }
            s_freeRoomID = (short)(s_freeRoomID + 1);
            actor.initAI();
            return actor;
        }
        return null;
    }

    public static void disallocActor(Actor actor, boolean bl) {
        int n = actor.m_actorID;
        Player.m_actorRoomID[n] = -1;
        if (bl && n < 100) {
            actor.packActor(m_originData, m_actorOffset[n]);
        }
        if (actor.m_roomID != (s_freeRoomID = (short)(s_freeRoomID - 1))) {
            s_actorDie = true;
            short s = actor.m_roomID;
            if (Player.m_actors[Player.s_freeRoomID].m_actorID >= 0) {
                Player.m_actorRoomID[Player.m_actors[Player.s_freeRoomID].m_actorID] = s;
            }
            Player.m_actors[s] = m_actors[s_freeRoomID];
            Player.m_actors[s].m_roomID = s;
            Player.m_actors[Player.s_freeRoomID] = actor;
        }
        actor.cleanRoom();
    }

    static void clearRooms() {
        int n;
        for (n = 0; n < 30; ++n) {
            m_actors[n].cleanRoom();
        }
        for (n = 0; n < 130; ++n) {
            Player.m_actorRoomID[n] = -1;
        }
        s_freeRoomID = 0;
    }

    static Actor getActor(int n) {
        if (n < 0) {
            return null;
        }
        if (m_actorRoomID[n] >= 0) {
            return m_actors[m_actorRoomID[n]];
        }
        return null;
    }

    static boolean isDie(int n) {
        return (m_originData[m_actorOffset[n] + 4] & 2) != 0;
    }

    static boolean inActiveZone(int n, int n2) {
        if ((n & 8) == 0 || (n & 2) == 1) {
            return false;
        }
        if ((n & 4) != 0) {
            return true;
        }
        if (focusActor == null) {
            return false;
        }
        short s = activeZones[n2++];
        short s2 = activeZones[n2++];
        if (m_camX + 128 < s || m_camY + 132 < s2) {
            return false;
        }
        short s3 = activeZones[n2++];
        short s4 = activeZones[n2++];
        return m_camX <= s3 && m_camY <= s4;
    }

    public static void updatePlayer() {
        int n;
        for (n = 0; n < m_nActors; ++n) {
            if (m_actorRoomID[n] != -1 || !Player.inActiveZone(m_originData[m_actorOffset[n] + 4], n * 4)) continue;
            Player.allocActor(n, true);
        }
        for (n = 0; n < s_freeRoomID; ++n) {
            Actor actor = m_actors[n];
            actor.ai();
            Player.displaylist_sort[n] = actor;
            if (!s_actorDie) continue;
            --n;
            s_actorDie = false;
        }
        if (Player.containsID_CAMERA()) {
            GameScreen.id_camera = true;
        } else if (GameScreen.id_camera) {
            GameScreen.id_camera = false;
        }
        Player.Camera_Tick(true);
    }

    private static boolean containsID_CAMERA() {
        for (int i = 0; i < s_freeRoomID; ++i) {
            if (Player.m_actors[i].m_animType != 20) continue;
            return true;
        }
        return false;
    }

    public static void displayPlayer() {
        if (s_freeRoomID < 0) {
            s_freeRoomID = 0;
        }
        System.arraycopy(m_actors, 0, displaylist_sort, 0, s_freeRoomID);
        Player.quicksort(0, s_freeRoomID - 1, displaylist_sort);
        for (int i = 0; i < s_freeRoomID; ++i) {
            displaylist_sort[i].draw(m_camX, m_camY);
        }
    }

    static DataInputStream openStream(String string, int n) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(string.getClass().getResourceAsStream(string));
        s_blockNum = dataInputStream.readUnsignedShort();
        s_indexbytes = new byte[s_blockNum * 4];
        dataInputStream.readFully(s_indexbytes, 0, s_blockNum * 4);
        int n2 = 0;
        if (n > 0) {
            n2 = Player.readUnsignedInt(s_indexbytes, (n - 1) * 4);
        }
        dataInputStream.skip(n2);
        return dataInputStream;
    }

    static int getBlockSize(int n) {
        int n2 = 0;
        if (n > 0) {
            n2 = Player.readUnsignedInt(s_indexbytes, (n - 1) * 4);
        }
        return Player.readUnsignedInt(s_indexbytes, n * 4) - n2;
    }

    static void closeStream(DataInputStream dataInputStream) throws Exception {
        dataInputStream.close();
        s_indexbytes = null;
        System.gc();
    }

    public static void quicksort(int n, int n2, Actor[] actorArray) {
        Actor actor;
        if (n2 <= n) {
            return;
        }
        int n3 = n - 1;
        int n4 = n2;
        int n5 = actorArray[n2].m_posY_Ground;
        while (true) {
            if (actorArray[++n3].m_posY_Ground < n5) {
                continue;
            }
            while (n5 < actorArray[--n4].m_posY_Ground && n4 != n) {
            }
            if (n3 >= n4) break;
            actor = actorArray[n3];
            actorArray[n3] = actorArray[n4];
            actorArray[n4] = actor;
        }
        actor = actorArray[n3];
        actorArray[n3] = actorArray[n2];
        actorArray[n2] = actor;
        Player.quicksort(n, n3 - 1, actorArray);
        Player.quicksort(n3 + 1, n2, actorArray);
    }

    static final int readUnsignedInt(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    static final int readUnsignedShort(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    void loadAdditionalInfo() throws Exception {
        DataInputStream dataInputStream = Player.openStream("/add.bin", 0);
        int n = dataInputStream.readUnsignedByte();
        resInfo = new long[n];
        palette = new long[n];
        record = new byte[n * 80 + 33];
        blood = new int[3];
        this.loadRecord();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readUnsignedByte();
            for (int j = 0; j < n2; ++j) {
                long l = 1L;
                int n3 = Player.m_anims[dataInputStream.readUnsignedByte()].m_imageID;
                int n4 = i;
                resInfo[n4] = resInfo[n4] | (l <<= n3);
                if (dataInputStream.readUnsignedByte() != 1) continue;
                int n5 = i;
                palette[n5] = palette[n5] | l;
            }
        }
        Player.closeStream(dataInputStream);
    }

    void loadAnimation() throws Exception {
        DataInputStream dataInputStream = Player.openStream("/anim.lz", 0);
        int n = Player.getBlockSize(0);
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        Player.closeStream(dataInputStream);
        int n2 = Player.readUnsignedShort(byArray, 0);
        m_anims = new Animation[n2];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 2, byArray.length - 2);
        dataInputStream = new DataInputStream(byteArrayInputStream);
        for (int i = 0; i < n2; ++i) {
            Animation animation;
            dataInputStream.skipBytes(2);
            Player.m_anims[i] = animation = new Animation();
            animation.loadAnimation(dataInputStream);
            ++GameScreen.s_tickGS;
        }
        byArray = null;
        m_outStream = null;
        dataInputStream.close();
        byteArrayInputStream.close();
    }

    void loadCommonString() throws Exception {
        DataInputStream dataInputStream = Player.openStream("/str.bin", 0);
        GameScreen.s_images = new Image[21][];
        int n = dataInputStream.readUnsignedByte();
        m_text = new String[n];
        for (int i = 0; i < n; ++i) {
            Player.m_text[i] = dataInputStream.readUTF();
            ++GameScreen.s_tickGS;
        }
        Player.closeStream(dataInputStream);
    }

    void loadLevelData() {
        try {
            this.loadAnimation();
            this.loadAdditionalInfo();
            ++GameScreen.s_tickGS;
            System.gc();
            GameScreen.s_inst.soundInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void loadCurLev() {
        try {
            GameScreen.s_tickGS = 2;
            Actor.s_blackRoom = false;
            this.releaseAll();
            GameScreen.s_tickGS = 3;
            this.switchRes();
            this.loadPlayfield();
            this.loadString();
            this.loadScene();
            GameScreen.s_tickGS = 40;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void releaseAll() {
        activeZones = null;
        m_actorOffset = null;
        m_originData = null;
        mapBuf = null;
        phyBuf = null;
        System.gc();
    }

    void switchRes() {
        int n;
        long l = palette[m_currentLev];
        long l2 = resInfo[m_currentLev];
        long l3 = curInfo ^ l2;
        long l4 = curPal ^ l;
        long l5 = l3 & curInfo | l4;
        long l6 = l3 & l2 | l4;
        curInfo = l2;
        curPal = l;
        for (n = 0; n < 64; ++n) {
            if ((l5 & 1L) != 0L) {
                GameScreen.releaseImage(n);
            }
            if (n == 32) {
                GameScreen.s_tickGS = 5;
            }
            l5 >>= 1;
        }
        for (n = 0; n < 64; ++n) {
            if ((l6 & 1L) != 0L) {
                GameScreen.loadImage(n, (int)l & 1);
            }
            ++GameScreen.s_tickGS;
            l6 >>= 1;
            l >>= 1;
        }
    }

    void loadPlayfield() throws Exception {
        DataInputStream dataInputStream = Player.openStream("/map.lz", m_currentLev);
        int n = Player.getBlockSize(m_currentLev);
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        Player.closeStream(dataInputStream);
        int n2 = Player.readUnsignedShort(byArray, 1);
        if (m_tkImgID != n2 && m_tkImgID >= 0) {
            GameScreen.releaseImage(m_tkImgID);
        }
        m_tkImgID = n2;
        mapW = Player.readUnsignedShort(byArray, 3);
        mapH = Player.readUnsignedShort(byArray, 5);
        GameScreen.loadImage(m_tkImgID, 0);
        GameScreen.s_tickGS += 3;
        n2 = 11;
        int n3 = mapW * mapH;
        mapBuf = new byte[n3];
        System.arraycopy(byArray, n2, mapBuf, 0, n3);
        pMapW = Player.readUnsignedShort(byArray, (n2 += n3) + 4);
        pMapH = Player.readUnsignedShort(byArray, n2 + 6);
        GameScreen.s_tickGS += 5;
        Player.init(byArray, n2 += 8);
        GameScreen.s_tickGS += 3;
        m_outStream = null;
        byArray = null;
        System.gc();
    }

    void loadString() throws Exception {
        DataInputStream dataInputStream = Player.openStream("/str.bin", 1 + m_currentLev);
        int n = dataInputStream.readUnsignedByte();
        m_levText = new String[n];
        for (int i = 0; i < n; ++i) {
            Player.m_levText[i] = dataInputStream.readUTF();
        }
        Player.closeStream(dataInputStream);
    }

    void loadScene() throws Exception {
        DataInputStream dataInputStream = Player.openStream("/scn.bin", m_currentLev);
        int n = Player.getBlockSize(m_currentLev);
        m_originData = new byte[n];
        dataInputStream.readFully(m_originData);
        Player.closeStream(dataInputStream);
        m_nActors = Player.readUnsignedShort(m_originData, 0);
        m_actorOffset = new int[m_nActors];
        n = 2;
        activeZones = new short[m_nActors * 4];
        for (int i = 0; i < m_nActors; ++i) {
            Player.m_actorOffset[i] = n;
            Player.activeZones[i * 4] = (short)Player.readUnsignedShort(m_originData, n + 10);
            Player.activeZones[i * 4 + 1] = (short)Player.readUnsignedShort(m_originData, n + 12);
            Player.activeZones[i * 4 + 2] = (short)Player.readUnsignedShort(m_originData, n + 14);
            Player.activeZones[i * 4 + 3] = (short)Player.readUnsignedShort(m_originData, n + 16);
            n += 2 + Player.readUnsignedShort(m_originData, n);
        }
    }

    void saveRecord() {
        try {
            int n;
            RecordStore recordStore = RecordStore.openRecordStore((String)"MM", (boolean)true);
            Player.record[0] = (byte)m_currentLev;
            for (n = 0; n < 3; ++n) {
                Actor actor = Actor.s_Hero.findActor(n);
                if (actor != null) {
                    Player.record[1 + n * 6] = (byte)(actor.m_gridX >> 8);
                    Player.record[2 + n * 6] = (byte)(actor.m_gridX & 0xFF);
                    Player.record[3 + n * 6] = (byte)(actor.m_gridY >> 8);
                    Player.record[4 + n * 6] = (byte)(actor.m_gridY & 0xFF);
                    Player.record[5 + n * 6] = actor.m_blood;
                    Player.record[6 + n * 6] = Actor.s_ability[n];
                    continue;
                }
                Player.record[1 + n * 6] = 0;
                Player.record[2 + n * 6] = 0;
                Player.record[3 + n * 6] = 0;
                Player.record[4 + n * 6] = 0;
            }
            Player.record[20] = Actor.s_usingItem;
            Player.record[21] = Actor.s_medicineNum;
            Player.record[22] = 1;
            Player.record[23] = (byte)Actor.s_Energy;
            for (n = 0; n < 8; ++n) {
            }
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(record, 0, record.length);
            } else {
                recordStore.setRecord(1, record, 0, record.length);
            }
            GameScreen.s_firstTimeFlag = false;
            recordStore.closeRecordStore();
            recordStore = null;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    void loadRecord() {
        try {
            int n;
            RecordStore recordStore = RecordStore.openRecordStore((String)"MM", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                GameScreen.s_firstTimeFlag = true;
                recordStore.closeRecordStore();
                recordStore = null;
                return;
            }
            record = recordStore.getRecord(1);
            recordStore.closeRecordStore();
            m_currentLev = record[0];
            if (Actor.s_ability != null) {
                for (n = 0; n < 3; ++n) {
                    Actor.teleportX[n] = ((record[1 + n * 6] & 0xFF) << 8) + (record[2 + n * 6] & 0xFF);
                    Actor.teleportY[n] = ((record[3 + n * 6] & 0xFF) << 8) + (record[4 + n * 6] & 0xFF);
                    Player.blood[n] = record[5 + n * 6];
                    Actor.s_ability[n] = record[6 + n * 6];
                }
            }
            Actor.s_usingItem = record[20];
            Actor.s_blood = (byte)blood[0];
            Actor.s_medicineNum = record[21];
            Actor.s_Energy = record[23];
            for (n = 0; n < 8; ++n) {
            }
            recordStore = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void actorChanged(int n, int n2) {
        if (n2 == -1) {
            n2 = m_currentLev;
        }
        Player.record[33 + n2 * 80 + n] = 1;
    }

    boolean isActorChanged(int n) {
        return record[33 + m_currentLev * 80 + n] == 1;
    }

    public static void init(byte[] byArray, int n) {
        tileCntPerLn = GameScreen.getImgW(m_tkImgID) / 8;
        m_maxCamX = mapW * 8 - 128;
        m_minCamX = 0;
        m_maxCamY = mapH * 8 - 132;
        m_minCamY = 0;
        m_camX = 0;
        m_camY = 0;
        focusActor = null;
        phyBufLen = pMapW * pMapH * 2;
        phyBuf = new short[phyBufLen];
        for (int i = 0; i < phyBuf.length; ++i) {
            Player.phyBuf[i] = (short)(byArray[i + n] + 1);
        }
    }

    protected static void fastDraw() {
        boolean bl;
        int n;
        int n2 = n = GameScreen.s_isCutScreen ? 15 : 0;
        if (focusActor == null) {
            GameScreen.drawFrame();
            return;
        }
        int n3 = m_camX >> 3;
        int n4 = m_camY >> 3;
        int n5 = m_camX + 128 >> 3;
        int n6 = m_camY + 132 >> 3;
        if (n3 != prevMapX0 || n5 != prevMapX1) {
            if (n5 > prevMapX1) {
                Player.mappedDraw(prevMapX1 + 1, n4, n5, n6);
            } else if (n3 < prevMapX0) {
                Player.mappedDraw(n3, n4, prevMapX0 - 1, n6);
            }
            prevMapX0 = n3;
            prevMapX1 = n5;
        }
        if (n4 != prevMapY0 || n6 != prevMapY1) {
            if (n6 > prevMapY1) {
                Player.mappedDraw(n3, prevMapY1 + 1, n5, n6);
            } else if (n4 < prevMapY0) {
                Player.mappedDraw(n3, n4, n5, prevMapY0 - 1);
            }
            prevMapY0 = n4;
            prevMapY1 = n6;
        }
        if (Actor.s_blackRoom) {
            GameScreen.drawFrame();
            return;
        }
        int n7 = m_camX % 144;
        int n8 = m_camY % 144;
        int n9 = (m_camX + 128) % 144;
        int n10 = (m_camY + 132) % 144;
        boolean bl2 = n7 < n9;
        boolean bl3 = bl = n8 < n10;
        if (bl2 && bl) {
            Player.copyFromBackImage(n7, n8, 128, 132, 0, 0);
        } else if (bl) {
            int n11 = 144 - n7;
            Player.copyFromBackImage(n7, n8, n11, 132, 0, 0);
            Player.copyFromBackImage(0, n8, n9, 132, n11, 0);
        } else if (bl2) {
            int n12 = 144 - n8;
            Player.copyFromBackImage(n7, n8 + n, 128, n12, 0, n);
            Player.copyFromBackImage(n7, -n, 128, n10, 0, n12 - n);
        } else {
            int n13 = 144 - n7;
            int n14 = 144 - n8;
            Player.copyFromBackImage(n7, n8 + n, n13, n14, 0, n);
            Player.copyFromBackImage(0, n8 + n, n9, n14, n13, n);
            Player.copyFromBackImage(n7, -n, n13, n10, 0, n14 - n);
            Player.copyFromBackImage(0, -n, n9, n10, n13, n14 - n);
        }
    }

    protected static void mappedDraw(int n, int n2, int n3, int n4) {
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                byte by = mapBuf[i % mapH * mapW + j % mapW];
                int n5 = j % 18 << 3;
                int n6 = i % 18 << 3;
                int n7 = by & 0x7F;
                int n8 = 0;
                n8 = GameScreen.trans((by & 0x80) != 0, false);
                int n9 = n7 % tileCntPerLn << 3;
                int n10 = n7 / tileCntPerLn << 3;
                backG.setClip(n5, n6, 8, 8);
                if (n8 == 0) {
                    GameScreen.drawImage_bk(m_tkImgID, n5 - n9, n6 - n10);
                    continue;
                }
                GameScreen.drawRegion_bk(m_tkImgID, n9, n10, n8, n5, n6);
            }
        }
    }

    protected static void copyFromBackImage(int n, int n2, int n3, int n4, int n5, int n6) {
        if (GameScreen.s_g != null) {
            GameScreen.s_g.setClip(n5, n6, n3, n4);
            GameScreen.s_g.drawImage(backImg, n5 - n, n6 - n2, 20);
        }
    }

    static void Camera_Tick(boolean bl) {
        int n;
        int n2;
        if (focusActor == null) {
            n2 = m_minCamX;
            n = m_minCamY;
        } else {
            n2 = (Player.focusActor.m_posX >> 8) - (128 * focusX >> 6);
            n = (Player.focusActor.m_posY_Display >> 8) - (132 * focusY >> 6);
        }
        if (bl) {
            if (n2 < m_camX - 8) {
                n2 = m_camX - 8;
            } else if (n2 > m_camX + 8) {
                n2 = m_camX + 8;
            }
            if (n < m_camY - 8) {
                n = m_camY - 8;
            } else if (n > m_camY + 8) {
                n = m_camY + 8;
            }
        }
        if (n2 < m_minCamX) {
            n2 = m_minCamX;
        } else if (n2 > m_maxCamX) {
            n2 = m_maxCamX;
        }
        if (n < m_minCamY) {
            n = m_minCamY;
        } else if (n > m_maxCamY) {
            n = m_maxCamY;
        }
        m_camX = n2;
        m_camY = n;
    }

    public static void setFocusActor(Actor actor) {
        if (focusActor == actor) {
            return;
        }
        focusActor = actor;
        Player.Camera_Tick(false);
        if (actor != null) {
            prevMapX0 = m_camX >> 3;
        }
        prevMapY0 = m_camY >> 3;
        prevMapX1 = m_camX + 128 >> 3;
        prevMapY1 = m_camY + 132 >> 3;
        Player.mappedDraw(prevMapX0, prevMapY0, prevMapX1, prevMapY1);
    }

    public static void setFocusPos(byte by, byte by2) {
        focusX = by;
        focusY = by2;
    }

    static boolean isInCamera(int n, int n2, int n3) {
        return (n2 >>= 8) < m_camY + 132 + n3 && n2 >= m_camY - n3 && (n >>= 8) < m_camX + 128 + n3 && n >= m_camX - n3;
    }

    public static boolean isWall(int n) {
        return n >= 1 && n <= 8;
    }

    public static int getWallHeight(int n) {
        return (n &= 0x7F) - 1 + 1;
    }

    public static boolean isGround(int n) {
        return n >= 9 && n <= 20;
    }

    public static int getGridIndex(int n, int n2) {
        int n3 = Player.findCenter(n, n2);
        n = n3 >> 16;
        n2 = n3 & 0xFFFF;
        int n4 = n / 6 + n2 / 6 * pMapW << 1;
        if (n2 % 6 == 5) {
            ++n4;
        }
        return n4;
    }

    public static int getPhybyGrid(int n, int n2) {
        int n3 = Player.getGridIndex(n, n2);
        if (n3 >= 0 && n3 < phyBufLen) {
            return phyBuf[n3];
        }
        return 30;
    }

    public static int findCenter(int n, int n2) {
        int n3;
        if (n % 3 == 2 && n % 3 == n2 % 3) {
            return (n << 16) + n2;
        }
        if (n % 3 == 0) {
            if ((n + 2) % 3 == n2 % 3) {
                n3 = n + 2 << 16;
                n3 += n2;
            } else {
                n3 = n - 1 << 16;
                n3 = (n - 1) % 3 == (n2 + 1) % 3 ? (n3 += n2 + 1) : (n3 += n2 - 1);
            }
        } else if (n % 3 == 1) {
            if ((n - 2) % 3 == n2 % 3) {
                n3 = n - 2 << 16;
                n3 += n2;
            } else {
                n3 = n + 1 << 16;
                n3 = (n + 1) % 3 == (n2 + 1) % 3 ? (n3 += n2 + 1) : (n3 += n2 - 1);
            }
        } else {
            n3 = n << 16;
            n3 = n % 3 == n2 % 3 ? (n3 += n2) : (n % 3 == (n2 - 2) % 3 ? (n3 += n2 - 2) : (n3 += n2 + 2));
        }
        if ((n3 >> 16) % 3 == 2 && (n3 >> 16) % 3 == (n3 & 0xFFFF) % 3) {
            return n3;
        }
        return -1;
    }

    public static int XY2grid(int n, int n2) {
        int n3 = -1;
        int n4 = (n & 0xFFFC) + 2;
        int n5 = (n2 & 0xFFFE) + 1;
        int n6 = n - n4;
        int n7 = n2 - n5 << 1;
        if (Math.abs(n6) + Math.abs(n7) <= 2) {
            n3 = n >> 2 << 1 << 16;
            n3 += n2 >> 1 << 1;
        } else {
            if ((n -= 2) < 0 || --n2 < 0) {
                return n3;
            }
            n3 = 1 + (n >> 2 << 1) << 16;
            n3 += 1 + (n2 >> 1 << 1);
        }
        return n3;
    }

    public static int grid2XY(int n, int n2) {
        int n3 = (n << 2 >> 1) + 2 << 16;
        return n3 += (n2 << 1 >> 1) + 1;
    }

    public static int getNextBigGrid(int n, int n2, int n3) {
        int n4 = Player.findCenter(n, n2);
        n = n4 >> 16;
        n2 = n4 & 0xFFFF;
        n = (n3 & 1) != 0 ? (n -= 3) : (n += 3);
        n2 = (n3 & 8) != 0 ? (n2 -= 3) : (n2 += 3);
        return (n << 16) + n2;
    }

    public static int getNextSmallGrid(int n, int n2, int n3) {
        return Player.getNextBigGrid(n, n2, n3);
    }

    public static void plantActor(int n, int n2, int n3, int n4, int n5) {
        if (n4 == 0) {
            if (n5 == 9 || n5 == 6) {
                Player.plantActor(n, n2, n3);
                Player.plantActor(n + 3, n2 - 3, n3);
                Player.plantActor(n - 3, n2 + 3, n3);
            } else {
                Player.plantActor(n, n2, n3);
                Player.plantActor(n + 3, n2 + 3, n3);
                Player.plantActor(n - 3, n2 - 3, n3);
            }
        } else {
            for (int i = -n4; i <= n4; ++i) {
                int n6 = n + i * 3;
                int n7 = n2 + i * 3;
                for (int j = -n4; j <= n4; ++j) {
                    int n8 = Player.getGridIndex(n6 - 3 * j, n7 + 3 * j);
                    if (n8 < 0 || n8 >= phyBufLen) continue;
                    int n9 = n8;
                    phyBuf[n9] = (short)(phyBuf[n9] | (n3 << 8) + 128);
                }
            }
        }
    }

    public static void plantActor(int n, int n2, int n3) {
        int n4 = Player.getGridIndex(n, n2);
        if (n4 >= 0 && n4 < phyBufLen) {
            int n5 = n4;
            phyBuf[n5] = (short)(phyBuf[n5] | (n3 << 8) + 128);
        }
    }

    public static void unplantActor(int n, int n2, int n3, int n4) {
        if (n3 == 0) {
            if (n4 == 9 || n4 == 6) {
                Player.unplantActor(n, n2);
                Player.unplantActor(n + 3, n2 - 3);
                Player.unplantActor(n - 3, n2 + 3);
            } else {
                Player.unplantActor(n, n2);
                Player.unplantActor(n + 3, n2 + 3);
                Player.unplantActor(n - 3, n2 - 3);
            }
        } else {
            for (int i = -n3; i <= n3; ++i) {
                int n5 = n + i * 3;
                int n6 = n2 + i * 3;
                for (int j = -n3; j <= n3; ++j) {
                    int n7 = Player.getGridIndex(n5 - 3 * j, n6 + 3 * j);
                    if (n7 < 0 || n7 >= phyBufLen) continue;
                    int n8 = n7;
                    phyBuf[n8] = (short)(phyBuf[n8] & 0x7F);
                }
            }
        }
    }

    public static void unplantActor(int n, int n2) {
        int n3 = Player.getGridIndex(n, n2);
        if (n3 >= 0 && n3 < phyBufLen) {
            int n4 = n3;
            phyBuf[n4] = (short)(phyBuf[n4] & 0x7F);
        }
    }

    static {
        s_freeRoomID = 0;
        s_actorDie = false;
        s_blockNum = 0;
        curInfo = 0L;
        curPal = 0L;
        focusX = (byte)32;
        focusY = (byte)32;
    }
}

