/*
 * Decompiled with CFR 0.152.
 */
public class Actor {
    public static boolean invincible = false;
    public static int numArrows = 0;
    static boolean s_upStair;
    static Player s_player;
    static int[] teleportX;
    static int[] teleportY;
    int m_posX;
    int m_posY_Display;
    int m_posY_Ground;
    int m_tarX;
    int m_tarY;
    int m_gridX;
    int m_gridY;
    int m_vX;
    int m_vY;
    int m_vZ;
    int m_aY;
    byte m_blood;
    public static byte MAXBLOOD;
    byte m_tickInvincible;
    static byte[] s_ability;
    boolean[] m_flag;
    byte[] m_parameters = new byte[15];
    int m_animType;
    int m_frameIndex;
    int m_currentActionID;
    int m_pageIDNow;
    byte m_durNow;
    boolean m_actionOver;
    Animation m_anim;
    byte m_Direction;
    byte m_preDirection;
    int m_tickAction;
    int m_currentTactic;
    int m_previousTactic;
    int m_tickTactic;
    int m_actorID;
    short m_roomID;
    int m_patrolID;
    boolean m_isValid;
    int m_tmpVar;
    boolean m_isSwitchOn;
    int m_canFakeDie;
    byte m_attribute;
    Actor m_friendActor;
    static Actor m_liftActor;
    Actor m_hurtBy;
    Actor m_shadow;
    static boolean s_bellow;
    public static int x_louis;
    public static int y_louis;
    static Actor s_getItem;
    static int s_GloriaAppearance;
    static Actor s_Hero;
    static byte s_blood;
    static int s_pressTick;
    public static int s_Energy;
    static int s_nActorBelowLouis;
    public static boolean s_attackPressed;
    static int s_position;
    static int s_gridX;
    static int s_gridY;
    static byte s_usingItem;
    static int s_dirDuration;
    static boolean s_blackRoom;
    static byte s_medicineNum;
    public static final int[] PX;
    public static final int[] PY;
    int preDistance = 0;
    static byte s_activeDragon;
    static Actor[] s_Dragon;
    static boolean s_gameComplete;

    public Actor() {
        this.m_flag = new boolean[4];
    }

    void loadActor(int n) {
        this.m_animType = n;
        this.m_anim = Player.m_anims[this.m_animType];
        this.m_currentActionID = 0;
        this.setAliveFlag(true);
        this.m_posY_Display = 0;
        this.m_posX = 0;
    }

    void loadActor(byte[] byArray, int n) {
        byte by;
        n += 2;
        this.m_animType = byArray[n++];
        this.m_anim = Player.m_anims[this.m_animType];
        this.m_currentActionID = byArray[n++];
        this.m_flag[0] = ((by = byArray[n++]) & 1) != 0;
        this.m_flag[1] = (by & 2) != 0;
        this.m_flag[2] = (by & 4) != 0;
        this.m_flag[3] = (by & 8) != 0;
        this.m_Direction = this.m_flag[0] ? (byte)4 : (byte)1;
        this.m_Direction = (this.m_currentActionID & 1) == 0 ? (byte)(this.m_Direction | 8) : (byte)(this.m_Direction | 2);
        if (!this.m_flag[3]) {
            this.m_flag[3] = true;
        }
        byte by2 = byArray[n++];
        this.m_posX = Player.readUnsignedShort(byArray, n) << 8;
        this.m_posY_Display = Player.readUnsignedShort(byArray, n += 2) << 8;
        n += 10;
        if (by2 > 0) {
            System.arraycopy(byArray, n, this.m_parameters, 0, by2);
        }
    }

    void packActor(byte[] byArray, int n) {
        n += 3;
        byArray[n++] = (byte)this.m_currentActionID;
        int n2 = 0;
        if (this.m_flag[0]) {
            n2 = (byte)(n2 + 1);
        }
        if (this.m_flag[1]) {
            n2 = (byte)(n2 + 2);
        }
        if (this.m_flag[2]) {
            n2 = (byte)(n2 + 4);
        }
        if (this.m_flag[3]) {
            n2 = (byte)(n2 + 8);
        }
        byArray[n++] = n2;
        int n3 = this.m_posX >> 8;
        int n4 = ++n;
        byArray[n4] = (byte)(n3 >> 8);
        int n5 = ++n;
        byArray[n5] = (byte)n3;
        n3 = this.m_posY_Display >> 8;
        int n6 = ++n;
        byArray[n6] = (byte)(n3 >> 8);
        int n7 = ++n;
        ++n;
        byArray[n7] = (byte)n3;
    }

    void changeAction(int n, boolean bl) {
        if ((this.m_Direction & 2) != 0) {
            n |= 1;
        }
        if (n == this.m_currentActionID && !bl && this.m_preDirection == this.m_Direction) {
            return;
        }
        if (this.m_animType != 6) {
            this.m_flag[0] = (this.m_Direction & 4) != 0;
        }
        this.m_tickAction = 0;
        this.m_actionOver = false;
        this.m_currentActionID = n;
        this.m_pageIDNow = 0;
        this.m_durNow = 0;
        this.m_frameIndex = this.m_anim.getFrame(this.m_currentActionID, this.m_pageIDNow);
        this.initMech();
    }

    void initMech() {
        byte by = this.m_anim.mechModelID[this.m_currentActionID];
        if ((by & 1) != 0) {
            this.m_vX = this.m_anim.mechModel[this.m_currentActionID << 2];
            if (this.m_flag[0]) {
                this.m_vX = -this.m_vX;
            }
        }
        if ((by & 2) != 0) {
            this.m_vZ = this.m_anim.mechModel[(this.m_currentActionID << 2) + 1];
        }
        if ((by & 4) != 0) {
            this.m_vY = this.m_anim.mechModel[(this.m_currentActionID << 2) + 2];
        }
        if ((by & 8) != 0) {
            this.m_aY = this.m_anim.mechModel[(this.m_currentActionID << 2) + 3];
        }
    }

    void draw(int n, int n2) {
        try {
            n = (this.m_posX >> 8) - n;
            n2 = (this.m_posY_Display >> 8) - n2;
            this.m_anim.draw(n, n2, this.m_flag[0], this.m_frameIndex);
            if (!GameScreen.s_pause) {
                this.m_durNow = (byte)(this.m_durNow + 1);
                if (this.m_durNow < this.m_anim.frames[this.m_currentActionID][(this.m_pageIDNow << 1) + 1]) {
                    return;
                }
                ++this.m_pageIDNow;
                if (this.m_pageIDNow > this.m_anim.nFrame[this.m_currentActionID] - 1) {
                    this.m_pageIDNow = 0;
                    this.m_actionOver = true;
                }
                this.m_frameIndex = this.m_anim.getFrame(this.m_currentActionID, this.m_pageIDNow);
                this.m_durNow = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setDirection(Actor actor) {
        if (actor == null) {
            return;
        }
        this.m_Direction = this.m_posX > actor.m_posX ? (byte)1 : (byte)4;
        this.m_Direction = this.m_posY_Ground > actor.m_posY_Ground ? (byte)(this.m_Direction | 8) : (byte)(this.m_Direction | 2);
    }

    boolean intersectColBox(Actor actor) {
        if (this.m_animType == 0 && (this.m_currentActionID & 0xFE) == 46) {
            return this.isActorInRange(actor, -this.m_anim.frameData[2], this.m_anim.frameData[2], -this.m_anim.frameData[2], this.m_anim.frameData[2]);
        }
        return this.isActorInRange(actor, this.m_anim.frameData[0], this.m_anim.frameData[1], this.m_anim.frameData[3], this.m_anim.frameData[2]);
    }

    public void initAI() {
        this.changeAction(this.m_currentActionID, true);
        this.m_posY_Ground = this.m_posY_Display;
        this.getNewGrid_G();
        switch (this.m_animType) {
            case 0: {
                this.m_isValid = true;
                if (teleportX[0] != 0) {
                    this.m_gridX = teleportX[0];
                    this.m_gridY = teleportY[0];
                    this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                    this.m_posY_Display = this.m_posY_Ground;
                    Actor.teleportX[0] = 0;
                    this.m_blood = s_blood;
                    MAXBLOOD = s_blood;
                } else {
                    MAXBLOOD = Player.m_currentLev == 0 || Player.m_currentLev == 1 ? (byte)8 : (Player.m_currentLev == 2 || Player.m_currentLev == 3 ? (byte)10 : (byte)12);
                    this.m_blood = MAXBLOOD;
                }
                this.m_shadow = this.allocTempActor(14, 0);
                Player.setFocusActor(this);
                s_Hero = this;
                this.changeTactic(0);
                GameScreen.s_updateInterface = true;
                break;
            }
            case 6: {
                this.m_isValid = true;
                this.m_parameters[0] = (byte)(this.m_currentActionID - 0);
                this.changeTactic(0);
                this.m_tmpVar = 0;
                this.m_canFakeDie = 1;
                break;
            }
            case 23: {
                this.setParaBool(7, this.m_currentActionID != 2);
                this.changeTactic(0);
                this.changeAction(6, true);
                this.m_canFakeDie = 2;
                break;
            }
            case 25: {
                this.m_isValid = true;
                this.m_tmpVar = this.m_currentActionID & 0xFC;
                if (this.m_tmpVar == 0) {
                    this.m_posY_Ground = -1;
                    this.m_isValid = false;
                } else if (this.m_tmpVar == 8) {
                    if ((this.m_currentActionID & 3) > 1) {
                        this.m_attribute = 1;
                    }
                    if (this.m_parameters[0] >= 0) {
                        s_blackRoom = true;
                    }
                } else if (this.m_tmpVar == 12) {
                    if (s_player.isActorChanged(this.m_actorID)) {
                        this.m_attribute = 1;
                        this.changeAction(14, true);
                        s_player.actorChanged(this.m_actorID, -1);
                    } else if (this.m_parameters[0] >= 0) {
                        s_blackRoom = true;
                    }
                }
                this.m_canFakeDie = 2;
                break;
            }
            case 31: {
                s_activeDragon = 0;
                Actor.s_Dragon[this.m_parameters[0]] = this;
                if (this.m_parameters[0] != 0) {
                    Actor.s_Dragon[this.m_parameters[0]].m_posY_Ground += 33792;
                }
                this.changeTactic(0);
                this.m_blood = (byte)4;
                break;
            }
            case 1: {
                this.m_isValid = true;
                MAXBLOOD = Player.m_currentLev == 0 || Player.m_currentLev == 1 ? (byte)8 : (Player.m_currentLev == 2 || Player.m_currentLev == 3 ? (byte)10 : (byte)12);
                this.m_blood = MAXBLOOD;
                s_GloriaAppearance = 0;
                s_GloriaAppearance = 0;
                if (teleportX[1] != 0) {
                    this.m_gridX = teleportX[1];
                    this.m_gridY = teleportY[1];
                    this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                    this.m_posY_Display = this.m_posY_Ground;
                    Actor.teleportX[1] = 0;
                }
                this.setParaBool(10, false);
                this.m_shadow = this.allocTempActor(14, 0);
                this.changeTactic(0);
                break;
            }
            case 2: {
                this.m_isValid = true;
                if (this.m_parameters[2] == 0) {
                    this.changeTactic(2);
                } else {
                    this.changeTactic(3);
                }
                if (this.checkParaBool(0)) {
                    this.m_blood = (byte)5;
                    break;
                }
                this.m_blood = (byte)3;
                break;
            }
            case 3: {
                this.m_isValid = true;
                if (this.checkParaBool(0)) {
                    this.m_blood = (byte)4;
                    this.changeTactic(2);
                    break;
                }
                this.changeTactic(4);
                this.m_blood = (byte)2;
                break;
            }
            case 4: {
                this.m_isValid = true;
                this.m_tmpVar = 0;
                this.m_blood = this.m_parameters[0];
                this.changeTactic(1);
                break;
            }
            case 5: {
                this.m_posY_Display -= 2560;
                this.m_blood = this.m_parameters[0];
                this.changeTactic(0);
                break;
            }
            case 9: {
                this.m_isValid = true;
                this.m_parameters[6] = (byte)(this.m_currentActionID >> 1);
                this.changeTactic(this.m_parameters[0]);
                break;
            }
            case 10: {
                this.m_isValid = true;
                this.m_tmpVar = 6;
                if ((this.m_currentActionID & 0xFE) == 0) {
                    this.patrol(2, this.m_currentActionID & 0xFE);
                }
                this.m_canFakeDie = 2;
                break;
            }
            case 11: {
                this.m_isValid = true;
                this.m_canFakeDie = 2;
                if ((this.m_currentActionID & 0xFE) != 4) break;
                this.m_canFakeDie = 0;
                this.patrol(0, this.m_currentActionID & 0xFE);
                break;
            }
            case 15: {
                this.changeAction(4, true);
                if (!s_player.isActorChanged(this.m_actorID)) break;
                this.die(true);
                break;
            }
            case 18: {
                this.m_preDirection = this.m_Direction;
                this.m_posY_Ground = (this.m_currentActionID & 0xFE) == 0 ? (this.m_posY_Ground += 12288) : (this.m_posY_Ground += 18432);
                this.m_canFakeDie = 2;
                break;
            }
            case 19: {
                if (s_player.isActorChanged(this.m_actorID) && ((this.m_currentActionID & 0xFE) == 36 || (this.m_currentActionID & 0xFE) == 46 || this.m_currentActionID <= 3)) {
                    this.die(true);
                    break;
                }
                this.m_posY_Ground = 0xFFF0000;
                this.m_tmpVar = this.m_currentActionID;
                this.changeAction(2, true);
                this.m_canFakeDie = 2;
                if ((this.m_tmpVar & 0xFE) == 20) {
                    this.m_canFakeDie = 0;
                }
                if ((this.m_tmpVar & 0xFE) != 44) break;
                this.m_vY = 0;
                this.m_vX = 0;
                break;
            }
            case 7: {
                this.changeAction(2, false);
                this.m_canFakeDie = 1;
                break;
            }
            case 22: {
                this.m_isValid = true;
                this.m_Direction = 0;
                if (this.m_actorID < 0 || !s_player.isActorChanged(this.m_actorID)) break;
                this.die(true);
                break;
            }
            case 21: {
                this.m_attribute = 1;
                break;
            }
            case 17: {
                this.m_canFakeDie = 1;
                this.m_isValid = true;
                break;
            }
            case 16: 
            case 26: {
                this.m_isValid = true;
            }
            case 13: 
            case 24: {
                this.m_canFakeDie = 1;
                break;
            }
            case 28: {
                this.m_isValid = true;
            }
        }
    }

    void die(boolean bl) {
        if (this.m_shadow != null) {
            this.m_shadow.die(true);
            this.m_shadow = null;
        }
        if (this.m_isValid) {
            if (this.m_animType != 9) {
                Player.unplantActor(this.m_gridX, this.m_gridY);
            } else if (this.m_parameters[6] == 3) {
                Player.unplantActor(this.m_gridX, this.m_gridY, 1, this.m_Direction);
            } else {
                Player.unplantActor(this.m_gridX, this.m_gridY, 0, this.m_Direction);
            }
        }
        this.setAliveFlag(false);
        Player.disallocActor(this, bl);
    }

    boolean checkParaBool(int n) {
        return this.m_parameters[n] > 0;
    }

    void setParaBool(int n, boolean bl) {
        this.m_parameters[n] = bl ? (byte)1 : 0;
    }

    void setAliveFlag(boolean bl) {
        this.m_flag[1] = !bl;
        this.m_flag[3] = bl;
    }

    void showDialog(boolean bl, int n, int n2, int n3, boolean bl2) {
        if (bl) {
            GameScreen.playSound(4);
        }
        String string = bl2 ? Player.m_levText[n3] : Player.m_text[n3];
        if (string == "") {
            return;
        }
        GameScreen.invokeDialog(n, n2, string);
    }

    void ai() {
        if (this.m_animType == 0) {
            x_louis = this.m_posX;
            y_louis = this.m_posY_Display;
        }
        if (this.m_canFakeDie > 0) {
            if (!Player.isInCamera(this.m_posX, this.m_canFakeDie == 1 ? this.m_posY_Ground : this.m_posY_Display, 20)) {
                if (this.m_animType == 24) {
                    --numArrows;
                }
                this.die(false);
                return;
            }
        }
        ++this.m_tickAction;
        ++this.m_tickTactic;
        if (this.m_tickInvincible > 0) {
            this.m_tickInvincible = (byte)(this.m_tickInvincible - 1);
        }
        if (this.m_isValid) {
            if (this.m_animType != 9) {
                Player.unplantActor(this.m_gridX, this.m_gridY);
            } else if (this.m_parameters[6] == 3) {
                Player.unplantActor(this.m_gridX, this.m_gridY, 1, this.m_Direction);
            } else {
                Player.unplantActor(this.m_gridX, this.m_gridY, 0, this.m_Direction);
            }
        }
        switch (this.m_animType) {
            case 0: {
                this.ai_Louis();
                this.m_vY += this.m_aY;
                this.m_posX += this.m_vX;
                this.m_posY_Display += this.m_vY + this.m_vZ;
                this.m_posY_Ground += this.m_vZ;
                if ((this.m_currentActionID & 0xFE) != 40 && this.m_posY_Display > this.m_posY_Ground) {
                    this.m_posY_Display = this.m_posY_Ground;
                }
                if (this.m_shadow == null) break;
                this.updateShadow();
                break;
            }
            case 6: {
                this.ai_Box();
                this.m_vY += this.m_aY;
                this.m_posX += this.m_vX;
                this.m_posY_Display += this.m_vY + this.m_vZ;
                this.m_posY_Ground += this.m_vZ;
                if (this.m_posY_Display <= this.m_posY_Ground) break;
                this.m_posY_Display = this.m_posY_Ground;
                break;
            }
            case 23: {
                this.ai_Waker();
                break;
            }
            case 8: {
                if (!this.m_actionOver) break;
                this.die(true);
                break;
            }
            case 1: {
                this.ai_Gloria();
                this.m_vY += this.m_aY;
                this.m_posX += this.m_vX;
                this.m_posY_Display += this.m_vY + this.m_vZ;
                this.m_posY_Ground += this.m_vZ;
                if (this.m_posY_Display > this.m_posY_Ground) {
                    this.m_posY_Display = this.m_posY_Ground;
                }
                if (this.m_shadow == null) break;
                this.updateShadow();
                break;
            }
            case 18: {
                this.ai_Ring();
                break;
            }
            case 9: {
                this.ai_Door();
                break;
            }
            case 25: {
                this.ai_Switch();
                break;
            }
            case 20: {
                this.ai_Camera();
                this.m_posX += this.m_vX;
                this.m_posY_Ground += this.m_vZ;
                this.m_posY_Display = this.m_posY_Ground;
                break;
            }
            case 2: {
                this.ai_Ogre();
                if (Player.m_currentLev == 2 && teleportY[0] != 0 && this.m_posX == 36864) {
                    if (!(x_louis <= 94720 && x_louis >= 59904 && y_louis <= 76544 && y_louis >= 59136 || GameScreen.s_isCutScreen)) {
                        this.m_posX += this.m_vX;
                        this.m_posY_Ground += this.m_vZ;
                    }
                } else if (!GameScreen.s_isCutScreen) {
                    this.m_posX += this.m_vX;
                    this.m_posY_Ground += this.m_vZ;
                }
                this.m_posY_Display = this.m_posY_Ground;
                break;
            }
            case 21: {
                this.ai_Bomb();
                break;
            }
            case 3: {
                this.ai_Mage();
                if (!GameScreen.s_isCutScreen) {
                    this.m_posX += this.m_vX;
                    this.m_posY_Ground += this.m_vZ;
                }
                this.m_posY_Display = this.m_posY_Ground;
                break;
            }
            case 7: {
                this.ai_Teleport();
                break;
            }
            case 4: {
                this.ai_Skeleton();
                if (!GameScreen.s_isCutScreen) {
                    this.m_posX += this.m_vX;
                    this.m_posY_Ground += this.m_vZ;
                }
                this.m_posY_Display = this.m_posY_Ground;
                break;
            }
            case 5: {
                this.ai_Bat();
                if (GameScreen.s_isCutScreen) break;
                this.m_vY += this.m_aY;
                this.m_posX += this.m_vX;
                this.m_posY_Display += this.m_vY + this.m_vZ;
                this.m_posY_Ground += this.m_vZ;
                break;
            }
            case 10: {
                this.ai_Ball();
                if (GameScreen.s_isCutScreen) break;
                this.m_vY += this.m_aY;
                this.m_posX += this.m_vX;
                this.m_posY_Display += this.m_vY + this.m_vZ;
                this.m_posY_Ground += this.m_vZ;
                break;
            }
            case 11: {
                this.ai_Platform();
                this.m_posX += this.m_vX;
                this.m_posY_Ground += this.m_vZ;
                this.m_posY_Display = this.m_posY_Ground;
                if (this.m_friendActor == null || this.m_friendActor.m_currentTactic != 16 && this.m_friendActor.m_currentTactic != 9 && this.m_friendActor.m_currentTactic != 5) break;
                if ((this.m_currentActionID & 0xFE) < 8) {
                    this.m_friendActor.copyPostion(this);
                }
                this.m_friendActor.m_posY_Ground = this.m_posY_Ground + 10;
                break;
            }
            case 13: {
                this.ai_Wind();
                this.m_posX += this.m_vX;
                this.m_posY_Ground += this.m_vZ;
                this.m_posY_Display = this.m_posY_Ground;
                break;
            }
            case 15: {
                this.ai_Flash();
                break;
            }
            case 17: {
                this.ai_Barrel();
                this.m_vY += this.m_aY;
                this.m_posX += this.m_vX;
                this.m_posY_Display += this.m_vY + this.m_vZ;
                this.m_posY_Ground += this.m_vZ;
                break;
            }
            case 16: {
                this.ai_Tree();
                break;
            }
            case 24: {
                this.ai_Arrow();
                this.m_posX += this.m_vX;
                this.m_posY_Ground += this.m_vZ;
                this.m_posY_Display = this.m_posY_Ground;
                break;
            }
            case 27: {
                this.ai_SkeletonArmor();
                this.m_posX += this.m_vX;
                this.m_posY_Ground += this.m_vZ;
                this.m_posY_Display = this.m_posY_Ground;
                break;
            }
            case 26: {
                this.ai_MageArmor();
                this.m_posX += this.m_vX;
                this.m_posY_Ground += this.m_vZ;
                if ((this.m_currentActionID & 0xFE) == 2) {
                    this.m_posY_Display = this.m_posY_Ground - 5120;
                    break;
                }
                this.m_posY_Display = this.m_posY_Ground;
                break;
            }
            case 29: {
                this.ai_IceMagic();
                break;
            }
            case 28: {
                this.ai_Ice();
                this.m_vY += this.m_aY;
                this.m_posX += this.m_vX;
                this.m_posY_Display += this.m_vY + this.m_vZ;
                this.m_posY_Ground += this.m_vZ;
                break;
            }
            case 19: {
                this.ai_Tip();
                break;
            }
            case 31: {
                this.ai_Dragon();
                this.m_posX += this.m_vX;
                this.m_posY_Display += this.m_vZ;
                this.m_posY_Ground += this.m_vZ;
                if (this.m_currentActionID >= 30 && this.m_currentActionID <= 49) {
                    int n = this.m_flag[0] ? 24 : -24;
                    int n2 = Player.XY2grid((this.m_posX >> 8) + n, (this.m_posY_Ground >> 8) + 24);
                    this.m_gridX = n2 >> 16;
                    this.m_gridY = n2 & 0xFFFF;
                    break;
                }
                this.getNewGrid_G();
                break;
            }
            case 32: {
                this.m_posX += this.m_vX;
                this.m_posY_Display += this.m_vZ;
                this.m_posY_Ground += this.m_vZ;
                this.getNewGrid_G();
                if (!Player.isInCamera(this.m_posX, this.m_posY_Display, 0)) {
                    this.die(true);
                    return;
                }
                if (this.intersectColBox(s_Hero) && Actor.s_Hero.m_tickInvincible <= 0) {
                    if ((this.m_currentActionID & 0xFE) == 4 && Actor.s_Hero.m_currentTactic == 0) {
                        Actor actor = this.allocTempActor(28, 0);
                        actor.setParaBool(2, true);
                        actor.m_friendActor = this.m_friendActor;
                        Actor.s_Hero.m_posY_Display = Actor.s_Hero.m_posY_Ground;
                        actor.copyPostion(s_Hero);
                        s_Hero.changeTactic(28);
                        Actor.s_Hero.m_tickInvincible = (byte)30;
                        this.die(true);
                    } else {
                        Actor.s_Hero.m_hurtBy = this.m_friendActor;
                        Actor.s_Hero.m_blood = (byte)(Actor.s_Hero.m_blood - 1);
                        Actor.s_Hero.m_tickInvincible = (byte)30;
                        s_Hero.changeTactic(1);
                        GameScreen.s_updateInterface = true;
                        this.die(true);
                    }
                }
                if (this.checkParaBool(0) || this.attackEnemy(0) == null) break;
                this.die(true);
            }
        }
        if (this.m_isValid && GameScreen.s_gameState == 2) {
            this.getNewGrid_G();
            if (this.m_animType != 9) {
                Player.plantActor(this.m_gridX, this.m_gridY, this.m_actorID);
            } else if (this.m_parameters[6] == 3) {
                Player.plantActor(this.m_gridX, this.m_gridY, this.m_actorID, 1, this.m_Direction);
            } else {
                Player.plantActor(this.m_gridX, this.m_gridY, this.m_actorID, 0, this.m_Direction);
            }
        }
        if (this.m_animType == 0 && this.m_currentTactic == 23) {
            this.m_isValid = false;
        }
    }

    void changeTactic(int n) {
        this.m_tickTactic = 0;
        this.m_previousTactic = this.m_currentTactic;
        this.m_currentTactic = n;
        switch (this.m_animType) {
            case 0: {
                this.changeTactic_Louis();
                break;
            }
            case 1: {
                this.changeTactic_Gloria();
                break;
            }
            case 3: {
                this.changeTactic_Mage();
                break;
            }
            case 2: {
                this.changeTactic_Ogre();
                break;
            }
            case 6: {
                this.changeTactic_Box();
                break;
            }
            case 9: {
                this.changeTactic_Door();
                break;
            }
            case 4: {
                this.changeTactic_Skeleton();
                break;
            }
            case 5: {
                this.changeTactic_Bat();
                break;
            }
            case 31: {
                this.changeTactic_Dragon();
            }
        }
    }

    boolean changeBlood(int n, Actor actor) {
        boolean bl = false;
        this.m_hurtBy = actor;
        switch (this.m_animType) {
            case 4: {
                if (this.m_hurtBy.m_animType == 13 || this.m_currentTactic == 1 || this.m_currentTactic == 2) {
                    return false;
                }
                if (this.m_hurtBy.m_animType == 29) {
                    GameScreen.playSound(2);
                    this.allocTempActor(28, 0);
                    if (this.m_friendActor != null) {
                        this.m_friendActor.die(true);
                    }
                    this.die(true);
                    return false;
                }
                if (this.m_currentTactic == 7) {
                    return false;
                }
                this.m_blood = (byte)(this.m_blood - n);
                this.m_tickInvincible = (byte)10;
                ++this.m_tmpVar;
                if (!this.checkParaBool(1)) {
                    GameScreen.playSound(2);
                }
                if (this.m_blood <= 0) {
                    this.allocTempActor(8, 0);
                    if (this.m_friendActor != null) {
                        this.m_friendActor.die(true);
                        this.m_friendActor = null;
                    }
                    if (!this.checkParaBool(1)) {
                        this.die(true);
                    } else {
                        this.die(false);
                    }
                } else {
                    this.changeTactic(0);
                }
                return true;
            }
            case 5: {
                if (this.m_hurtBy.m_animType == 13) {
                    return false;
                }
                this.m_blood = (byte)(this.m_blood - n);
                this.m_tickInvincible = (byte)10;
                if (this.m_blood <= 0) {
                    this.allocTempActor(8, 0);
                    this.die(true);
                } else {
                    this.changeTactic(5);
                }
                GameScreen.playSound(2);
                return true;
            }
            case 2: {
                if (this.m_hurtBy.m_animType == 13 || this.m_hurtBy.m_animType == 21) {
                    if (this.m_currentTactic != 8) {
                        this.changeTactic(8);
                        return true;
                    }
                } else {
                    if (this.m_currentTactic == 9 || this.m_currentTactic == 10 || this.m_currentTactic == 11 || this.m_hurtBy.m_animType == 29) {
                        return false;
                    }
                    this.changeTactic(0);
                    this.m_blood = (byte)(this.m_blood - n);
                    this.m_tickInvincible = (byte)10;
                }
                return true;
            }
            case 25: {
                if (this.m_tmpVar == 4 && !this.m_isSwitchOn) {
                    if (!this.m_isSwitchOn) {
                        this.m_isSwitchOn = true;
                        GameScreen.playSound(8);
                    }
                    this.changeAction(4, true);
                    break;
                }
                if (this.m_tmpVar != 8 && (this.m_tmpVar != 12 || this.m_isSwitchOn) || (actor.m_attribute & 1) == 0) break;
                this.m_attribute = 1;
                if (!this.m_isSwitchOn) {
                    this.m_isSwitchOn = true;
                    GameScreen.playSound(8);
                }
                s_blackRoom = false;
                if (this.m_tmpVar == 8) {
                    this.changeAction(10, true);
                    break;
                }
                this.changeAction(14, true);
                s_player.actorChanged(this.m_actorID, -1);
                break;
            }
            case 28: {
                if (this.m_hurtBy.m_animType != 13) break;
                bl = true;
                this.m_Direction = this.m_hurtBy.m_Direction;
                this.setParaBool(1, true);
                int n2 = this.getNextBigGridPhy();
                if (Player.isWall(n2)) break;
                if ((n2 & 0x80) != 0 && this.getHeight() < 20 || n2 == 0) break;
                this.changeAction(6, true);
                break;
            }
            case 17: {
                if (this.m_hurtBy.m_animType != 21 || 2 != (this.m_currentActionID & 0xFE)) break;
                this.changeAction(4, true);
                break;
            }
            case 1: {
                bl = this.changeBlood_Gloria();
                break;
            }
            case 32: {
                if ((this.m_currentActionID & 0xFE) != 0 || this.m_hurtBy.m_animType != 13) break;
                this.m_vX = -this.m_vX;
                this.m_vZ = -this.m_vZ;
                this.setParaBool(0, false);
                bl = true;
                break;
            }
            case 31: {
                n = 1;
                bl = this.changeBlood_Dragon();
                break;
            }
            case 3: {
                if (this.m_hurtBy.m_animType != 26) break;
                this.changeTactic(0);
                bl = true;
                break;
            }
            case 9: {
                this.m_tickInvincible = (byte)10;
                switch (this.m_currentTactic) {
                    case 1: {
                        boolean bl2 = true;
                        if ((this.m_currentActionID & 0xFE) == 10 && this.m_hurtBy.m_animType != 21) {
                            bl2 = false;
                        }
                        if (this.m_parameters[6] == 6 && this.m_hurtBy.m_animType != 29) {
                            bl2 = false;
                        }
                        if (!bl2) break;
                        this.changeTactic(5);
                        bl = true;
                    }
                }
                bl = false;
                break;
            }
            case 16: {
                if ((this.m_currentActionID & 0xFE) != 0) break;
                this.changeAction(2, false);
                break;
            }
            case 26: {
                if (this.m_hurtBy != null && (this.m_hurtBy.m_animType == 13 || this.m_hurtBy.m_animType == 26)) break;
                if ((this.m_currentActionID & 0xFE) == 2 && this.m_Direction + this.m_hurtBy.m_Direction == 15) {
                    this.m_Direction = this.m_hurtBy.m_Direction;
                    this.changeAction(2, true);
                    this.setParaBool(0, true);
                }
                bl = true;
            }
        }
        if (bl) {
            this.m_blood = (byte)(this.m_blood - n);
            this.m_tickInvincible = (byte)10;
        }
        return bl;
    }

    Actor attackEnemy(int n) {
        int n2 = 0;
        while (true) {
            if (n2 >= Player.s_freeRoomID) break;
            Actor actor = Player.m_actors[n2];
            if (actor != this && this.intersectColBox(actor) && actor.m_tickInvincible <= 0 && actor.m_animType != 0 && (actor.m_animType != 1 || this.m_animType == 13) && actor.changeBlood(n, this) && this.m_animType != 21) {
                return actor;
            }
            ++n2;
        }
        return null;
    }

    boolean e_attackHero(boolean bl) {
        if (Actor.s_Hero.m_tickInvincible > 0 || Actor.s_Hero.m_currentTactic == 14 || Actor.s_Hero.m_currentTactic == 28) {
            return false;
        }
        if (Actor.s_Hero.m_animType == 1 && Actor.s_Hero.m_currentTactic == 5) {
            return false;
        }
        if ((bl || this.intersectColBox(s_Hero)) && !invincible) {
            System.out.println("3");
            Actor.s_Hero.m_hurtBy = this;
            Actor.s_Hero.m_blood = (byte)(Actor.s_Hero.m_blood - 1);
            Actor.s_Hero.m_tickInvincible = (byte)30;
            if (Actor.s_Hero.m_animType == 0 && Actor.s_Hero.m_currentTactic == 24) {
                s_Hero.setXYBaseOnGrid(Actor.s_Hero.m_gridX, Actor.s_Hero.m_gridY);
            }
            s_Hero.changeTactic(1);
            GameScreen.s_updateInterface = true;
            return true;
        }
        return false;
    }

    void copyPostion(Actor actor) {
        this.m_posX = actor.m_posX;
        this.m_posY_Ground = actor.m_posY_Ground;
        this.m_posY_Display = actor.m_posY_Display;
    }

    public static int random(int n, int n2) {
        return Math.abs(GameScreen.s_ran.nextInt()) % (n2 - n + 1) + n;
    }

    void cleanRoom() {
        int n;
        for (n = 0; n < 4; ++n) {
            this.m_flag[n] = false;
        }
        for (n = 0; n < 15; ++n) {
            this.m_parameters[n] = -1;
        }
        this.m_vX = 0;
        this.m_vY = 0;
        this.m_vZ = 0;
        this.m_aY = 0;
        this.m_friendActor = null;
        this.m_blood = (byte)-1;
        this.m_tickTactic = 0;
        this.m_currentActionID = -1;
        this.m_tickAction = 0;
        this.m_Direction = 0;
        this.m_roomID = (short)-1;
        this.m_isValid = false;
        this.m_currentTactic = -1;
        this.m_previousTactic = -1;
        this.m_shadow = null;
        this.m_attribute = 0;
        this.m_isSwitchOn = false;
        this.m_patrolID = 0;
        this.m_hurtBy = null;
        this.m_tmpVar = 0;
        this.m_canFakeDie = 0;
        this.m_tickInvincible = 0;
    }

    int getHeight() {
        return this.m_posY_Ground - this.m_posY_Display - this.m_vY >> 8;
    }

    boolean dealDirKey(int n) {
        if ((GameScreen.s_currentKey & 0xF) == 0) {
            return false;
        }
        this.m_Direction = (GameScreen.s_currentKey & 9) != 0 ? (byte)1 : (byte)4;
        this.m_Direction = (GameScreen.s_currentKey & 5) != 0 ? (byte)(this.m_Direction | 8) : (byte)(this.m_Direction | 2);
        if (!this.checkParaBool(12)) {
            this.changeAction(n, false);
        }
        return true;
    }

    boolean checkTarget_G(int n) {
        return Math.abs(this.m_gridX - this.m_gridY - (this.m_tarX - this.m_tarY) >> 1) <= n && Math.abs(this.m_tarX + this.m_tarY - (this.m_gridX + this.m_gridY) >> 1) <= n;
    }

    Actor getTopBox(Actor actor) {
        while (actor.m_friendActor != null) {
            actor = actor.m_friendActor;
        }
        return actor;
    }

    Actor allocTempActor(int n, int n2) {
        Actor actor = Player.allocActor(n, false);
        actor.copyPostion(this);
        actor.m_Direction = this.m_Direction;
        if (n == 22 || n == 14) {
            actor.m_Direction = 0;
        }
        actor.changeAction(n2, true);
        return actor;
    }

    Actor checkActorByPhy(int n) {
        if ((n & 0x80) == 0) {
            return null;
        }
        return Player.getActor(n >> 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isActorBlocked() {
        int n = this.getNextBigGridPhy();
        if ((n & 0x80) != 0) return true;
        if (Player.isGround(n)) return false;
        return true;
    }

    boolean isActorToBeBlocked() {
        block7: {
            block6: {
                int n;
                block5: {
                    block4: {
                        n = this.getNextBigGridPhy();
                        if ((n & 0x80) != 0) break block4;
                        if (Player.isGround(n)) break block5;
                    }
                    return true;
                }
                n = this.getBigGridPhyAfterNext();
                if ((n & 0x80) != 0) break block6;
                if (Player.isGround(n)) break block7;
            }
            return true;
        }
        return false;
    }

    int getGridOnWall() {
        int n = Player.getNextBigGrid(this.m_gridX, this.m_gridY, this.m_Direction);
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        int n4 = Player.getPhybyGrid(n2, n3);
        if (Player.isWall(n4)) {
            n4 = Player.getWallHeight(n4);
            if ((this.m_Direction & 8) != 0) {
                n4 = -n4;
            }
        } else {
            n4 = 0;
        }
        return (n2 << 16) + (n3 += n4 * 6);
    }

    Actor findActor(int n) {
        int n2 = 0;
        while (true) {
            if (n2 >= Player.s_freeRoomID) break;
            if (Player.m_actors[n2].m_animType == n) {
                return Player.m_actors[n2];
            }
            ++n2;
        }
        return null;
    }

    void patrol(int n, int n2) {
        int n3;
        byte by = this.m_parameters[n + 1 + this.m_patrolID];
        int n4 = n3 = (by & 0x3F) << 1;
        if ((by & 0x80) != 0) {
            this.m_Direction = 1;
            n4 = -n4;
        } else {
            this.m_Direction = (byte)4;
        }
        if ((by & 0x40) != 0) {
            this.m_Direction = (byte)(this.m_Direction | 8);
            n3 = -n3;
        } else {
            this.m_Direction = (byte)(this.m_Direction | 2);
        }
        this.m_tarY = n3 + this.m_gridY;
        this.m_tarX = n4 + this.m_gridX;
        ++this.m_patrolID;
        this.m_patrolID %= this.m_parameters[n];
        this.changeAction(n2, true);
    }

    int distInRU(Actor actor) {
        return actor.m_gridX - actor.m_gridY - (this.m_gridX - this.m_gridY) >> 1;
    }

    int distInLU(Actor actor) {
        return this.m_gridX + this.m_gridY - (actor.m_gridX + actor.m_gridY) >> 1;
    }

    boolean follow(int n, int n2, Actor actor) {
        byte by = this.m_Direction;
        boolean bl = false;
        int n3 = this.distInRU(actor);
        int n4 = this.distInLU(actor);
        this.m_tarX = actor.m_gridX;
        this.m_tarY = actor.m_gridY;
        int n5 = 0;
        if (n4 > 0) {
            if (n3 > 0) {
                n5 = 5;
                this.m_Direction = (byte)12;
            } else {
                n5 = 10;
                this.m_Direction = (byte)3;
            }
        } else if (n3 > 0) {
            n5 = 10;
            this.m_Direction = (byte)12;
        } else {
            n5 = 5;
            this.m_Direction = (byte)3;
        }
        if (Math.abs(n3) <= n) {
            this.m_Direction = (byte)(n4 > 0 ? 9 : 6);
            bl = true;
        } else if (Math.abs(n4) <= n) {
            this.m_Direction = (byte)(n3 > 0 ? 12 : 3);
            bl = true;
        }
        if (this.m_animType != 5 && this.m_animType != 0) {
            if (this.isActorToBeBlocked()) {
                this.m_Direction = (byte)(this.m_Direction ^ n5);
                if (this.isActorToBeBlocked() || bl) {
                    this.m_Direction = by;
                    return false;
                }
            }
        } else if (this.getNextBigGridPhy() == 30) {
            this.m_Direction = (byte)(this.m_Direction ^ n5);
        }
        if (this.m_Direction == 9 || this.m_Direction == 6) {
            this.m_tarX = this.m_gridX - n4;
            this.m_tarY = this.m_gridY - n4;
        } else if (this.m_Direction == 12 || this.m_Direction == 3) {
            this.m_tarX = this.m_gridX + n3;
            this.m_tarY = this.m_gridY - n3;
        }
        this.preDistance = Math.abs(n3) + Math.abs(n4);
        if (this.m_Direction != by) {
            this.m_preDirection = by;
        }
        this.changeAction(n2, false);
        return true;
    }

    boolean isActorInRange(Actor actor, int n, int n2, int n3, int n4) {
        int n5 = actor.m_gridX - actor.m_gridY - (this.m_gridX - this.m_gridY) >> 1;
        int n6 = this.m_gridX + this.m_gridY - (actor.m_gridX + actor.m_gridY) >> 1;
        if (this.m_Direction == 12 || this.m_Direction == 3) {
            int n7 = n5;
            n5 = n6;
            n6 = n7;
        }
        if ((this.m_Direction & 2) != 0) {
            n6 = -n6;
        }
        if ((this.m_Direction & 4) != 0) {
            n5 = -n5;
        }
        return n6 >= n3 && n6 <= n4 && n5 >= n && n5 <= n2;
    }

    boolean isHeroInZone(int n) {
        return this.isActorInRange(s_Hero, this.m_parameters[n], this.m_parameters[n + 1], this.m_parameters[n + 2], this.m_parameters[n + 3]);
    }

    void getShadow(int n) {
        this.m_shadow = this.allocTempActor(14, n);
    }

    void updateShadow() {
        this.m_shadow.m_posX = this.m_posX;
        this.m_shadow.m_posY_Ground = this.m_shadow.m_posY_Display = this.m_posY_Ground - 256;
    }

    int getNextSmallGridPhy() {
        int n = Player.getNextSmallGrid(this.m_gridX, this.m_gridY, this.m_Direction);
        return Player.getPhybyGrid(n >> 16, n & 0xFFFF);
    }

    int getNextBigGridPhy() {
        int n = Player.getNextBigGrid(this.m_gridX, this.m_gridY, this.m_Direction);
        return Player.getPhybyGrid(n >> 16, n & 0xFFFF);
    }

    int getBigGridPhyAfterNext() {
        int n = Player.getNextBigGrid(this.m_gridX, this.m_gridY, this.m_Direction);
        n = Player.getNextBigGrid(n >> 16, n & 0xFFFF, this.m_Direction);
        return Player.getPhybyGrid(n >> 16, n & 0xFFFF);
    }

    void setXYBaseOnGrid(int n, int n2) {
        n = Player.grid2XY(n, n2);
        this.m_posX = n >> 16 << 8;
        this.m_posY_Ground = (n & 0xFFFF) << 8;
    }

    void checkBack() {
        this.m_Direction = (byte)(15 - this.m_Direction);
        if (this.isActorBlocked()) {
            this.m_vZ = 0;
            this.m_vX = 0;
        }
        this.m_Direction = (byte)(15 - this.m_Direction);
    }

    void getNewGrid_G() {
        int n = Player.XY2grid(this.m_posX >> 8, this.m_posY_Ground >> 8);
        this.m_gridX = n >> 16;
        this.m_gridY = n & 0xFFFF;
    }

    void plugFloor() {
        int n = Player.getPhybyGrid(this.m_gridX, this.m_gridY);
        if ((n & 0x80) == 0) {
            this.m_Direction = (byte)9;
            for (int i = 0; i < 4; ++i) {
                this.m_Direction = (byte)((this.m_Direction << 4) + this.m_Direction >> 1 & 0xF);
                n = this.getNextBigGridPhy();
                if ((n & 0x80) == 0) continue;
                Actor actor = Player.getActor(n >>= 8);
                if (actor == null || actor.m_animType != 6 || actor.m_friendActor != null) continue;
                actor.copyPostion(this);
                actor.m_posY_Ground = actor.m_posY_Display;
            }
        }
    }

    int randomXY(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = Actor.random(n, n2);
        int n8 = Actor.random(n3, n4);
        int n9 = Actor.random(0, 3);
        if (n9 == 0) {
            n6 = Actor.s_Hero.m_gridX - n7;
            n5 = Actor.s_Hero.m_gridY - n7;
            n6 += n8;
            n5 -= n8;
        } else if (n9 == 1) {
            n6 = Actor.s_Hero.m_gridX + n7;
            n5 = Actor.s_Hero.m_gridY - n7;
            n6 += n8;
            n5 += n8;
        } else if (n9 == 2) {
            n6 = Actor.s_Hero.m_gridX - n7;
            n5 = Actor.s_Hero.m_gridY + n7;
            n6 -= n8;
            n5 -= n8;
        } else {
            n6 = Actor.s_Hero.m_gridX + n7;
            n5 = Actor.s_Hero.m_gridY + n7;
            n6 -= n8;
            n5 += n8;
        }
        return (n6 << 16) + (n5 & 0xFFFF);
    }

    boolean switchHero(int n) {
        if (numArrows == 0) {
            int n2 = Player.getPhybyGrid(Actor.s_Hero.m_gridX, Actor.s_Hero.m_gridY);
            if (n2 == 23) {
                return false;
            }
            if (n == Actor.s_Hero.m_animType) {
                return true;
            }
            Actor actor = this.findActor(n);
            if (actor == null) {
                return false;
            }
            GameScreen.key_Clear();
            if (Actor.s_Hero.m_animType == 0) {
                s_Hero.changeTactic(26);
            } else {
                s_Hero.changeAction(0 + s_GloriaAppearance, true);
                s_Hero.setParaBool(10, false);
            }
            s_Hero = actor;
            Player.setFocusActor(s_Hero);
            GameScreen.s_updateInterface = true;
            if (actor.m_animType == 0) {
                if (Actor.s_Hero.m_previousTactic == 5 || s_Hero.checkParaBool(11) && Actor.s_Hero.m_friendActor == null) {
                    Actor.s_Hero.m_previousTactic = 0;
                }
                s_Hero.changeTactic(Actor.s_Hero.m_previousTactic);
            } else {
                s_Hero.setParaBool(10, true);
            }
            GameScreen.s_showInfoDlg = false;
            GameScreen.s_tickShow = 0;
            GameScreen.s_InfoDlgStr = null;
            return true;
        }
        return false;
    }

    void ai_Ball() {
        if (Math.abs(this.m_posY_Display - Actor.s_Hero.m_posY_Display) < 2304) {
            this.e_attackHero(false);
        }
        this.getNewGrid_G();
        this.m_isValid = this.m_posY_Display >= this.m_posY_Ground;
        switch (this.m_currentActionID & 0xFE) {
            case 0: {
                if (!this.checkTarget_G(1)) break;
                this.patrol(2, this.m_currentActionID & 0xFE);
                break;
            }
            case 2: {
                if (this.m_tickAction != this.m_parameters[1]) break;
                this.changeAction(6, true);
                this.m_tmpVar = 4;
                break;
            }
            case 4: {
                if (this.m_tickAction != this.m_parameters[1]) break;
                this.m_posY_Display = this.m_posY_Ground;
                this.changeAction(8, true);
                break;
            }
            case 6: {
                if (this.m_tickAction <= 8) break;
                this.changeAction(this.m_tmpVar, true);
            }
        }
    }

    void ai_Platform() {
        int n;
        this.getNewGrid_G();
        if (this.m_friendActor != null && this.m_friendActor.m_friendActor != this) {
            this.m_friendActor = null;
        }
        if ((n = this.m_currentActionID & 0xFE) != 6 && s_Hero.isActorInRange(this, -6, 6, 1, 6) && (Actor.s_Hero.m_animType != 0 || n != 0 && n != 4) && this.getHeight() <= s_Hero.getHeight() && this.m_friendActor == null && Actor.s_Hero.m_currentTactic == 13) {
            if (n == 2 && Actor.s_Hero.m_animType != 0) {
                return;
            }
            this.m_friendActor = s_Hero;
            Actor.s_Hero.m_friendActor = this;
            if (n != 2) {
                s_Hero.changeTactic(16);
            } else {
                s_Hero.setParaBool(13, true);
                s_Hero.changeTactic(9);
            }
        }
        switch (n) {
            case 4: {
                if (!this.checkTarget_G(0)) break;
                this.changeAction(0, true);
                break;
            }
            case 0: {
                if (this.m_tickAction <= 20) break;
                this.patrol(0, 4);
                break;
            }
            case 2: {
                if (Actor.s_Hero.m_currentTactic == 1) {
                    this.m_vZ = 0;
                    this.m_vX = 0;
                }
                if (this.getNextBigGridPhy() == 0) break;
                this.m_vZ = 0;
                this.m_vX = 0;
                int n2 = Player.findCenter(this.m_gridX, this.m_gridY);
                this.m_gridX = n2 >> 16;
                this.m_gridY = n2 & 0xFFFF;
                this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                break;
            }
            case 8: {
                if (this.m_friendActor == null) break;
                this.changeAction(10, true);
                break;
            }
            case 10: {
                if (this.m_tickAction <= 20) break;
                this.changeAction(12, true);
                break;
            }
            case 12: {
                if (this.m_tickAction <= 20) break;
                this.changeAction(6, true);
                if (this.m_friendActor != null && this.m_friendActor.m_currentTactic == 16) {
                    s_blood = (byte)-1;
                    this.m_tickAction += 50;
                    GameScreen.s_inst.changeState(16);
                }
                this.m_friendActor = null;
                break;
            }
            case 6: {
                if (this.m_tickAction <= 50) break;
                this.changeAction(8, true);
            }
        }
    }

    void changeTactic_Box() {
        this.m_isValid = false;
        switch (this.m_currentTactic) {
            case 0: {
                this.changeAction(0 + this.m_parameters[0], false);
                this.m_isValid = this.m_tmpVar <= 0;
                break;
            }
            case 2: {
                this.copyPostion(this.m_friendActor);
                this.m_posY_Ground += 256;
                this.m_posY_Display -= 6144;
                this.changeAction(0 + this.m_parameters[0], false);
                break;
            }
            case 1: {
                this.m_Direction = this.m_friendActor.m_Direction;
                this.changeAction(2 + this.m_parameters[0], false);
                if (!this.checkParaBool(1)) break;
                Player.getActor((int)this.m_parameters[1]).m_friendActor = null;
                this.m_parameters[1] = -1;
                break;
            }
            case 4: {
                int n;
                if (this.checkParaBool(1)) {
                    n = (this.m_friendActor.m_gridX << 16) + this.m_friendActor.m_gridY;
                    this.m_parameters[1] = -1;
                } else {
                    n = this.m_friendActor.getGridOnWall();
                }
                int n2 = n >> 16;
                int n3 = n & 0xFFFF;
                this.setXYBaseOnGrid(n2, n3);
                this.m_posY_Display = this.m_posY_Ground - s_nActorBelowLouis * 1536 - 6144;
                this.m_tarY = this.m_posY_Ground;
                this.m_tmpVar = 0;
                Actor actor = this.checkActorByPhy(Player.getPhybyGrid(n2, n3));
                if (actor != null && actor.m_animType == 6) {
                    actor = this.getTopBox(actor);
                    this.m_tmpVar = actor.m_tmpVar + 1;
                    this.m_tarY -= this.m_tmpVar * 6 << 8;
                    this.m_posY_Ground = actor.m_posY_Ground + 128;
                    actor.m_friendActor = this;
                    this.m_parameters[1] = (byte)actor.m_actorID;
                }
                this.m_Direction = this.m_friendActor.m_Direction;
                this.m_friendActor = null;
                this.changeAction(4 + this.m_parameters[0], false);
            }
        }
    }

    void ai_Box() {
        this.getNewGrid_G();
        switch (this.m_currentTactic) {
            case 0: {
                if (this.m_friendActor == null) {
                    if (Actor.s_Hero.m_animType != 0 || Actor.s_Hero.m_vY <= 0 || s_Hero.getHeight() >= 6) break;
                    if (Player.findCenter(this.m_gridX, this.m_gridY) != Player.findCenter(Actor.s_Hero.m_gridX, Actor.s_Hero.m_gridY)) break;
                    Actor.s_Hero.m_friendActor = this;
                    s_Hero.changeTactic(23);
                    break;
                }
                if (this.m_friendActor.m_animType != 0) break;
                if (this.m_friendActor.m_currentTactic == 6) {
                    this.changeTactic(1);
                    break;
                }
                if (!this.m_friendActor.checkParaBool(14) || this.m_friendActor.m_vY < 0) break;
                this.m_friendActor.m_friendActor = this;
                Player.unplantActor(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY);
                this.setParaBool(14, false);
                this.m_friendActor.changeTactic(23);
                this.m_friendActor = null;
                break;
            }
            case 1: {
                if (this.m_friendActor.m_currentTactic != 6 && this.m_friendActor.m_currentTactic != 8) {
                    this.changeTactic(4);
                    break;
                }
                if (!this.m_actionOver) break;
                this.changeTactic(2);
                break;
            }
            case 2: {
                this.copyPostion(this.m_friendActor);
                this.m_posY_Ground += 256;
                this.m_posY_Display -= 6144;
                if (this.m_friendActor.m_currentTactic != 7 && this.m_friendActor.m_currentTactic != 1) break;
                if (this.m_friendActor.m_currentTactic == 1) {
                    this.setParaBool(1, true);
                }
                this.changeTactic(4);
                break;
            }
            case 4: {
                if (this.m_posY_Display < this.m_tarY) break;
                this.m_posY_Display = this.m_tarY;
                this.changeTactic(0);
            }
        }
    }

    void changeTactic_Door() {
        this.m_isValid = true;
        this.m_canFakeDie = 1;
        switch (this.m_currentTactic) {
            case 3: {
                this.changeAction((this.m_parameters[6] << 1) + 0, true);
                break;
            }
            case 5: {
                this.changeAction(14 + (this.m_parameters[6] << 1), true);
                this.m_canFakeDie = 0;
            }
        }
    }

    void ai_Door() {
        if (this.m_currentTactic == 5) {
            if (this.m_tickAction > 6) {
                this.die(true);
            }
        } else if (this.m_parameters[6] == 6) {
            this.e_attackHero(false);
        }
    }

    void ai_Flash() {
        if (this.isHeroInZone(1) && Actor.s_Hero.m_posY_Display >= Actor.s_Hero.m_posY_Ground && Actor.s_Hero.m_currentTactic != 24) {
            if (this.m_parameters[0] == -1) {
                if (Actor.s_Hero.m_blood > 0) {
                    if (!GameScreen.to_save) {
                        GameScreen.to_save = true;
                        return;
                    }
                    Actor actor = this.findActor(0);
                    s_blood = actor.m_blood;
                    s_player.actorChanged(this.m_actorID, -1);
                    s_player.saveRecord();
                    this.die(true);
                    GameScreen.to_save = false;
                }
            } else if (this.m_parameters[0] == -3) {
                if (this.switchHero(0)) {
                    s_player.actorChanged(this.m_actorID, -1);
                    this.die(true);
                    return;
                }
            } else if (this.m_parameters[0] == -4 && this.switchHero(1)) {
                s_player.actorChanged(this.m_actorID, -1);
                this.die(true);
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void ai_Gloria() {
        block101: {
            if ((GameScreen.s_currentKey & 8192) != 0 && Actor.s_Hero == this && !GameScreen.s_isCutScreen && (this.m_currentTactic == 0 || this.m_currentTactic == 5) && this.switchHero(0)) {
                return;
            }
            this.m_preDirection = this.m_Direction;
            this.getNewGrid_G();
            switch (this.m_currentTactic) {
                case 0: {
                    this.m_posY_Display = this.m_posY_Ground;
                    var1_1 = Player.getPhybyGrid(this.m_gridX, this.m_gridY);
                    if (this.checkParaBool(10) && !GameScreen.s_isCutScreen) {
                        if (var1_1 == 23) {
                            Actor.s_blood = (byte)-1;
                            GameScreen.s_inst.changeState(16);
                            break;
                        }
                        if (this.dealDirKey(6 + Actor.s_GloriaAppearance)) {
                            if (0 == this.m_vX && !this.isActorBlocked()) {
                                this.initMech();
                            }
                        } else if ((GameScreen.s_pressedKey & 256) != 0) {
                            if (Actor.s_GloriaAppearance == 0) {
                                this.changeTactic(3);
                            }
                        } else if ((GameScreen.s_currentKey & 16) != 0) {
                            if (Actor.s_GloriaAppearance == 0) {
                                this.changeTactic(13);
                            } else if (var1_1 >= 9 && var1_1 <= 20) {
                                Actor.s_GloriaAppearance = 0;
                                this.changeTactic(2);
                            }
                        } else if ((GameScreen.s_currentKey & 64) != 0) {
                            if (Actor.s_GloriaAppearance != 2 && (Actor.s_ability[1] & 2) != 0) {
                                Actor.s_GloriaAppearance = 2;
                                this.changeTactic(2);
                            }
                        } else if ((GameScreen.s_currentKey & 32) != 0) {
                            if (Actor.s_GloriaAppearance != 4 && (Actor.s_ability[1] & 4) != 0) {
                                Actor.s_GloriaAppearance = 4;
                                this.changeTactic(2);
                            }
                        } else {
                            this.changeAction(0 + Actor.s_GloriaAppearance, false);
                        }
                        var1_1 = this.getNextSmallGridPhy();
                        var2_9 = var1_1 & 127;
                        var3_14 = this.checkActorByPhy(var1_1);
                        if (var3_14 != null && var3_14.m_animType != 24) {
                            if (var3_14.m_animType == 11 && Actor.s_GloriaAppearance == 0) {
                                if ((var3_14.m_currentActionID & 254) < 8 || var3_14.getHeight() != 0) break;
                                this.m_friendActor = var3_14;
                                var3_14.m_friendActor = this;
                                this.changeTactic(16);
                                break;
                            }
                            this.m_vX = 0;
                            this.m_vZ = 0;
                            break;
                        }
                        if (var2_9 >= 9 && var2_9 <= 20) break;
                        if (var2_9 > 0 && var2_9 < 9) {
                            if (Actor.s_GloriaAppearance == 0 && (this.m_Direction & 2) != 0) {
                                this.changeTactic(4);
                            } else {
                                this.m_vZ = 0;
                                this.m_vX = 0;
                            }
                        } else if (var2_9 == 21 || var2_9 == 24) {
                            if (Actor.s_GloriaAppearance == 0) {
                                this.m_vZ = 0;
                                this.m_vX = 0;
                            }
                        } else if (var2_9 > 25 && var2_9 < 30) {
                            if (Actor.s_GloriaAppearance != 0 || !this.louis_CheckSlide(var2_9, 24, 22, 12)) {
                                this.m_vZ = 0;
                                this.m_vX = 0;
                            }
                        } else {
                            this.m_vZ = 0;
                            this.m_vX = 0;
                        }
                    }
                    this.setParaBool(12, false);
                    break;
                }
                case 3: {
                    if (this.checkParaBool(10) && Actor.s_GloriaAppearance == 0) {
                        if (this.m_tickAction == 5) {
                            var1_2 = this.allocTempActor(24, 0);
                            ++Actor.numArrows;
                            var1_2.m_friendActor = this;
                            var1_2.m_posY_Ground = (this.m_Direction & 2) != 0 ? (var1_2.m_posY_Ground += 256) : (var1_2.m_posY_Ground -= 256);
                            GameScreen.playSound(1);
                        }
                        if (!this.m_actionOver) break;
                        this.changeTactic(this.m_previousTactic);
                        break;
                    }
                    this.changeTactic(this.m_previousTactic);
                    break;
                }
                case 13: {
                    switch (this.m_currentActionID & 254) {
                        case 12: {
                            if (this.m_actionOver) {
                                this.changeAction(14, false);
                                this.m_friendActor = null;
                                var1_3 = this.getNextSmallGridPhy();
                                if ((var1_3 & 127) >= 24) {
                                    this.m_vZ = 0;
                                    this.m_vX = 0;
                                }
                                if (var1_3 < 9 && var1_3 > 0 && (this.m_Direction & 2) == 0) {
                                    this.m_vX = 0;
                                    this.m_vZ = 0;
                                } else if (var1_3 < 9 && var1_3 > 0 && (this.m_Direction & 2) != 0) {
                                    var2_10 = this.getGridOnWall();
                                    this.setXYBaseOnGrid(var2_10 >> 16, var2_10 & 65535);
                                } else if ((var1_3 & 127) == 0 || (var1_3 & 127) == 21) {
                                    this.m_vX = 0;
                                    this.m_vZ = 0;
                                }
                                var2_11 = null;
                                var2_11 = this.checkActorByPhy(var1_3);
                                if (var2_11 != null) {
                                    if (var2_11.m_animType == 6) {
                                        var2_11 = this.getTopBox(var2_11);
                                        if (this.getHeight() > (var2_11.m_tmpVar + 1) * 6) break;
                                    }
                                    if (var2_11.m_animType != 11) {
                                        this.m_vZ = 0;
                                        this.m_vX = 0;
                                        break;
                                    }
                                }
                            }
                            break block101;
                        }
                        case 14: {
                            var1_4 = this.getNextSmallGridPhy();
                            if (var1_4 >= 9 || var1_4 <= 0 || (this.m_Direction & 2) != 0) ** GOTO lbl158
                            var2_12 = this.getGridOnWall();
                            var3_15 = Player.getPhybyGrid(var2_12 >> 16, var2_12 & 65535);
                            if (!Player.isGround(var3_15)) ** GOTO lbl-1000
                            if ((var3_15 & 128) != 0) lbl-1000:
                            // 2 sources

                            {
                                this.m_vX = 0;
                                this.m_vZ = 0;
                            } else if (this.getHeight() > var1_4 * 6) {
                                if (this.m_Direction == 9) {
                                    this.m_vX = -512;
                                    this.m_vZ = -256;
                                } else if (this.m_Direction == 12) {
                                    this.m_vX = 512;
                                    this.m_vZ = -256;
                                } else if (this.m_Direction == 6) {
                                    this.m_vX = 512;
                                    this.m_vZ = 256;
                                } else if (this.m_Direction == 3) {
                                    this.m_vX = -512;
                                    this.m_vZ = 256;
                                }
                                var4_18 = this.getGridOnWall();
                                this.setXYBaseOnGrid(var4_18 >> 16, var4_18 & 65535);
                                Actor.s_upStair = true;
                            } else {
                                this.m_vX = 0;
                                this.m_vZ = 0;
                            }
                            ** GOTO lbl169
lbl158:
                            // 1 sources

                            if (var1_4 < 9 && var1_4 > 0 && (this.m_Direction & 2) != 0) {
                                var2_12 = this.getGridOnWall();
                                this.setXYBaseOnGrid(var2_12 >> 16, var2_12 & 65535);
                            } else if ((var1_4 & 127) == 0 || (var1_4 & 127) == 21) {
                                this.m_vX = 0;
                                this.m_vZ = 0;
                            } else if ((var1_4 & 127) >= 24) {
                                this.m_vZ = 0;
                                this.m_vX = 0;
                            }
lbl169:
                            // 8 sources

                            var2_12 = this.getNextBigGridPhy();
                            if (Player.isWall(var2_12)) {
                                var2_12 = Player.getWallHeight(var2_12);
                                if ((this.m_Direction & 8) != 0) {
                                    var2_12 = -var2_12;
                                }
                            } else {
                                var2_12 = 0;
                            }
                            this.m_gridY += var2_12 * 6;
                            var3_16 = this.checkActorByPhy(this.getNextBigGridPhy());
                            this.m_gridY -= var2_12 * 6;
                            if (var3_16 != null) {
                                this.m_vZ = 0;
                                this.m_vX = 0;
                                if (var3_16.m_animType == 11 && (var3_16.m_currentActionID & 254) != 2 && (var3_16.m_currentActionID & 254) != 6 && var3_16.getHeight() <= this.getHeight() && var3_16.m_friendActor == null) {
                                    var3_16.m_friendActor = this;
                                    this.m_friendActor = var3_16;
                                    this.changeTactic(16);
                                }
                            }
                            if (Actor.s_upStair) {
                                if (this.m_vY > 0 && this.m_posY_Display >= this.m_posY_Ground) {
                                    this.changeAction(18, false);
                                    break;
                                }
                            } else if (this.m_posY_Display >= this.m_posY_Ground) {
                                this.changeAction(18, false);
                                break;
                            }
                            break block101;
                        }
                        case 18: {
                            this.m_tmpVar = 0;
                            this.changeTactic(0);
                        }
                    }
                    break;
                }
                case 4: {
                    var1_5 = this.getNextSmallGridPhy();
                    if (var1_5 == 0) {
                        this.m_vX = 0;
                        this.m_vZ = 0;
                    }
                    if (this.m_posY_Display < this.m_posY_Ground) break;
                    this.changeTactic(0);
                    break;
                }
                case 16: {
                    this.m_isValid = false;
                    this.m_tmpVar = 0;
                    if ((this.m_currentActionID & 254) == 20) {
                        if (!this.m_actionOver) break;
                        var1_6 = this.allocTempActor(24, 0);
                        ++Actor.numArrows;
                        var1_6.m_friendActor = this;
                        var1_6.m_posY_Ground = (this.m_Direction & 2) != 0 ? (var1_6.m_posY_Ground += 256) : (var1_6.m_posY_Ground -= 256);
                        this.changeAction(0, true);
                        GameScreen.playSound(1);
                        break;
                    }
                    if (!((this.m_friendActor.m_currentActionID & 254) < 8 && this.dealDirKey(0) || (this.m_friendActor.m_currentActionID & 254) >= 8 && this.dealDirKey(6))) {
                        if ((GameScreen.s_pressedKey & 16) != 0) {
                            this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                            this.m_friendActor.m_friendActor = null;
                            this.changeTactic(13);
                            break;
                        }
                        if ((GameScreen.s_currentKey & 256) != 0) {
                            this.changeAction(20, true);
                            break;
                        }
                        this.changeAction(0, false);
                    }
                    this.m_tarX = this.m_posX + this.m_vX;
                    this.m_tarY = this.m_posY_Display + this.m_vZ;
                    var1_7 = Player.XY2grid(this.m_tarX >> 8, this.m_tarY >> 8);
                    var2_13 = Player.getNextSmallGrid(var1_7 >> 16, var1_7 & 65535, this.m_Direction);
                    var3_17 = Player.getPhybyGrid(var2_13 >> 16, var2_13 & 65535);
                    var4_19 = this.checkActorByPhy(var3_17);
                    if (var3_17 >= 9 && var3_17 != 23) {
                        this.m_gridX = var1_7 >> 16;
                        this.m_gridY = var1_7 & 65535;
                        if (Player.findCenter(this.m_gridX, this.m_gridY) == Player.findCenter(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY)) break;
                        if (var4_19 != null) {
                            if (var4_19.m_animType == 11 && (var4_19.m_currentActionID & 254) >= 8) {
                                this.m_friendActor.m_friendActor = null;
                                this.m_friendActor = var4_19;
                                var4_19.m_friendActor = this;
                                break;
                            }
                            this.m_vZ = 0;
                            this.m_vX = 0;
                            break;
                        }
                        if (this.m_vX == 0) break;
                        var5_20 = Player.getNextBigGrid(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY, this.m_Direction);
                        var6_21 = Player.grid2XY(var5_20 >> 16, var5_20 & 65535);
                        this.m_posX = var6_21 >> 16 << 8;
                        this.m_posY_Ground = (var6_21 & 65535) << 8;
                        this.m_friendActor.m_friendActor = null;
                        this.m_friendActor = null;
                        this.changeTactic(0);
                        break;
                    }
                    this.m_vZ = 0;
                    this.m_vX = 0;
                    break;
                }
                case 1: {
                    this.checkBack();
                    if (this.m_blood <= 0) {
                        GameScreen.s_inst.changeState(16);
                        return;
                    }
                    if (!this.m_actionOver) break;
                    if (Actor.s_GloriaAppearance == 4) {
                        this.changeTactic(5);
                        break;
                    }
                    this.changeTactic(0);
                    break;
                }
                case 2: {
                    this.changeAction(0 + Actor.s_GloriaAppearance, true);
                    if (Actor.s_GloriaAppearance == 4) {
                        this.changeTactic(5);
                        break;
                    }
                    this.changeTactic(0);
                    break;
                }
                case 5: {
                    if (this.checkParaBool(10)) {
                        var1_8 = Player.getPhybyGrid(this.m_gridX, this.m_gridY) & 127;
                        if ((GameScreen.s_currentKey & 16) != 0) {
                            if (Actor.s_GloriaAppearance != 0 && var1_8 >= 9 && var1_8 <= 20) {
                                Actor.s_GloriaAppearance = 0;
                                this.changeTactic(2);
                            }
                        } else if ((GameScreen.s_currentKey & 64) != 0 && (Actor.s_ability[1] & 2) != 0) {
                            Actor.s_GloriaAppearance = 2;
                            this.changeTactic(2);
                        }
                    }
                    if ((var1_8 = this.getNextSmallGridPhy() & 127) < 9 || var1_8 > 24 || var1_8 == 22 || var1_8 == 23) {
                        this.m_vZ = 0;
                        this.m_vX = 0;
                    }
                    if ((this.m_currentActionID & 254) != 10 || this.m_tickAction <= 9) break;
                    this.changeAction(4, true);
                }
            }
        }
    }

    boolean changeBlood_Gloria() {
        if (this.m_hurtBy.m_animType == 13) {
            if (this.m_currentTactic == 5 && (this.m_currentActionID & 0xFE) == 4) {
                this.m_Direction = this.m_hurtBy.m_Direction;
                this.changeAction(10, true);
                this.m_hurtBy.die(true);
                return false;
            }
            return false;
        }
        if (this.m_hurtBy.m_animType == 24 && this.m_hurtBy.m_friendActor == this) {
            return false;
        }
        if (s_GloriaAppearance == 4 || this.m_hurtBy.m_animType == 0) {
            return false;
        }
        this.changeTactic(1);
        return true;
    }

    void changeTactic_Gloria() {
        this.m_isValid = true;
        switch (this.m_currentTactic) {
            case 1: {
                this.setDirection(this.m_hurtBy);
                this.m_hurtBy = null;
                this.changeAction(28 + s_GloriaAppearance, false);
                GameScreen.playSound(10);
                break;
            }
            case 16: {
                this.copyPostion(this.m_friendActor);
                this.changeAction(0, false);
                break;
            }
            case 4: {
                this.changeAction(16, false);
                int n = this.getNextBigGridPhy();
                if (n <= 0 || n >= 9 || (this.m_Direction & 2) == 0) break;
                int n2 = this.getGridOnWall();
                this.setXYBaseOnGrid(n2 >> 16, n2 & 0xFFFF);
                break;
            }
            case 3: {
                this.changeAction(20, true);
                break;
            }
            case 0: {
                this.getNewGrid_G();
                this.changeAction(0 + s_GloriaAppearance, true);
                this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                break;
            }
            case 13: {
                if (Player.isGround(Player.getPhybyGrid(this.m_gridX, this.m_gridY))) {
                    s_position = (this.m_gridX << 16) + this.m_gridY;
                }
                this.changeAction(12, false);
                break;
            }
            case 28: {
                this.changeAction(26, false);
            }
        }
    }

    void ai_Arrow() {
        Actor actor;
        if (this.checkParaBool(1)) {
            if (this.m_tickTactic == 2) {
                this.die(true);
                --numArrows;
            }
            return;
        }
        this.getNewGrid_G();
        Actor actor2 = this.attackEnemy(1);
        if (actor2 != null && actor2 != this.m_friendActor) {
            this.setParaBool(1, true);
            this.m_tickTactic = 0;
        }
        if ((actor = this.checkActorByPhy(this.getNextBigGridPhy())) != null) {
            if ((actor.m_attribute & 1) != 0 && (this.m_attribute & 1) == 0) {
                this.m_attribute = (byte)(this.m_attribute | 1);
                this.changeAction(6, true);
            }
            if (actor.m_animType == 9 && actor.m_parameters[6] < 2) {
                this.setParaBool(1, true);
                this.m_tickTactic = 0;
            }
        }
        if (Player.isWall(this.getBigGridPhyAfterNext()) && (this.m_Direction & 8) != 0) {
            this.setParaBool(1, true);
            this.m_vZ = 0;
            this.m_vX = 0;
            this.m_tickTactic = 0;
        }
    }

    void ai_Ice() {
        this.getNewGrid_G();
        switch (this.m_currentActionID & 0xFE) {
            case 0: {
                if (this.checkParaBool(0)) {
                    this.m_isValid = false;
                    this.copyPostion(this.m_friendActor);
                    this.m_posY_Ground += 256;
                    this.m_posY_Display -= 6144;
                    this.m_Direction = this.m_friendActor.m_Direction;
                    if (this.m_friendActor.m_currentTactic != 7 && this.m_friendActor.m_currentTactic != 1) break;
                    if (this.m_friendActor.m_currentTactic == 1) {
                        this.setXYBaseOnGrid(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY);
                    } else {
                        int n = Player.getNextBigGrid(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY, this.m_friendActor.m_Direction);
                        this.setXYBaseOnGrid(n >> 16, n & 0xFFFF);
                    }
                    this.changeAction(4, true);
                    this.setParaBool(0, false);
                    this.m_tarY = this.m_posY_Ground;
                    break;
                }
                if (!this.checkParaBool(2) || this.m_tickAction <= 30) break;
                this.changeAction(10, true);
                s_Hero.changeTactic(0);
                this.m_friendActor.e_attackHero(true);
                break;
            }
            case 10: {
                if (!this.m_actionOver) break;
                this.die(true);
                break;
            }
            case 6: {
                int n = this.getNextBigGridPhy();
                if (!Player.isWall(n)) {
                    if (((n & 0x80) == 0 || this.getHeight() >= 20) && this.m_tickAction <= 3 && n != 0 && (n <= 20 || n == 24)) break;
                }
                this.changeAction(0, true);
                break;
            }
            case 4: {
                if (this.m_posY_Display < this.m_tarY) break;
                this.m_posY_Display = this.m_posY_Ground;
                this.m_isValid = true;
                this.changeAction(0, true);
                break;
            }
            case 2: {
                if (this.m_friendActor.m_currentTactic == 1) {
                    this.setXYBaseOnGrid(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY);
                    this.changeAction(4, true);
                    this.setParaBool(0, false);
                    this.m_tarY = this.m_posY_Ground;
                    break;
                }
                if (this.m_posY_Display > this.m_tarY) break;
                this.m_posY_Display = this.m_tarY;
                this.changeAction(0, true);
                this.setParaBool(0, true);
            }
        }
    }

    void ai_Barrel() {
        this.getNewGrid_G();
        this.m_isValid = true;
        block0 : switch (this.m_currentActionID & 0xFE) {
            case 10: {
                this.m_isValid = false;
                if (this.getHeight() < 24) {
                    this.e_attackHero(false);
                    this.m_isValid = true;
                }
                if (this.m_posY_Display < this.m_posY_Ground) break;
                Actor actor = this.allocTempActor(21, 0);
                actor.setParaBool(11, true);
                this.die(true);
                break;
            }
            case 4: {
                if (!this.checkParaBool(0)) break;
                this.m_isValid = false;
                this.copyPostion(this.m_friendActor);
                this.m_Direction = this.m_friendActor.m_Direction;
                this.m_posY_Ground += 256;
                this.m_posY_Display -= 6144;
                if (this.m_friendActor.m_currentTactic != 1) break;
                this.allocTempActor(21, 0);
                this.die(false);
                break;
            }
            case 6: {
                int n = this.getNextBigGridPhy();
                if (!Player.isWall(n) || (this.m_Direction & 2) != 0) {
                    if (((n & 0x80) == 0 || this.getHeight() >= 20) && this.m_posY_Display < this.m_posY_Ground) break;
                }
                Actor actor = this.allocTempActor(21, 0);
                actor.setParaBool(10, true);
                this.die(false);
                break;
            }
            case 0: {
                int n = 0;
                while (true) {
                    if (n >= Player.s_freeRoomID) break block0;
                    Actor actor = Player.m_actors[n];
                    if (actor != this && actor.m_isValid && this.intersectColBox(actor)) {
                        System.out.println("4");
                        this.allocTempActor(21, 0);
                        this.die(true);
                        break block0;
                    }
                    ++n;
                }
            }
            case 8: {
                if (this.m_friendActor.m_currentTactic == 1) {
                    this.allocTempActor(21, 0);
                    this.die(false);
                    break;
                }
                if (this.m_posY_Display > this.m_tarY) break;
                this.m_posY_Display = this.m_tarY;
                this.changeAction(4, true);
                this.setParaBool(0, true);
            }
        }
    }

    void earthQuake() {
        if ((this.m_tickTactic & 1) == 0) {
            Player.setFocusPos((byte)27, (byte)32);
        } else {
            Player.setFocusPos((byte)37, (byte)32);
        }
    }

    public int getSidelingBigGrid(int n, int n2, int n3, int n4) {
        switch (n3) {
            case 9: {
                return Player.getPhybyGrid(n + n4, n2 - n4);
            }
            case 3: {
                return Player.getPhybyGrid(n - n4, n2 - n4);
            }
            case 12: {
                return Player.getPhybyGrid(n + n4, n2 + n4);
            }
            case 6: {
                return Player.getPhybyGrid(n - n4, n2 + n4);
            }
        }
        return 30;
    }

    public boolean checkValidBox(int n) {
        if ((n & 0x80) != 0) {
            Actor actor = this.checkActorByPhy(n);
            if (actor.m_animType == 6) {
                actor = this.getTopBox(actor);
                if (actor.m_tmpVar * 6 == this.m_posY_Ground - this.m_posY_Display >> 8) {
                    actor.m_friendActor = this;
                    this.setParaBool(14, true);
                    return true;
                }
            }
        }
        return false;
    }

    boolean checkLiftEx() {
        int n = this.getNextBigGridPhy();
        if (Player.isWall(n)) {
            return false;
        }
        if (0 == (n & 0x80)) {
            Actor actor = null;
            switch (this.m_Direction) {
                case 9: {
                    n = Player.getPhybyGrid(this.m_gridX - 6, this.m_gridY);
                    actor = this.checkActorByPhy(n);
                    if (actor != null) break;
                    n = Player.getPhybyGrid(this.m_gridX, this.m_gridY - 6);
                    actor = this.checkActorByPhy(n);
                    if (actor != null) break;
                    n = Player.getPhybyGrid(this.m_gridX - 6, this.m_gridY - 6);
                    actor = this.checkActorByPhy(n);
                    break;
                }
                case 6: {
                    n = Player.getPhybyGrid(this.m_gridX + 6, this.m_gridY);
                    actor = this.checkActorByPhy(n);
                    if (actor != null) break;
                    n = Player.getPhybyGrid(this.m_gridX, this.m_gridY + 6);
                    actor = this.checkActorByPhy(n);
                    if (actor != null) break;
                    n = Player.getPhybyGrid(this.m_gridX + 6, this.m_gridY + 6);
                    actor = this.checkActorByPhy(n);
                    break;
                }
                case 12: {
                    n = Player.getPhybyGrid(this.m_gridX, this.m_gridY - 6);
                    actor = this.checkActorByPhy(n);
                    if (actor != null) break;
                    n = Player.getPhybyGrid(this.m_gridX + 6, this.m_gridY);
                    actor = this.checkActorByPhy(n);
                    if (actor != null) break;
                    n = Player.getPhybyGrid(this.m_gridX + 6, this.m_gridY - 6);
                    actor = this.checkActorByPhy(n);
                    break;
                }
                case 3: {
                    n = Player.getPhybyGrid(this.m_gridX - 6, this.m_gridY);
                    actor = this.checkActorByPhy(n);
                    if (actor != null) break;
                    n = Player.getPhybyGrid(this.m_gridX, this.m_gridY + 6);
                    actor = this.checkActorByPhy(n);
                    if (actor != null) break;
                    n = Player.getPhybyGrid(this.m_gridX - 6, this.m_gridY + 6);
                    actor = this.checkActorByPhy(n);
                }
            }
            if (actor != null) {
                return this.louis_FaceActor(actor);
            }
        }
        return false;
    }

    boolean louis_FaceActor(Actor actor) {
        switch (actor.m_animType) {
            case 6: {
                actor = this.getTopBox(actor);
                this.changeTactic(6);
                actor.m_friendActor = this;
                m_liftActor = actor;
                return true;
            }
            case 17: {
                if ((actor.m_currentActionID & 0xFE) != 4) break;
                this.changeTactic(6);
                actor.m_friendActor = this;
                actor.changeAction(8, true);
                actor.m_tarY = this.m_posY_Ground - 6144;
                m_liftActor = actor;
                return true;
            }
            case 28: {
                if ((actor.m_currentActionID & 0xFE) != 0) break;
                this.changeTactic(6);
                actor.m_friendActor = this;
                actor.changeAction(2, true);
                actor.m_tarY = this.m_posY_Ground - 6144;
                m_liftActor = actor;
                return true;
            }
            case 22: {
                s_player.actorChanged(actor.m_actorID, -1);
                s_getItem = actor;
                Actor.s_getItem.m_posX = Actor.s_Hero.m_posX;
                Actor.s_getItem.m_posY_Ground += 256;
                Actor.s_getItem.m_posY_Display -= 6144;
                GameScreen.s_updateInterface = true;
                this.changeTactic(14);
                return true;
            }
        }
        return false;
    }

    boolean louis_CheckSlide(int n, int n2, int n3, int n4) {
        if (this.m_vX == 0) {
            return false;
        }
        int n5 = 0;
        switch (n) {
            case 26: {
                if (this.m_Direction == 3 || this.m_Direction == 12) {
                    return false;
                }
                n5 = Player.getPhybyGrid(this.m_gridX - 1, this.m_gridY + 1);
                break;
            }
            case 29: {
                if (this.m_Direction == 3 || this.m_Direction == 12) {
                    return false;
                }
                n5 = Player.getPhybyGrid(this.m_gridX + 1, this.m_gridY - 1);
                break;
            }
            case 27: {
                if (this.m_Direction == 9 || this.m_Direction == 6) {
                    return false;
                }
                n5 = Player.getPhybyGrid(this.m_gridX - 1, this.m_gridY - 1);
                break;
            }
            case 28: {
                if (this.m_Direction == 9 || this.m_Direction == 6) {
                    return false;
                }
                n5 = Player.getPhybyGrid(this.m_gridX + 1, this.m_gridY + 1);
            }
        }
        if (Player.isGround(n5) && null == this.checkActorByPhy(n5)) {
            if (n == 26 || n == 28) {
                this.changeAction(n2, false);
                this.setParaBool(n4, true);
                return true;
            }
            if (n == 27 || n == 29) {
                this.changeAction(n3, false);
                this.setParaBool(n4, true);
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    void ai_Louis() {
        block189: {
            Actor.s_pressTick = (GameScreen.s_currentKey & 256) != 0 ? ++Actor.s_pressTick : 0;
            if ((GameScreen.s_currentKey & 8192) != 0 && (this.m_currentTactic == 0 || this.m_currentTactic == 27) && this.switchHero(1)) {
                return;
            }
            Actor.s_dirDuration = this.m_preDirection == this.m_Direction ? ++Actor.s_dirDuration : 0;
            this.m_preDirection = this.m_Direction;
            this.getNewGrid_G();
            switch (this.m_currentTactic) {
                case 0: {
                    if (Player.getPhybyGrid(this.m_gridX, this.m_gridY) == 23) {
                        Actor.s_blood = (byte)-1;
                        GameScreen.s_inst.changeState(16);
                        break;
                    }
                    this.m_posY_Display = this.m_posY_Ground;
                    if (this.dealDirKey(4)) {
                        if (0 == this.m_vX && !this.isActorBlocked()) {
                            this.initMech();
                        }
                    } else if ((GameScreen.s_currentKey & 256) != 0) {
                        this.changeAction(0, false);
                        if (this.storeEnergy()) {
                            ++Actor.s_Energy;
                            break;
                        }
                        if (this.checkLiftEx()) break;
                        if (!Actor.s_attackPressed) {
                            this.changeTactic(12);
                        }
                    } else {
                        if ((GameScreen.s_pressedKey & 16) != 0) {
                            this.changeTactic(13);
                            break;
                        }
                        if ((GameScreen.s_pressedKey & 32) != 0) {
                            this.chooseItem(true);
                            break;
                        }
                        if ((GameScreen.s_pressedKey & 128) != 0) {
                            this.chooseItem(false);
                            break;
                        }
                        if ((GameScreen.s_pressedKey & 64) != 0) {
                            if (Actor.s_usingItem == 5) {
                                this.m_blood = (byte)(this.m_blood + 6);
                                if (this.m_blood > Actor.MAXBLOOD) {
                                    this.m_blood = Actor.MAXBLOOD;
                                }
                                if ((Actor.s_medicineNum = (byte)(Actor.s_medicineNum - 1)) == 0) {
                                    Actor.s_ability[0] = (byte)(Actor.s_ability[0] & -33);
                                    Actor.s_usingItem = (Actor.s_ability[0] & 4) != 0 ? (byte)2 : (byte)-1;
                                }
                                GameScreen.s_updateInterface = true;
                                break;
                            }
                            if (this.magic()) {
                                this.changeTactic(5);
                                break;
                            }
                        } else {
                            this.changeAction(0, false);
                        }
                    }
                    var1_1 = this.getNextSmallGridPhy();
                    this.setParaBool(12, false);
                    if ((var1_1 & 128) == 0) {
                        if (var1_1 == 0 || var1_1 < 9 && (this.m_Direction & 2) == 0 || var1_1 >= 23 || (Actor.s_ability[0] & 2) == 0 && var1_1 == 21) {
                            if (this.louis_CheckSlide(var1_1, 8, 6, 12)) break;
                            this.m_vZ = 0;
                            this.m_vX = 0;
                        } else if (var1_1 < 9 && (this.m_Direction & 2) != 0 && this.m_vX != 0) {
                            this.changeTactic(4);
                        }
                        if (GameScreen.s_currentKey != 256 || ((var1_1 = this.getNextBigGridPhy()) & 128) == 0) break;
                        var2_10 = Player.getActor(var1_1 >> 8);
                        this.louis_FaceActor(var2_10);
                        break;
                    }
                    var2_11 = Player.getActor(var1_1 >>= 8);
                    this.m_vX = 0;
                    this.m_vZ = 0;
                    if (var2_11.m_animType == 11) {
                        if ((var2_11.m_currentActionID & 254) == 2) {
                            this.setParaBool(13, true);
                            this.changeTactic(9);
                            this.m_friendActor = var2_11;
                            var2_11.m_friendActor = this;
                            break;
                        }
                        if ((var2_11.m_currentActionID & 254) < 8 || var2_11.getHeight() != 0) break;
                        this.m_friendActor = var2_11;
                        var2_11.m_friendActor = this;
                        this.changeTactic(16);
                        break;
                    }
                    if (GameScreen.s_currentKey != 256) break;
                    this.louis_FaceActor(var2_11);
                    break;
                }
                case 24: {
                    switch (this.m_currentActionID & 254) {
                        case 38: {
                            if (!this.m_actionOver) break;
                            this.m_friendActor = null;
                            this.changeTactic(0);
                            break;
                        }
                        case 48: {
                            if (this.m_tickAction > 8) {
                                Player.setFocusPos((byte)32, (byte)(32 - (this.m_tickAction - 8) << 2));
                            }
                            if (!this.m_actionOver) break;
                            var1_2 = Player.getNextBigGrid(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY, this.m_Direction);
                            this.m_gridX = var1_2 >> 16;
                            this.m_gridY = var1_2 & 65535;
                            this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                            this.m_posY_Display = this.m_posY_Ground;
                            this.changeTactic(0);
                            this.m_friendActor = null;
                            break;
                        }
                        case 40: {
                            var1_3 = Player.getNextBigGrid(Actor.s_gridX, Actor.s_gridY, this.m_Direction);
                            if (this.m_frameIndex >= 72) {
                                var2_12 = this.m_frameIndex - 72;
                                var4_21 = Actor.PX[var2_12];
                            } else {
                                var2_12 = this.m_frameIndex - 59;
                                var4_21 = Actor.PY[var2_12];
                            }
                            for (var5_26 = 0; var5_26 < var2_12; ++var5_26) {
                                var1_3 = Player.getNextBigGrid(var1_3 >> 16, var1_3 & 65535, this.m_Direction);
                            }
                            this.m_gridX = var1_3 >> 16;
                            this.m_gridY = var1_3 & 65535;
                            if ((GameScreen.s_pressedKey & 16) == 0) break;
                            this.setXYBaseOnGrid(var1_3 >> 16, var1_3 & 65535);
                            this.m_posY_Display = this.m_posY_Ground + (var4_21 << 8);
                            this.changeTactic(13);
                        }
                    }
                    break;
                }
                case 23: {
                    this.m_isValid = false;
                    this.m_posY_Ground = this.m_friendActor.m_posY_Ground + 128;
                    var1_4 = null;
                    if (!this.dealDirKey(this.checkParaBool(11) != false ? 30 : 4)) {
                        if ((GameScreen.s_currentKey & 256) != 0) {
                            this.m_vZ = 0;
                            this.m_vX = 0;
                            this.m_tarX = this.m_posX + this.m_vX;
                            this.m_tarY = this.m_posY_Display + this.m_vZ + Actor.s_nActorBelowLouis * 1536;
                            var2_13 = Player.XY2grid(this.m_tarX >> 8, this.m_tarY >> 8);
                            var3_30 = Player.getNextBigGrid(var2_13 >> 16, var2_13 & 65535, this.m_Direction);
                            var4_22 = Player.getPhybyGrid(var3_30 >> 16, var3_30 & 65535);
                            var1_4 = this.checkActorByPhy(var4_22);
                            if (this.checkParaBool(11)) {
                                if (var1_4 != null) {
                                    if (var1_4.m_animType != 6) break;
                                    var1_4 = this.getTopBox(var1_4);
                                    if (var1_4.m_tmpVar > Actor.s_nActorBelowLouis) break;
                                }
                                if (var4_22 < 9 || (var4_22 & 127) > 20) break;
                                Actor.m_liftActor = null;
                                this.changeTactic(7);
                            } else {
                                if (var1_4 != null && var1_4.m_animType == 6) {
                                    var1_4 = this.getTopBox(var1_4);
                                    if (var1_4.m_tmpVar > Actor.s_nActorBelowLouis) break;
                                    if (var1_4.m_tmpVar == Actor.s_nActorBelowLouis) {
                                        var1_4.m_friendActor = this;
                                        Actor.m_liftActor = var1_4;
                                        this.changeTactic(6);
                                        break;
                                    }
                                }
                                if (this.storeEnergy()) {
                                    ++Actor.s_Energy;
                                } else if (!Actor.s_attackPressed) {
                                    this.changeTactic(12);
                                }
                            }
                        } else {
                            if ((GameScreen.s_pressedKey & 16) != 0 && !this.checkParaBool(11)) {
                                this.changeTactic(13);
                                break;
                            }
                            if ((GameScreen.s_pressedKey & 32) != 0) {
                                this.chooseItem(true);
                                break;
                            }
                            if ((GameScreen.s_pressedKey & 128) != 0) {
                                this.chooseItem(false);
                                break;
                            }
                            if (this.checkParaBool(11)) {
                                this.changeAction(28, false);
                            } else {
                                this.changeAction(0, false);
                            }
                        }
                    }
                    this.m_tarX = this.m_posX + this.m_vX;
                    this.m_tarY = this.m_posY_Display + this.m_vZ + Actor.s_nActorBelowLouis * 1536;
                    var2_13 = Player.XY2grid(this.m_tarX >> 8, this.m_tarY >> 8);
                    var3_30 = Player.getNextBigGrid(this.m_gridX, this.m_gridY, this.m_Direction);
                    var4_22 = Player.getPhybyGrid(var3_30 >> 16, var3_30 & 65535);
                    var1_4 = this.checkActorByPhy(var4_22);
                    if (var4_22 >= 9 && var4_22 <= 20 || var4_22 == 21 && 0 != (Actor.s_ability[0] & 2) || var1_4 != null) {
                        this.m_gridX = var2_13 >> 16;
                        this.m_gridY = var2_13 & 65535;
                        if (Player.findCenter(this.m_gridX, this.m_gridY) == Player.findCenter(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY)) break;
                        if (var1_4 != null) {
                            var1_4 = this.getTopBox(var1_4);
                            if (var1_4.m_animType == 6 && var1_4.m_tmpVar < Actor.s_nActorBelowLouis) {
                                this.m_friendActor = var1_4;
                                this.changeTactic(23);
                                break;
                            }
                            this.m_vZ = 0;
                            this.m_vX = 0;
                            break;
                        }
                        if (this.m_vX == 0) break;
                        var5_27 = Player.getNextBigGrid(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY, this.m_Direction);
                        var6_35 = Player.grid2XY(var5_27 >> 16, var5_27 & 65535);
                        this.m_posX = var6_35 >> 16 << 8;
                        this.m_posY_Ground = (var6_35 & 65535) << 8;
                        this.changeTactic(21);
                        break;
                    }
                    this.m_vZ = 0;
                    this.m_vX = 0;
                    break;
                }
                case 13: {
                    switch (this.m_currentActionID & 254) {
                        case 18: {
                            if (this.m_actionOver) {
                                if (Actor.s_nActorBelowLouis > 0) {
                                    this.m_posY_Ground = this.m_posY_Display + Actor.s_nActorBelowLouis * 1536;
                                }
                                this.getNewGrid_G();
                                this.changeAction(20, false);
                                this.m_friendActor = null;
                                var1_5 = this.getNextSmallGridPhy();
                                if ((var1_5 & 127) >= 24) {
                                    this.m_vZ = 0;
                                    this.m_vX = 0;
                                } else if ((var1_5 & 127) == 21 && (Actor.s_ability[0] & 2) == 0) {
                                    this.m_vZ = 0;
                                    this.m_vX = 0;
                                }
                                if (var1_5 < 9 && var1_5 > 0 && (this.m_Direction & 2) == 0) {
                                    this.m_vX = 0;
                                    this.m_vZ = 0;
                                } else if (var1_5 < 9 && var1_5 > 0 && (this.m_Direction & 2) != 0) {
                                    var2_14 = this.getGridOnWall();
                                    this.setXYBaseOnGrid(var2_14 >> 16, var2_14 & 65535);
                                } else if (var1_5 == 0) {
                                    this.m_vX = 0;
                                    this.m_vZ = 0;
                                }
                                var2_15 = this.checkActorByPhy(var1_5);
                                if (var2_15 != null) {
                                    if (var2_15.m_animType == 6) {
                                        var2_15 = this.getTopBox(var2_15);
                                        if (this.getHeight() > (var2_15.m_tmpVar + 1) * 6) break;
                                    }
                                    if (var2_15.m_animType != 11) {
                                        this.m_vZ = 0;
                                        this.m_vX = 0;
                                    }
                                }
                                var3_31 = this.getNextBigGridPhy();
                                if ((var3_31 & 128) == 0) {
                                    var4_23 = Player.getNextBigGrid(this.m_gridX, this.m_gridY, this.m_Direction);
                                    var5_28 = var4_23 >> 16;
                                    var6_36 = var4_23 & 65535;
                                    var8_39 = var7_38 = Player.getPhybyGrid(var5_28, var6_36);
                                    if (!(this.checkValidBox(var7_38) || this.checkValidBox(var7_38 = this.getSidelingBigGrid(var5_28, var6_36, this.m_Direction, -3)) || this.checkValidBox(var7_38 = this.getSidelingBigGrid(var5_28, var6_36, this.m_Direction, 3)))) {
                                        if (!Player.isWall(var8_39) && (var8_39 & 128) == 0) {
                                            var4_23 = Player.getNextBigGrid(var5_28, var6_36, this.m_Direction);
                                            var7_38 = Player.getPhybyGrid(var4_23 >> 16, var4_23 & 65535);
                                            this.checkValidBox(var7_38);
                                            break;
                                        }
                                    }
                                }
                            }
                            break block189;
                        }
                        case 20: {
                            var1_6 = this.getNextSmallGridPhy();
                            if (Player.isWall(var1_6) && (this.m_Direction & 2) == 0) {
                                var2_16 = this.getGridOnWall();
                                var3_32 = Player.getPhybyGrid(var2_16 >> 16, var2_16 & 65535);
                                if ((var3_32 & 128) != 0) {
                                    this.m_vX = 0;
                                    this.m_vZ = 0;
                                } else if (this.getHeight() > var1_6 * 6) {
                                    if (this.m_Direction == 9) {
                                        this.m_vX = -512;
                                        this.m_vZ = -256;
                                    } else if (this.m_Direction == 12) {
                                        this.m_vX = 512;
                                        this.m_vZ = -256;
                                    } else if (this.m_Direction == 6) {
                                        this.m_vX = 512;
                                        this.m_vZ = 256;
                                    } else if (this.m_Direction == 3) {
                                        this.m_vX = -512;
                                        this.m_vZ = 256;
                                    }
                                    var4_24 = this.getGridOnWall();
                                    this.setXYBaseOnGrid(var4_24 >> 16, var4_24 & 65535);
                                    Actor.s_upStair = true;
                                } else {
                                    this.m_vX = 0;
                                    this.m_vZ = 0;
                                }
                            } else if (var1_6 < 9 && var1_6 > 0 && (this.m_Direction & 2) != 0) {
                                var2_16 = this.getGridOnWall();
                                this.setXYBaseOnGrid(var2_16 >> 16, var2_16 & 65535);
                            } else if (var1_6 == 0) {
                                this.m_vX = 0;
                                this.m_vZ = 0;
                            } else if ((var1_6 & 127) >= 24) {
                                this.m_vZ = 0;
                                this.m_vX = 0;
                            } else if ((var1_6 & 127) == 21 && (Actor.s_ability[0] & 2) == 0) {
                                this.m_vZ = 0;
                                this.m_vX = 0;
                            }
                            var2_17 = this.checkActorByPhy(Player.getPhybyGrid(this.m_gridX, this.m_gridY));
                            if (var2_17 != null && var2_17.m_animType == 6 && var2_17.m_friendActor != this && this.getHeight() < (var2_17.m_tmpVar + 1) * 6) {
                                if (Player.findCenter(this.m_gridX, this.m_gridY) == Player.findCenter(var2_17.m_gridX, var2_17.m_gridY) && this.m_vY > 0) {
                                    this.m_friendActor = var2_17;
                                    this.m_posY_Display = this.m_posY_Ground - ((var2_17.m_tmpVar + 1) * 6 << 8);
                                    this.m_tarY = this.m_posY_Ground;
                                    this.changeTactic(23);
                                    break;
                                }
                                this.m_vZ = 0;
                                this.m_vX = 0;
                            }
                            if ((var3_33 = this.checkActorByPhy(var1_6)) == null) ** GOTO lbl362
                            if (var3_33.m_animType != 6) ** GOTO lbl353
                            var3_33 = this.getTopBox(var3_33);
                            if (this.getHeight() > (var3_33.m_tmpVar + 1 + (Player.isWall(var1_6) ? Player.getWallHeight(var1_6) : 0)) * 6) {
                                if (Player.findCenter(this.m_gridX, this.m_gridY) == Player.findCenter(var3_33.m_gridX, var3_33.m_gridY) && this.m_vY >= 0) {
                                    this.m_friendActor = var3_33;
                                    this.m_posY_Display = this.m_posY_Ground - ((var3_33.m_tmpVar + 1) * 6 << 8);
                                    this.m_tarY = this.m_posY_Ground;
                                    this.changeTactic(23);
                                    break;
                                }
                            } else {
                                this.m_vZ = 0;
                                this.m_vX = 0;
lbl353:
                                // 2 sources

                                if (var3_33.m_animType != 11) {
                                    this.m_vZ = 0;
                                    this.m_vX = 0;
                                } else {
                                    var4_24 = var3_33.m_currentActionID & 254;
                                    if (var4_24 != 6 && var4_24 != 0 && var4_24 != 4 && var3_33.getHeight() <= this.getHeight() && var3_33.m_friendActor == null) {
                                        var3_33.m_friendActor = this;
                                        this.m_friendActor = var3_33;
                                        this.changeTactic(16);
                                    }
                                }
lbl362:
                                // 5 sources

                                if (Actor.s_upStair) {
                                    if (this.m_vY > 0 && this.m_posY_Display >= this.m_posY_Ground) {
                                        this.changeAction(22, false);
                                        break;
                                    }
                                } else if (this.m_posY_Display >= this.m_posY_Ground) {
                                    this.changeAction(22, false);
                                    break;
                                }
                            }
                            break block189;
                        }
                        case 22: {
                            this.changeTactic(0);
                        }
                    }
                    break;
                }
                case 18: {
                    switch (this.m_currentActionID & 254) {
                        case 18: {
                            if (!this.m_actionOver) break;
                            this.changeAction(20, false);
                            this.m_vX = this.m_friendActor.m_posX - this.m_posX >> 2;
                            this.m_vY = this.m_friendActor.m_posY_Display - 1536 - this.m_posY_Display >> 2;
                            this.m_aY = 0;
                            this.m_vZ = 0;
                            break;
                        }
                        case 20: {
                            if (this.m_tickAction == 4) {
                                this.changeAction(22, false);
                                break;
                            }
                            if (this.m_tickAction != 2) break;
                            this.m_posY_Ground = this.m_friendActor.m_posY_Ground + 10;
                            break;
                        }
                        case 22: {
                            if (!this.m_actionOver) break;
                            if (0 == Actor.s_nActorBelowLouis) {
                                this.m_posY_Ground = this.m_posY_Display;
                            }
                            this.changeTactic(23);
                        }
                    }
                    break;
                }
                case 12: {
                    if (this.m_tickTactic == 1) {
                        if (Actor.s_Energy == 10) {
                            this.changeAction(46, false);
                            Actor.s_Energy = 0;
                            GameScreen.s_updateInterface = true;
                            GameScreen.s_drawSuperAttack = true;
                            break;
                        }
                        this.changeAction(10, false);
                    }
                    if (this.m_tickTactic > 2) {
                        if ((this.m_currentActionID & 254) == 10) {
                            this.attackEnemy(1);
                        } else {
                            this.attackEnemy(2);
                        }
                    }
                    if (!this.m_actionOver) break;
                    GameScreen.s_tickGS = 0;
                    if (Actor.s_nActorBelowLouis > 0) {
                        this.changeTactic(23);
                        break;
                    }
                    this.changeTactic(0);
                    break;
                }
                case 6: {
                    this.changeAction(24, false);
                    if (!this.m_actionOver) break;
                    if (Actor.s_nActorBelowLouis > 0) {
                        this.setParaBool(11, true);
                        this.changeTactic(23);
                        break;
                    }
                    this.changeTactic(8);
                    break;
                }
                case 7: {
                    if (!this.m_actionOver) break;
                    Actor.m_liftActor = null;
                    if (Actor.s_nActorBelowLouis > 0) {
                        this.changeTactic(23);
                    } else {
                        this.changeTactic(0);
                    }
                    this.changeAction(0, false);
                    break;
                }
                case 8: {
                    this.m_posY_Display = this.m_posY_Ground;
                    var1_7 = null;
                    if (this.dealDirKey(30)) {
                        if (0 == this.m_vX && !this.isActorBlocked()) {
                            this.initMech();
                        }
                    } else if ((GameScreen.s_pressedKey & 256) != 0) {
                        this.m_vZ = 0;
                        this.m_vX = 0;
                        if (Actor.m_liftActor.m_animType == 17) {
                            Actor.m_liftActor.changeAction(6, true);
                            this.changeTactic(7);
                            break;
                        }
                        var2_18 = this.getNextBigGridPhy();
                        var1_7 = this.checkActorByPhy(var2_18);
                        if (var1_7 != null) {
                            if (Actor.m_liftActor.m_animType == 28 || var1_7.m_animType != 6) break;
                            var1_7 = this.getTopBox(var1_7);
                            if (var1_7.m_tmpVar > 0) break;
                        }
                        if ((var2_18 &= 127) == 24 && Actor.m_liftActor.m_animType == 28) {
                            this.changeTactic(7);
                            break;
                        }
                        if (!Player.isGround(var2_18)) break;
                        this.changeTactic(7);
                    } else {
                        this.changeAction(28, false);
                    }
                    if ((var1_7 = this.checkActorByPhy(var2_18 = this.getNextSmallGridPhy())) != null) {
                        this.m_vX = 0;
                        this.m_vZ = 0;
                        break;
                    }
                    if (var2_18 < 9 || var2_18 >= 23 || var2_18 == 21 && (Actor.s_ability[0] & 2) == 0) {
                        if (this.louis_CheckSlide(var2_18, 34, 32, 12)) break;
                        this.m_vZ = 0;
                        this.m_vX = 0;
                    }
                    this.setParaBool(12, false);
                    break;
                }
                case 9: {
                    if (this.dealDirKey(4)) {
                        var1_8 = Player.getNextSmallGrid(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY, this.m_Direction);
                        this.m_gridX = var1_8 >> 16;
                        this.m_gridY = var1_8 & 65535;
                        if (this.m_preDirection != this.m_Direction) break;
                        var2_19 = this.getNextSmallGridPhy();
                        if (var2_19 < 9 || var2_19 >= 21) {
                            this.m_vZ = 0;
                            this.m_vX = 0;
                            break;
                        }
                        if (Actor.s_dirDuration > 5) {
                            this.m_friendActor.m_friendActor = null;
                            this.m_friendActor = null;
                            var1_8 = Player.getNextSmallGrid(this.m_gridX, this.m_gridY, this.m_Direction);
                            this.m_gridX = var1_8 >> 16;
                            this.m_gridY = var1_8 & 65535;
                            this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                            this.changeTactic(0);
                            break;
                        }
                        this.m_vZ = 0;
                        this.m_vX = 0;
                        break;
                    }
                    if (GameScreen.s_pressedKey == 64) {
                        if (Actor.s_usingItem == 5) {
                            this.m_blood = (byte)(this.m_blood + 6);
                            if (this.m_blood > Actor.MAXBLOOD) {
                                this.m_blood = Actor.MAXBLOOD;
                            }
                            if ((Actor.s_medicineNum = (byte)(Actor.s_medicineNum - 1)) == 0) {
                                Actor.s_ability[0] = (byte)(Actor.s_ability[0] & -33);
                                Actor.s_usingItem = (Actor.s_ability[0] & 4) != 0 ? (byte)2 : (byte)-1;
                            }
                            GameScreen.s_updateInterface = true;
                            break;
                        }
                        if (!this.magic()) break;
                        this.changeTactic(5);
                        if (Actor.s_usingItem != 2) break;
                        this.m_friendActor.m_vX = (this.m_Direction & 1) == 0 ? -512 : 512;
                        this.m_friendActor.m_vZ = (this.m_Direction & 8) == 0 ? -256 : 256;
                        this.m_friendActor.m_Direction = (byte)(15 - this.m_Direction);
                        break;
                    }
                    if ((GameScreen.s_pressedKey & 32) != 0) {
                        this.chooseItem(true);
                        break;
                    }
                    if ((GameScreen.s_pressedKey & 128) != 0) {
                        this.chooseItem(false);
                        break;
                    }
                    this.changeAction(0, false);
                    break;
                }
                case 4: {
                    if (this.getNextSmallGridPhy() == 0) {
                        this.m_vX = 0;
                        this.m_vZ = 0;
                    }
                    if (this.m_posY_Display < this.m_posY_Ground) break;
                    if (!this.checkParaBool(11)) {
                        this.changeTactic(0);
                        break;
                    }
                    this.changeTactic(8);
                    this.changeAction(28, false);
                    break;
                }
                case 21: {
                    if ((this.m_Direction & 2) == 0) {
                        if (this.m_posY_Display >= this.m_posY_Ground) break;
                        if (this.checkParaBool(11)) {
                            this.changeTactic(8);
                        } else {
                            this.changeTactic(0);
                        }
                        this.m_friendActor = null;
                        this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                        break;
                    }
                    if (this.m_posY_Display < this.m_posY_Ground) break;
                    if (this.checkParaBool(11)) {
                        this.changeTactic(8);
                    } else {
                        this.changeTactic(0);
                    }
                    this.m_friendActor = null;
                    this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                    break;
                }
                case 1: {
                    this.m_hurtBy = null;
                    if (this.m_blood <= 0) {
                        GameScreen.s_inst.changeState(16);
                        return;
                    }
                    this.changeAction(12, false);
                    if (Actor.s_nActorBelowLouis > 0) {
                        this.m_vZ = 0;
                        this.m_vX = 0;
                    }
                    if (this.m_actionOver) {
                        if (this.checkParaBool(13)) {
                            this.changeTactic(9);
                        } else if (Actor.s_nActorBelowLouis > 0 && this.m_friendActor != null) {
                            this.changeTactic(23);
                        } else {
                            this.changeTactic(0);
                        }
                    }
                    this.checkBack();
                    break;
                }
                case 14: {
                    if (this.m_tickTactic <= 3) break;
                    this.changeTactic(0);
                    Actor.s_getItem.die(true);
                    break;
                }
                case 16: {
                    this.m_isValid = false;
                    if ((this.m_currentActionID & 254) != 10 && (this.m_currentActionID & 254) != 46) {
                        GameScreen.s_drawSuperAttack = false;
                    } else {
                        this.attackEnemy(1);
                    }
                    if (!((this.m_friendActor.m_currentActionID & 254) < 8 && this.dealDirKey(0) || (this.m_friendActor.m_currentActionID & 254) >= 8 && this.dealDirKey(4))) {
                        if ((GameScreen.s_pressedKey & 16) != 0) {
                            this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                            this.m_friendActor.m_friendActor = null;
                            this.changeTactic(13);
                            break;
                        }
                        if ((GameScreen.s_currentKey & 256) != 0) {
                            if (this.storeEnergy()) {
                                ++Actor.s_Energy;
                                break;
                            }
                            if (Actor.s_attackPressed || (this.m_currentActionID & 254) == 10 || (this.m_currentActionID & 254) == 46) break;
                            if (Actor.s_Energy == 10) {
                                this.changeAction(46, false);
                                Actor.s_Energy = 0;
                                GameScreen.s_updateInterface = true;
                                GameScreen.s_drawSuperAttack = true;
                                break;
                            }
                            this.changeAction(10, false);
                            break;
                        }
                        if ((this.m_currentActionID & 254) != 10 || this.m_actionOver) {
                            this.changeAction(0, false);
                        }
                    }
                    this.m_tarX = this.m_posX + this.m_vX;
                    this.m_tarY = this.m_posY_Display + this.m_vZ;
                    var1_9 = Player.XY2grid(this.m_tarX >> 8, this.m_tarY >> 8);
                    var2_20 = Player.getNextSmallGrid(var1_9 >> 16, var1_9 & 65535, this.m_Direction);
                    var3_34 = Player.getPhybyGrid(var2_20 >> 16, var2_20 & 65535);
                    var4_25 = this.checkActorByPhy(var3_34);
                    if (var3_34 >= 9 && var3_34 != 23) {
                        this.m_gridX = var1_9 >> 16;
                        this.m_gridY = var1_9 & 65535;
                        if (Player.findCenter(this.m_gridX, this.m_gridY) == Player.findCenter(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY)) break;
                        if (var4_25 != null) {
                            if (var4_25.m_animType == 11 && (var4_25.m_currentActionID & 254) >= 8) {
                                this.m_friendActor.m_friendActor = null;
                                this.m_friendActor = var4_25;
                                var4_25.m_friendActor = this;
                                break;
                            }
                            this.m_vZ = 0;
                            this.m_vX = 0;
                            break;
                        }
                        if (this.m_vX == 0) break;
                        var5_29 = Player.getNextBigGrid(this.m_friendActor.m_gridX, this.m_friendActor.m_gridY, this.m_Direction);
                        var6_37 = Player.grid2XY(var5_29 >> 16, var5_29 & 65535);
                        this.m_posX = var6_37 >> 16 << 8;
                        this.m_posY_Ground = (var6_37 & 65535) << 8;
                        this.m_friendActor.m_friendActor = null;
                        this.m_friendActor = null;
                        this.changeTactic(0);
                        break;
                    }
                    this.m_vZ = 0;
                    this.m_vX = 0;
                    break;
                }
                case 2: {
                    if (GameScreen.s_showDialog) break;
                    this.changeTactic(0);
                    break;
                }
                case 19: {
                    this.m_Direction = (byte)9;
                    this.changeAction(12, false);
                    if (this.m_actionOver) {
                        if (this.checkParaBool(11)) {
                            this.changeTactic(8);
                            break;
                        }
                        this.changeTactic(0);
                        break;
                    }
                    this.checkBack();
                    break;
                }
                case 26: {
                    break;
                }
                case 5: {
                    if (!this.m_actionOver) break;
                    if (this.m_previousTactic == 9) {
                        this.m_friendActor.m_vZ = 0;
                        this.m_friendActor.m_vX = 0;
                    }
                    this.changeTactic(this.m_previousTactic);
                }
            }
        }
    }

    boolean storeEnergy() {
        if (s_pressTick > 6 && s_Energy < 10) {
            this.changeAction(44, false);
            GameScreen.s_updateInterface = true;
            s_attackPressed = true;
            return true;
        }
        return false;
    }

    boolean magic() {
        Actor actor = null;
        if (s_usingItem == 2) {
            actor = this.allocTempActor(13, 0);
        } else if (s_usingItem == 3) {
            actor = this.allocTempActor(21, 0);
        } else if (s_usingItem == 4) {
            actor = this.allocTempActor(29, 0);
        }
        if (actor != null) {
            if (actor.m_animType == 13) {
                int n = Player.getNextBigGrid(this.m_gridX, this.m_gridY, this.m_Direction);
                actor.setXYBaseOnGrid(n >> 16, n & 0xFFFF);
                actor.changeTactic(0);
                actor.m_posY_Display += this.m_posY_Display - this.m_posY_Ground;
            } else if (actor.m_animType == 21) {
                actor.setParaBool(10, true);
                int n = Player.getNextSmallGrid(this.m_gridX, this.m_gridY, this.m_Direction);
                n = Player.getNextSmallGrid(n >> 16, n & 0xFFFF, this.m_Direction);
                actor.setXYBaseOnGrid(n >> 16, n & 0xFFFF);
                actor.getNewGrid_G();
                actor.m_posY_Display = actor.m_posY_Ground - 4608;
            } else if (actor.m_animType == 29) {
                int n = Player.getNextBigGrid(this.m_gridX, this.m_gridY, this.m_Direction);
                n = Player.getNextSmallGrid(n >> 16, n & 0xFFFF, this.m_Direction);
                actor.setXYBaseOnGrid(n >> 16, n & 0xFFFF);
                actor.getNewGrid_G();
                actor.m_posY_Display = actor.m_posY_Ground - 3840;
            }
            this.changeAction(42, false);
            return true;
        }
        return false;
    }

    void changeTactic_Louis() {
        try {
            Player.setFocusPos((byte)32, (byte)32);
            s_upStair = false;
            this.m_isValid = true;
            this.m_shadow.changeAction(0, true);
            GameScreen.s_drawSuperAttack = false;
            switch (this.m_currentTactic) {
                case 0: {
                    m_liftActor = null;
                    s_nActorBelowLouis = 0;
                    this.getNewGrid_G();
                    this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                    this.setParaBool(11, false);
                    this.setParaBool(13, false);
                    this.changeAction(0, false);
                    break;
                }
                case 24: {
                    this.m_isValid = false;
                    this.m_shadow.changeAction(4, true);
                    if ((this.m_friendActor.m_currentActionID & 0xFE) == 2) {
                        this.m_Direction = (byte)(this.m_friendActor.m_flag[0] ? 12 : 9);
                    }
                    this.changeAction(38, true);
                    s_gridX = (this.m_Direction & 1) == 0 ? ((this.m_friendActor.m_currentActionID & 0xFE) == 2 ? this.m_friendActor.m_gridX - 5 : this.m_friendActor.m_gridX - 9) : ((this.m_friendActor.m_currentActionID & 0xFE) == 2 ? this.m_friendActor.m_gridX + 5 : this.m_friendActor.m_gridX + 9);
                    s_gridY = (this.m_Direction & 8) == 0 ? ((this.m_friendActor.m_currentActionID & 0xFE) == 2 ? this.m_friendActor.m_gridY - 12 : this.m_friendActor.m_gridY - 9) : ((this.m_friendActor.m_currentActionID & 0xFE) == 2 ? this.m_friendActor.m_gridY + 11 : this.m_friendActor.m_gridY + 9);
                    this.m_gridX = s_gridX;
                    this.m_gridY = s_gridY;
                    this.setXYBaseOnGrid(s_gridX, s_gridY);
                    this.m_posY_Display = this.m_posY_Ground;
                    break;
                }
                case 23: {
                    s_nActorBelowLouis = this.m_friendActor.m_tmpVar + 1;
                    this.m_gridX = this.m_friendActor.m_gridX;
                    this.m_gridY = this.m_friendActor.m_gridY;
                    if (this.m_previousTactic != 6 && this.m_previousTactic != 7) {
                        this.setXYBaseOnGrid(this.m_gridX, this.m_gridY);
                        this.m_posY_Display = this.m_posY_Ground - s_nActorBelowLouis * 1536;
                    }
                    this.m_posY_Ground = this.m_friendActor.m_posY_Ground + 128;
                    if (this.checkParaBool(11)) {
                        this.changeAction(28, true);
                    } else {
                        this.changeAction(0, true);
                    }
                    this.m_shadow.changeAction(4, true);
                    break;
                }
                case 14: {
                    this.m_tickInvincible = (byte)5;
                    switch (Actor.s_getItem.m_currentActionID) {
                        case 5: {
                            if ((s_ability[0] & 0x20) == 0) {
                                s_usingItem = (byte)5;
                            }
                            s_ability[0] = (byte)(s_ability[0] | 0x20);
                            s_medicineNum = (byte)(s_medicineNum + 1);
                            this.showDialog(true, 2, this.m_animType, 6, false);
                            break;
                        }
                        case 1: {
                            s_ability[0] = (byte)(s_ability[0] | 2);
                            this.showDialog(true, 2, 0, 1, true);
                            break;
                        }
                        case 0: {
                            s_ability[0] = (byte)(s_ability[0] | 1);
                            this.showDialog(true, 2, 0, 0, true);
                            break;
                        }
                        case 2: {
                            s_usingItem = (byte)2;
                            s_ability[0] = (byte)(s_ability[0] | 4);
                            this.showDialog(true, 2, 0, 0, true);
                            break;
                        }
                        case 3: {
                            s_usingItem = (byte)3;
                            s_ability[0] = (byte)(s_ability[0] | 8);
                            this.showDialog(true, 2, 0, 0, true);
                            break;
                        }
                        case 4: {
                            s_usingItem = (byte)4;
                            s_ability[0] = (byte)(s_ability[0] | 0x10);
                            this.showDialog(true, 2, 0, 0, true);
                        }
                    }
                    this.changeAction(28, false);
                    break;
                }
                case 13: {
                    int n = Player.getPhybyGrid(this.m_gridX, this.m_gridY);
                    if (Player.isGround(n) || n == 21) {
                        s_position = (this.m_gridX << 16) + this.m_gridY;
                    }
                    if ((s_ability[0] & 1) != 0) {
                        int n2 = 0;
                        while (true) {
                            if (n2 >= Player.s_freeRoomID) break;
                            Actor actor = Player.m_actors[n2];
                            if (!(actor.m_animType != 18 || (actor.m_currentActionID & 0xFE) == 0 || actor == this.m_friendActor || (actor.m_currentActionID & 0xFE) == 2 && (this.m_Direction == 3 && actor.m_flag[0] || this.m_Direction == 6 && !actor.m_flag[0]))) {
                                actor.m_gridY += 24;
                                if (this.isActorInRange(actor, (actor.m_currentActionID & 0xFE) == 2 ? -9 : -6, (actor.m_currentActionID & 0xFE) == 2 ? 9 : 6, (actor.m_currentActionID & 0xFE) == 2 ? -6 : -2, 12) && ((actor.m_currentActionID & 0xFE) == 2 || !actor.m_flag[0] && (this.m_Direction == 9 || this.m_Direction == 6) || actor.m_flag[0] && (this.m_Direction == 12 || this.m_Direction == 3))) {
                                    if (this.m_friendActor != null) {
                                        this.m_friendActor.m_friendActor = null;
                                        this.m_friendActor = null;
                                    }
                                    this.m_friendActor = actor;
                                    this.changeTactic(24);
                                    actor.m_gridY -= 24;
                                    return;
                                }
                                actor.m_gridY -= 24;
                            }
                            ++n2;
                        }
                    }
                    this.changeAction(18, false);
                    Actor actor = this.checkActorByPhy(this.getNextBigGridPhy());
                    if (actor == null || actor.m_animType != 6) break;
                    actor = this.getTopBox(actor);
                    if (actor.m_tmpVar < s_nActorBelowLouis || actor.m_tmpVar != s_nActorBelowLouis) break;
                    this.changeTactic(18);
                    this.m_friendActor = actor;
                    break;
                }
                case 8: {
                    this.changeAction(28, false);
                    s_nActorBelowLouis = 0;
                    this.setParaBool(11, true);
                    break;
                }
                case 1: {
                    if (this.m_friendActor != null && this.m_friendActor.m_animType != 11 && 0 == s_nActorBelowLouis) {
                        this.m_friendActor = null;
                    }
                    this.setDirection(this.m_hurtBy);
                    GameScreen.playSound(11);
                    break;
                }
                case 4: {
                    this.changeAction(36, false);
                    int n = this.getNextSmallGridPhy();
                    if (n <= 0 || n >= 9 || (this.m_Direction & 2) == 0) break;
                    int n3 = this.getGridOnWall();
                    this.setXYBaseOnGrid(n3 >> 16, n3 & 0xFFFF);
                    break;
                }
                case 21: {
                    this.changeAction(36, false);
                    if ((this.m_Direction & 2) == 0) {
                        this.m_vY = -256;
                        this.m_aY = 0;
                        break;
                    }
                    this.m_vY = 256;
                    this.m_aY = 256;
                    break;
                }
                case 16: {
                    this.copyPostion(this.m_friendActor);
                    this.changeAction(0, false);
                    break;
                }
                case 2: 
                case 26: {
                    this.changeAction(0, false);
                    break;
                }
                case 28: {
                    this.changeAction(54, false);
                    break;
                }
                case 7: {
                    this.setParaBool(11, false);
                    this.changeAction(26, false);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void ai_IceMagic() {
        this.attackEnemy(1);
        if (this.m_actionOver) {
            this.die(true);
        }
    }

    public void chooseItem(boolean bl) {
        block2: {
            int n = 0;
            int n2 = s_usingItem == -1 ? 4 : (int)s_usingItem;
            do {
                n2 = bl ? (int)((byte)(n2 - 1)) : (int)((byte)(n2 + 1));
                if ((n = (int)((byte)(n + 1))) > 8) break block2;
                if (bl) {
                    if (n2 >= 2) continue;
                    n2 = 5;
                    continue;
                }
                if (n2 <= 5) continue;
                n2 = 2;
            } while ((s_ability[0] >> n2 & 1) == 0);
            s_usingItem = (byte)n2;
        }
        GameScreen.s_updateInterface = true;
    }

    void changeTactic_Mage() {
        switch (this.m_currentTactic) {
            case 1: {
                if (this.checkParaBool(0)) {
                    this.setDirection(s_Hero);
                }
                this.changeAction(4, false);
                break;
            }
            case 2: {
                this.changeAction(6, false);
                break;
            }
            case 0: {
                this.m_Direction = (byte)(15 - this.m_hurtBy.m_Direction);
                this.changeAction(10, false);
                if (!this.checkParaBool(0)) {
                    this.m_vZ = 0;
                    this.m_vX = 0;
                }
                GameScreen.playSound(2);
                break;
            }
            case 4: {
                this.setDirection(s_Hero);
                this.changeAction(0, true);
            }
        }
    }

    void ai_Mage() {
        this.getNewGrid_G();
        switch (this.m_currentTactic) {
            case 1: {
                if (!this.m_actionOver) break;
                if (Actor.random(0, 2) < 2 || !this.isActorInRange(s_Hero, -30, 30, -30, 30)) {
                    this.allocTempActor(26, 2);
                } else {
                    s_Hero.allocTempActor(26, 0);
                }
                this.changeTactic(4);
                break;
            }
            case 0: {
                this.checkBack();
                if (!this.m_actionOver) break;
                if (this.m_blood <= 0) {
                    this.allocTempActor(8, 0);
                    this.die(true);
                    break;
                }
                if (this.checkParaBool(0)) {
                    this.changeTactic(2);
                    break;
                }
                this.changeTactic(4);
                break;
            }
            case 2: {
                switch (this.m_currentActionID & 0xFE) {
                    case 6: {
                        if (!this.m_actionOver) break;
                        this.changeAction(12, false);
                        break;
                    }
                    case 12: {
                        if (this.m_tickAction <= 10) break;
                        int n = this.randomXY(-4, 4, 15, 25);
                        int n2 = n & 0xFFFF;
                        if (!Player.isGround(Player.getPhybyGrid(n >>= 16, n2))) break;
                        this.setXYBaseOnGrid(n, n2);
                        this.m_posY_Display = this.m_posY_Ground;
                        this.changeAction(8, true);
                        break;
                    }
                    case 8: {
                        if (!this.m_actionOver) break;
                        this.changeTactic(1);
                    }
                }
                break;
            }
            case 4: {
                if (this.m_tickAction < 12) break;
                if (this.checkParaBool(0)) {
                    this.changeTactic(2);
                    break;
                }
                this.changeTactic(1);
            }
        }
    }

    void ai_MageArmor() {
        this.getNewGrid_G();
        switch (this.m_currentActionID & 0xFE) {
            case 2: {
                if (!this.checkParaBool(0)) {
                    if (Actor.s_Hero.m_currentTactic == 12 || !this.e_attackHero(false)) break;
                    this.die(true);
                    break;
                }
                if (this.attackEnemy(1) == null) break;
                this.die(true);
                break;
            }
            case 0: {
                this.m_isValid = false;
                if (this.m_tickAction <= 25) break;
                this.changeAction(4, true);
                break;
            }
            case 4: {
                this.m_isValid = false;
                if (this.m_tickAction > 20) {
                    this.die(true);
                    break;
                }
                if (!this.e_attackHero(false)) break;
                this.die(true);
            }
        }
    }

    void changeTactic_Ogre() {
        switch (this.m_currentTactic) {
            case 1: {
                this.changeAction(0, true);
                break;
            }
            case 4: {
                if (this.follow(4, 2, s_Hero)) break;
                this.m_Direction = (byte)(15 - this.m_Direction);
                this.changeTactic(1);
                break;
            }
            case 8: {
                this.changeAction(8, true);
                break;
            }
            case 3: {
                this.patrol(1, 2);
                break;
            }
            case 0: {
                this.m_Direction = (byte)(15 - this.m_hurtBy.m_Direction);
                this.changeAction(4, false);
                GameScreen.playSound(2);
                break;
            }
            case 7: {
                this.allocTempActor(8, 0);
                this.die(true);
                break;
            }
            case 2: {
                this.changeAction(6, false);
                this.m_vZ = 0;
                this.m_vX = 0;
                break;
            }
            case 9: {
                this.changeAction(10, true);
                break;
            }
            case 10: {
                if (this.follow(4, 6, s_Hero)) break;
                this.changeTactic(11);
                break;
            }
            case 11: {
                this.m_vZ = 0;
                this.m_vX = 0;
                this.changeAction(15, true);
            }
        }
    }

    void ai_Ogre() {
        this.getNewGrid_G();
        this.m_preDirection = this.m_Direction;
        switch (this.m_currentTactic) {
            case 1: {
                if (this.m_tickTactic < 6) break;
                if (this.isActorInRange(s_Hero, -12, 12, -20, 18)) {
                    this.changeTactic(11);
                    break;
                }
                if (!this.isActorInRange(s_Hero, -24, 24, -20, 36)) break;
                this.changeTactic(4);
                break;
            }
            case 0: {
                if (this.m_actionOver) {
                    if (this.m_blood <= 0) {
                        this.changeTactic(7);
                        break;
                    }
                    this.changeTactic(4);
                    break;
                }
                this.checkBack();
                break;
            }
            case 8: {
                if (this.m_tickTactic <= 50) break;
                this.changeTactic(this.m_previousTactic);
                break;
            }
            case 3: {
                int n = 24;
                int n2 = 36;
                int n3 = -20;
                if (this.m_parameters[1] == 2) {
                    n = 12;
                    n2 = 24;
                    n3 = -32;
                }
                if (this.isActorInRange(s_Hero, -n, n, n3, n2)) {
                    this.changeTactic(4);
                    break;
                }
                if (!this.checkTarget_G(0)) break;
                this.changeTactic(3);
                break;
            }
            case 4: {
                int n = this.getNextBigGridPhy();
                if (this.isActorInRange(s_Hero, -12, 12, -20, 18)) {
                    this.changeTactic(9);
                    break;
                }
                if (this.isActorBlocked() || n > 20) {
                    this.changeTactic(1);
                    break;
                }
                if (!this.checkTarget_G(4)) break;
                this.follow(4, 2, s_Hero);
                break;
            }
            case 9: {
                if (!this.m_actionOver) break;
                this.changeTactic(10);
                break;
            }
            case 10: {
                this.e_attackHero(false);
                int n = this.getNextBigGridPhy();
                if (this.isActorBlocked() || n > 20) {
                    this.changeTactic(1);
                }
                if (this.m_tickTactic > 100) {
                    this.changeTactic(1);
                    break;
                }
                if (!this.checkTarget_G(4)) break;
                this.follow(4, 6, s_Hero);
                break;
            }
            case 2: {
                this.m_preDirection = this.m_Direction;
                this.setDirection(s_Hero);
                if (this.m_preDirection != this.m_Direction) {
                    this.changeAction(6, true);
                    this.m_vZ = 0;
                    this.m_vX = 0;
                }
                this.e_attackHero(false);
                break;
            }
            case 11: {
                this.e_attackHero(false);
                if (this.m_tickTactic <= 30) break;
                this.changeTactic(4);
            }
        }
    }

    void ai_Tree() {
        if ((this.m_currentActionID & 0xFE) == 2 && this.m_actionOver) {
            GameScreen.playSound(2);
            this.die(true);
        }
    }

    void ai_Bomb() {
        this.getNewGrid_G();
        if (!this.checkParaBool(11)) {
            this.attackEnemy(1);
        }
        if (!this.checkParaBool(10)) {
            this.e_attackHero(false);
            if (this.m_actionOver) {
                this.die(true);
            }
        } else if (this.m_tickAction > 10) {
            this.die(true);
        }
    }

    void ai_Teleport() {
        if (this.isActorInRange(s_Hero, -4, 4, -4, 4)) {
            this.teleport(0, 1, 2);
        }
    }

    void teleport(int n, int n2, int n3) {
        Player.m_currentLev = this.m_parameters[n] - 1;
        s_blood = MAXBLOOD;
        Actor.teleportX[0] = (this.m_parameters[n2] & 0xFF) << 1;
        Actor.teleportY[0] = (this.m_parameters[n3] & 0xFF) << 1;
        GameScreen.s_inst.changeState(1);
    }

    void ai_Tip() {
        this.m_preDirection = this.m_Direction;
        if ((this.m_tmpVar & 0xFE) == 20) {
            if (this.m_friendActor == s_Hero || this.m_friendActor == null) {
                for (int i = 0; i < 3; ++i) {
                    Actor actor = s_Hero.findActor(i);
                    if (actor == null || actor == s_Hero) continue;
                    this.m_friendActor = actor;
                    break;
                }
            }
            if (this.m_friendActor == null) {
                this.changeAction(2, false);
            } else {
                this.changeAction(this.m_tmpVar, false);
                this.m_posX = this.m_friendActor.m_posX;
                this.m_posY_Display = this.m_friendActor.m_posY_Display - 7680;
            }
            return;
        }
        if ((this.m_tmpVar & 0xFE) == 36) {
            this.m_friendActor = s_Hero;
            this.changeAction(this.m_tmpVar + GameScreen.s_keyControl, false);
            this.m_posX = this.m_friendActor.m_posX;
            this.m_posY_Display = this.m_friendActor.m_posY_Display;
            if (this.isHeroInZone(1)) {
                s_player.actorChanged(this.m_actorID, -1);
                this.die(true);
            }
            return;
        }
        if ((this.m_tmpVar & 0xFE) == 44 && this.checkParaBool(10)) {
            String string = Player.m_levText[this.m_parameters[0]];
            if (string == null || this.m_vY >= string.length()) {
                this.die(true);
                GameScreen.s_specialBlack = false;
                if (s_gameComplete) {
                    s_gameComplete = false;
                    GameScreen.s_specialBlack = true;
                    GameScreen.s_inst.changeState(13);
                }
                return;
            }
            this.m_vX = string.indexOf(35, this.m_vY);
            if (this.m_vX == -1) {
                this.m_vX = 0;
            }
            this.m_vY = this.m_vX + 1;
            while (this.m_vY < string.length() && string.charAt(this.m_vY) != '#') {
                ++this.m_vY;
            }
            String string2 = new String(string.substring(this.m_vX, this.m_vY));
            int n = 0;
            if (string2.startsWith("#" + Player.m_text[8])) {
                n = 1;
            } else if (string2.startsWith("#" + Player.m_text[10])) {
                n = 3;
            } else if (string2.startsWith("#" + Player.m_text[11])) {
                n = 31;
            }
            this.m_vX = string2.indexOf(58);
            String string3 = new String(string2.substring(this.m_vX + 1));
            GameScreen.invokeDialog(2, n, string3);
            return;
        }
        if (this.isHeroInZone(1) && Actor.s_Hero.m_currentTactic == 0) {
            if ((this.m_tmpVar & 0xFE) == 44 && !this.checkParaBool(10)) {
                this.setParaBool(10, true);
                return;
            }
            if ((this.m_tmpVar & 0xFE) == 46) {
                GameScreen.s_inst.changeState(25);
                s_player.actorChanged(this.m_actorID, -1);
                this.die(true);
                return;
            }
            if (this.m_tmpVar <= 3 && !s_player.isActorChanged(this.m_actorID) || this.m_tmpVar > 3) {
                GameScreen.s_showInfoDlg = true;
                GameScreen.s_tickShow = 40;
                GameScreen.s_InfoDlgStr = Player.m_levText[this.m_parameters[0]];
                this.setParaBool(10, true);
                if (Player.m_currentLev == 3 && this.m_parameters[0] == 1) {
                    s_ability[1] = (byte)(s_ability[1] | 2);
                }
                if (Player.m_currentLev == 3 && this.m_parameters[0] == 0) {
                    s_ability[1] = (byte)(s_ability[1] | 4);
                }
                if (this.m_tmpVar <= 3) {
                    s_player.actorChanged(this.m_actorID, -1);
                    this.die(true);
                } else {
                    this.changeAction(this.m_tmpVar, false);
                    s_player.actorChanged(this.m_actorID, -1);
                }
            }
        } else if (this.checkParaBool(10)) {
            this.changeAction(2, false);
            GameScreen.s_tickShow = 0;
            this.setParaBool(10, false);
        }
    }

    void ai_Camera() {
        if (this.m_currentTactic == 1) {
            if (this.m_tickTactic == this.m_parameters[2]) {
                if (this.m_tickTactic == 32) {
                    Actor actor = this.activate(this.m_tmpVar);
                    if (actor.m_animType != 9) {
                        actor.allocTempActor(8, 0);
                    }
                    this.m_vZ = 0;
                    this.m_vX = 0;
                    this.changeTactic(0);
                } else {
                    this.die(true);
                    GameScreen.s_isCutScreen = false;
                    if (Actor.s_Hero.m_animType == 0 && s_Hero.checkParaBool(11)) {
                        s_Hero.changeTactic(8);
                    } else {
                        s_Hero.changeTactic(0);
                    }
                    if (Actor.s_Hero.m_animType == 1) {
                        s_Hero.setParaBool(10, true);
                    }
                    Player.setFocusActor(s_Hero);
                }
            }
        } else if (this.m_currentTactic == 0 && this.m_tickTactic > 20) {
            this.m_vX = (Actor.s_Hero.m_posX - this.m_posX) / 16;
            this.m_vZ = (Actor.s_Hero.m_posY_Display - this.m_posY_Display) / 16;
            this.m_parameters[2] = 16;
            this.changeTactic(1);
        }
    }

    void ai_Ring() {
        if ((this.m_currentActionID & 0xFE) == 2) {
            if ((Actor.s_Hero.m_currentActionID & 0xFE) == 38) {
                this.m_gridY += 24;
                if (s_Hero.isActorInRange(this, -6, 6, -2, 12)) {
                    s_Hero.changeAction(48, true);
                }
                this.m_gridY -= 24;
            }
        } else {
            this.m_gridY += 24;
            if (s_Hero.isActorInRange(this, -6, 6, -2, 12)) {
                if (this.m_flag[0] && (Actor.s_Hero.m_Direction == 12 || Actor.s_Hero.m_Direction == 3)) {
                    this.changeAction(4, false);
                } else if (!(this.m_flag[0] || Actor.s_Hero.m_Direction != 9 && Actor.s_Hero.m_Direction != 6)) {
                    this.changeAction(4, false);
                }
            } else {
                this.changeAction(0, false);
            }
            this.m_gridY -= 24;
            if (Actor.s_Hero.m_friendActor == this && (Actor.s_Hero.m_currentActionID & 0xFE) == 38) {
                s_Hero.changeAction(40, true);
                Actor.s_Hero.m_posX = (Actor.s_Hero.m_Direction & 1) != 0 ? this.m_posX + 3328 : this.m_posX - 3584;
                Actor.s_Hero.m_posY_Display = (Actor.s_Hero.m_Direction & 8) != 0 ? this.m_posY_Display + 10752 : this.m_posY_Display + 7680;
                Player.setFocusPos((byte)(32 - (this.m_posX - Actor.s_Hero.m_posX >> 10)), (byte)(32 - (this.m_posY_Display - Actor.s_Hero.m_posY_Display >> 10)));
            }
        }
    }

    void changeTactic_Skeleton() {
        this.m_isValid = true;
        switch (this.m_currentTactic) {
            case 2: {
                this.changeAction(6, true);
                break;
            }
            case 1: {
                this.m_isValid = false;
                this.changeAction(8, true);
                break;
            }
            case 6: {
                this.changeAction(4, true);
                break;
            }
            case 3: {
                this.changeAction(0, true);
                break;
            }
            case 4: {
                if (this.follow(1, 2, s_Hero)) break;
                this.changeTactic(3);
                break;
            }
            case 0: {
                this.m_Direction = (byte)(15 - this.m_hurtBy.m_Direction);
                this.changeAction(10, true);
                break;
            }
            case 7: {
                this.setDirection(s_Hero);
                this.changeAction(12, true);
                this.m_friendActor = this.allocTempActor(33, 0);
            }
        }
    }

    void ai_Skeleton() {
        this.getNewGrid_G();
        switch (this.m_currentTactic) {
            case 1: {
                if (!this.isHeroInZone(2)) break;
                this.changeTactic(6);
                break;
            }
            case 2: {
                if (this.m_actionOver) {
                    this.changeAction(8, false);
                }
                if (this.m_tickTactic <= 20) break;
                this.changeTactic(6);
                break;
            }
            case 6: {
                if (!this.m_actionOver) break;
                this.changeTactic(4);
                break;
            }
            case 4: {
                int n = this.getNextBigGridPhy();
                if (this.isActorInRange(s_Hero, -6, 6, -9, 9)) {
                    this.changeTactic(3);
                    break;
                }
                if (this.checkTarget_G(1)) {
                    this.changeTactic(4);
                    break;
                }
                if (!this.isActorToBeBlocked()) break;
                this.changeTactic(4);
                break;
            }
            case 0: {
                this.m_Direction = (byte)(15 - this.m_Direction);
                if (this.isActorToBeBlocked()) {
                    this.m_vZ = 0;
                    this.m_vX = 0;
                }
                this.m_Direction = (byte)(15 - this.m_Direction);
                if (!this.m_actionOver) break;
                if ((this.m_tmpVar & 1) == 0) {
                    this.changeTactic(7);
                    break;
                }
                this.changeTactic(4);
                break;
            }
            case 7: {
                if (!this.m_actionOver) break;
                if ((this.m_currentActionID & 0xFE) == 12) {
                    this.changeAction(14, true);
                    this.m_friendActor.changeAction(2, true);
                    this.allocTempActor(27, 0);
                    break;
                }
                this.m_friendActor.die(true);
                this.m_friendActor = null;
                this.changeTactic(4);
                break;
            }
            case 3: {
                if (this.m_tickTactic <= 15) break;
                this.changeTactic(7);
            }
        }
    }

    void ai_SkeletonArmor() {
        this.getNewGrid_G();
        this.e_attackHero(false);
        if (this.m_tickAction > 20) {
            this.die(true);
        }
    }

    void changeTactic_Bat() {
        switch (this.m_currentTactic) {
            case 0: {
                this.changeAction(2, true);
                break;
            }
            case 1: {
                this.changeAction(6, true);
                break;
            }
            case 2: {
                this.follow(1, 0, s_Hero);
                break;
            }
            case 3: {
                this.changeAction(4, true);
                break;
            }
            case 4: {
                this.changeAction(0, true);
                break;
            }
            case 5: {
                this.changeAction(8, true);
            }
        }
    }

    void ai_Bat() {
        this.getNewGrid_G();
        switch (this.m_currentTactic) {
            case 0: {
                if (!this.isHeroInZone(1)) break;
                if (this.checkParaBool(5)) {
                    this.changeTactic(1);
                    break;
                }
                this.changeTactic(2);
                break;
            }
            case 4: {
                if (this.getNextBigGridPhy() != 30 && this.m_tickTactic <= 15) break;
                this.changeTactic(1);
                break;
            }
            case 1: {
                if (this.m_tickTactic <= 20) break;
                this.changeTactic(2);
                break;
            }
            case 3: {
                this.e_attackHero(false);
                if (this.m_actionOver) {
                    this.m_posY_Display = this.m_posY_Ground - 2560;
                    this.changeTactic(4);
                }
                if (this.getNextBigGridPhy() != 30) break;
                this.m_vZ = 0;
                this.m_vX = 0;
                break;
            }
            case 2: {
                if (this.isActorInRange(s_Hero, -4, 4, -4, 4)) {
                    this.changeTactic(3);
                    break;
                }
                if (this.getNextBigGridPhy() == 30) {
                    this.m_vZ = 0;
                    this.m_vX = 0;
                    this.follow(1, 0, s_Hero);
                    break;
                }
                if (this.checkTarget_G(1)) {
                    this.follow(1, 0, s_Hero);
                    break;
                }
                if (Math.abs(this.distInRU(s_Hero)) + Math.abs(this.distInLU(s_Hero)) <= this.preDistance) break;
                this.follow(1, 0, s_Hero);
                break;
            }
            case 5: {
                this.m_Direction = (byte)(15 - this.m_Direction);
                if (this.getNextBigGridPhy() == 30) {
                    this.m_vZ = 0;
                    this.m_vX = 0;
                    this.m_posX += 512;
                    this.m_posY_Display += 512;
                    this.m_posY_Ground += 512;
                }
                this.m_Direction = (byte)(15 - this.m_Direction);
                if (this.m_tickTactic <= 6) break;
                this.changeTactic(1);
            }
        }
    }

    Actor activate(int n) {
        Actor actor = Player.getActor(n);
        if (actor == null) {
            actor = Player.allocActor(n, true);
        } else if (actor.m_animType == 18) {
            actor.die(true);
        }
        if (actor.m_animType == 9) {
            actor.changeTactic(5);
        } else if (actor.m_animType == 10 && actor.m_currentActionID == 8) {
            actor.changeAction(2, true);
        }
        return actor;
    }

    void ai_Waker() {
        Actor actor;
        byte by;
        int n;
        boolean bl = true;
        for (n = 0; n <= 2 && (by = this.m_parameters[n]) != -1; ++n) {
            if (Player.isDie(by)) continue;
            actor = Player.getActor(by);
            if (actor == null) {
                bl = false;
                break;
            }
            if (actor.m_isSwitchOn) continue;
            bl = false;
            break;
        }
        if (this.m_currentTactic == 0) {
            if (bl) {
                for (n = 3; n <= 5 && this.m_parameters[n] != -1; ++n) {
                    if (this.m_flag[0]) {
                        GameScreen.playSound(5);
                    }
                    if (this.checkParaBool(6) && n == 3) {
                        int n2 = Player.m_actorOffset[this.m_parameters[3]] + 6;
                        int n3 = Player.readUnsignedShort(Player.m_originData, n2) << 8;
                        int n4 = Player.readUnsignedShort(Player.m_originData, n2 + 2) << 8;
                        Actor actor2 = s_Hero.allocTempActor(20, 2);
                        actor2.m_vX = (n3 - Actor.s_Hero.m_posX) / 32;
                        actor2.m_vZ = (n4 - Actor.s_Hero.m_posY_Display) / 32;
                        actor2.m_parameters[2] = 32;
                        actor2.m_tmpVar = this.m_parameters[3];
                        actor2.changeTactic(1);
                        if (Actor.s_Hero.m_animType == 0) {
                            s_Hero.changeTactic(26);
                        } else {
                            s_Hero.setParaBool(10, false);
                            s_Hero.changeTactic(0);
                        }
                        Player.setFocusActor(actor2);
                        GameScreen.s_isCutScreen = true;
                        continue;
                    }
                    this.activate(this.m_parameters[n]);
                }
                if (this.checkParaBool(7)) {
                    this.die(true);
                } else {
                    this.changeTactic(1);
                }
            }
        } else if (this.m_currentTactic == 1 && !bl) {
            for (n = 3; n <= 5 && this.m_parameters[n] != -1; ++n) {
                actor = Player.getActor(this.m_parameters[n]);
                if (actor == null || actor.m_animType != 9) continue;
                actor.changeTactic(3);
            }
            this.changeTactic(0);
        }
    }

    void ai_Wind() {
        this.getNewGrid_G();
        switch (this.m_currentTactic) {
            case 0: {
                Actor actor = this.attackEnemy(1);
                if (actor != null) {
                    this.m_parameters[11] = 1;
                    this.m_tickTactic = 0;
                }
                if (!this.checkParaBool(11) || this.m_tickTactic <= 4) break;
                this.die(true);
                break;
            }
            case 1: {
                Actor actor = this.checkActorByPhy(this.getNextBigGridPhy());
                if (actor == null) {
                    return;
                }
                if (actor.m_animType == 0) {
                    actor.changeTactic(19);
                    break;
                }
                if (actor.m_animType != 6 || actor.m_posY_Display < actor.m_posY_Ground) break;
                this.die(true);
            }
        }
    }

    void ai_Switch() {
        switch (this.m_currentActionID & 0xFE) {
            case 2: {
                this.ps_hasValidActorOn();
                if (!this.m_isSwitchOn) break;
                GameScreen.playSound(8);
                break;
            }
            case 0: {
                if (this.m_parameters[0] <= 0 || this.m_tickAction < this.m_parameters[0]) break;
                this.m_isSwitchOn = false;
                this.ps_hasValidActorOn();
                if (this.m_isSwitchOn) break;
                this.changeAction(2, false);
                break;
            }
            case 4: {
                if (this.m_parameters[0] <= 0 || this.m_tickAction < this.m_parameters[0]) break;
                this.m_isSwitchOn = false;
                this.changeAction(6, false);
            }
        }
    }

    void ps_hasValidActorOn() {
        block4: {
            Actor actor;
            block5: {
                this.plugFloor();
                actor = this.checkActorByPhy(Player.getPhybyGrid(this.m_gridX, this.m_gridY));
                if (actor == null) break block4;
                if (actor.m_animType == 0 || actor.m_animType == 6 || actor.m_animType == 28) break block5;
                if (actor.m_animType != 1) break block4;
                if (s_GloriaAppearance != 0) break block4;
            }
            if (actor.getHeight() == 0) {
                this.changeAction(0, false);
                this.m_isSwitchOn = true;
                this.m_tickAction = 0;
                return;
            }
        }
    }

    void ai_Dragon() {
        if (s_bellow) {
            for (int i = 0; i < 6; ++i) {
                int n = this.randomXY(-18, 18, -12, 12);
                int n2 = n & 0xFFFF;
                if (!Player.isGround(Player.getPhybyGrid(n >>= 16, n2))) continue;
                Actor actor = this.allocTempActor(17, 10);
                actor.setXYBaseOnGrid(n, n2);
                actor.m_posY_Display = actor.m_posY_Ground - (132 + Actor.random(0, 20) << 8);
                actor.getShadow(0);
                actor.m_shadow.m_posY_Display = actor.m_shadow.m_posY_Ground;
            }
            s_bellow = false;
            return;
        }
        switch (this.m_currentTactic) {
            case 0: {
                if (s_activeDragon != this.m_parameters[0]) break;
                this.changeTactic(7);
                break;
            }
            case 1: {
                this.e_attackHero(false);
                if (this.checkParaBool(11)) {
                    if (this.m_tickTactic % 30 == 0) {
                        this.setParaBool(11, false);
                        this.m_vX = this.m_tarX;
                        this.m_vZ = this.m_tarY;
                    }
                    return;
                }
                if (this.m_gridX < (this.m_flag[0] ? 8 : 32) && this.m_vX < 0) {
                    this.m_vX = 0 - this.m_vX;
                    this.m_vZ = 0 - this.m_vZ;
                } else if (this.m_gridX > (this.m_flag[0] ? 40 : 64) && this.m_vX > 0) {
                    this.m_vX = 0 - this.m_vX;
                    this.m_vZ = 0 - this.m_vZ;
                }
                if (this.m_parameters[0] == 0) {
                    if (this.m_tickTactic % 10 != 0) break;
                    this.dragon_Attack(32, 4);
                    break;
                }
                if (this.m_parameters[0] == 1) {
                    if (this.m_tickTactic % 20 != 0) break;
                    Actor actor = this.dragon_Attack(32, 2);
                    actor = this.dragon_Attack(32, 2);
                    actor.m_posX += 4096;
                    actor.m_posY_Ground = actor.m_posY_Display = actor.m_posY_Display + (this.m_flag[0] ? -2048 : 2048);
                    actor = this.dragon_Attack(32, 2);
                    actor.m_posX -= 4096;
                    actor.m_posY_Ground = actor.m_posY_Display = actor.m_posY_Display + (this.m_flag[0] ? 2048 : -2048);
                    break;
                }
                if (this.checkParaBool(10)) {
                    if ((!this.m_flag[0] || Math.abs(this.distInRU(s_Hero)) >= 3) && (this.m_flag[0] || Math.abs(this.distInLU(s_Hero)) >= 3)) break;
                    this.changeTactic(2);
                    break;
                }
                if (this.m_tickTactic % 15 != 0) break;
                Actor actor = this.dragon_Attack(32, 0);
                actor.setParaBool(0, true);
                Actor actor2 = this.dragon_Attack(27, 0);
                actor2.setParaBool(10, true);
                actor2.m_vX = actor.m_vX;
                actor2.m_vZ = actor.m_vZ;
                this.setParaBool(11, true);
                this.m_tarX = this.m_vX;
                this.m_tarY = this.m_vZ;
                this.m_vZ = 0;
                this.m_vX = 0;
                this.m_tickTactic = 0;
                break;
            }
            case 2: {
                this.e_attackHero(false);
                if ((this.m_currentActionID & 0xFE) == 36) {
                    if (this.m_tickAction <= 15) break;
                    this.changeAction(38, true);
                    this.m_anim.frameData[2] = (byte)(this.m_anim.frameData[2] + 8);
                    break;
                }
                if ((this.m_currentActionID & 0xFE) != 38 || !this.m_actionOver) break;
                this.changeTactic(4);
                break;
            }
            case 3: {
                int n;
                if (!this.m_actionOver) break;
                s_activeDragon = (byte)(s_activeDragon + 1);
                if (this.m_blood <= 0) {
                    Actor.s_Dragon[this.m_parameters[0]] = null;
                    n = 1;
                    for (int i = 0; i < 3; ++i) {
                        if (s_Dragon[i] == null) continue;
                        n = 0;
                    }
                    if (n != 0) {
                        this.changeTactic(10);
                        return;
                    }
                    this.die(true);
                } else {
                    this.setParaBool(10, false);
                }
                for (n = 0; n < 3; ++n) {
                    if (s_Dragon[n] == null) continue;
                    s_Dragon[n].changeTactic(8);
                }
                break;
            }
            case 9: {
                if (this.m_tickTactic <= 6) break;
                if (s_activeDragon == 0) {
                    s_bellow = true;
                }
                for (int i = 0; i < 3; ++i) {
                    if (s_Dragon[i] == null) continue;
                    if (s_bellow) {
                        s_Dragon[i].changeTactic(6);
                        continue;
                    }
                    s_Dragon[i].changeTactic(0);
                }
                break;
            }
            case 8: {
                if (!this.m_actionOver) break;
                if (s_activeDragon > 2) {
                    s_activeDragon = 0;
                }
                boolean bl = false;
                for (int i = 0; i < 3; ++i) {
                    if (s_activeDragon == i) {
                        if (s_Dragon[i] == null) {
                            s_activeDragon = (byte)(s_activeDragon + 1);
                            continue;
                        }
                        Actor.s_Dragon[i].m_Direction = (byte)(Actor.s_Dragon[i].m_flag[0] ? 3 : 6);
                        s_Dragon[i].changeTactic(9);
                        Actor.s_Dragon[i].m_posX = Actor.s_Dragon[i].m_flag[0] ? 4352 : 30976;
                        Actor.s_Dragon[i].m_posY_Ground = Actor.s_Dragon[i].m_flag[0] ? 6144 : 4864;
                        Actor.s_Dragon[i].m_posY_Display = Actor.s_Dragon[i].m_posY_Ground;
                        continue;
                    }
                    if (bl) {
                        if (s_Dragon[i] == null) continue;
                        Actor.s_Dragon[i].m_Direction = (byte)(Actor.s_Dragon[i].m_flag[0] ? 3 : 6);
                        s_Dragon[i].changeTactic(9);
                        Actor.s_Dragon[i].m_posX = Actor.s_Dragon[i].m_flag[0] ? 7424 : 35328;
                        Actor.s_Dragon[i].m_posY_Ground = Actor.s_Dragon[i].m_flag[0] ? -256 : 4608;
                        Actor.s_Dragon[i].m_posY_Display = Actor.s_Dragon[i].m_posY_Ground;
                        Actor.s_Dragon[i].m_posY_Ground += 33792;
                        continue;
                    }
                    if (s_Dragon[i] != null) {
                        Actor.s_Dragon[i].m_Direction = (byte)(Actor.s_Dragon[i].m_flag[0] ? 3 : 6);
                        s_Dragon[i].changeTactic(9);
                        Actor.s_Dragon[i].m_posX = Actor.s_Dragon[i].m_flag[0] ? -768 : 29184;
                        Actor.s_Dragon[i].m_posY_Ground = Actor.s_Dragon[i].m_flag[0] ? 5376 : 256;
                        Actor.s_Dragon[i].m_posY_Display = Actor.s_Dragon[i].m_posY_Ground;
                        Actor.s_Dragon[i].m_posY_Ground += 33792;
                    }
                    bl = true;
                }
                break;
            }
            case 4: {
                this.e_attackHero(false);
                if (this.m_tickTactic <= 40) break;
                if (this.m_parameters[0] == 2) {
                    this.m_anim.frameData[2] = (byte)(this.m_anim.frameData[2] - 8);
                }
                this.changeTactic(1);
                break;
            }
            case 6: {
                this.e_attackHero(false);
                this.earthQuake();
                if (this.m_tickAction > 90) {
                    this.changeTactic(0);
                    return;
                }
                int n = 0;
                while (true) {
                    if (n >= Player.s_freeRoomID) break;
                    Actor actor = Player.m_actors[n];
                    if (actor.m_animType == 17 || actor.m_animType == 21 && !actor.checkParaBool(10)) {
                        return;
                    }
                    ++n;
                }
                s_bellow = true;
                break;
            }
            case 7: {
                if (!this.m_actionOver) break;
                this.changeTactic(1);
                break;
            }
            case 10: {
                if (this.m_tickTactic <= 12) break;
                this.die(true);
                s_gameComplete = true;
                GameScreen.s_specialBlack = true;
            }
        }
    }

    Actor dragon_Attack(int n, int n2) {
        int n3 = this.m_flag[0] ? 28 : -28;
        Actor actor = Player.allocActor(n, false);
        actor.m_posX = this.m_posX + (n3 << 8);
        actor.m_posY_Display = actor.m_posY_Ground = this.m_posY_Ground + 7168;
        actor.m_Direction = this.m_Direction;
        actor.changeAction(n2, true);
        actor.m_friendActor = this;
        return actor;
    }

    boolean changeBlood_Dragon() {
        if (this.m_currentTactic == 1) {
            if (this.m_parameters[0] == 0) {
                if (this.m_hurtBy.m_animType == 21) {
                    this.changeTactic(4);
                }
            } else if (this.m_parameters[0] == 1) {
                if (this.m_hurtBy.m_animType == 29) {
                    this.changeTactic(4);
                }
            } else if (this.m_hurtBy.m_animType == 32) {
                this.setParaBool(10, true);
            }
        } else if (this.m_currentTactic == 4 && this.m_hurtBy.m_animType == 0) {
            this.changeTactic(3);
            return true;
        }
        return false;
    }

    void changeTactic_Dragon() {
        switch (this.m_currentTactic) {
            case 0: {
                this.changeAction(12 + (this.m_parameters[0] << 1), true);
                break;
            }
            case 1: {
                this.changeAction(30 + (this.m_parameters[0] << 1), true);
                break;
            }
            case 2: {
                this.changeAction(36, true);
                break;
            }
            case 3: {
                if (this.m_parameters[0] == 2) {
                    this.m_anim.frameData[2] = (byte)(this.m_anim.frameData[2] - 8);
                }
                this.changeAction(24 + (this.m_parameters[0] << 1), true);
                GameScreen.playSound(2);
                break;
            }
            case 4: {
                this.changeAction(40 + (this.m_parameters[0] << 1), true);
                break;
            }
            case 6: {
                this.changeAction(46 + (this.m_parameters[0] << 1), true);
                break;
            }
            case 7: {
                this.changeAction(18 + (this.m_parameters[0] << 1), true);
                break;
            }
            case 8: {
                this.changeAction(0 + (this.m_parameters[0] << 1), true);
                break;
            }
            case 9: {
                this.changeAction(6 + (this.m_parameters[0] << 1), true);
                break;
            }
            case 10: {
                this.allocTempActor(21, 4);
            }
        }
    }

    static {
        s_bellow = false;
        s_blood = 0;
        s_pressTick = 0;
        s_Energy = 0;
        s_nActorBelowLouis = 0;
        s_attackPressed = false;
        s_position = 0;
        s_usingItem = (byte)-1;
        s_dirDuration = 0;
        s_blackRoom = false;
        s_medicineNum = 0;
        PX = new int[]{-13, -6, 0, -6, -20};
        PY = new int[]{-4, 6, 8, 7, -4};
        s_activeDragon = 0;
        s_Dragon = new Actor[3];
        s_gameComplete = false;
    }
}

