/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.util;

import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Utils {
    public static final byte RED_COMPONENT = 0;
    public static final byte GREEN_COMPONENT = 1;
    public static final byte BLUE_COMPONENT = 2;
    public static final int CLEAN_MEMORY_DELAY = 400;
    public static final int CTE = 100;
    private static Random rnd = new Random(System.currentTimeMillis());
    private static int[] crc_table;
    public static final int ARROW_COLOR = 0xFFFF00;
    public static final int ARROW_COLOR2 = 0xFF0000;

    public static int abs(int n) {
        return n > 0 ? n : -n;
    }

    public static long abs(long n) {
        return n > 0L ? n : -n;
    }

    public static final void cleanMemory() {
        System.gc();
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static final int getRandNumber(int min, int max) {
        int r = Math.abs(rnd.nextInt());
        return r % (max - min + 1) + min;
    }

    public static int linearInterpolation(int startV, int endV, long num, long den) {
        if (num <= 0L) {
            return startV;
        }
        if (num >= den) {
            return endV;
        }
        long coef = (num << 10) / den;
        return (int)((long)startV + (coef * (long)(endV - startV) >> 10));
    }

    public static int nearValue(int startV, int endV, int inc) {
        int result = 0;
        if (startV < endV) {
            result = startV + inc;
            int n = result = result > endV ? endV : result;
        }
        if (startV > endV) {
            result = startV - inc;
            result = result < endV ? endV : result;
        }
        return result;
    }

    public static final boolean isIntersectingRect(int ax, int ay, int aw, int ah, int bx, int by, int bw, int bh) {
        return by + bh >= ay && by <= ay + ah && bx + bw >= ax && bx <= ax + aw;
    }

    public static final void swap(int[] value1, int[] value2) {
        if (value1.length == value2.length) {
            int[] aux = new int[value1.length];
            for (int i = 0; i < aux.length; ++i) {
                aux[i] = value1[i];
                value1[i] = value2[i];
                value2[i] = aux[i];
            }
        }
    }

    public static final int convertHSVtoRGB(int hue, int saturation, int value) {
        int[] rgb = new int[3];
        if (saturation == 0) {
            rgb[0] = value * 255 / 100;
            rgb[1] = value * 255 / 100;
            rgb[2] = value * 255 / 100;
        } else {
            if (hue == 360) {
                hue = 0;
            }
            int hex = hue * 100 / 60;
            int pColor = hue / 60 * 100;
            int sColor = hex - pColor;
            int p1 = value * (100 - saturation) / 100;
            int p2 = (100 - saturation * sColor / 100) * value / 100;
            int p3 = (100 - saturation * (100 - sColor) / 100) * value / 100;
            int i = pColor / 100;
            switch (i) {
                case 0: {
                    rgb[0] = value * 255 / 100;
                    rgb[1] = p3 * 255 / 100;
                    rgb[2] = p1 * 255 / 100;
                    break;
                }
                case 1: {
                    rgb[0] = p2 * 255 / 100;
                    rgb[1] = value * 255 / 100;
                    rgb[2] = p1 * 255 / 100;
                    break;
                }
                case 2: {
                    rgb[0] = p1 * 255 / 100;
                    rgb[1] = value * 255 / 100;
                    rgb[2] = p3 * 255 / 100;
                    break;
                }
                case 3: {
                    rgb[0] = p1 * 255 / 100;
                    rgb[1] = p2 * 255 / 100;
                    rgb[2] = value * 255 / 100;
                    break;
                }
                case 4: {
                    rgb[0] = p3 * 255 / 100;
                    rgb[1] = p1 * 255 / 100;
                    rgb[2] = value * 255 / 100;
                    break;
                }
                case 5: {
                    rgb[0] = value * 255 / 100;
                    rgb[1] = p1 * 255 / 100;
                    rgb[2] = p2 * 255 / 100;
                }
            }
        }
        int red = rgb[0] << 16;
        int green = rgb[1] << 8;
        int blue = rgb[2];
        int color = red | green | blue;
        return color;
    }

    public static final boolean insideLimits(int min, int max, int value) {
        return value >= min && value < max;
    }

    public static final boolean changePNGPalette(byte[] data, short[][] colors) {
        int readPoint = 8;
        while (readPoint < data.length) {
            int length = (data[readPoint] << 24) + (data[readPoint + 1] << 16) + (data[readPoint + 2] << 8) + (data[readPoint + 3] & 0xFF);
            if (data[readPoint + 4] == 80 && data[readPoint + 5] == 76 && data[readPoint + 6] == 84 && data[readPoint + 7] == 69) {
                int paletteChunkOffset = readPoint + 8;
                for (int i = 0; i < colors.length; ++i) {
                    int position = paletteChunkOffset + colors[i][0] * 3;
                    data[position] = (byte)(colors[i][1] & 0xFF);
                    data[position + 1] = (byte)(colors[i][2] & 0xFF);
                    data[position + 2] = (byte)(colors[i][3] & 0xFF);
                }
                long crc = Utils.getCRC32(data, readPoint + 4, length + 4);
                int crcPosition = readPoint + 8 + length;
                data[crcPosition] = (byte)((crc & 0xFFFFFFFFFF000000L) >> 24);
                data[crcPosition + 1] = (byte)((crc & 0xFF0000L) >> 16);
                data[crcPosition + 2] = (byte)((crc & 0xFF00L) >> 8);
                data[crcPosition + 3] = (byte)(crc & 0xFFL);
                return true;
            }
            readPoint = readPoint + 8 + length + 4;
        }
        return false;
    }

    public static final long getCRC32(byte[] buf, int off, int len) {
        int c;
        if (crc_table == null) {
            crc_table = new int[256];
            for (int n = 0; n < 256; ++n) {
                c = n;
                int k = 8;
                while (--k >= 0) {
                    if ((c & 1) != 0) {
                        c = 0xEDB88320 ^ c >>> 1;
                        continue;
                    }
                    c >>>= 1;
                }
                Utils.crc_table[n] = c;
            }
        }
        int crc = 0;
        c = ~crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        crc = ~c;
        return (long)crc & 0xFFFFFFFFL;
    }

    public static final void drawArrow(Graphics g, int x, int y, boolean isRight, long time) {
        g.setColor(0xFFFF00);
        if (isRight) {
            if (time / 500L % 2L == 1L) {
                ++x;
            }
            g.fillRect(x + 1, y, 1, 1);
            g.fillRect(x + 2, y - 1, 1, 3);
            g.fillRect(x + 3, y - 2, 1, 5);
            g.fillRect(x + 4, y - 3, 1, 7);
        } else {
            if (time / 500L % 2L == 1L) {
                --x;
            }
            g.fillRect(x - 2, y - 2, 1, 5);
            g.fillRect(x - 1, y - 1, 1, 3);
            g.fillRect(x, y, 1, 1);
            g.fillRect(x - 3, y - 3, 1, 7);
        }
    }

    public static final void drawArrow2(Graphics g, int x, int y, boolean isRight, long time) {
        g.setColor(0xFF0000);
        if (isRight) {
            --x;
            if (time / 500L % 2L == 1L) {
                ++x;
            }
        } else {
            x -= 5;
            if (time / 500L % 2L == 1L) {
                --x;
            }
        }
        g.fillRect(x + 2, y - 3, 3, 1);
        g.fillRect(x + 2, y - 2, 1, 1);
        g.fillRect(x + 4, y - 2, 1, 1);
        g.fillRect(x + 1, y - 1, 5, 4);
    }

    public static final void drawUpDownArrow(Graphics g, int x, int y, boolean isUp, long time) {
        g.setColor(0xFFFF00);
        if (isUp) {
            if (time / 500L % 2L == 1L) {
                ++y;
            }
            g.fillRect(x, y, 1, 1);
            g.fillRect(x - 1, y + 1, 3, 1);
            g.fillRect(x - 2, y + 2, 5, 1);
            g.fillRect(x - 3, y + 3, 7, 1);
        } else {
            if (time / 500L % 2L == 1L) {
                --y;
            }
            g.fillRect(x - 2, y, 5, 1);
            g.fillRect(x - 1, y + 1, 3, 1);
            g.fillRect(x, y + 2, 1, 1);
            g.fillRect(x - 3, y - 1, 7, 1);
        }
    }

    public static final void clearRegion(Graphics g, int x, int y, int w, int h, int color) {
        g.setColor(color);
        g.fillRect(x, y, w, h);
    }

    public static final String replace(String text, String textSearch, String textReplace) {
        if (text.length() == 0) {
            return text;
        }
        int searchLength = textSearch.length();
        if (searchLength == 0) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int index = text.indexOf(textSearch);
        while (index != -1) {
            if (index != 0) {
                result.append(text.substring(0, index - searchLength + textSearch.length()) + textReplace);
            } else {
                result.append(textReplace);
            }
            text = text.substring(index + searchLength);
            index = text.indexOf(textSearch);
        }
        result.append(text);
        return result.toString();
    }

    public static final void findAndReplace(char[] text, int start, int end, String strFind, String strReplace) {
        if (strFind.length() != strReplace.length()) {
            return;
        }
        for (int i = start; i < end; ++i) {
            int j;
            if (text[i] != strFind.charAt(0)) continue;
            for (j = 1; j < strFind.length(); ++j) {
                if (i + j >= end) {
                    return;
                }
                if (text[i + j] == strFind.charAt(j)) continue;
                return;
            }
            for (j = 0; j < strFind.length(); ++j) {
                text[i + j] = strReplace.charAt(j);
            }
            return;
        }
    }
}

