/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import z.playw.j2me.Car;
import z.playw.j2me.Const;
import z.playw.j2me.MainCanvas;
import z.playw.j2me.Mid;
import z.playw.j2me.util.FMath;
import z.playw.j2me.util.PWPiFont;
import z.playw.j2me.util.Utils;

public class Sim
implements Const {
    private static int country;
    private static int mode;
    private static int raceRound;
    private static int carType;
    public static long startTime;
    public static final int EDGE_WIDTH_INCREASE = 32;
    public static final int[][] TARGET_SCORE;
    private byte nextMenuState;
    public static final int UI_TIME_X = 40;
    public static final int UI_SPEED_X = 440;
    public static final int UI_SPEED_Y = 15;
    public static final int UI_SPEED_H = 7;
    public static final int UI_SPEED_W = 5;
    public static final int UI_SPEED_XOFF = 9;
    public static final int MODE_DAREDEVIL = 0;
    public static final int MODE_SURVIVAL = 1;
    public static final int MODE_COLLISION = 2;
    public static final int MODE_MAX_TIME = 60000;
    public static final byte INGAME_BRIEFING = 0;
    public static final byte INGAME_321GO = 1;
    public static final byte INGAME_PLAYING = 2;
    public static final byte INGAME_GAMEOVER = 3;
    public static final byte INGAME_TOTAL = 4;
    public static final byte INGAME_UNLOCK = 5;
    public static final byte INGAME_TO_MENU = 6;
    public static final int GAME_RESULT_WIN = 0;
    public static final int GAME_RESULT_LOSE = 1;
    public static final int GAME_RESULT_CRASH = 2;
    public static final int GAME_RESULT_TIMEUP = 3;
    public static final int GAME_RESULT_NEXT = 4;
    public static final int TOTAL_CARS_MODE0 = 2;
    public static final int TOTAL_CARS_MODE1 = 6;
    public static final int PLAYER_CAR_HP = 1200;
    public static final int ENEMY_CAR_HP = 150;
    public static final int RACE_START_POSITION = Short.MAX_VALUE;
    public static final int SPEED_BITS = 7;
    public static Car[] cars;
    private int gameState;
    private int gameResult;
    private int gameTime;
    private static int gameScore;
    private int gameRank;
    static int gameTargetScore;
    private long stateTimmer;
    boolean needSave = false;
    String unlockMsg = "";
    int goFrameIdx = 0;
    static final int MODE0_CAR_Y_DIS = 360;
    static final int MODE0_LIST_SIZE = 10;
    static final int MODE0_CAR_HP = 40;
    int carInScreenIdx;
    int listStart;
    int listEnd;
    byte[] carPosXs = new byte[10];
    byte[] carHps = new byte[10];
    public static final int CLOSE_DIS = 90;
    public static final int DECIDE_TIME = 2000;
    long lastDecideTime;
    static final int[] APPEAR_DIS;
    int actorX;
    int actorY;
    int actorHalfW;
    int actorHalfH;
    int actorType;
    boolean actorEnable;
    int actorSpeedY;
    int actorAnim;
    int actorFlip;
    int actorFrameIndex;
    long animStartTime;
    static int[] point;
    static int[] fixHalf;
    int treeX;
    int treeY;
    private static int vpx;
    private static int vpy;
    private static int tvpx;
    private static int tvpy;
    public static final int SCORE_SPEED_X = 12;
    public static final int SCORE_SPEED_Y = 14;
    public static final int CAMERA_DIFF_MAX_Y = 90;
    public static final int CAMERA_DIFF_MAX_X = 120;
    private static Image backBuffer;
    private static Graphics gBackBuffer;
    private int bufWidth;
    private int bufHeight;
    private byte tileW;
    private byte tileH;
    private int roadWidth;
    private int roadHeight;
    public static int roadColWidth;
    public static final int END_LINE_BLOCK_SIZE = 6;
    public static int curKey;
    public static int keyPressed;
    public static int keyPressedOnce;
    public static int keyReleased;

    public Sim() {
        this.initMap();
    }

    public void initSim() {
        Sim.clearKey();
        this.initActors();
        this.initCars();
        this.initTree();
        startTime = MainCanvas.processTime;
        this.setGameState(0, startTime);
    }

    public static int getCountry() {
        return country;
    }

    public static void setCountry(int country) {
        Sim.country = country;
    }

    public static int getMode() {
        return mode;
    }

    public static void setMode(int mode) {
        Sim.mode = mode;
        gameTargetScore = TARGET_SCORE[country][mode];
        gameScore = 0;
        raceRound = 0;
    }

    public static int getCarType() {
        return carType;
    }

    public static void setCarType(int type) {
        carType = type;
    }

    public byte getNextMenuState() {
        return this.nextMenuState;
    }

    public void setNextMenuState(byte menu) {
        this.nextMenuState = menu;
    }

    public boolean process(long time) {
        if (this.gameState == 6) {
            return false;
        }
        this.updateMode(time);
        if (this.gameState == 2 || this.gameState == 3) {
            int i;
            for (i = 0; i < cars.length; ++i) {
                cars[i].process(time);
            }
            for (i = 0; i < cars.length; ++i) {
                cars[i].updateCollWithCars(time);
            }
            for (i = 0; i < cars.length; ++i) {
                cars[i].updateCollWithWall();
            }
            this.updateActors(time);
        }
        if (this.gameState == 2) {
            this.updateViewByCar(cars[0]);
        } else {
            this.updateCamera(tvpx, tvpy, false);
        }
        keyPressedOnce = -1;
        return true;
    }

    public void paint(Graphics g) {
        this.paintMap(g);
        this.paintActors(g);
        cars[0].paint(g, vpx, vpy);
        for (int i = 1; i < cars.length; ++i) {
            cars[i].paint(g, vpx, vpy);
        }
        this.paintTree(g);
        this.paintInterface(g);
    }

    private void paintInterface(Graphics g) {
        switch (this.gameState) {
            case 1: {
                this.goFrameIdx = MainCanvas.anim321Go.drawAnimation(g, 0, MainCanvas.processTime - this.stateTimmer, 240, 60, 0, false);
                break;
            }
            case 2: {
                this.paintUIPlaying(g);
                g.setColor(0);
                int x = 471;
                int y = 355;
                g.fillRect(x - 2, y - 2, 9, 1);
                g.fillRect(x - 1, y - 1, 7, 1);
                g.fillRect(x, y, 5, 1);
                g.fillRect(x + 1, y + 1, 3, 1);
                g.fillRect(x + 2, y + 2, 1, 1);
                break;
            }
            case 3: {
                int h = MainCanvas.font.getFontHeight() * 4;
                int y = 180 - h / 2;
                int x = 0;
                g.setColor(0);
                g.fillRect(x, y, 480, h);
                x += 240;
                String msg = this.gameResult == 0 ? MainCanvas.lang[235] : (this.gameResult == 1 ? MainCanvas.lang[236] : (this.gameResult == 2 ? MainCanvas.lang[189] : (this.gameResult == 3 ? MainCanvas.lang[186] : (this.gameResult == 4 ? MainCanvas.lang[237] : ""))));
                MainCanvas.font.drawString(g, msg, 0, 0, 480, 360, 3);
                MainCanvas.paintButtons(g, 1);
                break;
            }
            case 4: {
                String msg = mode != 2 && this.gameResult != 2 ? MainCanvas.lang[186] : MainCanvas.lang[187];
                char[] chars = msg.toCharArray();
                short[][] lineData = MainCanvas.font.getLineData(chars, 480);
                int items = lineData.length + 3;
                if (mode != 0) {
                    items += 3;
                }
                int x = 0;
                int h = MainCanvas.font.getFontHeight() * (items + 2);
                int y = 180 - h / 2;
                g.setColor(0);
                g.fillRect(x, y, 480, h);
                x = 240;
                MainCanvas.font.drawFastString(g, chars, 0, y += MainCanvas.font.getFontHeight(), 480, MainCanvas.font.getFontHeight() * lineData.length, 17, lineData);
                MainCanvas.font.drawString(g, MainCanvas.lang[188], x, y += MainCanvas.font.getFontHeight() * (lineData.length + 1), 17);
                MainCanvas.font.drawString(g, "" + gameScore, x, y += MainCanvas.font.getFontHeight(), 17);
                if (mode != 0) {
                    MainCanvas.font.drawString(g, MainCanvas.lang[190], x, y += MainCanvas.font.getFontHeight() * 2, 17);
                    MainCanvas.font.drawString(g, "" + this.gameRank + "/" + cars.length, x, y += MainCanvas.font.getFontHeight(), 17);
                }
                MainCanvas.paintButtons(g, 1);
                break;
            }
            case 5: {
                char[] msgData = this.unlockMsg.toCharArray();
                short[][] mLineData = MainCanvas.font.getLineData(msgData, 480);
                int h = MainCanvas.font.getFontHeight() * (mLineData.length + 2);
                int y = 180 - h / 2;
                int x = 0;
                g.setColor(0);
                g.fillRect(x, y, 480, h);
                x += 240;
                MainCanvas.font.drawFastString(g, msgData, 0, 0, 480, 360, 3, mLineData);
                MainCanvas.paintButtons(g, 1);
            }
        }
    }

    private void paintUIPlaying(Graphics g) {
        int paintTime;
        int x = Sim.getPaintPosX(this.actorX);
        int y = this.actorY - vpy;
        if (y < 0 && this.gameTime / 300 % 2 == 0) {
            MainCanvas.font.drawString(g, "! ! !", x, 40, 17);
        }
        MainCanvas.animSpeedBg.drawAnimation(g, 0, 0L, 440, 15, 0, false);
        int speedView = Sim.cars[0].fixSpeed >> 7;
        if (speedView >= 2) {
            speedView += Utils.getRandNumber(-2, 2);
        }
        int speedX = 445;
        y = 22;
        MainCanvas.font.drawChar(g, (char)(48 + speedView / 100), speedX, y);
        MainCanvas.font.drawChar(g, (char)(48 + speedView / 10 % 10), speedX += 9, y);
        MainCanvas.font.drawChar(g, (char)(48 + speedView % 10), speedX += 9, y);
        boolean show = true;
        if (mode == 2) {
            paintTime = this.gameTime / 1000;
        } else {
            paintTime = (60000 - this.gameTime) / 1000;
            if (paintTime < 0) {
                paintTime = 0;
            }
            if (paintTime < 10) {
                show = MainCanvas.processTime / 500L % 2L == 0L;
            }
        }
        int min = paintTime / 60;
        int sec = paintTime % 60;
        if (show) {
            x = 33;
            y = 15 + MainCanvas.font.fontHeight + MainCanvas.font.fontHeight / 2;
            MainCanvas.font.drawChar(g, (char)(48 + sec % 10), x, y);
            MainCanvas.font.drawChar(g, (char)(48 + sec / 10), x -= 7, y);
            MainCanvas.font.drawChar(g, ':', x -= 5, y);
            MainCanvas.font.drawChar(g, (char)(48 + min % 10), x -= 8, y);
            MainCanvas.font.drawChar(g, (char)(48 + min / 10), x -= 7, y);
        }
        y = 15 - MainCanvas.font.fontHeight / 2;
        MainCanvas.font.drawString(g, gameScore, 40, y, 24);
        PWPiFont font = MainCanvas.font;
        if (mode != 0) {
            int w = font.getCharacterWidth('/');
            char rank = (char)(48 + this.gameRank);
            x = 240 - font.getCharacterWidth(rank) - w / 2;
            y = 90 + (font.fontHeight >> 1);
            x += font.drawChar(g, rank, x, y);
            x += font.drawChar(g, '/', x, y);
            x += font.drawChar(g, (char)(48 + cars.length), x, y);
        }
    }

    public static void getScore(int score) {
        gameScore += score;
    }

    public void setGameState(int gameState, long time) {
        this.gameState = gameState;
        this.stateTimmer = time;
        if (gameState == 0) {
            tvpy = 32047;
            for (int i = 0; i < cars.length; ++i) {
                cars[i].setState(0);
            }
            this.goFrameIdx = 0;
        } else if (gameState == 2) {
            for (int i = 0; i < cars.length; ++i) {
                cars[i].setState(1);
            }
            this.listStart = 0;
            this.listEnd = -1;
            this.carInScreenIdx = -1;
            this.gameTime = 0;
            this.lastDecideTime = time;
        } else if (gameState == 3 && this.gameResult == 0) {
            boolean newHS;
            boolean bl = newHS = gameScore > MainCanvas.getHighScore(country, mode);
            if (newHS) {
                MainCanvas.setHighScore(country, mode, gameScore);
                this.needSave = true;
            }
            int nextLock = country * 3 + mode + 1;
            int MAX_LOCK = (MainCanvas.MENUS_SEL_COUNTRY.length - 1) * 3 + 3;
            if (MainCanvas.rsData[1] < nextLock) {
                if (nextLock == MAX_LOCK) {
                    this.unlockMsg = MainCanvas.lang[248];
                    this.setNextMenuState((byte)4);
                } else {
                    this.unlockMsg = MainCanvas.lang[20];
                    this.unlockMsg = this.unlockMsg + "\n";
                    this.unlockMsg = this.unlockMsg + MainCanvas.lang[127 + (mode + 1) % 3];
                    if (nextLock % 3 == 0) {
                        this.unlockMsg = this.unlockMsg + "\n\n";
                        this.unlockMsg = this.unlockMsg + MainCanvas.lang[28];
                        this.unlockMsg = this.unlockMsg + "\n";
                        this.unlockMsg = this.unlockMsg + MainCanvas.lang[MainCanvas.MENUS_SEL_COUNTRY[nextLock / 3]];
                        this.setNextMenuState((byte)9);
                    } else {
                        this.setNextMenuState((byte)10);
                    }
                }
                MainCanvas.rsData[1] = (byte)nextLock;
                this.needSave = true;
            } else {
                if (nextLock == MAX_LOCK) {
                    this.setNextMenuState((byte)4);
                }
                if (newHS) {
                    this.unlockMsg = MainCanvas.lang[26] + "\n" + gameScore;
                }
            }
        }
        Sim.clearKey();
    }

    private void initCars() {
        int totalCars = mode == 0 ? 2 : 6;
        cars = new Car[totalCars];
        Sim.cars[0] = new Car();
        cars[0].setAnim(MainCanvas.animPlayerCar);
        cars[0].setAiMode(mode);
        cars[0].setPlayerCar(true);
        cars[0].initHp(1200);
        for (int i = 1; i < totalCars; ++i) {
            Sim.cars[i] = new Car();
            cars[i].setAnim(MainCanvas.animEnemyCar);
            cars[i].setAiMode(mode);
            cars[i].setPlayerCar(false);
            cars[i].initHp(150 + country * 10);
        }
        if (mode == 0) {
            cars[0].setPos(0, Short.MAX_VALUE);
            cars[1].setPos(0, 33127);
        } else {
            int startX = -roadColWidth >> 2;
            int startY = Short.MAX_VALUE;
            for (int i = 0; i < totalCars; ++i) {
                cars[i].setPos(startX, startY);
                startX = -startX;
                startY -= Sim.cars[0].half[1] << 2;
            }
        }
    }

    private void updateMode(long time) {
        int frameTime = (int)(time - startTime);
        startTime = time;
        switch (this.gameState) {
            case 0: {
                tvpx = 0;
                tvpy += 2;
                if (curKey == 512) {
                    tvpy = Sim.cars[0].posY - 270;
                }
                if (tvpy < Sim.cars[0].posY - 270) break;
                this.setGameState(1, time);
                break;
            }
            case 1: {
                this.update321G0(time);
                break;
            }
            case 2: {
                this.gameTime += frameTime;
                if (mode == 0) {
                    this.updateMode0(time);
                } else {
                    this.updateMode1(time);
                }
                if (curKey == 16384) {
                    Sim.clearKey();
                    Mid.canvas.pauseGame();
                }
                this.updateTree();
                this.checkWinLose(time);
                break;
            }
            case 3: {
                if (time - this.stateTimmer <= 1000L || curKey != 512) break;
                this.setGameState(4, time);
                break;
            }
            case 4: {
                if (curKey != 512) break;
                if (this.isUnlock()) {
                    this.setGameState(5, time);
                    break;
                }
                this.tryToNewRace(time);
                break;
            }
            case 5: {
                if (curKey != 512) break;
                this.tryToNewRace(time);
            }
        }
    }

    private void tryToNewRace(long time) {
        if (this.needSave) {
            this.needSave = false;
            MainCanvas.save();
        }
        if (mode == 2 && this.gameResult != 1 && this.gameResult != 2) {
            if (++raceRound >= 3) {
                this.setGameState(6, time);
            } else {
                this.initSim();
            }
        } else {
            this.setNextMenuState((byte)10);
            this.setGameState(6, time);
        }
    }

    public void restartRace() {
        Sim.setMode(mode);
        this.initSim();
    }

    private void checkWinLose(long time) {
        if (mode != 2 && this.gameTime > 60000) {
            this.gameResult = gameScore >= gameTargetScore ? 0 : 1;
            this.setGameState(3, time);
        }
        if (Sim.cars[0].posY < 0) {
            this.gameResult = mode == 2 ? (this.gameRank > 3 && raceRound != 2 ? 1 : (raceRound == 2 ? (gameScore > gameTargetScore ? 0 : 1) : 4)) : (gameScore > gameTargetScore ? 0 : 1);
            this.setGameState(3, time);
        }
        if (Sim.cars[0].hp <= 0) {
            this.gameResult = 2;
            this.setGameState(3, time);
        }
    }

    public boolean isUnlock() {
        return this.unlockMsg != null && this.unlockMsg.length() > 0;
    }

    private void update321G0(long time) {
        if (this.goFrameIdx == -1) {
            this.setGameState(2, time);
        }
    }

    void updateMode0(long time) {
        if (this.listEnd == -1 && Sim.cars[0].posY < 32407) {
            this.spawnACar();
        }
        if (Sim.cars[1].hp <= 0) {
            // empty if block
        }
        if (Sim.cars[1].posY - Sim.cars[0].posY > 360) {
            this.setNextCar(true);
        } else if (Sim.cars[0].posY - Sim.cars[1].posY > 540 && !this.setNextCar(false) && Sim.cars[0].posY - Sim.cars[1].posY > 720) {
            Sim.cars[1].posY = Sim.cars[0].posY - 720;
            Sim.cars[1].fixPos[1] = FMath.fix(Sim.cars[1].posY);
        }
    }

    boolean setNextCar(boolean forward) {
        int y;
        if (forward) {
            if (this.carInScreenIdx == this.listEnd) {
                this.spawnACar();
                return true;
            }
            this.dumpCurrCar();
            this.carInScreenIdx = (this.carInScreenIdx + 1) % 10;
            y = vpy - Sim.cars[1].half[1];
        } else {
            if (this.carInScreenIdx == this.listStart) {
                return false;
            }
            this.dumpCurrCar();
            this.carInScreenIdx = (this.carInScreenIdx - 1) % 10;
            if (this.carInScreenIdx < 0) {
                this.carInScreenIdx += 10;
            }
            y = vpy + 360 + Sim.cars[1].half[1];
        }
        if (this.carHps[this.carInScreenIdx] <= 0) {
            return this.setNextCar(forward);
        }
        cars[1].setState(1);
        byte x = this.carPosXs[this.carInScreenIdx];
        cars[1].setPos(x, y);
        cars[1].setHp(this.carHps[this.carInScreenIdx]);
        return true;
    }

    void spawnACar() {
        if (this.listEnd == -1) {
            this.listEnd = 0;
        } else {
            this.dumpCurrCar();
            this.listEnd = (this.listEnd + 1) % 10;
            if (this.listEnd == this.listStart) {
                this.listStart = (this.listStart + 1) % 10;
            }
        }
        this.carInScreenIdx = this.listEnd;
        int carXLimit = roadColWidth / 2 - Sim.cars[1].half[0];
        int x = Utils.getRandNumber(-carXLimit, carXLimit);
        int y = vpy - Sim.cars[1].half[1];
        cars[1].setPos(x, y);
        cars[1].initHp(40 + country * 5);
        cars[1].setState(1);
        Sim.cars[1].fixSpeed = Sim.cars[1].fixSpeedMax;
        this.dumpCurrCar();
    }

    void dumpCurrCar() {
        this.carPosXs[this.carInScreenIdx] = (byte)Sim.cars[1].posX;
        this.carHps[this.carInScreenIdx] = (byte)Sim.cars[1].hp;
    }

    void updateMode1(long time) {
        this.updateGameRank();
        this.updateDesision(time);
    }

    private void updateGameRank() {
        this.gameRank = cars.length;
        for (int i = 1; i < cars.length; ++i) {
            if (Sim.cars[i].posY <= Sim.cars[0].posY) continue;
            --this.gameRank;
        }
    }

    void updateDesision(long time) {
        if (time - this.lastDecideTime < 2000L) {
            return;
        }
        boolean haveDecision = false;
        int carBehind = -1;
        int carInFront = -1;
        int carClose = -1;
        int disBehind = 1048575;
        int disInFront = 1048575;
        int disClose = 1048575;
        for (int i = 1; i < cars.length; ++i) {
            Car car = cars[i];
            if (car.state == 2) continue;
            if (car.decision != 0) {
                if (car.hp <= 0) {
                    car.setDecision(0);
                } else {
                    haveDecision = true;
                }
            }
            int dis = car.posY - Sim.cars[0].posY;
            int disAbs = Math.abs(dis);
            if (dis >= 0) {
                if (disBehind > dis) {
                    disBehind = disAbs;
                    carBehind = i;
                }
            } else if (disInFront > disAbs) {
                disInFront = disAbs;
                carInFront = i;
            }
            if (disClose <= disAbs) continue;
            disClose = disAbs;
            carClose = i;
        }
        if (!haveDecision) {
            if (carInFront == -1) {
                if (carBehind > 0 && (mode != 2 || Utils.getRandNumber(0, 20) > 15)) {
                    cars[carBehind].setDecision(2);
                }
            } else if (carBehind == -1) {
                if (carInFront > 0) {
                    cars[carInFront].setDecision(3);
                }
            } else if (carClose > 0 && disClose < 90) {
                cars[carClose].setDecision(1);
            } else {
                int selFront = 0;
                int selBehind = 0;
                if (carInFront > 0) {
                    selFront = Utils.getRandNumber(0, disInFront);
                }
                if (carBehind > 0) {
                    selBehind = Utils.getRandNumber(0, disBehind);
                }
                if (selFront > selBehind) {
                    cars[carInFront].setDecision(3);
                } else {
                    cars[carBehind].setDecision(2);
                }
            }
            this.lastDecideTime = time;
        }
    }

    void initActors() {
        this.actorType = -1;
        this.actorX = 0;
        this.actorY = 0;
        this.actorEnable = false;
    }

    void spawnActor(int type, long time) {
        this.actorType = type;
        this.actorHalfW = MainCanvas.animActors[type].getFrameWidth(0) / 2;
        this.actorHalfH = MainCanvas.animActors[type].getFrameHeight(0) / 2;
        this.actorY = vpy - APPEAR_DIS[this.actorType];
        int region = roadColWidth / 2 - this.actorHalfW;
        if (country < 3) {
            this.actorX = Utils.getRandNumber(-region, region);
        } else {
            this.actorX = Sim.cars[0].posX;
            if (this.actorX < -region) {
                this.actorX = -region;
            } else if (this.actorX > region) {
                this.actorX = region;
            }
        }
        this.animStartTime = time;
        this.actorAnim = type == 0 ? Utils.getRandNumber(0, 1) * 2 : 0;
        this.actorFlip = 0;
        this.actorEnable = true;
    }

    void updateActors(long time) {
        boolean inCamera;
        if (this.gameState != 2) {
            return;
        }
        boolean bl = inCamera = this.actorType >= 0 && this.actorY + APPEAR_DIS[this.actorType] > vpy && this.actorY - this.actorHalfH - 20 < vpy + 360;
        if (!inCamera && vpy > 360 + APPEAR_DIS[1]) {
            int type = mode == 0 ? 0 : (mode == 1 ? (country < 3 ? 1 : Utils.getRandNumber(1, 2)) : (country < 3 ? Utils.getRandNumber(0, 1) : Utils.getRandNumber(0, 2)));
            type = type == 0 ? 1 : (type == 1 ? 0 : 2);
            this.spawnActor(type, time);
        }
        if (this.actorType >= 0) {
            switch (this.actorType) {
                case 1: {
                    this.updateOil();
                    break;
                }
                case 0: 
                case 2: {
                    this.updateCan(time);
                }
            }
        }
    }

    void updateOil() {
        for (int i = 0; i < cars.length; ++i) {
            if (this.carInRect(cars[i], this.actorX, this.actorY, this.actorHalfW, this.actorHalfH)) {
                int speed = Car.DEFAULT_MOVE_MAX_SPEED >> 1;
                speed -= (speed >> 1) * country / (MainCanvas.MENUS_SEL_COUNTRY.length - 1);
                Sim.cars[i].fixBaseSpeedMax = speed;
            } else {
                cars[i].loadCarSpeedMax();
            }
            Sim.cars[i].fixSpeedMax = Sim.cars[i].fixBaseSpeedMax;
        }
    }

    boolean carInRect(Car car, int x, int y, int halfW, int halfH) {
        for (int i = 0; i < 4; ++i) {
            int px = car.posX + FMath.fix2int(car.carPoints[i][0]);
            int py = car.posY + FMath.fix2int(car.carPoints[i][1]);
            if (px <= x - halfW || px >= x + halfW || py <= y - halfH || py >= y + halfH) continue;
            return true;
        }
        return false;
    }

    void updateCan(long time) {
        if (!this.actorEnable) {
            return;
        }
        if (this.actorAnim % 2 != 0) {
            this.actorY -= this.actorSpeedY;
            if (this.actorFrameIndex == -1) {
                this.actorEnable = false;
            }
            return;
        }
        for (int i = 0; i < cars.length; ++i) {
            Car car = cars[i];
            Sim.fixHalf[0] = FMath.fix(car.half[0]);
            Sim.fixHalf[1] = FMath.fix(car.half[1]);
            Sim.point[0] = FMath.fix(this.actorX);
            Sim.point[1] = FMath.fix(this.actorY);
            boolean isCollision = FMath.isPointInRect(point, car.fixPos, fixHalf, car.angle);
            if (!isCollision) {
                Sim.point[0] = FMath.fix(this.actorX - this.actorHalfW);
                Sim.point[1] = FMath.fix(this.actorY - this.actorHalfH);
                isCollision = FMath.isPointInRect(point, car.fixPos, fixHalf, car.angle);
            }
            if (!isCollision) {
                Sim.point[0] = FMath.fix(this.actorX + this.actorHalfW);
                Sim.point[1] = FMath.fix(this.actorY - this.actorHalfH);
                isCollision = FMath.isPointInRect(point, car.fixPos, fixHalf, car.angle);
            }
            if (!isCollision) {
                Sim.point[0] = FMath.fix(this.actorX - this.actorHalfW);
                Sim.point[1] = FMath.fix(this.actorY + this.actorHalfH);
                isCollision = FMath.isPointInRect(point, car.fixPos, fixHalf, car.angle);
            }
            if (!isCollision) {
                Sim.point[0] = FMath.fix(this.actorX - this.actorHalfW);
                Sim.point[1] = FMath.fix(this.actorY - this.actorHalfH);
                isCollision = FMath.isPointInRect(point, car.fixPos, fixHalf, car.angle);
            }
            if (!isCollision) continue;
            if (this.actorType == 0) {
                if (car.posX > this.actorX) {
                    this.actorFlip = 2;
                }
                ++this.actorAnim;
                this.animStartTime = time;
                this.actorSpeedY = car.speed;
                this.actorFrameIndex = 0;
                int dmg = 10 + 8 * country;
                if (car.isPlayer) {
                    car.beAttacked(time, dmg);
                    Sim.getScore(dmg << 1);
                    break;
                }
                car.beAttacked(time, dmg >> 1);
                break;
            }
            int dmg = 10 + 8 * country;
            if (car.isPlayer) {
                car.beAttacked(time, dmg);
            } else {
                car.beAttacked(time, dmg >> 2);
            }
            car.setBlink(time + 1000L);
            break;
        }
    }

    void paintActors(Graphics g) {
        if (this.actorType < 0 || !this.actorEnable) {
            return;
        }
        int x = Sim.getPaintPosX(this.actorX);
        int y = this.actorY - vpy;
        if (this.actorType == 2) {
            MainCanvas.animActors[this.actorType].drawAnimation(g, this.actorAnim, MainCanvas.processTime - this.animStartTime, x, y, this.actorFlip, true);
        } else {
            this.actorFrameIndex = MainCanvas.animActors[this.actorType].drawAnimation(g, this.actorAnim, MainCanvas.processTime - this.animStartTime, x, y, this.actorFlip, false);
        }
    }

    private void initTree() {
        this.treeY = 33487;
    }

    private void spawnATree() {
        this.treeY = vpy - Utils.getRandNumber(480, 960);
    }

    private void updateTree() {
        int treeToTopDis;
        int treeH = MainCanvas.imgTree.getHeight();
        if (this.treeY > vpy + 360 + treeH) {
            this.spawnATree();
        }
        if ((treeToTopDis = vpy - this.treeY) > treeH / 2 && treeToTopDis < treeH) {
            boolean isLeft;
            boolean bl = isLeft = Sim.cars[0].posX > 0;
            if (Math.abs(Sim.cars[0].posX) < roadColWidth >> 2) {
                isLeft = Utils.getRandNumber(0, 1) == 0;
            }
            this.treeX = isLeft ? this.roadWidth / 2 : -this.roadWidth / 2;
        }
    }

    private void paintTree(Graphics g) {
        int x = Sim.getPaintPosX(this.treeX);
        int y = this.treeY - vpy;
        g.drawImage(MainCanvas.imgTree, x, y, 3);
    }

    public static int getPaintPosX(int posX) {
        return posX - vpx + 240;
    }

    private void updateViewByCar(Car car) {
        tvpx = car.posX >> 1;
        tvpy = car.posY - 270;
        if (tvpy < -180) {
            tvpy = -180;
        }
        this.updateCamera(tvpx, tvpy, true);
    }

    private void updateCamera(int x, int y, boolean smooth) {
        if (smooth) {
            int diffX = x - vpx;
            int diffY = y - vpy;
            int absDiffX = Math.abs(diffX);
            int absDiffY = Math.abs(diffY);
            vpx = absDiffX > 120 ? (diffX > 0 ? x - 120 : x + 120) : (absDiffX > 12 ? (diffX > 0 ? vpx + 12 : vpx - 12) : x);
            if (absDiffY > 14) {
                if (diffY > 0) {
                    if (y - (vpy += 14) > 90) {
                        vpy = y - 90;
                    }
                } else if ((vpy -= 14) - y > 90) {
                    vpy = y + 90;
                }
            } else {
                vpy = y;
            }
        } else {
            vpx = x;
            vpy = y;
        }
        if (vpy < -180) {
            vpy = -180;
        }
    }

    public static boolean isInCamera(Car car) {
        return Sim.isInCamera(car.posX, car.posY, car.half[0], car.half[1]);
    }

    public static boolean isInCamera(int posX, int posY, int halfW, int halfH) {
        return posX <= vpx + 240 + halfW && posX >= vpx - 240 - halfW && posY >= vpy - halfH && posY <= vpy + 360 + halfH;
    }

    private void initMap() {
        this.tileW = (byte)MainCanvas.imgRoadBg.getWidth();
        this.tileH = (byte)MainCanvas.imgRoadBg.getHeight();
        this.roadWidth = MainCanvas.imgRoad0.getWidth();
        this.roadHeight = MainCanvas.imgRoad0.getHeight();
        roadColWidth = this.roadWidth - 20 - 32;
        this.createBackBufferImage(480, 360, this.tileW, this.tileH);
    }

    private final void createBackBufferImage(int screenW, int screenH, byte tileW, byte tileH) {
        int bbWide = screenW / tileW + (screenW % tileW == 0 ? 1 : 2);
        int bbHigh = screenH / tileH + (screenH % tileH == 0 ? 1 : 2);
        this.bufWidth = bbWide * tileW;
        this.bufHeight = bbHigh * tileH;
        backBuffer = Image.createImage((int)this.bufWidth, (int)this.bufHeight);
        gBackBuffer = backBuffer.getGraphics();
        for (int x = 0; x < this.bufWidth; x += tileW) {
            for (int y = 0; y < this.bufHeight; y += tileH) {
                gBackBuffer.drawImage(MainCanvas.imgRoadBg, x, y, 0);
            }
        }
        MainCanvas.imgRoadBg = null;
    }

    public static final void freeBackBuffer() {
        backBuffer = null;
        gBackBuffer = null;
    }

    private void paintMap(Graphics g) {
        int x0 = Sim.getPaintPosX(-this.roadWidth / 2);
        int x1 = x0 + this.roadWidth;
        if (x0 > 0) {
            this.paintMapBG(g, 0, x0 > 480 ? 480 : x0);
        }
        if (x1 < 480) {
            if (x1 < 0) {
                x1 = 0;
            }
            this.paintMapBG(g, x1, 480 - x1);
        }
        g.setClip(0, 0, 480, 360);
        boolean isFirstBlock = vpy / this.roadHeight % 2 == 0;
        int yOff = vpy % this.roadHeight;
        if (yOff < 0) {
            yOff += this.roadHeight;
            isFirstBlock = !isFirstBlock;
        }
        for (int y = -yOff; y < 360; y += this.roadHeight) {
            g.drawImage(isFirstBlock ? MainCanvas.imgRoad0 : MainCanvas.imgRoad1, x0, y, 0);
            isFirstBlock = !isFirstBlock;
        }
        if (vpy < 6) {
            g.setColor(0xFFFFFF);
            int xStart = Sim.getPaintPosX(-roadColWidth / 2);
            int yStart = -vpy - 6;
            for (int y = 0; y < 12; y += 6) {
                for (int x = 0; x < roadColWidth && x + xStart <= 480; x += 12) {
                    if (x + xStart + 6 < 0) continue;
                    g.fillRect(x + xStart, y + yStart, 6, 6);
                }
                xStart += 6;
            }
        }
    }

    private void paintMapBG(Graphics g, int startX, int paintW) {
        int modX0 = (vpx + startX) % this.bufWidth;
        int modY0 = vpy % this.bufHeight;
        int modX1 = (vpx + startX + paintW) % this.bufWidth;
        int modY1 = (vpy + 360) % this.bufHeight;
        if (modX0 < 0) {
            modX0 += this.bufWidth;
        }
        if (modX1 < 0) {
            modX1 += this.bufWidth;
        }
        if (modY0 < 0) {
            modY0 += this.bufHeight;
        }
        if (modY1 < 0) {
            modY1 += this.bufHeight;
        }
        if (modX1 > modX0) {
            if (modY1 > modY0) {
                Sim.CopyFromBackImage(g, modX0, modY0, paintW, 360, startX, 0);
            } else {
                Sim.CopyFromBackImage(g, modX0, modY0, paintW, 360 - modY1, startX, 0);
                Sim.CopyFromBackImage(g, modX0, 0, paintW, modY1, startX, 360 - modY1);
            }
        } else if (modY1 > modY0) {
            Sim.CopyFromBackImage(g, modX0, modY0, paintW - modX1, 360, startX, 0);
            Sim.CopyFromBackImage(g, 0, modY0, modX1, 360, startX + paintW - modX1, 0);
        } else {
            Sim.CopyFromBackImage(g, modX0, modY0, paintW - modX1, 360 - modY1, startX, 0);
            Sim.CopyFromBackImage(g, modX0, 0, paintW - modX1, modY1, startX, 360 - modY1);
            Sim.CopyFromBackImage(g, 0, modY0, modX1, 360 - modY1, startX + paintW - modX1, 0);
            Sim.CopyFromBackImage(g, 0, 0, modX1, modY1, startX + paintW - modX1, 360 - modY1);
        }
    }

    static void CopyFromBackImage(Graphics g, int modX, int modY, int w, int h, int screenX, int screenY) {
        g.setClip(screenX, screenY, w, h);
        g.drawImage(backBuffer, screenX - modX, screenY - modY, 20);
    }

    public static void clearKey() {
        curKey = -1;
        keyPressed = 0;
        keyReleased = 0;
    }

    public void keyPress(char c) {
        switch (c) {
            case '\u0003': 
            case '4': {
                curKey = 256;
                keyPressed |= 0x100;
                break;
            }
            case '\u0004': 
            case '6': {
                curKey = 1024;
                keyPressed |= 0x400;
                break;
            }
            case '\u0005': 
            case '2': {
                curKey = 64;
                keyPressed |= 0x40;
                break;
            }
            case '\u0006': 
            case '8': {
                curKey = 4096;
                keyPressed |= 0x1000;
                break;
            }
            case '3': {
                curKey = 128;
                keyPressed |= 0x80;
                break;
            }
            case '9': {
                curKey = 8192;
                keyPressed |= 0x2000;
                break;
            }
            case '1': {
                curKey = 32;
                keyPressed |= 0x20;
                break;
            }
            case '7': {
                curKey = 2048;
                keyPressed |= 0x800;
                break;
            }
            case '\u0000': 
            case '\u0002': 
            case '5': {
                curKey = 512;
                keyPressed |= 0x200;
                break;
            }
            case '0': {
                curKey = 16;
                keyPressed |= 0x10;
                break;
            }
            case '*': {
                curKey = 65536;
                keyPressed |= 0x10000;
                break;
            }
            case '#': {
                curKey = 32768;
                keyPressed |= 0x8000;
                break;
            }
            case '\u0001': {
                curKey = 16384;
                keyPressed |= 0x4000;
            }
        }
        keyPressedOnce = curKey;
    }

    public void keyRelease(char c) {
        switch (c) {
            case '\u0003': 
            case '4': {
                keyPressed &= 0xFFFFFEFF;
                keyReleased = 256;
                break;
            }
            case '\u0004': 
            case '6': {
                keyPressed &= 0xFFFFFBFF;
                keyReleased = 1024;
                break;
            }
            case '\u0005': 
            case '2': {
                keyPressed &= 0xFFFFFFBF;
                keyReleased = 64;
                break;
            }
            case '\u0006': 
            case '8': {
                keyPressed &= 0xFFFFEFFF;
                keyReleased = 4096;
                break;
            }
            case '3': {
                keyPressed &= 0xFFFFFF7F;
                keyReleased = 128;
                break;
            }
            case '9': {
                keyPressed &= 0xFFFFDFFF;
                keyReleased = 8192;
                break;
            }
            case '1': {
                keyPressed &= 0xFFFFFFDF;
                keyReleased = 32;
                break;
            }
            case '7': {
                keyPressed &= 0xFFFFF7FF;
                keyReleased = 2048;
                break;
            }
            case '\u0000': 
            case '\u0002': 
            case '5': {
                keyPressed &= 0xFFFFFDFF;
                keyReleased = 512;
                break;
            }
            case '0': {
                keyPressed &= 0xFFFFFFEF;
                keyReleased = 16;
                break;
            }
            case '*': {
                keyPressed &= 0xFFFEFFFF;
                keyReleased = 65536;
                break;
            }
            case '#': {
                keyPressed &= 0xFFFF7FFF;
                keyReleased = 32768;
                break;
            }
            case '\u0001': {
                keyPressed &= 0xFFFFBFFF;
                keyReleased = 16384;
            }
        }
        curKey = -1;
    }

    static {
        TARGET_SCORE = new int[][]{{1000, 2000, 5000}, {1000, 2000, 5000}, {1000, 2000, 5000}, {1000, 2000, 5000}, {1000, 2000, 5000}, {1000, 2000, 5000}};
        APPEAR_DIS = new int[]{200, 220, 200};
        point = new int[2];
        fixHalf = new int[2];
        curKey = -1;
        keyPressed = 0;
        keyPressedOnce = 0;
        keyReleased = 0;
    }
}

