/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import z.playw.j2me.Const;
import z.playw.j2me.Mid;
import z.playw.j2me.Sim;
import z.playw.j2me.util.PWAdvancedKeyboard;
import z.playw.j2me.util.PWPiFont;
import z.playw.j2me.util.PWScreenToolbox;
import z.playw.j2me.util.Utils;
import z.playw.j2me.util.ZedAnimation;

public class MainCanvas
extends Canvas
implements Const {
    public static final int SLEEP_TIME = 5;
    public static final int GAP_PROCESS = 40;
    public static final int MAX_TIME_BETWEEN_FRAMES = 160;
    public static final int TIME_TO_ENTER_PAUSE_STATE = 5000;
    public static final byte First_Valid_App_Value = 0;
    public static final byte APPSTATE_LOGOINTRO = 0;
    public static final byte APPSTATE_SPLASH = 1;
    public static final byte APPSTATE_MENU = 2;
    public static final byte APPSTATE_PLAY = 3;
    public static final byte APPSTATE_PAUSE_MENU = 4;
    public static final byte Last_Valid_App_Value = 4;
    public static byte appState = 0;
    public static final String Font_GAMEFONT = "font.ajo";
    public static PWPiFont font;
    public static final String LANG_GAME_TEXTFILE_NAME = "lang";
    public static String[] lang;
    public static int langId;
    public static PWAdvancedKeyboard keyboard;
    public static final int LOADINGBAR_BASE_HEIGHT = 1;
    public static int loadingBarStep;
    public static int loadingBarTotalSteps;
    public static int offsetY;
    public static boolean loading;
    private int tipTxtId;
    public static final int LOGOINTRO_INIT = 0;
    public static final int LOGOINTRO_ZED = 1;
    public static final int LOGOINTRO_PLAYX = 2;
    public static final int LOGOINTRO_FINISHED = 3;
    public static final int LOGOINTRO_TIME = 2000;
    public static final String Image_SUFIX = ".png";
    public static final String Image_ZED = "zed";
    public static final String Image_PLAYX = "playx";
    public static Image imglogoZed;
    public static Image imgloglPlayx;
    public static int logoState;
    public static long tLastStatusZed;
    public static final String PIF_Splash = "splash.png";
    public static final int SPLASH_TIME = 3000;
    public static Image imgSplash;
    public static long tSplash;
    public static final byte MENU_MAIN = 0;
    public static final byte MENU_LANG = 1;
    public static final byte MENU_SOUND = 2;
    public static final byte MENU_HELP = 3;
    public static final byte MENU_ABOUT = 4;
    public static final byte MENU_MORE_GAME = 5;
    public static final byte MENU_OPTIONS = 6;
    public static final byte MENU_NEW_CONTINUE = 7;
    public static final byte MENU_SEL_CAR = 8;
    public static final byte MENU_SEL_COUNTRY = 9;
    public static final byte MENU_SEL_MODE = 10;
    public static final byte MENU_PAUSE = 11;
    public static final byte MENU_YES_NO = 12;
    public static final String PIF_MENU_TOP = "menutop.png";
    public static final String PIF_MENU_BOTTOM = "menudown.png";
    public static byte menuState;
    public static Image imgMenuTitleTop;
    public static Image imgMenuTitleBottom;
    private static boolean menuResourcesLoaded;
    public static int menuSel;
    public static int menuPaintStart;
    public static final byte BUTTON_NONE = 0;
    public static final byte BUTTON_OK = 1;
    public static final byte BUTTON_CANCEL = 2;
    public static final byte BUTTON_BACK = 4;
    public static final byte BUTTON_DELETE = 8;
    public static final byte BUTTON_YES = 16;
    public static final byte BUTTON_NO = 32;
    public static final byte BUTTON_EXIT = 64;
    public static byte buttons;
    public static boolean renderLeftButton;
    public static boolean renderRightButton;
    private int subMenuTitle;
    private short[] subMenuItems;
    private byte backToMenu;
    public static final short[] MENUS_MAIN_OPTIONS;
    public static final byte[] MENUS_MAIN_STATES;
    public static final short[] MENUS_NEW_CONTINUE;
    public static final short[] MENUS_SEL_CAR;
    public static final short[] MENUS_SEL_COUNTRY;
    public static final short[] MENUS_SEL_MODE;
    public static final short[] MENUS_PAUSE_MENU;
    public static final short[] MENUS_EXIT_CONFIRM_MENU;
    int aboutViewFirstLine;
    int aboutViewLines;
    char[] aboutText;
    short[][] aboutLineData;
    public static final int TOTAL_CAR_TYPES = 5;
    public static final String ANIM_CAR_NAME = "play";
    public static ZedAnimation animPlayerCar;
    public static ZedAnimation animEnemyCar;
    public static Image imgRoad0;
    public static Image imgRoad1;
    public static Image imgRoadBg;
    public static Image imgTree;
    public static ZedAnimation animSpeedBg;
    public static ZedAnimation anim321Go;
    public static final int ANIM_ACTOR_CAN = 0;
    public static final int ANIM_ACTOR_OIL = 1;
    public static final int ANIM_ACTOR_FIRE = 2;
    public static final int TOTAL_ACOTRS = 3;
    public static ZedAnimation[] animActors;
    public static Sim sim;
    private static boolean commonLevelResourcesLoaded;
    private static boolean specificLevelResourcesLoaded;
    public static final String RS_NAME = "CarCrash";
    public static final int RS_IDX_LANGUAGE = 0;
    public static final int RS_IDX_LEVEL = 1;
    public static final int RS_IDX_HS = 2;
    public static final int RS_IDX_HS_LENGTH;
    public static final int RS_LENGTH;
    static byte[] rsData;
    public static boolean enablePause;
    public static long processTime;
    public static boolean running;
    public static boolean paint;
    public static long timeInitSound;
    public static long timeStatistics;
    public static long lastTime;
    public static int timeAccum;
    public static byte alarmState;
    public static final byte ALARM_OFF = -1;
    public static final byte ALARM_WARNING = 0;
    public static final byte ALARM_ON = 1;
    public static final int ALARM_ON_ANIM_ID = 2;
    public static final int ALARM_OFF_FRAME_ID = 0;
    public static boolean alarmRenderAnim;
    public static boolean enemiesSearching;
    public static final int ALARM_DISCONNECT_TIME = 50;
    public static final int ALARM_RECTANGLE_SIZE = 1;
    public static final int[] ALARM_COLORS;
    public static boolean painting;
    public static final byte SCROLL_UP = 0;
    public static final byte SCROLL_DOWN = 1;
    public static final byte SCROLL_NONE = 2;

    public MainCanvas() {
        this.screenMode(true);
        this.loadCommonResources();
    }

    public void screenMode(boolean setFullScreen) {
        super.setFullScreenMode(setFullScreen);
    }

    public final void loadCommonResources() {
        if (font == null) {
            font = new PWPiFont(PWScreenToolbox.get().getResource(Font_GAMEFONT), 0, 0);
        }
    }

    public final void loadAndChangeLanguage(int langSelected, boolean saveData) {
        langId = langSelected;
        lang = MainCanvas.loadLangData(LANG_GAME_TEXTFILE_NAME + Mid.PW_LANG_TEXTFILE_NAME_EXT[langId] + ".dat");
        if (saveData) {
            MainCanvas.save();
        }
    }

    public static final String[] loadLangData(String resourceName) {
        byte[] content;
        String[] s = null;
        try {
            content = PWScreenToolbox.get().getResource(resourceName);
            Vector<String> temp = new Vector<String>();
            ByteArrayInputStream aux1 = new ByteArrayInputStream(content);
            ByteArrayOutputStream aux2 = new ByteArrayOutputStream();
            int actualByte = aux1.read();
            while (actualByte != -1) {
                aux2.write(actualByte);
                if (actualByte == 10) {
                    temp.addElement(new String(aux2.toByteArray(), "UTF-8").toUpperCase());
                    aux2.reset();
                }
                actualByte = aux1.read();
            }
            s = new String[temp.size()];
            for (int i = 0; i < temp.size(); ++i) {
                s[i] = (String)temp.elementAt(i);
                if (s[i].endsWith("\r\n")) {
                    s[i] = s[i].substring(0, s[i].length() - 2);
                }
                s[i] = Utils.replace(s[i], "^", "\n");
            }
        }
        catch (Exception e) {
            return null;
        }
        content = null;
        return s;
    }

    public void keyPressed(int keycode) {
        keyboard.keyPressed(keycode);
    }

    public void keyReleased(int key) {
        keyboard.keyReleased(key);
    }

    public final void processKeys() {
        if (keyboard == null) {
            return;
        }
        while (MainCanvas.keyboard.hasMoreKeys) {
            char c = keyboard.nextChar();
            switch (MainCanvas.keyboard.lastEvent) {
                case 1: {
                    this.processKeyReleased(c);
                    MainCanvas.keyboard.lastEvent = (byte)-100;
                    break;
                }
                case 0: {
                    this.processKeyPressed(c);
                    MainCanvas.keyboard.lastEvent = (byte)-100;
                }
            }
        }
    }

    public void processKeyPressed(char c) {
        switch (appState) {
            case 1: {
                if (c != '5' && c != '\u0000' && c != '\u0002') break;
                this.endSplash();
                break;
            }
            case 2: {
                this.processKeyPressedMenu(c);
                break;
            }
            case 4: {
                this.processKeyPressedMenu(c);
                break;
            }
            case 3: {
                sim.keyPress(c);
            }
        }
    }

    public void processKeyReleased(char c) {
        switch (appState) {
            case 3: {
                sim.keyRelease(c);
            }
        }
    }

    public void showLoadingBar() {
        if (loading) {
            ++loadingBarStep;
            painting = true;
            MainCanvas.getTime();
            this.repaint();
            this.serviceRepaintCanvas();
        }
    }

    public void paintLoading(Graphics g) {
        Utils.clearRegion(g, 0, 0, 320, 240, 0);
        boolean showLoadingBar = true;
        if (menuState == 10 && appState == 2) {
            int x = 10;
            int y = MainCanvas.font.fontHeight + 4;
            int h = 240 - MainCanvas.font.fontHeight * 2 - y;
            short[][] lineData = font.drawString(g, lang[this.tipTxtId] + Sim.gameTargetScore + lang[this.tipTxtId + 1], x, y, 320 - x - x, h, 6);
            font.drawString(g, lang[191], 160, y += (h - lineData.length * MainCanvas.font.fontHeight) / 2 - MainCanvas.font.fontHeight, 3);
            if (commonLevelResourcesLoaded && specificLevelResourcesLoaded) {
                showLoadingBar = false;
                if (processTime / 500L % 2L == 0L) {
                    font.drawString(g, lang[241], 160, 240 - MainCanvas.font.fontHeight, 3);
                }
            }
        }
        if (showLoadingBar) {
            g.setColor(-3355444);
            int y = 240 - MainCanvas.font.fontHeight;
            g.fillRect(0, y, 320, 1);
            g.setColor(-6951677);
            g.fillRect(0, y, loadingBarStep * 320 / loadingBarTotalSteps, 1);
        }
    }

    public void loadLogoIntroResources() {
        loading = true;
        loadingBarTotalSteps = 2;
        loadingBarStep = 0;
        this.showLoadingBar();
        imglogoZed = PWScreenToolbox.get().getImage("zed.png");
        this.showLoadingBar();
        imgloglPlayx = PWScreenToolbox.get().getImage("playx.png");
        loading = false;
    }

    public final void unloadLogoIntroResources() {
        imglogoZed = null;
        imgloglPlayx = null;
        Utils.cleanMemory();
    }

    public void paintIntroLogo(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 320, 240);
        switch (logoState) {
            case 1: {
                g.drawImage(imglogoZed, 160, 120, 3);
                break;
            }
            case 2: {
                g.drawImage(imgloglPlayx, 160, 120, 3);
            }
        }
    }

    public void changeLogoIntroStatus(int statusIncrement) {
        tLastStatusZed = processTime;
        logoState += statusIncrement;
    }

    public void processLogo() {
        switch (logoState) {
            case 0: {
                this.loadLogoIntroResources();
                this.changeLogoIntroStatus(1);
                break;
            }
            case 1: 
            case 2: {
                if (processTime - tLastStatusZed <= 2000L) break;
                this.changeLogoIntroStatus(1);
                break;
            }
            case 3: {
                loading = true;
                loadingBarTotalSteps = 5;
                loadingBarStep = 0;
                this.showLoadingBar();
                this.unloadLogoIntroResources();
                this.showLoadingBar();
                this.loadMenuResources(true);
                boolean rsResult = MainCanvas.load();
                if (langId != -1) {
                    this.loadAndChangeLanguage(langId, true);
                    this.startSplash();
                    this.goToMenu((byte)0);
                } else {
                    langId = 0;
                    this.loadAndChangeLanguage(langId, true);
                    this.goToMenu((byte)1);
                    appState = (byte)2;
                }
                loading = false;
            }
        }
    }

    private void loadSplashResources() {
        loading = true;
        loadingBarTotalSteps = 1;
        imgSplash = PWScreenToolbox.get().getImage(PIF_Splash);
        loading = false;
    }

    private void startSplash() {
        this.loadSplashResources();
        tSplash = processTime;
        appState = 1;
    }

    private void endSplash() {
        appState = (byte)2;
        this.goToMenu((byte)0);
    }

    private final void paintSplash(Graphics g) {
        g.drawImage(imgSplash, 0, 0, 20);
        if (processTime / 500L % 2L == 0L) {
            font.drawString(g, lang[241], 160, 240 - MainCanvas.font.fontHeight * 2, 33);
        }
    }

    public void loadMenuResources(boolean isLoading) {
        if (menuResourcesLoaded) {
            return;
        }
        if (!isLoading) {
            loading = true;
            loadingBarTotalSteps = 4;
            loadingBarStep = 0;
        }
        this.showLoadingBar();
        if (imgSplash == null) {
            imgSplash = PWScreenToolbox.get().getImage(PIF_Splash);
        }
        this.showLoadingBar();
        imgMenuTitleTop = PWScreenToolbox.get().getImage(PIF_MENU_TOP);
        this.showLoadingBar();
        imgMenuTitleBottom = PWScreenToolbox.get().getImage(PIF_MENU_BOTTOM);
        menuResourcesLoaded = true;
        if (!isLoading) {
            loading = false;
        }
        Utils.cleanMemory();
        keyboard.removeAlEvents();
    }

    public final void unloadMenuResources(boolean forceUnload) {
        imgSplash = null;
        imgMenuTitleTop = null;
        imgMenuTitleBottom = null;
        if (menuResourcesLoaded) {
            Utils.cleanMemory();
            menuResourcesLoaded = false;
        }
    }

    private void goToMenu(byte menu) {
        switch (menu) {
            case 1: {
                this.goToMenu(menu, (byte)1, -1, null, (byte)-1);
                break;
            }
            case 0: {
                int selId = 0;
                this.subMenuItems = MENUS_MAIN_OPTIONS;
                byte[] subMenuStates = MENUS_MAIN_STATES;
                if (!Mid.gmgmode.toUpperCase().equals("ON")) {
                    this.subMenuItems = new short[MENUS_MAIN_OPTIONS.length - 1];
                    subMenuStates = new byte[MENUS_MAIN_STATES.length - 1];
                    int idx = 0;
                    for (int i = 0; i < MENUS_MAIN_OPTIONS.length; ++i) {
                        if (MENUS_MAIN_OPTIONS[i] == 4) continue;
                        subMenuStates[idx] = MENUS_MAIN_STATES[i];
                        this.subMenuItems[idx++] = MENUS_MAIN_OPTIONS[i];
                    }
                }
                for (int i = 0; i < subMenuStates.length; ++i) {
                    if (subMenuStates[i] != menuState) continue;
                    selId = i;
                    break;
                }
                this.goToMenu(menu, (byte)1, -1, this.subMenuItems, (byte)-1);
                menuSel = selId;
                break;
            }
            case 7: {
                this.goToMenu(menu, (byte)5, 80, MENUS_NEW_CONTINUE, (byte)0);
                break;
            }
            case 8: {
                this.goToMenu(menu, (byte)5, 77, MENUS_SEL_CAR, (byte)0);
                break;
            }
            case 9: {
                this.goToMenu(menu, (byte)5, 74, MENUS_SEL_COUNTRY, (byte)8);
                break;
            }
            case 10: {
                this.goToMenu(menu, (byte)5, 245, MENUS_SEL_MODE, (byte)9);
                break;
            }
            case 6: {
                this.goToMenu(menu, (byte)5, 5, null, (byte)0);
                break;
            }
            case 11: {
                this.goToMenu(menu, (byte)1, 169, MENUS_PAUSE_MENU, (byte)-1);
                break;
            }
            case 3: {
                int height = 240 - (MainCanvas.font.fontHeight + MainCanvas.font.lineSpacing) * 2;
                this.aboutText = lang[48].toUpperCase().toCharArray();
                this.aboutLineData = font.getLineData(this.aboutText, 316);
                this.aboutViewFirstLine = 0;
                this.aboutViewLines = height / (MainCanvas.font.fontHeight + MainCanvas.font.lineSpacing);
                if (this.aboutViewLines > this.aboutLineData.length) {
                    this.aboutViewLines = this.aboutLineData.length;
                }
                this.goToMenu(menu, (byte)4, 3, null, (byte)0);
                break;
            }
            case 4: {
                int height = 240 - (MainCanvas.font.fontHeight + MainCanvas.font.lineSpacing) * 2;
                this.aboutText = lang[47].toUpperCase().toCharArray();
                this.aboutLineData = font.getLineData(this.aboutText, 316);
                Utils.findAndReplace(this.aboutText, 0, this.aboutText.length, "X.X.X", Mid.midletVersion);
                this.aboutViewFirstLine = 0;
                this.aboutViewLines = height / (MainCanvas.font.fontHeight + MainCanvas.font.lineSpacing);
                if (this.aboutViewLines > this.aboutLineData.length) {
                    this.aboutViewLines = this.aboutLineData.length;
                }
                this.goToMenu(menu, (byte)4, 3, null, (byte)0);
                break;
            }
            case 5: {
                int height = 240 - (MainCanvas.font.fontHeight + MainCanvas.font.lineSpacing) * 2;
                this.aboutText = lang[208].toUpperCase().toCharArray();
                this.aboutLineData = font.getLineData(this.aboutText, 316);
                this.aboutViewFirstLine = 0;
                this.aboutViewLines = height / (MainCanvas.font.fontHeight + MainCanvas.font.lineSpacing);
                if (this.aboutViewLines > this.aboutLineData.length) {
                    this.aboutViewLines = this.aboutLineData.length;
                }
                byte button = 5;
                this.goToMenu(menu, button, 3, null, (byte)0);
                break;
            }
            default: {
                System.out.println("NOT DEFINED goto menu! id:" + menu);
            }
        }
    }

    private void goToMenu(byte menu, byte button, int title, short[] items, byte backMenu) {
        menuState = menu;
        buttons = button;
        this.subMenuTitle = title;
        this.subMenuItems = items;
        this.backToMenu = backMenu;
        menuSel = 0;
        menuPaintStart = 0;
    }

    public static final void paintMenuBackground(Graphics g) {
        Utils.clearRegion(g, 0, 0, 320, 240, 0);
        if (loading) {
            return;
        }
        if (menuState == 0) {
            g.drawImage(imgSplash, 0, 0, 0);
        } else if (menuState != 11 && menuState != 12 && menuState != 4 && menuState != 3 && menuState != 5) {
            g.drawImage(imgMenuTitleTop, 0, 0, 0);
            g.drawImage(imgMenuTitleBottom, 0, 240, 36);
        }
    }

    private int getMeunAreaOffY(int itemNum) {
        int lineSpace = MainCanvas.font.lineSpacing + MainCanvas.font.fontHeight;
        int areaH = itemNum * lineSpace - MainCanvas.font.lineSpacing;
        if (imgMenuTitleTop == null) {
            return 30 + (185 - areaH) / 2;
        }
        int topImgH = imgMenuTitleTop.getHeight();
        return topImgH + (240 - topImgH - imgMenuTitleBottom.getHeight() - areaH) / 2;
    }

    public static void paintButtons(Graphics g, int buttons) {
        g.setClip(0, 0, 320, 240);
        renderLeftButton = true;
        renderRightButton = true;
        if ((buttons & 1) == 1 && renderLeftButton) {
            font.drawString(g, lang[137], 0, 240, 36);
        }
        if ((buttons & 0x10) == 16 && renderLeftButton) {
            font.drawString(g, lang[203], 0, 240, 36);
        }
        if ((buttons & 0x20) == 32 && renderRightButton) {
            font.drawString(g, lang[204], 320, 240, 40);
        }
        if ((buttons & 2) == 2 && renderRightButton) {
            font.drawString(g, lang[205], 320, 240, 40);
        }
        if ((buttons & 4) == 4 && renderRightButton) {
            font.drawString(g, lang[138], 320, 240, 40);
        }
    }

    private final void paintMenu(Graphics g) {
        MainCanvas.paintMenuBackground(g);
        g.setClip(0, 0, 320, 240);
        switch (menuState) {
            case 1: {
                this.paintLangSel(g);
                break;
            }
            case 0: {
                this.paintMainMenu(g);
                break;
            }
            case 10: {
                this.paintSelModeMenu(g);
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.paintSubMenu(g);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.paintAbout(g);
                break;
            }
            default: {
                System.out.println("todo menu paint.menuState : " + menuState);
            }
        }
        MainCanvas.paintButtons(g, buttons);
    }

    private void paintSubMenu(Graphics g) {
        font.drawString(g, lang[this.subMenuTitle], 1, MainCanvas.font.fontHeight, 318, 240, 17);
        int itemNum = this.subMenuItems.length;
        int lineSpace = MainCanvas.font.lineSpacing + MainCanvas.font.fontHeight;
        int y = this.getMeunAreaOffY(itemNum) + font.getFontHeight() / 2;
        for (int i = 0; i < itemNum; ++i) {
            int width = font.drawString(g, lang[this.subMenuItems[i]], 160, y, 3);
            if (i == menuSel) {
                if (this.isLocked()) {
                    Utils.drawArrow2(g, 160 - width / 2 - 2, y, false, processTime);
                    Utils.drawArrow2(g, 160 + width / 2 + 1, y, true, processTime);
                } else {
                    Utils.drawArrow(g, 160 - width / 2 - 2, y, false, processTime);
                    Utils.drawArrow(g, 160 + width / 2 + 1, y, true, processTime);
                }
            }
            y += lineSpace;
        }
    }

    boolean isLocked() {
        byte lock = rsData[1];
        switch (menuState) {
            case 9: {
                return lock / 3 < menuSel;
            }
            case 10: {
                return lock < Sim.getCountry() * 3 + menuSel;
            }
        }
        return false;
    }

    public void processKeyPressedMenu(char c) {
        if (loading) {
            this.processKeyLoading(c);
            return;
        }
        switch (menuState) {
            case 1: {
                this.processKeyLangSel(c);
                break;
            }
            case 0: {
                this.processKeyMain(c);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.processKeyAbout(c);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.processSubMenu(c);
                break;
            }
            default: {
                this.processSubMenu(c);
                System.out.println("todo menu keypress. menuState : " + menuState);
            }
        }
    }

    private void processSubMenu(char c) {
        block0 : switch (c) {
            case '\u0000': 
            case '\u0002': 
            case '5': {
                switch (menuState) {
                    case 9: {
                        this.keyOKSelCountry();
                        break block0;
                    }
                    case 7: {
                        this.keyOKNewContinue();
                        break block0;
                    }
                    case 10: {
                        this.keyOKSelMode();
                        break block0;
                    }
                    case 8: {
                        this.keyOKSelCar();
                        break block0;
                    }
                    case 11: {
                        this.keyOKPause();
                        break block0;
                    }
                    case 12: {
                        this.keyOKYesNO();
                        break block0;
                    }
                }
                System.out.println("TODO in processSubMenu. menuState:" + menuState);
                break;
            }
            case '\u0001': {
                if (this.backToMenu < 0) break;
                this.goToMenu(this.backToMenu);
                break;
            }
            case '\u0005': 
            case '2': {
                if (--menuSel >= 0) break;
                menuSel = 0;
                break;
            }
            case '\u0006': 
            case '8': {
                if (++menuSel < this.subMenuItems.length) break;
                menuSel = this.subMenuItems.length - 1;
            }
        }
        if (menuState == 9 || menuState == 10) {
            buttons = this.isLocked() ? (byte)(buttons & 0xFFFFFFFE) : (byte)(buttons | 1);
        }
    }

    private void paintLangSel(Graphics g) {
        font.drawString(g, lang[85], 160, MainCanvas.font.fontHeight, 17);
        int itemNum = Mid.PW_LANG_LANGUAGE.length;
        int y = this.getMeunAreaOffY(itemNum) + font.getFontHeight() / 2;
        for (int i = 0; i < itemNum; ++i) {
            int width = font.drawString(g, Mid.PW_LANG_LANGUAGE[i], 160, y, 3);
            if (langId == i) {
                Utils.drawArrow(g, 160 - width / 2 - 8, y, false, processTime);
                Utils.drawArrow(g, 160 + width / 2 + 8, y, true, processTime);
            }
            y += font.getFontHeight() + MainCanvas.font.lineSpacing;
        }
    }

    private void processKeyLangSel(char c) {
        switch (c) {
            case '\u0005': 
            case '2': {
                if (--langId >= 0) break;
                langId = 0;
                break;
            }
            case '\u0006': 
            case '8': {
                if (++langId < Mid.PW_LANG_IDS.length) break;
                langId = Mid.PW_LANG_IDS.length - 1;
                break;
            }
            case '\u0000': 
            case '\u0002': 
            case '5': {
                this.loadAndChangeLanguage(langId, true);
                if (this.backToMenu != -1) {
                    this.goToMenu(this.backToMenu);
                    menuSel = 1;
                    break;
                }
                this.startSplash();
                break;
            }
            case '\u0001': {
                if (this.backToMenu == -1) break;
                this.goToMenu(this.backToMenu);
                menuSel = 1;
            }
        }
    }

    private void paintMainMenu(Graphics g) {
        g.setColor(-16777216);
        int areaH = MainCanvas.font.fontHeight * 2;
        int y = 240 - MainCanvas.font.fontHeight * 2 - areaH;
        g.fillRect(0, y, 320, areaH);
        font.drawString(g, lang[this.subMenuItems[menuSel]], 160, y += MainCanvas.font.fontHeight, 3);
        if (menuSel > 0) {
            Utils.drawArrow(g, 6, y, true, processTime);
        }
        if (menuSel < this.subMenuItems.length - 1) {
            Utils.drawArrow(g, 314, y, false, processTime);
        }
    }

    private void processKeyMain(char c) {
        block0 : switch (c) {
            case '\u0003': 
            case '4': {
                if (--menuSel >= 0) break;
                menuSel = 0;
                break;
            }
            case '\u0004': 
            case '6': {
                if (++menuSel < this.subMenuItems.length) break;
                menuSel = this.subMenuItems.length - 1;
                break;
            }
            case '\u0000': 
            case '\u0002': 
            case '5': {
                short selItem = this.subMenuItems[menuSel];
                switch (selItem) {
                    case 0: {
                        if (MainCanvas.haveGameData()) {
                            this.goToMenu((byte)7);
                            break block0;
                        }
                        this.goToMenu((byte)8);
                        break block0;
                    }
                    case 85: {
                        this.goToMenu((byte)1, (byte)5, -1, null, (byte)0);
                        break block0;
                    }
                    case 2: {
                        this.goToMenu((byte)3);
                        break block0;
                    }
                    case 4: {
                        this.goToMenu((byte)5);
                        break block0;
                    }
                    case 3: {
                        this.goToMenu((byte)4);
                        break block0;
                    }
                    case 6: {
                        this.goToMenu((byte)12, (byte)5, 73, MENUS_EXIT_CONFIRM_MENU, (byte)0);
                        break block0;
                    }
                }
                System.out.println(lang[selItem] + " not implement yet!");
                break;
            }
        }
    }

    private void keyOKNewContinue() {
        if (menuSel == 1) {
            this.goToMenu((byte)12, (byte)5, 72, MENUS_EXIT_CONFIRM_MENU, (byte)7);
        } else {
            this.goToMenu((byte)8);
        }
    }

    private void keyOKSelCar() {
        Sim.setCarType(menuSel);
        this.goToMenu((byte)9);
    }

    private void keyOKSelCountry() {
        if (!this.isLocked()) {
            Sim.setCountry(menuSel);
            this.goToMenu((byte)10);
        }
    }

    private void paintSelModeMenu(Graphics g) {
        int y = imgMenuTitleTop.getHeight() + 2;
        font.drawString(g, lang[25] + MainCanvas.getHighScore(Sim.getCountry(), menuSel), 1, y, 20);
        y = 240 - imgMenuTitleBottom.getHeight() - 1;
        font.drawString(g, lang[19] + Sim.TARGET_SCORE[Sim.getCountry()][menuSel], 320, y, 40);
    }

    private void keyOKSelMode() {
        if (!this.isLocked()) {
            Sim.setMode(menuSel);
            this.tipTxtId = Sim.getMode() == 2 ? 192 : (Utils.getRandNumber(0, 1) == 0 ? 196 : 194);
            this.startTheGame();
        }
    }

    private void keyOKPause() {
        switch (MENUS_PAUSE_MENU[menuSel]) {
            case 168: {
                appState = (byte)3;
                break;
            }
            case 261: {
                this.goToMenu((byte)12, (byte)5, 262, MENUS_EXIT_CONFIRM_MENU, (byte)11);
                break;
            }
            case 2: {
                int height = 240 - (MainCanvas.font.fontHeight + MainCanvas.font.lineSpacing) * 2;
                this.aboutText = lang[48].toUpperCase().toCharArray();
                this.aboutLineData = font.getLineData(this.aboutText, 316);
                this.aboutViewFirstLine = 0;
                this.aboutViewLines = height / (MainCanvas.font.fontHeight + MainCanvas.font.lineSpacing);
                if (this.aboutViewLines > this.aboutLineData.length) {
                    this.aboutViewLines = this.aboutLineData.length;
                }
                this.goToMenu((byte)3, (byte)4, 3, null, (byte)11);
                break;
            }
            case 246: {
                this.goToMenu((byte)12, (byte)5, 247, MENUS_EXIT_CONFIRM_MENU, (byte)11);
            }
        }
        Sim.startTime = processTime;
    }

    private void keyOKYesNO() {
        if (MENUS_EXIT_CONFIRM_MENU[menuSel] == 203) {
            switch (this.backToMenu) {
                case 0: {
                    running = false;
                    break;
                }
                case 11: {
                    if (this.subMenuTitle == 262) {
                        sim.restartRace();
                        appState = (byte)3;
                        break;
                    }
                    sim.setNextMenuState((byte)0);
                    sim.setGameState(6, processTime);
                    appState = (byte)3;
                    break;
                }
                case 7: {
                    MainCanvas.initGameData();
                    this.goToMenu((byte)0);
                    menuSel = 0;
                }
            }
        } else if (MENUS_EXIT_CONFIRM_MENU[menuSel] == 204) {
            this.goToMenu(this.backToMenu);
        }
    }

    private void paintAbout(Graphics g) {
        int y = (240 - this.aboutViewLines * (MainCanvas.font.fontHeight + MainCanvas.font.lineSpacing)) / 2;
        font.drawFastString(g, this.aboutText, this.aboutLineData, 2, y, 316, 17, this.aboutViewFirstLine, this.aboutViewLines);
        if (this.aboutViewFirstLine != 0) {
            Utils.drawUpDownArrow(g, 156, 234, true, 0L);
        }
        if (this.aboutViewFirstLine + this.aboutViewLines < this.aboutLineData.length) {
            Utils.drawUpDownArrow(g, 164, 234, false, 0L);
        }
    }

    private void processKeyAbout(char c) {
        switch (c) {
            case '\u0001': {
                this.goToMenu(this.backToMenu);
                break;
            }
            case '\u0005': 
            case '2': {
                if (--this.aboutViewFirstLine >= 0) break;
                this.aboutViewFirstLine = 0;
                break;
            }
            case '\u0000': 
            case '\u0002': 
            case '5': {
                if (menuState != 5) break;
                try {
                    this.platformRequest();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case '\u0006': 
            case '8': {
                if (++this.aboutViewFirstLine <= this.aboutLineData.length - this.aboutViewLines) break;
                this.aboutViewFirstLine = this.aboutLineData.length - this.aboutViewLines;
            }
        }
    }

    private void startTheGame() {
        this.launchGame();
    }

    private final void launchGame() {
        loading = true;
        this.unloadMenuResources(false);
        this.loadGameResources();
        this.resetGame();
    }

    void processKeyLoading(char c) {
        if (c == '\u0002' || c == '\u0000' || c == '5') {
            appState = (byte)3;
            sim.initSim();
            loading = false;
        }
    }

    private void resetGame() {
        keyboard.removeAlEvents();
        enablePause = true;
    }

    public final void loadGameResources() {
        Utils.cleanMemory();
        loadingBarTotalSteps = 12;
        loadingBarStep = 0;
        this.showLoadingBar();
        this.loadCommonLevelResources();
        this.loadSpecificLevelResources();
        Utils.cleanMemory();
    }

    private final void loadCommonLevelResources() {
        if (!commonLevelResourcesLoaded) {
            animPlayerCar = new ZedAnimation(PWScreenToolbox.get().getResource(ANIM_CAR_NAME + Sim.getCarType() + ".ajo"), 0, true);
            this.showLoadingBar();
            int enemyCarType = Utils.getRandNumber(0, 3);
            if (enemyCarType >= Sim.getCarType()) {
                ++enemyCarType;
            }
            animEnemyCar = new ZedAnimation(PWScreenToolbox.get().getResource(ANIM_CAR_NAME + enemyCarType + ".ajo"), 0, true);
            this.showLoadingBar();
            imgRoad0 = PWScreenToolbox.get().getImage("t0.png");
            this.showLoadingBar();
            imgRoad1 = PWScreenToolbox.get().getImage("t1.png");
            this.showLoadingBar();
            imgRoadBg = PWScreenToolbox.get().getImage("bg.png");
            animSpeedBg = new ZedAnimation(PWScreenToolbox.get().getResource("speed.ajo"), 0, true);
            this.showLoadingBar();
            anim321Go = new ZedAnimation(PWScreenToolbox.get().getResource("number.ajo"), 0, true);
            sim = new Sim();
            this.showLoadingBar();
            commonLevelResourcesLoaded = true;
            Utils.cleanMemory();
        }
    }

    private final void loadSpecificLevelResources() {
        if (!specificLevelResourcesLoaded) {
            animActors = new ZedAnimation[3];
            MainCanvas.animActors[0] = new ZedAnimation(PWScreenToolbox.get().getResource("can.ajo"), 0, true);
            this.showLoadingBar();
            MainCanvas.animActors[1] = new ZedAnimation(PWScreenToolbox.get().getResource("oil.ajo"), 0, true);
            this.showLoadingBar();
            MainCanvas.animActors[2] = new ZedAnimation(PWScreenToolbox.get().getResource("fire.ajo"), 0, true);
            this.showLoadingBar();
            imgTree = PWScreenToolbox.get().getImage("tree" + Sim.getCountry() % 2 + Image_SUFIX);
            this.showLoadingBar();
            specificLevelResourcesLoaded = true;
        }
    }

    public static void unloadGameResources(boolean forceUnload) {
        MainCanvas.unloadSpecificLevelResources(forceUnload);
        MainCanvas.unloadCommonLevelResources(forceUnload);
        Utils.cleanMemory();
    }

    private static final void unloadSpecificLevelResources(boolean forceUnload) {
        if (specificLevelResourcesLoaded) {
            Sim.freeBackBuffer();
            for (int i = 0; i < 3; ++i) {
                MainCanvas.animActors[i] = null;
            }
            animActors = null;
            imgTree = null;
            Utils.cleanMemory();
            specificLevelResourcesLoaded = false;
        }
    }

    private static final void unloadCommonLevelResources(boolean forceUnload) {
        if (commonLevelResourcesLoaded) {
            animPlayerCar = null;
            animEnemyCar = null;
            imgRoad0 = null;
            imgRoad1 = null;
            imgRoadBg = null;
            sim = null;
            Utils.cleanMemory();
            commonLevelResourcesLoaded = false;
        }
    }

    public static void save() {
        MainCanvas.rsData[0] = (byte)langId;
        Mid.store(RS_NAME, rsData);
    }

    public static boolean load() {
        DataInputStream dis = Mid.load(RS_NAME);
        if (dis != null) {
            try {
                dis.read(rsData, 0, rsData.length);
                langId = rsData[0];
            }
            catch (IOException e) {
                MainCanvas.initRS();
                return false;
            }
            return true;
        }
        MainCanvas.initRS();
        return false;
    }

    public static int getHighScore(int country, int mode) {
        int startIdx = country * 3 * 3 + mode * 3 + 2;
        return ((rsData[startIdx] & 0xFF) << 16) + ((rsData[startIdx + 1] & 0xFF) << 8) + (rsData[startIdx + 2] & 0xFF);
    }

    public static void setHighScore(int country, int mode, int score) {
        int startIdx = country * 3 * 3 + mode * 3 + 2;
        MainCanvas.rsData[startIdx++] = (byte)((score & 0xFF0000) >> 16);
        MainCanvas.rsData[startIdx++] = (byte)((score & 0xFF00) >> 8);
        MainCanvas.rsData[startIdx++] = (byte)(score & 0xFF);
    }

    public static void initRS() {
        langId = -1;
        MainCanvas.rsData[0] = (byte)langId;
        for (int i = 1; i < rsData.length; ++i) {
            MainCanvas.rsData[i] = 0;
        }
        MainCanvas.save();
    }

    public static void initGameData() {
        for (int i = 1; i < rsData.length; ++i) {
            MainCanvas.rsData[i] = 0;
        }
        MainCanvas.save();
    }

    public static boolean haveGameData() {
        return rsData[1] > 0;
    }

    public void pauseGame() {
        appState = (byte)4;
        Sim.clearKey();
        this.goToMenu((byte)11);
    }

    public void showNotify() {
        if (!loading) {
            keyboard.removeAlEvents();
            if (appState == 3 && sim != null) {
                this.pauseGame();
            }
        }
    }

    public void hideNotify() {
        if (!loading) {
            keyboard.removeAlEvents();
            if (appState == 3 && sim != null) {
                this.pauseGame();
            }
        }
    }

    public void paint(Graphics g) {
        if (!running) {
            Utils.clearRegion(g, 0, 0, 320, 240, -16777216);
            painting = false;
            return;
        }
        if (loading) {
            this.paintLoading(g);
            if (loadingBarStep >= loadingBarTotalSteps) {
                loading = false;
            }
            painting = false;
            return;
        }
        switch (appState) {
            case 0: {
                this.paintIntroLogo(g);
                break;
            }
            case 1: {
                this.paintSplash(g);
                break;
            }
            case 2: {
                this.paintMenu(g);
                break;
            }
            case 4: {
                this.paintMenu(g);
                break;
            }
            case 3: {
                sim.paint(g);
            }
        }
        painting = false;
    }

    public void process() {
        processTime += 40L;
        this.processKeys();
        switch (appState) {
            case 0: {
                this.processLogo();
                break;
            }
            case 1: {
                if (processTime - tSplash <= 3000L) break;
                this.endSplash();
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                boolean notLastUnlockRace;
                boolean isPlaying = sim.process(processTime);
                if (isPlaying) break;
                byte nextMenuState = sim.getNextMenuState();
                loading = true;
                loadingBarTotalSteps = 7;
                loadingBarStep = 0;
                this.showLoadingBar();
                int nextSelItem = 0;
                boolean bl = notLastUnlockRace = Sim.getCountry() * 3 + Sim.getMode() + 1 == rsData[1];
                if (nextMenuState == 9) {
                    nextSelItem = sim.isUnlock() ? rsData[1] / 3 : Sim.getCountry();
                } else if (nextMenuState == 10) {
                    nextSelItem = sim.isUnlock() ? rsData[1] % 3 : Sim.getMode();
                }
                MainCanvas.unloadGameResources(false);
                this.showLoadingBar();
                this.loadMenuResources(true);
                this.showLoadingBar();
                appState = (byte)2;
                loading = false;
                this.goToMenu(nextMenuState);
                menuSel = nextSelItem;
            }
        }
    }

    private void menuExit() {
    }

    public void serviceRepaintCanvas() {
        while (painting) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public final void run() {
        keyboard.removeAlEvents();
        lastTime = System.currentTimeMillis();
        timeAccum = 0;
        running = true;
        while (running) {
            paint = false;
            for (timeAccum = (int)((long)timeAccum + MainCanvas.getTime()); timeAccum >= 40 && running; timeAccum -= 40) {
                paint = true;
                this.process();
            }
            if (paint) {
                painting = true;
                this.repaint();
                this.serviceRepaintCanvas();
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.exitApp();
    }

    private void exitApp() {
        keyboard.removeAlEvents();
        MainCanvas.unloadGameResources(true);
        this.unloadMenuResources(true);
    }

    public static final long getTime() {
        long currentTime = System.currentTimeMillis();
        long ret = currentTime - lastTime;
        lastTime = currentTime;
        timeStatistics += ret;
        if (ret > 5000L) {
            Mid.canvas.showNotify();
        }
        return ret < 160L ? ret : 160L;
    }

    final void platformRequest() throws Exception {
        Mid.midlet.platformRequest(Mid.gmgurl);
        running = false;
        Mid.midlet.destroyApp(true);
        Mid.midlet.notifyDestroyed();
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    static {
        langId = -1;
        keyboard = new PWAdvancedKeyboard("A^B^C^D^E^F^G^H^I^J^K^L^M^N^O^P^Q^R^S^T^U^V^W^X^Y^Z");
        loadingBarStep = 0;
        loadingBarTotalSteps = 0;
        loading = false;
        logoState = 0;
        imgSplash = null;
        menuState = 0;
        menuSel = 0;
        menuPaintStart = 0;
        buttons = 0;
        MENUS_MAIN_OPTIONS = new short[]{0, 85, 4, 2, 3, 6};
        MENUS_MAIN_STATES = new byte[]{8, -1, 5, 3, 4, 12};
        MENUS_NEW_CONTINUE = new short[]{35, 34};
        MENUS_SEL_CAR = new short[]{103, 104, 105, 106, 107};
        MENUS_SEL_COUNTRY = new short[]{109, 114, 115, 111, 113, 116};
        MENUS_SEL_MODE = new short[]{127, 128, 129};
        MENUS_PAUSE_MENU = new short[]{168, 261, 2, 246};
        MENUS_EXIT_CONFIRM_MENU = new short[]{203, 204};
        RS_IDX_HS_LENGTH = MENUS_SEL_COUNTRY.length * 3 * 3;
        RS_LENGTH = 2 + RS_IDX_HS_LENGTH;
        rsData = new byte[RS_LENGTH];
        processTime = 0L;
        running = false;
        paint = false;
        timeInitSound = 0L;
        timeStatistics = 0L;
        alarmRenderAnim = true;
        enemiesSearching = false;
        ALARM_COLORS = new int[]{-256, -65536};
        painting = false;
    }
}

