/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.util;

public class PWPointerEvents {
    public static final long TIME_REPEAT_POINTER = 1000L;
    public static final byte NO_POINTER = -1;
    public static final byte EVENT_POINTER_PRESSED = 0;
    public static final byte EVENT_POINTER_RELEASED = 1;
    public static final byte EVENT_POINTER_DRAGGED = 2;
    public byte lastEvent;
    public int lastPointerEventX;
    public int lastPointerEventY;
    public boolean acceptPointerEventPressed = true;
    public boolean acceptPointerEventReleased = true;
    public boolean acceptPointerEventDragged = true;
    public boolean acceptPointerEventTyped = true;
    public boolean hasMorePointerEvents = false;
    private short pointerRead;
    private short pointerWrite;
    private byte[] evtArray_type;
    private int[] evtArray_pointerEvent;

    public PWPointerEvents() {
        this.init(200);
    }

    public synchronized void removeAllEvents() {
        this.pointerRead = this.pointerWrite;
        this.hasMorePointerEvents = false;
    }

    private void init(int bufferSize) {
        this.pointerWrite = 0;
        this.pointerRead = 0;
        this.evtArray_type = new byte[bufferSize];
        this.evtArray_pointerEvent = new int[bufferSize * 2];
        this.hasMorePointerEvents = false;
    }

    public int nextEvent() {
        if (!this.hasMorePointerEvents) {
            return -1;
        }
        this.lastEvent = this.evtArray_type[this.pointerRead];
        this.lastPointerEventX = this.evtArray_pointerEvent[this.pointerRead << 1];
        this.lastPointerEventY = this.evtArray_pointerEvent[(this.pointerRead << 1) + 1];
        this.elementReaded();
        return this.lastEvent;
    }

    public synchronized void pointerEventPressed(int x, int y) {
        if (!this.acceptPointerEventPressed) {
            return;
        }
        this.add((byte)0, x, y);
    }

    public synchronized void pointerEventReleased(int x, int y) {
        if (!this.acceptPointerEventReleased) {
            return;
        }
        this.add((byte)1, x, y);
    }

    public synchronized void pointerEventDragged(int x, int y) {
        if (!this.acceptPointerEventDragged) {
            return;
        }
        this.add((byte)2, x, y);
    }

    public void add(byte event, int x, int y) {
        this.evtArray_type[this.pointerWrite] = event;
        this.evtArray_pointerEvent[this.pointerWrite << 1] = x;
        this.evtArray_pointerEvent[(this.pointerWrite << 1) + 1] = y;
        this.pointerWrite = (short)(this.pointerWrite + 1);
        if (this.pointerWrite == this.evtArray_type.length) {
            this.pointerWrite = 0;
        }
        this.hasMorePointerEvents = true;
    }

    private void elementReaded() {
        this.pointerRead = (short)(this.pointerRead + 1);
        if (this.pointerRead == this.evtArray_type.length) {
            this.pointerRead = 0;
        }
        this.hasMorePointerEvents = this.pointerRead != this.pointerWrite;
    }
}

