/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicRacing
extends GameLogic {
    protected static final byte CAR_SIZE = 7;
    protected static final int LIFE_MAX = 3;
    protected static final byte CAR_APPEAR = 11;
    protected static final byte SCORE_INC = 10;
    protected static final int SCORE_UP = 500;
    protected static final int[] CAR_FIGURE = new int[]{162, 171, 172, 173, 182, 191, 193};
    protected final byte CAR_POS_1;
    protected final byte CAR_POS_2 = (byte)4;
    protected byte bCurUpdate = 1;
    protected byte bCurPos = 0;
    protected byte bCarPos;
    protected byte bCarOpCount = 0;
    protected byte bSideWall;
    protected boolean figureIsHot = false;
    protected boolean lastFigureHotState = false;
    private static int _opcarBrick = 0;

    public GameLogicRacing() {
        super(7, 3);
        this.CAR_POS_1 = 1;
        GameFieldItem.TAIN_HIGHLIGHT_1_TARIN = false;
    }

    protected void load() throws Exception {
        super.load();
        this.bCarPos = GUtillIo.readByte();
        this.bSideWall = GUtillIo.readByte();
        this.bCurUpdate = GUtillIo.readByte();
        this.bCarOpCount = GUtillIo.readByte();
        this.bShowCollision = GUtillIo.readByte();
        this.bCurPos = GUtillIo.readByte();
    }

    protected void save() throws Exception {
        super.save();
        GUtillIo.writeByte(this.bCarPos);
        GUtillIo.writeByte(this.bSideWall);
        GUtillIo.writeByte(this.bCurUpdate);
        GUtillIo.writeByte(this.bCarOpCount);
        GUtillIo.writeByte(this.bShowCollision);
        GUtillIo.writeByte(this.bCurPos);
    }

    protected void updateFigure() {
        boolean lifedecr = false;
        GameFieldItem figure = new GameFieldItem();
        for (int i = 0; i < 7; ++i) {
            this.figure_pos[i] = CAR_FIGURE[i] + this.bCarPos;
            figure.setData(this.figure_elem[i]);
            figure.setIsHotBrick(this.figureIsHot);
            this.figure_elem[i] = figure.data();
            if (GameField.getBrickType(this.figure_pos[i]) != 3) continue;
            lifedecr = true;
        }
        figure = null;
        this.lastFigureHotState = this.figureIsHot;
        if (lifedecr) {
            this.figureIsHot = false;
            this.showCollision();
        }
    }

    protected void placePlayer() {
        this.active = false;
        GameField.clear();
        this.bCurUpdate = (byte)6;
        this.bCarOpCount = 0;
        this.bCarPos = (byte)((byte)GUtillMath.rnd(2) == 0 ? 1 : 4);
        for (int i = 0; i < this.figure_elem.length; ++i) {
            this.figure_elem[i] = GameFieldItem.playerBrickData();
        }
        this.updateFigure();
    }

    private static int opcarBrick() {
        if (_opcarBrick == 0) {
            GameFieldItem item = new GameFieldItem();
            item.setBrickType(3);
            _opcarBrick = item.data();
            Object var0 = null;
        }
        return _opcarBrick;
    }

    protected void placeOpCar(int shift, int pos) {
        if (this.bCarOpCount < 2) {
            this.bCarOpCount = (byte)(this.bCarOpCount + 1);
        }
        for (int i = 0; i < 7; ++i) {
            GameField.getItem(CAR_FIGURE[i] + pos - shift).setData(GameLogicRacing.opcarBrick());
        }
    }

    public void keyClicked(int key) {
        if (key == 7 && !this.active) {
            this.active = true;
        } else if (!this.active || this.bShowCollision == 0) {
            // empty if block
        }
    }

    public boolean updateEvent() {
        if (this.active && this.bShowCollision == 0) {
            if (E.kStates[6]) {
                if (this.bCarPos != 1) {
                    this.bCarPos = 1;
                    this.updateFigure();
                }
            } else if (E.kStates[8] && this.bCarPos != 4) {
                this.bCarPos = (byte)4;
                this.updateFigure();
            }
            if (E.kStates[7] || E.kStates[4]) {
                this.figureIsHot = true;
                this.updateState();
            } else {
                this.figureIsHot = false;
            }
            if (this.figureIsHot != this.lastFigureHotState) {
                this.updateFigure();
            }
        }
        return false;
    }

    public void updateLevel(int level) {
        this.placePlayer();
        this.bSideWall = 1;
        this.bCurUpdate = (byte)6;
        this.bCarOpCount = 0;
        this.bShowCollision = 0;
    }

    protected boolean in_car(int i) {
        for (int j = 0; j < CAR_FIGURE.length; ++j) {
            if (i != CAR_FIGURE[j] + this.bCarPos) continue;
            return true;
        }
        return false;
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.bShowCollision != 0) {
                if (this.bShowCollision == 4) {
                    this.bShowCollision = 0;
                    this.lifeDecr();
                } else {
                    this.bShowCollision = (byte)(this.bShowCollision + 1);
                }
            } else {
                for (int i = 199; i >= 0; --i) {
                    if (GameField.getBrickType(i) != 3 && GameField.getBrickType(i) != 1 && GameField.getBrickType(i) != 2) continue;
                    GameField.getItem(i + 10).setData(GameField.getItem(i).data());
                    GameField.setBrickType(i, 0);
                    GameField.getItem(i).setMatrixBrickIndex(-1);
                }
                if (this.bSideWall != 3) {
                    GameField.getItem(0).setData(GameFieldItem.fieldBrickData());
                    GameField.getItem(9).setData(GameFieldItem.fieldBrickData());
                    this.bSideWall = (byte)(this.bSideWall + 1);
                } else {
                    this.bSideWall = 1;
                }
                if (this.bCurUpdate < 11) {
                    if (this.bCurUpdate == 1) {
                        this.bCurPos = (byte)((byte)GUtillMath.rnd(2) == 0 ? 1 : 4);
                    }
                    if (this.bCurUpdate <= 4) {
                        this.placeOpCar(160 + (4 - this.bCurUpdate) * 10, this.bCurPos);
                    }
                    this.bCurUpdate = (byte)(this.bCurUpdate + 1);
                } else if (this.bCurUpdate == 11) {
                    this.bCurUpdate = 1;
                }
                if (this.bCurUpdate == 9 && this.bCarOpCount == 2) {
                    this.score += 10;
                    this.CurrentScore += 10;
                }
                if (this.checkCollision()) {
                    this.CurrentScore = 0;
                    this.showCollision();
                }
                if (this.CurrentScore == 500) {
                    this.score += 200;
                    this.CurrentScore = 0;
                    this.gameup = true;
                    this.placePlayer();
                }
            }
        }
    }

    protected final void showCollision() {
        int i = 0;
        for (i = 0; i < 7; ++i) {
            GameField.getItem(CAR_FIGURE[i] + this.bCarPos).setData(0);
            this.figure_pos[i] = -1;
            this.figure_elem[i] = 0;
        }
        this.collisionAtPos(160 + this.bCarPos);
    }

    protected boolean checkCollision() {
        int posNext = CAR_FIGURE[0] + this.bCarPos - 10;
        return GameField.getBrickType(posNext) == 3;
    }
}

