/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicShooter
extends GameLogic {
    protected static final byte BULLET_MAX = 40;
    protected static final byte BULLET_LAST = 39;
    protected static int SCORE_UP_MIN = 160;
    protected static int SCORE_UP_INC = 60;
    protected static final int PLAYER_SIZE = 1;
    protected static final int LIFE_MAX = 3;
    protected static final byte SCORE_INC = 1;
    protected static final byte STEP_INC = 3;
    protected static final byte STEP_RES = 4;
    protected final int[] iArrBulletPos = new int[40];
    protected final byte[] bArrLine = new byte[10];
    protected byte bRandomFrom;
    protected byte bRandomTo;
    protected short sScoreUp = 0;
    protected short sLast;

    public GameLogicShooter() {
        super(1, 3);
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            this.bArrLine[i] = i;
        }
        this.bRandomFrom = (byte)5;
        this.bRandomTo = (byte)10;
        this.firstKeydownDelay = this.repeatKeydownDelay;
    }

    public void save() throws Exception {
        super.save();
        GUtillIo.writeShort(this.sLast);
        GUtillIo.writeShort(this.sScoreUp);
        GUtillIo.writeArray(this.bArrLine);
        GUtillIo.writeArray(this.iArrBulletPos);
    }

    public void load() throws Exception {
        super.load();
        this.sLast = GUtillIo.readShort();
        this.sScoreUp = GUtillIo.readShort();
        GUtillIo.read(this.bArrLine);
        GUtillIo.read(this.iArrBulletPos);
        int rowBottom = this.sLast + 10;
        GameFieldItem tempItem = new GameFieldItem();
        for (int i = 0; i < 10; ++i) {
            tempItem.setData(0);
            tempItem.setBrickType(1);
            tempItem.updateState();
            GameField.getItem(rowBottom + i).setData(tempItem.data());
        }
        tempItem = null;
    }

    public final void updateLevel(int level) {
        this.sLast = (short)(200 - level * 10);
        this.sScoreUp = (short)(SCORE_UP_MIN + SCORE_UP_INC * (level - 1));
        this.placePlayer();
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            for (int i = this.sLast - 1; i >= 0; --i) {
                if (GameField.getBrickType(i) != 1) continue;
                GameField.setBrickType(i, 0);
                int next = i + GameField.step[3];
                if (next >= this.sLast) {
                    this.lifeDecr();
                    continue;
                }
                GameField.setBrickType(next, 1);
            }
            if (!this.gameover) {
                if (this.CurrentScore >= this.sScoreUp) {
                    this.CurrentScore = 0;
                    this.gameup = true;
                    this.placePlayer();
                } else {
                    this.placeLine();
                }
            }
        }
    }

    public void keyClicked(int key) {
        if (this.canUpdate()) {
            if (key == 7 && !this.active) {
                this.active = true;
                int blink_pos = 0;
                blink_pos = this.figure_pos[0] + GameField.step[2];
                GameField.setBrickType(blink_pos, 0);
            }
            if (this.active) {
                byte[] border = GameField.border(this.figure_pos[0]);
                int blink_pos = 0;
                if (key == 6) {
                    if (!GUtillArray.contains(border, (byte)1)) {
                        blink_pos = this.figure_pos[0] + GameField.step[2];
                        this.figure_pos[0] = this.figure_pos[0] - 1;
                        if (!this.active) {
                            GameField.setBrickType(blink_pos, 0);
                            blink_pos = this.figure_pos[0] + GameField.step[2];
                            GameField.setBrickType(blink_pos, 5);
                        }
                    }
                } else if (key == 8 && !GUtillArray.contains(border, (byte)2)) {
                    blink_pos = this.figure_pos[0] + GameField.step[2];
                    this.figure_pos[0] = this.figure_pos[0] + 1;
                    if (!this.active) {
                        GameField.setBrickType(blink_pos, 0);
                        blink_pos = this.figure_pos[0] + GameField.step[2];
                        GameField.setBrickType(blink_pos, 5);
                    }
                }
            }
        }
    }

    public boolean updateEvent() {
        if (this.canUpdate() && this.active) {
            int j = 0;
            for (int i = 0; i < 40; ++i) {
                int next = this.iArrBulletPos[i];
                for (j = 0; j <= 3 && next >= 0; next += GameField.step[2], ++j) {
                    if (GameField.getBrickType(next) != 1) continue;
                    GameField.setBrickType(next, 0);
                    GameField.getItem(next).setIsHotBrick(true);
                    if (next > 9) {
                        GameField.getItem(next - 10).setIsHotOnceBrick(true);
                    }
                    ++this.score;
                    ++this.CurrentScore;
                    break;
                }
                GameField.setBrickType(this.iArrBulletPos[i], 0);
                if (j == 4) {
                    this.iArrBulletPos[i] = next;
                    GameField.setBrickType(this.iArrBulletPos[i], 5);
                    continue;
                }
                this.iArrBulletPos[i] = -1;
                GUtillArray.moveOut(this.iArrBulletPos, i, 39);
            }
            int pos = this.figure_pos[0] + GameField.step[2];
            GUtillArray.insert(this.iArrBulletPos, pos, 0);
            GameField.setBrickType(pos, 5);
        }
        return false;
    }

    private final void placeLine() {
        int count = GUtillMath.rnd_to(this.bRandomFrom, this.bRandomTo);
        for (int i = 0; i < 10; ++i) {
            int index = GUtillMath.rnd(10);
            int index2 = GUtillMath.rnd(10);
            byte temp = this.bArrLine[index];
            this.bArrLine[index] = this.bArrLine[index2];
            this.bArrLine[index2] = temp;
        }
        GameFieldItem tempItem = new GameFieldItem();
        for (int i = 0; i < count; ++i) {
            tempItem.setData(0);
            tempItem.setBrickType(1);
            tempItem.updateState();
            GameField.getItem(this.bArrLine[i]).setData(tempItem.data());
        }
        tempItem = null;
    }

    protected void placePlayer() {
        GameField.clear();
        this.active = false;
        GUtillArray.fill(this.iArrBulletPos, -1);
        int rowBottom = this.sLast + 10;
        for (int i = 0; i < 10; ++i) {
            GameField.setBrickType(rowBottom + i, 1);
        }
        GameFieldItem tempItem = new GameFieldItem();
        tempItem.setBrickType(2);
        tempItem.setIsHotBrick(true);
        tempItem.setIsBlinking(true);
        this.figure_pos[0] = this.sLast + GUtillMath.rnd(10);
        this.figure_elem[0] = tempItem.data();
    }
}

